<?php

namespace PHPMaker2024\fibre;

// Page object
$ProductCartBSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { product_cart_b: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fproduct_cart_bsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fproduct_cart_bsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["po_id", [ew.Validators.integer], fields.po_id.isInvalid],
            ["location", [], fields.location.isInvalid],
            ["company_id", [ew.Validators.integer], fields.company_id.isInvalid],
            ["partner_order_no", [], fields.partner_order_no.isInvalid],
            ["partner_id", [], fields.partner_id.isInvalid],
            ["partner_rid", [], fields.partner_rid.isInvalid],
            ["partner_code", [], fields.partner_code.isInvalid],
            ["grp", [], fields.grp.isInvalid],
            ["s_grp", [], fields.s_grp.isInvalid],
            ["product", [], fields.product.isInvalid],
            ["rid_2", [], fields.rid_2.isInvalid],
            ["rid", [], fields.rid.isInvalid],
            ["packing_type", [], fields.packing_type.isInvalid],
            ["batch_no", [], fields.batch_no.isInvalid],
            ["shape", [], fields.shape.isInvalid],
            ["product_type", [], fields.product_type.isInvalid],
            ["unit", [], fields.unit.isInvalid],
            ["w", [], fields.w.isInvalid],
            ["w_cm", [ew.Validators.float], fields.w_cm.isInvalid],
            ["l", [], fields.l.isInvalid],
            ["l_cm", [ew.Validators.float], fields.l_cm.isInvalid],
            ["h", [], fields.h.isInvalid],
            ["h_cm", [ew.Validators.float], fields.h_cm.isInvalid],
            ["partner_size", [], fields.partner_size.isInvalid],
            ["size", [], fields.size.isInvalid],
            ["sqm", [ew.Validators.float], fields.sqm.isInvalid],
            ["sqm_a", [ew.Validators.float], fields.sqm_a.isInvalid],
            ["quantity", [ew.Validators.float], fields.quantity.isInvalid],
            ["image", [], fields.image.isInvalid],
            ["price", [ew.Validators.float], fields.price.isInvalid],
            ["currency", [], fields.currency.isInvalid],
            ["cbm", [ew.Validators.float], fields.cbm.isInvalid],
            ["additional_discount", [ew.Validators.float], fields.additional_discount.isInvalid],
            ["buyer_uid", [], fields.buyer_uid.isInvalid],
            ["buyer_loc", [], fields.buyer_loc.isInvalid],
            ["label", [], fields.label.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["d_remarks", [], fields.d_remarks.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "po_id": <?= $Page->po_id->toClientList($Page) ?>,
            "location": <?= $Page->location->toClientList($Page) ?>,
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
            "partner_id": <?= $Page->partner_id->toClientList($Page) ?>,
            "partner_rid": <?= $Page->partner_rid->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "rid_2": <?= $Page->rid_2->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
            "batch_no": <?= $Page->batch_no->toClientList($Page) ?>,
            "shape": <?= $Page->shape->toClientList($Page) ?>,
            "product_type": <?= $Page->product_type->toClientList($Page) ?>,
            "unit": <?= $Page->unit->toClientList($Page) ?>,
            "currency": <?= $Page->currency->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fproduct_cart_bsearch" id="fproduct_cart_bsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="product_cart_b">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="product_cart_b" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->po_id->Visible) { // po_id ?>
    <div id="r_po_id" class="row"<?= $Page->po_id->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_po_id"><?= $Page->po_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_po_id" id="z_po_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_po_id" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->po_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_po_id" class="ew-auto-suggest">
    <input type="<?= $Page->po_id->getInputTextType() ?>" class="form-control" name="sv_x_po_id" id="sv_x_po_id" value="<?= RemoveHtml($Page->po_id->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->po_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->po_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po_id->formatPattern()) ?>"<?= $Page->po_id->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="product_cart_b" data-field="x_po_id" data-input="sv_x_po_id" data-value-separator="<?= $Page->po_id->displayValueSeparatorAttribute() ?>" name="x_po_id" id="x_po_id" value="<?= HtmlEncode($Page->po_id->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->po_id->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fproduct_cart_bsearch", function() {
    fproduct_cart_bsearch.createAutoSuggest(Object.assign({"id":"x_po_id","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->po_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.product_cart_b.fields.po_id.autoSuggestOptions));
});
</script>
<?= $Page->po_id->Lookup->getParamTag($Page, "p_x_po_id") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
    <div id="r_location" class="row"<?= $Page->location->rowAttributes() ?>>
        <label for="x_location" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_location"><?= $Page->location->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_location" id="z_location" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->location->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_location" class="ew-search-field ew-search-field-single">
    <select
        id="x_location"
        name="x_location"
        class="form-select ew-select<?= $Page->location->isInvalidClass() ?>"
        <?php if (!$Page->location->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_bsearch_x_location"
        <?php } ?>
        data-table="product_cart_b"
        data-field="x_location"
        data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>"
        <?= $Page->location->editAttributes() ?>>
        <?= $Page->location->selectOptionListHtml("x_location") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->location->getErrorMessage(false) ?></div>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
<?php if (!$Page->location->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_bsearch", function() {
    var options = { name: "x_location", selectId: "fproduct_cart_bsearch_x_location" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_bsearch.lists.location?.lookupOptions.length) {
        options.data = { id: "x_location", form: "fproduct_cart_bsearch" };
    } else {
        options.ajax = { id: "x_location", form: "fproduct_cart_bsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b.fields.location.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
    <div id="r_company_id" class="row"<?= $Page->company_id->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_company_id"><?= $Page->company_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_company_id" id="z_company_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->company_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_company_id" class="ew-search-field">
<?php
if (IsRTL()) {
    $Page->company_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_company_id" class="ew-auto-suggest">
    <input type="<?= $Page->company_id->getInputTextType() ?>" class="form-control" name="sv_x_company_id" id="sv_x_company_id" value="<?= RemoveHtml($Page->company_id->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->company_id->formatPattern()) ?>"<?= $Page->company_id->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="product_cart_b" data-field="x_company_id" data-input="sv_x_company_id" data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>" name="x_company_id" id="x_company_id" value="<?= HtmlEncode($Page->company_id->AdvancedSearch->SearchValue) ?>" data-ew-action="update-options"></selection-list>
<div class="invalid-feedback"><?= $Page->company_id->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fproduct_cart_bsearch", function() {
    fproduct_cart_bsearch.createAutoSuggest(Object.assign({"id":"x_company_id","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->company_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.product_cart_b.fields.company_id.autoSuggestOptions));
});
</script>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
</span>
                    <span class="ew-search-cond">
<div class="form-check"><input class="form-check-input" type="radio" id="v_company_id_1" name="v_company_id" value="AND"<?= ($Page->company_id->AdvancedSearch->SearchCondition != "OR") ? " checked" : "" ?>><label class="form-check-label" for="v_company_id_1"><?= $Language->phrase("AND") ?></label></div>
<div class="form-check"><input class="form-check-input" type="radio" id="v_company_id_2" name="v_company_id" value="OR"<?= ($Page->company_id->AdvancedSearch->SearchCondition == "OR") ? " checked" : "" ?>><label class="form-check-label" for="v_company_id_2"><?= $Language->phrase("OR") ?></label></div></span>
                    <span class="ew-search-operator2">
<?= $Language->phrase("=") ?>
<input type="hidden" name="w_company_id" id="w_company_id" value="=">
</span>
                    <span id="el2_product_cart_b_company_id" class="ew-search-field2">
<?php
if (IsRTL()) {
    $Page->company_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_y_company_id" class="ew-auto-suggest">
    <input type="<?= $Page->company_id->getInputTextType() ?>" class="form-control" name="sv_y_company_id" id="sv_y_company_id" value="<?= RemoveHtml($Page->company_id->EditValue2) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->company_id->formatPattern()) ?>"<?= $Page->company_id->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="product_cart_b" data-field="x_company_id" data-input="sv_y_company_id" data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>" name="y_company_id" id="y_company_id" value="<?= HtmlEncode($Page->company_id->AdvancedSearch->SearchValue2) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->company_id->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fproduct_cart_bsearch", function() {
    fproduct_cart_bsearch.createAutoSuggest(Object.assign({"id":"y_company_id","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->company_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.product_cart_b.fields.company_id.autoSuggestOptions));
});
</script>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_y_company_id") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->partner_order_no->Visible) { // partner_order_no ?>
    <div id="r_partner_order_no" class="row"<?= $Page->partner_order_no->rowAttributes() ?>>
        <label for="x_partner_order_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_partner_order_no"><?= $Page->partner_order_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_partner_order_no" id="z_partner_order_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->partner_order_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_partner_order_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->partner_order_no->getInputTextType() ?>" name="x_partner_order_no" id="x_partner_order_no" data-table="product_cart_b" data-field="x_partner_order_no" value="<?= $Page->partner_order_no->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->partner_order_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->partner_order_no->formatPattern()) ?>"<?= $Page->partner_order_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->partner_order_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->partner_id->Visible) { // partner_id ?>
    <div id="r_partner_id" class="row"<?= $Page->partner_id->rowAttributes() ?>>
        <label for="x_partner_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_partner_id"><?= $Page->partner_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_partner_id" id="z_partner_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->partner_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_partner_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_partner_id"
        name="x_partner_id"
        class="form-select ew-select<?= $Page->partner_id->isInvalidClass() ?>"
        <?php if (!$Page->partner_id->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_bsearch_x_partner_id"
        <?php } ?>
        data-table="product_cart_b"
        data-field="x_partner_id"
        data-value-separator="<?= $Page->partner_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->partner_id->getPlaceHolder()) ?>"
        <?= $Page->partner_id->editAttributes() ?>>
        <?= $Page->partner_id->selectOptionListHtml("x_partner_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->partner_id->getErrorMessage(false) ?></div>
<?= $Page->partner_id->Lookup->getParamTag($Page, "p_x_partner_id") ?>
<?php if (!$Page->partner_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_bsearch", function() {
    var options = { name: "x_partner_id", selectId: "fproduct_cart_bsearch_x_partner_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_bsearch.lists.partner_id?.lookupOptions.length) {
        options.data = { id: "x_partner_id", form: "fproduct_cart_bsearch" };
    } else {
        options.ajax = { id: "x_partner_id", form: "fproduct_cart_bsearch", limit: 20 };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b.fields.partner_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->partner_rid->Visible) { // partner_rid ?>
    <div id="r_partner_rid" class="row"<?= $Page->partner_rid->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_partner_rid"><?= $Page->partner_rid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_partner_rid" id="z_partner_rid" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->partner_rid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_partner_rid" class="ew-search-field">
    <select
        id="x_partner_rid"
        name="x_partner_rid"
        class="form-control ew-select<?= $Page->partner_rid->isInvalidClass() ?>"
        data-select2-id="fproduct_cart_bsearch_x_partner_rid"
        data-table="product_cart_b"
        data-field="x_partner_rid"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->partner_rid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->partner_rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->partner_rid->getPlaceHolder()) ?>"
        <?= $Page->partner_rid->editAttributes() ?>>
        <?= $Page->partner_rid->selectOptionListHtml("x_partner_rid") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->partner_rid->getErrorMessage(false) ?></div>
<?= $Page->partner_rid->Lookup->getParamTag($Page, "p_x_partner_rid") ?>
<script>
loadjs.ready("fproduct_cart_bsearch", function() {
    var options = { name: "x_partner_rid", selectId: "fproduct_cart_bsearch_x_partner_rid" };
    if (fproduct_cart_bsearch.lists.partner_rid?.lookupOptions.length) {
        options.data = { id: "x_partner_rid", form: "fproduct_cart_bsearch" };
    } else {
        options.ajax = { id: "x_partner_rid", form: "fproduct_cart_bsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.product_cart_b.fields.partner_rid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                    <span class="ew-search-cond">
<div class="form-check"><input class="form-check-input" type="radio" id="v_partner_rid_1" name="v_partner_rid" value="AND"<?= ($Page->partner_rid->AdvancedSearch->SearchCondition != "OR") ? " checked" : "" ?>><label class="form-check-label" for="v_partner_rid_1"><?= $Language->phrase("AND") ?></label></div>
<div class="form-check"><input class="form-check-input" type="radio" id="v_partner_rid_2" name="v_partner_rid" value="OR"<?= ($Page->partner_rid->AdvancedSearch->SearchCondition == "OR") ? " checked" : "" ?>><label class="form-check-label" for="v_partner_rid_2"><?= $Language->phrase("OR") ?></label></div></span>
                    <span class="ew-search-operator2">
<?= $Language->phrase("=") ?>
<input type="hidden" name="w_partner_rid" id="w_partner_rid" value="=">
</span>
                    <span id="el2_product_cart_b_partner_rid" class="ew-search-field2">
    <select
        id="y_partner_rid"
        name="y_partner_rid"
        class="form-control ew-select<?= $Page->partner_rid->isInvalidClass() ?>"
        data-select2-id="fproduct_cart_bsearch_y_partner_rid"
        data-table="product_cart_b"
        data-field="x_partner_rid"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->partner_rid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->partner_rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->partner_rid->getPlaceHolder()) ?>"
        <?= $Page->partner_rid->editAttributes() ?>>
        <?= $Page->partner_rid->selectOptionListHtml("y_partner_rid") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->partner_rid->getErrorMessage(false) ?></div>
<?= $Page->partner_rid->Lookup->getParamTag($Page, "p_y_partner_rid") ?>
<script>
loadjs.ready("fproduct_cart_bsearch", function() {
    var options = { name: "y_partner_rid", selectId: "fproduct_cart_bsearch_y_partner_rid" };
    if (fproduct_cart_bsearch.lists.partner_rid?.lookupOptions.length) {
        options.data = { id: "y_partner_rid", form: "fproduct_cart_bsearch" };
    } else {
        options.ajax = { id: "y_partner_rid", form: "fproduct_cart_bsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.product_cart_b.fields.partner_rid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->partner_code->Visible) { // partner_code ?>
    <div id="r_partner_code" class="row"<?= $Page->partner_code->rowAttributes() ?>>
        <label for="x_partner_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_partner_code"><?= $Page->partner_code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_partner_code" id="z_partner_code" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->partner_code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_partner_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->partner_code->getInputTextType() ?>" name="x_partner_code" id="x_partner_code" data-table="product_cart_b" data-field="x_partner_code" value="<?= $Page->partner_code->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->partner_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->partner_code->formatPattern()) ?>"<?= $Page->partner_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->partner_code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp" class="row"<?= $Page->grp->rowAttributes() ?>>
        <label for="x_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_grp"><?= $Page->grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_bsearch_x_grp"
        <?php } ?>
        data-table="product_cart_b"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_bsearch", function() {
    var options = { name: "x_grp", selectId: "fproduct_cart_bsearch_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_bsearch.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fproduct_cart_bsearch" };
    } else {
        options.ajax = { id: "x_grp", form: "fproduct_cart_bsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp" class="row"<?= $Page->s_grp->rowAttributes() ?>>
        <label for="x_s_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_s_grp"><?= $Page->s_grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_s_grp" id="z_s_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->s_grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_s_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_bsearch_x_s_grp"
        <?php } ?>
        data-table="product_cart_b"
        data-field="x_s_grp"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage(false) ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_bsearch", function() {
    var options = { name: "x_s_grp", selectId: "fproduct_cart_bsearch_x_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_bsearch.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "fproduct_cart_bsearch" };
    } else {
        options.ajax = { id: "x_s_grp", form: "fproduct_cart_bsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product" class="row"<?= $Page->product->rowAttributes() ?>>
        <label for="x_product" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_product"><?= $Page->product->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product" id="z_product" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_product" class="ew-search-field ew-search-field-single">
    <select
        id="x_product"
        name="x_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_bsearch_x_product"
        <?php } ?>
        data-table="product_cart_b"
        data-field="x_product"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage(false) ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_bsearch", function() {
    var options = { name: "x_product", selectId: "fproduct_cart_bsearch_x_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_bsearch.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "fproduct_cart_bsearch" };
    } else {
        options.ajax = { id: "x_product", form: "fproduct_cart_bsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->rid_2->Visible) { // rid_2 ?>
    <div id="r_rid_2" class="row"<?= $Page->rid_2->rowAttributes() ?>>
        <label for="x_rid_2" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_rid_2"><?= $Page->rid_2->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_rid_2" id="z_rid_2" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rid_2->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_rid_2" class="ew-search-field ew-search-field-single">
    <select
        id="x_rid_2"
        name="x_rid_2"
        class="form-select ew-select<?= $Page->rid_2->isInvalidClass() ?>"
        <?php if (!$Page->rid_2->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_bsearch_x_rid_2"
        <?php } ?>
        data-table="product_cart_b"
        data-field="x_rid_2"
        data-value-separator="<?= $Page->rid_2->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid_2->getPlaceHolder()) ?>"
        <?= $Page->rid_2->editAttributes() ?>>
        <?= $Page->rid_2->selectOptionListHtml("x_rid_2") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->rid_2->getErrorMessage(false) ?></div>
<?= $Page->rid_2->Lookup->getParamTag($Page, "p_x_rid_2") ?>
<?php if (!$Page->rid_2->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_bsearch", function() {
    var options = { name: "x_rid_2", selectId: "fproduct_cart_bsearch_x_rid_2" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_bsearch.lists.rid_2?.lookupOptions.length) {
        options.data = { id: "x_rid_2", form: "fproduct_cart_bsearch" };
    } else {
        options.ajax = { id: "x_rid_2", form: "fproduct_cart_bsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b.fields.rid_2.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
    <div id="r_rid" class="row"<?= $Page->rid->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_rid"><?= $Page->rid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_rid" id="z_rid" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_rid" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->rid->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_rid" class="ew-auto-suggest">
    <input type="<?= $Page->rid->getInputTextType() ?>" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?= RemoveHtml($Page->rid->EditValue) ?>" autocomplete="off" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rid->formatPattern()) ?>"<?= $Page->rid->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="product_cart_b" data-field="x_rid" data-input="sv_x_rid" data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?= HtmlEncode($Page->rid->AdvancedSearch->SearchValue) ?>" data-ew-action="update-options"></selection-list>
<div class="invalid-feedback"><?= $Page->rid->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fproduct_cart_bsearch", function() {
    fproduct_cart_bsearch.createAutoSuggest(Object.assign({"id":"x_rid","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->rid->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.product_cart_b.fields.rid.autoSuggestOptions));
});
</script>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type" class="row"<?= $Page->packing_type->rowAttributes() ?>>
        <label for="x_packing_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_packing_type"><?= $Page->packing_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packing_type" id="z_packing_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packing_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_packing_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_packing_type"
        name="x_packing_type"
        class="form-select ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_type->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_bsearch_x_packing_type"
        <?php } ?>
        data-table="product_cart_b"
        data-field="x_packing_type"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage(false) ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x_packing_type") ?>
<?php if (!$Page->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_bsearch", function() {
    var options = { name: "x_packing_type", selectId: "fproduct_cart_bsearch_x_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_bsearch.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x_packing_type", form: "fproduct_cart_bsearch" };
    } else {
        options.ajax = { id: "x_packing_type", form: "fproduct_cart_bsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
    <div id="r_batch_no" class="row"<?= $Page->batch_no->rowAttributes() ?>>
        <label for="x_batch_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_batch_no"><?= $Page->batch_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_batch_no" id="z_batch_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->batch_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_batch_no" class="ew-search-field ew-search-field-single">
    <select
        id="x_batch_no"
        name="x_batch_no"
        class="form-control ew-select<?= $Page->batch_no->isInvalidClass() ?>"
        data-select2-id="fproduct_cart_bsearch_x_batch_no"
        data-table="product_cart_b"
        data-field="x_batch_no"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->batch_no->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->batch_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>"
        <?= $Page->batch_no->editAttributes() ?>>
        <?= $Page->batch_no->selectOptionListHtml("x_batch_no") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->batch_no->getErrorMessage(false) ?></div>
<?= $Page->batch_no->Lookup->getParamTag($Page, "p_x_batch_no") ?>
<script>
loadjs.ready("fproduct_cart_bsearch", function() {
    var options = { name: "x_batch_no", selectId: "fproduct_cart_bsearch_x_batch_no" };
    if (fproduct_cart_bsearch.lists.batch_no?.lookupOptions.length) {
        options.data = { id: "x_batch_no", form: "fproduct_cart_bsearch" };
    } else {
        options.ajax = { id: "x_batch_no", form: "fproduct_cart_bsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.product_cart_b.fields.batch_no.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->shape->Visible) { // shape ?>
    <div id="r_shape" class="row"<?= $Page->shape->rowAttributes() ?>>
        <label for="x_shape" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_shape"><?= $Page->shape->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_shape" id="z_shape" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->shape->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_shape" class="ew-search-field ew-search-field-single">
    <select
        id="x_shape"
        name="x_shape"
        class="form-select ew-select<?= $Page->shape->isInvalidClass() ?>"
        <?php if (!$Page->shape->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_bsearch_x_shape"
        <?php } ?>
        data-table="product_cart_b"
        data-field="x_shape"
        data-value-separator="<?= $Page->shape->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->shape->getPlaceHolder()) ?>"
        <?= $Page->shape->editAttributes() ?>>
        <?= $Page->shape->selectOptionListHtml("x_shape") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->shape->getErrorMessage(false) ?></div>
<?= $Page->shape->Lookup->getParamTag($Page, "p_x_shape") ?>
<?php if (!$Page->shape->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_bsearch", function() {
    var options = { name: "x_shape", selectId: "fproduct_cart_bsearch_x_shape" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_bsearch.lists.shape?.lookupOptions.length) {
        options.data = { id: "x_shape", form: "fproduct_cart_bsearch" };
    } else {
        options.ajax = { id: "x_shape", form: "fproduct_cart_bsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b.fields.shape.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product_type->Visible) { // product_type ?>
    <div id="r_product_type" class="row"<?= $Page->product_type->rowAttributes() ?>>
        <label for="x_product_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_product_type"><?= $Page->product_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product_type" id="z_product_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_product_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_product_type"
        name="x_product_type"
        class="form-select ew-select<?= $Page->product_type->isInvalidClass() ?>"
        <?php if (!$Page->product_type->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_bsearch_x_product_type"
        <?php } ?>
        data-table="product_cart_b"
        data-field="x_product_type"
        data-value-separator="<?= $Page->product_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product_type->getPlaceHolder()) ?>"
        <?= $Page->product_type->editAttributes() ?>>
        <?= $Page->product_type->selectOptionListHtml("x_product_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product_type->getErrorMessage(false) ?></div>
<?= $Page->product_type->Lookup->getParamTag($Page, "p_x_product_type") ?>
<?php if (!$Page->product_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_bsearch", function() {
    var options = { name: "x_product_type", selectId: "fproduct_cart_bsearch_x_product_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_bsearch.lists.product_type?.lookupOptions.length) {
        options.data = { id: "x_product_type", form: "fproduct_cart_bsearch" };
    } else {
        options.ajax = { id: "x_product_type", form: "fproduct_cart_bsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b.fields.product_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->unit->Visible) { // unit ?>
    <div id="r_unit" class="row"<?= $Page->unit->rowAttributes() ?>>
        <label for="x_unit" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_unit"><?= $Page->unit->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_unit" id="z_unit" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->unit->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_unit" class="ew-search-field ew-search-field-single">
    <select
        id="x_unit"
        name="x_unit"
        class="form-select ew-select<?= $Page->unit->isInvalidClass() ?>"
        <?php if (!$Page->unit->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_bsearch_x_unit"
        <?php } ?>
        data-table="product_cart_b"
        data-field="x_unit"
        data-value-separator="<?= $Page->unit->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->unit->getPlaceHolder()) ?>"
        <?= $Page->unit->editAttributes() ?>>
        <?= $Page->unit->selectOptionListHtml("x_unit") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->unit->getErrorMessage(false) ?></div>
<?php if (!$Page->unit->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_bsearch", function() {
    var options = { name: "x_unit", selectId: "fproduct_cart_bsearch_x_unit" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_bsearch.lists.unit?.lookupOptions.length) {
        options.data = { id: "x_unit", form: "fproduct_cart_bsearch" };
    } else {
        options.ajax = { id: "x_unit", form: "fproduct_cart_bsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b.fields.unit.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->w->Visible) { // w ?>
    <div id="r_w" class="row"<?= $Page->w->rowAttributes() ?>>
        <label for="x_w" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_w"><?= $Page->w->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_w" id="z_w" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->w->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_w" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->w->getInputTextType() ?>" name="x_w" id="x_w" data-table="product_cart_b" data-field="x_w" value="<?= $Page->w->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->w->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->w->formatPattern()) ?>"<?= $Page->w->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->w->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->w_cm->Visible) { // w_cm ?>
    <div id="r_w_cm" class="row"<?= $Page->w_cm->rowAttributes() ?>>
        <label for="x_w_cm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_w_cm"><?= $Page->w_cm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_w_cm" id="z_w_cm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->w_cm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_w_cm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->w_cm->getInputTextType() ?>" name="x_w_cm" id="x_w_cm" data-table="product_cart_b" data-field="x_w_cm" value="<?= $Page->w_cm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->w_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->w_cm->formatPattern()) ?>"<?= $Page->w_cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->w_cm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->l->Visible) { // l ?>
    <div id="r_l" class="row"<?= $Page->l->rowAttributes() ?>>
        <label for="x_l" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_l"><?= $Page->l->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_l" id="z_l" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->l->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_l" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->l->getInputTextType() ?>" name="x_l" id="x_l" data-table="product_cart_b" data-field="x_l" value="<?= $Page->l->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->l->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->l->formatPattern()) ?>"<?= $Page->l->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->l->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->l_cm->Visible) { // l_cm ?>
    <div id="r_l_cm" class="row"<?= $Page->l_cm->rowAttributes() ?>>
        <label for="x_l_cm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_l_cm"><?= $Page->l_cm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_l_cm" id="z_l_cm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->l_cm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_l_cm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->l_cm->getInputTextType() ?>" name="x_l_cm" id="x_l_cm" data-table="product_cart_b" data-field="x_l_cm" value="<?= $Page->l_cm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->l_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->l_cm->formatPattern()) ?>"<?= $Page->l_cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->l_cm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->h->Visible) { // h ?>
    <div id="r_h" class="row"<?= $Page->h->rowAttributes() ?>>
        <label for="x_h" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_h"><?= $Page->h->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_h" id="z_h" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->h->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_h" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->h->getInputTextType() ?>" name="x_h" id="x_h" data-table="product_cart_b" data-field="x_h" value="<?= $Page->h->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->h->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->h->formatPattern()) ?>"<?= $Page->h->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->h->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->h_cm->Visible) { // h_cm ?>
    <div id="r_h_cm" class="row"<?= $Page->h_cm->rowAttributes() ?>>
        <label for="x_h_cm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_h_cm"><?= $Page->h_cm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_h_cm" id="z_h_cm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->h_cm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_h_cm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->h_cm->getInputTextType() ?>" name="x_h_cm" id="x_h_cm" data-table="product_cart_b" data-field="x_h_cm" value="<?= $Page->h_cm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->h_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->h_cm->formatPattern()) ?>"<?= $Page->h_cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->h_cm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->partner_size->Visible) { // partner_size ?>
    <div id="r_partner_size" class="row"<?= $Page->partner_size->rowAttributes() ?>>
        <label for="x_partner_size" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_partner_size"><?= $Page->partner_size->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_partner_size" id="z_partner_size" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->partner_size->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_partner_size" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->partner_size->getInputTextType() ?>" name="x_partner_size" id="x_partner_size" data-table="product_cart_b" data-field="x_partner_size" value="<?= $Page->partner_size->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->partner_size->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->partner_size->formatPattern()) ?>"<?= $Page->partner_size->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->partner_size->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->size->Visible) { // size ?>
    <div id="r_size" class="row"<?= $Page->size->rowAttributes() ?>>
        <label for="x_size" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_size"><?= $Page->size->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_size" id="z_size" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->size->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_size" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->size->getInputTextType() ?>" name="x_size" id="x_size" data-table="product_cart_b" data-field="x_size" value="<?= $Page->size->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->size->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size->formatPattern()) ?>"<?= $Page->size->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->size->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
    <div id="r_sqm" class="row"<?= $Page->sqm->rowAttributes() ?>>
        <label for="x_sqm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_sqm"><?= $Page->sqm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_sqm" id="z_sqm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sqm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_sqm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sqm->getInputTextType() ?>" name="x_sqm" id="x_sqm" data-table="product_cart_b" data-field="x_sqm" value="<?= $Page->sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm->formatPattern()) ?>"<?= $Page->sqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sqm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sqm_a->Visible) { // sqm_a ?>
    <div id="r_sqm_a" class="row"<?= $Page->sqm_a->rowAttributes() ?>>
        <label for="x_sqm_a" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_sqm_a"><?= $Page->sqm_a->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_sqm_a" id="z_sqm_a" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sqm_a->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_sqm_a" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sqm_a->getInputTextType() ?>" name="x_sqm_a" id="x_sqm_a" data-table="product_cart_b" data-field="x_sqm_a" value="<?= $Page->sqm_a->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sqm_a->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm_a->formatPattern()) ?>"<?= $Page->sqm_a->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sqm_a->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity" class="row"<?= $Page->quantity->rowAttributes() ?>>
        <label for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_quantity"><?= $Page->quantity->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_quantity" id="z_quantity" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->quantity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->quantity->getInputTextType() ?>" name="x_quantity" id="x_quantity" data-table="product_cart_b" data-field="x_quantity" value="<?= $Page->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity->formatPattern()) ?>"<?= $Page->quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->quantity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->image->Visible) { // image ?>
    <div id="r_image" class="row"<?= $Page->image->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_image"><?= $Page->image->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_image" id="z_image" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->image->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_image" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->image->getInputTextType() ?>" name="x_image" id="x_image" data-table="product_cart_b" data-field="x_image" value="<?= $Page->image->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->image->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->image->formatPattern()) ?>"<?= $Page->image->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->image->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->price->Visible) { // price ?>
    <div id="r_price" class="row"<?= $Page->price->rowAttributes() ?>>
        <label for="x_price" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_price"><?= $Page->price->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_price" id="z_price" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->price->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_price" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->price->getInputTextType() ?>" name="x_price" id="x_price" data-table="product_cart_b" data-field="x_price" value="<?= $Page->price->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->price->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->price->formatPattern()) ?>"<?= $Page->price->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->price->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->currency->Visible) { // currency ?>
    <div id="r_currency" class="row"<?= $Page->currency->rowAttributes() ?>>
        <label for="x_currency" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_currency"><?= $Page->currency->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_currency" id="z_currency" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->currency->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_currency" class="ew-search-field ew-search-field-single">
    <select
        id="x_currency"
        name="x_currency"
        class="form-select ew-select<?= $Page->currency->isInvalidClass() ?>"
        <?php if (!$Page->currency->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_bsearch_x_currency"
        <?php } ?>
        data-table="product_cart_b"
        data-field="x_currency"
        data-value-separator="<?= $Page->currency->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->currency->getPlaceHolder()) ?>"
        <?= $Page->currency->editAttributes() ?>>
        <?= $Page->currency->selectOptionListHtml("x_currency") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->currency->getErrorMessage(false) ?></div>
<?= $Page->currency->Lookup->getParamTag($Page, "p_x_currency") ?>
<?php if (!$Page->currency->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_bsearch", function() {
    var options = { name: "x_currency", selectId: "fproduct_cart_bsearch_x_currency" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_bsearch.lists.currency?.lookupOptions.length) {
        options.data = { id: "x_currency", form: "fproduct_cart_bsearch" };
    } else {
        options.ajax = { id: "x_currency", form: "fproduct_cart_bsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b.fields.currency.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->cbm->Visible) { // cbm ?>
    <div id="r_cbm" class="row"<?= $Page->cbm->rowAttributes() ?>>
        <label for="x_cbm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_cbm"><?= $Page->cbm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_cbm" id="z_cbm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->cbm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_cbm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->cbm->getInputTextType() ?>" name="x_cbm" id="x_cbm" data-table="product_cart_b" data-field="x_cbm" value="<?= $Page->cbm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->cbm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cbm->formatPattern()) ?>"<?= $Page->cbm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->cbm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_uid->Visible) { // buyer_uid ?>
    <div id="r_buyer_uid" class="row"<?= $Page->buyer_uid->rowAttributes() ?>>
        <label for="x_buyer_uid" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_buyer_uid"><?= $Page->buyer_uid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_buyer_uid" id="z_buyer_uid" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_uid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_buyer_uid" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_uid->getInputTextType() ?>" name="x_buyer_uid" id="x_buyer_uid" data-table="product_cart_b" data-field="x_buyer_uid" value="<?= $Page->buyer_uid->EditValue ?>" size="35" maxlength="65535" placeholder="<?= HtmlEncode($Page->buyer_uid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_uid->formatPattern()) ?>"<?= $Page->buyer_uid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_uid->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_loc->Visible) { // buyer_loc ?>
    <div id="r_buyer_loc" class="row"<?= $Page->buyer_loc->rowAttributes() ?>>
        <label for="x_buyer_loc" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_buyer_loc"><?= $Page->buyer_loc->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_buyer_loc" id="z_buyer_loc" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_loc->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_buyer_loc" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_loc->getInputTextType() ?>" name="x_buyer_loc" id="x_buyer_loc" data-table="product_cart_b" data-field="x_buyer_loc" value="<?= $Page->buyer_loc->EditValue ?>" size="35" maxlength="250" placeholder="<?= HtmlEncode($Page->buyer_loc->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_loc->formatPattern()) ?>"<?= $Page->buyer_loc->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_loc->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->label->Visible) { // label ?>
    <div id="r_label" class="row"<?= $Page->label->rowAttributes() ?>>
        <label for="x_label" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_label"><?= $Page->label->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_label" id="z_label" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->label->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_label" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->label->getInputTextType() ?>" name="x_label" id="x_label" data-table="product_cart_b" data-field="x_label" value="<?= $Page->label->EditValue ?>" maxlength="96" placeholder="<?= HtmlEncode($Page->label->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->label->formatPattern()) ?>"<?= $Page->label->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->label->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="product_cart_b" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" maxlength="250" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_remarks->Visible) { // d_remarks ?>
    <div id="r_d_remarks" class="row"<?= $Page->d_remarks->rowAttributes() ?>>
        <label for="x_d_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_d_remarks"><?= $Page->d_remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_remarks" id="z_d_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_d_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_remarks->getInputTextType() ?>" name="x_d_remarks" id="x_d_remarks" data-table="product_cart_b" data-field="x_d_remarks" value="<?= $Page->d_remarks->EditValue ?>" size="30" maxlength="500" placeholder="<?= HtmlEncode($Page->d_remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_remarks->formatPattern()) ?>"<?= $Page->d_remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_bsearch_x_operator"
        <?php } ?>
        data-table="product_cart_b"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_bsearch", function() {
    var options = { name: "x_operator", selectId: "fproduct_cart_bsearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_bsearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fproduct_cart_bsearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fproduct_cart_bsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="product_cart_b" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fproduct_cart_bsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fproduct_cart_bsearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fproduct_cart_bsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fproduct_cart_bsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fproduct_cart_bsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("product_cart_b");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
