<?php

namespace PHPMaker2024\fibre;

// Page object
$ProductCartBSampleSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { product_cart_b_sample: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fproduct_cart_b_samplesearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fproduct_cart_b_samplesearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["po_id", [], fields.po_id.isInvalid],
            ["company_id", [], fields.company_id.isInvalid],
            ["partner_id", [], fields.partner_id.isInvalid],
            ["product_type", [], fields.product_type.isInvalid],
            ["grp", [], fields.grp.isInvalid],
            ["s_grp", [], fields.s_grp.isInvalid],
            ["product", [], fields.product.isInvalid],
            ["rid", [], fields.rid.isInvalid],
            ["rid_1", [], fields.rid_1.isInvalid],
            ["shape", [], fields.shape.isInvalid],
            ["unit", [], fields.unit.isInvalid],
            ["w", [], fields.w.isInvalid],
            ["w_cm", [ew.Validators.float], fields.w_cm.isInvalid],
            ["l", [], fields.l.isInvalid],
            ["l_cm", [ew.Validators.float], fields.l_cm.isInvalid],
            ["partner_size", [], fields.partner_size.isInvalid],
            ["sqm", [ew.Validators.float], fields.sqm.isInvalid],
            ["quantity", [ew.Validators.float], fields.quantity.isInvalid],
            ["price", [ew.Validators.float], fields.price.isInvalid],
            ["currency", [], fields.currency.isInvalid],
            ["_9", [], fields._9.isInvalid],
            ["_10", [], fields._10.isInvalid],
            ["_11", [], fields._11.isInvalid],
            ["_12", [], fields._12.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["buyer_uid", [], fields.buyer_uid.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [], fields.datetime.isInvalid],
            ["image", [], fields.image.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "po_id": <?= $Page->po_id->toClientList($Page) ?>,
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
            "partner_id": <?= $Page->partner_id->toClientList($Page) ?>,
            "product_type": <?= $Page->product_type->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "shape": <?= $Page->shape->toClientList($Page) ?>,
            "unit": <?= $Page->unit->toClientList($Page) ?>,
            "currency": <?= $Page->currency->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fproduct_cart_b_samplesearch" id="fproduct_cart_b_samplesearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="product_cart_b_sample">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_sample_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="product_cart_b_sample" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->po_id->Visible) { // po_id ?>
    <div id="r_po_id" class="row"<?= $Page->po_id->rowAttributes() ?>>
        <label for="x_po_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_po_id"><?= $Page->po_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_po_id" id="z_po_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_sample_po_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_po_id"
        name="x_po_id"
        class="form-select ew-select<?= $Page->po_id->isInvalidClass() ?>"
        <?php if (!$Page->po_id->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_b_samplesearch_x_po_id"
        <?php } ?>
        data-table="product_cart_b_sample"
        data-field="x_po_id"
        data-value-separator="<?= $Page->po_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->po_id->getPlaceHolder()) ?>"
        <?= $Page->po_id->editAttributes() ?>>
        <?= $Page->po_id->selectOptionListHtml("x_po_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->po_id->getErrorMessage(false) ?></div>
<?= $Page->po_id->Lookup->getParamTag($Page, "p_x_po_id") ?>
<?php if (!$Page->po_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_b_samplesearch", function() {
    var options = { name: "x_po_id", selectId: "fproduct_cart_b_samplesearch_x_po_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_b_samplesearch.lists.po_id?.lookupOptions.length) {
        options.data = { id: "x_po_id", form: "fproduct_cart_b_samplesearch" };
    } else {
        options.ajax = { id: "x_po_id", form: "fproduct_cart_b_samplesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b_sample.fields.po_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
    <div id="r_company_id" class="row"<?= $Page->company_id->rowAttributes() ?>>
        <label for="x_company_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_company_id"><?= $Page->company_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_company_id" id="z_company_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->company_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_sample_company_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_company_id"
        name="x_company_id"
        class="form-select ew-select<?= $Page->company_id->isInvalidClass() ?>"
        <?php if (!$Page->company_id->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_b_samplesearch_x_company_id"
        <?php } ?>
        data-table="product_cart_b_sample"
        data-field="x_company_id"
        data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>"
        <?= $Page->company_id->editAttributes() ?>>
        <?= $Page->company_id->selectOptionListHtml("x_company_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->company_id->getErrorMessage(false) ?></div>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
<?php if (!$Page->company_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_b_samplesearch", function() {
    var options = { name: "x_company_id", selectId: "fproduct_cart_b_samplesearch_x_company_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_b_samplesearch.lists.company_id?.lookupOptions.length) {
        options.data = { id: "x_company_id", form: "fproduct_cart_b_samplesearch" };
    } else {
        options.ajax = { id: "x_company_id", form: "fproduct_cart_b_samplesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b_sample.fields.company_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->partner_id->Visible) { // partner_id ?>
    <div id="r_partner_id" class="row"<?= $Page->partner_id->rowAttributes() ?>>
        <label for="x_partner_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_partner_id"><?= $Page->partner_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_partner_id" id="z_partner_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->partner_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_sample_partner_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_partner_id"
        name="x_partner_id"
        class="form-select ew-select<?= $Page->partner_id->isInvalidClass() ?>"
        <?php if (!$Page->partner_id->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_b_samplesearch_x_partner_id"
        <?php } ?>
        data-table="product_cart_b_sample"
        data-field="x_partner_id"
        data-value-separator="<?= $Page->partner_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->partner_id->getPlaceHolder()) ?>"
        <?= $Page->partner_id->editAttributes() ?>>
        <?= $Page->partner_id->selectOptionListHtml("x_partner_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->partner_id->getErrorMessage(false) ?></div>
<?= $Page->partner_id->Lookup->getParamTag($Page, "p_x_partner_id") ?>
<?php if (!$Page->partner_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_b_samplesearch", function() {
    var options = { name: "x_partner_id", selectId: "fproduct_cart_b_samplesearch_x_partner_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_b_samplesearch.lists.partner_id?.lookupOptions.length) {
        options.data = { id: "x_partner_id", form: "fproduct_cart_b_samplesearch" };
    } else {
        options.ajax = { id: "x_partner_id", form: "fproduct_cart_b_samplesearch", limit: 20 };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b_sample.fields.partner_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product_type->Visible) { // product_type ?>
    <div id="r_product_type" class="row"<?= $Page->product_type->rowAttributes() ?>>
        <label for="x_product_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_product_type"><?= $Page->product_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product_type" id="z_product_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_sample_product_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_product_type"
        name="x_product_type"
        class="form-select ew-select<?= $Page->product_type->isInvalidClass() ?>"
        <?php if (!$Page->product_type->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_b_samplesearch_x_product_type"
        <?php } ?>
        data-table="product_cart_b_sample"
        data-field="x_product_type"
        data-value-separator="<?= $Page->product_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product_type->getPlaceHolder()) ?>"
        <?= $Page->product_type->editAttributes() ?>>
        <?= $Page->product_type->selectOptionListHtml("x_product_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product_type->getErrorMessage(false) ?></div>
<?php if (!$Page->product_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_b_samplesearch", function() {
    var options = { name: "x_product_type", selectId: "fproduct_cart_b_samplesearch_x_product_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_b_samplesearch.lists.product_type?.lookupOptions.length) {
        options.data = { id: "x_product_type", form: "fproduct_cart_b_samplesearch" };
    } else {
        options.ajax = { id: "x_product_type", form: "fproduct_cart_b_samplesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b_sample.fields.product_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp" class="row"<?= $Page->grp->rowAttributes() ?>>
        <label for="x_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_grp"><?= $Page->grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_sample_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_b_samplesearch_x_grp"
        <?php } ?>
        data-table="product_cart_b_sample"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_b_samplesearch", function() {
    var options = { name: "x_grp", selectId: "fproduct_cart_b_samplesearch_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_b_samplesearch.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fproduct_cart_b_samplesearch" };
    } else {
        options.ajax = { id: "x_grp", form: "fproduct_cart_b_samplesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b_sample.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp" class="row"<?= $Page->s_grp->rowAttributes() ?>>
        <label for="x_s_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_s_grp"><?= $Page->s_grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_s_grp" id="z_s_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->s_grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_sample_s_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_b_samplesearch_x_s_grp"
        <?php } ?>
        data-table="product_cart_b_sample"
        data-field="x_s_grp"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage(false) ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_b_samplesearch", function() {
    var options = { name: "x_s_grp", selectId: "fproduct_cart_b_samplesearch_x_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_b_samplesearch.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "fproduct_cart_b_samplesearch" };
    } else {
        options.ajax = { id: "x_s_grp", form: "fproduct_cart_b_samplesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b_sample.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product" class="row"<?= $Page->product->rowAttributes() ?>>
        <label for="x_product" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_product"><?= $Page->product->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product" id="z_product" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_sample_product" class="ew-search-field ew-search-field-single">
    <select
        id="x_product"
        name="x_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_b_samplesearch_x_product"
        <?php } ?>
        data-table="product_cart_b_sample"
        data-field="x_product"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage(false) ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_b_samplesearch", function() {
    var options = { name: "x_product", selectId: "fproduct_cart_b_samplesearch_x_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_b_samplesearch.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "fproduct_cart_b_samplesearch" };
    } else {
        options.ajax = { id: "x_product", form: "fproduct_cart_b_samplesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b_sample.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
    <div id="r_rid" class="row"<?= $Page->rid->rowAttributes() ?>>
        <label for="x_rid" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_rid"><?= $Page->rid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_rid" id="z_rid" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_sample_rid" class="ew-search-field ew-search-field-single">
    <select
        id="x_rid"
        name="x_rid"
        class="form-select ew-select<?= $Page->rid->isInvalidClass() ?>"
        <?php if (!$Page->rid->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_b_samplesearch_x_rid"
        <?php } ?>
        data-table="product_cart_b_sample"
        data-field="x_rid"
        data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>"
        <?= $Page->rid->editAttributes() ?>>
        <?= $Page->rid->selectOptionListHtml("x_rid") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->rid->getErrorMessage(false) ?></div>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
<?php if (!$Page->rid->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_b_samplesearch", function() {
    var options = { name: "x_rid", selectId: "fproduct_cart_b_samplesearch_x_rid" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_b_samplesearch.lists.rid?.lookupOptions.length) {
        options.data = { id: "x_rid", form: "fproduct_cart_b_samplesearch" };
    } else {
        options.ajax = { id: "x_rid", form: "fproduct_cart_b_samplesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b_sample.fields.rid.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->rid_1->Visible) { // rid_1 ?>
    <div id="r_rid_1" class="row"<?= $Page->rid_1->rowAttributes() ?>>
        <label for="x_rid_1" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_rid_1"><?= $Page->rid_1->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_rid_1" id="z_rid_1" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rid_1->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_sample_rid_1" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->rid_1->getInputTextType() ?>" name="x_rid_1" id="x_rid_1" data-table="product_cart_b_sample" data-field="x_rid_1" value="<?= $Page->rid_1->EditValue ?>" size="35" maxlength="65535" placeholder="<?= HtmlEncode($Page->rid_1->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rid_1->formatPattern()) ?>"<?= $Page->rid_1->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->rid_1->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->shape->Visible) { // shape ?>
    <div id="r_shape" class="row"<?= $Page->shape->rowAttributes() ?>>
        <label for="x_shape" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_shape"><?= $Page->shape->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_shape" id="z_shape" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->shape->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_sample_shape" class="ew-search-field ew-search-field-single">
    <select
        id="x_shape"
        name="x_shape"
        class="form-select ew-select<?= $Page->shape->isInvalidClass() ?>"
        <?php if (!$Page->shape->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_b_samplesearch_x_shape"
        <?php } ?>
        data-table="product_cart_b_sample"
        data-field="x_shape"
        data-value-separator="<?= $Page->shape->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->shape->getPlaceHolder()) ?>"
        <?= $Page->shape->editAttributes() ?>>
        <?= $Page->shape->selectOptionListHtml("x_shape") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->shape->getErrorMessage(false) ?></div>
<?= $Page->shape->Lookup->getParamTag($Page, "p_x_shape") ?>
<?php if (!$Page->shape->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_b_samplesearch", function() {
    var options = { name: "x_shape", selectId: "fproduct_cart_b_samplesearch_x_shape" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_b_samplesearch.lists.shape?.lookupOptions.length) {
        options.data = { id: "x_shape", form: "fproduct_cart_b_samplesearch" };
    } else {
        options.ajax = { id: "x_shape", form: "fproduct_cart_b_samplesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b_sample.fields.shape.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->unit->Visible) { // unit ?>
    <div id="r_unit" class="row"<?= $Page->unit->rowAttributes() ?>>
        <label for="x_unit" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_unit"><?= $Page->unit->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_unit" id="z_unit" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->unit->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_sample_unit" class="ew-search-field ew-search-field-single">
    <select
        id="x_unit"
        name="x_unit"
        class="form-select ew-select<?= $Page->unit->isInvalidClass() ?>"
        <?php if (!$Page->unit->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_b_samplesearch_x_unit"
        <?php } ?>
        data-table="product_cart_b_sample"
        data-field="x_unit"
        data-value-separator="<?= $Page->unit->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->unit->getPlaceHolder()) ?>"
        <?= $Page->unit->editAttributes() ?>>
        <?= $Page->unit->selectOptionListHtml("x_unit") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->unit->getErrorMessage(false) ?></div>
<?php if (!$Page->unit->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_b_samplesearch", function() {
    var options = { name: "x_unit", selectId: "fproduct_cart_b_samplesearch_x_unit" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_b_samplesearch.lists.unit?.lookupOptions.length) {
        options.data = { id: "x_unit", form: "fproduct_cart_b_samplesearch" };
    } else {
        options.ajax = { id: "x_unit", form: "fproduct_cart_b_samplesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b_sample.fields.unit.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->w->Visible) { // w ?>
    <div id="r_w" class="row"<?= $Page->w->rowAttributes() ?>>
        <label for="x_w" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_w"><?= $Page->w->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_w" id="z_w" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->w->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_sample_w" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->w->getInputTextType() ?>" name="x_w" id="x_w" data-table="product_cart_b_sample" data-field="x_w" value="<?= $Page->w->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->w->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->w->formatPattern()) ?>"<?= $Page->w->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->w->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->w_cm->Visible) { // w_cm ?>
    <div id="r_w_cm" class="row"<?= $Page->w_cm->rowAttributes() ?>>
        <label for="x_w_cm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_w_cm"><?= $Page->w_cm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_w_cm" id="z_w_cm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->w_cm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_sample_w_cm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->w_cm->getInputTextType() ?>" name="x_w_cm" id="x_w_cm" data-table="product_cart_b_sample" data-field="x_w_cm" value="<?= $Page->w_cm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->w_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->w_cm->formatPattern()) ?>"<?= $Page->w_cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->w_cm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->l->Visible) { // l ?>
    <div id="r_l" class="row"<?= $Page->l->rowAttributes() ?>>
        <label for="x_l" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_l"><?= $Page->l->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_l" id="z_l" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->l->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_sample_l" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->l->getInputTextType() ?>" name="x_l" id="x_l" data-table="product_cart_b_sample" data-field="x_l" value="<?= $Page->l->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->l->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->l->formatPattern()) ?>"<?= $Page->l->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->l->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->l_cm->Visible) { // l_cm ?>
    <div id="r_l_cm" class="row"<?= $Page->l_cm->rowAttributes() ?>>
        <label for="x_l_cm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_l_cm"><?= $Page->l_cm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_l_cm" id="z_l_cm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->l_cm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_sample_l_cm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->l_cm->getInputTextType() ?>" name="x_l_cm" id="x_l_cm" data-table="product_cart_b_sample" data-field="x_l_cm" value="<?= $Page->l_cm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->l_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->l_cm->formatPattern()) ?>"<?= $Page->l_cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->l_cm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->partner_size->Visible) { // partner_size ?>
    <div id="r_partner_size" class="row"<?= $Page->partner_size->rowAttributes() ?>>
        <label for="x_partner_size" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_partner_size"><?= $Page->partner_size->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_partner_size" id="z_partner_size" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->partner_size->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_sample_partner_size" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->partner_size->getInputTextType() ?>" name="x_partner_size" id="x_partner_size" data-table="product_cart_b_sample" data-field="x_partner_size" value="<?= $Page->partner_size->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->partner_size->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->partner_size->formatPattern()) ?>"<?= $Page->partner_size->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->partner_size->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
    <div id="r_sqm" class="row"<?= $Page->sqm->rowAttributes() ?>>
        <label for="x_sqm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_sqm"><?= $Page->sqm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_sqm" id="z_sqm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sqm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_sample_sqm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sqm->getInputTextType() ?>" name="x_sqm" id="x_sqm" data-table="product_cart_b_sample" data-field="x_sqm" value="<?= $Page->sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm->formatPattern()) ?>"<?= $Page->sqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sqm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity" class="row"<?= $Page->quantity->rowAttributes() ?>>
        <label for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_quantity"><?= $Page->quantity->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_quantity" id="z_quantity" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->quantity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_sample_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->quantity->getInputTextType() ?>" name="x_quantity" id="x_quantity" data-table="product_cart_b_sample" data-field="x_quantity" value="<?= $Page->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity->formatPattern()) ?>"<?= $Page->quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->quantity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->price->Visible) { // price ?>
    <div id="r_price" class="row"<?= $Page->price->rowAttributes() ?>>
        <label for="x_price" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_price"><?= $Page->price->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_price" id="z_price" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->price->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_sample_price" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->price->getInputTextType() ?>" name="x_price" id="x_price" data-table="product_cart_b_sample" data-field="x_price" value="<?= $Page->price->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->price->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->price->formatPattern()) ?>"<?= $Page->price->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->price->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->currency->Visible) { // currency ?>
    <div id="r_currency" class="row"<?= $Page->currency->rowAttributes() ?>>
        <label for="x_currency" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_currency"><?= $Page->currency->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_currency" id="z_currency" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->currency->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_sample_currency" class="ew-search-field ew-search-field-single">
    <select
        id="x_currency"
        name="x_currency"
        class="form-select ew-select<?= $Page->currency->isInvalidClass() ?>"
        <?php if (!$Page->currency->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_b_samplesearch_x_currency"
        <?php } ?>
        data-table="product_cart_b_sample"
        data-field="x_currency"
        data-value-separator="<?= $Page->currency->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->currency->getPlaceHolder()) ?>"
        <?= $Page->currency->editAttributes() ?>>
        <?= $Page->currency->selectOptionListHtml("x_currency") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->currency->getErrorMessage(false) ?></div>
<?= $Page->currency->Lookup->getParamTag($Page, "p_x_currency") ?>
<?php if (!$Page->currency->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_b_samplesearch", function() {
    var options = { name: "x_currency", selectId: "fproduct_cart_b_samplesearch_x_currency" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_b_samplesearch.lists.currency?.lookupOptions.length) {
        options.data = { id: "x_currency", form: "fproduct_cart_b_samplesearch" };
    } else {
        options.ajax = { id: "x_currency", form: "fproduct_cart_b_samplesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b_sample.fields.currency.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_9->Visible) { // 9 ?>
    <div id="r__9" class="row"<?= $Page->_9->rowAttributes() ?>>
        <label for="x__9" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_sample__9"><?= $Page->_9->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__9" id="z__9" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_9->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_sample__9" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_9->getInputTextType() ?>" name="x__9" id="x__9" data-table="product_cart_b_sample" data-field="x__9" value="<?= $Page->_9->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->_9->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_9->formatPattern()) ?>"<?= $Page->_9->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_9->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_10->Visible) { // 10 ?>
    <div id="r__10" class="row"<?= $Page->_10->rowAttributes() ?>>
        <label for="x__10" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_sample__10"><?= $Page->_10->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__10" id="z__10" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_10->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_sample__10" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_10->getInputTextType() ?>" name="x__10" id="x__10" data-table="product_cart_b_sample" data-field="x__10" value="<?= $Page->_10->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->_10->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_10->formatPattern()) ?>"<?= $Page->_10->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_10->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_11->Visible) { // 11 ?>
    <div id="r__11" class="row"<?= $Page->_11->rowAttributes() ?>>
        <label for="x__11" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_sample__11"><?= $Page->_11->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__11" id="z__11" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_11->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_sample__11" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_11->getInputTextType() ?>" name="x__11" id="x__11" data-table="product_cart_b_sample" data-field="x__11" value="<?= $Page->_11->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->_11->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_11->formatPattern()) ?>"<?= $Page->_11->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_11->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_12->Visible) { // 12 ?>
    <div id="r__12" class="row"<?= $Page->_12->rowAttributes() ?>>
        <label for="x__12" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_sample__12"><?= $Page->_12->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__12" id="z__12" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_12->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_sample__12" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_12->getInputTextType() ?>" name="x__12" id="x__12" data-table="product_cart_b_sample" data-field="x__12" value="<?= $Page->_12->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->_12->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_12->formatPattern()) ?>"<?= $Page->_12->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_12->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_sample_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="product_cart_b_sample" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" maxlength="250" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_uid->Visible) { // buyer_uid ?>
    <div id="r_buyer_uid" class="row"<?= $Page->buyer_uid->rowAttributes() ?>>
        <label for="x_buyer_uid" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_buyer_uid"><?= $Page->buyer_uid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_buyer_uid" id="z_buyer_uid" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_uid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_sample_buyer_uid" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_uid->getInputTextType() ?>" name="x_buyer_uid" id="x_buyer_uid" data-table="product_cart_b_sample" data-field="x_buyer_uid" value="<?= $Page->buyer_uid->EditValue ?>" size="35" maxlength="65535" placeholder="<?= HtmlEncode($Page->buyer_uid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_uid->formatPattern()) ?>"<?= $Page->buyer_uid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_uid->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_sample_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_b_samplesearch_x_status"
        <?php } ?>
        data-table="product_cart_b_sample"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_b_samplesearch", function() {
    var options = { name: "x_status", selectId: "fproduct_cart_b_samplesearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_b_samplesearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fproduct_cart_b_samplesearch" };
    } else {
        options.ajax = { id: "x_status", form: "fproduct_cart_b_samplesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b_sample.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_sample_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_b_samplesearch_x_operator"
        <?php } ?>
        data-table="product_cart_b_sample"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_b_samplesearch", function() {
    var options = { name: "x_operator", selectId: "fproduct_cart_b_samplesearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_b_samplesearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fproduct_cart_b_samplesearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fproduct_cart_b_samplesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b_sample.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_sample_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="product_cart_b_sample" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fproduct_cart_b_samplesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fproduct_cart_b_samplesearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->image->Visible) { // image ?>
    <div id="r_image" class="row"<?= $Page->image->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_image"><?= $Page->image->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_image" id="z_image" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->image->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_sample_image" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->image->getInputTextType() ?>" name="x_image" id="x_image" data-table="product_cart_b_sample" data-field="x_image" value="<?= $Page->image->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->image->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->image->formatPattern()) ?>"<?= $Page->image->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->image->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fproduct_cart_b_samplesearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fproduct_cart_b_samplesearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fproduct_cart_b_samplesearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("product_cart_b_sample");
});
</script>
<script>
loadjs.ready("load", function () {
    // Startup script
    // Write your table-specific startup script here
    // document.write("page loaded");
    		var SGrp = $("#x_s_grp").val();
    		if (SGrp.length > 0)
    		{
    		$.getJSON(window.location.origin +"/apcajax?getHead="+SGrp,function(data){
    					if (data.calculation_method == '1') {
    					$("#elh_product_cart_b_sample_price").html('Price / SQM');}
    					else if (data.calculation_method == '11') {
    					$("#elh_product_cart_b_sample_price").html('Price / SKU');}
    					else if (data.calculation_method == '21') {
    					$("#elh_product_cart_b_sample_price").html('Price / KG');}
    			 		if (data.pc_shape == '--NA--') {
    					$("#x_shape").val('');
    					$("#r_shape").hide(); } else {
    					$("#r_shape").show();}
    			 		if (data.pc_unit == '--NA--') {
    					$("#x_unit").val(1);
    					$("#r_unit").hide(); } else {
    					$("#r_unit").show();}			 		
    					if (data.pc_w == '--NA--') {
    					$("#x_w").val(0);
    					$("#x_w_cm").val(0);
    					$("#r_w").hide();					
    					$("#r_w_cm").hide();
    					} else {
    					$("#r_w").show();
    					$("#r_w_cm").show();}
    					if (data.pc_l == '--NA--') {
    					$("#x_l").val(0);
    					$("#x_l_cm").val(0);
    					$("#r_l").hide();					
    					$("#r_l_cm").hide();
    					} else {
    					$("#r_l").show();
    					$("#r_l_cm").show();}					
    					if (data.pc_h == '--NA--') {
    					$("#x_h").val(0);
    					$("#x_h_cm").val(0);
    					$("#r_h").hide();					
    					$("#r_h_cm").hide();
    					} else {
    					$("#r_h").show();
    					$("#r_h_cm").show();}
    			 		if (data.pc_partner_size == '--NA--') {
    					$("#x_partner_size").val('');
    					$("#r_partner_size").hide(); } else {
    					$("#r_partner_size").show();}
    			 		if (data.pc_sqm == '--NA--') {
    					$("#x_sqm").val(0);
    					$("#r_sqm").hide(); } else {
    					$("#r_sqm").show();}
    			 		if (data.pc_01_head == '--NA--') {
    					$("#x__1").val('');
    					$("#r__1").hide(); } else {
    					$("#r__1").show();					
    					$("#elh_product_cart_b_sample__1").html(data.pc_01_head);}
    			 		if (data.pc_02_head == '--NA--') {
    					$("#x__2").val('');
    					$("#r__2").hide(); } else {
    					$("#r__2").show();					
    					$("#elh_product_cart_b_sample__2").html(data.pc_02_head);}
    			 		if (data.pc_03_head == '--NA--') {
    					$("#x__3").val('');
    					$("#r__3").hide(); } else {
    					$("#r__3").show();					
    					$("#elh_product_cart_b_sample__3").html(data.pc_03_head);}
    			 		if (data.pc_04_head == '--NA--') {
    					$("#x__4").val('');
    					$("#r__4").hide(); } else {
    					$("#r__4").show();					
    					$("#elh_product_cart_b_sample__4").html(data.pc_04_head);}
    			 		if (data.pc_05_head == '--NA--') {
    					$("#x__5").val('');
    					$("#r__5").hide(); } else {
    					$("#r__5").show();					
    					$("#elh_product_cart_b_sample__5").html(data.pc_05_head);}
    			 		if (data.pc_06_head == '--NA--') {
    					$("#x__6").val('');
    					$("#r__6").hide(); } else {
    					$("#r__6").show();					
    					$("#elh_product_cart_b_sample__6").html(data.pc_06_head);}
    			 		if (data.pc_07_head == '--NA--') {
    					$("#x__7").val('');
    					$("#r__7").hide(); } else {
    					$("#r__7").show();					
    					$("#elh_product_cart_b_sample__7").html(data.pc_07_head);}
    			 		if (data.pc_08_head == '--NA--') {
    					$("#x__8").val('');
    					$("#r__8").hide(); } else {
    					$("#r__8").show();					
    					$("#elh_product_cart_b_sample__8").html(data.pc_08_head);}
    					if (data.pc_09_head == '--NA--') {
    					$("#x__9").val('');
    					$("#r__9").hide(); } else {
    					$("#r__9").show();					
    					$("#elh_product_cart_b_sample__9").html(data.pc_09_head);}
    			 		if (data.pc_10_head == '--NA--') {
    					$("#x__10").val('');
    					$("#r__10").hide(); } else {
    					$("#r__10").show();					
    					$("#elh_product_cart_b_sample__10").html(data.pc_10_head);}
    			 		if (data.pc_11_head == '--NA--') {
    					$("#x__11").val('');
    					$("#r__11").hide(); } else {
    					$("#r__11").show();					
    					$("#elh_product_cart_b_sample__11").html(data.pc_11_head);}
    			 		if (data.pc_12_head == '--NA--') {
    					$("#x__12").val('');
    					$("#r__12").hide(); } else {
    					$("#r__12").show();					
    					$("#elh_product_cart_b_sample__12").html(data.pc_12_head);}
    			});
    		}
});
</script>
