<?php

namespace PHPMaker2024\fibre;

// Page object
$ProductCartBSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { product_cart_b: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fproduct_cart_bsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fproduct_cart_bsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["po_id", [ew.Validators.integer], fields.po_id.isInvalid],
            ["location", [], fields.location.isInvalid],
            ["company_id", [ew.Validators.integer], fields.company_id.isInvalid],
            ["partner_order_no", [], fields.partner_order_no.isInvalid],
            ["partner_id", [], fields.partner_id.isInvalid],
            ["partner_rid", [], fields.partner_rid.isInvalid],
            ["partner_code", [], fields.partner_code.isInvalid],
            ["grp", [], fields.grp.isInvalid],
            ["s_grp", [], fields.s_grp.isInvalid],
            ["product", [], fields.product.isInvalid],
            ["rid_2", [], fields.rid_2.isInvalid],
            ["rid", [], fields.rid.isInvalid],
            ["packing_type", [], fields.packing_type.isInvalid],
            ["batch_no", [], fields.batch_no.isInvalid],
            ["shape", [], fields.shape.isInvalid],
            ["product_type", [], fields.product_type.isInvalid],
            ["unit", [], fields.unit.isInvalid],
            ["w", [], fields.w.isInvalid],
            ["w_cm", [ew.Validators.float], fields.w_cm.isInvalid],
            ["l", [], fields.l.isInvalid],
            ["l_cm", [ew.Validators.float], fields.l_cm.isInvalid],
            ["h", [], fields.h.isInvalid],
            ["h_cm", [ew.Validators.float], fields.h_cm.isInvalid],
            ["partner_size", [], fields.partner_size.isInvalid],
            ["size", [], fields.size.isInvalid],
            ["sqm", [ew.Validators.float], fields.sqm.isInvalid],
            ["sqm_a", [ew.Validators.float], fields.sqm_a.isInvalid],
            ["quantity", [ew.Validators.float], fields.quantity.isInvalid],
            ["image", [], fields.image.isInvalid],
            ["price", [ew.Validators.float], fields.price.isInvalid],
            ["currency", [], fields.currency.isInvalid],
            ["cbm", [ew.Validators.float], fields.cbm.isInvalid],
            ["additional_discount", [ew.Validators.float], fields.additional_discount.isInvalid],
            ["buyer_uid", [], fields.buyer_uid.isInvalid],
            ["buyer_loc", [], fields.buyer_loc.isInvalid],
            ["label", [], fields.label.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["d_remarks", [], fields.d_remarks.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setQueryBuilderLists({
            "po_id": <?= $Page->po_id->toClientList($Page) ?>,
            "location": <?= $Page->location->toClientList($Page) ?>,
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
            "partner_id": <?= $Page->partner_id->toClientList($Page) ?>,
            "partner_rid": <?= $Page->partner_rid->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "rid_2": <?= $Page->rid_2->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
            "batch_no": <?= $Page->batch_no->toClientList($Page) ?>,
            "shape": <?= $Page->shape->toClientList($Page) ?>,
            "product_type": <?= $Page->product_type->toClientList($Page) ?>,
            "unit": <?= $Page->unit->toClientList($Page) ?>,
            "currency": <?= $Page->currency->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fproduct_cart_bsearch" id="fproduct_cart_bsearch" class="<?= $Page->FormClassName ?>" action="<?= HtmlEncode(GetUrl("productcartblist")) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="product_cart_b">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<input type="hidden" name="rules" value="<?= HtmlEncode($Page->getSessionRules()) ?>">
<template id="tpx_product_cart_b_id" class="product_cart_bsearch"><span id="el_product_cart_b_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="product_cart_b" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_product_cart_b_po_id" class="product_cart_bsearch"><span id="el_product_cart_b_po_id" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->po_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_po_id" class="ew-auto-suggest">
    <input type="<?= $Page->po_id->getInputTextType() ?>" class="form-control" name="sv_x_po_id" id="sv_x_po_id" value="<?= RemoveHtml($Page->po_id->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->po_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->po_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po_id->formatPattern()) ?>"<?= $Page->po_id->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="product_cart_b" data-field="x_po_id" data-input="sv_x_po_id" data-value-separator="<?= $Page->po_id->displayValueSeparatorAttribute() ?>" name="x_po_id" id="x_po_id" value="<?= HtmlEncode($Page->po_id->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->po_id->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fproduct_cart_bsearch", function() {
    fproduct_cart_bsearch.createAutoSuggest(Object.assign({"id":"x_po_id","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->po_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.product_cart_b.fields.po_id.autoSuggestOptions));
});
</script>
<?= $Page->po_id->Lookup->getParamTag($Page, "p_x_po_id") ?>
</span></template>
<template id="tpx_product_cart_b_location" class="product_cart_bsearch"><span id="el_product_cart_b_location" class="ew-search-field ew-search-field-single">
    <select
        id="x_location"
        name="x_location"
        class="form-select ew-select<?= $Page->location->isInvalidClass() ?>"
        <?php if (!$Page->location->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_bsearch_x_location"
        <?php } ?>
        data-table="product_cart_b"
        data-field="x_location"
        data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>"
        <?= $Page->location->editAttributes() ?>>
        <?= $Page->location->selectOptionListHtml("x_location") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->location->getErrorMessage(false) ?></div>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
<?php if (!$Page->location->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_bsearch", function() {
    var options = { name: "x_location", selectId: "fproduct_cart_bsearch_x_location" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_bsearch.lists.location?.lookupOptions.length) {
        options.data = { id: "x_location", form: "fproduct_cart_bsearch" };
    } else {
        options.ajax = { id: "x_location", form: "fproduct_cart_bsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b.fields.location.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_product_cart_b_company_id" class="product_cart_bsearch"><span id="el_product_cart_b_company_id" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->company_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_company_id" class="ew-auto-suggest">
    <input type="<?= $Page->company_id->getInputTextType() ?>" class="form-control" name="sv_x_company_id" id="sv_x_company_id" value="<?= RemoveHtml($Page->company_id->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->company_id->formatPattern()) ?>"<?= $Page->company_id->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="product_cart_b" data-field="x_company_id" data-input="sv_x_company_id" data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>" name="x_company_id" id="x_company_id" value="<?= HtmlEncode($Page->company_id->AdvancedSearch->SearchValue) ?>" data-ew-action="update-options"></selection-list>
<div class="invalid-feedback"><?= $Page->company_id->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fproduct_cart_bsearch", function() {
    fproduct_cart_bsearch.createAutoSuggest(Object.assign({"id":"x_company_id","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->company_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.product_cart_b.fields.company_id.autoSuggestOptions));
});
</script>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
</span></template>
<template id="tpx_product_cart_b_partner_order_no" class="product_cart_bsearch"><span id="el_product_cart_b_partner_order_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->partner_order_no->getInputTextType() ?>" name="x_partner_order_no" id="x_partner_order_no" data-table="product_cart_b" data-field="x_partner_order_no" value="<?= $Page->partner_order_no->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->partner_order_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->partner_order_no->formatPattern()) ?>"<?= $Page->partner_order_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->partner_order_no->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_product_cart_b_partner_id" class="product_cart_bsearch"><span id="el_product_cart_b_partner_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_partner_id"
        name="x_partner_id"
        class="form-select ew-select<?= $Page->partner_id->isInvalidClass() ?>"
        <?php if (!$Page->partner_id->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_bsearch_x_partner_id"
        <?php } ?>
        data-table="product_cart_b"
        data-field="x_partner_id"
        data-value-separator="<?= $Page->partner_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->partner_id->getPlaceHolder()) ?>"
        <?= $Page->partner_id->editAttributes() ?>>
        <?= $Page->partner_id->selectOptionListHtml("x_partner_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->partner_id->getErrorMessage(false) ?></div>
<?= $Page->partner_id->Lookup->getParamTag($Page, "p_x_partner_id") ?>
<?php if (!$Page->partner_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_bsearch", function() {
    var options = { name: "x_partner_id", selectId: "fproduct_cart_bsearch_x_partner_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_bsearch.lists.partner_id?.lookupOptions.length) {
        options.data = { id: "x_partner_id", form: "fproduct_cart_bsearch" };
    } else {
        options.ajax = { id: "x_partner_id", form: "fproduct_cart_bsearch", limit: 20 };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b.fields.partner_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_product_cart_b_partner_rid" class="product_cart_bsearch"><span id="el_product_cart_b_partner_rid" class="ew-search-field ew-search-field-single">
    <select
        id="x_partner_rid"
        name="x_partner_rid"
        class="form-control ew-select<?= $Page->partner_rid->isInvalidClass() ?>"
        data-select2-id="fproduct_cart_bsearch_x_partner_rid"
        data-table="product_cart_b"
        data-field="x_partner_rid"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->partner_rid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->partner_rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->partner_rid->getPlaceHolder()) ?>"
        <?= $Page->partner_rid->editAttributes() ?>>
        <?= $Page->partner_rid->selectOptionListHtml("x_partner_rid") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->partner_rid->getErrorMessage(false) ?></div>
<?= $Page->partner_rid->Lookup->getParamTag($Page, "p_x_partner_rid") ?>
<script>
loadjs.ready("fproduct_cart_bsearch", function() {
    var options = { name: "x_partner_rid", selectId: "fproduct_cart_bsearch_x_partner_rid" };
    if (fproduct_cart_bsearch.lists.partner_rid?.lookupOptions.length) {
        options.data = { id: "x_partner_rid", form: "fproduct_cart_bsearch" };
    } else {
        options.ajax = { id: "x_partner_rid", form: "fproduct_cart_bsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.product_cart_b.fields.partner_rid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span></template>
<template id="tpx_product_cart_b_partner_code" class="product_cart_bsearch"><span id="el_product_cart_b_partner_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->partner_code->getInputTextType() ?>" name="x_partner_code" id="x_partner_code" data-table="product_cart_b" data-field="x_partner_code" value="<?= $Page->partner_code->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->partner_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->partner_code->formatPattern()) ?>"<?= $Page->partner_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->partner_code->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_product_cart_b_grp" class="product_cart_bsearch"><span id="el_product_cart_b_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_bsearch_x_grp"
        <?php } ?>
        data-table="product_cart_b"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_bsearch", function() {
    var options = { name: "x_grp", selectId: "fproduct_cart_bsearch_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_bsearch.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fproduct_cart_bsearch" };
    } else {
        options.ajax = { id: "x_grp", form: "fproduct_cart_bsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_product_cart_b_s_grp" class="product_cart_bsearch"><span id="el_product_cart_b_s_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_bsearch_x_s_grp"
        <?php } ?>
        data-table="product_cart_b"
        data-field="x_s_grp"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage(false) ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_bsearch", function() {
    var options = { name: "x_s_grp", selectId: "fproduct_cart_bsearch_x_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_bsearch.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "fproduct_cart_bsearch" };
    } else {
        options.ajax = { id: "x_s_grp", form: "fproduct_cart_bsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_product_cart_b_product" class="product_cart_bsearch"><span id="el_product_cart_b_product" class="ew-search-field ew-search-field-single">
    <select
        id="x_product"
        name="x_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_bsearch_x_product"
        <?php } ?>
        data-table="product_cart_b"
        data-field="x_product"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage(false) ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_bsearch", function() {
    var options = { name: "x_product", selectId: "fproduct_cart_bsearch_x_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_bsearch.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "fproduct_cart_bsearch" };
    } else {
        options.ajax = { id: "x_product", form: "fproduct_cart_bsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_product_cart_b_rid_2" class="product_cart_bsearch"><span id="el_product_cart_b_rid_2" class="ew-search-field ew-search-field-single">
    <select
        id="x_rid_2"
        name="x_rid_2"
        class="form-select ew-select<?= $Page->rid_2->isInvalidClass() ?>"
        <?php if (!$Page->rid_2->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_bsearch_x_rid_2"
        <?php } ?>
        data-table="product_cart_b"
        data-field="x_rid_2"
        data-value-separator="<?= $Page->rid_2->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid_2->getPlaceHolder()) ?>"
        <?= $Page->rid_2->editAttributes() ?>>
        <?= $Page->rid_2->selectOptionListHtml("x_rid_2") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->rid_2->getErrorMessage(false) ?></div>
<?= $Page->rid_2->Lookup->getParamTag($Page, "p_x_rid_2") ?>
<?php if (!$Page->rid_2->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_bsearch", function() {
    var options = { name: "x_rid_2", selectId: "fproduct_cart_bsearch_x_rid_2" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_bsearch.lists.rid_2?.lookupOptions.length) {
        options.data = { id: "x_rid_2", form: "fproduct_cart_bsearch" };
    } else {
        options.ajax = { id: "x_rid_2", form: "fproduct_cart_bsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b.fields.rid_2.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_product_cart_b_rid" class="product_cart_bsearch"><span id="el_product_cart_b_rid" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->rid->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_rid" class="ew-auto-suggest">
    <input type="<?= $Page->rid->getInputTextType() ?>" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?= RemoveHtml($Page->rid->EditValue) ?>" autocomplete="off" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rid->formatPattern()) ?>"<?= $Page->rid->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="product_cart_b" data-field="x_rid" data-input="sv_x_rid" data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?= HtmlEncode($Page->rid->AdvancedSearch->SearchValue) ?>" data-ew-action="update-options"></selection-list>
<div class="invalid-feedback"><?= $Page->rid->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fproduct_cart_bsearch", function() {
    fproduct_cart_bsearch.createAutoSuggest(Object.assign({"id":"x_rid","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->rid->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.product_cart_b.fields.rid.autoSuggestOptions));
});
</script>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
</span></template>
<template id="tpx_product_cart_b_packing_type" class="product_cart_bsearch"><span id="el_product_cart_b_packing_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_packing_type"
        name="x_packing_type"
        class="form-select ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_type->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_bsearch_x_packing_type"
        <?php } ?>
        data-table="product_cart_b"
        data-field="x_packing_type"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage(false) ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x_packing_type") ?>
<?php if (!$Page->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_bsearch", function() {
    var options = { name: "x_packing_type", selectId: "fproduct_cart_bsearch_x_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_bsearch.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x_packing_type", form: "fproduct_cart_bsearch" };
    } else {
        options.ajax = { id: "x_packing_type", form: "fproduct_cart_bsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_product_cart_b_batch_no" class="product_cart_bsearch"><span id="el_product_cart_b_batch_no" class="ew-search-field ew-search-field-single">
    <select
        id="x_batch_no"
        name="x_batch_no"
        class="form-control ew-select<?= $Page->batch_no->isInvalidClass() ?>"
        data-select2-id="fproduct_cart_bsearch_x_batch_no"
        data-table="product_cart_b"
        data-field="x_batch_no"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->batch_no->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->batch_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>"
        <?= $Page->batch_no->editAttributes() ?>>
        <?= $Page->batch_no->selectOptionListHtml("x_batch_no") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->batch_no->getErrorMessage(false) ?></div>
<?= $Page->batch_no->Lookup->getParamTag($Page, "p_x_batch_no") ?>
<script>
loadjs.ready("fproduct_cart_bsearch", function() {
    var options = { name: "x_batch_no", selectId: "fproduct_cart_bsearch_x_batch_no" };
    if (fproduct_cart_bsearch.lists.batch_no?.lookupOptions.length) {
        options.data = { id: "x_batch_no", form: "fproduct_cart_bsearch" };
    } else {
        options.ajax = { id: "x_batch_no", form: "fproduct_cart_bsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.product_cart_b.fields.batch_no.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span></template>
<template id="tpx_product_cart_b_shape" class="product_cart_bsearch"><span id="el_product_cart_b_shape" class="ew-search-field ew-search-field-single">
    <select
        id="x_shape"
        name="x_shape"
        class="form-select ew-select<?= $Page->shape->isInvalidClass() ?>"
        <?php if (!$Page->shape->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_bsearch_x_shape"
        <?php } ?>
        data-table="product_cart_b"
        data-field="x_shape"
        data-value-separator="<?= $Page->shape->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->shape->getPlaceHolder()) ?>"
        <?= $Page->shape->editAttributes() ?>>
        <?= $Page->shape->selectOptionListHtml("x_shape") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->shape->getErrorMessage(false) ?></div>
<?= $Page->shape->Lookup->getParamTag($Page, "p_x_shape") ?>
<?php if (!$Page->shape->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_bsearch", function() {
    var options = { name: "x_shape", selectId: "fproduct_cart_bsearch_x_shape" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_bsearch.lists.shape?.lookupOptions.length) {
        options.data = { id: "x_shape", form: "fproduct_cart_bsearch" };
    } else {
        options.ajax = { id: "x_shape", form: "fproduct_cart_bsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b.fields.shape.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_product_cart_b_product_type" class="product_cart_bsearch"><span id="el_product_cart_b_product_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_product_type"
        name="x_product_type"
        class="form-select ew-select<?= $Page->product_type->isInvalidClass() ?>"
        <?php if (!$Page->product_type->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_bsearch_x_product_type"
        <?php } ?>
        data-table="product_cart_b"
        data-field="x_product_type"
        data-value-separator="<?= $Page->product_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product_type->getPlaceHolder()) ?>"
        <?= $Page->product_type->editAttributes() ?>>
        <?= $Page->product_type->selectOptionListHtml("x_product_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product_type->getErrorMessage(false) ?></div>
<?= $Page->product_type->Lookup->getParamTag($Page, "p_x_product_type") ?>
<?php if (!$Page->product_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_bsearch", function() {
    var options = { name: "x_product_type", selectId: "fproduct_cart_bsearch_x_product_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_bsearch.lists.product_type?.lookupOptions.length) {
        options.data = { id: "x_product_type", form: "fproduct_cart_bsearch" };
    } else {
        options.ajax = { id: "x_product_type", form: "fproduct_cart_bsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b.fields.product_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_product_cart_b_unit" class="product_cart_bsearch"><span id="el_product_cart_b_unit" class="ew-search-field ew-search-field-single">
    <select
        id="x_unit"
        name="x_unit"
        class="form-select ew-select<?= $Page->unit->isInvalidClass() ?>"
        <?php if (!$Page->unit->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_bsearch_x_unit"
        <?php } ?>
        data-table="product_cart_b"
        data-field="x_unit"
        data-value-separator="<?= $Page->unit->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->unit->getPlaceHolder()) ?>"
        <?= $Page->unit->editAttributes() ?>>
        <?= $Page->unit->selectOptionListHtml("x_unit") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->unit->getErrorMessage(false) ?></div>
<?php if (!$Page->unit->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_bsearch", function() {
    var options = { name: "x_unit", selectId: "fproduct_cart_bsearch_x_unit" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_bsearch.lists.unit?.lookupOptions.length) {
        options.data = { id: "x_unit", form: "fproduct_cart_bsearch" };
    } else {
        options.ajax = { id: "x_unit", form: "fproduct_cart_bsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b.fields.unit.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_product_cart_b_w" class="product_cart_bsearch"><span id="el_product_cart_b_w" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->w->getInputTextType() ?>" name="x_w" id="x_w" data-table="product_cart_b" data-field="x_w" value="<?= $Page->w->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->w->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->w->formatPattern()) ?>"<?= $Page->w->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->w->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_product_cart_b_w_cm" class="product_cart_bsearch"><span id="el_product_cart_b_w_cm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->w_cm->getInputTextType() ?>" name="x_w_cm" id="x_w_cm" data-table="product_cart_b" data-field="x_w_cm" value="<?= $Page->w_cm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->w_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->w_cm->formatPattern()) ?>"<?= $Page->w_cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->w_cm->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_product_cart_b_l" class="product_cart_bsearch"><span id="el_product_cart_b_l" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->l->getInputTextType() ?>" name="x_l" id="x_l" data-table="product_cart_b" data-field="x_l" value="<?= $Page->l->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->l->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->l->formatPattern()) ?>"<?= $Page->l->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->l->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_product_cart_b_l_cm" class="product_cart_bsearch"><span id="el_product_cart_b_l_cm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->l_cm->getInputTextType() ?>" name="x_l_cm" id="x_l_cm" data-table="product_cart_b" data-field="x_l_cm" value="<?= $Page->l_cm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->l_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->l_cm->formatPattern()) ?>"<?= $Page->l_cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->l_cm->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_product_cart_b_h" class="product_cart_bsearch"><span id="el_product_cart_b_h" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->h->getInputTextType() ?>" name="x_h" id="x_h" data-table="product_cart_b" data-field="x_h" value="<?= $Page->h->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->h->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->h->formatPattern()) ?>"<?= $Page->h->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->h->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_product_cart_b_h_cm" class="product_cart_bsearch"><span id="el_product_cart_b_h_cm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->h_cm->getInputTextType() ?>" name="x_h_cm" id="x_h_cm" data-table="product_cart_b" data-field="x_h_cm" value="<?= $Page->h_cm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->h_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->h_cm->formatPattern()) ?>"<?= $Page->h_cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->h_cm->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_product_cart_b_partner_size" class="product_cart_bsearch"><span id="el_product_cart_b_partner_size" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->partner_size->getInputTextType() ?>" name="x_partner_size" id="x_partner_size" data-table="product_cart_b" data-field="x_partner_size" value="<?= $Page->partner_size->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->partner_size->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->partner_size->formatPattern()) ?>"<?= $Page->partner_size->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->partner_size->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_product_cart_b_size" class="product_cart_bsearch"><span id="el_product_cart_b_size" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->size->getInputTextType() ?>" name="x_size" id="x_size" data-table="product_cart_b" data-field="x_size" value="<?= $Page->size->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->size->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size->formatPattern()) ?>"<?= $Page->size->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->size->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_product_cart_b_sqm" class="product_cart_bsearch"><span id="el_product_cart_b_sqm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sqm->getInputTextType() ?>" name="x_sqm" id="x_sqm" data-table="product_cart_b" data-field="x_sqm" value="<?= $Page->sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm->formatPattern()) ?>"<?= $Page->sqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sqm->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_product_cart_b_sqm_a" class="product_cart_bsearch"><span id="el_product_cart_b_sqm_a" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sqm_a->getInputTextType() ?>" name="x_sqm_a" id="x_sqm_a" data-table="product_cart_b" data-field="x_sqm_a" value="<?= $Page->sqm_a->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sqm_a->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm_a->formatPattern()) ?>"<?= $Page->sqm_a->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sqm_a->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_product_cart_b_quantity" class="product_cart_bsearch"><span id="el_product_cart_b_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->quantity->getInputTextType() ?>" name="x_quantity" id="x_quantity" data-table="product_cart_b" data-field="x_quantity" value="<?= $Page->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity->formatPattern()) ?>"<?= $Page->quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->quantity->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_product_cart_b_image" class="product_cart_bsearch"><span id="el_product_cart_b_image" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->image->getInputTextType() ?>" name="x_image" id="x_image" data-table="product_cart_b" data-field="x_image" value="<?= $Page->image->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->image->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->image->formatPattern()) ?>"<?= $Page->image->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->image->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_product_cart_b_price" class="product_cart_bsearch"><span id="el_product_cart_b_price" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->price->getInputTextType() ?>" name="x_price" id="x_price" data-table="product_cart_b" data-field="x_price" value="<?= $Page->price->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->price->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->price->formatPattern()) ?>"<?= $Page->price->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->price->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_product_cart_b_currency" class="product_cart_bsearch"><span id="el_product_cart_b_currency" class="ew-search-field ew-search-field-single">
    <select
        id="x_currency"
        name="x_currency"
        class="form-select ew-select<?= $Page->currency->isInvalidClass() ?>"
        <?php if (!$Page->currency->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_bsearch_x_currency"
        <?php } ?>
        data-table="product_cart_b"
        data-field="x_currency"
        data-value-separator="<?= $Page->currency->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->currency->getPlaceHolder()) ?>"
        <?= $Page->currency->editAttributes() ?>>
        <?= $Page->currency->selectOptionListHtml("x_currency") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->currency->getErrorMessage(false) ?></div>
<?= $Page->currency->Lookup->getParamTag($Page, "p_x_currency") ?>
<?php if (!$Page->currency->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_bsearch", function() {
    var options = { name: "x_currency", selectId: "fproduct_cart_bsearch_x_currency" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_bsearch.lists.currency?.lookupOptions.length) {
        options.data = { id: "x_currency", form: "fproduct_cart_bsearch" };
    } else {
        options.ajax = { id: "x_currency", form: "fproduct_cart_bsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b.fields.currency.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_product_cart_b_cbm" class="product_cart_bsearch"><span id="el_product_cart_b_cbm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->cbm->getInputTextType() ?>" name="x_cbm" id="x_cbm" data-table="product_cart_b" data-field="x_cbm" value="<?= $Page->cbm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->cbm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cbm->formatPattern()) ?>"<?= $Page->cbm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->cbm->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_product_cart_b_additional_discount" class="product_cart_bsearch"><span id="el_product_cart_b_additional_discount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->additional_discount->getInputTextType() ?>" name="x_additional_discount" id="x_additional_discount" data-table="product_cart_b" data-field="x_additional_discount" value="<?= $Page->additional_discount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->additional_discount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->additional_discount->formatPattern()) ?>"<?= $Page->additional_discount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->additional_discount->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_product_cart_b_buyer_uid" class="product_cart_bsearch"><span id="el_product_cart_b_buyer_uid" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_uid->getInputTextType() ?>" name="x_buyer_uid" id="x_buyer_uid" data-table="product_cart_b" data-field="x_buyer_uid" value="<?= $Page->buyer_uid->EditValue ?>" size="35" maxlength="65535" placeholder="<?= HtmlEncode($Page->buyer_uid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_uid->formatPattern()) ?>"<?= $Page->buyer_uid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_uid->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_product_cart_b_buyer_loc" class="product_cart_bsearch"><span id="el_product_cart_b_buyer_loc" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_loc->getInputTextType() ?>" name="x_buyer_loc" id="x_buyer_loc" data-table="product_cart_b" data-field="x_buyer_loc" value="<?= $Page->buyer_loc->EditValue ?>" size="35" maxlength="250" placeholder="<?= HtmlEncode($Page->buyer_loc->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_loc->formatPattern()) ?>"<?= $Page->buyer_loc->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_loc->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_product_cart_b_label" class="product_cart_bsearch"><span id="el_product_cart_b_label" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->label->getInputTextType() ?>" name="x_label" id="x_label" data-table="product_cart_b" data-field="x_label" value="<?= $Page->label->EditValue ?>" maxlength="96" placeholder="<?= HtmlEncode($Page->label->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->label->formatPattern()) ?>"<?= $Page->label->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->label->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_product_cart_b_remarks" class="product_cart_bsearch"><span id="el_product_cart_b_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="product_cart_b" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" maxlength="250" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_product_cart_b_d_remarks" class="product_cart_bsearch"><span id="el_product_cart_b_d_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_remarks->getInputTextType() ?>" name="x_d_remarks" id="x_d_remarks" data-table="product_cart_b" data-field="x_d_remarks" value="<?= $Page->d_remarks->EditValue ?>" size="30" maxlength="500" placeholder="<?= HtmlEncode($Page->d_remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_remarks->formatPattern()) ?>"<?= $Page->d_remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_remarks->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_product_cart_b_operator" class="product_cart_bsearch"><span id="el_product_cart_b_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_bsearch_x_operator"
        <?php } ?>
        data-table="product_cart_b"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_bsearch", function() {
    var options = { name: "x_operator", selectId: "fproduct_cart_bsearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_bsearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fproduct_cart_bsearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fproduct_cart_bsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_product_cart_b_datetime" class="product_cart_bsearch"><span id="el_product_cart_b_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="product_cart_b" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fproduct_cart_bsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fproduct_cart_bsearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span></template>
<div id="product_cart_b_query_builder" class="query-builder mb-3"></div>
<div class="btn-group mb-3 query-btn-group"></div>
<button type="button" id="btn-view-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("View", true)) ?>"><i class="fa-solid fa-eye ew-icon"></i></button>
<button type="button" id="btn-clear-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("Clear", true)) ?>"><i class="fa-solid fa-xmark ew-icon"></i></button>
<script>
// Filter builder
loadjs.ready(["wrapper", "head"], () => {
    let filters = [
            {
                id: "id",
                type: "integer",
                label: currentTable.fields.id.caption,
                operators: currentTable.fields.id.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.id.validators),
                data: {
                    format: currentTable.fields.id.clientFormatPattern
                }
            },
            {
                id: "po_id",
                type: "integer",
                label: currentTable.fields.po_id.caption,
                operators: currentTable.fields.po_id.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.po_id.validators),
                data: {
                    format: currentTable.fields.po_id.clientFormatPattern
                }
            },
            {
                id: "location",
                type: "integer",
                label: currentTable.fields.location.caption,
                operators: currentTable.fields.location.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.location.validators),
                data: {
                    format: currentTable.fields.location.clientFormatPattern
                }
            },
            {
                id: "company_id",
                type: "integer",
                label: currentTable.fields.company_id.caption,
                operators: currentTable.fields.company_id.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.company_id.validators),
                data: {
                    format: currentTable.fields.company_id.clientFormatPattern
                }
            },
            {
                id: "partner_order_no",
                type: "string",
                label: currentTable.fields.partner_order_no.caption,
                operators: currentTable.fields.partner_order_no.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.partner_order_no.validators),
                data: {
                    format: currentTable.fields.partner_order_no.clientFormatPattern
                }
            },
            {
                id: "partner_id",
                type: "integer",
                label: currentTable.fields.partner_id.caption,
                operators: currentTable.fields.partner_id.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.partner_id.validators),
                data: {
                    format: currentTable.fields.partner_id.clientFormatPattern
                }
            },
            {
                id: "partner_rid",
                type: "string",
                label: currentTable.fields.partner_rid.caption,
                operators: currentTable.fields.partner_rid.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.partner_rid.validators),
                data: {
                    format: currentTable.fields.partner_rid.clientFormatPattern
                }
            },
            {
                id: "partner_code",
                type: "string",
                label: currentTable.fields.partner_code.caption,
                operators: currentTable.fields.partner_code.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.partner_code.validators),
                data: {
                    format: currentTable.fields.partner_code.clientFormatPattern
                }
            },
            {
                id: "grp",
                type: "integer",
                label: currentTable.fields.grp.caption,
                operators: currentTable.fields.grp.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.grp.validators),
                data: {
                    format: currentTable.fields.grp.clientFormatPattern
                }
            },
            {
                id: "s_grp",
                type: "integer",
                label: currentTable.fields.s_grp.caption,
                operators: currentTable.fields.s_grp.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.s_grp.validators),
                data: {
                    format: currentTable.fields.s_grp.clientFormatPattern
                }
            },
            {
                id: "product",
                type: "integer",
                label: currentTable.fields.product.caption,
                operators: currentTable.fields.product.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.product.validators),
                data: {
                    format: currentTable.fields.product.clientFormatPattern
                }
            },
            {
                id: "rid_2",
                type: "string",
                label: currentTable.fields.rid_2.caption,
                operators: currentTable.fields.rid_2.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.rid_2.validators),
                data: {
                    format: currentTable.fields.rid_2.clientFormatPattern
                }
            },
            {
                id: "rid",
                type: "string",
                label: currentTable.fields.rid.caption,
                operators: currentTable.fields.rid.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.rid.validators),
                data: {
                    format: currentTable.fields.rid.clientFormatPattern
                }
            },
            {
                id: "packing_type",
                type: "integer",
                label: currentTable.fields.packing_type.caption,
                operators: currentTable.fields.packing_type.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.packing_type.validators),
                data: {
                    format: currentTable.fields.packing_type.clientFormatPattern
                }
            },
            {
                id: "batch_no",
                type: "integer",
                label: currentTable.fields.batch_no.caption,
                operators: currentTable.fields.batch_no.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.batch_no.validators),
                data: {
                    format: currentTable.fields.batch_no.clientFormatPattern
                }
            },
            {
                id: "shape",
                type: "integer",
                label: currentTable.fields.shape.caption,
                operators: currentTable.fields.shape.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.shape.validators),
                data: {
                    format: currentTable.fields.shape.clientFormatPattern
                }
            },
            {
                id: "product_type",
                type: "integer",
                label: currentTable.fields.product_type.caption,
                operators: currentTable.fields.product_type.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.product_type.validators),
                data: {
                    format: currentTable.fields.product_type.clientFormatPattern
                }
            },
            {
                id: "unit",
                type: "integer",
                label: currentTable.fields.unit.caption,
                operators: currentTable.fields.unit.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.unit.validators),
                data: {
                    format: currentTable.fields.unit.clientFormatPattern
                }
            },
            {
                id: "w",
                type: "string",
                label: currentTable.fields.w.caption,
                operators: currentTable.fields.w.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.w.validators),
                data: {
                    format: currentTable.fields.w.clientFormatPattern
                }
            },
            {
                id: "w_cm",
                type: "double",
                label: currentTable.fields.w_cm.caption,
                operators: currentTable.fields.w_cm.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.w_cm.validators),
                data: {
                    format: currentTable.fields.w_cm.clientFormatPattern
                }
            },
            {
                id: "l",
                type: "string",
                label: currentTable.fields.l.caption,
                operators: currentTable.fields.l.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.l.validators),
                data: {
                    format: currentTable.fields.l.clientFormatPattern
                }
            },
            {
                id: "l_cm",
                type: "double",
                label: currentTable.fields.l_cm.caption,
                operators: currentTable.fields.l_cm.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.l_cm.validators),
                data: {
                    format: currentTable.fields.l_cm.clientFormatPattern
                }
            },
            {
                id: "h",
                type: "string",
                label: currentTable.fields.h.caption,
                operators: currentTable.fields.h.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.h.validators),
                data: {
                    format: currentTable.fields.h.clientFormatPattern
                }
            },
            {
                id: "h_cm",
                type: "double",
                label: currentTable.fields.h_cm.caption,
                operators: currentTable.fields.h_cm.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.h_cm.validators),
                data: {
                    format: currentTable.fields.h_cm.clientFormatPattern
                }
            },
            {
                id: "partner_size",
                type: "string",
                label: currentTable.fields.partner_size.caption,
                operators: currentTable.fields.partner_size.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.partner_size.validators),
                data: {
                    format: currentTable.fields.partner_size.clientFormatPattern
                }
            },
            {
                id: "size",
                type: "string",
                label: currentTable.fields.size.caption,
                operators: currentTable.fields.size.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.size.validators),
                data: {
                    format: currentTable.fields.size.clientFormatPattern
                }
            },
            {
                id: "sqm",
                type: "double",
                label: currentTable.fields.sqm.caption,
                operators: currentTable.fields.sqm.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.sqm.validators),
                data: {
                    format: currentTable.fields.sqm.clientFormatPattern
                }
            },
            {
                id: "sqm_a",
                type: "double",
                label: currentTable.fields.sqm_a.caption,
                operators: currentTable.fields.sqm_a.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.sqm_a.validators),
                data: {
                    format: currentTable.fields.sqm_a.clientFormatPattern
                }
            },
            {
                id: "quantity",
                type: "double",
                label: currentTable.fields.quantity.caption,
                operators: currentTable.fields.quantity.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.quantity.validators),
                data: {
                    format: currentTable.fields.quantity.clientFormatPattern
                }
            },
            {
                id: "image",
                type: "string",
                label: currentTable.fields.image.caption,
                operators: currentTable.fields.image.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.image.validators),
                data: {
                    format: currentTable.fields.image.clientFormatPattern
                }
            },
            {
                id: "price",
                type: "double",
                label: currentTable.fields.price.caption,
                operators: currentTable.fields.price.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.price.validators),
                data: {
                    format: currentTable.fields.price.clientFormatPattern
                }
            },
            {
                id: "currency",
                type: "integer",
                label: currentTable.fields.currency.caption,
                operators: currentTable.fields.currency.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.currency.validators),
                data: {
                    format: currentTable.fields.currency.clientFormatPattern
                }
            },
            {
                id: "cbm",
                type: "double",
                label: currentTable.fields.cbm.caption,
                operators: currentTable.fields.cbm.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.cbm.validators),
                data: {
                    format: currentTable.fields.cbm.clientFormatPattern
                }
            },
            {
                id: "additional_discount",
                type: "double",
                label: currentTable.fields.additional_discount.caption,
                operators: currentTable.fields.additional_discount.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.additional_discount.validators),
                data: {
                    format: currentTable.fields.additional_discount.clientFormatPattern
                }
            },
            {
                id: "buyer_uid",
                type: "string",
                label: currentTable.fields.buyer_uid.caption,
                operators: currentTable.fields.buyer_uid.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.buyer_uid.validators),
                data: {
                    format: currentTable.fields.buyer_uid.clientFormatPattern
                }
            },
            {
                id: "buyer_loc",
                type: "string",
                label: currentTable.fields.buyer_loc.caption,
                operators: currentTable.fields.buyer_loc.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.buyer_loc.validators),
                data: {
                    format: currentTable.fields.buyer_loc.clientFormatPattern
                }
            },
            {
                id: "label",
                type: "string",
                label: currentTable.fields.label.caption,
                operators: currentTable.fields.label.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.label.validators),
                data: {
                    format: currentTable.fields.label.clientFormatPattern
                }
            },
            {
                id: "remarks",
                type: "string",
                label: currentTable.fields.remarks.caption,
                operators: currentTable.fields.remarks.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.remarks.validators),
                data: {
                    format: currentTable.fields.remarks.clientFormatPattern
                }
            },
            {
                id: "d_remarks",
                type: "string",
                label: currentTable.fields.d_remarks.caption,
                operators: currentTable.fields.d_remarks.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.d_remarks.validators),
                data: {
                    format: currentTable.fields.d_remarks.clientFormatPattern
                }
            },
            {
                id: "operator",
                type: "integer",
                label: currentTable.fields.operator.caption,
                operators: currentTable.fields.operator.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.operator.validators),
                data: {
                    format: currentTable.fields.operator.clientFormatPattern
                }
            },
            {
                id: "datetime",
                type: "datetime",
                label: currentTable.fields.datetime.caption,
                operators: currentTable.fields.datetime.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fproduct_cart_bsearch.fields.datetime.validators),
                data: {
                    format: currentTable.fields.datetime.clientFormatPattern
                }
            },
        ],
        $ = jQuery,
        $qb = $("#product_cart_b_query_builder"),
        args = {},
        rules = ew.parseJson($("#fproduct_cart_bsearch input[name=rules]").val()),
        queryBuilderOptions = Object.assign({}, ew.queryBuilderOptions),
        allowViewRules = queryBuilderOptions.allowViewRules,
        allowClearRules = queryBuilderOptions.allowClearRules,
        hasRules = group => Array.isArray(group?.rules) && group.rules.length > 0,
        getRules = () => $qb.queryBuilder("getRules", { skip_empty: true }),
        getSql = () => $qb.queryBuilder("getSQL", false, false, rules)?.sql;
    delete queryBuilderOptions.allowViewRules;
    delete queryBuilderOptions.allowClearRules;
    args.options = ew.deepAssign({
        plugins: Object.assign({}, ew.queryBuilderPlugins),
        lang: ew.language.phrase("querybuilderjs"),
        select_placeholder: ew.language.phrase("PleaseSelect"),
        inputs_separator: `<div class="d-inline-flex ms-2 me-2">${ew.language.phrase("AND")}</div>`, // For "between"
        filters,
        rules
    }, queryBuilderOptions);
    $qb.trigger("querybuilder", [args]);
    $qb.queryBuilder(args.options).on("rulesChanged.queryBuilder", () => {
        let rules = getRules();
        !ew.DEBUG || console.log(rules, getSql());
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").toggleClass("disabled", !rules);
    }).on("afterCreateRuleInput.queryBuilder", function(e, rule) {
        let select = rule.$el.find(".rule-value-container").find("selection-list, select")[0];
        if (select) { // Selection list
            let id = select.dataset.field.replace("^x_", ""),
                form = ew.forms.get(select);
            form.updateList(select, undefined, undefined, true); // Update immediately
        }
    });
    $("#fproduct_cart_bsearch").on("beforesubmit", function () {
        this.rules.value = JSON.stringify(getRules());
    });
    $("#btn-reset").toggleClass("d-none", false).on("click", () => {
        hasRules(rules) ? $qb.queryBuilder("setRules", rules) : $qb.queryBuilder("reset");
        return false;
    });
    $("#btn-action").toggleClass("d-none", false);
    if (allowClearRules) {
        $("#btn-clear-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => $qb.queryBuilder("reset"));
    }
    if (allowViewRules) {
        $("#btn-view-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => {
            let rules = getRules();
            if (hasRules(rules)) {
                let sql = getSql();
                ew.alert(sql ? '<pre class="text-start fs-6">' + sql + '</pre>' : '', "dark");
                !ew.DEBUG || console.log(rules, sql);
            } else {
                ew.alert(ew.language.phrase("EmptyLabel"));
            }
        });
    }
    $(".query-btn-group").toggleClass(".mb-3", $(".query-btn-group").find(".btn:not(.d-none)").length);
    if (hasRules(rules)) { // Enable buttons if rules exist initially
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").removeClass("disabled");
    }
});
</script>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn d-none disabled" name="btn-action" id="btn-action" type="submit" form="fproduct_cart_bsearch" formaction="<?= HtmlEncode(GetUrl("productcartblist")) ?>" data-ajax="<?= $Page->UseAjaxActions ? "true" : "false" ?>"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fproduct_cart_bsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn d-none disabled" name="btn-reset" id="btn-reset" type="button" form="fproduct_cart_bsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("product_cart_b");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
