<?php

namespace PHPMaker2024\fibre;

// Page object
$ProductCartBAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { product_cart_b: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fproduct_cart_badd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fproduct_cart_badd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["location", [fields.location.visible && fields.location.required ? ew.Validators.required(fields.location.caption) : null], fields.location.isInvalid],
            ["company_id", [fields.company_id.visible && fields.company_id.required ? ew.Validators.required(fields.company_id.caption) : null, ew.Validators.integer], fields.company_id.isInvalid],
            ["partner_order_no", [fields.partner_order_no.visible && fields.partner_order_no.required ? ew.Validators.required(fields.partner_order_no.caption) : null], fields.partner_order_no.isInvalid],
            ["partner_id", [fields.partner_id.visible && fields.partner_id.required ? ew.Validators.required(fields.partner_id.caption) : null], fields.partner_id.isInvalid],
            ["partner_rid", [fields.partner_rid.visible && fields.partner_rid.required ? ew.Validators.required(fields.partner_rid.caption) : null], fields.partner_rid.isInvalid],
            ["partner_code", [fields.partner_code.visible && fields.partner_code.required ? ew.Validators.required(fields.partner_code.caption) : null], fields.partner_code.isInvalid],
            ["grp", [fields.grp.visible && fields.grp.required ? ew.Validators.required(fields.grp.caption) : null], fields.grp.isInvalid],
            ["s_grp", [fields.s_grp.visible && fields.s_grp.required ? ew.Validators.required(fields.s_grp.caption) : null], fields.s_grp.isInvalid],
            ["product", [fields.product.visible && fields.product.required ? ew.Validators.required(fields.product.caption) : null], fields.product.isInvalid],
            ["rid_2", [fields.rid_2.visible && fields.rid_2.required ? ew.Validators.required(fields.rid_2.caption) : null], fields.rid_2.isInvalid],
            ["rid", [fields.rid.visible && fields.rid.required ? ew.Validators.required(fields.rid.caption) : null], fields.rid.isInvalid],
            ["packing_type", [fields.packing_type.visible && fields.packing_type.required ? ew.Validators.required(fields.packing_type.caption) : null], fields.packing_type.isInvalid],
            ["batch_no", [fields.batch_no.visible && fields.batch_no.required ? ew.Validators.required(fields.batch_no.caption) : null], fields.batch_no.isInvalid],
            ["shape", [fields.shape.visible && fields.shape.required ? ew.Validators.required(fields.shape.caption) : null], fields.shape.isInvalid],
            ["product_type", [fields.product_type.visible && fields.product_type.required ? ew.Validators.required(fields.product_type.caption) : null], fields.product_type.isInvalid],
            ["unit", [fields.unit.visible && fields.unit.required ? ew.Validators.required(fields.unit.caption) : null], fields.unit.isInvalid],
            ["w", [fields.w.visible && fields.w.required ? ew.Validators.required(fields.w.caption) : null], fields.w.isInvalid],
            ["w_cm", [fields.w_cm.visible && fields.w_cm.required ? ew.Validators.required(fields.w_cm.caption) : null, ew.Validators.float], fields.w_cm.isInvalid],
            ["l", [fields.l.visible && fields.l.required ? ew.Validators.required(fields.l.caption) : null], fields.l.isInvalid],
            ["l_cm", [fields.l_cm.visible && fields.l_cm.required ? ew.Validators.required(fields.l_cm.caption) : null, ew.Validators.float], fields.l_cm.isInvalid],
            ["h", [fields.h.visible && fields.h.required ? ew.Validators.required(fields.h.caption) : null], fields.h.isInvalid],
            ["h_cm", [fields.h_cm.visible && fields.h_cm.required ? ew.Validators.required(fields.h_cm.caption) : null, ew.Validators.float], fields.h_cm.isInvalid],
            ["partner_size", [fields.partner_size.visible && fields.partner_size.required ? ew.Validators.required(fields.partner_size.caption) : null], fields.partner_size.isInvalid],
            ["sqm", [fields.sqm.visible && fields.sqm.required ? ew.Validators.required(fields.sqm.caption) : null, ew.Validators.float], fields.sqm.isInvalid],
            ["sqm_a", [fields.sqm_a.visible && fields.sqm_a.required ? ew.Validators.required(fields.sqm_a.caption) : null, ew.Validators.float], fields.sqm_a.isInvalid],
            ["quantity", [fields.quantity.visible && fields.quantity.required ? ew.Validators.required(fields.quantity.caption) : null, ew.Validators.float], fields.quantity.isInvalid],
            ["image", [fields.image.visible && fields.image.required ? ew.Validators.fileRequired(fields.image.caption) : null], fields.image.isInvalid],
            ["price", [fields.price.visible && fields.price.required ? ew.Validators.required(fields.price.caption) : null, ew.Validators.float], fields.price.isInvalid],
            ["currency", [fields.currency.visible && fields.currency.required ? ew.Validators.required(fields.currency.caption) : null], fields.currency.isInvalid],
            ["amount", [fields.amount.visible && fields.amount.required ? ew.Validators.required(fields.amount.caption) : null, ew.Validators.float], fields.amount.isInvalid],
            ["shipping_charge", [fields.shipping_charge.visible && fields.shipping_charge.required ? ew.Validators.required(fields.shipping_charge.caption) : null, ew.Validators.float], fields.shipping_charge.isInvalid],
            ["additional_discount", [fields.additional_discount.visible && fields.additional_discount.required ? ew.Validators.required(fields.additional_discount.caption) : null, ew.Validators.float], fields.additional_discount.isInvalid],
            ["buyer_uid", [fields.buyer_uid.visible && fields.buyer_uid.required ? ew.Validators.required(fields.buyer_uid.caption) : null], fields.buyer_uid.isInvalid],
            ["buyer_loc", [fields.buyer_loc.visible && fields.buyer_loc.required ? ew.Validators.required(fields.buyer_loc.caption) : null], fields.buyer_loc.isInvalid],
            ["label", [fields.label.visible && fields.label.required ? ew.Validators.required(fields.label.caption) : null], fields.label.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "location": <?= $Page->location->toClientList($Page) ?>,
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
            "partner_id": <?= $Page->partner_id->toClientList($Page) ?>,
            "partner_rid": <?= $Page->partner_rid->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "rid_2": <?= $Page->rid_2->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
            "batch_no": <?= $Page->batch_no->toClientList($Page) ?>,
            "shape": <?= $Page->shape->toClientList($Page) ?>,
            "product_type": <?= $Page->product_type->toClientList($Page) ?>,
            "unit": <?= $Page->unit->toClientList($Page) ?>,
            "currency": <?= $Page->currency->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fproduct_cart_badd" id="fproduct_cart_badd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="product_cart_b">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->location->Visible) { // location ?>
    <div id="r_location"<?= $Page->location->rowAttributes() ?>>
        <label id="elh_product_cart_b_location" for="x_location" class="<?= $Page->LeftColumnClass ?>"><?= $Page->location->caption() ?><?= $Page->location->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->location->cellAttributes() ?>>
<span id="el_product_cart_b_location">
    <select
        id="x_location"
        name="x_location"
        class="form-select ew-select<?= $Page->location->isInvalidClass() ?>"
        <?php if (!$Page->location->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_badd_x_location"
        <?php } ?>
        data-table="product_cart_b"
        data-field="x_location"
        data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>"
        <?= $Page->location->editAttributes() ?>>
        <?= $Page->location->selectOptionListHtml("x_location") ?>
    </select>
    <?= $Page->location->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->location->getErrorMessage() ?></div>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
<?php if (!$Page->location->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_badd", function() {
    var options = { name: "x_location", selectId: "fproduct_cart_badd_x_location" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_badd.lists.location?.lookupOptions.length) {
        options.data = { id: "x_location", form: "fproduct_cart_badd" };
    } else {
        options.ajax = { id: "x_location", form: "fproduct_cart_badd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b.fields.location.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
    <div id="r_company_id"<?= $Page->company_id->rowAttributes() ?>>
        <label id="elh_product_cart_b_company_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->company_id->caption() ?><?= $Page->company_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->company_id->cellAttributes() ?>>
<span id="el_product_cart_b_company_id">
<?php
if (IsRTL()) {
    $Page->company_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_company_id" class="ew-auto-suggest">
    <input type="<?= $Page->company_id->getInputTextType() ?>" class="form-control" name="sv_x_company_id" id="sv_x_company_id" value="<?= RemoveHtml($Page->company_id->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->company_id->formatPattern()) ?>"<?= $Page->company_id->editAttributes() ?> aria-describedby="x_company_id_help">
</span>
<selection-list hidden class="form-control" data-table="product_cart_b" data-field="x_company_id" data-input="sv_x_company_id" data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>" name="x_company_id" id="x_company_id" value="<?= HtmlEncode($Page->company_id->CurrentValue) ?>" data-ew-action="update-options"></selection-list>
<?= $Page->company_id->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->company_id->getErrorMessage() ?></div>
<script>
loadjs.ready("fproduct_cart_badd", function() {
    fproduct_cart_badd.createAutoSuggest(Object.assign({"id":"x_company_id","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->company_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.product_cart_b.fields.company_id.autoSuggestOptions));
});
</script>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->partner_order_no->Visible) { // partner_order_no ?>
    <div id="r_partner_order_no"<?= $Page->partner_order_no->rowAttributes() ?>>
        <label id="elh_product_cart_b_partner_order_no" for="x_partner_order_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->partner_order_no->caption() ?><?= $Page->partner_order_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->partner_order_no->cellAttributes() ?>>
<span id="el_product_cart_b_partner_order_no">
<input type="<?= $Page->partner_order_no->getInputTextType() ?>" name="x_partner_order_no" id="x_partner_order_no" data-table="product_cart_b" data-field="x_partner_order_no" value="<?= $Page->partner_order_no->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->partner_order_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->partner_order_no->formatPattern()) ?>"<?= $Page->partner_order_no->editAttributes() ?> aria-describedby="x_partner_order_no_help">
<?= $Page->partner_order_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->partner_order_no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->partner_id->Visible) { // partner_id ?>
    <div id="r_partner_id"<?= $Page->partner_id->rowAttributes() ?>>
        <label id="elh_product_cart_b_partner_id" for="x_partner_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->partner_id->caption() ?><?= $Page->partner_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->partner_id->cellAttributes() ?>>
<span id="el_product_cart_b_partner_id">
    <select
        id="x_partner_id"
        name="x_partner_id"
        class="form-select ew-select<?= $Page->partner_id->isInvalidClass() ?>"
        <?php if (!$Page->partner_id->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_badd_x_partner_id"
        <?php } ?>
        data-table="product_cart_b"
        data-field="x_partner_id"
        data-value-separator="<?= $Page->partner_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->partner_id->getPlaceHolder()) ?>"
        <?= $Page->partner_id->editAttributes() ?>>
        <?= $Page->partner_id->selectOptionListHtml("x_partner_id") ?>
    </select>
    <?= $Page->partner_id->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->partner_id->getErrorMessage() ?></div>
<?= $Page->partner_id->Lookup->getParamTag($Page, "p_x_partner_id") ?>
<?php if (!$Page->partner_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_badd", function() {
    var options = { name: "x_partner_id", selectId: "fproduct_cart_badd_x_partner_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_badd.lists.partner_id?.lookupOptions.length) {
        options.data = { id: "x_partner_id", form: "fproduct_cart_badd" };
    } else {
        options.ajax = { id: "x_partner_id", form: "fproduct_cart_badd", limit: 20 };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b.fields.partner_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->partner_rid->Visible) { // partner_rid ?>
    <div id="r_partner_rid"<?= $Page->partner_rid->rowAttributes() ?>>
        <label id="elh_product_cart_b_partner_rid" class="<?= $Page->LeftColumnClass ?>"><?= $Page->partner_rid->caption() ?><?= $Page->partner_rid->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->partner_rid->cellAttributes() ?>>
<span id="el_product_cart_b_partner_rid">
    <select
        id="x_partner_rid"
        name="x_partner_rid"
        class="form-control ew-select<?= $Page->partner_rid->isInvalidClass() ?>"
        data-select2-id="fproduct_cart_badd_x_partner_rid"
        data-table="product_cart_b"
        data-field="x_partner_rid"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->partner_rid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->partner_rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->partner_rid->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Page->partner_rid->editAttributes() ?>>
        <?= $Page->partner_rid->selectOptionListHtml("x_partner_rid") ?>
    </select>
    <?= $Page->partner_rid->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->partner_rid->getErrorMessage() ?></div>
<?= $Page->partner_rid->Lookup->getParamTag($Page, "p_x_partner_rid") ?>
<script>
loadjs.ready("fproduct_cart_badd", function() {
    var options = { name: "x_partner_rid", selectId: "fproduct_cart_badd_x_partner_rid" };
    if (fproduct_cart_badd.lists.partner_rid?.lookupOptions.length) {
        options.data = { id: "x_partner_rid", form: "fproduct_cart_badd" };
    } else {
        options.ajax = { id: "x_partner_rid", form: "fproduct_cart_badd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.product_cart_b.fields.partner_rid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->partner_code->Visible) { // partner_code ?>
    <div id="r_partner_code"<?= $Page->partner_code->rowAttributes() ?>>
        <label id="elh_product_cart_b_partner_code" for="x_partner_code" class="<?= $Page->LeftColumnClass ?>"><?= $Page->partner_code->caption() ?><?= $Page->partner_code->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->partner_code->cellAttributes() ?>>
<span id="el_product_cart_b_partner_code">
<input type="<?= $Page->partner_code->getInputTextType() ?>" name="x_partner_code" id="x_partner_code" data-table="product_cart_b" data-field="x_partner_code" value="<?= $Page->partner_code->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->partner_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->partner_code->formatPattern()) ?>"<?= $Page->partner_code->editAttributes() ?> aria-describedby="x_partner_code_help">
<?= $Page->partner_code->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->partner_code->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp"<?= $Page->grp->rowAttributes() ?>>
        <label id="elh_product_cart_b_grp" for="x_grp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->grp->caption() ?><?= $Page->grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->grp->cellAttributes() ?>>
<span id="el_product_cart_b_grp">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_badd_x_grp"
        <?php } ?>
        data-table="product_cart_b"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <?= $Page->grp->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage() ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_badd", function() {
    var options = { name: "x_grp", selectId: "fproduct_cart_badd_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_badd.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fproduct_cart_badd" };
    } else {
        options.ajax = { id: "x_grp", form: "fproduct_cart_badd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp"<?= $Page->s_grp->rowAttributes() ?>>
        <label id="elh_product_cart_b_s_grp" for="x_s_grp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->s_grp->caption() ?><?= $Page->s_grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->s_grp->cellAttributes() ?>>
<span id="el_product_cart_b_s_grp">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_badd_x_s_grp"
        <?php } ?>
        data-table="product_cart_b"
        data-field="x_s_grp"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <?= $Page->s_grp->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage() ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_badd", function() {
    var options = { name: "x_s_grp", selectId: "fproduct_cart_badd_x_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_badd.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "fproduct_cart_badd" };
    } else {
        options.ajax = { id: "x_s_grp", form: "fproduct_cart_badd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product"<?= $Page->product->rowAttributes() ?>>
        <label id="elh_product_cart_b_product" for="x_product" class="<?= $Page->LeftColumnClass ?>"><?= $Page->product->caption() ?><?= $Page->product->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->product->cellAttributes() ?>>
<span id="el_product_cart_b_product">
    <select
        id="x_product"
        name="x_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_badd_x_product"
        <?php } ?>
        data-table="product_cart_b"
        data-field="x_product"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <?= $Page->product->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage() ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_badd", function() {
    var options = { name: "x_product", selectId: "fproduct_cart_badd_x_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_badd.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "fproduct_cart_badd" };
    } else {
        options.ajax = { id: "x_product", form: "fproduct_cart_badd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->rid_2->Visible) { // rid_2 ?>
    <div id="r_rid_2"<?= $Page->rid_2->rowAttributes() ?>>
        <label id="elh_product_cart_b_rid_2" for="x_rid_2" class="<?= $Page->LeftColumnClass ?>"><?= $Page->rid_2->caption() ?><?= $Page->rid_2->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->rid_2->cellAttributes() ?>>
<span id="el_product_cart_b_rid_2">
    <select
        id="x_rid_2"
        name="x_rid_2"
        class="form-select ew-select<?= $Page->rid_2->isInvalidClass() ?>"
        <?php if (!$Page->rid_2->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_badd_x_rid_2"
        <?php } ?>
        data-table="product_cart_b"
        data-field="x_rid_2"
        data-value-separator="<?= $Page->rid_2->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid_2->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Page->rid_2->editAttributes() ?>>
        <?= $Page->rid_2->selectOptionListHtml("x_rid_2") ?>
    </select>
    <?= $Page->rid_2->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->rid_2->getErrorMessage() ?></div>
<?= $Page->rid_2->Lookup->getParamTag($Page, "p_x_rid_2") ?>
<?php if (!$Page->rid_2->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_badd", function() {
    var options = { name: "x_rid_2", selectId: "fproduct_cart_badd_x_rid_2" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_badd.lists.rid_2?.lookupOptions.length) {
        options.data = { id: "x_rid_2", form: "fproduct_cart_badd" };
    } else {
        options.ajax = { id: "x_rid_2", form: "fproduct_cart_badd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b.fields.rid_2.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
    <div id="r_rid"<?= $Page->rid->rowAttributes() ?>>
        <label id="elh_product_cart_b_rid" class="<?= $Page->LeftColumnClass ?>"><?= $Page->rid->caption() ?><?= $Page->rid->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->rid->cellAttributes() ?>>
<span id="el_product_cart_b_rid">
<?php
if (IsRTL()) {
    $Page->rid->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_rid" class="ew-auto-suggest">
    <input type="<?= $Page->rid->getInputTextType() ?>" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?= RemoveHtml($Page->rid->EditValue) ?>" autocomplete="off" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rid->formatPattern()) ?>"<?= $Page->rid->editAttributes() ?> aria-describedby="x_rid_help">
</span>
<selection-list hidden class="form-control" data-table="product_cart_b" data-field="x_rid" data-input="sv_x_rid" data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?= HtmlEncode($Page->rid->CurrentValue) ?>" data-ew-action="update-options"></selection-list>
<?= $Page->rid->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->rid->getErrorMessage() ?></div>
<script>
loadjs.ready("fproduct_cart_badd", function() {
    fproduct_cart_badd.createAutoSuggest(Object.assign({"id":"x_rid","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->rid->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.product_cart_b.fields.rid.autoSuggestOptions));
});
</script>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type"<?= $Page->packing_type->rowAttributes() ?>>
        <label id="elh_product_cart_b_packing_type" for="x_packing_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->packing_type->caption() ?><?= $Page->packing_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->packing_type->cellAttributes() ?>>
<span id="el_product_cart_b_packing_type">
    <select
        id="x_packing_type"
        name="x_packing_type"
        class="form-select ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_type->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_badd_x_packing_type"
        <?php } ?>
        data-table="product_cart_b"
        data-field="x_packing_type"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x_packing_type") ?>
    </select>
    <?= $Page->packing_type->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage() ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x_packing_type") ?>
<?php if (!$Page->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_badd", function() {
    var options = { name: "x_packing_type", selectId: "fproduct_cart_badd_x_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_badd.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x_packing_type", form: "fproduct_cart_badd" };
    } else {
        options.ajax = { id: "x_packing_type", form: "fproduct_cart_badd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
    <div id="r_batch_no"<?= $Page->batch_no->rowAttributes() ?>>
        <label id="elh_product_cart_b_batch_no" for="x_batch_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->batch_no->caption() ?><?= $Page->batch_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->batch_no->cellAttributes() ?>>
<span id="el_product_cart_b_batch_no">
    <select
        id="x_batch_no"
        name="x_batch_no"
        class="form-control ew-select<?= $Page->batch_no->isInvalidClass() ?>"
        data-select2-id="fproduct_cart_badd_x_batch_no"
        data-table="product_cart_b"
        data-field="x_batch_no"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->batch_no->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->batch_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>"
        <?= $Page->batch_no->editAttributes() ?>>
        <?= $Page->batch_no->selectOptionListHtml("x_batch_no") ?>
    </select>
    <?= $Page->batch_no->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->batch_no->getErrorMessage() ?></div>
<?= $Page->batch_no->Lookup->getParamTag($Page, "p_x_batch_no") ?>
<script>
loadjs.ready("fproduct_cart_badd", function() {
    var options = { name: "x_batch_no", selectId: "fproduct_cart_badd_x_batch_no" };
    if (fproduct_cart_badd.lists.batch_no?.lookupOptions.length) {
        options.data = { id: "x_batch_no", form: "fproduct_cart_badd" };
    } else {
        options.ajax = { id: "x_batch_no", form: "fproduct_cart_badd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.product_cart_b.fields.batch_no.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->shape->Visible) { // shape ?>
    <div id="r_shape"<?= $Page->shape->rowAttributes() ?>>
        <label id="elh_product_cart_b_shape" for="x_shape" class="<?= $Page->LeftColumnClass ?>"><?= $Page->shape->caption() ?><?= $Page->shape->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->shape->cellAttributes() ?>>
<span id="el_product_cart_b_shape">
    <select
        id="x_shape"
        name="x_shape"
        class="form-select ew-select<?= $Page->shape->isInvalidClass() ?>"
        <?php if (!$Page->shape->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_badd_x_shape"
        <?php } ?>
        data-table="product_cart_b"
        data-field="x_shape"
        data-value-separator="<?= $Page->shape->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->shape->getPlaceHolder()) ?>"
        <?= $Page->shape->editAttributes() ?>>
        <?= $Page->shape->selectOptionListHtml("x_shape") ?>
    </select>
    <?= $Page->shape->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->shape->getErrorMessage() ?></div>
<?= $Page->shape->Lookup->getParamTag($Page, "p_x_shape") ?>
<?php if (!$Page->shape->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_badd", function() {
    var options = { name: "x_shape", selectId: "fproduct_cart_badd_x_shape" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_badd.lists.shape?.lookupOptions.length) {
        options.data = { id: "x_shape", form: "fproduct_cart_badd" };
    } else {
        options.ajax = { id: "x_shape", form: "fproduct_cart_badd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b.fields.shape.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->product_type->Visible) { // product_type ?>
    <div id="r_product_type"<?= $Page->product_type->rowAttributes() ?>>
        <label id="elh_product_cart_b_product_type" for="x_product_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->product_type->caption() ?><?= $Page->product_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->product_type->cellAttributes() ?>>
<span id="el_product_cart_b_product_type">
    <select
        id="x_product_type"
        name="x_product_type"
        class="form-select ew-select<?= $Page->product_type->isInvalidClass() ?>"
        <?php if (!$Page->product_type->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_badd_x_product_type"
        <?php } ?>
        data-table="product_cart_b"
        data-field="x_product_type"
        data-value-separator="<?= $Page->product_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product_type->getPlaceHolder()) ?>"
        <?= $Page->product_type->editAttributes() ?>>
        <?= $Page->product_type->selectOptionListHtml("x_product_type") ?>
    </select>
    <?= $Page->product_type->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->product_type->getErrorMessage() ?></div>
<?= $Page->product_type->Lookup->getParamTag($Page, "p_x_product_type") ?>
<?php if (!$Page->product_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_badd", function() {
    var options = { name: "x_product_type", selectId: "fproduct_cart_badd_x_product_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_badd.lists.product_type?.lookupOptions.length) {
        options.data = { id: "x_product_type", form: "fproduct_cart_badd" };
    } else {
        options.ajax = { id: "x_product_type", form: "fproduct_cart_badd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b.fields.product_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->unit->Visible) { // unit ?>
    <div id="r_unit"<?= $Page->unit->rowAttributes() ?>>
        <label id="elh_product_cart_b_unit" for="x_unit" class="<?= $Page->LeftColumnClass ?>"><?= $Page->unit->caption() ?><?= $Page->unit->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->unit->cellAttributes() ?>>
<span id="el_product_cart_b_unit">
    <select
        id="x_unit"
        name="x_unit"
        class="form-select ew-select<?= $Page->unit->isInvalidClass() ?>"
        <?php if (!$Page->unit->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_badd_x_unit"
        <?php } ?>
        data-table="product_cart_b"
        data-field="x_unit"
        data-value-separator="<?= $Page->unit->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->unit->getPlaceHolder()) ?>"
        <?= $Page->unit->editAttributes() ?>>
        <?= $Page->unit->selectOptionListHtml("x_unit") ?>
    </select>
    <?= $Page->unit->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->unit->getErrorMessage() ?></div>
<?php if (!$Page->unit->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_badd", function() {
    var options = { name: "x_unit", selectId: "fproduct_cart_badd_x_unit" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_badd.lists.unit?.lookupOptions.length) {
        options.data = { id: "x_unit", form: "fproduct_cart_badd" };
    } else {
        options.ajax = { id: "x_unit", form: "fproduct_cart_badd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b.fields.unit.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->w->Visible) { // w ?>
    <div id="r_w"<?= $Page->w->rowAttributes() ?>>
        <label id="elh_product_cart_b_w" for="x_w" class="<?= $Page->LeftColumnClass ?>"><?= $Page->w->caption() ?><?= $Page->w->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->w->cellAttributes() ?>>
<span id="el_product_cart_b_w">
<input type="<?= $Page->w->getInputTextType() ?>" name="x_w" id="x_w" data-table="product_cart_b" data-field="x_w" value="<?= $Page->w->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->w->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->w->formatPattern()) ?>"<?= $Page->w->editAttributes() ?> aria-describedby="x_w_help">
<?= $Page->w->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->w->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->w_cm->Visible) { // w_cm ?>
    <div id="r_w_cm"<?= $Page->w_cm->rowAttributes() ?>>
        <label id="elh_product_cart_b_w_cm" for="x_w_cm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->w_cm->caption() ?><?= $Page->w_cm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->w_cm->cellAttributes() ?>>
<span id="el_product_cart_b_w_cm">
<input type="<?= $Page->w_cm->getInputTextType() ?>" name="x_w_cm" id="x_w_cm" data-table="product_cart_b" data-field="x_w_cm" value="<?= $Page->w_cm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->w_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->w_cm->formatPattern()) ?>"<?= $Page->w_cm->editAttributes() ?> aria-describedby="x_w_cm_help">
<?= $Page->w_cm->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->w_cm->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->l->Visible) { // l ?>
    <div id="r_l"<?= $Page->l->rowAttributes() ?>>
        <label id="elh_product_cart_b_l" for="x_l" class="<?= $Page->LeftColumnClass ?>"><?= $Page->l->caption() ?><?= $Page->l->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->l->cellAttributes() ?>>
<span id="el_product_cart_b_l">
<input type="<?= $Page->l->getInputTextType() ?>" name="x_l" id="x_l" data-table="product_cart_b" data-field="x_l" value="<?= $Page->l->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->l->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->l->formatPattern()) ?>"<?= $Page->l->editAttributes() ?> aria-describedby="x_l_help">
<?= $Page->l->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->l->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->l_cm->Visible) { // l_cm ?>
    <div id="r_l_cm"<?= $Page->l_cm->rowAttributes() ?>>
        <label id="elh_product_cart_b_l_cm" for="x_l_cm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->l_cm->caption() ?><?= $Page->l_cm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->l_cm->cellAttributes() ?>>
<span id="el_product_cart_b_l_cm">
<input type="<?= $Page->l_cm->getInputTextType() ?>" name="x_l_cm" id="x_l_cm" data-table="product_cart_b" data-field="x_l_cm" value="<?= $Page->l_cm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->l_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->l_cm->formatPattern()) ?>"<?= $Page->l_cm->editAttributes() ?> aria-describedby="x_l_cm_help">
<?= $Page->l_cm->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->l_cm->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->h->Visible) { // h ?>
    <div id="r_h"<?= $Page->h->rowAttributes() ?>>
        <label id="elh_product_cart_b_h" for="x_h" class="<?= $Page->LeftColumnClass ?>"><?= $Page->h->caption() ?><?= $Page->h->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->h->cellAttributes() ?>>
<span id="el_product_cart_b_h">
<input type="<?= $Page->h->getInputTextType() ?>" name="x_h" id="x_h" data-table="product_cart_b" data-field="x_h" value="<?= $Page->h->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->h->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->h->formatPattern()) ?>"<?= $Page->h->editAttributes() ?> aria-describedby="x_h_help">
<?= $Page->h->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->h->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->h_cm->Visible) { // h_cm ?>
    <div id="r_h_cm"<?= $Page->h_cm->rowAttributes() ?>>
        <label id="elh_product_cart_b_h_cm" for="x_h_cm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->h_cm->caption() ?><?= $Page->h_cm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->h_cm->cellAttributes() ?>>
<span id="el_product_cart_b_h_cm">
<input type="<?= $Page->h_cm->getInputTextType() ?>" name="x_h_cm" id="x_h_cm" data-table="product_cart_b" data-field="x_h_cm" value="<?= $Page->h_cm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->h_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->h_cm->formatPattern()) ?>"<?= $Page->h_cm->editAttributes() ?> aria-describedby="x_h_cm_help">
<?= $Page->h_cm->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->h_cm->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->partner_size->Visible) { // partner_size ?>
    <div id="r_partner_size"<?= $Page->partner_size->rowAttributes() ?>>
        <label id="elh_product_cart_b_partner_size" for="x_partner_size" class="<?= $Page->LeftColumnClass ?>"><?= $Page->partner_size->caption() ?><?= $Page->partner_size->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->partner_size->cellAttributes() ?>>
<span id="el_product_cart_b_partner_size">
<input type="<?= $Page->partner_size->getInputTextType() ?>" name="x_partner_size" id="x_partner_size" data-table="product_cart_b" data-field="x_partner_size" value="<?= $Page->partner_size->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->partner_size->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->partner_size->formatPattern()) ?>"<?= $Page->partner_size->editAttributes() ?> aria-describedby="x_partner_size_help">
<?= $Page->partner_size->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->partner_size->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
    <div id="r_sqm"<?= $Page->sqm->rowAttributes() ?>>
        <label id="elh_product_cart_b_sqm" for="x_sqm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->sqm->caption() ?><?= $Page->sqm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->sqm->cellAttributes() ?>>
<span id="el_product_cart_b_sqm">
<input type="<?= $Page->sqm->getInputTextType() ?>" name="x_sqm" id="x_sqm" data-table="product_cart_b" data-field="x_sqm" value="<?= $Page->sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm->formatPattern()) ?>"<?= $Page->sqm->editAttributes() ?> aria-describedby="x_sqm_help">
<?= $Page->sqm->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->sqm->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->sqm_a->Visible) { // sqm_a ?>
    <div id="r_sqm_a"<?= $Page->sqm_a->rowAttributes() ?>>
        <label id="elh_product_cart_b_sqm_a" for="x_sqm_a" class="<?= $Page->LeftColumnClass ?>"><?= $Page->sqm_a->caption() ?><?= $Page->sqm_a->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->sqm_a->cellAttributes() ?>>
<span id="el_product_cart_b_sqm_a">
<input type="<?= $Page->sqm_a->getInputTextType() ?>" name="x_sqm_a" id="x_sqm_a" data-table="product_cart_b" data-field="x_sqm_a" value="<?= $Page->sqm_a->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sqm_a->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm_a->formatPattern()) ?>"<?= $Page->sqm_a->editAttributes() ?> aria-describedby="x_sqm_a_help">
<?= $Page->sqm_a->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->sqm_a->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity"<?= $Page->quantity->rowAttributes() ?>>
        <label id="elh_product_cart_b_quantity" for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><?= $Page->quantity->caption() ?><?= $Page->quantity->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->quantity->cellAttributes() ?>>
<span id="el_product_cart_b_quantity">
<input type="<?= $Page->quantity->getInputTextType() ?>" name="x_quantity" id="x_quantity" data-table="product_cart_b" data-field="x_quantity" value="<?= $Page->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity->formatPattern()) ?>"<?= $Page->quantity->editAttributes() ?> aria-describedby="x_quantity_help">
<?= $Page->quantity->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->quantity->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->image->Visible) { // image ?>
    <div id="r_image"<?= $Page->image->rowAttributes() ?>>
        <label id="elh_product_cart_b_image" class="<?= $Page->LeftColumnClass ?>"><?= $Page->image->caption() ?><?= $Page->image->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->image->cellAttributes() ?>>
<span id="el_product_cart_b_image">
<div id="fd_x_image" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x_image"
        name="x_image"
        class="form-control ew-file-input"
        title="<?= $Page->image->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="product_cart_b"
        data-field="x_image"
        data-size="250"
        data-accept-file-types="<?= $Page->image->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->image->UploadMaxFileSize ?>"
        data-max-number-of-files="<?= $Page->image->UploadMaxFileCount ?>"
        data-disable-image-crop="<?= $Page->image->ImageCropper ? 0 : 1 ?>"
        multiple
        aria-describedby="x_image_help"
        <?= ($Page->image->ReadOnly || $Page->image->Disabled) ? " disabled" : "" ?>
        <?= $Page->image->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFiles") ?></div>
    <?= $Page->image->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->image->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x_image" id= "fn_x_image" value="<?= $Page->image->Upload->FileName ?>">
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="0">
<table id="ft_x_image" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->price->Visible) { // price ?>
    <div id="r_price"<?= $Page->price->rowAttributes() ?>>
        <label id="elh_product_cart_b_price" for="x_price" class="<?= $Page->LeftColumnClass ?>"><?= $Page->price->caption() ?><?= $Page->price->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->price->cellAttributes() ?>>
<span id="el_product_cart_b_price">
<input type="<?= $Page->price->getInputTextType() ?>" name="x_price" id="x_price" data-table="product_cart_b" data-field="x_price" value="<?= $Page->price->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->price->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->price->formatPattern()) ?>"<?= $Page->price->editAttributes() ?> aria-describedby="x_price_help">
<?= $Page->price->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->price->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->currency->Visible) { // currency ?>
    <div id="r_currency"<?= $Page->currency->rowAttributes() ?>>
        <label id="elh_product_cart_b_currency" for="x_currency" class="<?= $Page->LeftColumnClass ?>"><?= $Page->currency->caption() ?><?= $Page->currency->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->currency->cellAttributes() ?>>
<span id="el_product_cart_b_currency">
    <select
        id="x_currency"
        name="x_currency"
        class="form-select ew-select<?= $Page->currency->isInvalidClass() ?>"
        <?php if (!$Page->currency->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_badd_x_currency"
        <?php } ?>
        data-table="product_cart_b"
        data-field="x_currency"
        data-value-separator="<?= $Page->currency->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->currency->getPlaceHolder()) ?>"
        <?= $Page->currency->editAttributes() ?>>
        <?= $Page->currency->selectOptionListHtml("x_currency") ?>
    </select>
    <?= $Page->currency->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->currency->getErrorMessage() ?></div>
<?= $Page->currency->Lookup->getParamTag($Page, "p_x_currency") ?>
<?php if (!$Page->currency->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_badd", function() {
    var options = { name: "x_currency", selectId: "fproduct_cart_badd_x_currency" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_badd.lists.currency?.lookupOptions.length) {
        options.data = { id: "x_currency", form: "fproduct_cart_badd" };
    } else {
        options.ajax = { id: "x_currency", form: "fproduct_cart_badd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b.fields.currency.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
    <div id="r_amount"<?= $Page->amount->rowAttributes() ?>>
        <label id="elh_product_cart_b_amount" for="x_amount" class="<?= $Page->LeftColumnClass ?>"><?= $Page->amount->caption() ?><?= $Page->amount->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->amount->cellAttributes() ?>>
<span id="el_product_cart_b_amount">
<input type="<?= $Page->amount->getInputTextType() ?>" name="x_amount" id="x_amount" data-table="product_cart_b" data-field="x_amount" value="<?= $Page->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?> aria-describedby="x_amount_help">
<?= $Page->amount->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->shipping_charge->Visible) { // shipping_charge ?>
    <div id="r_shipping_charge"<?= $Page->shipping_charge->rowAttributes() ?>>
        <label id="elh_product_cart_b_shipping_charge" for="x_shipping_charge" class="<?= $Page->LeftColumnClass ?>"><?= $Page->shipping_charge->caption() ?><?= $Page->shipping_charge->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->shipping_charge->cellAttributes() ?>>
<span id="el_product_cart_b_shipping_charge">
<input type="<?= $Page->shipping_charge->getInputTextType() ?>" name="x_shipping_charge" id="x_shipping_charge" data-table="product_cart_b" data-field="x_shipping_charge" value="<?= $Page->shipping_charge->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->shipping_charge->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->shipping_charge->formatPattern()) ?>"<?= $Page->shipping_charge->editAttributes() ?> aria-describedby="x_shipping_charge_help">
<?= $Page->shipping_charge->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->shipping_charge->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->additional_discount->Visible) { // additional_discount ?>
    <div id="r_additional_discount"<?= $Page->additional_discount->rowAttributes() ?>>
        <label id="elh_product_cart_b_additional_discount" for="x_additional_discount" class="<?= $Page->LeftColumnClass ?>"><?= $Page->additional_discount->caption() ?><?= $Page->additional_discount->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->additional_discount->cellAttributes() ?>>
<span id="el_product_cart_b_additional_discount">
<input type="<?= $Page->additional_discount->getInputTextType() ?>" name="x_additional_discount" id="x_additional_discount" data-table="product_cart_b" data-field="x_additional_discount" value="<?= $Page->additional_discount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->additional_discount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->additional_discount->formatPattern()) ?>"<?= $Page->additional_discount->editAttributes() ?> aria-describedby="x_additional_discount_help">
<?= $Page->additional_discount->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->additional_discount->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->buyer_uid->Visible) { // buyer_uid ?>
    <div id="r_buyer_uid"<?= $Page->buyer_uid->rowAttributes() ?>>
        <label id="elh_product_cart_b_buyer_uid" for="x_buyer_uid" class="<?= $Page->LeftColumnClass ?>"><?= $Page->buyer_uid->caption() ?><?= $Page->buyer_uid->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->buyer_uid->cellAttributes() ?>>
<span id="el_product_cart_b_buyer_uid">
<textarea data-table="product_cart_b" data-field="x_buyer_uid" name="x_buyer_uid" id="x_buyer_uid" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->buyer_uid->getPlaceHolder()) ?>"<?= $Page->buyer_uid->editAttributes() ?> aria-describedby="x_buyer_uid_help"><?= $Page->buyer_uid->EditValue ?></textarea>
<?= $Page->buyer_uid->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->buyer_uid->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->buyer_loc->Visible) { // buyer_loc ?>
    <div id="r_buyer_loc"<?= $Page->buyer_loc->rowAttributes() ?>>
        <label id="elh_product_cart_b_buyer_loc" for="x_buyer_loc" class="<?= $Page->LeftColumnClass ?>"><?= $Page->buyer_loc->caption() ?><?= $Page->buyer_loc->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->buyer_loc->cellAttributes() ?>>
<span id="el_product_cart_b_buyer_loc">
<textarea data-table="product_cart_b" data-field="x_buyer_loc" name="x_buyer_loc" id="x_buyer_loc" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->buyer_loc->getPlaceHolder()) ?>"<?= $Page->buyer_loc->editAttributes() ?> aria-describedby="x_buyer_loc_help"><?= $Page->buyer_loc->EditValue ?></textarea>
<?= $Page->buyer_loc->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->buyer_loc->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->label->Visible) { // label ?>
    <div id="r_label"<?= $Page->label->rowAttributes() ?>>
        <label id="elh_product_cart_b_label" for="x_label" class="<?= $Page->LeftColumnClass ?>"><?= $Page->label->caption() ?><?= $Page->label->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->label->cellAttributes() ?>>
<span id="el_product_cart_b_label">
<textarea data-table="product_cart_b" data-field="x_label" name="x_label" id="x_label" cols="35" rows="2" placeholder="<?= HtmlEncode($Page->label->getPlaceHolder()) ?>"<?= $Page->label->editAttributes() ?> aria-describedby="x_label_help"><?= $Page->label->EditValue ?></textarea>
<?= $Page->label->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->label->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <label id="elh_product_cart_b_remarks" for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->remarks->caption() ?><?= $Page->remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->remarks->cellAttributes() ?>>
<span id="el_product_cart_b_remarks">
<textarea data-table="product_cart_b" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="35" rows="2" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>"<?= $Page->remarks->editAttributes() ?> aria-describedby="x_remarks_help"><?= $Page->remarks->EditValue ?></textarea>
<?= $Page->remarks->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fproduct_cart_badd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fproduct_cart_badd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("product_cart_b");
});
</script>
<script>
loadjs.ready("load", function () {
    // Startup script
    // Write your table-specific startup script here
    // document.write("page loaded");
    	  	$("#r_sqm_a").hide();
    		var ID = getURL('id');
    		if (ID > 0)
    		{
    			var SGrp = $("#x_s_grp").val();
    			document.cookie = "s_grp="+SGrp+";path=/";
    			if (SGrp.length > 0)
    			{
    			$.getJSON(window.location.origin +"/apcajax?getHead="+SGrp,function(data){
    						if (data.calculation_method == '1') {
    						$("#elh_product_cart_b_price").html('Price / SQM');}
    						else if (data.calculation_method == '11') {
    						$("#elh_product_cart_b_price").html('Price / SKU');}
    						else if (data.calculation_method == '21') {
    						$("#elh_product_cart_b_price").html('Price / KG');}
    						if (data.pc_shape == '--NA--') {
    						$("#x_shape").val('');
    						$("#r_shape").hide(); } else {
    						$("#r_shape").show();}
    						if (data.pc_unit == '--NA--') {
    						$("#x_unit").val(1);
    						$("#r_unit").hide(); } else {
    						$("#r_unit").show();}			 		
    						if (data.pc_w == '--NA--') {
    						$("#x_w").val(0);
    						$("#x_w_cm").val(0);
    						$("#r_w").hide();					
    						$("#r_w_cm").hide();
    						} else {
    						$("#r_w").show();
    						$("#r_w_cm").show();}
    						if (data.pc_l == '--NA--') {
    						$("#x_l").val(0);
    						$("#x_l_cm").val(0);
    						$("#r_l").hide();					
    						$("#r_l_cm").hide();
    						} else {
    						$("#r_l").show();
    						$("#r_l_cm").show();}					
    						if (data.pc_h == '--NA--') {
    						$("#x_h").val(0);
    						$("#x_h_cm").val(0);
    						$("#r_h").hide();					
    						$("#r_h_cm").hide();
    						} else {
    						$("#r_h").show();
    						$("#r_h_cm").show();}
    						if (data.pc_partner_size == '--NA--') {
    						$("#x_partner_size").val('');
    						$("#r_partner_size").hide(); } else {
    						$("#r_partner_size").show();}
    						if (data.pc_sqm == '--NA--') {
    						$("#x_sqm").val(0);
    						$("#r_sqm").hide(); } else {
    						$("#r_sqm").show();}
    						if (data.pc_01_head == '--NA--') {
    						$("#x__1").val('');
    						$("#r__1").hide(); } else {
    						$("#r__1").show();					
    						$("#elh_product_cart_b__1").html(data.pc_01_head);}
    						if (data.pc_02_head == '--NA--') {
    						$("#x__2").val('');
    						$("#r__2").hide(); } else {
    						$("#r__2").show();					
    						$("#elh_product_cart_b__2").html(data.pc_02_head);}
    						if (data.pc_03_head == '--NA--') {
    						$("#x__3").val('');
    						$("#r__3").hide(); } else {
    						$("#r__3").show();					
    						$("#elh_product_cart_b__3").html(data.pc_03_head);}
    						if (data.pc_04_head == '--NA--') {
    						$("#x__4").val('');
    						$("#r__4").hide(); } else {
    						$("#r__4").show();					
    						$("#elh_product_cart_b__4").html(data.pc_04_head);}
    						if (data.pc_05_head == '--NA--') {
    						$("#x__5").val('');
    						$("#r__5").hide(); } else {
    						$("#r__5").show();					
    						$("#elh_product_cart_b__5").html(data.pc_05_head);}
    						if (data.pc_06_head == '--NA--') {
    						$("#x__6").val('');
    						$("#r__6").hide(); } else {
    						$("#r__6").show();					
    						$("#elh_product_cart_b__6").html(data.pc_06_head);}
    						if (data.pc_07_head == '--NA--') {
    						$("#x__7").val('');
    						$("#r__7").hide(); } else {
    						$("#r__7").show();					
    						$("#elh_product_cart_b__7").html(data.pc_07_head);}
    						if (data.pc_08_head == '--NA--') {
    						$("#x__8").val('');
    						$("#r__8").hide(); } else {
    						$("#r__8").show();					
    						$("#elh_product_cart_b__8").html(data.pc_08_head);}
    				});
    			} else {
    						$("#r_sqm").hide();
    						//$("#r_product_type").hide();
    						$("#r_shape").hide();
    						$("#r_unit").hide();
    						$("#r_w").hide();
    						$("#r_w_cm").hide();
    						$("#r_l").hide();
    						$("#r_l_cm").hide();
    						$("#r_h").hide();
    						$("#r_h_cm").hide();
    						$("#r_partner_size").hide();
    						$("#r__1").hide();
    						$("#r__2").hide();
    						$("#r__3").hide();
    						$("#r__4").hide();
    						$("#r__5").hide();
    						$("#r__6").hide();
    						$("#r__7").hide();
    						$("#r__8").hide();					
    						$("#elh_product_cart_s_price").html('Price')
    			}
    		}
    					$.getJSON(window.location.origin +"/apcajax?pdbyepass=9",function(data) {
    			 		if (data == '2') {$("#r_batch_no").hide();}});
});
</script>
