<?php

namespace PHPMaker2024\fibre;

// Page object
$ProcessYeildSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { process_yeild: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fprocess_yeildsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fprocess_yeildsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["po", [ew.Validators.integer], fields.po.isInvalid],
            ["product_code", [], fields.product_code.isInvalid],
            ["process", [], fields.process.isInvalid],
            ["yeild", [ew.Validators.float], fields.yeild.isInvalid],
            ["jc_yeild", [ew.Validators.float], fields.jc_yeild.isInvalid],
            ["cart_quantity", [ew.Validators.integer], fields.cart_quantity.isInvalid],
            ["pam_qty", [ew.Validators.float], fields.pam_qty.isInvalid],
            ["pp_qty", [ew.Validators.float], fields.pp_qty.isInvalid],
            ["packing_type", [ew.Validators.integer], fields.packing_type.isInvalid],
            ["batch_no", [], fields.batch_no.isInvalid],
            ["issue_to", [], fields.issue_to.isInvalid],
            ["jc_no", [ew.Validators.integer], fields.jc_no.isInvalid],
            ["jc_quantity", [ew.Validators.float], fields.jc_quantity.isInvalid],
            ["despatch_week", [], fields.despatch_week.isInvalid],
            ["company_id", [], fields.company_id.isInvalid],
            ["par_com", [ew.Validators.integer], fields.par_com.isInvalid],
            ["last_processing_date", [ew.Validators.datetime(fields.last_processing_date.clientFormatPattern)], fields.last_processing_date.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "process": <?= $Page->process->toClientList($Page) ?>,
            "batch_no": <?= $Page->batch_no->toClientList($Page) ?>,
            "issue_to": <?= $Page->issue_to->toClientList($Page) ?>,
            "despatch_week": <?= $Page->despatch_week->toClientList($Page) ?>,
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fprocess_yeildsearch" id="fprocess_yeildsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="process_yeild">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_yeild_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_yeild_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="process_yeild" data-field="x_id" value="<?= $Page->id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
    <div id="r_po" class="row"<?= $Page->po->rowAttributes() ?>>
        <label for="x_po" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_yeild_po"><?= $Page->po->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_po" id="z_po" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_yeild_po" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->po->getInputTextType() ?>" name="x_po" id="x_po" data-table="process_yeild" data-field="x_po" value="<?= $Page->po->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product_code->Visible) { // product_code ?>
    <div id="r_product_code" class="row"<?= $Page->product_code->rowAttributes() ?>>
        <label for="x_product_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_yeild_product_code"><?= $Page->product_code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_product_code" id="z_product_code" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product_code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_yeild_product_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->product_code->getInputTextType() ?>" name="x_product_code" id="x_product_code" data-table="process_yeild" data-field="x_product_code" value="<?= $Page->product_code->EditValue ?>" size="30" maxlength="355" placeholder="<?= HtmlEncode($Page->product_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->product_code->formatPattern()) ?>"<?= $Page->product_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->product_code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->process->Visible) { // process ?>
    <div id="r_process" class="row"<?= $Page->process->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_yeild_process"><?= $Page->process->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_process" id="z_process" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->process->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_yeild_process" class="ew-search-field ew-search-field-single">
    <select
        id="x_process[]"
        name="x_process[]"
        class="form-control ew-select<?= $Page->process->isInvalidClass() ?>"
        data-select2-id="fprocess_yeildsearch_x_process[]"
        data-table="process_yeild"
        data-field="x_process"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->process->caption())) ?>"
        data-modal-lookup="true"
        multiple
        size="1"
        data-value-separator="<?= $Page->process->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process->getPlaceHolder()) ?>"
        <?= $Page->process->editAttributes() ?>>
        <?= $Page->process->selectOptionListHtml("x_process[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->process->getErrorMessage(false) ?></div>
<?= $Page->process->Lookup->getParamTag($Page, "p_x_process") ?>
<script>
loadjs.ready("fprocess_yeildsearch", function() {
    var options = { name: "x_process[]", selectId: "fprocess_yeildsearch_x_process[]" };
    options.multiple = true;
    if (fprocess_yeildsearch.lists.process?.lookupOptions.length) {
        options.data = { id: "x_process[]", form: "fprocess_yeildsearch" };
    } else {
        options.ajax = { id: "x_process[]", form: "fprocess_yeildsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.process_yeild.fields.process.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->yeild->Visible) { // yeild ?>
    <div id="r_yeild" class="row"<?= $Page->yeild->rowAttributes() ?>>
        <label for="x_yeild" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_yeild_yeild"><?= $Page->yeild->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_yeild" id="z_yeild" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->yeild->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_yeild_yeild" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->yeild->getInputTextType() ?>" name="x_yeild" id="x_yeild" data-table="process_yeild" data-field="x_yeild" value="<?= $Page->yeild->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->yeild->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->yeild->formatPattern()) ?>"<?= $Page->yeild->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->yeild->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->jc_yeild->Visible) { // jc_yeild ?>
    <div id="r_jc_yeild" class="row"<?= $Page->jc_yeild->rowAttributes() ?>>
        <label for="x_jc_yeild" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_yeild_jc_yeild"><?= $Page->jc_yeild->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_jc_yeild" id="z_jc_yeild" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->jc_yeild->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_yeild_jc_yeild" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->jc_yeild->getInputTextType() ?>" name="x_jc_yeild" id="x_jc_yeild" data-table="process_yeild" data-field="x_jc_yeild" value="<?= $Page->jc_yeild->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->jc_yeild->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->jc_yeild->formatPattern()) ?>"<?= $Page->jc_yeild->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->jc_yeild->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->cart_quantity->Visible) { // cart_quantity ?>
    <div id="r_cart_quantity" class="row"<?= $Page->cart_quantity->rowAttributes() ?>>
        <label for="x_cart_quantity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_yeild_cart_quantity"><?= $Page->cart_quantity->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_cart_quantity" id="z_cart_quantity" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->cart_quantity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_yeild_cart_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->cart_quantity->getInputTextType() ?>" name="x_cart_quantity" id="x_cart_quantity" data-table="process_yeild" data-field="x_cart_quantity" value="<?= $Page->cart_quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->cart_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cart_quantity->formatPattern()) ?>"<?= $Page->cart_quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->cart_quantity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pam_qty->Visible) { // pam_qty ?>
    <div id="r_pam_qty" class="row"<?= $Page->pam_qty->rowAttributes() ?>>
        <label for="x_pam_qty" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_yeild_pam_qty"><?= $Page->pam_qty->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pam_qty" id="z_pam_qty" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pam_qty->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_yeild_pam_qty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pam_qty->getInputTextType() ?>" name="x_pam_qty" id="x_pam_qty" data-table="process_yeild" data-field="x_pam_qty" value="<?= $Page->pam_qty->EditValue ?>" size="30" maxlength="32" placeholder="<?= HtmlEncode($Page->pam_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pam_qty->formatPattern()) ?>"<?= $Page->pam_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pam_qty->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pp_qty->Visible) { // pp_qty ?>
    <div id="r_pp_qty" class="row"<?= $Page->pp_qty->rowAttributes() ?>>
        <label for="x_pp_qty" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_yeild_pp_qty"><?= $Page->pp_qty->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pp_qty" id="z_pp_qty" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pp_qty->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_yeild_pp_qty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pp_qty->getInputTextType() ?>" name="x_pp_qty" id="x_pp_qty" data-table="process_yeild" data-field="x_pp_qty" value="<?= $Page->pp_qty->EditValue ?>" size="30" maxlength="33" placeholder="<?= HtmlEncode($Page->pp_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pp_qty->formatPattern()) ?>"<?= $Page->pp_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pp_qty->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type" class="row"<?= $Page->packing_type->rowAttributes() ?>>
        <label for="x_packing_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_yeild_packing_type"><?= $Page->packing_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packing_type" id="z_packing_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packing_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_yeild_packing_type" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->packing_type->getInputTextType() ?>" name="x_packing_type" id="x_packing_type" data-table="process_yeild" data-field="x_packing_type" value="<?= $Page->packing_type->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->packing_type->formatPattern()) ?>"<?= $Page->packing_type->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
    <div id="r_batch_no" class="row"<?= $Page->batch_no->rowAttributes() ?>>
        <label for="x_batch_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_yeild_batch_no"><?= $Page->batch_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_batch_no" id="z_batch_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->batch_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_yeild_batch_no" class="ew-search-field ew-search-field-single">
    <select
        id="x_batch_no"
        name="x_batch_no"
        class="form-select ew-select<?= $Page->batch_no->isInvalidClass() ?>"
        <?php if (!$Page->batch_no->IsNativeSelect) { ?>
        data-select2-id="fprocess_yeildsearch_x_batch_no"
        <?php } ?>
        data-table="process_yeild"
        data-field="x_batch_no"
        data-value-separator="<?= $Page->batch_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>"
        <?= $Page->batch_no->editAttributes() ?>>
        <?= $Page->batch_no->selectOptionListHtml("x_batch_no") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->batch_no->getErrorMessage(false) ?></div>
<?= $Page->batch_no->Lookup->getParamTag($Page, "p_x_batch_no") ?>
<?php if (!$Page->batch_no->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_yeildsearch", function() {
    var options = { name: "x_batch_no", selectId: "fprocess_yeildsearch_x_batch_no" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_yeildsearch.lists.batch_no?.lookupOptions.length) {
        options.data = { id: "x_batch_no", form: "fprocess_yeildsearch" };
    } else {
        options.ajax = { id: "x_batch_no", form: "fprocess_yeildsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_yeild.fields.batch_no.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->issue_to->Visible) { // issue_to ?>
    <div id="r_issue_to" class="row"<?= $Page->issue_to->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_yeild_issue_to"><?= $Page->issue_to->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_issue_to" id="z_issue_to" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->issue_to->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_yeild_issue_to" class="ew-search-field ew-search-field-single">
    <select
        id="x_issue_to"
        name="x_issue_to"
        class="form-control ew-select<?= $Page->issue_to->isInvalidClass() ?>"
        data-select2-id="fprocess_yeildsearch_x_issue_to"
        data-table="process_yeild"
        data-field="x_issue_to"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->issue_to->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->issue_to->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->issue_to->getPlaceHolder()) ?>"
        <?= $Page->issue_to->editAttributes() ?>>
        <?= $Page->issue_to->selectOptionListHtml("x_issue_to") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->issue_to->getErrorMessage(false) ?></div>
<?= $Page->issue_to->Lookup->getParamTag($Page, "p_x_issue_to") ?>
<script>
loadjs.ready("fprocess_yeildsearch", function() {
    var options = { name: "x_issue_to", selectId: "fprocess_yeildsearch_x_issue_to" };
    if (fprocess_yeildsearch.lists.issue_to?.lookupOptions.length) {
        options.data = { id: "x_issue_to", form: "fprocess_yeildsearch" };
    } else {
        options.ajax = { id: "x_issue_to", form: "fprocess_yeildsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.process_yeild.fields.issue_to.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->jc_no->Visible) { // jc_no ?>
    <div id="r_jc_no" class="row"<?= $Page->jc_no->rowAttributes() ?>>
        <label for="x_jc_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_yeild_jc_no"><?= $Page->jc_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_jc_no" id="z_jc_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->jc_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_yeild_jc_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->jc_no->getInputTextType() ?>" name="x_jc_no" id="x_jc_no" data-table="process_yeild" data-field="x_jc_no" value="<?= $Page->jc_no->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->jc_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->jc_no->formatPattern()) ?>"<?= $Page->jc_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->jc_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->jc_quantity->Visible) { // jc_quantity ?>
    <div id="r_jc_quantity" class="row"<?= $Page->jc_quantity->rowAttributes() ?>>
        <label for="x_jc_quantity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_yeild_jc_quantity"><?= $Page->jc_quantity->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_jc_quantity" id="z_jc_quantity" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->jc_quantity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_yeild_jc_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->jc_quantity->getInputTextType() ?>" name="x_jc_quantity" id="x_jc_quantity" data-table="process_yeild" data-field="x_jc_quantity" value="<?= $Page->jc_quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->jc_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->jc_quantity->formatPattern()) ?>"<?= $Page->jc_quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->jc_quantity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->despatch_week->Visible) { // despatch_week ?>
    <div id="r_despatch_week" class="row"<?= $Page->despatch_week->rowAttributes() ?>>
        <label for="x_despatch_week" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_yeild_despatch_week"><?= $Page->despatch_week->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_despatch_week" id="z_despatch_week" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->despatch_week->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_yeild_despatch_week" class="ew-search-field ew-search-field-single">
    <select
        id="x_despatch_week"
        name="x_despatch_week"
        class="form-select ew-select<?= $Page->despatch_week->isInvalidClass() ?>"
        <?php if (!$Page->despatch_week->IsNativeSelect) { ?>
        data-select2-id="fprocess_yeildsearch_x_despatch_week"
        <?php } ?>
        data-table="process_yeild"
        data-field="x_despatch_week"
        data-value-separator="<?= $Page->despatch_week->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->despatch_week->getPlaceHolder()) ?>"
        <?= $Page->despatch_week->editAttributes() ?>>
        <?= $Page->despatch_week->selectOptionListHtml("x_despatch_week") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->despatch_week->getErrorMessage(false) ?></div>
<?= $Page->despatch_week->Lookup->getParamTag($Page, "p_x_despatch_week") ?>
<?php if (!$Page->despatch_week->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_yeildsearch", function() {
    var options = { name: "x_despatch_week", selectId: "fprocess_yeildsearch_x_despatch_week" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_yeildsearch.lists.despatch_week?.lookupOptions.length) {
        options.data = { id: "x_despatch_week", form: "fprocess_yeildsearch" };
    } else {
        options.ajax = { id: "x_despatch_week", form: "fprocess_yeildsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_yeild.fields.despatch_week.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
    <div id="r_company_id" class="row"<?= $Page->company_id->rowAttributes() ?>>
        <label for="x_company_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_yeild_company_id"><?= $Page->company_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_company_id" id="z_company_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->company_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_yeild_company_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_company_id"
        name="x_company_id"
        class="form-select ew-select<?= $Page->company_id->isInvalidClass() ?>"
        <?php if (!$Page->company_id->IsNativeSelect) { ?>
        data-select2-id="fprocess_yeildsearch_x_company_id"
        <?php } ?>
        data-table="process_yeild"
        data-field="x_company_id"
        data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>"
        <?= $Page->company_id->editAttributes() ?>>
        <?= $Page->company_id->selectOptionListHtml("x_company_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->company_id->getErrorMessage(false) ?></div>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
<?php if (!$Page->company_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_yeildsearch", function() {
    var options = { name: "x_company_id", selectId: "fprocess_yeildsearch_x_company_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_yeildsearch.lists.company_id?.lookupOptions.length) {
        options.data = { id: "x_company_id", form: "fprocess_yeildsearch" };
    } else {
        options.ajax = { id: "x_company_id", form: "fprocess_yeildsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_yeild.fields.company_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->par_com->Visible) { // par_com ?>
    <div id="r_par_com" class="row"<?= $Page->par_com->rowAttributes() ?>>
        <label for="x_par_com" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_yeild_par_com"><?= $Page->par_com->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_par_com" id="z_par_com" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->par_com->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_yeild_par_com" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->par_com->getInputTextType() ?>" name="x_par_com" id="x_par_com" data-table="process_yeild" data-field="x_par_com" value="<?= $Page->par_com->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->par_com->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->par_com->formatPattern()) ?>"<?= $Page->par_com->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->par_com->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->last_processing_date->Visible) { // last_processing_date ?>
    <div id="r_last_processing_date" class="row"<?= $Page->last_processing_date->rowAttributes() ?>>
        <label for="x_last_processing_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_yeild_last_processing_date"><?= $Page->last_processing_date->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_last_processing_date" id="z_last_processing_date" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->last_processing_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_yeild_last_processing_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->last_processing_date->getInputTextType() ?>" name="x_last_processing_date" id="x_last_processing_date" data-table="process_yeild" data-field="x_last_processing_date" value="<?= $Page->last_processing_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->last_processing_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->last_processing_date->formatPattern()) ?>"<?= $Page->last_processing_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->last_processing_date->getErrorMessage(false) ?></div>
<?php if (!$Page->last_processing_date->ReadOnly && !$Page->last_processing_date->Disabled && !isset($Page->last_processing_date->EditAttrs["readonly"]) && !isset($Page->last_processing_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprocess_yeildsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprocess_yeildsearch", "x_last_processing_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fprocess_yeildsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fprocess_yeildsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fprocess_yeildsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("process_yeild");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
