<?php

namespace PHPMaker2024\fibre;

// Page object
$ProcessYeildSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { process_yeild: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fprocess_yeildsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fprocess_yeildsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["po", [ew.Validators.integer], fields.po.isInvalid],
            ["product_code", [], fields.product_code.isInvalid],
            ["process", [], fields.process.isInvalid],
            ["yeild", [ew.Validators.float], fields.yeild.isInvalid],
            ["jc_yeild", [ew.Validators.float], fields.jc_yeild.isInvalid],
            ["cart_quantity", [ew.Validators.integer], fields.cart_quantity.isInvalid],
            ["pam_qty", [ew.Validators.float], fields.pam_qty.isInvalid],
            ["pp_qty", [ew.Validators.float], fields.pp_qty.isInvalid],
            ["packing_type", [ew.Validators.integer], fields.packing_type.isInvalid],
            ["batch_no", [], fields.batch_no.isInvalid],
            ["issue_to", [], fields.issue_to.isInvalid],
            ["jc_no", [ew.Validators.integer], fields.jc_no.isInvalid],
            ["jc_quantity", [ew.Validators.float], fields.jc_quantity.isInvalid],
            ["despatch_week", [], fields.despatch_week.isInvalid],
            ["company_id", [], fields.company_id.isInvalid],
            ["par_com", [ew.Validators.integer], fields.par_com.isInvalid],
            ["last_processing_date", [ew.Validators.datetime(fields.last_processing_date.clientFormatPattern)], fields.last_processing_date.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setQueryBuilderLists({
            "process": <?= $Page->process->toClientList($Page) ?>,
            "batch_no": <?= $Page->batch_no->toClientList($Page) ?>,
            "issue_to": <?= $Page->issue_to->toClientList($Page) ?>,
            "despatch_week": <?= $Page->despatch_week->toClientList($Page) ?>,
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fprocess_yeildsearch" id="fprocess_yeildsearch" class="<?= $Page->FormClassName ?>" action="<?= HtmlEncode(GetUrl("processyeildlist")) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="process_yeild">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<input type="hidden" name="rules" value="<?= HtmlEncode($Page->getSessionRules()) ?>">
<template id="tpx_process_yeild_id" class="process_yeildsearch"><span id="el_process_yeild_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="process_yeild" data-field="x_id" value="<?= $Page->id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_process_yeild_po" class="process_yeildsearch"><span id="el_process_yeild_po" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->po->getInputTextType() ?>" name="x_po" id="x_po" data-table="process_yeild" data-field="x_po" value="<?= $Page->po->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_process_yeild_product_code" class="process_yeildsearch"><span id="el_process_yeild_product_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->product_code->getInputTextType() ?>" name="x_product_code" id="x_product_code" data-table="process_yeild" data-field="x_product_code" value="<?= $Page->product_code->EditValue ?>" size="30" maxlength="355" placeholder="<?= HtmlEncode($Page->product_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->product_code->formatPattern()) ?>"<?= $Page->product_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->product_code->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_process_yeild_process" class="process_yeildsearch"><span id="el_process_yeild_process" class="ew-search-field ew-search-field-single">
    <select
        id="x_process[]"
        name="x_process[]"
        class="form-control ew-select<?= $Page->process->isInvalidClass() ?>"
        data-select2-id="fprocess_yeildsearch_x_process[]"
        data-table="process_yeild"
        data-field="x_process"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->process->caption())) ?>"
        data-modal-lookup="true"
        multiple
        size="1"
        data-value-separator="<?= $Page->process->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process->getPlaceHolder()) ?>"
        <?= $Page->process->editAttributes() ?>>
        <?= $Page->process->selectOptionListHtml("x_process[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->process->getErrorMessage(false) ?></div>
<?= $Page->process->Lookup->getParamTag($Page, "p_x_process") ?>
<script>
loadjs.ready("fprocess_yeildsearch", function() {
    var options = { name: "x_process[]", selectId: "fprocess_yeildsearch_x_process[]" };
    options.multiple = true;
    if (fprocess_yeildsearch.lists.process?.lookupOptions.length) {
        options.data = { id: "x_process[]", form: "fprocess_yeildsearch" };
    } else {
        options.ajax = { id: "x_process[]", form: "fprocess_yeildsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.process_yeild.fields.process.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span></template>
<template id="tpx_process_yeild_yeild" class="process_yeildsearch"><span id="el_process_yeild_yeild" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->yeild->getInputTextType() ?>" name="x_yeild" id="x_yeild" data-table="process_yeild" data-field="x_yeild" value="<?= $Page->yeild->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->yeild->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->yeild->formatPattern()) ?>"<?= $Page->yeild->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->yeild->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_process_yeild_jc_yeild" class="process_yeildsearch"><span id="el_process_yeild_jc_yeild" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->jc_yeild->getInputTextType() ?>" name="x_jc_yeild" id="x_jc_yeild" data-table="process_yeild" data-field="x_jc_yeild" value="<?= $Page->jc_yeild->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->jc_yeild->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->jc_yeild->formatPattern()) ?>"<?= $Page->jc_yeild->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->jc_yeild->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_process_yeild_cart_quantity" class="process_yeildsearch"><span id="el_process_yeild_cart_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->cart_quantity->getInputTextType() ?>" name="x_cart_quantity" id="x_cart_quantity" data-table="process_yeild" data-field="x_cart_quantity" value="<?= $Page->cart_quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->cart_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cart_quantity->formatPattern()) ?>"<?= $Page->cart_quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->cart_quantity->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_process_yeild_pam_qty" class="process_yeildsearch"><span id="el_process_yeild_pam_qty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pam_qty->getInputTextType() ?>" name="x_pam_qty" id="x_pam_qty" data-table="process_yeild" data-field="x_pam_qty" value="<?= $Page->pam_qty->EditValue ?>" size="30" maxlength="32" placeholder="<?= HtmlEncode($Page->pam_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pam_qty->formatPattern()) ?>"<?= $Page->pam_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pam_qty->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_process_yeild_pp_qty" class="process_yeildsearch"><span id="el_process_yeild_pp_qty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pp_qty->getInputTextType() ?>" name="x_pp_qty" id="x_pp_qty" data-table="process_yeild" data-field="x_pp_qty" value="<?= $Page->pp_qty->EditValue ?>" size="30" maxlength="33" placeholder="<?= HtmlEncode($Page->pp_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pp_qty->formatPattern()) ?>"<?= $Page->pp_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pp_qty->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_process_yeild_packing_type" class="process_yeildsearch"><span id="el_process_yeild_packing_type" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->packing_type->getInputTextType() ?>" name="x_packing_type" id="x_packing_type" data-table="process_yeild" data-field="x_packing_type" value="<?= $Page->packing_type->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->packing_type->formatPattern()) ?>"<?= $Page->packing_type->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_process_yeild_batch_no" class="process_yeildsearch"><span id="el_process_yeild_batch_no" class="ew-search-field ew-search-field-single">
    <select
        id="x_batch_no"
        name="x_batch_no"
        class="form-select ew-select<?= $Page->batch_no->isInvalidClass() ?>"
        <?php if (!$Page->batch_no->IsNativeSelect) { ?>
        data-select2-id="fprocess_yeildsearch_x_batch_no"
        <?php } ?>
        data-table="process_yeild"
        data-field="x_batch_no"
        data-value-separator="<?= $Page->batch_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>"
        <?= $Page->batch_no->editAttributes() ?>>
        <?= $Page->batch_no->selectOptionListHtml("x_batch_no") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->batch_no->getErrorMessage(false) ?></div>
<?= $Page->batch_no->Lookup->getParamTag($Page, "p_x_batch_no") ?>
<?php if (!$Page->batch_no->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_yeildsearch", function() {
    var options = { name: "x_batch_no", selectId: "fprocess_yeildsearch_x_batch_no" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_yeildsearch.lists.batch_no?.lookupOptions.length) {
        options.data = { id: "x_batch_no", form: "fprocess_yeildsearch" };
    } else {
        options.ajax = { id: "x_batch_no", form: "fprocess_yeildsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_yeild.fields.batch_no.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_process_yeild_issue_to" class="process_yeildsearch"><span id="el_process_yeild_issue_to" class="ew-search-field ew-search-field-single">
    <select
        id="x_issue_to"
        name="x_issue_to"
        class="form-control ew-select<?= $Page->issue_to->isInvalidClass() ?>"
        data-select2-id="fprocess_yeildsearch_x_issue_to"
        data-table="process_yeild"
        data-field="x_issue_to"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->issue_to->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->issue_to->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->issue_to->getPlaceHolder()) ?>"
        <?= $Page->issue_to->editAttributes() ?>>
        <?= $Page->issue_to->selectOptionListHtml("x_issue_to") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->issue_to->getErrorMessage(false) ?></div>
<?= $Page->issue_to->Lookup->getParamTag($Page, "p_x_issue_to") ?>
<script>
loadjs.ready("fprocess_yeildsearch", function() {
    var options = { name: "x_issue_to", selectId: "fprocess_yeildsearch_x_issue_to" };
    if (fprocess_yeildsearch.lists.issue_to?.lookupOptions.length) {
        options.data = { id: "x_issue_to", form: "fprocess_yeildsearch" };
    } else {
        options.ajax = { id: "x_issue_to", form: "fprocess_yeildsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.process_yeild.fields.issue_to.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span></template>
<template id="tpx_process_yeild_jc_no" class="process_yeildsearch"><span id="el_process_yeild_jc_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->jc_no->getInputTextType() ?>" name="x_jc_no" id="x_jc_no" data-table="process_yeild" data-field="x_jc_no" value="<?= $Page->jc_no->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->jc_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->jc_no->formatPattern()) ?>"<?= $Page->jc_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->jc_no->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_process_yeild_jc_quantity" class="process_yeildsearch"><span id="el_process_yeild_jc_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->jc_quantity->getInputTextType() ?>" name="x_jc_quantity" id="x_jc_quantity" data-table="process_yeild" data-field="x_jc_quantity" value="<?= $Page->jc_quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->jc_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->jc_quantity->formatPattern()) ?>"<?= $Page->jc_quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->jc_quantity->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_process_yeild_despatch_week" class="process_yeildsearch"><span id="el_process_yeild_despatch_week" class="ew-search-field ew-search-field-single">
    <select
        id="x_despatch_week"
        name="x_despatch_week"
        class="form-select ew-select<?= $Page->despatch_week->isInvalidClass() ?>"
        <?php if (!$Page->despatch_week->IsNativeSelect) { ?>
        data-select2-id="fprocess_yeildsearch_x_despatch_week"
        <?php } ?>
        data-table="process_yeild"
        data-field="x_despatch_week"
        data-value-separator="<?= $Page->despatch_week->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->despatch_week->getPlaceHolder()) ?>"
        <?= $Page->despatch_week->editAttributes() ?>>
        <?= $Page->despatch_week->selectOptionListHtml("x_despatch_week") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->despatch_week->getErrorMessage(false) ?></div>
<?= $Page->despatch_week->Lookup->getParamTag($Page, "p_x_despatch_week") ?>
<?php if (!$Page->despatch_week->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_yeildsearch", function() {
    var options = { name: "x_despatch_week", selectId: "fprocess_yeildsearch_x_despatch_week" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_yeildsearch.lists.despatch_week?.lookupOptions.length) {
        options.data = { id: "x_despatch_week", form: "fprocess_yeildsearch" };
    } else {
        options.ajax = { id: "x_despatch_week", form: "fprocess_yeildsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_yeild.fields.despatch_week.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_process_yeild_company_id" class="process_yeildsearch"><span id="el_process_yeild_company_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_company_id"
        name="x_company_id"
        class="form-select ew-select<?= $Page->company_id->isInvalidClass() ?>"
        <?php if (!$Page->company_id->IsNativeSelect) { ?>
        data-select2-id="fprocess_yeildsearch_x_company_id"
        <?php } ?>
        data-table="process_yeild"
        data-field="x_company_id"
        data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>"
        <?= $Page->company_id->editAttributes() ?>>
        <?= $Page->company_id->selectOptionListHtml("x_company_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->company_id->getErrorMessage(false) ?></div>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
<?php if (!$Page->company_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_yeildsearch", function() {
    var options = { name: "x_company_id", selectId: "fprocess_yeildsearch_x_company_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_yeildsearch.lists.company_id?.lookupOptions.length) {
        options.data = { id: "x_company_id", form: "fprocess_yeildsearch" };
    } else {
        options.ajax = { id: "x_company_id", form: "fprocess_yeildsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_yeild.fields.company_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_process_yeild_par_com" class="process_yeildsearch"><span id="el_process_yeild_par_com" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->par_com->getInputTextType() ?>" name="x_par_com" id="x_par_com" data-table="process_yeild" data-field="x_par_com" value="<?= $Page->par_com->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->par_com->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->par_com->formatPattern()) ?>"<?= $Page->par_com->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->par_com->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_process_yeild_last_processing_date" class="process_yeildsearch"><span id="el_process_yeild_last_processing_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->last_processing_date->getInputTextType() ?>" name="x_last_processing_date" id="x_last_processing_date" data-table="process_yeild" data-field="x_last_processing_date" value="<?= $Page->last_processing_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->last_processing_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->last_processing_date->formatPattern()) ?>"<?= $Page->last_processing_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->last_processing_date->getErrorMessage(false) ?></div>
<?php if (!$Page->last_processing_date->ReadOnly && !$Page->last_processing_date->Disabled && !isset($Page->last_processing_date->EditAttrs["readonly"]) && !isset($Page->last_processing_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprocess_yeildsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprocess_yeildsearch", "x_last_processing_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span></template>
<div id="process_yeild_query_builder" class="query-builder mb-3"></div>
<div class="btn-group mb-3 query-btn-group"></div>
<button type="button" id="btn-view-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("View", true)) ?>"><i class="fa-solid fa-eye ew-icon"></i></button>
<button type="button" id="btn-clear-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("Clear", true)) ?>"><i class="fa-solid fa-xmark ew-icon"></i></button>
<script>
// Filter builder
loadjs.ready(["wrapper", "head"], () => {
    let filters = [
            {
                id: "id",
                type: "integer",
                label: currentTable.fields.id.caption,
                operators: currentTable.fields.id.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fprocess_yeildsearch.fields.id.validators),
                data: {
                    format: currentTable.fields.id.clientFormatPattern
                }
            },
            {
                id: "po",
                type: "string",
                label: currentTable.fields.po.caption,
                operators: currentTable.fields.po.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fprocess_yeildsearch.fields.po.validators),
                data: {
                    format: currentTable.fields.po.clientFormatPattern
                }
            },
            {
                id: "product_code",
                type: "string",
                label: currentTable.fields.product_code.caption,
                operators: currentTable.fields.product_code.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fprocess_yeildsearch.fields.product_code.validators),
                data: {
                    format: currentTable.fields.product_code.clientFormatPattern
                }
            },
            {
                id: "process",
                type: "string",
                label: currentTable.fields.process.caption,
                operators: currentTable.fields.process.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                multiple: true,
                validation: ew.getQueryBuilderFilterValidation(fprocess_yeildsearch.fields.process.validators),
                data: {
                    format: currentTable.fields.process.clientFormatPattern
                }
            },
            {
                id: "yeild",
                type: "double",
                label: currentTable.fields.yeild.caption,
                operators: currentTable.fields.yeild.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fprocess_yeildsearch.fields.yeild.validators),
                data: {
                    format: currentTable.fields.yeild.clientFormatPattern
                }
            },
            {
                id: "jc_yeild",
                type: "double",
                label: currentTable.fields.jc_yeild.caption,
                operators: currentTable.fields.jc_yeild.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fprocess_yeildsearch.fields.jc_yeild.validators),
                data: {
                    format: currentTable.fields.jc_yeild.clientFormatPattern
                }
            },
            {
                id: "cart_quantity",
                type: "double",
                label: currentTable.fields.cart_quantity.caption,
                operators: currentTable.fields.cart_quantity.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fprocess_yeildsearch.fields.cart_quantity.validators),
                data: {
                    format: currentTable.fields.cart_quantity.clientFormatPattern
                }
            },
            {
                id: "pam_qty",
                type: "string",
                label: currentTable.fields.pam_qty.caption,
                operators: currentTable.fields.pam_qty.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fprocess_yeildsearch.fields.pam_qty.validators),
                data: {
                    format: currentTable.fields.pam_qty.clientFormatPattern
                }
            },
            {
                id: "pp_qty",
                type: "string",
                label: currentTable.fields.pp_qty.caption,
                operators: currentTable.fields.pp_qty.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fprocess_yeildsearch.fields.pp_qty.validators),
                data: {
                    format: currentTable.fields.pp_qty.clientFormatPattern
                }
            },
            {
                id: "packing_type",
                type: "string",
                label: currentTable.fields.packing_type.caption,
                operators: currentTable.fields.packing_type.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fprocess_yeildsearch.fields.packing_type.validators),
                data: {
                    format: currentTable.fields.packing_type.clientFormatPattern
                }
            },
            {
                id: "batch_no",
                type: "string",
                label: currentTable.fields.batch_no.caption,
                operators: currentTable.fields.batch_no.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fprocess_yeildsearch.fields.batch_no.validators),
                data: {
                    format: currentTable.fields.batch_no.clientFormatPattern
                }
            },
            {
                id: "issue_to",
                type: "double",
                label: currentTable.fields.issue_to.caption,
                operators: currentTable.fields.issue_to.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fprocess_yeildsearch.fields.issue_to.validators),
                data: {
                    format: currentTable.fields.issue_to.clientFormatPattern
                }
            },
            {
                id: "jc_no",
                type: "string",
                label: currentTable.fields.jc_no.caption,
                operators: currentTable.fields.jc_no.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fprocess_yeildsearch.fields.jc_no.validators),
                data: {
                    format: currentTable.fields.jc_no.clientFormatPattern
                }
            },
            {
                id: "jc_quantity",
                type: "double",
                label: currentTable.fields.jc_quantity.caption,
                operators: currentTable.fields.jc_quantity.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fprocess_yeildsearch.fields.jc_quantity.validators),
                data: {
                    format: currentTable.fields.jc_quantity.clientFormatPattern
                }
            },
            {
                id: "despatch_week",
                type: "string",
                label: currentTable.fields.despatch_week.caption,
                operators: currentTable.fields.despatch_week.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fprocess_yeildsearch.fields.despatch_week.validators),
                data: {
                    format: currentTable.fields.despatch_week.clientFormatPattern
                }
            },
            {
                id: "company_id",
                type: "double",
                label: currentTable.fields.company_id.caption,
                operators: currentTable.fields.company_id.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fprocess_yeildsearch.fields.company_id.validators),
                data: {
                    format: currentTable.fields.company_id.clientFormatPattern
                }
            },
            {
                id: "par_com",
                type: "integer",
                label: currentTable.fields.par_com.caption,
                operators: currentTable.fields.par_com.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fprocess_yeildsearch.fields.par_com.validators),
                data: {
                    format: currentTable.fields.par_com.clientFormatPattern
                }
            },
            {
                id: "last_processing_date",
                type: "datetime",
                label: currentTable.fields.last_processing_date.caption,
                operators: currentTable.fields.last_processing_date.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fprocess_yeildsearch.fields.last_processing_date.validators),
                data: {
                    format: currentTable.fields.last_processing_date.clientFormatPattern
                }
            },
        ],
        $ = jQuery,
        $qb = $("#process_yeild_query_builder"),
        args = {},
        rules = ew.parseJson($("#fprocess_yeildsearch input[name=rules]").val()),
        queryBuilderOptions = Object.assign({}, ew.queryBuilderOptions),
        allowViewRules = queryBuilderOptions.allowViewRules,
        allowClearRules = queryBuilderOptions.allowClearRules,
        hasRules = group => Array.isArray(group?.rules) && group.rules.length > 0,
        getRules = () => $qb.queryBuilder("getRules", { skip_empty: true }),
        getSql = () => $qb.queryBuilder("getSQL", false, false, rules)?.sql;
    delete queryBuilderOptions.allowViewRules;
    delete queryBuilderOptions.allowClearRules;
    args.options = ew.deepAssign({
        plugins: Object.assign({}, ew.queryBuilderPlugins),
        lang: ew.language.phrase("querybuilderjs"),
        select_placeholder: ew.language.phrase("PleaseSelect"),
        inputs_separator: `<div class="d-inline-flex ms-2 me-2">${ew.language.phrase("AND")}</div>`, // For "between"
        filters,
        rules
    }, queryBuilderOptions);
    $qb.trigger("querybuilder", [args]);
    $qb.queryBuilder(args.options).on("rulesChanged.queryBuilder", () => {
        let rules = getRules();
        !ew.DEBUG || console.log(rules, getSql());
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").toggleClass("disabled", !rules);
    }).on("afterCreateRuleInput.queryBuilder", function(e, rule) {
        let select = rule.$el.find(".rule-value-container").find("selection-list, select")[0];
        if (select) { // Selection list
            let id = select.dataset.field.replace("^x_", ""),
                form = ew.forms.get(select);
            form.updateList(select, undefined, undefined, true); // Update immediately
        }
    });
    $("#fprocess_yeildsearch").on("beforesubmit", function () {
        this.rules.value = JSON.stringify(getRules());
    });
    $("#btn-reset").toggleClass("d-none", false).on("click", () => {
        hasRules(rules) ? $qb.queryBuilder("setRules", rules) : $qb.queryBuilder("reset");
        return false;
    });
    $("#btn-action").toggleClass("d-none", false);
    if (allowClearRules) {
        $("#btn-clear-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => $qb.queryBuilder("reset"));
    }
    if (allowViewRules) {
        $("#btn-view-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => {
            let rules = getRules();
            if (hasRules(rules)) {
                let sql = getSql();
                ew.alert(sql ? '<pre class="text-start fs-6">' + sql + '</pre>' : '', "dark");
                !ew.DEBUG || console.log(rules, sql);
            } else {
                ew.alert(ew.language.phrase("EmptyLabel"));
            }
        });
    }
    $(".query-btn-group").toggleClass(".mb-3", $(".query-btn-group").find(".btn:not(.d-none)").length);
    if (hasRules(rules)) { // Enable buttons if rules exist initially
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").removeClass("disabled");
    }
});
</script>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn d-none disabled" name="btn-action" id="btn-action" type="submit" form="fprocess_yeildsearch" formaction="<?= HtmlEncode(GetUrl("processyeildlist")) ?>" data-ajax="<?= $Page->UseAjaxActions ? "true" : "false" ?>"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fprocess_yeildsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn d-none disabled" name="btn-reset" id="btn-reset" type="button" form="fprocess_yeildsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("process_yeild");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
