<?php

namespace PHPMaker2024\fibre;

// Page object
$ProcessTableOldList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { process_table_old: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fprocess_table_oldsrch" id="fprocess_table_oldsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fprocess_table_oldsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { process_table_old: currentTable } });
var currentForm;
var fprocess_table_oldsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fprocess_table_oldsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["ref", [], fields.ref.isInvalid],
            ["product_processed", [ew.Validators.integer], fields.product_processed.isInvalid],
            ["rid", [], fields.rid.isInvalid],
            ["packing_type", [], fields.packing_type.isInvalid],
            ["godown", [], fields.godown.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "ref": <?= $Page->ref->toClientList($Page) ?>,
            "product_processed": <?= $Page->product_processed->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
            "godown": <?= $Page->godown->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->ref->Visible) { // ref ?>
<?php
if (!$Page->ref->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_ref" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->ref->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->ref->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_ref" id="z_ref" value="LIKE">
</div>
        </div>
        <div id="el_process_table_old_ref" class="ew-search-field">
    <select
        id="x_ref"
        name="x_ref"
        class="form-control ew-select<?= $Page->ref->isInvalidClass() ?>"
        data-select2-id="fprocess_table_oldsrch_x_ref"
        data-table="process_table_old"
        data-field="x_ref"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->ref->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->ref->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ref->getPlaceHolder()) ?>"
        <?= $Page->ref->editAttributes() ?>>
        <?= $Page->ref->selectOptionListHtml("x_ref") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->ref->getErrorMessage(false) ?></div>
<?= $Page->ref->Lookup->getParamTag($Page, "p_x_ref") ?>
<script>
loadjs.ready("fprocess_table_oldsrch", function() {
    var options = { name: "x_ref", selectId: "fprocess_table_oldsrch_x_ref" };
    if (fprocess_table_oldsrch.lists.ref?.lookupOptions.length) {
        options.data = { id: "x_ref", form: "fprocess_table_oldsrch" };
    } else {
        options.ajax = { id: "x_ref", form: "fprocess_table_oldsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.process_table_old.fields.ref.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->product_processed->Visible) { // product_processed ?>
<?php
if (!$Page->product_processed->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_product_processed" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->product_processed->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->product_processed->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product_processed" id="z_product_processed" value="=">
</div>
        </div>
        <div id="el_process_table_old_product_processed" class="ew-search-field">
<?php
if (IsRTL()) {
    $Page->product_processed->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_product_processed" class="ew-auto-suggest">
    <input type="<?= $Page->product_processed->getInputTextType() ?>" class="form-control" name="sv_x_product_processed" id="sv_x_product_processed" value="<?= RemoveHtml($Page->product_processed->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->product_processed->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->product_processed->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->product_processed->formatPattern()) ?>"<?= $Page->product_processed->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="process_table_old" data-field="x_product_processed" data-input="sv_x_product_processed" data-value-separator="<?= $Page->product_processed->displayValueSeparatorAttribute() ?>" name="x_product_processed" id="x_product_processed" value="<?= HtmlEncode($Page->product_processed->AdvancedSearch->SearchValue) ?>" data-ew-action="update-options"></selection-list>
<div class="invalid-feedback"><?= $Page->product_processed->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fprocess_table_oldsrch", function() {
    fprocess_table_oldsrch.createAutoSuggest(Object.assign({"id":"x_product_processed","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->product_processed->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.process_table_old.fields.product_processed.autoSuggestOptions));
});
</script>
<?= $Page->product_processed->Lookup->getParamTag($Page, "p_x_product_processed") ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
<?php
if (!$Page->rid->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_rid" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->rid->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->rid->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_rid" id="z_rid" value="LIKE">
</div>
        </div>
        <div id="el_process_table_old_rid" class="ew-search-field">
<?php
if (IsRTL()) {
    $Page->rid->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_rid" class="ew-auto-suggest">
    <input type="<?= $Page->rid->getInputTextType() ?>" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?= RemoveHtml($Page->rid->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rid->formatPattern()) ?>"<?= $Page->rid->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="process_table_old" data-field="x_rid" data-input="sv_x_rid" data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?= HtmlEncode($Page->rid->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->rid->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fprocess_table_oldsrch", function() {
    fprocess_table_oldsrch.createAutoSuggest(Object.assign({"id":"x_rid","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->rid->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.process_table_old.fields.rid.autoSuggestOptions));
});
</script>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
<?php
if (!$Page->packing_type->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_packing_type" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->packing_type->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_packing_type" class="ew-search-caption ew-label"><?= $Page->packing_type->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_packing_type" id="z_packing_type" value="LIKE">
</div>
        </div>
        <div id="el_process_table_old_packing_type" class="ew-search-field">
    <select
        id="x_packing_type"
        name="x_packing_type"
        class="form-select ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_type->IsNativeSelect) { ?>
        data-select2-id="fprocess_table_oldsrch_x_packing_type"
        <?php } ?>
        data-table="process_table_old"
        data-field="x_packing_type"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage(false) ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x_packing_type") ?>
<?php if (!$Page->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_table_oldsrch", function() {
    var options = { name: "x_packing_type", selectId: "fprocess_table_oldsrch_x_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_table_oldsrch.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x_packing_type", form: "fprocess_table_oldsrch" };
    } else {
        options.ajax = { id: "x_packing_type", form: "fprocess_table_oldsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_table_old.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->godown->Visible) { // godown ?>
<?php
if (!$Page->godown->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_godown" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->godown->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_godown" class="ew-search-caption ew-label"><?= $Page->godown->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_godown" id="z_godown" value="=">
</div>
        </div>
        <div id="el_process_table_old_godown" class="ew-search-field">
    <select
        id="x_godown"
        name="x_godown"
        class="form-select ew-select<?= $Page->godown->isInvalidClass() ?>"
        <?php if (!$Page->godown->IsNativeSelect) { ?>
        data-select2-id="fprocess_table_oldsrch_x_godown"
        <?php } ?>
        data-table="process_table_old"
        data-field="x_godown"
        data-value-separator="<?= $Page->godown->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->godown->getPlaceHolder()) ?>"
        <?= $Page->godown->editAttributes() ?>>
        <?= $Page->godown->selectOptionListHtml("x_godown") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->godown->getErrorMessage(false) ?></div>
<?= $Page->godown->Lookup->getParamTag($Page, "p_x_godown") ?>
<?php if (!$Page->godown->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_table_oldsrch", function() {
    var options = { name: "x_godown", selectId: "fprocess_table_oldsrch_x_godown" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_table_oldsrch.lists.godown?.lookupOptions.length) {
        options.data = { id: "x_godown", form: "fprocess_table_oldsrch" };
    } else {
        options.ajax = { id: "x_godown", form: "fprocess_table_oldsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_table_old.fields.godown.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fprocess_table_oldsrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fprocess_table_oldsrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fprocess_table_oldsrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fprocess_table_oldsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fprocess_table_oldsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fprocess_table_oldsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fprocess_table_oldsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="process_table_old">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_process_table_old" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_process_table_oldlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_process_table_old_id" class="process_table_old_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->type->Visible) { // type ?>
        <th data-name="type" class="<?= $Page->type->headerCellClass() ?>"><div id="elh_process_table_old_type" class="process_table_old_type"><?= $Page->renderFieldHeader($Page->type) ?></div></th>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
        <th data-name="company_id" class="<?= $Page->company_id->headerCellClass() ?>"><div id="elh_process_table_old_company_id" class="process_table_old_company_id"><?= $Page->renderFieldHeader($Page->company_id) ?></div></th>
<?php } ?>
<?php if ($Page->partner->Visible) { // partner ?>
        <th data-name="partner" class="<?= $Page->partner->headerCellClass() ?>"><div id="elh_process_table_old_partner" class="process_table_old_partner"><?= $Page->renderFieldHeader($Page->partner) ?></div></th>
<?php } ?>
<?php if ($Page->ref->Visible) { // ref ?>
        <th data-name="ref" class="<?= $Page->ref->headerCellClass() ?>"><div id="elh_process_table_old_ref" class="process_table_old_ref"><?= $Page->renderFieldHeader($Page->ref) ?></div></th>
<?php } ?>
<?php if ($Page->ref_internal->Visible) { // ref_internal ?>
        <th data-name="ref_internal" class="<?= $Page->ref_internal->headerCellClass() ?>"><div id="elh_process_table_old_ref_internal" class="process_table_old_ref_internal"><?= $Page->renderFieldHeader($Page->ref_internal) ?></div></th>
<?php } ?>
<?php if ($Page->product_processed->Visible) { // product_processed ?>
        <th data-name="product_processed" class="<?= $Page->product_processed->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_process_table_old_product_processed" class="process_table_old_product_processed"><?= $Page->renderFieldHeader($Page->product_processed) ?></div></th>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
        <th data-name="rid" class="<?= $Page->rid->headerCellClass() ?>"><div id="elh_process_table_old_rid" class="process_table_old_rid"><?= $Page->renderFieldHeader($Page->rid) ?></div></th>
<?php } ?>
<?php if ($Page->packets->Visible) { // packets ?>
        <th data-name="packets" class="<?= $Page->packets->headerCellClass() ?>"><div id="elh_process_table_old_packets" class="process_table_old_packets"><?= $Page->renderFieldHeader($Page->packets) ?></div></th>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
        <th data-name="quantity" class="<?= $Page->quantity->headerCellClass() ?>"><div id="elh_process_table_old_quantity" class="process_table_old_quantity"><?= $Page->renderFieldHeader($Page->quantity) ?></div></th>
<?php } ?>
<?php if ($Page->tmp_lot->Visible) { // tmp_lot ?>
        <th data-name="tmp_lot" class="<?= $Page->tmp_lot->headerCellClass() ?>"><div id="elh_process_table_old_tmp_lot" class="process_table_old_tmp_lot"><?= $Page->renderFieldHeader($Page->tmp_lot) ?></div></th>
<?php } ?>
<?php if ($Page->par_com->Visible) { // par_com ?>
        <th data-name="par_com" class="<?= $Page->par_com->headerCellClass() ?>"><div id="elh_process_table_old_par_com" class="process_table_old_par_com"><?= $Page->renderFieldHeader($Page->par_com) ?></div></th>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
        <th data-name="packing_type" class="<?= $Page->packing_type->headerCellClass() ?>"><div id="elh_process_table_old_packing_type" class="process_table_old_packing_type"><?= $Page->renderFieldHeader($Page->packing_type) ?></div></th>
<?php } ?>
<?php if ($Page->godown->Visible) { // godown ?>
        <th data-name="godown" class="<?= $Page->godown->headerCellClass() ?>"><div id="elh_process_table_old_godown" class="process_table_old_godown"><?= $Page->renderFieldHeader($Page->godown) ?></div></th>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
        <th data-name="dated" class="<?= $Page->dated->headerCellClass() ?>"><div id="elh_process_table_old_dated" class="process_table_old_dated"><?= $Page->renderFieldHeader($Page->dated) ?></div></th>
<?php } ?>
<?php if ($Page->employee_id->Visible) { // employee_id ?>
        <th data-name="employee_id" class="<?= $Page->employee_id->headerCellClass() ?>"><div id="elh_process_table_old_employee_id" class="process_table_old_employee_id"><?= $Page->renderFieldHeader($Page->employee_id) ?></div></th>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Page->operator->headerCellClass() ?>"><div id="elh_process_table_old_operator" class="process_table_old_operator"><?= $Page->renderFieldHeader($Page->operator) ?></div></th>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Page->datetime->headerCellClass() ?>"><div id="elh_process_table_old_datetime" class="process_table_old_datetime"><?= $Page->renderFieldHeader($Page->datetime) ?></div></th>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
        <th data-name="remarks" class="<?= $Page->remarks->headerCellClass() ?>"><div id="elh_process_table_old_remarks" class="process_table_old_remarks"><?= $Page->renderFieldHeader($Page->remarks) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_table_old_id" class="el_process_table_old_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->type->Visible) { // type ?>
        <td data-name="type"<?= $Page->type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_table_old_type" class="el_process_table_old_type">
<span<?= $Page->type->viewAttributes() ?>>
<?= $Page->type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->company_id->Visible) { // company_id ?>
        <td data-name="company_id"<?= $Page->company_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_table_old_company_id" class="el_process_table_old_company_id">
<span<?= $Page->company_id->viewAttributes() ?>>
<?= $Page->company_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->partner->Visible) { // partner ?>
        <td data-name="partner"<?= $Page->partner->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_table_old_partner" class="el_process_table_old_partner">
<span<?= $Page->partner->viewAttributes() ?>>
<?= $Page->partner->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ref->Visible) { // ref ?>
        <td data-name="ref"<?= $Page->ref->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_table_old_ref" class="el_process_table_old_ref">
<span<?= $Page->ref->viewAttributes() ?>>
<?= $Page->ref->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ref_internal->Visible) { // ref_internal ?>
        <td data-name="ref_internal"<?= $Page->ref_internal->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_table_old_ref_internal" class="el_process_table_old_ref_internal">
<span<?= $Page->ref_internal->viewAttributes() ?>>
<?= $Page->ref_internal->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->product_processed->Visible) { // product_processed ?>
        <td data-name="product_processed"<?= $Page->product_processed->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_table_old_product_processed" class="el_process_table_old_product_processed">
<span<?= $Page->product_processed->viewAttributes() ?>>
<?= $Page->product_processed->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->rid->Visible) { // rid ?>
        <td data-name="rid"<?= $Page->rid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_table_old_rid" class="el_process_table_old_rid">
<span<?= $Page->rid->viewAttributes() ?>>
<?php if (!EmptyString($Page->rid->getViewValue()) && $Page->rid->linkAttributes() != "") { ?>
<a<?= $Page->rid->linkAttributes() ?>><?= $Page->rid->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->packets->Visible) { // packets ?>
        <td data-name="packets"<?= $Page->packets->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_table_old_packets" class="el_process_table_old_packets">
<span<?= $Page->packets->viewAttributes() ?>>
<?= $Page->packets->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->quantity->Visible) { // quantity ?>
        <td data-name="quantity"<?= $Page->quantity->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_table_old_quantity" class="el_process_table_old_quantity">
<span<?= $Page->quantity->viewAttributes() ?>>
<?= $Page->quantity->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->tmp_lot->Visible) { // tmp_lot ?>
        <td data-name="tmp_lot"<?= $Page->tmp_lot->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_table_old_tmp_lot" class="el_process_table_old_tmp_lot">
<span<?= $Page->tmp_lot->viewAttributes() ?>>
<?= $Page->tmp_lot->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->par_com->Visible) { // par_com ?>
        <td data-name="par_com"<?= $Page->par_com->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_table_old_par_com" class="el_process_table_old_par_com">
<span<?= $Page->par_com->viewAttributes() ?>>
<?= $Page->par_com->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->packing_type->Visible) { // packing_type ?>
        <td data-name="packing_type"<?= $Page->packing_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_table_old_packing_type" class="el_process_table_old_packing_type">
<span<?= $Page->packing_type->viewAttributes() ?>>
<?php if (!EmptyString($Page->packing_type->getViewValue()) && $Page->packing_type->linkAttributes() != "") { ?>
<a<?= $Page->packing_type->linkAttributes() ?>><?= $Page->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->godown->Visible) { // godown ?>
        <td data-name="godown"<?= $Page->godown->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_table_old_godown" class="el_process_table_old_godown">
<span<?= $Page->godown->viewAttributes() ?>>
<?php if (!EmptyString($Page->godown->getViewValue()) && $Page->godown->linkAttributes() != "") { ?>
<a<?= $Page->godown->linkAttributes() ?>><?= $Page->godown->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->dated->Visible) { // dated ?>
        <td data-name="dated"<?= $Page->dated->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_table_old_dated" class="el_process_table_old_dated">
<span<?= $Page->dated->viewAttributes() ?>>
<?= $Page->dated->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->employee_id->Visible) { // employee_id ?>
        <td data-name="employee_id"<?= $Page->employee_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_table_old_employee_id" class="el_process_table_old_employee_id">
<span<?= $Page->employee_id->viewAttributes() ?>>
<?php if (!EmptyString($Page->employee_id->getViewValue()) && $Page->employee_id->linkAttributes() != "") { ?>
<a<?= $Page->employee_id->linkAttributes() ?>><?= $Page->employee_id->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->employee_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_table_old_operator" class="el_process_table_old_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_table_old_datetime" class="el_process_table_old_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->remarks->Visible) { // remarks ?>
        <td data-name="remarks"<?= $Page->remarks->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_table_old_remarks" class="el_process_table_old_remarks">
<span<?= $Page->remarks->viewAttributes() ?>>
<?= $Page->remarks->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Page->RowType = RowType::AGGREGATE;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->TotalRecords > 0 && !$Page->isGridAdd() && !$Page->isGridEdit() && !$Page->isMultiEdit()) { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (footer, left)
$Page->ListOptions->render("footer", "left");
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id" class="<?= $Page->id->footerCellClass() ?>"><span id="elf_process_table_old_id" class="process_table_old_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->type->Visible) { // type ?>
        <td data-name="type" class="<?= $Page->type->footerCellClass() ?>"><span id="elf_process_table_old_type" class="process_table_old_type">
        </span></td>
    <?php } ?>
    <?php if ($Page->company_id->Visible) { // company_id ?>
        <td data-name="company_id" class="<?= $Page->company_id->footerCellClass() ?>"><span id="elf_process_table_old_company_id" class="process_table_old_company_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->partner->Visible) { // partner ?>
        <td data-name="partner" class="<?= $Page->partner->footerCellClass() ?>"><span id="elf_process_table_old_partner" class="process_table_old_partner">
        </span></td>
    <?php } ?>
    <?php if ($Page->ref->Visible) { // ref ?>
        <td data-name="ref" class="<?= $Page->ref->footerCellClass() ?>"><span id="elf_process_table_old_ref" class="process_table_old_ref">
        </span></td>
    <?php } ?>
    <?php if ($Page->ref_internal->Visible) { // ref_internal ?>
        <td data-name="ref_internal" class="<?= $Page->ref_internal->footerCellClass() ?>"><span id="elf_process_table_old_ref_internal" class="process_table_old_ref_internal">
        </span></td>
    <?php } ?>
    <?php if ($Page->product_processed->Visible) { // product_processed ?>
        <td data-name="product_processed" class="<?= $Page->product_processed->footerCellClass() ?>"><span id="elf_process_table_old_product_processed" class="process_table_old_product_processed">
        </span></td>
    <?php } ?>
    <?php if ($Page->rid->Visible) { // rid ?>
        <td data-name="rid" class="<?= $Page->rid->footerCellClass() ?>"><span id="elf_process_table_old_rid" class="process_table_old_rid">
        </span></td>
    <?php } ?>
    <?php if ($Page->packets->Visible) { // packets ?>
        <td data-name="packets" class="<?= $Page->packets->footerCellClass() ?>"><span id="elf_process_table_old_packets" class="process_table_old_packets">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->packets->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->quantity->Visible) { // quantity ?>
        <td data-name="quantity" class="<?= $Page->quantity->footerCellClass() ?>"><span id="elf_process_table_old_quantity" class="process_table_old_quantity">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->quantity->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->tmp_lot->Visible) { // tmp_lot ?>
        <td data-name="tmp_lot" class="<?= $Page->tmp_lot->footerCellClass() ?>"><span id="elf_process_table_old_tmp_lot" class="process_table_old_tmp_lot">
        </span></td>
    <?php } ?>
    <?php if ($Page->par_com->Visible) { // par_com ?>
        <td data-name="par_com" class="<?= $Page->par_com->footerCellClass() ?>"><span id="elf_process_table_old_par_com" class="process_table_old_par_com">
        </span></td>
    <?php } ?>
    <?php if ($Page->packing_type->Visible) { // packing_type ?>
        <td data-name="packing_type" class="<?= $Page->packing_type->footerCellClass() ?>"><span id="elf_process_table_old_packing_type" class="process_table_old_packing_type">
        </span></td>
    <?php } ?>
    <?php if ($Page->godown->Visible) { // godown ?>
        <td data-name="godown" class="<?= $Page->godown->footerCellClass() ?>"><span id="elf_process_table_old_godown" class="process_table_old_godown">
        </span></td>
    <?php } ?>
    <?php if ($Page->dated->Visible) { // dated ?>
        <td data-name="dated" class="<?= $Page->dated->footerCellClass() ?>"><span id="elf_process_table_old_dated" class="process_table_old_dated">
        </span></td>
    <?php } ?>
    <?php if ($Page->employee_id->Visible) { // employee_id ?>
        <td data-name="employee_id" class="<?= $Page->employee_id->footerCellClass() ?>"><span id="elf_process_table_old_employee_id" class="process_table_old_employee_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator" class="<?= $Page->operator->footerCellClass() ?>"><span id="elf_process_table_old_operator" class="process_table_old_operator">
        </span></td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime" class="<?= $Page->datetime->footerCellClass() ?>"><span id="elf_process_table_old_datetime" class="process_table_old_datetime">
        </span></td>
    <?php } ?>
    <?php if ($Page->remarks->Visible) { // remarks ?>
        <td data-name="remarks" class="<?= $Page->remarks->footerCellClass() ?>"><span id="elf_process_table_old_remarks" class="process_table_old_remarks">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Page->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("process_table_old");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
