<?php

namespace PHPMaker2024\fibre;

// Page object
$ProcessTableHsList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { process_table_hs: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fprocess_table_hssrch" id="fprocess_table_hssrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fprocess_table_hssrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { process_table_hs: currentTable } });
var currentForm;
var fprocess_table_hssrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fprocess_table_hssrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["ref", [ew.Validators.integer], fields.ref.isInvalid],
            ["rid", [ew.Validators.integer], fields.rid.isInvalid],
            ["batch_no", [ew.Validators.integer], fields.batch_no.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->ref->Visible) { // ref ?>
<?php
if (!$Page->ref->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_ref" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->ref->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_ref" class="ew-search-caption ew-label"><?= $Page->ref->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_ref" id="z_ref" value="=">
</div>
        </div>
        <div id="el_process_table_hs_ref" class="ew-search-field">
<input type="<?= $Page->ref->getInputTextType() ?>" name="x_ref" id="x_ref" data-table="process_table_hs" data-field="x_ref" value="<?= $Page->ref->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ref->formatPattern()) ?>"<?= $Page->ref->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ref->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
<?php
if (!$Page->rid->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_rid" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->rid->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_rid" class="ew-search-caption ew-label"><?= $Page->rid->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_rid" id="z_rid" value="=">
</div>
        </div>
        <div id="el_process_table_hs_rid" class="ew-search-field">
<input type="<?= $Page->rid->getInputTextType() ?>" name="x_rid" id="x_rid" data-table="process_table_hs" data-field="x_rid" value="<?= $Page->rid->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rid->formatPattern()) ?>"<?= $Page->rid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->rid->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
<?php
if (!$Page->batch_no->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_batch_no" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->batch_no->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_batch_no" class="ew-search-caption ew-label"><?= $Page->batch_no->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_batch_no" id="z_batch_no" value="=">
</div>
        </div>
        <div id="el_process_table_hs_batch_no" class="ew-search-field">
<input type="<?= $Page->batch_no->getInputTextType() ?>" name="x_batch_no" id="x_batch_no" data-table="process_table_hs" data-field="x_batch_no" value="<?= $Page->batch_no->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->batch_no->formatPattern()) ?>"<?= $Page->batch_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->batch_no->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fprocess_table_hssrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fprocess_table_hssrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fprocess_table_hssrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fprocess_table_hssrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fprocess_table_hssrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fprocess_table_hssrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fprocess_table_hssrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="process_table_hs">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_process_table_hs" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_process_table_hslist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_process_table_hs_id" class="process_table_hs_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
        <th data-name="grp" class="<?= $Page->grp->headerCellClass() ?>"><div id="elh_process_table_hs_grp" class="process_table_hs_grp"><?= $Page->renderFieldHeader($Page->grp) ?></div></th>
<?php } ?>
<?php if ($Page->godown->Visible) { // godown ?>
        <th data-name="godown" class="<?= $Page->godown->headerCellClass() ?>"><div id="elh_process_table_hs_godown" class="process_table_hs_godown"><?= $Page->renderFieldHeader($Page->godown) ?></div></th>
<?php } ?>
<?php if ($Page->emp_name->Visible) { // emp_name ?>
        <th data-name="emp_name" class="<?= $Page->emp_name->headerCellClass() ?>"><div id="elh_process_table_hs_emp_name" class="process_table_hs_emp_name"><?= $Page->renderFieldHeader($Page->emp_name) ?></div></th>
<?php } ?>
<?php if ($Page->ref->Visible) { // ref ?>
        <th data-name="ref" class="<?= $Page->ref->headerCellClass() ?>"><div id="elh_process_table_hs_ref" class="process_table_hs_ref"><?= $Page->renderFieldHeader($Page->ref) ?></div></th>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
        <th data-name="rid" class="<?= $Page->rid->headerCellClass() ?>"><div id="elh_process_table_hs_rid" class="process_table_hs_rid"><?= $Page->renderFieldHeader($Page->rid) ?></div></th>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
        <th data-name="batch_no" class="<?= $Page->batch_no->headerCellClass() ?>"><div id="elh_process_table_hs_batch_no" class="process_table_hs_batch_no"><?= $Page->renderFieldHeader($Page->batch_no) ?></div></th>
<?php } ?>
<?php if ($Page->count->Visible) { // count ?>
        <th data-name="count" class="<?= $Page->count->headerCellClass() ?>"><div id="elh_process_table_hs_count" class="process_table_hs_count"><?= $Page->renderFieldHeader($Page->count) ?></div></th>
<?php } ?>
<?php if ($Page->count_received->Visible) { // count_received ?>
        <th data-name="count_received" class="<?= $Page->count_received->headerCellClass() ?>"><div id="elh_process_table_hs_count_received" class="process_table_hs_count_received"><?= $Page->renderFieldHeader($Page->count_received) ?></div></th>
<?php } ?>
<?php if ($Page->twist->Visible) { // twist ?>
        <th data-name="twist" class="<?= $Page->twist->headerCellClass() ?>"><div id="elh_process_table_hs_twist" class="process_table_hs_twist"><?= $Page->renderFieldHeader($Page->twist) ?></div></th>
<?php } ?>
<?php if ($Page->quantity_avg_act->Visible) { // quantity_avg_act ?>
        <th data-name="quantity_avg_act" class="<?= $Page->quantity_avg_act->headerCellClass() ?>"><div id="elh_process_table_hs_quantity_avg_act" class="process_table_hs_quantity_avg_act"><?= $Page->renderFieldHeader($Page->quantity_avg_act) ?></div></th>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
        <th data-name="quantity" class="<?= $Page->quantity->headerCellClass() ?>"><div id="elh_process_table_hs_quantity" class="process_table_hs_quantity"><?= $Page->renderFieldHeader($Page->quantity) ?></div></th>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
        <th data-name="status" class="<?= $Page->status->headerCellClass() ?>"><div id="elh_process_table_hs_status" class="process_table_hs_status"><?= $Page->renderFieldHeader($Page->status) ?></div></th>
<?php } ?>
<?php if ($Page->std_rate->Visible) { // std_rate ?>
        <th data-name="std_rate" class="<?= $Page->std_rate->headerCellClass() ?>"><div id="elh_process_table_hs_std_rate" class="process_table_hs_std_rate"><?= $Page->renderFieldHeader($Page->std_rate) ?></div></th>
<?php } ?>
<?php if ($Page->_40->Visible) { // @ ?>
        <th data-name="_40" class="<?= $Page->_40->headerCellClass() ?>"><div id="elh_process_table_hs__40" class="process_table_hs__40"><?= $Page->renderFieldHeader($Page->_40) ?></div></th>
<?php } ?>
<?php if ($Page->total_amount->Visible) { // total_amount ?>
        <th data-name="total_amount" class="<?= $Page->total_amount->headerCellClass() ?>"><div id="elh_process_table_hs_total_amount" class="process_table_hs_total_amount"><?= $Page->renderFieldHeader($Page->total_amount) ?></div></th>
<?php } ?>
<?php if ($Page->payment->Visible) { // payment ?>
        <th data-name="payment" class="<?= $Page->payment->headerCellClass() ?>"><div id="elh_process_table_hs_payment" class="process_table_hs_payment"><?= $Page->renderFieldHeader($Page->payment) ?></div></th>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
        <th data-name="remarks" class="<?= $Page->remarks->headerCellClass() ?>"><div id="elh_process_table_hs_remarks" class="process_table_hs_remarks"><?= $Page->renderFieldHeader($Page->remarks) ?></div></th>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Page->operator->headerCellClass() ?>"><div id="elh_process_table_hs_operator" class="process_table_hs_operator"><?= $Page->renderFieldHeader($Page->operator) ?></div></th>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Page->datetime->headerCellClass() ?>"><div id="elh_process_table_hs_datetime" class="process_table_hs_datetime"><?= $Page->renderFieldHeader($Page->datetime) ?></div></th>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
        <th data-name="dated" class="<?= $Page->dated->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_process_table_hs_dated" class="process_table_hs_dated"><?= $Page->renderFieldHeader($Page->dated) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_table_hs_id" class="el_process_table_hs_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->grp->Visible) { // grp ?>
        <td data-name="grp"<?= $Page->grp->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_table_hs_grp" class="el_process_table_hs_grp">
<span<?= $Page->grp->viewAttributes() ?>>
<?= $Page->grp->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->godown->Visible) { // godown ?>
        <td data-name="godown"<?= $Page->godown->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_table_hs_godown" class="el_process_table_hs_godown">
<span<?= $Page->godown->viewAttributes() ?>>
<?php if (!EmptyString($Page->godown->getViewValue()) && $Page->godown->linkAttributes() != "") { ?>
<a<?= $Page->godown->linkAttributes() ?>><?= $Page->godown->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->emp_name->Visible) { // emp_name ?>
        <td data-name="emp_name"<?= $Page->emp_name->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_table_hs_emp_name" class="el_process_table_hs_emp_name">
<span<?= $Page->emp_name->viewAttributes() ?>>
<?php if (!EmptyString($Page->emp_name->getViewValue()) && $Page->emp_name->linkAttributes() != "") { ?>
<a<?= $Page->emp_name->linkAttributes() ?>><?= $Page->emp_name->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->emp_name->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ref->Visible) { // ref ?>
        <td data-name="ref"<?= $Page->ref->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_table_hs_ref" class="el_process_table_hs_ref">
<span<?= $Page->ref->viewAttributes() ?>>
<?= $Page->ref->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->rid->Visible) { // rid ?>
        <td data-name="rid"<?= $Page->rid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_table_hs_rid" class="el_process_table_hs_rid">
<span<?= $Page->rid->viewAttributes() ?>>
<?php if (!EmptyString($Page->rid->getViewValue()) && $Page->rid->linkAttributes() != "") { ?>
<a<?= $Page->rid->linkAttributes() ?>><?= $Page->rid->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->batch_no->Visible) { // batch_no ?>
        <td data-name="batch_no"<?= $Page->batch_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_table_hs_batch_no" class="el_process_table_hs_batch_no">
<span<?= $Page->batch_no->viewAttributes() ?>>
<?= $Page->batch_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->count->Visible) { // count ?>
        <td data-name="count"<?= $Page->count->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_table_hs_count" class="el_process_table_hs_count">
<span<?= $Page->count->viewAttributes() ?>>
<?= $Page->count->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->count_received->Visible) { // count_received ?>
        <td data-name="count_received"<?= $Page->count_received->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_table_hs_count_received" class="el_process_table_hs_count_received">
<span<?= $Page->count_received->viewAttributes() ?>>
<?= $Page->count_received->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->twist->Visible) { // twist ?>
        <td data-name="twist"<?= $Page->twist->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_table_hs_twist" class="el_process_table_hs_twist">
<span<?= $Page->twist->viewAttributes() ?>>
<?= $Page->twist->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->quantity_avg_act->Visible) { // quantity_avg_act ?>
        <td data-name="quantity_avg_act"<?= $Page->quantity_avg_act->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_table_hs_quantity_avg_act" class="el_process_table_hs_quantity_avg_act">
<span<?= $Page->quantity_avg_act->viewAttributes() ?>>
<?= $Page->quantity_avg_act->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->quantity->Visible) { // quantity ?>
        <td data-name="quantity"<?= $Page->quantity->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_table_hs_quantity" class="el_process_table_hs_quantity">
<span<?= $Page->quantity->viewAttributes() ?>>
<?= $Page->quantity->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->status->Visible) { // status ?>
        <td data-name="status"<?= $Page->status->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_table_hs_status" class="el_process_table_hs_status">
<span<?= $Page->status->viewAttributes() ?>>
<?= $Page->status->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->std_rate->Visible) { // std_rate ?>
        <td data-name="std_rate"<?= $Page->std_rate->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_table_hs_std_rate" class="el_process_table_hs_std_rate">
<span<?= $Page->std_rate->viewAttributes() ?>>
<?= $Page->std_rate->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_40->Visible) { // @ ?>
        <td data-name="_40"<?= $Page->_40->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_table_hs__40" class="el_process_table_hs__40">
<span<?= $Page->_40->viewAttributes() ?>>
<?= $Page->_40->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->total_amount->Visible) { // total_amount ?>
        <td data-name="total_amount"<?= $Page->total_amount->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_table_hs_total_amount" class="el_process_table_hs_total_amount">
<span<?= $Page->total_amount->viewAttributes() ?>>
<?= $Page->total_amount->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->payment->Visible) { // payment ?>
        <td data-name="payment"<?= $Page->payment->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_table_hs_payment" class="el_process_table_hs_payment">
<span<?= $Page->payment->viewAttributes() ?>>
<?= $Page->payment->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->remarks->Visible) { // remarks ?>
        <td data-name="remarks"<?= $Page->remarks->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_table_hs_remarks" class="el_process_table_hs_remarks">
<span<?= $Page->remarks->viewAttributes() ?>>
<?= $Page->remarks->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_table_hs_operator" class="el_process_table_hs_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_table_hs_datetime" class="el_process_table_hs_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->dated->Visible) { // dated ?>
        <td data-name="dated"<?= $Page->dated->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_table_hs_dated" class="el_process_table_hs_dated">
<span<?= $Page->dated->viewAttributes() ?>>
<?= $Page->dated->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("process_table_hs");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
