<?php

namespace PHPMaker2024\fibre;

// Page object
$ProcessActionSingleSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { process_action_single: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fprocess_action_singlesearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fprocess_action_singlesearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["location", [], fields.location.isInvalid],
            ["process", [], fields.process.isInvalid],
            ["employee_id", [], fields.employee_id.isInvalid],
            ["y_employee_id", [ew.Validators.between], false],
            ["code", [], fields.code.isInvalid],
            ["y_code", [ew.Validators.between], false],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["y_datetime", [ew.Validators.between], false],
            ["roll_no", [], fields.roll_no.isInvalid],
            ["qty", [], fields.qty.isInvalid],
            ["size_actual", [], fields.size_actual.isInvalid],
            ["weight_actual", [ew.Validators.float], fields.weight_actual.isInvalid],
            ["valuation", [], fields.valuation.isInvalid],
            ["buyer_id", [ew.Validators.integer], fields.buyer_id.isInvalid],
            ["design_id", [ew.Validators.integer], fields.design_id.isInvalid],
            ["size_cm", [], fields.size_cm.isInvalid],
            ["sqm", [ew.Validators.float], fields.sqm.isInvalid],
            ["deduction", [ew.Validators.float], fields.deduction.isInvalid],
            ["upload", [], fields.upload.isInvalid],
            ["payment", [], fields.payment.isInvalid],
            ["y_payment", [ew.Validators.between], false],
            ["remark", [], fields.remark.isInvalid],
            ["tmp_id", [ew.Validators.integer], fields.tmp_id.isInvalid],
            ["process_other", [], fields.process_other.isInvalid],
            ["jc_no", [ew.Validators.integer], fields.jc_no.isInvalid],
            ["loom_id", [], fields.loom_id.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "location": <?= $Page->location->toClientList($Page) ?>,
            "process": <?= $Page->process->toClientList($Page) ?>,
            "employee_id": <?= $Page->employee_id->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
            "valuation": <?= $Page->valuation->toClientList($Page) ?>,
            "buyer_id": <?= $Page->buyer_id->toClientList($Page) ?>,
            "design_id": <?= $Page->design_id->toClientList($Page) ?>,
            "payment": <?= $Page->payment->toClientList($Page) ?>,
            "process_other": <?= $Page->process_other->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fprocess_action_singlesearch" id="fprocess_action_singlesearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="process_action_single">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_single_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_single_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="process_action_single" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
    <div id="r_location" class="row"<?= $Page->location->rowAttributes() ?>>
        <label for="x_location" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_single_location"><?= $Page->location->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_location" id="z_location" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->location->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_single_location" class="ew-search-field ew-search-field-single">
    <select
        id="x_location"
        name="x_location"
        class="form-select ew-select<?= $Page->location->isInvalidClass() ?>"
        <?php if (!$Page->location->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_singlesearch_x_location"
        <?php } ?>
        data-table="process_action_single"
        data-field="x_location"
        data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>"
        <?= $Page->location->editAttributes() ?>>
        <?= $Page->location->selectOptionListHtml("x_location") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->location->getErrorMessage(false) ?></div>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
<?php if (!$Page->location->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_singlesearch", function() {
    var options = { name: "x_location", selectId: "fprocess_action_singlesearch_x_location" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_singlesearch.lists.location?.lookupOptions.length) {
        options.data = { id: "x_location", form: "fprocess_action_singlesearch" };
    } else {
        options.ajax = { id: "x_location", form: "fprocess_action_singlesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_single.fields.location.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->process->Visible) { // process ?>
    <div id="r_process" class="row"<?= $Page->process->rowAttributes() ?>>
        <label for="x_process" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_single_process"><?= $Page->process->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_process" id="z_process" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->process->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_single_process" class="ew-search-field ew-search-field-single">
    <select
        id="x_process"
        name="x_process"
        class="form-select ew-select<?= $Page->process->isInvalidClass() ?>"
        <?php if (!$Page->process->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_singlesearch_x_process"
        <?php } ?>
        data-table="process_action_single"
        data-field="x_process"
        data-value-separator="<?= $Page->process->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process->getPlaceHolder()) ?>"
        <?= $Page->process->editAttributes() ?>>
        <?= $Page->process->selectOptionListHtml("x_process") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->process->getErrorMessage(false) ?></div>
<?= $Page->process->Lookup->getParamTag($Page, "p_x_process") ?>
<?php if (!$Page->process->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_singlesearch", function() {
    var options = { name: "x_process", selectId: "fprocess_action_singlesearch_x_process" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_singlesearch.lists.process?.lookupOptions.length) {
        options.data = { id: "x_process", form: "fprocess_action_singlesearch" };
    } else {
        options.ajax = { id: "x_process", form: "fprocess_action_singlesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_single.fields.process.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->employee_id->Visible) { // employee_id ?>
    <div id="r_employee_id" class="row"<?= $Page->employee_id->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_single_employee_id"><?= $Page->employee_id->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->employee_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_employee_id" id="z_employee_id" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->employee_id->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->employee_id->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_process_action_single_employee_id" class="ew-search-field">
    <select
        id="x_employee_id[]"
        name="x_employee_id[]"
        class="form-control ew-select<?= $Page->employee_id->isInvalidClass() ?>"
        data-select2-id="fprocess_action_singlesearch_x_employee_id[]"
        data-table="process_action_single"
        data-field="x_employee_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->employee_id->caption())) ?>"
        data-modal-lookup="true"
        multiple
        size="1"
        data-value-separator="<?= $Page->employee_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->employee_id->getPlaceHolder()) ?>"
        <?= $Page->employee_id->editAttributes() ?>>
        <?= $Page->employee_id->selectOptionListHtml("x_employee_id[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->employee_id->getErrorMessage(false) ?></div>
<?= $Page->employee_id->Lookup->getParamTag($Page, "p_x_employee_id") ?>
<script>
loadjs.ready("fprocess_action_singlesearch", function() {
    var options = { name: "x_employee_id[]", selectId: "fprocess_action_singlesearch_x_employee_id[]" };
    options.multiple = true;
    if (fprocess_action_singlesearch.lists.employee_id?.lookupOptions.length) {
        options.data = { id: "x_employee_id[]", form: "fprocess_action_singlesearch" };
    } else {
        options.ajax = { id: "x_employee_id[]", form: "fprocess_action_singlesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.process_action_single.fields.employee_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_process_action_single_employee_id" class="ew-search-field2 d-none">
    <select
        id="y_employee_id[]"
        name="y_employee_id[]"
        class="form-control ew-select<?= $Page->employee_id->isInvalidClass() ?>"
        data-select2-id="fprocess_action_singlesearch_y_employee_id[]"
        data-table="process_action_single"
        data-field="x_employee_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->employee_id->caption())) ?>"
        data-modal-lookup="true"
        multiple
        size="1"
        data-value-separator="<?= $Page->employee_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->employee_id->getPlaceHolder()) ?>"
        <?= $Page->employee_id->editAttributes() ?>>
        <?= $Page->employee_id->selectOptionListHtml("y_employee_id[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->employee_id->getErrorMessage(false) ?></div>
<?= $Page->employee_id->Lookup->getParamTag($Page, "p_y_employee_id") ?>
<script>
loadjs.ready("fprocess_action_singlesearch", function() {
    var options = { name: "y_employee_id[]", selectId: "fprocess_action_singlesearch_y_employee_id[]" };
    options.multiple = true;
    if (fprocess_action_singlesearch.lists.employee_id?.lookupOptions.length) {
        options.data = { id: "y_employee_id[]", form: "fprocess_action_singlesearch" };
    } else {
        options.ajax = { id: "y_employee_id[]", form: "fprocess_action_singlesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.process_action_single.fields.employee_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->code->Visible) { // code ?>
    <div id="r_code" class="row"<?= $Page->code->rowAttributes() ?>>
        <label for="x_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_single_code"><?= $Page->code->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_code" id="z_code" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->code->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->code->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_process_action_single_code" class="ew-search-field">
<input type="<?= $Page->code->getInputTextType() ?>" name="x_code" id="x_code" data-table="process_action_single" data-field="x_code" value="<?= $Page->code->EditValue ?>" size="30" maxlength="9" placeholder="<?= HtmlEncode($Page->code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->code->formatPattern()) ?>"<?= $Page->code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->code->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_process_action_single_code" class="ew-search-field2 d-none">
<input type="<?= $Page->code->getInputTextType() ?>" name="y_code" id="y_code" data-table="process_action_single" data-field="x_code" value="<?= $Page->code->EditValue2 ?>" size="30" maxlength="9" placeholder="<?= HtmlEncode($Page->code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->code->formatPattern()) ?>"<?= $Page->code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_single_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_single_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_singlesearch_x_operator"
        <?php } ?>
        data-table="process_action_single"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_singlesearch", function() {
    var options = { name: "x_operator", selectId: "fprocess_action_singlesearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_singlesearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fprocess_action_singlesearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fprocess_action_singlesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_single.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_single_datetime"><?= $Page->datetime->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_datetime" id="z_datetime" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->datetime->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->datetime->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_process_action_single_datetime" class="ew-search-field">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="process_action_single" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprocess_action_singlesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprocess_action_singlesearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_process_action_single_datetime" class="ew-search-field2 d-none">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="y_datetime" id="y_datetime" data-table="process_action_single" data-field="x_datetime" value="<?= $Page->datetime->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprocess_action_singlesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprocess_action_singlesearch", "y_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->roll_no->Visible) { // roll_no ?>
    <div id="r_roll_no" class="row"<?= $Page->roll_no->rowAttributes() ?>>
        <label for="x_roll_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_single_roll_no"><?= $Page->roll_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_roll_no" id="z_roll_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->roll_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_single_roll_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->roll_no->getInputTextType() ?>" name="x_roll_no" id="x_roll_no" data-table="process_action_single" data-field="x_roll_no" value="<?= $Page->roll_no->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->roll_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->roll_no->formatPattern()) ?>"<?= $Page->roll_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->roll_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->qty->Visible) { // qty ?>
    <div id="r_qty" class="row"<?= $Page->qty->rowAttributes() ?>>
        <label for="x_qty" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_single_qty"><?= $Page->qty->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_qty" id="z_qty" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->qty->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_single_qty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->qty->getInputTextType() ?>" name="x_qty" id="x_qty" data-table="process_action_single" data-field="x_qty" value="<?= $Page->qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qty->formatPattern()) ?>"<?= $Page->qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->qty->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->size_actual->Visible) { // size_actual ?>
    <div id="r_size_actual" class="row"<?= $Page->size_actual->rowAttributes() ?>>
        <label for="x_size_actual" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_single_size_actual"><?= $Page->size_actual->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_size_actual" id="z_size_actual" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->size_actual->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_single_size_actual" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->size_actual->getInputTextType() ?>" name="x_size_actual" id="x_size_actual" data-table="process_action_single" data-field="x_size_actual" value="<?= $Page->size_actual->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->size_actual->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size_actual->formatPattern()) ?>"<?= $Page->size_actual->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->size_actual->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->weight_actual->Visible) { // weight_actual ?>
    <div id="r_weight_actual" class="row"<?= $Page->weight_actual->rowAttributes() ?>>
        <label for="x_weight_actual" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_single_weight_actual"><?= $Page->weight_actual->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_weight_actual" id="z_weight_actual" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->weight_actual->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_single_weight_actual" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->weight_actual->getInputTextType() ?>" name="x_weight_actual" id="x_weight_actual" data-table="process_action_single" data-field="x_weight_actual" value="<?= $Page->weight_actual->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->weight_actual->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->weight_actual->formatPattern()) ?>"<?= $Page->weight_actual->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->weight_actual->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->valuation->Visible) { // valuation ?>
    <div id="r_valuation" class="row"<?= $Page->valuation->rowAttributes() ?>>
        <label for="x_valuation" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_single_valuation"><?= $Page->valuation->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_valuation" id="z_valuation" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->valuation->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_single_valuation" class="ew-search-field ew-search-field-single">
    <select
        id="x_valuation"
        name="x_valuation"
        class="form-select ew-select<?= $Page->valuation->isInvalidClass() ?>"
        <?php if (!$Page->valuation->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_singlesearch_x_valuation"
        <?php } ?>
        data-table="process_action_single"
        data-field="x_valuation"
        data-value-separator="<?= $Page->valuation->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->valuation->getPlaceHolder()) ?>"
        <?= $Page->valuation->editAttributes() ?>>
        <?= $Page->valuation->selectOptionListHtml("x_valuation") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->valuation->getErrorMessage(false) ?></div>
<?php if (!$Page->valuation->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_singlesearch", function() {
    var options = { name: "x_valuation", selectId: "fprocess_action_singlesearch_x_valuation" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_singlesearch.lists.valuation?.lookupOptions.length) {
        options.data = { id: "x_valuation", form: "fprocess_action_singlesearch" };
    } else {
        options.ajax = { id: "x_valuation", form: "fprocess_action_singlesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_single.fields.valuation.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_id->Visible) { // buyer_id ?>
    <div id="r_buyer_id" class="row"<?= $Page->buyer_id->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_single_buyer_id"><?= $Page->buyer_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyer_id" id="z_buyer_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_single_buyer_id" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->buyer_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_buyer_id" class="ew-auto-suggest">
    <input type="<?= $Page->buyer_id->getInputTextType() ?>" class="form-control" name="sv_x_buyer_id" id="sv_x_buyer_id" value="<?= RemoveHtml($Page->buyer_id->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->buyer_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->buyer_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_id->formatPattern()) ?>"<?= $Page->buyer_id->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="process_action_single" data-field="x_buyer_id" data-input="sv_x_buyer_id" data-value-separator="<?= $Page->buyer_id->displayValueSeparatorAttribute() ?>" name="x_buyer_id" id="x_buyer_id" value="<?= HtmlEncode($Page->buyer_id->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->buyer_id->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fprocess_action_singlesearch", function() {
    fprocess_action_singlesearch.createAutoSuggest(Object.assign({"id":"x_buyer_id","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->buyer_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.process_action_single.fields.buyer_id.autoSuggestOptions));
});
</script>
<?= $Page->buyer_id->Lookup->getParamTag($Page, "p_x_buyer_id") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->design_id->Visible) { // design_id ?>
    <div id="r_design_id" class="row"<?= $Page->design_id->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_single_design_id"><?= $Page->design_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_design_id" id="z_design_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->design_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_single_design_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_design_id"
        name="x_design_id"
        class="form-control ew-select<?= $Page->design_id->isInvalidClass() ?>"
        data-select2-id="fprocess_action_singlesearch_x_design_id"
        data-table="process_action_single"
        data-field="x_design_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->design_id->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->design_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->design_id->getPlaceHolder()) ?>"
        <?= $Page->design_id->editAttributes() ?>>
        <?= $Page->design_id->selectOptionListHtml("x_design_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->design_id->getErrorMessage(false) ?></div>
<?= $Page->design_id->Lookup->getParamTag($Page, "p_x_design_id") ?>
<script>
loadjs.ready("fprocess_action_singlesearch", function() {
    var options = { name: "x_design_id", selectId: "fprocess_action_singlesearch_x_design_id" };
    if (fprocess_action_singlesearch.lists.design_id?.lookupOptions.length) {
        options.data = { id: "x_design_id", form: "fprocess_action_singlesearch" };
    } else {
        options.ajax = { id: "x_design_id", form: "fprocess_action_singlesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.process_action_single.fields.design_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->size_cm->Visible) { // size_cm ?>
    <div id="r_size_cm" class="row"<?= $Page->size_cm->rowAttributes() ?>>
        <label for="x_size_cm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_single_size_cm"><?= $Page->size_cm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_size_cm" id="z_size_cm" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->size_cm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_single_size_cm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->size_cm->getInputTextType() ?>" name="x_size_cm" id="x_size_cm" data-table="process_action_single" data-field="x_size_cm" value="<?= $Page->size_cm->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->size_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size_cm->formatPattern()) ?>"<?= $Page->size_cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->size_cm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
    <div id="r_sqm" class="row"<?= $Page->sqm->rowAttributes() ?>>
        <label for="x_sqm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_single_sqm"><?= $Page->sqm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_sqm" id="z_sqm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sqm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_single_sqm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sqm->getInputTextType() ?>" name="x_sqm" id="x_sqm" data-table="process_action_single" data-field="x_sqm" value="<?= $Page->sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm->formatPattern()) ?>"<?= $Page->sqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sqm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->deduction->Visible) { // deduction ?>
    <div id="r_deduction" class="row"<?= $Page->deduction->rowAttributes() ?>>
        <label for="x_deduction" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_single_deduction"><?= $Page->deduction->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_deduction" id="z_deduction" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->deduction->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_single_deduction" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->deduction->getInputTextType() ?>" name="x_deduction" id="x_deduction" data-table="process_action_single" data-field="x_deduction" value="<?= $Page->deduction->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->deduction->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->deduction->formatPattern()) ?>"<?= $Page->deduction->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->deduction->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->upload->Visible) { // upload ?>
    <div id="r_upload" class="row"<?= $Page->upload->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_single_upload"><?= $Page->upload->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_upload" id="z_upload" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->upload->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_single_upload" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->upload->getInputTextType() ?>" name="x_upload" id="x_upload" data-table="process_action_single" data-field="x_upload" value="<?= $Page->upload->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->upload->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->upload->formatPattern()) ?>"<?= $Page->upload->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->upload->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->payment->Visible) { // payment ?>
    <div id="r_payment" class="row"<?= $Page->payment->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_single_payment"><?= $Page->payment->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->payment->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_payment" id="z_payment" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->payment->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->payment->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_process_action_single_payment" class="ew-search-field">
    <select
        id="x_payment[]"
        name="x_payment[]"
        class="form-control ew-select<?= $Page->payment->isInvalidClass() ?>"
        data-select2-id="fprocess_action_singlesearch_x_payment[]"
        data-table="process_action_single"
        data-field="x_payment"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->payment->caption())) ?>"
        data-modal-lookup="true"
        multiple
        size="1"
        data-value-separator="<?= $Page->payment->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->payment->getPlaceHolder()) ?>"
        <?= $Page->payment->editAttributes() ?>>
        <?= $Page->payment->selectOptionListHtml("x_payment[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->payment->getErrorMessage(false) ?></div>
<?= $Page->payment->Lookup->getParamTag($Page, "p_x_payment") ?>
<script>
loadjs.ready("fprocess_action_singlesearch", function() {
    var options = { name: "x_payment[]", selectId: "fprocess_action_singlesearch_x_payment[]" };
    options.multiple = true;
    if (fprocess_action_singlesearch.lists.payment?.lookupOptions.length) {
        options.data = { id: "x_payment[]", form: "fprocess_action_singlesearch" };
    } else {
        options.ajax = { id: "x_payment[]", form: "fprocess_action_singlesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.process_action_single.fields.payment.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_process_action_single_payment" class="ew-search-field2 d-none">
    <select
        id="y_payment[]"
        name="y_payment[]"
        class="form-control ew-select<?= $Page->payment->isInvalidClass() ?>"
        data-select2-id="fprocess_action_singlesearch_y_payment[]"
        data-table="process_action_single"
        data-field="x_payment"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->payment->caption())) ?>"
        data-modal-lookup="true"
        multiple
        size="1"
        data-value-separator="<?= $Page->payment->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->payment->getPlaceHolder()) ?>"
        <?= $Page->payment->editAttributes() ?>>
        <?= $Page->payment->selectOptionListHtml("y_payment[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->payment->getErrorMessage(false) ?></div>
<?= $Page->payment->Lookup->getParamTag($Page, "p_y_payment") ?>
<script>
loadjs.ready("fprocess_action_singlesearch", function() {
    var options = { name: "y_payment[]", selectId: "fprocess_action_singlesearch_y_payment[]" };
    options.multiple = true;
    if (fprocess_action_singlesearch.lists.payment?.lookupOptions.length) {
        options.data = { id: "y_payment[]", form: "fprocess_action_singlesearch" };
    } else {
        options.ajax = { id: "y_payment[]", form: "fprocess_action_singlesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.process_action_single.fields.payment.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remark->Visible) { // remark ?>
    <div id="r_remark" class="row"<?= $Page->remark->rowAttributes() ?>>
        <label for="x_remark" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_single_remark"><?= $Page->remark->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remark" id="z_remark" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remark->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_single_remark" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remark->getInputTextType() ?>" name="x_remark" id="x_remark" data-table="process_action_single" data-field="x_remark" value="<?= $Page->remark->EditValue ?>" size="30" maxlength="225" placeholder="<?= HtmlEncode($Page->remark->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remark->formatPattern()) ?>"<?= $Page->remark->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remark->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->tmp_id->Visible) { // tmp_id ?>
    <div id="r_tmp_id" class="row"<?= $Page->tmp_id->rowAttributes() ?>>
        <label for="x_tmp_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_single_tmp_id"><?= $Page->tmp_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_tmp_id" id="z_tmp_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->tmp_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_single_tmp_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->tmp_id->getInputTextType() ?>" name="x_tmp_id" id="x_tmp_id" data-table="process_action_single" data-field="x_tmp_id" value="<?= $Page->tmp_id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->tmp_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->tmp_id->formatPattern()) ?>"<?= $Page->tmp_id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->tmp_id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->process_other->Visible) { // process_other ?>
    <div id="r_process_other" class="row"<?= $Page->process_other->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_single_process_other"><?= $Page->process_other->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_process_other" id="z_process_other" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->process_other->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_single_process_other" class="ew-search-field ew-search-field-single">
<template id="tp_x_process_other">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="process_action_single" data-field="x_process_other" name="x_process_other" id="x_process_other"<?= $Page->process_other->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_process_other" class="ew-item-list"></div>
<selection-list hidden
    id="x_process_other[]"
    name="x_process_other[]"
    value="<?= HtmlEncode($Page->process_other->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_process_other"
    data-target="dsl_x_process_other"
    data-repeatcolumn="3"
    class="form-control<?= $Page->process_other->isInvalidClass() ?>"
    data-table="process_action_single"
    data-field="x_process_other"
    data-value-separator="<?= $Page->process_other->displayValueSeparatorAttribute() ?>"
    <?= $Page->process_other->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->process_other->getErrorMessage(false) ?></div>
<?= $Page->process_other->Lookup->getParamTag($Page, "p_x_process_other") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->jc_no->Visible) { // jc_no ?>
    <div id="r_jc_no" class="row"<?= $Page->jc_no->rowAttributes() ?>>
        <label for="x_jc_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_single_jc_no"><?= $Page->jc_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_jc_no" id="z_jc_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->jc_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_single_jc_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->jc_no->getInputTextType() ?>" name="x_jc_no" id="x_jc_no" data-table="process_action_single" data-field="x_jc_no" value="<?= $Page->jc_no->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->jc_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->jc_no->formatPattern()) ?>"<?= $Page->jc_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->jc_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->loom_id->Visible) { // loom_id ?>
    <div id="r_loom_id" class="row"<?= $Page->loom_id->rowAttributes() ?>>
        <label for="x_loom_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_single_loom_id"><?= $Page->loom_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_loom_id" id="z_loom_id" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->loom_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_single_loom_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->loom_id->getInputTextType() ?>" name="x_loom_id" id="x_loom_id" data-table="process_action_single" data-field="x_loom_id" value="<?= $Page->loom_id->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->loom_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->loom_id->formatPattern()) ?>"<?= $Page->loom_id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->loom_id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fprocess_action_singlesearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fprocess_action_singlesearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fprocess_action_singlesearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("process_action_single");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
