<?php

namespace PHPMaker2024\fibre;

// Page object
$ProcessActionSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { process_action: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fprocess_actionsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fprocess_actionsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["process", [ew.Validators.integer], fields.process.isInvalid],
            ["process_other", [], fields.process_other.isInvalid],
            ["location", [], fields.location.isInvalid],
            ["godown", [], fields.godown.isInvalid],
            ["code", [], fields.code.isInvalid],
            ["y_code", [ew.Validators.between], false],
            ["code_last", [], fields.code_last.isInvalid],
            ["y_code_last", [ew.Validators.between], false],
            ["employee_id", [], fields.employee_id.isInvalid],
            ["y_employee_id", [ew.Validators.between], false],
            ["qty", [], fields.qty.isInvalid],
            ["roll_no", [], fields.roll_no.isInvalid],
            ["size_w", [ew.Validators.integer], fields.size_w.isInvalid],
            ["size_l", [ew.Validators.integer], fields.size_l.isInvalid],
            ["size_h", [ew.Validators.integer], fields.size_h.isInvalid],
            ["size_actual", [], fields.size_actual.isInvalid],
            ["weight_actual", [ew.Validators.float], fields.weight_actual.isInvalid],
            ["lines_in_30cm", [ew.Validators.float], fields.lines_in_30cm.isInvalid],
            ["d_01", [], fields.d_01.isInvalid],
            ["d_02", [], fields.d_02.isInvalid],
            ["d_03", [], fields.d_03.isInvalid],
            ["d_04", [], fields.d_04.isInvalid],
            ["d_05", [], fields.d_05.isInvalid],
            ["d_06", [], fields.d_06.isInvalid],
            ["d_07", [], fields.d_07.isInvalid],
            ["d_08", [], fields.d_08.isInvalid],
            ["d_09", [], fields.d_09.isInvalid],
            ["d_10", [], fields.d_10.isInvalid],
            ["valuation", [], fields.valuation.isInvalid],
            ["deduction", [ew.Validators.float], fields.deduction.isInvalid],
            ["remark", [], fields.remark.isInvalid],
            ["upload", [], fields.upload.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["y_datetime", [ew.Validators.between], false]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "process": <?= $Page->process->toClientList($Page) ?>,
            "process_other": <?= $Page->process_other->toClientList($Page) ?>,
            "location": <?= $Page->location->toClientList($Page) ?>,
            "godown": <?= $Page->godown->toClientList($Page) ?>,
            "employee_id": <?= $Page->employee_id->toClientList($Page) ?>,
            "valuation": <?= $Page->valuation->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fprocess_actionsearch" id="fprocess_actionsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="process_action">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="process_action" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->process->Visible) { // process ?>
    <div id="r_process" class="row"<?= $Page->process->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_process"><?= $Page->process->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_process" id="z_process" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->process->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_process" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->process->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_process" class="ew-auto-suggest">
    <input type="<?= $Page->process->getInputTextType() ?>" class="form-control" name="sv_x_process" id="sv_x_process" value="<?= RemoveHtml($Page->process->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->process->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->process->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->process->formatPattern()) ?>"<?= $Page->process->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="process_action" data-field="x_process" data-input="sv_x_process" data-value-separator="<?= $Page->process->displayValueSeparatorAttribute() ?>" name="x_process" id="x_process" value="<?= HtmlEncode($Page->process->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->process->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fprocess_actionsearch", function() {
    fprocess_actionsearch.createAutoSuggest(Object.assign({"id":"x_process","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->process->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.process_action.fields.process.autoSuggestOptions));
});
</script>
<?= $Page->process->Lookup->getParamTag($Page, "p_x_process") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->process_other->Visible) { // process_other ?>
    <div id="r_process_other" class="row"<?= $Page->process_other->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_process_other"><?= $Page->process_other->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_process_other" id="z_process_other" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->process_other->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_process_other" class="ew-search-field ew-search-field-single">
<template id="tp_x_process_other">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="process_action" data-field="x_process_other" name="x_process_other" id="x_process_other"<?= $Page->process_other->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_process_other" class="ew-item-list"></div>
<selection-list hidden
    id="x_process_other[]"
    name="x_process_other[]"
    value="<?= HtmlEncode($Page->process_other->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_process_other"
    data-target="dsl_x_process_other"
    data-repeatcolumn="3"
    class="form-control<?= $Page->process_other->isInvalidClass() ?>"
    data-table="process_action"
    data-field="x_process_other"
    data-value-separator="<?= $Page->process_other->displayValueSeparatorAttribute() ?>"
    <?= $Page->process_other->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->process_other->getErrorMessage(false) ?></div>
<?= $Page->process_other->Lookup->getParamTag($Page, "p_x_process_other") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
    <div id="r_location" class="row"<?= $Page->location->rowAttributes() ?>>
        <label for="x_location" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_location"><?= $Page->location->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_location" id="z_location" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->location->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_location" class="ew-search-field ew-search-field-single">
    <select
        id="x_location"
        name="x_location"
        class="form-select ew-select<?= $Page->location->isInvalidClass() ?>"
        <?php if (!$Page->location->IsNativeSelect) { ?>
        data-select2-id="fprocess_actionsearch_x_location"
        <?php } ?>
        data-table="process_action"
        data-field="x_location"
        data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->location->editAttributes() ?>>
        <?= $Page->location->selectOptionListHtml("x_location") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->location->getErrorMessage(false) ?></div>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
<?php if (!$Page->location->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_actionsearch", function() {
    var options = { name: "x_location", selectId: "fprocess_actionsearch_x_location" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_actionsearch.lists.location?.lookupOptions.length) {
        options.data = { id: "x_location", form: "fprocess_actionsearch" };
    } else {
        options.ajax = { id: "x_location", form: "fprocess_actionsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action.fields.location.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->godown->Visible) { // godown ?>
    <div id="r_godown" class="row"<?= $Page->godown->rowAttributes() ?>>
        <label for="x_godown" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_godown"><?= $Page->godown->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_godown" id="z_godown" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->godown->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_godown" class="ew-search-field ew-search-field-single">
    <select
        id="x_godown"
        name="x_godown"
        class="form-select ew-select<?= $Page->godown->isInvalidClass() ?>"
        <?php if (!$Page->godown->IsNativeSelect) { ?>
        data-select2-id="fprocess_actionsearch_x_godown"
        <?php } ?>
        data-table="process_action"
        data-field="x_godown"
        data-value-separator="<?= $Page->godown->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->godown->getPlaceHolder()) ?>"
        <?= $Page->godown->editAttributes() ?>>
        <?= $Page->godown->selectOptionListHtml("x_godown") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->godown->getErrorMessage(false) ?></div>
<?= $Page->godown->Lookup->getParamTag($Page, "p_x_godown") ?>
<?php if (!$Page->godown->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_actionsearch", function() {
    var options = { name: "x_godown", selectId: "fprocess_actionsearch_x_godown" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_actionsearch.lists.godown?.lookupOptions.length) {
        options.data = { id: "x_godown", form: "fprocess_actionsearch" };
    } else {
        options.ajax = { id: "x_godown", form: "fprocess_actionsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action.fields.godown.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->code->Visible) { // code ?>
    <div id="r_code" class="row"<?= $Page->code->rowAttributes() ?>>
        <label for="x_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_code"><?= $Page->code->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_code" id="z_code" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->code->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->code->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_process_action_code" class="ew-search-field">
<input type="<?= $Page->code->getInputTextType() ?>" name="x_code" id="x_code" data-table="process_action" data-field="x_code" value="<?= $Page->code->EditValue ?>" maxlength="250" placeholder="<?= HtmlEncode($Page->code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->code->formatPattern()) ?>"<?= $Page->code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->code->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_process_action_code" class="ew-search-field2 d-none">
<input type="<?= $Page->code->getInputTextType() ?>" name="y_code" id="y_code" data-table="process_action" data-field="x_code" value="<?= $Page->code->EditValue2 ?>" maxlength="250" placeholder="<?= HtmlEncode($Page->code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->code->formatPattern()) ?>"<?= $Page->code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->code_last->Visible) { // code_last ?>
    <div id="r_code_last" class="row"<?= $Page->code_last->rowAttributes() ?>>
        <label for="x_code_last" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_code_last"><?= $Page->code_last->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->code_last->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_code_last" id="z_code_last" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->code_last->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->code_last->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_process_action_code_last" class="ew-search-field">
<input type="<?= $Page->code_last->getInputTextType() ?>" name="x_code_last" id="x_code_last" data-table="process_action" data-field="x_code_last" value="<?= $Page->code_last->EditValue ?>" maxlength="250" placeholder="<?= HtmlEncode($Page->code_last->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->code_last->formatPattern()) ?>"<?= $Page->code_last->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->code_last->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_process_action_code_last" class="ew-search-field2 d-none">
<input type="<?= $Page->code_last->getInputTextType() ?>" name="y_code_last" id="y_code_last" data-table="process_action" data-field="x_code_last" value="<?= $Page->code_last->EditValue2 ?>" maxlength="250" placeholder="<?= HtmlEncode($Page->code_last->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->code_last->formatPattern()) ?>"<?= $Page->code_last->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->code_last->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->employee_id->Visible) { // employee_id ?>
    <div id="r_employee_id" class="row"<?= $Page->employee_id->rowAttributes() ?>>
        <label for="x_employee_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_employee_id"><?= $Page->employee_id->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->employee_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_employee_id" id="z_employee_id" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->employee_id->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->employee_id->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_process_action_employee_id" class="ew-search-field">
    <select
        id="x_employee_id[]"
        name="x_employee_id[]"
        class="form-control ew-select<?= $Page->employee_id->isInvalidClass() ?>"
        data-select2-id="fprocess_actionsearch_x_employee_id[]"
        data-table="process_action"
        data-field="x_employee_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->employee_id->caption())) ?>"
        data-modal-lookup="true"
        multiple
        size="1"
        data-value-separator="<?= $Page->employee_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->employee_id->getPlaceHolder()) ?>"
        <?= $Page->employee_id->editAttributes() ?>>
        <?= $Page->employee_id->selectOptionListHtml("x_employee_id[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->employee_id->getErrorMessage(false) ?></div>
<?= $Page->employee_id->Lookup->getParamTag($Page, "p_x_employee_id") ?>
<script>
loadjs.ready("fprocess_actionsearch", function() {
    var options = { name: "x_employee_id[]", selectId: "fprocess_actionsearch_x_employee_id[]" };
    options.multiple = true;
    if (fprocess_actionsearch.lists.employee_id?.lookupOptions.length) {
        options.data = { id: "x_employee_id[]", form: "fprocess_actionsearch" };
    } else {
        options.ajax = { id: "x_employee_id[]", form: "fprocess_actionsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.process_action.fields.employee_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_process_action_employee_id" class="ew-search-field2 d-none">
    <select
        id="y_employee_id[]"
        name="y_employee_id[]"
        class="form-control ew-select<?= $Page->employee_id->isInvalidClass() ?>"
        data-select2-id="fprocess_actionsearch_y_employee_id[]"
        data-table="process_action"
        data-field="x_employee_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->employee_id->caption())) ?>"
        data-modal-lookup="true"
        multiple
        size="1"
        data-value-separator="<?= $Page->employee_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->employee_id->getPlaceHolder()) ?>"
        <?= $Page->employee_id->editAttributes() ?>>
        <?= $Page->employee_id->selectOptionListHtml("y_employee_id[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->employee_id->getErrorMessage(false) ?></div>
<?= $Page->employee_id->Lookup->getParamTag($Page, "p_y_employee_id") ?>
<script>
loadjs.ready("fprocess_actionsearch", function() {
    var options = { name: "y_employee_id[]", selectId: "fprocess_actionsearch_y_employee_id[]" };
    options.multiple = true;
    if (fprocess_actionsearch.lists.employee_id?.lookupOptions.length) {
        options.data = { id: "y_employee_id[]", form: "fprocess_actionsearch" };
    } else {
        options.ajax = { id: "y_employee_id[]", form: "fprocess_actionsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.process_action.fields.employee_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->qty->Visible) { // qty ?>
    <div id="r_qty" class="row"<?= $Page->qty->rowAttributes() ?>>
        <label for="x_qty" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_qty"><?= $Page->qty->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_qty" id="z_qty" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->qty->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_qty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->qty->getInputTextType() ?>" name="x_qty" id="x_qty" data-table="process_action" data-field="x_qty" value="<?= $Page->qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qty->formatPattern()) ?>"<?= $Page->qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->qty->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->roll_no->Visible) { // roll_no ?>
    <div id="r_roll_no" class="row"<?= $Page->roll_no->rowAttributes() ?>>
        <label for="x_roll_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_roll_no"><?= $Page->roll_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_roll_no" id="z_roll_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->roll_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_roll_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->roll_no->getInputTextType() ?>" name="x_roll_no" id="x_roll_no" data-table="process_action" data-field="x_roll_no" value="<?= $Page->roll_no->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->roll_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->roll_no->formatPattern()) ?>"<?= $Page->roll_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->roll_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->size_w->Visible) { // size_w ?>
    <div id="r_size_w" class="row"<?= $Page->size_w->rowAttributes() ?>>
        <label for="x_size_w" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_size_w"><?= $Page->size_w->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_size_w" id="z_size_w" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->size_w->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_size_w" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->size_w->getInputTextType() ?>" name="x_size_w" id="x_size_w" data-table="process_action" data-field="x_size_w" value="<?= $Page->size_w->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->size_w->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size_w->formatPattern()) ?>"<?= $Page->size_w->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->size_w->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->size_l->Visible) { // size_l ?>
    <div id="r_size_l" class="row"<?= $Page->size_l->rowAttributes() ?>>
        <label for="x_size_l" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_size_l"><?= $Page->size_l->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_size_l" id="z_size_l" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->size_l->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_size_l" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->size_l->getInputTextType() ?>" name="x_size_l" id="x_size_l" data-table="process_action" data-field="x_size_l" value="<?= $Page->size_l->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->size_l->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size_l->formatPattern()) ?>"<?= $Page->size_l->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->size_l->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->size_h->Visible) { // size_h ?>
    <div id="r_size_h" class="row"<?= $Page->size_h->rowAttributes() ?>>
        <label for="x_size_h" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_size_h"><?= $Page->size_h->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_size_h" id="z_size_h" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->size_h->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_size_h" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->size_h->getInputTextType() ?>" name="x_size_h" id="x_size_h" data-table="process_action" data-field="x_size_h" value="<?= $Page->size_h->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->size_h->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size_h->formatPattern()) ?>"<?= $Page->size_h->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->size_h->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->size_actual->Visible) { // size_actual ?>
    <div id="r_size_actual" class="row"<?= $Page->size_actual->rowAttributes() ?>>
        <label for="x_size_actual" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_size_actual"><?= $Page->size_actual->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_size_actual" id="z_size_actual" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->size_actual->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_size_actual" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->size_actual->getInputTextType() ?>" name="x_size_actual" id="x_size_actual" data-table="process_action" data-field="x_size_actual" value="<?= $Page->size_actual->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->size_actual->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size_actual->formatPattern()) ?>"<?= $Page->size_actual->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->size_actual->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->weight_actual->Visible) { // weight_actual ?>
    <div id="r_weight_actual" class="row"<?= $Page->weight_actual->rowAttributes() ?>>
        <label for="x_weight_actual" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_weight_actual"><?= $Page->weight_actual->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_weight_actual" id="z_weight_actual" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->weight_actual->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_weight_actual" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->weight_actual->getInputTextType() ?>" name="x_weight_actual" id="x_weight_actual" data-table="process_action" data-field="x_weight_actual" value="<?= $Page->weight_actual->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->weight_actual->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->weight_actual->formatPattern()) ?>"<?= $Page->weight_actual->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->weight_actual->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->lines_in_30cm->Visible) { // lines_in_30cm ?>
    <div id="r_lines_in_30cm" class="row"<?= $Page->lines_in_30cm->rowAttributes() ?>>
        <label for="x_lines_in_30cm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_lines_in_30cm"><?= $Page->lines_in_30cm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_lines_in_30cm" id="z_lines_in_30cm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->lines_in_30cm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_lines_in_30cm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->lines_in_30cm->getInputTextType() ?>" name="x_lines_in_30cm" id="x_lines_in_30cm" data-table="process_action" data-field="x_lines_in_30cm" value="<?= $Page->lines_in_30cm->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->lines_in_30cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->lines_in_30cm->formatPattern()) ?>"<?= $Page->lines_in_30cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->lines_in_30cm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_01->Visible) { // d_01 ?>
    <div id="r_d_01" class="row"<?= $Page->d_01->rowAttributes() ?>>
        <label for="x_d_01" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_d_01"><?= $Page->d_01->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_01" id="z_d_01" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_01->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_d_01" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_01->getInputTextType() ?>" name="x_d_01" id="x_d_01" data-table="process_action" data-field="x_d_01" value="<?= $Page->d_01->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->d_01->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_01->formatPattern()) ?>"<?= $Page->d_01->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_01->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_02->Visible) { // d_02 ?>
    <div id="r_d_02" class="row"<?= $Page->d_02->rowAttributes() ?>>
        <label for="x_d_02" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_d_02"><?= $Page->d_02->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_02" id="z_d_02" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_02->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_d_02" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_02->getInputTextType() ?>" name="x_d_02" id="x_d_02" data-table="process_action" data-field="x_d_02" value="<?= $Page->d_02->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->d_02->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_02->formatPattern()) ?>"<?= $Page->d_02->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_02->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_03->Visible) { // d_03 ?>
    <div id="r_d_03" class="row"<?= $Page->d_03->rowAttributes() ?>>
        <label for="x_d_03" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_d_03"><?= $Page->d_03->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_03" id="z_d_03" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_03->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_d_03" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_03->getInputTextType() ?>" name="x_d_03" id="x_d_03" data-table="process_action" data-field="x_d_03" value="<?= $Page->d_03->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->d_03->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_03->formatPattern()) ?>"<?= $Page->d_03->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_03->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_04->Visible) { // d_04 ?>
    <div id="r_d_04" class="row"<?= $Page->d_04->rowAttributes() ?>>
        <label for="x_d_04" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_d_04"><?= $Page->d_04->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_04" id="z_d_04" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_04->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_d_04" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_04->getInputTextType() ?>" name="x_d_04" id="x_d_04" data-table="process_action" data-field="x_d_04" value="<?= $Page->d_04->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->d_04->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_04->formatPattern()) ?>"<?= $Page->d_04->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_04->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_05->Visible) { // d_05 ?>
    <div id="r_d_05" class="row"<?= $Page->d_05->rowAttributes() ?>>
        <label for="x_d_05" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_d_05"><?= $Page->d_05->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_05" id="z_d_05" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_05->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_d_05" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_05->getInputTextType() ?>" name="x_d_05" id="x_d_05" data-table="process_action" data-field="x_d_05" value="<?= $Page->d_05->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->d_05->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_05->formatPattern()) ?>"<?= $Page->d_05->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_05->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_06->Visible) { // d_06 ?>
    <div id="r_d_06" class="row"<?= $Page->d_06->rowAttributes() ?>>
        <label for="x_d_06" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_d_06"><?= $Page->d_06->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_06" id="z_d_06" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_06->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_d_06" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_06->getInputTextType() ?>" name="x_d_06" id="x_d_06" data-table="process_action" data-field="x_d_06" value="<?= $Page->d_06->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->d_06->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_06->formatPattern()) ?>"<?= $Page->d_06->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_06->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_07->Visible) { // d_07 ?>
    <div id="r_d_07" class="row"<?= $Page->d_07->rowAttributes() ?>>
        <label for="x_d_07" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_d_07"><?= $Page->d_07->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_07" id="z_d_07" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_07->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_d_07" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_07->getInputTextType() ?>" name="x_d_07" id="x_d_07" data-table="process_action" data-field="x_d_07" value="<?= $Page->d_07->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->d_07->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_07->formatPattern()) ?>"<?= $Page->d_07->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_07->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_08->Visible) { // d_08 ?>
    <div id="r_d_08" class="row"<?= $Page->d_08->rowAttributes() ?>>
        <label for="x_d_08" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_d_08"><?= $Page->d_08->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_08" id="z_d_08" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_08->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_d_08" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_08->getInputTextType() ?>" name="x_d_08" id="x_d_08" data-table="process_action" data-field="x_d_08" value="<?= $Page->d_08->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->d_08->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_08->formatPattern()) ?>"<?= $Page->d_08->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_08->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_09->Visible) { // d_09 ?>
    <div id="r_d_09" class="row"<?= $Page->d_09->rowAttributes() ?>>
        <label for="x_d_09" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_d_09"><?= $Page->d_09->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_09" id="z_d_09" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_09->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_d_09" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_09->getInputTextType() ?>" name="x_d_09" id="x_d_09" data-table="process_action" data-field="x_d_09" value="<?= $Page->d_09->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->d_09->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_09->formatPattern()) ?>"<?= $Page->d_09->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_09->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_10->Visible) { // d_10 ?>
    <div id="r_d_10" class="row"<?= $Page->d_10->rowAttributes() ?>>
        <label for="x_d_10" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_d_10"><?= $Page->d_10->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_10" id="z_d_10" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_10->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_d_10" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_10->getInputTextType() ?>" name="x_d_10" id="x_d_10" data-table="process_action" data-field="x_d_10" value="<?= $Page->d_10->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->d_10->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_10->formatPattern()) ?>"<?= $Page->d_10->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_10->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->valuation->Visible) { // valuation ?>
    <div id="r_valuation" class="row"<?= $Page->valuation->rowAttributes() ?>>
        <label for="x_valuation" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_valuation"><?= $Page->valuation->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_valuation" id="z_valuation" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->valuation->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_valuation" class="ew-search-field ew-search-field-single">
    <select
        id="x_valuation"
        name="x_valuation"
        class="form-select ew-select<?= $Page->valuation->isInvalidClass() ?>"
        <?php if (!$Page->valuation->IsNativeSelect) { ?>
        data-select2-id="fprocess_actionsearch_x_valuation"
        <?php } ?>
        data-table="process_action"
        data-field="x_valuation"
        data-value-separator="<?= $Page->valuation->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->valuation->getPlaceHolder()) ?>"
        <?= $Page->valuation->editAttributes() ?>>
        <?= $Page->valuation->selectOptionListHtml("x_valuation") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->valuation->getErrorMessage(false) ?></div>
<?php if (!$Page->valuation->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_actionsearch", function() {
    var options = { name: "x_valuation", selectId: "fprocess_actionsearch_x_valuation" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_actionsearch.lists.valuation?.lookupOptions.length) {
        options.data = { id: "x_valuation", form: "fprocess_actionsearch" };
    } else {
        options.ajax = { id: "x_valuation", form: "fprocess_actionsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action.fields.valuation.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->deduction->Visible) { // deduction ?>
    <div id="r_deduction" class="row"<?= $Page->deduction->rowAttributes() ?>>
        <label for="x_deduction" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_deduction"><?= $Page->deduction->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_deduction" id="z_deduction" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->deduction->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_deduction" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->deduction->getInputTextType() ?>" name="x_deduction" id="x_deduction" data-table="process_action" data-field="x_deduction" value="<?= $Page->deduction->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->deduction->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->deduction->formatPattern()) ?>"<?= $Page->deduction->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->deduction->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remark->Visible) { // remark ?>
    <div id="r_remark" class="row"<?= $Page->remark->rowAttributes() ?>>
        <label for="x_remark" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_remark"><?= $Page->remark->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remark" id="z_remark" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remark->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_remark" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remark->getInputTextType() ?>" name="x_remark" id="x_remark" data-table="process_action" data-field="x_remark" value="<?= $Page->remark->EditValue ?>" size="30" maxlength="500" placeholder="<?= HtmlEncode($Page->remark->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remark->formatPattern()) ?>"<?= $Page->remark->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remark->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->upload->Visible) { // upload ?>
    <div id="r_upload" class="row"<?= $Page->upload->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_upload"><?= $Page->upload->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_upload" id="z_upload" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->upload->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_upload" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->upload->getInputTextType() ?>" name="x_upload" id="x_upload" data-table="process_action" data-field="x_upload" value="<?= $Page->upload->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->upload->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->upload->formatPattern()) ?>"<?= $Page->upload->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->upload->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fprocess_actionsearch_x_operator"
        <?php } ?>
        data-table="process_action"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_actionsearch", function() {
    var options = { name: "x_operator", selectId: "fprocess_actionsearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_actionsearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fprocess_actionsearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fprocess_actionsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_datetime"><?= $Page->datetime->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_datetime" id="z_datetime" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->datetime->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->datetime->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_process_action_datetime" class="ew-search-field">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="process_action" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprocess_actionsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprocess_actionsearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_process_action_datetime" class="ew-search-field2 d-none">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="y_datetime" id="y_datetime" data-table="process_action" data-field="x_datetime" value="<?= $Page->datetime->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprocess_actionsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprocess_actionsearch", "y_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fprocess_actionsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fprocess_actionsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fprocess_actionsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("process_action");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
