<?php

namespace PHPMaker2024\fibre;

// Page object
$ProcessActionPaymentSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { process_action_payment: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fprocess_action_paymentsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fprocess_action_paymentsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["location", [], fields.location.isInvalid],
            ["process", [], fields.process.isInvalid],
            ["emp_id", [], fields.emp_id.isInvalid],
            ["code", [ew.Validators.float], fields.code.isInvalid],
            ["y_code", [ew.Validators.between], false],
            ["ref", [], fields.ref.isInvalid],
            ["size_wl", [ew.Validators.integer], fields.size_wl.isInvalid],
            ["process_", [ew.Validators.integer], fields.process_.isInvalid],
            ["final_amount", [ew.Validators.float], fields.final_amount.isInvalid],
            ["amount", [ew.Validators.float], fields.amount.isInvalid],
            ["c_charge", [ew.Validators.float], fields.c_charge.isInvalid],
            ["c_id", [], fields.c_id.isInvalid],
            ["custom_size", [ew.Validators.float], fields.custom_size.isInvalid],
            ["ded_jc", [ew.Validators.float], fields.ded_jc.isInvalid],
            ["ded_pa", [ew.Validators.float], fields.ded_pa.isInvalid],
            ["payment_type", [], fields.payment_type.isInvalid],
            ["sqm", [ew.Validators.float], fields.sqm.isInvalid],
            ["sqm_grp", [ew.Validators.float], fields.sqm_grp.isInvalid],
            ["_2_srm", [ew.Validators.integer], fields._2_srm.isInvalid],
            ["_4_srm", [ew.Validators.integer], fields._4_srm.isInvalid],
            ["process_fix", [], fields.process_fix.isInvalid],
            ["method", [], fields.method.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["y_datetime", [ew.Validators.between], false],
            ["payment", [], fields.payment.isInvalid],
            ["y_payment", [ew.Validators.between], false],
            ["grp", [ew.Validators.integer], fields.grp.isInvalid],
            ["remark", [], fields.remark.isInvalid],
            ["pps", [ew.Validators.integer], fields.pps.isInvalid],
            ["category", [], fields.category.isInvalid],
            ["c_method", [ew.Validators.integer], fields.c_method.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "location": <?= $Page->location->toClientList($Page) ?>,
            "process": <?= $Page->process->toClientList($Page) ?>,
            "emp_id": <?= $Page->emp_id->toClientList($Page) ?>,
            "ref": <?= $Page->ref->toClientList($Page) ?>,
            "c_id": <?= $Page->c_id->toClientList($Page) ?>,
            "payment_type": <?= $Page->payment_type->toClientList($Page) ?>,
            "process_fix": <?= $Page->process_fix->toClientList($Page) ?>,
            "method": <?= $Page->method->toClientList($Page) ?>,
            "payment": <?= $Page->payment->toClientList($Page) ?>,
            "category": <?= $Page->category->toClientList($Page) ?>,
            "c_method": <?= $Page->c_method->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fprocess_action_paymentsearch" id="fprocess_action_paymentsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="process_action_payment">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_payment_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_payment_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="process_action_payment" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
    <div id="r_location" class="row"<?= $Page->location->rowAttributes() ?>>
        <label for="x_location" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_payment_location"><?= $Page->location->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_location" id="z_location" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->location->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_payment_location" class="ew-search-field ew-search-field-single">
    <select
        id="x_location"
        name="x_location"
        class="form-select ew-select<?= $Page->location->isInvalidClass() ?>"
        <?php if (!$Page->location->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_paymentsearch_x_location"
        <?php } ?>
        data-table="process_action_payment"
        data-field="x_location"
        data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>"
        <?= $Page->location->editAttributes() ?>>
        <?= $Page->location->selectOptionListHtml("x_location") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->location->getErrorMessage(false) ?></div>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
<?php if (!$Page->location->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_paymentsearch", function() {
    var options = { name: "x_location", selectId: "fprocess_action_paymentsearch_x_location" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_paymentsearch.lists.location?.lookupOptions.length) {
        options.data = { id: "x_location", form: "fprocess_action_paymentsearch" };
    } else {
        options.ajax = { id: "x_location", form: "fprocess_action_paymentsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_payment.fields.location.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->process->Visible) { // process ?>
    <div id="r_process" class="row"<?= $Page->process->rowAttributes() ?>>
        <label for="x_process" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_payment_process"><?= $Page->process->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_process" id="z_process" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->process->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_payment_process" class="ew-search-field ew-search-field-single">
    <select
        id="x_process"
        name="x_process"
        class="form-select ew-select<?= $Page->process->isInvalidClass() ?>"
        <?php if (!$Page->process->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_paymentsearch_x_process"
        <?php } ?>
        data-table="process_action_payment"
        data-field="x_process"
        data-value-separator="<?= $Page->process->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process->getPlaceHolder()) ?>"
        <?= $Page->process->editAttributes() ?>>
        <?= $Page->process->selectOptionListHtml("x_process") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->process->getErrorMessage(false) ?></div>
<?= $Page->process->Lookup->getParamTag($Page, "p_x_process") ?>
<?php if (!$Page->process->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_paymentsearch", function() {
    var options = { name: "x_process", selectId: "fprocess_action_paymentsearch_x_process" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_paymentsearch.lists.process?.lookupOptions.length) {
        options.data = { id: "x_process", form: "fprocess_action_paymentsearch" };
    } else {
        options.ajax = { id: "x_process", form: "fprocess_action_paymentsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_payment.fields.process.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->emp_id->Visible) { // emp_id ?>
    <div id="r_emp_id" class="row"<?= $Page->emp_id->rowAttributes() ?>>
        <label for="x_emp_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_payment_emp_id"><?= $Page->emp_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_emp_id" id="z_emp_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->emp_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_payment_emp_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_emp_id"
        name="x_emp_id"
        class="form-select ew-select<?= $Page->emp_id->isInvalidClass() ?>"
        <?php if (!$Page->emp_id->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_paymentsearch_x_emp_id"
        <?php } ?>
        data-table="process_action_payment"
        data-field="x_emp_id"
        data-value-separator="<?= $Page->emp_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->emp_id->getPlaceHolder()) ?>"
        <?= $Page->emp_id->editAttributes() ?>>
        <?= $Page->emp_id->selectOptionListHtml("x_emp_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->emp_id->getErrorMessage(false) ?></div>
<?= $Page->emp_id->Lookup->getParamTag($Page, "p_x_emp_id") ?>
<?php if (!$Page->emp_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_paymentsearch", function() {
    var options = { name: "x_emp_id", selectId: "fprocess_action_paymentsearch_x_emp_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_paymentsearch.lists.emp_id?.lookupOptions.length) {
        options.data = { id: "x_emp_id", form: "fprocess_action_paymentsearch" };
    } else {
        options.ajax = { id: "x_emp_id", form: "fprocess_action_paymentsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_payment.fields.emp_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->code->Visible) { // code ?>
    <div id="r_code" class="row"<?= $Page->code->rowAttributes() ?>>
        <label for="x_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_payment_code"><?= $Page->code->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_code" id="z_code" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->code->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->code->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_process_action_payment_code" class="ew-search-field">
<input type="<?= $Page->code->getInputTextType() ?>" name="x_code" id="x_code" data-table="process_action_payment" data-field="x_code" value="<?= $Page->code->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->code->formatPattern()) ?>"<?= $Page->code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->code->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_process_action_payment_code" class="ew-search-field2 d-none">
<input type="<?= $Page->code->getInputTextType() ?>" name="y_code" id="y_code" data-table="process_action_payment" data-field="x_code" value="<?= $Page->code->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->code->formatPattern()) ?>"<?= $Page->code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ref->Visible) { // ref ?>
    <div id="r_ref" class="row"<?= $Page->ref->rowAttributes() ?>>
        <label for="x_ref" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_payment_ref"><?= $Page->ref->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_ref" id="z_ref" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ref->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_payment_ref" class="ew-search-field ew-search-field-single">
    <select
        id="x_ref"
        name="x_ref"
        class="form-select ew-select<?= $Page->ref->isInvalidClass() ?>"
        <?php if (!$Page->ref->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_paymentsearch_x_ref"
        <?php } ?>
        data-table="process_action_payment"
        data-field="x_ref"
        data-value-separator="<?= $Page->ref->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ref->getPlaceHolder()) ?>"
        <?= $Page->ref->editAttributes() ?>>
        <?= $Page->ref->selectOptionListHtml("x_ref") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->ref->getErrorMessage(false) ?></div>
<?= $Page->ref->Lookup->getParamTag($Page, "p_x_ref") ?>
<?php if (!$Page->ref->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_paymentsearch", function() {
    var options = { name: "x_ref", selectId: "fprocess_action_paymentsearch_x_ref" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_paymentsearch.lists.ref?.lookupOptions.length) {
        options.data = { id: "x_ref", form: "fprocess_action_paymentsearch" };
    } else {
        options.ajax = { id: "x_ref", form: "fprocess_action_paymentsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_payment.fields.ref.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->size_wl->Visible) { // size_wl ?>
    <div id="r_size_wl" class="row"<?= $Page->size_wl->rowAttributes() ?>>
        <label for="x_size_wl" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_payment_size_wl"><?= $Page->size_wl->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_size_wl" id="z_size_wl" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->size_wl->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_payment_size_wl" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->size_wl->getInputTextType() ?>" name="x_size_wl" id="x_size_wl" data-table="process_action_payment" data-field="x_size_wl" value="<?= $Page->size_wl->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->size_wl->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size_wl->formatPattern()) ?>"<?= $Page->size_wl->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->size_wl->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->process_->Visible) { // process_@ ?>
    <div id="r_process_" class="row"<?= $Page->process_->rowAttributes() ?>>
        <label for="x_process_" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_payment_process_"><?= $Page->process_->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_process_" id="z_process_" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->process_->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_payment_process_" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->process_->getInputTextType() ?>" name="x_process_" id="x_process_" data-table="process_action_payment" data-field="x_process_" value="<?= $Page->process_->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->process_->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->process_->formatPattern()) ?>"<?= $Page->process_->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->process_->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->final_amount->Visible) { // final_amount ?>
    <div id="r_final_amount" class="row"<?= $Page->final_amount->rowAttributes() ?>>
        <label for="x_final_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_payment_final_amount"><?= $Page->final_amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_final_amount" id="z_final_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->final_amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_payment_final_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->final_amount->getInputTextType() ?>" name="x_final_amount" id="x_final_amount" data-table="process_action_payment" data-field="x_final_amount" value="<?= $Page->final_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->final_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->final_amount->formatPattern()) ?>"<?= $Page->final_amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->final_amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
    <div id="r_amount" class="row"<?= $Page->amount->rowAttributes() ?>>
        <label for="x_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_payment_amount"><?= $Page->amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_amount" id="z_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_payment_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->amount->getInputTextType() ?>" name="x_amount" id="x_amount" data-table="process_action_payment" data-field="x_amount" value="<?= $Page->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->c_charge->Visible) { // c_charge ?>
    <div id="r_c_charge" class="row"<?= $Page->c_charge->rowAttributes() ?>>
        <label for="x_c_charge" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_payment_c_charge"><?= $Page->c_charge->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_c_charge" id="z_c_charge" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->c_charge->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_payment_c_charge" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->c_charge->getInputTextType() ?>" name="x_c_charge" id="x_c_charge" data-table="process_action_payment" data-field="x_c_charge" value="<?= $Page->c_charge->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->c_charge->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->c_charge->formatPattern()) ?>"<?= $Page->c_charge->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->c_charge->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->c_id->Visible) { // c_id ?>
    <div id="r_c_id" class="row"<?= $Page->c_id->rowAttributes() ?>>
        <label for="x_c_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_payment_c_id"><?= $Page->c_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_c_id" id="z_c_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->c_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_payment_c_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_c_id"
        name="x_c_id"
        class="form-select ew-select<?= $Page->c_id->isInvalidClass() ?>"
        <?php if (!$Page->c_id->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_paymentsearch_x_c_id"
        <?php } ?>
        data-table="process_action_payment"
        data-field="x_c_id"
        data-value-separator="<?= $Page->c_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->c_id->getPlaceHolder()) ?>"
        <?= $Page->c_id->editAttributes() ?>>
        <?= $Page->c_id->selectOptionListHtml("x_c_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->c_id->getErrorMessage(false) ?></div>
<?= $Page->c_id->Lookup->getParamTag($Page, "p_x_c_id") ?>
<?php if (!$Page->c_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_paymentsearch", function() {
    var options = { name: "x_c_id", selectId: "fprocess_action_paymentsearch_x_c_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_paymentsearch.lists.c_id?.lookupOptions.length) {
        options.data = { id: "x_c_id", form: "fprocess_action_paymentsearch" };
    } else {
        options.ajax = { id: "x_c_id", form: "fprocess_action_paymentsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_payment.fields.c_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->custom_size->Visible) { // custom_size ?>
    <div id="r_custom_size" class="row"<?= $Page->custom_size->rowAttributes() ?>>
        <label for="x_custom_size" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_payment_custom_size"><?= $Page->custom_size->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_custom_size" id="z_custom_size" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->custom_size->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_payment_custom_size" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->custom_size->getInputTextType() ?>" name="x_custom_size" id="x_custom_size" data-table="process_action_payment" data-field="x_custom_size" value="<?= $Page->custom_size->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->custom_size->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->custom_size->formatPattern()) ?>"<?= $Page->custom_size->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->custom_size->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ded_jc->Visible) { // ded_jc ?>
    <div id="r_ded_jc" class="row"<?= $Page->ded_jc->rowAttributes() ?>>
        <label for="x_ded_jc" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_payment_ded_jc"><?= $Page->ded_jc->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_ded_jc" id="z_ded_jc" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ded_jc->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_payment_ded_jc" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ded_jc->getInputTextType() ?>" name="x_ded_jc" id="x_ded_jc" data-table="process_action_payment" data-field="x_ded_jc" value="<?= $Page->ded_jc->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->ded_jc->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ded_jc->formatPattern()) ?>"<?= $Page->ded_jc->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ded_jc->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ded_pa->Visible) { // ded_pa ?>
    <div id="r_ded_pa" class="row"<?= $Page->ded_pa->rowAttributes() ?>>
        <label for="x_ded_pa" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_payment_ded_pa"><?= $Page->ded_pa->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_ded_pa" id="z_ded_pa" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ded_pa->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_payment_ded_pa" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ded_pa->getInputTextType() ?>" name="x_ded_pa" id="x_ded_pa" data-table="process_action_payment" data-field="x_ded_pa" value="<?= $Page->ded_pa->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->ded_pa->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ded_pa->formatPattern()) ?>"<?= $Page->ded_pa->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ded_pa->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->payment_type->Visible) { // payment_type ?>
    <div id="r_payment_type" class="row"<?= $Page->payment_type->rowAttributes() ?>>
        <label for="x_payment_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_payment_payment_type"><?= $Page->payment_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_payment_type" id="z_payment_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->payment_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_payment_payment_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_payment_type"
        name="x_payment_type"
        class="form-select ew-select<?= $Page->payment_type->isInvalidClass() ?>"
        <?php if (!$Page->payment_type->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_paymentsearch_x_payment_type"
        <?php } ?>
        data-table="process_action_payment"
        data-field="x_payment_type"
        data-value-separator="<?= $Page->payment_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->payment_type->getPlaceHolder()) ?>"
        <?= $Page->payment_type->editAttributes() ?>>
        <?= $Page->payment_type->selectOptionListHtml("x_payment_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->payment_type->getErrorMessage(false) ?></div>
<?php if (!$Page->payment_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_paymentsearch", function() {
    var options = { name: "x_payment_type", selectId: "fprocess_action_paymentsearch_x_payment_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_paymentsearch.lists.payment_type?.lookupOptions.length) {
        options.data = { id: "x_payment_type", form: "fprocess_action_paymentsearch" };
    } else {
        options.ajax = { id: "x_payment_type", form: "fprocess_action_paymentsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_payment.fields.payment_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
    <div id="r_sqm" class="row"<?= $Page->sqm->rowAttributes() ?>>
        <label for="x_sqm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_payment_sqm"><?= $Page->sqm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_sqm" id="z_sqm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sqm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_payment_sqm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sqm->getInputTextType() ?>" name="x_sqm" id="x_sqm" data-table="process_action_payment" data-field="x_sqm" value="<?= $Page->sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm->formatPattern()) ?>"<?= $Page->sqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sqm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sqm_grp->Visible) { // sqm_grp ?>
    <div id="r_sqm_grp" class="row"<?= $Page->sqm_grp->rowAttributes() ?>>
        <label for="x_sqm_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_payment_sqm_grp"><?= $Page->sqm_grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_sqm_grp" id="z_sqm_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sqm_grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_payment_sqm_grp" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sqm_grp->getInputTextType() ?>" name="x_sqm_grp" id="x_sqm_grp" data-table="process_action_payment" data-field="x_sqm_grp" value="<?= $Page->sqm_grp->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sqm_grp->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm_grp->formatPattern()) ?>"<?= $Page->sqm_grp->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sqm_grp->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_2_srm->Visible) { // 2_srm ?>
    <div id="r__2_srm" class="row"<?= $Page->_2_srm->rowAttributes() ?>>
        <label for="x__2_srm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_payment__2_srm"><?= $Page->_2_srm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__2_srm" id="z__2_srm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_2_srm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_payment__2_srm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_2_srm->getInputTextType() ?>" name="x__2_srm" id="x__2_srm" data-table="process_action_payment" data-field="x__2_srm" value="<?= $Page->_2_srm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_2_srm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_2_srm->formatPattern()) ?>"<?= $Page->_2_srm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_2_srm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_4_srm->Visible) { // 4_srm ?>
    <div id="r__4_srm" class="row"<?= $Page->_4_srm->rowAttributes() ?>>
        <label for="x__4_srm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_payment__4_srm"><?= $Page->_4_srm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__4_srm" id="z__4_srm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_4_srm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_payment__4_srm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_4_srm->getInputTextType() ?>" name="x__4_srm" id="x__4_srm" data-table="process_action_payment" data-field="x__4_srm" value="<?= $Page->_4_srm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_4_srm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_4_srm->formatPattern()) ?>"<?= $Page->_4_srm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_4_srm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->process_fix->Visible) { // process_fix ?>
    <div id="r_process_fix" class="row"<?= $Page->process_fix->rowAttributes() ?>>
        <label for="x_process_fix" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_payment_process_fix"><?= $Page->process_fix->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_process_fix" id="z_process_fix" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->process_fix->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_payment_process_fix" class="ew-search-field ew-search-field-single">
    <select
        id="x_process_fix"
        name="x_process_fix"
        class="form-select ew-select<?= $Page->process_fix->isInvalidClass() ?>"
        <?php if (!$Page->process_fix->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_paymentsearch_x_process_fix"
        <?php } ?>
        data-table="process_action_payment"
        data-field="x_process_fix"
        data-value-separator="<?= $Page->process_fix->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process_fix->getPlaceHolder()) ?>"
        <?= $Page->process_fix->editAttributes() ?>>
        <?= $Page->process_fix->selectOptionListHtml("x_process_fix") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->process_fix->getErrorMessage(false) ?></div>
<?php if (!$Page->process_fix->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_paymentsearch", function() {
    var options = { name: "x_process_fix", selectId: "fprocess_action_paymentsearch_x_process_fix" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_paymentsearch.lists.process_fix?.lookupOptions.length) {
        options.data = { id: "x_process_fix", form: "fprocess_action_paymentsearch" };
    } else {
        options.ajax = { id: "x_process_fix", form: "fprocess_action_paymentsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_payment.fields.process_fix.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->method->Visible) { // method ?>
    <div id="r_method" class="row"<?= $Page->method->rowAttributes() ?>>
        <label for="x_method" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_payment_method"><?= $Page->method->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_method" id="z_method" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->method->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_payment_method" class="ew-search-field ew-search-field-single">
    <select
        id="x_method"
        name="x_method"
        class="form-select ew-select<?= $Page->method->isInvalidClass() ?>"
        <?php if (!$Page->method->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_paymentsearch_x_method"
        <?php } ?>
        data-table="process_action_payment"
        data-field="x_method"
        data-value-separator="<?= $Page->method->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->method->getPlaceHolder()) ?>"
        <?= $Page->method->editAttributes() ?>>
        <?= $Page->method->selectOptionListHtml("x_method") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->method->getErrorMessage(false) ?></div>
<?php if (!$Page->method->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_paymentsearch", function() {
    var options = { name: "x_method", selectId: "fprocess_action_paymentsearch_x_method" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_paymentsearch.lists.method?.lookupOptions.length) {
        options.data = { id: "x_method", form: "fprocess_action_paymentsearch" };
    } else {
        options.ajax = { id: "x_method", form: "fprocess_action_paymentsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_payment.fields.method.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_payment_datetime"><?= $Page->datetime->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_datetime" id="z_datetime" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->datetime->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->datetime->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_process_action_payment_datetime" class="ew-search-field">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="process_action_payment" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprocess_action_paymentsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprocess_action_paymentsearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_process_action_payment_datetime" class="ew-search-field2 d-none">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="y_datetime" id="y_datetime" data-table="process_action_payment" data-field="x_datetime" value="<?= $Page->datetime->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprocess_action_paymentsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprocess_action_paymentsearch", "y_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->payment->Visible) { // payment ?>
    <div id="r_payment" class="row"<?= $Page->payment->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_payment_payment"><?= $Page->payment->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->payment->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_payment" id="z_payment" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->payment->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->payment->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_process_action_payment_payment" class="ew-search-field">
    <select
        id="x_payment[]"
        name="x_payment[]"
        class="form-select ew-select<?= $Page->payment->isInvalidClass() ?>"
        <?php if (!$Page->payment->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_paymentsearch_x_payment[]"
        <?php } ?>
        data-table="process_action_payment"
        data-field="x_payment"
        data-dropdown
        multiple
        size="1"
        data-value-separator="<?= $Page->payment->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->payment->getPlaceHolder()) ?>"
        <?= $Page->payment->editAttributes() ?>>
        <?= $Page->payment->selectOptionListHtml("x_payment[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->payment->getErrorMessage(false) ?></div>
<?= $Page->payment->Lookup->getParamTag($Page, "p_x_payment") ?>
<?php if (!$Page->payment->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_paymentsearch", function() {
    var options = { name: "x_payment[]", selectId: "fprocess_action_paymentsearch_x_payment[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.columns = el.dataset.repeatcolumn || 4;
    options.dropdown = !ew.IS_MOBILE && options.columns > 0; // Use custom dropdown
    el.dataset.dropdown = options.dropdown;
    if (options.dropdown) {
        options.dropdownAutoWidth = true;
        options.dropdownCssClass = "ew-select-dropdown process_action_payment-x_payment-dropdown ew-select-" + (options.multiple ? "multiple" : "one");
        if (options.columns > 1)
            options.dropdownCssClass += " ew-repeat-column";
    }
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_paymentsearch.lists.payment?.lookupOptions.length) {
        options.data = { id: "x_payment[]", form: "fprocess_action_paymentsearch" };
    } else {
        options.ajax = { id: "x_payment[]", form: "fprocess_action_paymentsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_payment.fields.payment.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_process_action_payment_payment" class="ew-search-field2 d-none">
    <select
        id="y_payment[]"
        name="y_payment[]"
        class="form-select ew-select<?= $Page->payment->isInvalidClass() ?>"
        <?php if (!$Page->payment->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_paymentsearch_y_payment[]"
        <?php } ?>
        data-table="process_action_payment"
        data-field="x_payment"
        data-dropdown
        multiple
        size="1"
        data-value-separator="<?= $Page->payment->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->payment->getPlaceHolder()) ?>"
        <?= $Page->payment->editAttributes() ?>>
        <?= $Page->payment->selectOptionListHtml("y_payment[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->payment->getErrorMessage(false) ?></div>
<?= $Page->payment->Lookup->getParamTag($Page, "p_y_payment") ?>
<?php if (!$Page->payment->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_paymentsearch", function() {
    var options = { name: "y_payment[]", selectId: "fprocess_action_paymentsearch_y_payment[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.columns = el.dataset.repeatcolumn || 4;
    options.dropdown = !ew.IS_MOBILE && options.columns > 0; // Use custom dropdown
    el.dataset.dropdown = options.dropdown;
    if (options.dropdown) {
        options.dropdownAutoWidth = true;
        options.dropdownCssClass = "ew-select-dropdown process_action_payment-x_payment-dropdown ew-select-" + (options.multiple ? "multiple" : "one");
        if (options.columns > 1)
            options.dropdownCssClass += " ew-repeat-column";
    }
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_paymentsearch.lists.payment?.lookupOptions.length) {
        options.data = { id: "y_payment[]", form: "fprocess_action_paymentsearch" };
    } else {
        options.ajax = { id: "y_payment[]", form: "fprocess_action_paymentsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_payment.fields.payment.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp" class="row"<?= $Page->grp->rowAttributes() ?>>
        <label for="x_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_payment_grp"><?= $Page->grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_payment_grp" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->grp->getInputTextType() ?>" name="x_grp" id="x_grp" data-table="process_action_payment" data-field="x_grp" value="<?= $Page->grp->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->grp->formatPattern()) ?>"<?= $Page->grp->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remark->Visible) { // remark ?>
    <div id="r_remark" class="row"<?= $Page->remark->rowAttributes() ?>>
        <label for="x_remark" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_payment_remark"><?= $Page->remark->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remark" id="z_remark" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remark->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_payment_remark" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remark->getInputTextType() ?>" name="x_remark" id="x_remark" data-table="process_action_payment" data-field="x_remark" value="<?= $Page->remark->EditValue ?>" size="30" maxlength="500" placeholder="<?= HtmlEncode($Page->remark->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remark->formatPattern()) ?>"<?= $Page->remark->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remark->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pps->Visible) { // pps ?>
    <div id="r_pps" class="row"<?= $Page->pps->rowAttributes() ?>>
        <label for="x_pps" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_payment_pps"><?= $Page->pps->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pps" id="z_pps" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pps->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_payment_pps" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pps->getInputTextType() ?>" name="x_pps" id="x_pps" data-table="process_action_payment" data-field="x_pps" value="<?= $Page->pps->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pps->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pps->formatPattern()) ?>"<?= $Page->pps->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pps->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
    <div id="r_category" class="row"<?= $Page->category->rowAttributes() ?>>
        <label for="x_category" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_payment_category"><?= $Page->category->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_category" id="z_category" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->category->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_payment_category" class="ew-search-field ew-search-field-single">
    <select
        id="x_category"
        name="x_category"
        class="form-select ew-select<?= $Page->category->isInvalidClass() ?>"
        <?php if (!$Page->category->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_paymentsearch_x_category"
        <?php } ?>
        data-table="process_action_payment"
        data-field="x_category"
        data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->category->getPlaceHolder()) ?>"
        <?= $Page->category->editAttributes() ?>>
        <?= $Page->category->selectOptionListHtml("x_category") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->category->getErrorMessage(false) ?></div>
<?= $Page->category->Lookup->getParamTag($Page, "p_x_category") ?>
<?php if (!$Page->category->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_paymentsearch", function() {
    var options = { name: "x_category", selectId: "fprocess_action_paymentsearch_x_category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_paymentsearch.lists.category?.lookupOptions.length) {
        options.data = { id: "x_category", form: "fprocess_action_paymentsearch" };
    } else {
        options.ajax = { id: "x_category", form: "fprocess_action_paymentsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_payment.fields.category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->c_method->Visible) { // c_method ?>
    <div id="r_c_method" class="row"<?= $Page->c_method->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_payment_c_method"><?= $Page->c_method->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_c_method" id="z_c_method" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->c_method->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_payment_c_method" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->c_method->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_c_method" class="ew-auto-suggest">
    <input type="<?= $Page->c_method->getInputTextType() ?>" class="form-control" name="sv_x_c_method" id="sv_x_c_method" value="<?= RemoveHtml($Page->c_method->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->c_method->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->c_method->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->c_method->formatPattern()) ?>"<?= $Page->c_method->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="process_action_payment" data-field="x_c_method" data-input="sv_x_c_method" data-value-separator="<?= $Page->c_method->displayValueSeparatorAttribute() ?>" name="x_c_method" id="x_c_method" value="<?= HtmlEncode($Page->c_method->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->c_method->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fprocess_action_paymentsearch", function() {
    fprocess_action_paymentsearch.createAutoSuggest(Object.assign({"id":"x_c_method","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->c_method->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.process_action_payment.fields.c_method.autoSuggestOptions));
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fprocess_action_paymentsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fprocess_action_paymentsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fprocess_action_paymentsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("process_action_payment");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
