<?php

namespace PHPMaker2024\fibre;

// Page object
$ProcessActionPaymentPeSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { process_action_payment_pe: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fprocess_action_payment_pesearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fprocess_action_payment_pesearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["location", [], fields.location.isInvalid],
            ["process", [], fields.process.isInvalid],
            ["emp_id", [], fields.emp_id.isInvalid],
            ["y_emp_id", [ew.Validators.between], false],
            ["contractor", [], fields.contractor.isInvalid],
            ["qty", [ew.Validators.float], fields.qty.isInvalid],
            ["sqm", [ew.Validators.float], fields.sqm.isInvalid],
            ["amount", [ew.Validators.float], fields.amount.isInvalid],
            ["payment", [], fields.payment.isInvalid],
            ["remarks", [], fields.remarks.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "location": <?= $Page->location->toClientList($Page) ?>,
            "process": <?= $Page->process->toClientList($Page) ?>,
            "emp_id": <?= $Page->emp_id->toClientList($Page) ?>,
            "contractor": <?= $Page->contractor->toClientList($Page) ?>,
            "payment": <?= $Page->payment->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fprocess_action_payment_pesearch" id="fprocess_action_payment_pesearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="process_action_payment_pe">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->location->Visible) { // location ?>
    <div id="r_location" class="row"<?= $Page->location->rowAttributes() ?>>
        <label for="x_location" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_payment_pe_location"><?= $Page->location->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_location" id="z_location" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->location->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_payment_pe_location" class="ew-search-field ew-search-field-single">
    <select
        id="x_location"
        name="x_location"
        class="form-select ew-select<?= $Page->location->isInvalidClass() ?>"
        <?php if (!$Page->location->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_payment_pesearch_x_location"
        <?php } ?>
        data-table="process_action_payment_pe"
        data-field="x_location"
        data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>"
        <?= $Page->location->editAttributes() ?>>
        <?= $Page->location->selectOptionListHtml("x_location") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->location->getErrorMessage(false) ?></div>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
<?php if (!$Page->location->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_payment_pesearch", function() {
    var options = { name: "x_location", selectId: "fprocess_action_payment_pesearch_x_location" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_payment_pesearch.lists.location?.lookupOptions.length) {
        options.data = { id: "x_location", form: "fprocess_action_payment_pesearch" };
    } else {
        options.ajax = { id: "x_location", form: "fprocess_action_payment_pesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_payment_pe.fields.location.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->process->Visible) { // process ?>
    <div id="r_process" class="row"<?= $Page->process->rowAttributes() ?>>
        <label for="x_process" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_payment_pe_process"><?= $Page->process->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_process" id="z_process" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->process->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_payment_pe_process" class="ew-search-field ew-search-field-single">
    <select
        id="x_process"
        name="x_process"
        class="form-select ew-select<?= $Page->process->isInvalidClass() ?>"
        <?php if (!$Page->process->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_payment_pesearch_x_process"
        <?php } ?>
        data-table="process_action_payment_pe"
        data-field="x_process"
        data-value-separator="<?= $Page->process->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process->getPlaceHolder()) ?>"
        <?= $Page->process->editAttributes() ?>>
        <?= $Page->process->selectOptionListHtml("x_process") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->process->getErrorMessage(false) ?></div>
<?= $Page->process->Lookup->getParamTag($Page, "p_x_process") ?>
<?php if (!$Page->process->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_payment_pesearch", function() {
    var options = { name: "x_process", selectId: "fprocess_action_payment_pesearch_x_process" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_payment_pesearch.lists.process?.lookupOptions.length) {
        options.data = { id: "x_process", form: "fprocess_action_payment_pesearch" };
    } else {
        options.ajax = { id: "x_process", form: "fprocess_action_payment_pesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_payment_pe.fields.process.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->emp_id->Visible) { // emp_id ?>
    <div id="r_emp_id" class="row"<?= $Page->emp_id->rowAttributes() ?>>
        <label for="x_emp_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_payment_pe_emp_id"><?= $Page->emp_id->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->emp_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_emp_id" id="z_emp_id" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->emp_id->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->emp_id->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_process_action_payment_pe_emp_id" class="ew-search-field">
    <select
        id="x_emp_id"
        name="x_emp_id"
        class="form-control ew-select<?= $Page->emp_id->isInvalidClass() ?>"
        data-select2-id="fprocess_action_payment_pesearch_x_emp_id"
        data-table="process_action_payment_pe"
        data-field="x_emp_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->emp_id->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->emp_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->emp_id->getPlaceHolder()) ?>"
        <?= $Page->emp_id->editAttributes() ?>>
        <?= $Page->emp_id->selectOptionListHtml("x_emp_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->emp_id->getErrorMessage(false) ?></div>
<?= $Page->emp_id->Lookup->getParamTag($Page, "p_x_emp_id") ?>
<script>
loadjs.ready("fprocess_action_payment_pesearch", function() {
    var options = { name: "x_emp_id", selectId: "fprocess_action_payment_pesearch_x_emp_id" };
    if (fprocess_action_payment_pesearch.lists.emp_id?.lookupOptions.length) {
        options.data = { id: "x_emp_id", form: "fprocess_action_payment_pesearch" };
    } else {
        options.ajax = { id: "x_emp_id", form: "fprocess_action_payment_pesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.process_action_payment_pe.fields.emp_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_process_action_payment_pe_emp_id" class="ew-search-field2 d-none">
    <select
        id="y_emp_id"
        name="y_emp_id"
        class="form-control ew-select<?= $Page->emp_id->isInvalidClass() ?>"
        data-select2-id="fprocess_action_payment_pesearch_y_emp_id"
        data-table="process_action_payment_pe"
        data-field="x_emp_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->emp_id->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->emp_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->emp_id->getPlaceHolder()) ?>"
        <?= $Page->emp_id->editAttributes() ?>>
        <?= $Page->emp_id->selectOptionListHtml("y_emp_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->emp_id->getErrorMessage(false) ?></div>
<?= $Page->emp_id->Lookup->getParamTag($Page, "p_y_emp_id") ?>
<script>
loadjs.ready("fprocess_action_payment_pesearch", function() {
    var options = { name: "y_emp_id", selectId: "fprocess_action_payment_pesearch_y_emp_id" };
    if (fprocess_action_payment_pesearch.lists.emp_id?.lookupOptions.length) {
        options.data = { id: "y_emp_id", form: "fprocess_action_payment_pesearch" };
    } else {
        options.ajax = { id: "y_emp_id", form: "fprocess_action_payment_pesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.process_action_payment_pe.fields.emp_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->contractor->Visible) { // contractor ?>
    <div id="r_contractor" class="row"<?= $Page->contractor->rowAttributes() ?>>
        <label for="x_contractor" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_payment_pe_contractor"><?= $Page->contractor->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_contractor" id="z_contractor" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->contractor->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_payment_pe_contractor" class="ew-search-field ew-search-field-single">
    <select
        id="x_contractor"
        name="x_contractor"
        class="form-select ew-select<?= $Page->contractor->isInvalidClass() ?>"
        <?php if (!$Page->contractor->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_payment_pesearch_x_contractor"
        <?php } ?>
        data-table="process_action_payment_pe"
        data-field="x_contractor"
        data-value-separator="<?= $Page->contractor->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->contractor->getPlaceHolder()) ?>"
        <?= $Page->contractor->editAttributes() ?>>
        <?= $Page->contractor->selectOptionListHtml("x_contractor") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->contractor->getErrorMessage(false) ?></div>
<?= $Page->contractor->Lookup->getParamTag($Page, "p_x_contractor") ?>
<?php if (!$Page->contractor->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_payment_pesearch", function() {
    var options = { name: "x_contractor", selectId: "fprocess_action_payment_pesearch_x_contractor" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_payment_pesearch.lists.contractor?.lookupOptions.length) {
        options.data = { id: "x_contractor", form: "fprocess_action_payment_pesearch" };
    } else {
        options.ajax = { id: "x_contractor", form: "fprocess_action_payment_pesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_payment_pe.fields.contractor.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->qty->Visible) { // qty ?>
    <div id="r_qty" class="row"<?= $Page->qty->rowAttributes() ?>>
        <label for="x_qty" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_payment_pe_qty"><?= $Page->qty->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_qty" id="z_qty" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->qty->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_payment_pe_qty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->qty->getInputTextType() ?>" name="x_qty" id="x_qty" data-table="process_action_payment_pe" data-field="x_qty" value="<?= $Page->qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qty->formatPattern()) ?>"<?= $Page->qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->qty->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
    <div id="r_sqm" class="row"<?= $Page->sqm->rowAttributes() ?>>
        <label for="x_sqm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_payment_pe_sqm"><?= $Page->sqm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_sqm" id="z_sqm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sqm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_payment_pe_sqm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sqm->getInputTextType() ?>" name="x_sqm" id="x_sqm" data-table="process_action_payment_pe" data-field="x_sqm" value="<?= $Page->sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm->formatPattern()) ?>"<?= $Page->sqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sqm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
    <div id="r_amount" class="row"<?= $Page->amount->rowAttributes() ?>>
        <label for="x_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_payment_pe_amount"><?= $Page->amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_amount" id="z_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_payment_pe_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->amount->getInputTextType() ?>" name="x_amount" id="x_amount" data-table="process_action_payment_pe" data-field="x_amount" value="<?= $Page->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->payment->Visible) { // payment ?>
    <div id="r_payment" class="row"<?= $Page->payment->rowAttributes() ?>>
        <label for="x_payment" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_payment_pe_payment"><?= $Page->payment->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_payment" id="z_payment" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->payment->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_payment_pe_payment" class="ew-search-field ew-search-field-single">
    <select
        id="x_payment"
        name="x_payment"
        class="form-select ew-select<?= $Page->payment->isInvalidClass() ?>"
        <?php if (!$Page->payment->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_payment_pesearch_x_payment"
        <?php } ?>
        data-table="process_action_payment_pe"
        data-field="x_payment"
        data-value-separator="<?= $Page->payment->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->payment->getPlaceHolder()) ?>"
        <?= $Page->payment->editAttributes() ?>>
        <?= $Page->payment->selectOptionListHtml("x_payment") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->payment->getErrorMessage(false) ?></div>
<?= $Page->payment->Lookup->getParamTag($Page, "p_x_payment") ?>
<?php if (!$Page->payment->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_payment_pesearch", function() {
    var options = { name: "x_payment", selectId: "fprocess_action_payment_pesearch_x_payment" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_payment_pesearch.lists.payment?.lookupOptions.length) {
        options.data = { id: "x_payment", form: "fprocess_action_payment_pesearch" };
    } else {
        options.ajax = { id: "x_payment", form: "fprocess_action_payment_pesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_payment_pe.fields.payment.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_payment_pe_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_payment_pe_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="process_action_payment_pe" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fprocess_action_payment_pesearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fprocess_action_payment_pesearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fprocess_action_payment_pesearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("process_action_payment_pe");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
