<?php

namespace PHPMaker2024\fibre;

// Page object
$ProcessActionPaymentPeList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { process_action_payment_pe: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fprocess_action_payment_pesrch" id="fprocess_action_payment_pesrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fprocess_action_payment_pesrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { process_action_payment_pe: currentTable } });
var currentForm;
var fprocess_action_payment_pesrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fprocess_action_payment_pesrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["location", [], fields.location.isInvalid],
            ["process", [], fields.process.isInvalid],
            ["emp_id", [], fields.emp_id.isInvalid],
            ["y_emp_id", [ew.Validators.between], false],
            ["contractor", [], fields.contractor.isInvalid],
            ["payment", [], fields.payment.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "location": <?= $Page->location->toClientList($Page) ?>,
            "process": <?= $Page->process->toClientList($Page) ?>,
            "emp_id": <?= $Page->emp_id->toClientList($Page) ?>,
            "contractor": <?= $Page->contractor->toClientList($Page) ?>,
            "payment": <?= $Page->payment->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->location->Visible) { // location ?>
<?php
if (!$Page->location->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_location" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->location->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_location" class="ew-search-caption ew-label"><?= $Page->location->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_location" id="z_location" value="=">
</div>
        </div>
        <div id="el_process_action_payment_pe_location" class="ew-search-field">
    <select
        id="x_location"
        name="x_location"
        class="form-select ew-select<?= $Page->location->isInvalidClass() ?>"
        <?php if (!$Page->location->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_payment_pesrch_x_location"
        <?php } ?>
        data-table="process_action_payment_pe"
        data-field="x_location"
        data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>"
        <?= $Page->location->editAttributes() ?>>
        <?= $Page->location->selectOptionListHtml("x_location") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->location->getErrorMessage(false) ?></div>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
<?php if (!$Page->location->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_payment_pesrch", function() {
    var options = { name: "x_location", selectId: "fprocess_action_payment_pesrch_x_location" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_payment_pesrch.lists.location?.lookupOptions.length) {
        options.data = { id: "x_location", form: "fprocess_action_payment_pesrch" };
    } else {
        options.ajax = { id: "x_location", form: "fprocess_action_payment_pesrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_payment_pe.fields.location.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->process->Visible) { // process ?>
<?php
if (!$Page->process->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_process" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->process->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_process" class="ew-search-caption ew-label"><?= $Page->process->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_process" id="z_process" value="=">
</div>
        </div>
        <div id="el_process_action_payment_pe_process" class="ew-search-field">
    <select
        id="x_process"
        name="x_process"
        class="form-select ew-select<?= $Page->process->isInvalidClass() ?>"
        <?php if (!$Page->process->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_payment_pesrch_x_process"
        <?php } ?>
        data-table="process_action_payment_pe"
        data-field="x_process"
        data-value-separator="<?= $Page->process->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process->getPlaceHolder()) ?>"
        <?= $Page->process->editAttributes() ?>>
        <?= $Page->process->selectOptionListHtml("x_process") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->process->getErrorMessage(false) ?></div>
<?= $Page->process->Lookup->getParamTag($Page, "p_x_process") ?>
<?php if (!$Page->process->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_payment_pesrch", function() {
    var options = { name: "x_process", selectId: "fprocess_action_payment_pesrch_x_process" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_payment_pesrch.lists.process?.lookupOptions.length) {
        options.data = { id: "x_process", form: "fprocess_action_payment_pesrch" };
    } else {
        options.ajax = { id: "x_process", form: "fprocess_action_payment_pesrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_payment_pe.fields.process.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->emp_id->Visible) { // emp_id ?>
<?php
if (!$Page->emp_id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_emp_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->emp_id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_emp_id" class="ew-search-caption ew-label"><?= $Page->emp_id->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_emp_id" id="z_emp_id" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->emp_id->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->emp_id->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_process_action_payment_pe_emp_id" class="ew-search-field">
    <select
        id="x_emp_id"
        name="x_emp_id"
        class="form-control ew-select<?= $Page->emp_id->isInvalidClass() ?>"
        data-select2-id="fprocess_action_payment_pesrch_x_emp_id"
        data-table="process_action_payment_pe"
        data-field="x_emp_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->emp_id->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->emp_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->emp_id->getPlaceHolder()) ?>"
        <?= $Page->emp_id->editAttributes() ?>>
        <?= $Page->emp_id->selectOptionListHtml("x_emp_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->emp_id->getErrorMessage(false) ?></div>
<?= $Page->emp_id->Lookup->getParamTag($Page, "p_x_emp_id") ?>
<script>
loadjs.ready("fprocess_action_payment_pesrch", function() {
    var options = { name: "x_emp_id", selectId: "fprocess_action_payment_pesrch_x_emp_id" };
    if (fprocess_action_payment_pesrch.lists.emp_id?.lookupOptions.length) {
        options.data = { id: "x_emp_id", form: "fprocess_action_payment_pesrch" };
    } else {
        options.ajax = { id: "x_emp_id", form: "fprocess_action_payment_pesrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.process_action_payment_pe.fields.emp_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_process_action_payment_pe_emp_id" class="ew-search-field2 d-none">
    <select
        id="y_emp_id"
        name="y_emp_id"
        class="form-control ew-select<?= $Page->emp_id->isInvalidClass() ?>"
        data-select2-id="fprocess_action_payment_pesrch_y_emp_id"
        data-table="process_action_payment_pe"
        data-field="x_emp_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->emp_id->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->emp_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->emp_id->getPlaceHolder()) ?>"
        <?= $Page->emp_id->editAttributes() ?>>
        <?= $Page->emp_id->selectOptionListHtml("y_emp_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->emp_id->getErrorMessage(false) ?></div>
<?= $Page->emp_id->Lookup->getParamTag($Page, "p_y_emp_id") ?>
<script>
loadjs.ready("fprocess_action_payment_pesrch", function() {
    var options = { name: "y_emp_id", selectId: "fprocess_action_payment_pesrch_y_emp_id" };
    if (fprocess_action_payment_pesrch.lists.emp_id?.lookupOptions.length) {
        options.data = { id: "y_emp_id", form: "fprocess_action_payment_pesrch" };
    } else {
        options.ajax = { id: "y_emp_id", form: "fprocess_action_payment_pesrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.process_action_payment_pe.fields.emp_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->contractor->Visible) { // contractor ?>
<?php
if (!$Page->contractor->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_contractor" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->contractor->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_contractor" class="ew-search-caption ew-label"><?= $Page->contractor->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_contractor" id="z_contractor" value="LIKE">
</div>
        </div>
        <div id="el_process_action_payment_pe_contractor" class="ew-search-field">
    <select
        id="x_contractor"
        name="x_contractor"
        class="form-select ew-select<?= $Page->contractor->isInvalidClass() ?>"
        <?php if (!$Page->contractor->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_payment_pesrch_x_contractor"
        <?php } ?>
        data-table="process_action_payment_pe"
        data-field="x_contractor"
        data-value-separator="<?= $Page->contractor->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->contractor->getPlaceHolder()) ?>"
        <?= $Page->contractor->editAttributes() ?>>
        <?= $Page->contractor->selectOptionListHtml("x_contractor") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->contractor->getErrorMessage(false) ?></div>
<?= $Page->contractor->Lookup->getParamTag($Page, "p_x_contractor") ?>
<?php if (!$Page->contractor->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_payment_pesrch", function() {
    var options = { name: "x_contractor", selectId: "fprocess_action_payment_pesrch_x_contractor" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_payment_pesrch.lists.contractor?.lookupOptions.length) {
        options.data = { id: "x_contractor", form: "fprocess_action_payment_pesrch" };
    } else {
        options.ajax = { id: "x_contractor", form: "fprocess_action_payment_pesrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_payment_pe.fields.contractor.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->payment->Visible) { // payment ?>
<?php
if (!$Page->payment->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_payment" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->payment->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_payment" class="ew-search-caption ew-label"><?= $Page->payment->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_payment" id="z_payment" value="=">
</div>
        </div>
        <div id="el_process_action_payment_pe_payment" class="ew-search-field">
    <select
        id="x_payment"
        name="x_payment"
        class="form-select ew-select<?= $Page->payment->isInvalidClass() ?>"
        <?php if (!$Page->payment->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_payment_pesrch_x_payment"
        <?php } ?>
        data-table="process_action_payment_pe"
        data-field="x_payment"
        data-value-separator="<?= $Page->payment->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->payment->getPlaceHolder()) ?>"
        <?= $Page->payment->editAttributes() ?>>
        <?= $Page->payment->selectOptionListHtml("x_payment") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->payment->getErrorMessage(false) ?></div>
<?= $Page->payment->Lookup->getParamTag($Page, "p_x_payment") ?>
<?php if (!$Page->payment->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_payment_pesrch", function() {
    var options = { name: "x_payment", selectId: "fprocess_action_payment_pesrch_x_payment" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_payment_pesrch.lists.payment?.lookupOptions.length) {
        options.data = { id: "x_payment", form: "fprocess_action_payment_pesrch" };
    } else {
        options.ajax = { id: "x_payment", form: "fprocess_action_payment_pesrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_payment_pe.fields.payment.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fprocess_action_payment_pesrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fprocess_action_payment_pesrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fprocess_action_payment_pesrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fprocess_action_payment_pesrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fprocess_action_payment_pesrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fprocess_action_payment_pesrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fprocess_action_payment_pesrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="process_action_payment_pe">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_process_action_payment_pe" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_process_action_payment_pelist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->location->Visible) { // location ?>
        <th data-name="location" class="<?= $Page->location->headerCellClass() ?>"><div id="elh_process_action_payment_pe_location" class="process_action_payment_pe_location"><?= $Page->renderFieldHeader($Page->location) ?></div></th>
<?php } ?>
<?php if ($Page->process->Visible) { // process ?>
        <th data-name="process" class="<?= $Page->process->headerCellClass() ?>"><div id="elh_process_action_payment_pe_process" class="process_action_payment_pe_process"><?= $Page->renderFieldHeader($Page->process) ?></div></th>
<?php } ?>
<?php if ($Page->emp_id->Visible) { // emp_id ?>
        <th data-name="emp_id" class="<?= $Page->emp_id->headerCellClass() ?>"><div id="elh_process_action_payment_pe_emp_id" class="process_action_payment_pe_emp_id"><?= $Page->renderFieldHeader($Page->emp_id) ?></div></th>
<?php } ?>
<?php if ($Page->contractor->Visible) { // contractor ?>
        <th data-name="contractor" class="<?= $Page->contractor->headerCellClass() ?>"><div id="elh_process_action_payment_pe_contractor" class="process_action_payment_pe_contractor"><?= $Page->renderFieldHeader($Page->contractor) ?></div></th>
<?php } ?>
<?php if ($Page->qty->Visible) { // qty ?>
        <th data-name="qty" class="<?= $Page->qty->headerCellClass() ?>"><div id="elh_process_action_payment_pe_qty" class="process_action_payment_pe_qty"><?= $Page->renderFieldHeader($Page->qty) ?></div></th>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
        <th data-name="sqm" class="<?= $Page->sqm->headerCellClass() ?>"><div id="elh_process_action_payment_pe_sqm" class="process_action_payment_pe_sqm"><?= $Page->renderFieldHeader($Page->sqm) ?></div></th>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
        <th data-name="amount" class="<?= $Page->amount->headerCellClass() ?>"><div id="elh_process_action_payment_pe_amount" class="process_action_payment_pe_amount"><?= $Page->renderFieldHeader($Page->amount) ?></div></th>
<?php } ?>
<?php if ($Page->payment->Visible) { // payment ?>
        <th data-name="payment" class="<?= $Page->payment->headerCellClass() ?>"><div id="elh_process_action_payment_pe_payment" class="process_action_payment_pe_payment"><?= $Page->renderFieldHeader($Page->payment) ?></div></th>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
        <th data-name="remarks" class="<?= $Page->remarks->headerCellClass() ?>"><div id="elh_process_action_payment_pe_remarks" class="process_action_payment_pe_remarks"><?= $Page->renderFieldHeader($Page->remarks) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->location->Visible) { // location ?>
        <td data-name="location"<?= $Page->location->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_payment_pe_location" class="el_process_action_payment_pe_location">
<span<?= $Page->location->viewAttributes() ?>>
<?= $Page->location->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->process->Visible) { // process ?>
        <td data-name="process"<?= $Page->process->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_payment_pe_process" class="el_process_action_payment_pe_process">
<span<?= $Page->process->viewAttributes() ?>>
<?php if (!EmptyString($Page->process->getViewValue()) && $Page->process->linkAttributes() != "") { ?>
<a<?= $Page->process->linkAttributes() ?>><?= $Page->process->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->process->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->emp_id->Visible) { // emp_id ?>
        <td data-name="emp_id"<?= $Page->emp_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_payment_pe_emp_id" class="el_process_action_payment_pe_emp_id">
<span<?= $Page->emp_id->viewAttributes() ?>>
<?php if (!EmptyString($Page->emp_id->getViewValue()) && $Page->emp_id->linkAttributes() != "") { ?>
<a<?= $Page->emp_id->linkAttributes() ?>><?= $Page->emp_id->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->emp_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->contractor->Visible) { // contractor ?>
        <td data-name="contractor"<?= $Page->contractor->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_payment_pe_contractor" class="el_process_action_payment_pe_contractor">
<span<?= $Page->contractor->viewAttributes() ?>>
<?= $Page->contractor->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->qty->Visible) { // qty ?>
        <td data-name="qty"<?= $Page->qty->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_payment_pe_qty" class="el_process_action_payment_pe_qty">
<span<?= $Page->qty->viewAttributes() ?>>
<?= $Page->qty->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sqm->Visible) { // sqm ?>
        <td data-name="sqm"<?= $Page->sqm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_payment_pe_sqm" class="el_process_action_payment_pe_sqm">
<span<?= $Page->sqm->viewAttributes() ?>>
<?= $Page->sqm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->amount->Visible) { // amount ?>
        <td data-name="amount"<?= $Page->amount->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_payment_pe_amount" class="el_process_action_payment_pe_amount">
<span<?= $Page->amount->viewAttributes() ?>>
<?php if (!EmptyString($Page->amount->getViewValue()) && $Page->amount->linkAttributes() != "") { ?>
<a<?= $Page->amount->linkAttributes() ?>><?= $Page->amount->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->amount->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->payment->Visible) { // payment ?>
        <td data-name="payment"<?= $Page->payment->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_payment_pe_payment" class="el_process_action_payment_pe_payment">
<span<?= $Page->payment->viewAttributes() ?>>
<?php if (!EmptyString($Page->payment->getViewValue()) && $Page->payment->linkAttributes() != "") { ?>
<a<?= $Page->payment->linkAttributes() ?>><?= $Page->payment->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->payment->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->remarks->Visible) { // remarks ?>
        <td data-name="remarks"<?= $Page->remarks->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_payment_pe_remarks" class="el_process_action_payment_pe_remarks">
<span<?= $Page->remarks->viewAttributes() ?>>
<?= $Page->remarks->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Page->RowType = RowType::AGGREGATE;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->TotalRecords > 0 && !$Page->isGridAdd() && !$Page->isGridEdit() && !$Page->isMultiEdit()) { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (footer, left)
$Page->ListOptions->render("footer", "left");
?>
    <?php if ($Page->location->Visible) { // location ?>
        <td data-name="location" class="<?= $Page->location->footerCellClass() ?>"><span id="elf_process_action_payment_pe_location" class="process_action_payment_pe_location">
        </span></td>
    <?php } ?>
    <?php if ($Page->process->Visible) { // process ?>
        <td data-name="process" class="<?= $Page->process->footerCellClass() ?>"><span id="elf_process_action_payment_pe_process" class="process_action_payment_pe_process">
        </span></td>
    <?php } ?>
    <?php if ($Page->emp_id->Visible) { // emp_id ?>
        <td data-name="emp_id" class="<?= $Page->emp_id->footerCellClass() ?>"><span id="elf_process_action_payment_pe_emp_id" class="process_action_payment_pe_emp_id">
        <span class="ew-aggregate"><?= $Language->phrase("COUNT") ?></span><span class="ew-aggregate-value">
        <?php if (!EmptyString($Page->emp_id->ViewValue) && $Page->emp_id->linkAttributes() != "") { ?>
        <a<?= $Page->emp_id->linkAttributes() ?>><?= $Page->emp_id->ViewValue ?></a>
        <?php } else { ?>
        <?= $Page->emp_id->ViewValue ?>
        <?php } ?>
        </span>
        </span></td>
    <?php } ?>
    <?php if ($Page->contractor->Visible) { // contractor ?>
        <td data-name="contractor" class="<?= $Page->contractor->footerCellClass() ?>"><span id="elf_process_action_payment_pe_contractor" class="process_action_payment_pe_contractor">
        </span></td>
    <?php } ?>
    <?php if ($Page->qty->Visible) { // qty ?>
        <td data-name="qty" class="<?= $Page->qty->footerCellClass() ?>"><span id="elf_process_action_payment_pe_qty" class="process_action_payment_pe_qty">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->qty->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->sqm->Visible) { // sqm ?>
        <td data-name="sqm" class="<?= $Page->sqm->footerCellClass() ?>"><span id="elf_process_action_payment_pe_sqm" class="process_action_payment_pe_sqm">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->sqm->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->amount->Visible) { // amount ?>
        <td data-name="amount" class="<?= $Page->amount->footerCellClass() ?>"><span id="elf_process_action_payment_pe_amount" class="process_action_payment_pe_amount">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?php if (!EmptyString($Page->amount->ViewValue) && $Page->amount->linkAttributes() != "") { ?>
        <a<?= $Page->amount->linkAttributes() ?>><?= $Page->amount->ViewValue ?></a>
        <?php } else { ?>
        <?= $Page->amount->ViewValue ?>
        <?php } ?>
        </span>
        </span></td>
    <?php } ?>
    <?php if ($Page->payment->Visible) { // payment ?>
        <td data-name="payment" class="<?= $Page->payment->footerCellClass() ?>"><span id="elf_process_action_payment_pe_payment" class="process_action_payment_pe_payment">
        </span></td>
    <?php } ?>
    <?php if ($Page->remarks->Visible) { // remarks ?>
        <td data-name="remarks" class="<?= $Page->remarks->footerCellClass() ?>"><span id="elf_process_action_payment_pe_remarks" class="process_action_payment_pe_remarks">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Page->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("process_action_payment_pe");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
