<?php

namespace PHPMaker2024\fibre;

// Page object
$ProcessActionPaymentList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { process_action_payment: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fprocess_action_paymentsrch" id="fprocess_action_paymentsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fprocess_action_paymentsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { process_action_payment: currentTable } });
var currentForm;
var fprocess_action_paymentsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fprocess_action_paymentsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["location", [], fields.location.isInvalid],
            ["process", [], fields.process.isInvalid],
            ["emp_id", [], fields.emp_id.isInvalid],
            ["code", [ew.Validators.float], fields.code.isInvalid],
            ["y_code", [ew.Validators.between], false],
            ["c_id", [], fields.c_id.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["y_datetime", [ew.Validators.between], false],
            ["payment", [], fields.payment.isInvalid],
            ["y_payment", [ew.Validators.between], false]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "location": <?= $Page->location->toClientList($Page) ?>,
            "process": <?= $Page->process->toClientList($Page) ?>,
            "emp_id": <?= $Page->emp_id->toClientList($Page) ?>,
            "c_id": <?= $Page->c_id->toClientList($Page) ?>,
            "payment": <?= $Page->payment->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->location->Visible) { // location ?>
<?php
if (!$Page->location->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_location" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->location->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_location" class="ew-search-caption ew-label"><?= $Page->location->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_location" id="z_location" value="=">
</div>
        </div>
        <div id="el_process_action_payment_location" class="ew-search-field">
    <select
        id="x_location"
        name="x_location"
        class="form-select ew-select<?= $Page->location->isInvalidClass() ?>"
        <?php if (!$Page->location->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_paymentsrch_x_location"
        <?php } ?>
        data-table="process_action_payment"
        data-field="x_location"
        data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>"
        <?= $Page->location->editAttributes() ?>>
        <?= $Page->location->selectOptionListHtml("x_location") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->location->getErrorMessage(false) ?></div>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
<?php if (!$Page->location->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_paymentsrch", function() {
    var options = { name: "x_location", selectId: "fprocess_action_paymentsrch_x_location" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_paymentsrch.lists.location?.lookupOptions.length) {
        options.data = { id: "x_location", form: "fprocess_action_paymentsrch" };
    } else {
        options.ajax = { id: "x_location", form: "fprocess_action_paymentsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_payment.fields.location.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->process->Visible) { // process ?>
<?php
if (!$Page->process->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_process" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->process->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_process" class="ew-search-caption ew-label"><?= $Page->process->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_process" id="z_process" value="=">
</div>
        </div>
        <div id="el_process_action_payment_process" class="ew-search-field">
    <select
        id="x_process"
        name="x_process"
        class="form-select ew-select<?= $Page->process->isInvalidClass() ?>"
        <?php if (!$Page->process->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_paymentsrch_x_process"
        <?php } ?>
        data-table="process_action_payment"
        data-field="x_process"
        data-value-separator="<?= $Page->process->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process->getPlaceHolder()) ?>"
        <?= $Page->process->editAttributes() ?>>
        <?= $Page->process->selectOptionListHtml("x_process") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->process->getErrorMessage(false) ?></div>
<?= $Page->process->Lookup->getParamTag($Page, "p_x_process") ?>
<?php if (!$Page->process->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_paymentsrch", function() {
    var options = { name: "x_process", selectId: "fprocess_action_paymentsrch_x_process" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_paymentsrch.lists.process?.lookupOptions.length) {
        options.data = { id: "x_process", form: "fprocess_action_paymentsrch" };
    } else {
        options.ajax = { id: "x_process", form: "fprocess_action_paymentsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_payment.fields.process.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->emp_id->Visible) { // emp_id ?>
<?php
if (!$Page->emp_id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_emp_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->emp_id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_emp_id" class="ew-search-caption ew-label"><?= $Page->emp_id->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_emp_id" id="z_emp_id" value="=">
</div>
        </div>
        <div id="el_process_action_payment_emp_id" class="ew-search-field">
    <select
        id="x_emp_id"
        name="x_emp_id"
        class="form-select ew-select<?= $Page->emp_id->isInvalidClass() ?>"
        <?php if (!$Page->emp_id->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_paymentsrch_x_emp_id"
        <?php } ?>
        data-table="process_action_payment"
        data-field="x_emp_id"
        data-value-separator="<?= $Page->emp_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->emp_id->getPlaceHolder()) ?>"
        <?= $Page->emp_id->editAttributes() ?>>
        <?= $Page->emp_id->selectOptionListHtml("x_emp_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->emp_id->getErrorMessage(false) ?></div>
<?= $Page->emp_id->Lookup->getParamTag($Page, "p_x_emp_id") ?>
<?php if (!$Page->emp_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_paymentsrch", function() {
    var options = { name: "x_emp_id", selectId: "fprocess_action_paymentsrch_x_emp_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_paymentsrch.lists.emp_id?.lookupOptions.length) {
        options.data = { id: "x_emp_id", form: "fprocess_action_paymentsrch" };
    } else {
        options.ajax = { id: "x_emp_id", form: "fprocess_action_paymentsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_payment.fields.emp_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->code->Visible) { // code ?>
<?php
if (!$Page->code->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_code" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->code->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_code" class="ew-search-caption ew-label"><?= $Page->code->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_code" id="z_code" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->code->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->code->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_process_action_payment_code" class="ew-search-field">
<input type="<?= $Page->code->getInputTextType() ?>" name="x_code" id="x_code" data-table="process_action_payment" data-field="x_code" value="<?= $Page->code->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->code->formatPattern()) ?>"<?= $Page->code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->code->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_process_action_payment_code" class="ew-search-field2 d-none">
<input type="<?= $Page->code->getInputTextType() ?>" name="y_code" id="y_code" data-table="process_action_payment" data-field="x_code" value="<?= $Page->code->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->code->formatPattern()) ?>"<?= $Page->code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->code->getErrorMessage(false) ?></div>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->c_id->Visible) { // c_id ?>
<?php
if (!$Page->c_id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_c_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->c_id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_c_id" class="ew-search-caption ew-label"><?= $Page->c_id->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_c_id" id="z_c_id" value="=">
</div>
        </div>
        <div id="el_process_action_payment_c_id" class="ew-search-field">
    <select
        id="x_c_id"
        name="x_c_id"
        class="form-select ew-select<?= $Page->c_id->isInvalidClass() ?>"
        <?php if (!$Page->c_id->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_paymentsrch_x_c_id"
        <?php } ?>
        data-table="process_action_payment"
        data-field="x_c_id"
        data-value-separator="<?= $Page->c_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->c_id->getPlaceHolder()) ?>"
        <?= $Page->c_id->editAttributes() ?>>
        <?= $Page->c_id->selectOptionListHtml("x_c_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->c_id->getErrorMessage(false) ?></div>
<?= $Page->c_id->Lookup->getParamTag($Page, "p_x_c_id") ?>
<?php if (!$Page->c_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_paymentsrch", function() {
    var options = { name: "x_c_id", selectId: "fprocess_action_paymentsrch_x_c_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_paymentsrch.lists.c_id?.lookupOptions.length) {
        options.data = { id: "x_c_id", form: "fprocess_action_paymentsrch" };
    } else {
        options.ajax = { id: "x_c_id", form: "fprocess_action_paymentsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_payment.fields.c_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
<?php
if (!$Page->datetime->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_datetime" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->datetime->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_datetime" class="ew-search-caption ew-label"><?= $Page->datetime->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_datetime" id="z_datetime" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->datetime->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->datetime->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_process_action_payment_datetime" class="ew-search-field">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="process_action_payment" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprocess_action_paymentsrch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprocess_action_paymentsrch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_process_action_payment_datetime" class="ew-search-field2 d-none">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="y_datetime" id="y_datetime" data-table="process_action_payment" data-field="x_datetime" value="<?= $Page->datetime->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprocess_action_paymentsrch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprocess_action_paymentsrch", "y_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->payment->Visible) { // payment ?>
<?php
if (!$Page->payment->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_payment" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->payment->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->payment->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_payment" id="z_payment" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->payment->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->payment->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_process_action_payment_payment" class="ew-search-field">
    <select
        id="x_payment[]"
        name="x_payment[]"
        class="form-select ew-select<?= $Page->payment->isInvalidClass() ?>"
        <?php if (!$Page->payment->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_paymentsrch_x_payment[]"
        <?php } ?>
        data-table="process_action_payment"
        data-field="x_payment"
        data-dropdown
        multiple
        size="1"
        data-value-separator="<?= $Page->payment->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->payment->getPlaceHolder()) ?>"
        <?= $Page->payment->editAttributes() ?>>
        <?= $Page->payment->selectOptionListHtml("x_payment[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->payment->getErrorMessage(false) ?></div>
<?= $Page->payment->Lookup->getParamTag($Page, "p_x_payment") ?>
<?php if (!$Page->payment->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_paymentsrch", function() {
    var options = { name: "x_payment[]", selectId: "fprocess_action_paymentsrch_x_payment[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.columns = el.dataset.repeatcolumn || 4;
    options.dropdown = !ew.IS_MOBILE && options.columns > 0; // Use custom dropdown
    el.dataset.dropdown = options.dropdown;
    if (options.dropdown) {
        options.dropdownAutoWidth = true;
        options.dropdownCssClass = "ew-select-dropdown process_action_payment-x_payment-dropdown ew-select-" + (options.multiple ? "multiple" : "one");
        if (options.columns > 1)
            options.dropdownCssClass += " ew-repeat-column";
    }
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_paymentsrch.lists.payment?.lookupOptions.length) {
        options.data = { id: "x_payment[]", form: "fprocess_action_paymentsrch" };
    } else {
        options.ajax = { id: "x_payment[]", form: "fprocess_action_paymentsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_payment.fields.payment.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_process_action_payment_payment" class="ew-search-field2 d-none">
    <select
        id="y_payment[]"
        name="y_payment[]"
        class="form-select ew-select<?= $Page->payment->isInvalidClass() ?>"
        <?php if (!$Page->payment->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_paymentsrch_y_payment[]"
        <?php } ?>
        data-table="process_action_payment"
        data-field="x_payment"
        data-dropdown
        multiple
        size="1"
        data-value-separator="<?= $Page->payment->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->payment->getPlaceHolder()) ?>"
        <?= $Page->payment->editAttributes() ?>>
        <?= $Page->payment->selectOptionListHtml("y_payment[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->payment->getErrorMessage(false) ?></div>
<?= $Page->payment->Lookup->getParamTag($Page, "p_y_payment") ?>
<?php if (!$Page->payment->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_paymentsrch", function() {
    var options = { name: "y_payment[]", selectId: "fprocess_action_paymentsrch_y_payment[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.columns = el.dataset.repeatcolumn || 4;
    options.dropdown = !ew.IS_MOBILE && options.columns > 0; // Use custom dropdown
    el.dataset.dropdown = options.dropdown;
    if (options.dropdown) {
        options.dropdownAutoWidth = true;
        options.dropdownCssClass = "ew-select-dropdown process_action_payment-x_payment-dropdown ew-select-" + (options.multiple ? "multiple" : "one");
        if (options.columns > 1)
            options.dropdownCssClass += " ew-repeat-column";
    }
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_paymentsrch.lists.payment?.lookupOptions.length) {
        options.data = { id: "y_payment[]", form: "fprocess_action_paymentsrch" };
    } else {
        options.ajax = { id: "y_payment[]", form: "fprocess_action_paymentsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_payment.fields.payment.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fprocess_action_paymentsrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fprocess_action_paymentsrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fprocess_action_paymentsrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fprocess_action_paymentsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fprocess_action_paymentsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fprocess_action_paymentsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fprocess_action_paymentsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="process_action_payment">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_process_action_payment" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_process_action_paymentlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_process_action_payment_id" class="process_action_payment_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
        <th data-name="location" class="<?= $Page->location->headerCellClass() ?>"><div id="elh_process_action_payment_location" class="process_action_payment_location"><?= $Page->renderFieldHeader($Page->location) ?></div></th>
<?php } ?>
<?php if ($Page->process->Visible) { // process ?>
        <th data-name="process" class="<?= $Page->process->headerCellClass() ?>"><div id="elh_process_action_payment_process" class="process_action_payment_process"><?= $Page->renderFieldHeader($Page->process) ?></div></th>
<?php } ?>
<?php if ($Page->emp_id->Visible) { // emp_id ?>
        <th data-name="emp_id" class="<?= $Page->emp_id->headerCellClass() ?>"><div id="elh_process_action_payment_emp_id" class="process_action_payment_emp_id"><?= $Page->renderFieldHeader($Page->emp_id) ?></div></th>
<?php } ?>
<?php if ($Page->emp_grp->Visible) { // emp_grp ?>
        <th data-name="emp_grp" class="<?= $Page->emp_grp->headerCellClass() ?>"><div id="elh_process_action_payment_emp_grp" class="process_action_payment_emp_grp"><?= $Page->renderFieldHeader($Page->emp_grp) ?></div></th>
<?php } ?>
<?php if ($Page->code->Visible) { // code ?>
        <th data-name="code" class="<?= $Page->code->headerCellClass() ?>"><div id="elh_process_action_payment_code" class="process_action_payment_code"><?= $Page->renderFieldHeader($Page->code) ?></div></th>
<?php } ?>
<?php if ($Page->ref->Visible) { // ref ?>
        <th data-name="ref" class="<?= $Page->ref->headerCellClass() ?>"><div id="elh_process_action_payment_ref" class="process_action_payment_ref"><?= $Page->renderFieldHeader($Page->ref) ?></div></th>
<?php } ?>
<?php if ($Page->size_wl->Visible) { // size_wl ?>
        <th data-name="size_wl" class="<?= $Page->size_wl->headerCellClass() ?>"><div id="elh_process_action_payment_size_wl" class="process_action_payment_size_wl"><?= $Page->renderFieldHeader($Page->size_wl) ?></div></th>
<?php } ?>
<?php if ($Page->process_->Visible) { // process_@ ?>
        <th data-name="process_" class="<?= $Page->process_->headerCellClass() ?>"><div id="elh_process_action_payment_process_" class="process_action_payment_process_"><?= $Page->renderFieldHeader($Page->process_) ?></div></th>
<?php } ?>
<?php if ($Page->final_amount->Visible) { // final_amount ?>
        <th data-name="final_amount" class="<?= $Page->final_amount->headerCellClass() ?>"><div id="elh_process_action_payment_final_amount" class="process_action_payment_final_amount"><?= $Page->renderFieldHeader($Page->final_amount) ?></div></th>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
        <th data-name="amount" class="<?= $Page->amount->headerCellClass() ?>"><div id="elh_process_action_payment_amount" class="process_action_payment_amount"><?= $Page->renderFieldHeader($Page->amount) ?></div></th>
<?php } ?>
<?php if ($Page->c_charge->Visible) { // c_charge ?>
        <th data-name="c_charge" class="<?= $Page->c_charge->headerCellClass() ?>"><div id="elh_process_action_payment_c_charge" class="process_action_payment_c_charge"><?= $Page->renderFieldHeader($Page->c_charge) ?></div></th>
<?php } ?>
<?php if ($Page->c_id->Visible) { // c_id ?>
        <th data-name="c_id" class="<?= $Page->c_id->headerCellClass() ?>"><div id="elh_process_action_payment_c_id" class="process_action_payment_c_id"><?= $Page->renderFieldHeader($Page->c_id) ?></div></th>
<?php } ?>
<?php if ($Page->custom_size->Visible) { // custom_size ?>
        <th data-name="custom_size" class="<?= $Page->custom_size->headerCellClass() ?>"><div id="elh_process_action_payment_custom_size" class="process_action_payment_custom_size"><?= $Page->renderFieldHeader($Page->custom_size) ?></div></th>
<?php } ?>
<?php if ($Page->ded_jc->Visible) { // ded_jc ?>
        <th data-name="ded_jc" class="<?= $Page->ded_jc->headerCellClass() ?>"><div id="elh_process_action_payment_ded_jc" class="process_action_payment_ded_jc"><?= $Page->renderFieldHeader($Page->ded_jc) ?></div></th>
<?php } ?>
<?php if ($Page->ded_pa->Visible) { // ded_pa ?>
        <th data-name="ded_pa" class="<?= $Page->ded_pa->headerCellClass() ?>"><div id="elh_process_action_payment_ded_pa" class="process_action_payment_ded_pa"><?= $Page->renderFieldHeader($Page->ded_pa) ?></div></th>
<?php } ?>
<?php if ($Page->payment_type->Visible) { // payment_type ?>
        <th data-name="payment_type" class="<?= $Page->payment_type->headerCellClass() ?>"><div id="elh_process_action_payment_payment_type" class="process_action_payment_payment_type"><?= $Page->renderFieldHeader($Page->payment_type) ?></div></th>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
        <th data-name="sqm" class="<?= $Page->sqm->headerCellClass() ?>"><div id="elh_process_action_payment_sqm" class="process_action_payment_sqm"><?= $Page->renderFieldHeader($Page->sqm) ?></div></th>
<?php } ?>
<?php if ($Page->sqm_grp->Visible) { // sqm_grp ?>
        <th data-name="sqm_grp" class="<?= $Page->sqm_grp->headerCellClass() ?>"><div id="elh_process_action_payment_sqm_grp" class="process_action_payment_sqm_grp"><?= $Page->renderFieldHeader($Page->sqm_grp) ?></div></th>
<?php } ?>
<?php if ($Page->_2_srm->Visible) { // 2_srm ?>
        <th data-name="_2_srm" class="<?= $Page->_2_srm->headerCellClass() ?>"><div id="elh_process_action_payment__2_srm" class="process_action_payment__2_srm"><?= $Page->renderFieldHeader($Page->_2_srm) ?></div></th>
<?php } ?>
<?php if ($Page->_4_srm->Visible) { // 4_srm ?>
        <th data-name="_4_srm" class="<?= $Page->_4_srm->headerCellClass() ?>"><div id="elh_process_action_payment__4_srm" class="process_action_payment__4_srm"><?= $Page->renderFieldHeader($Page->_4_srm) ?></div></th>
<?php } ?>
<?php if ($Page->process_fix->Visible) { // process_fix ?>
        <th data-name="process_fix" class="<?= $Page->process_fix->headerCellClass() ?>"><div id="elh_process_action_payment_process_fix" class="process_action_payment_process_fix"><?= $Page->renderFieldHeader($Page->process_fix) ?></div></th>
<?php } ?>
<?php if ($Page->method->Visible) { // method ?>
        <th data-name="method" class="<?= $Page->method->headerCellClass() ?>"><div id="elh_process_action_payment_method" class="process_action_payment_method"><?= $Page->renderFieldHeader($Page->method) ?></div></th>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Page->datetime->headerCellClass() ?>"><div id="elh_process_action_payment_datetime" class="process_action_payment_datetime"><?= $Page->renderFieldHeader($Page->datetime) ?></div></th>
<?php } ?>
<?php if ($Page->payment->Visible) { // payment ?>
        <th data-name="payment" class="<?= $Page->payment->headerCellClass() ?>"><div id="elh_process_action_payment_payment" class="process_action_payment_payment"><?= $Page->renderFieldHeader($Page->payment) ?></div></th>
<?php } ?>
<?php if ($Page->remark->Visible) { // remark ?>
        <th data-name="remark" class="<?= $Page->remark->headerCellClass() ?>"><div id="elh_process_action_payment_remark" class="process_action_payment_remark"><?= $Page->renderFieldHeader($Page->remark) ?></div></th>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
        <th data-name="category" class="<?= $Page->category->headerCellClass() ?>"><div id="elh_process_action_payment_category" class="process_action_payment_category"><?= $Page->renderFieldHeader($Page->category) ?></div></th>
<?php } ?>
<?php if ($Page->c_method->Visible) { // c_method ?>
        <th data-name="c_method" class="<?= $Page->c_method->headerCellClass() ?>"><div id="elh_process_action_payment_c_method" class="process_action_payment_c_method"><?= $Page->renderFieldHeader($Page->c_method) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_payment_id" class="el_process_action_payment_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->location->Visible) { // location ?>
        <td data-name="location"<?= $Page->location->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_payment_location" class="el_process_action_payment_location">
<span<?= $Page->location->viewAttributes() ?>>
<?= $Page->location->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->process->Visible) { // process ?>
        <td data-name="process"<?= $Page->process->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_payment_process" class="el_process_action_payment_process">
<span<?= $Page->process->viewAttributes() ?>>
<?= $Page->process->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->emp_id->Visible) { // emp_id ?>
        <td data-name="emp_id"<?= $Page->emp_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_payment_emp_id" class="el_process_action_payment_emp_id">
<span<?= $Page->emp_id->viewAttributes() ?>>
<?= $Page->emp_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->emp_grp->Visible) { // emp_grp ?>
        <td data-name="emp_grp"<?= $Page->emp_grp->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_payment_emp_grp" class="el_process_action_payment_emp_grp">
<span<?= $Page->emp_grp->viewAttributes() ?>>
<?= $Page->emp_grp->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->code->Visible) { // code ?>
        <td data-name="code"<?= $Page->code->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_payment_code" class="el_process_action_payment_code">
<span<?= $Page->code->viewAttributes() ?>>
<?= $Page->code->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ref->Visible) { // ref ?>
        <td data-name="ref"<?= $Page->ref->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_payment_ref" class="el_process_action_payment_ref">
<span<?= $Page->ref->viewAttributes() ?>>
<?= $Page->ref->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->size_wl->Visible) { // size_wl ?>
        <td data-name="size_wl"<?= $Page->size_wl->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_payment_size_wl" class="el_process_action_payment_size_wl">
<span<?= $Page->size_wl->viewAttributes() ?>>
<?= $Page->size_wl->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->process_->Visible) { // process_@ ?>
        <td data-name="process_"<?= $Page->process_->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_payment_process_" class="el_process_action_payment_process_">
<span<?= $Page->process_->viewAttributes() ?>>
<?= $Page->process_->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->final_amount->Visible) { // final_amount ?>
        <td data-name="final_amount"<?= $Page->final_amount->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_payment_final_amount" class="el_process_action_payment_final_amount">
<span<?= $Page->final_amount->viewAttributes() ?>>
<?= $Page->final_amount->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->amount->Visible) { // amount ?>
        <td data-name="amount"<?= $Page->amount->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_payment_amount" class="el_process_action_payment_amount">
<span<?= $Page->amount->viewAttributes() ?>>
<?= $Page->amount->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->c_charge->Visible) { // c_charge ?>
        <td data-name="c_charge"<?= $Page->c_charge->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_payment_c_charge" class="el_process_action_payment_c_charge">
<span<?= $Page->c_charge->viewAttributes() ?>>
<?= $Page->c_charge->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->c_id->Visible) { // c_id ?>
        <td data-name="c_id"<?= $Page->c_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_payment_c_id" class="el_process_action_payment_c_id">
<span<?= $Page->c_id->viewAttributes() ?>>
<?= $Page->c_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->custom_size->Visible) { // custom_size ?>
        <td data-name="custom_size"<?= $Page->custom_size->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_payment_custom_size" class="el_process_action_payment_custom_size">
<span<?= $Page->custom_size->viewAttributes() ?>>
<?= $Page->custom_size->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ded_jc->Visible) { // ded_jc ?>
        <td data-name="ded_jc"<?= $Page->ded_jc->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_payment_ded_jc" class="el_process_action_payment_ded_jc">
<span<?= $Page->ded_jc->viewAttributes() ?>>
<?= $Page->ded_jc->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ded_pa->Visible) { // ded_pa ?>
        <td data-name="ded_pa"<?= $Page->ded_pa->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_payment_ded_pa" class="el_process_action_payment_ded_pa">
<span<?= $Page->ded_pa->viewAttributes() ?>>
<?= $Page->ded_pa->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->payment_type->Visible) { // payment_type ?>
        <td data-name="payment_type"<?= $Page->payment_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_payment_payment_type" class="el_process_action_payment_payment_type">
<span<?= $Page->payment_type->viewAttributes() ?>>
<?= $Page->payment_type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sqm->Visible) { // sqm ?>
        <td data-name="sqm"<?= $Page->sqm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_payment_sqm" class="el_process_action_payment_sqm">
<span<?= $Page->sqm->viewAttributes() ?>>
<?= $Page->sqm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sqm_grp->Visible) { // sqm_grp ?>
        <td data-name="sqm_grp"<?= $Page->sqm_grp->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_payment_sqm_grp" class="el_process_action_payment_sqm_grp">
<span<?= $Page->sqm_grp->viewAttributes() ?>>
<?= $Page->sqm_grp->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_2_srm->Visible) { // 2_srm ?>
        <td data-name="_2_srm"<?= $Page->_2_srm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_payment__2_srm" class="el_process_action_payment__2_srm">
<span<?= $Page->_2_srm->viewAttributes() ?>>
<?= $Page->_2_srm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_4_srm->Visible) { // 4_srm ?>
        <td data-name="_4_srm"<?= $Page->_4_srm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_payment__4_srm" class="el_process_action_payment__4_srm">
<span<?= $Page->_4_srm->viewAttributes() ?>>
<?= $Page->_4_srm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->process_fix->Visible) { // process_fix ?>
        <td data-name="process_fix"<?= $Page->process_fix->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_payment_process_fix" class="el_process_action_payment_process_fix">
<span<?= $Page->process_fix->viewAttributes() ?>>
<?= $Page->process_fix->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->method->Visible) { // method ?>
        <td data-name="method"<?= $Page->method->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_payment_method" class="el_process_action_payment_method">
<span<?= $Page->method->viewAttributes() ?>>
<?= $Page->method->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_payment_datetime" class="el_process_action_payment_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->payment->Visible) { // payment ?>
        <td data-name="payment"<?= $Page->payment->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_payment_payment" class="el_process_action_payment_payment">
<span<?= $Page->payment->viewAttributes() ?>>
<?= $Page->payment->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->remark->Visible) { // remark ?>
        <td data-name="remark"<?= $Page->remark->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_payment_remark" class="el_process_action_payment_remark">
<span<?= $Page->remark->viewAttributes() ?>>
<?= $Page->remark->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->category->Visible) { // category ?>
        <td data-name="category"<?= $Page->category->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_payment_category" class="el_process_action_payment_category">
<span<?= $Page->category->viewAttributes() ?>>
<?= $Page->category->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->c_method->Visible) { // c_method ?>
        <td data-name="c_method"<?= $Page->c_method->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_payment_c_method" class="el_process_action_payment_c_method">
<span<?= $Page->c_method->viewAttributes() ?>>
<?= $Page->c_method->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Page->RowType = RowType::AGGREGATE;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->TotalRecords > 0 && !$Page->isGridAdd() && !$Page->isGridEdit() && !$Page->isMultiEdit()) { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (footer, left)
$Page->ListOptions->render("footer", "left");
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id" class="<?= $Page->id->footerCellClass() ?>"><span id="elf_process_action_payment_id" class="process_action_payment_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->location->Visible) { // location ?>
        <td data-name="location" class="<?= $Page->location->footerCellClass() ?>"><span id="elf_process_action_payment_location" class="process_action_payment_location">
        </span></td>
    <?php } ?>
    <?php if ($Page->process->Visible) { // process ?>
        <td data-name="process" class="<?= $Page->process->footerCellClass() ?>"><span id="elf_process_action_payment_process" class="process_action_payment_process">
        </span></td>
    <?php } ?>
    <?php if ($Page->emp_id->Visible) { // emp_id ?>
        <td data-name="emp_id" class="<?= $Page->emp_id->footerCellClass() ?>"><span id="elf_process_action_payment_emp_id" class="process_action_payment_emp_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->emp_grp->Visible) { // emp_grp ?>
        <td data-name="emp_grp" class="<?= $Page->emp_grp->footerCellClass() ?>"><span id="elf_process_action_payment_emp_grp" class="process_action_payment_emp_grp">
        </span></td>
    <?php } ?>
    <?php if ($Page->code->Visible) { // code ?>
        <td data-name="code" class="<?= $Page->code->footerCellClass() ?>"><span id="elf_process_action_payment_code" class="process_action_payment_code">
        </span></td>
    <?php } ?>
    <?php if ($Page->ref->Visible) { // ref ?>
        <td data-name="ref" class="<?= $Page->ref->footerCellClass() ?>"><span id="elf_process_action_payment_ref" class="process_action_payment_ref">
        </span></td>
    <?php } ?>
    <?php if ($Page->size_wl->Visible) { // size_wl ?>
        <td data-name="size_wl" class="<?= $Page->size_wl->footerCellClass() ?>"><span id="elf_process_action_payment_size_wl" class="process_action_payment_size_wl">
        </span></td>
    <?php } ?>
    <?php if ($Page->process_->Visible) { // process_@ ?>
        <td data-name="process_" class="<?= $Page->process_->footerCellClass() ?>"><span id="elf_process_action_payment_process_" class="process_action_payment_process_">
        </span></td>
    <?php } ?>
    <?php if ($Page->final_amount->Visible) { // final_amount ?>
        <td data-name="final_amount" class="<?= $Page->final_amount->footerCellClass() ?>"><span id="elf_process_action_payment_final_amount" class="process_action_payment_final_amount">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->final_amount->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->amount->Visible) { // amount ?>
        <td data-name="amount" class="<?= $Page->amount->footerCellClass() ?>"><span id="elf_process_action_payment_amount" class="process_action_payment_amount">
        </span></td>
    <?php } ?>
    <?php if ($Page->c_charge->Visible) { // c_charge ?>
        <td data-name="c_charge" class="<?= $Page->c_charge->footerCellClass() ?>"><span id="elf_process_action_payment_c_charge" class="process_action_payment_c_charge">
        </span></td>
    <?php } ?>
    <?php if ($Page->c_id->Visible) { // c_id ?>
        <td data-name="c_id" class="<?= $Page->c_id->footerCellClass() ?>"><span id="elf_process_action_payment_c_id" class="process_action_payment_c_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->custom_size->Visible) { // custom_size ?>
        <td data-name="custom_size" class="<?= $Page->custom_size->footerCellClass() ?>"><span id="elf_process_action_payment_custom_size" class="process_action_payment_custom_size">
        </span></td>
    <?php } ?>
    <?php if ($Page->ded_jc->Visible) { // ded_jc ?>
        <td data-name="ded_jc" class="<?= $Page->ded_jc->footerCellClass() ?>"><span id="elf_process_action_payment_ded_jc" class="process_action_payment_ded_jc">
        </span></td>
    <?php } ?>
    <?php if ($Page->ded_pa->Visible) { // ded_pa ?>
        <td data-name="ded_pa" class="<?= $Page->ded_pa->footerCellClass() ?>"><span id="elf_process_action_payment_ded_pa" class="process_action_payment_ded_pa">
        </span></td>
    <?php } ?>
    <?php if ($Page->payment_type->Visible) { // payment_type ?>
        <td data-name="payment_type" class="<?= $Page->payment_type->footerCellClass() ?>"><span id="elf_process_action_payment_payment_type" class="process_action_payment_payment_type">
        </span></td>
    <?php } ?>
    <?php if ($Page->sqm->Visible) { // sqm ?>
        <td data-name="sqm" class="<?= $Page->sqm->footerCellClass() ?>"><span id="elf_process_action_payment_sqm" class="process_action_payment_sqm">
        </span></td>
    <?php } ?>
    <?php if ($Page->sqm_grp->Visible) { // sqm_grp ?>
        <td data-name="sqm_grp" class="<?= $Page->sqm_grp->footerCellClass() ?>"><span id="elf_process_action_payment_sqm_grp" class="process_action_payment_sqm_grp">
        </span></td>
    <?php } ?>
    <?php if ($Page->_2_srm->Visible) { // 2_srm ?>
        <td data-name="_2_srm" class="<?= $Page->_2_srm->footerCellClass() ?>"><span id="elf_process_action_payment__2_srm" class="process_action_payment__2_srm">
        </span></td>
    <?php } ?>
    <?php if ($Page->_4_srm->Visible) { // 4_srm ?>
        <td data-name="_4_srm" class="<?= $Page->_4_srm->footerCellClass() ?>"><span id="elf_process_action_payment__4_srm" class="process_action_payment__4_srm">
        </span></td>
    <?php } ?>
    <?php if ($Page->process_fix->Visible) { // process_fix ?>
        <td data-name="process_fix" class="<?= $Page->process_fix->footerCellClass() ?>"><span id="elf_process_action_payment_process_fix" class="process_action_payment_process_fix">
        </span></td>
    <?php } ?>
    <?php if ($Page->method->Visible) { // method ?>
        <td data-name="method" class="<?= $Page->method->footerCellClass() ?>"><span id="elf_process_action_payment_method" class="process_action_payment_method">
        </span></td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime" class="<?= $Page->datetime->footerCellClass() ?>"><span id="elf_process_action_payment_datetime" class="process_action_payment_datetime">
        </span></td>
    <?php } ?>
    <?php if ($Page->payment->Visible) { // payment ?>
        <td data-name="payment" class="<?= $Page->payment->footerCellClass() ?>"><span id="elf_process_action_payment_payment" class="process_action_payment_payment">
        </span></td>
    <?php } ?>
    <?php if ($Page->remark->Visible) { // remark ?>
        <td data-name="remark" class="<?= $Page->remark->footerCellClass() ?>"><span id="elf_process_action_payment_remark" class="process_action_payment_remark">
        </span></td>
    <?php } ?>
    <?php if ($Page->category->Visible) { // category ?>
        <td data-name="category" class="<?= $Page->category->footerCellClass() ?>"><span id="elf_process_action_payment_category" class="process_action_payment_category">
        </span></td>
    <?php } ?>
    <?php if ($Page->c_method->Visible) { // c_method ?>
        <td data-name="c_method" class="<?= $Page->c_method->footerCellClass() ?>"><span id="elf_process_action_payment_c_method" class="process_action_payment_c_method">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Page->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("process_action_payment");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
