<?php

namespace PHPMaker2024\fibre;

// Page object
$ProcessActionMaterialPaymentSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { process_action_material_payment: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fprocess_action_material_paymentsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fprocess_action_material_paymentsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["location", [], fields.location.isInvalid],
            ["process", [], fields.process.isInvalid],
            ["emp_id", [ew.Validators.integer], fields.emp_id.isInvalid],
            ["rid", [], fields.rid.isInvalid],
            ["quantity", [ew.Validators.float], fields.quantity.isInvalid],
            ["process_from", [], fields.process_from.isInvalid],
            ["process_to", [], fields.process_to.isInvalid],
            ["process_method", [], fields.process_method.isInvalid],
            ["ply", [ew.Validators.integer], fields.ply.isInvalid],
            ["rid_new", [], fields.rid_new.isInvalid],
            ["process_", [ew.Validators.integer], fields.process_.isInvalid],
            ["amount", [ew.Validators.float], fields.amount.isInvalid],
            ["incentive", [ew.Validators.float], fields.incentive.isInvalid],
            ["final_amount", [ew.Validators.float], fields.final_amount.isInvalid],
            ["description", [], fields.description.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["payment", [], fields.payment.isInvalid],
            ["y_payment", [ew.Validators.between], false],
            ["pp_id", [ew.Validators.integer], fields.pp_id.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "location": <?= $Page->location->toClientList($Page) ?>,
            "process": <?= $Page->process->toClientList($Page) ?>,
            "emp_id": <?= $Page->emp_id->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "process_from": <?= $Page->process_from->toClientList($Page) ?>,
            "process_to": <?= $Page->process_to->toClientList($Page) ?>,
            "process_method": <?= $Page->process_method->toClientList($Page) ?>,
            "rid_new": <?= $Page->rid_new->toClientList($Page) ?>,
            "payment": <?= $Page->payment->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fprocess_action_material_paymentsearch" id="fprocess_action_material_paymentsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="process_action_material_payment">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_payment_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_payment_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="process_action_material_payment" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
    <div id="r_location" class="row"<?= $Page->location->rowAttributes() ?>>
        <label for="x_location" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_payment_location"><?= $Page->location->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_location" id="z_location" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->location->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_payment_location" class="ew-search-field ew-search-field-single">
    <select
        id="x_location"
        name="x_location"
        class="form-select ew-select<?= $Page->location->isInvalidClass() ?>"
        <?php if (!$Page->location->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_material_paymentsearch_x_location"
        <?php } ?>
        data-table="process_action_material_payment"
        data-field="x_location"
        data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>"
        <?= $Page->location->editAttributes() ?>>
        <?= $Page->location->selectOptionListHtml("x_location") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->location->getErrorMessage(false) ?></div>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
<?php if (!$Page->location->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_material_paymentsearch", function() {
    var options = { name: "x_location", selectId: "fprocess_action_material_paymentsearch_x_location" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_material_paymentsearch.lists.location?.lookupOptions.length) {
        options.data = { id: "x_location", form: "fprocess_action_material_paymentsearch" };
    } else {
        options.ajax = { id: "x_location", form: "fprocess_action_material_paymentsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_material_payment.fields.location.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->process->Visible) { // process ?>
    <div id="r_process" class="row"<?= $Page->process->rowAttributes() ?>>
        <label for="x_process" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_payment_process"><?= $Page->process->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_process" id="z_process" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->process->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_payment_process" class="ew-search-field ew-search-field-single">
    <select
        id="x_process"
        name="x_process"
        class="form-select ew-select<?= $Page->process->isInvalidClass() ?>"
        <?php if (!$Page->process->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_material_paymentsearch_x_process"
        <?php } ?>
        data-table="process_action_material_payment"
        data-field="x_process"
        data-value-separator="<?= $Page->process->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process->getPlaceHolder()) ?>"
        <?= $Page->process->editAttributes() ?>>
        <?= $Page->process->selectOptionListHtml("x_process") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->process->getErrorMessage(false) ?></div>
<?= $Page->process->Lookup->getParamTag($Page, "p_x_process") ?>
<?php if (!$Page->process->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_material_paymentsearch", function() {
    var options = { name: "x_process", selectId: "fprocess_action_material_paymentsearch_x_process" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_material_paymentsearch.lists.process?.lookupOptions.length) {
        options.data = { id: "x_process", form: "fprocess_action_material_paymentsearch" };
    } else {
        options.ajax = { id: "x_process", form: "fprocess_action_material_paymentsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_material_payment.fields.process.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->emp_id->Visible) { // emp_id ?>
    <div id="r_emp_id" class="row"<?= $Page->emp_id->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_payment_emp_id"><?= $Page->emp_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_emp_id" id="z_emp_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->emp_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_payment_emp_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_emp_id"
        name="x_emp_id"
        class="form-control ew-select<?= $Page->emp_id->isInvalidClass() ?>"
        data-select2-id="fprocess_action_material_paymentsearch_x_emp_id"
        data-table="process_action_material_payment"
        data-field="x_emp_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->emp_id->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->emp_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->emp_id->getPlaceHolder()) ?>"
        <?= $Page->emp_id->editAttributes() ?>>
        <?= $Page->emp_id->selectOptionListHtml("x_emp_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->emp_id->getErrorMessage(false) ?></div>
<?= $Page->emp_id->Lookup->getParamTag($Page, "p_x_emp_id") ?>
<script>
loadjs.ready("fprocess_action_material_paymentsearch", function() {
    var options = { name: "x_emp_id", selectId: "fprocess_action_material_paymentsearch_x_emp_id" };
    if (fprocess_action_material_paymentsearch.lists.emp_id?.lookupOptions.length) {
        options.data = { id: "x_emp_id", form: "fprocess_action_material_paymentsearch" };
    } else {
        options.ajax = { id: "x_emp_id", form: "fprocess_action_material_paymentsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.process_action_material_payment.fields.emp_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity" class="row"<?= $Page->quantity->rowAttributes() ?>>
        <label for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_payment_quantity"><?= $Page->quantity->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_quantity" id="z_quantity" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->quantity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_payment_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->quantity->getInputTextType() ?>" name="x_quantity" id="x_quantity" data-table="process_action_material_payment" data-field="x_quantity" value="<?= $Page->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity->formatPattern()) ?>"<?= $Page->quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->quantity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->process_from->Visible) { // process_from ?>
    <div id="r_process_from" class="row"<?= $Page->process_from->rowAttributes() ?>>
        <label for="x_process_from" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_payment_process_from"><?= $Page->process_from->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_process_from" id="z_process_from" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->process_from->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_payment_process_from" class="ew-search-field ew-search-field-single">
    <select
        id="x_process_from"
        name="x_process_from"
        class="form-select ew-select<?= $Page->process_from->isInvalidClass() ?>"
        <?php if (!$Page->process_from->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_material_paymentsearch_x_process_from"
        <?php } ?>
        data-table="process_action_material_payment"
        data-field="x_process_from"
        data-value-separator="<?= $Page->process_from->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process_from->getPlaceHolder()) ?>"
        <?= $Page->process_from->editAttributes() ?>>
        <?= $Page->process_from->selectOptionListHtml("x_process_from") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->process_from->getErrorMessage(false) ?></div>
<?= $Page->process_from->Lookup->getParamTag($Page, "p_x_process_from") ?>
<?php if (!$Page->process_from->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_material_paymentsearch", function() {
    var options = { name: "x_process_from", selectId: "fprocess_action_material_paymentsearch_x_process_from" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_material_paymentsearch.lists.process_from?.lookupOptions.length) {
        options.data = { id: "x_process_from", form: "fprocess_action_material_paymentsearch" };
    } else {
        options.ajax = { id: "x_process_from", form: "fprocess_action_material_paymentsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_material_payment.fields.process_from.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->process_to->Visible) { // process_to ?>
    <div id="r_process_to" class="row"<?= $Page->process_to->rowAttributes() ?>>
        <label for="x_process_to" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_payment_process_to"><?= $Page->process_to->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_process_to" id="z_process_to" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->process_to->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_payment_process_to" class="ew-search-field ew-search-field-single">
    <select
        id="x_process_to"
        name="x_process_to"
        class="form-select ew-select<?= $Page->process_to->isInvalidClass() ?>"
        <?php if (!$Page->process_to->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_material_paymentsearch_x_process_to"
        <?php } ?>
        data-table="process_action_material_payment"
        data-field="x_process_to"
        data-value-separator="<?= $Page->process_to->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process_to->getPlaceHolder()) ?>"
        <?= $Page->process_to->editAttributes() ?>>
        <?= $Page->process_to->selectOptionListHtml("x_process_to") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->process_to->getErrorMessage(false) ?></div>
<?= $Page->process_to->Lookup->getParamTag($Page, "p_x_process_to") ?>
<?php if (!$Page->process_to->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_material_paymentsearch", function() {
    var options = { name: "x_process_to", selectId: "fprocess_action_material_paymentsearch_x_process_to" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_material_paymentsearch.lists.process_to?.lookupOptions.length) {
        options.data = { id: "x_process_to", form: "fprocess_action_material_paymentsearch" };
    } else {
        options.ajax = { id: "x_process_to", form: "fprocess_action_material_paymentsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_material_payment.fields.process_to.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->process_method->Visible) { // process_method ?>
    <div id="r_process_method" class="row"<?= $Page->process_method->rowAttributes() ?>>
        <label for="x_process_method" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_payment_process_method"><?= $Page->process_method->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_process_method" id="z_process_method" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->process_method->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_payment_process_method" class="ew-search-field ew-search-field-single">
    <select
        id="x_process_method"
        name="x_process_method"
        class="form-select ew-select<?= $Page->process_method->isInvalidClass() ?>"
        <?php if (!$Page->process_method->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_material_paymentsearch_x_process_method"
        <?php } ?>
        data-table="process_action_material_payment"
        data-field="x_process_method"
        data-value-separator="<?= $Page->process_method->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process_method->getPlaceHolder()) ?>"
        <?= $Page->process_method->editAttributes() ?>>
        <?= $Page->process_method->selectOptionListHtml("x_process_method") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->process_method->getErrorMessage(false) ?></div>
<?php if (!$Page->process_method->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_material_paymentsearch", function() {
    var options = { name: "x_process_method", selectId: "fprocess_action_material_paymentsearch_x_process_method" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_material_paymentsearch.lists.process_method?.lookupOptions.length) {
        options.data = { id: "x_process_method", form: "fprocess_action_material_paymentsearch" };
    } else {
        options.ajax = { id: "x_process_method", form: "fprocess_action_material_paymentsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_material_payment.fields.process_method.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ply->Visible) { // ply ?>
    <div id="r_ply" class="row"<?= $Page->ply->rowAttributes() ?>>
        <label for="x_ply" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_payment_ply"><?= $Page->ply->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_ply" id="z_ply" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ply->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_payment_ply" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ply->getInputTextType() ?>" name="x_ply" id="x_ply" data-table="process_action_material_payment" data-field="x_ply" value="<?= $Page->ply->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->ply->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ply->formatPattern()) ?>"<?= $Page->ply->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ply->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->rid_new->Visible) { // rid_new ?>
    <div id="r_rid_new" class="row"<?= $Page->rid_new->rowAttributes() ?>>
        <label for="x_rid_new" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_payment_rid_new"><?= $Page->rid_new->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_rid_new" id="z_rid_new" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rid_new->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_payment_rid_new" class="ew-search-field ew-search-field-single">
    <select
        id="x_rid_new"
        name="x_rid_new"
        class="form-select ew-select<?= $Page->rid_new->isInvalidClass() ?>"
        <?php if (!$Page->rid_new->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_material_paymentsearch_x_rid_new"
        <?php } ?>
        data-table="process_action_material_payment"
        data-field="x_rid_new"
        data-value-separator="<?= $Page->rid_new->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid_new->getPlaceHolder()) ?>"
        <?= $Page->rid_new->editAttributes() ?>>
        <?= $Page->rid_new->selectOptionListHtml("x_rid_new") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->rid_new->getErrorMessage(false) ?></div>
<?= $Page->rid_new->Lookup->getParamTag($Page, "p_x_rid_new") ?>
<?php if (!$Page->rid_new->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_material_paymentsearch", function() {
    var options = { name: "x_rid_new", selectId: "fprocess_action_material_paymentsearch_x_rid_new" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_material_paymentsearch.lists.rid_new?.lookupOptions.length) {
        options.data = { id: "x_rid_new", form: "fprocess_action_material_paymentsearch" };
    } else {
        options.ajax = { id: "x_rid_new", form: "fprocess_action_material_paymentsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_material_payment.fields.rid_new.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->process_->Visible) { // process_@ ?>
    <div id="r_process_" class="row"<?= $Page->process_->rowAttributes() ?>>
        <label for="x_process_" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_payment_process_"><?= $Page->process_->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_process_" id="z_process_" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->process_->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_payment_process_" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->process_->getInputTextType() ?>" name="x_process_" id="x_process_" data-table="process_action_material_payment" data-field="x_process_" value="<?= $Page->process_->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->process_->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->process_->formatPattern()) ?>"<?= $Page->process_->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->process_->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
    <div id="r_amount" class="row"<?= $Page->amount->rowAttributes() ?>>
        <label for="x_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_payment_amount"><?= $Page->amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_amount" id="z_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_payment_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->amount->getInputTextType() ?>" name="x_amount" id="x_amount" data-table="process_action_material_payment" data-field="x_amount" value="<?= $Page->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->incentive->Visible) { // incentive ?>
    <div id="r_incentive" class="row"<?= $Page->incentive->rowAttributes() ?>>
        <label for="x_incentive" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_payment_incentive"><?= $Page->incentive->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_incentive" id="z_incentive" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->incentive->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_payment_incentive" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->incentive->getInputTextType() ?>" name="x_incentive" id="x_incentive" data-table="process_action_material_payment" data-field="x_incentive" value="<?= $Page->incentive->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->incentive->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->incentive->formatPattern()) ?>"<?= $Page->incentive->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->incentive->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->final_amount->Visible) { // final_amount ?>
    <div id="r_final_amount" class="row"<?= $Page->final_amount->rowAttributes() ?>>
        <label for="x_final_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_payment_final_amount"><?= $Page->final_amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_final_amount" id="z_final_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->final_amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_payment_final_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->final_amount->getInputTextType() ?>" name="x_final_amount" id="x_final_amount" data-table="process_action_material_payment" data-field="x_final_amount" value="<?= $Page->final_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->final_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->final_amount->formatPattern()) ?>"<?= $Page->final_amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->final_amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->description->Visible) { // description ?>
    <div id="r_description" class="row"<?= $Page->description->rowAttributes() ?>>
        <label for="x_description" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_payment_description"><?= $Page->description->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_description" id="z_description" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_payment_description" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->description->getInputTextType() ?>" name="x_description" id="x_description" data-table="process_action_material_payment" data-field="x_description" value="<?= $Page->description->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->description->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description->formatPattern()) ?>"<?= $Page->description->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->description->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_payment_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_payment_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="process_action_material_payment" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="225" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->payment->Visible) { // payment ?>
    <div id="r_payment" class="row"<?= $Page->payment->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_payment_payment"><?= $Page->payment->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->payment->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_payment" id="z_payment" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->payment->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->payment->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_process_action_material_payment_payment" class="ew-search-field">
    <select
        id="x_payment[]"
        name="x_payment[]"
        class="form-select ew-select<?= $Page->payment->isInvalidClass() ?>"
        <?php if (!$Page->payment->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_material_paymentsearch_x_payment[]"
        <?php } ?>
        data-table="process_action_material_payment"
        data-field="x_payment"
        data-dropdown
        multiple
        size="1"
        data-value-separator="<?= $Page->payment->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->payment->getPlaceHolder()) ?>"
        <?= $Page->payment->editAttributes() ?>>
        <?= $Page->payment->selectOptionListHtml("x_payment[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->payment->getErrorMessage(false) ?></div>
<?= $Page->payment->Lookup->getParamTag($Page, "p_x_payment") ?>
<?php if (!$Page->payment->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_material_paymentsearch", function() {
    var options = { name: "x_payment[]", selectId: "fprocess_action_material_paymentsearch_x_payment[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.columns = el.dataset.repeatcolumn || 5;
    options.dropdown = !ew.IS_MOBILE && options.columns > 0; // Use custom dropdown
    el.dataset.dropdown = options.dropdown;
    if (options.dropdown) {
        options.dropdownAutoWidth = true;
        options.dropdownCssClass = "ew-select-dropdown process_action_material_payment-x_payment-dropdown ew-select-" + (options.multiple ? "multiple" : "one");
        if (options.columns > 1)
            options.dropdownCssClass += " ew-repeat-column";
    }
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_material_paymentsearch.lists.payment?.lookupOptions.length) {
        options.data = { id: "x_payment[]", form: "fprocess_action_material_paymentsearch" };
    } else {
        options.ajax = { id: "x_payment[]", form: "fprocess_action_material_paymentsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_material_payment.fields.payment.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_process_action_material_payment_payment" class="ew-search-field2 d-none">
    <select
        id="y_payment[]"
        name="y_payment[]"
        class="form-select ew-select<?= $Page->payment->isInvalidClass() ?>"
        <?php if (!$Page->payment->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_material_paymentsearch_y_payment[]"
        <?php } ?>
        data-table="process_action_material_payment"
        data-field="x_payment"
        data-dropdown
        multiple
        size="1"
        data-value-separator="<?= $Page->payment->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->payment->getPlaceHolder()) ?>"
        <?= $Page->payment->editAttributes() ?>>
        <?= $Page->payment->selectOptionListHtml("y_payment[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->payment->getErrorMessage(false) ?></div>
<?= $Page->payment->Lookup->getParamTag($Page, "p_y_payment") ?>
<?php if (!$Page->payment->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_material_paymentsearch", function() {
    var options = { name: "y_payment[]", selectId: "fprocess_action_material_paymentsearch_y_payment[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.columns = el.dataset.repeatcolumn || 5;
    options.dropdown = !ew.IS_MOBILE && options.columns > 0; // Use custom dropdown
    el.dataset.dropdown = options.dropdown;
    if (options.dropdown) {
        options.dropdownAutoWidth = true;
        options.dropdownCssClass = "ew-select-dropdown process_action_material_payment-x_payment-dropdown ew-select-" + (options.multiple ? "multiple" : "one");
        if (options.columns > 1)
            options.dropdownCssClass += " ew-repeat-column";
    }
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_material_paymentsearch.lists.payment?.lookupOptions.length) {
        options.data = { id: "y_payment[]", form: "fprocess_action_material_paymentsearch" };
    } else {
        options.ajax = { id: "y_payment[]", form: "fprocess_action_material_paymentsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_material_payment.fields.payment.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pp_id->Visible) { // pp_id ?>
    <div id="r_pp_id" class="row"<?= $Page->pp_id->rowAttributes() ?>>
        <label for="x_pp_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_payment_pp_id"><?= $Page->pp_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pp_id" id="z_pp_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pp_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_payment_pp_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pp_id->getInputTextType() ?>" name="x_pp_id" id="x_pp_id" data-table="process_action_material_payment" data-field="x_pp_id" value="<?= $Page->pp_id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pp_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pp_id->formatPattern()) ?>"<?= $Page->pp_id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pp_id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_payment_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_payment_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="process_action_material_payment" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprocess_action_material_paymentsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprocess_action_material_paymentsearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fprocess_action_material_paymentsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fprocess_action_material_paymentsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fprocess_action_material_paymentsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("process_action_material_payment");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
