<?php

namespace PHPMaker2024\fibre;

// Page object
$ProcessActionMaterialPaymentList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { process_action_material_payment: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fprocess_action_material_paymentsrch" id="fprocess_action_material_paymentsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fprocess_action_material_paymentsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { process_action_material_payment: currentTable } });
var currentForm;
var fprocess_action_material_paymentsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fprocess_action_material_paymentsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["location", [], fields.location.isInvalid],
            ["process", [], fields.process.isInvalid],
            ["emp_id", [ew.Validators.integer], fields.emp_id.isInvalid],
            ["rid", [], fields.rid.isInvalid],
            ["process_from", [], fields.process_from.isInvalid],
            ["process_to", [], fields.process_to.isInvalid],
            ["payment", [], fields.payment.isInvalid],
            ["y_payment", [ew.Validators.between], false]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "location": <?= $Page->location->toClientList($Page) ?>,
            "process": <?= $Page->process->toClientList($Page) ?>,
            "emp_id": <?= $Page->emp_id->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "process_from": <?= $Page->process_from->toClientList($Page) ?>,
            "process_to": <?= $Page->process_to->toClientList($Page) ?>,
            "payment": <?= $Page->payment->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->location->Visible) { // location ?>
<?php
if (!$Page->location->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_location" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->location->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_location" class="ew-search-caption ew-label"><?= $Page->location->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_location" id="z_location" value="=">
</div>
        </div>
        <div id="el_process_action_material_payment_location" class="ew-search-field">
    <select
        id="x_location"
        name="x_location"
        class="form-select ew-select<?= $Page->location->isInvalidClass() ?>"
        <?php if (!$Page->location->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_material_paymentsrch_x_location"
        <?php } ?>
        data-table="process_action_material_payment"
        data-field="x_location"
        data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>"
        <?= $Page->location->editAttributes() ?>>
        <?= $Page->location->selectOptionListHtml("x_location") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->location->getErrorMessage(false) ?></div>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
<?php if (!$Page->location->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_material_paymentsrch", function() {
    var options = { name: "x_location", selectId: "fprocess_action_material_paymentsrch_x_location" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_material_paymentsrch.lists.location?.lookupOptions.length) {
        options.data = { id: "x_location", form: "fprocess_action_material_paymentsrch" };
    } else {
        options.ajax = { id: "x_location", form: "fprocess_action_material_paymentsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_material_payment.fields.location.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->process->Visible) { // process ?>
<?php
if (!$Page->process->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_process" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->process->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_process" class="ew-search-caption ew-label"><?= $Page->process->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_process" id="z_process" value="=">
</div>
        </div>
        <div id="el_process_action_material_payment_process" class="ew-search-field">
    <select
        id="x_process"
        name="x_process"
        class="form-select ew-select<?= $Page->process->isInvalidClass() ?>"
        <?php if (!$Page->process->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_material_paymentsrch_x_process"
        <?php } ?>
        data-table="process_action_material_payment"
        data-field="x_process"
        data-value-separator="<?= $Page->process->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process->getPlaceHolder()) ?>"
        <?= $Page->process->editAttributes() ?>>
        <?= $Page->process->selectOptionListHtml("x_process") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->process->getErrorMessage(false) ?></div>
<?= $Page->process->Lookup->getParamTag($Page, "p_x_process") ?>
<?php if (!$Page->process->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_material_paymentsrch", function() {
    var options = { name: "x_process", selectId: "fprocess_action_material_paymentsrch_x_process" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_material_paymentsrch.lists.process?.lookupOptions.length) {
        options.data = { id: "x_process", form: "fprocess_action_material_paymentsrch" };
    } else {
        options.ajax = { id: "x_process", form: "fprocess_action_material_paymentsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_material_payment.fields.process.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->emp_id->Visible) { // emp_id ?>
<?php
if (!$Page->emp_id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_emp_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->emp_id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->emp_id->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_emp_id" id="z_emp_id" value="=">
</div>
        </div>
        <div id="el_process_action_material_payment_emp_id" class="ew-search-field">
    <select
        id="x_emp_id"
        name="x_emp_id"
        class="form-control ew-select<?= $Page->emp_id->isInvalidClass() ?>"
        data-select2-id="fprocess_action_material_paymentsrch_x_emp_id"
        data-table="process_action_material_payment"
        data-field="x_emp_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->emp_id->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->emp_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->emp_id->getPlaceHolder()) ?>"
        <?= $Page->emp_id->editAttributes() ?>>
        <?= $Page->emp_id->selectOptionListHtml("x_emp_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->emp_id->getErrorMessage(false) ?></div>
<?= $Page->emp_id->Lookup->getParamTag($Page, "p_x_emp_id") ?>
<script>
loadjs.ready("fprocess_action_material_paymentsrch", function() {
    var options = { name: "x_emp_id", selectId: "fprocess_action_material_paymentsrch_x_emp_id" };
    if (fprocess_action_material_paymentsrch.lists.emp_id?.lookupOptions.length) {
        options.data = { id: "x_emp_id", form: "fprocess_action_material_paymentsrch" };
    } else {
        options.ajax = { id: "x_emp_id", form: "fprocess_action_material_paymentsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.process_action_material_payment.fields.emp_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
<?php
if (!$Page->rid->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_rid" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->rid->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->rid->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_rid" id="z_rid" value="LIKE">
</div>
        </div>
        <div id="el_process_action_material_payment_rid" class="ew-search-field">
<?php
if (IsRTL()) {
    $Page->rid->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_rid" class="ew-auto-suggest">
    <input type="<?= $Page->rid->getInputTextType() ?>" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?= RemoveHtml($Page->rid->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rid->formatPattern()) ?>"<?= $Page->rid->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="process_action_material_payment" data-field="x_rid" data-input="sv_x_rid" data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?= HtmlEncode($Page->rid->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->rid->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fprocess_action_material_paymentsrch", function() {
    fprocess_action_material_paymentsrch.createAutoSuggest(Object.assign({"id":"x_rid","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->rid->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.process_action_material_payment.fields.rid.autoSuggestOptions));
});
</script>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->process_from->Visible) { // process_from ?>
<?php
if (!$Page->process_from->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_process_from" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->process_from->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_process_from" class="ew-search-caption ew-label"><?= $Page->process_from->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_process_from" id="z_process_from" value="=">
</div>
        </div>
        <div id="el_process_action_material_payment_process_from" class="ew-search-field">
    <select
        id="x_process_from"
        name="x_process_from"
        class="form-select ew-select<?= $Page->process_from->isInvalidClass() ?>"
        <?php if (!$Page->process_from->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_material_paymentsrch_x_process_from"
        <?php } ?>
        data-table="process_action_material_payment"
        data-field="x_process_from"
        data-value-separator="<?= $Page->process_from->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process_from->getPlaceHolder()) ?>"
        <?= $Page->process_from->editAttributes() ?>>
        <?= $Page->process_from->selectOptionListHtml("x_process_from") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->process_from->getErrorMessage(false) ?></div>
<?= $Page->process_from->Lookup->getParamTag($Page, "p_x_process_from") ?>
<?php if (!$Page->process_from->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_material_paymentsrch", function() {
    var options = { name: "x_process_from", selectId: "fprocess_action_material_paymentsrch_x_process_from" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_material_paymentsrch.lists.process_from?.lookupOptions.length) {
        options.data = { id: "x_process_from", form: "fprocess_action_material_paymentsrch" };
    } else {
        options.ajax = { id: "x_process_from", form: "fprocess_action_material_paymentsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_material_payment.fields.process_from.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->process_to->Visible) { // process_to ?>
<?php
if (!$Page->process_to->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_process_to" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->process_to->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_process_to" class="ew-search-caption ew-label"><?= $Page->process_to->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_process_to" id="z_process_to" value="=">
</div>
        </div>
        <div id="el_process_action_material_payment_process_to" class="ew-search-field">
    <select
        id="x_process_to"
        name="x_process_to"
        class="form-select ew-select<?= $Page->process_to->isInvalidClass() ?>"
        <?php if (!$Page->process_to->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_material_paymentsrch_x_process_to"
        <?php } ?>
        data-table="process_action_material_payment"
        data-field="x_process_to"
        data-value-separator="<?= $Page->process_to->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process_to->getPlaceHolder()) ?>"
        <?= $Page->process_to->editAttributes() ?>>
        <?= $Page->process_to->selectOptionListHtml("x_process_to") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->process_to->getErrorMessage(false) ?></div>
<?= $Page->process_to->Lookup->getParamTag($Page, "p_x_process_to") ?>
<?php if (!$Page->process_to->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_material_paymentsrch", function() {
    var options = { name: "x_process_to", selectId: "fprocess_action_material_paymentsrch_x_process_to" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_material_paymentsrch.lists.process_to?.lookupOptions.length) {
        options.data = { id: "x_process_to", form: "fprocess_action_material_paymentsrch" };
    } else {
        options.ajax = { id: "x_process_to", form: "fprocess_action_material_paymentsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_material_payment.fields.process_to.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->payment->Visible) { // payment ?>
<?php
if (!$Page->payment->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_payment" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->payment->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->payment->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_payment" id="z_payment" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->payment->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->payment->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_process_action_material_payment_payment" class="ew-search-field">
    <select
        id="x_payment[]"
        name="x_payment[]"
        class="form-select ew-select<?= $Page->payment->isInvalidClass() ?>"
        <?php if (!$Page->payment->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_material_paymentsrch_x_payment[]"
        <?php } ?>
        data-table="process_action_material_payment"
        data-field="x_payment"
        data-dropdown
        multiple
        size="1"
        data-value-separator="<?= $Page->payment->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->payment->getPlaceHolder()) ?>"
        <?= $Page->payment->editAttributes() ?>>
        <?= $Page->payment->selectOptionListHtml("x_payment[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->payment->getErrorMessage(false) ?></div>
<?= $Page->payment->Lookup->getParamTag($Page, "p_x_payment") ?>
<?php if (!$Page->payment->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_material_paymentsrch", function() {
    var options = { name: "x_payment[]", selectId: "fprocess_action_material_paymentsrch_x_payment[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.columns = el.dataset.repeatcolumn || 5;
    options.dropdown = !ew.IS_MOBILE && options.columns > 0; // Use custom dropdown
    el.dataset.dropdown = options.dropdown;
    if (options.dropdown) {
        options.dropdownAutoWidth = true;
        options.dropdownCssClass = "ew-select-dropdown process_action_material_payment-x_payment-dropdown ew-select-" + (options.multiple ? "multiple" : "one");
        if (options.columns > 1)
            options.dropdownCssClass += " ew-repeat-column";
    }
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_material_paymentsrch.lists.payment?.lookupOptions.length) {
        options.data = { id: "x_payment[]", form: "fprocess_action_material_paymentsrch" };
    } else {
        options.ajax = { id: "x_payment[]", form: "fprocess_action_material_paymentsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_material_payment.fields.payment.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_process_action_material_payment_payment" class="ew-search-field2 d-none">
    <select
        id="y_payment[]"
        name="y_payment[]"
        class="form-select ew-select<?= $Page->payment->isInvalidClass() ?>"
        <?php if (!$Page->payment->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_material_paymentsrch_y_payment[]"
        <?php } ?>
        data-table="process_action_material_payment"
        data-field="x_payment"
        data-dropdown
        multiple
        size="1"
        data-value-separator="<?= $Page->payment->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->payment->getPlaceHolder()) ?>"
        <?= $Page->payment->editAttributes() ?>>
        <?= $Page->payment->selectOptionListHtml("y_payment[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->payment->getErrorMessage(false) ?></div>
<?= $Page->payment->Lookup->getParamTag($Page, "p_y_payment") ?>
<?php if (!$Page->payment->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_material_paymentsrch", function() {
    var options = { name: "y_payment[]", selectId: "fprocess_action_material_paymentsrch_y_payment[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.columns = el.dataset.repeatcolumn || 5;
    options.dropdown = !ew.IS_MOBILE && options.columns > 0; // Use custom dropdown
    el.dataset.dropdown = options.dropdown;
    if (options.dropdown) {
        options.dropdownAutoWidth = true;
        options.dropdownCssClass = "ew-select-dropdown process_action_material_payment-x_payment-dropdown ew-select-" + (options.multiple ? "multiple" : "one");
        if (options.columns > 1)
            options.dropdownCssClass += " ew-repeat-column";
    }
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_material_paymentsrch.lists.payment?.lookupOptions.length) {
        options.data = { id: "y_payment[]", form: "fprocess_action_material_paymentsrch" };
    } else {
        options.ajax = { id: "y_payment[]", form: "fprocess_action_material_paymentsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_material_payment.fields.payment.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fprocess_action_material_paymentsrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fprocess_action_material_paymentsrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fprocess_action_material_paymentsrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fprocess_action_material_paymentsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fprocess_action_material_paymentsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fprocess_action_material_paymentsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fprocess_action_material_paymentsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="process_action_material_payment">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_process_action_material_payment" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_process_action_material_paymentlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_process_action_material_payment_id" class="process_action_material_payment_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
        <th data-name="location" class="<?= $Page->location->headerCellClass() ?>"><div id="elh_process_action_material_payment_location" class="process_action_material_payment_location"><?= $Page->renderFieldHeader($Page->location) ?></div></th>
<?php } ?>
<?php if ($Page->process->Visible) { // process ?>
        <th data-name="process" class="<?= $Page->process->headerCellClass() ?>"><div id="elh_process_action_material_payment_process" class="process_action_material_payment_process"><?= $Page->renderFieldHeader($Page->process) ?></div></th>
<?php } ?>
<?php if ($Page->emp_id->Visible) { // emp_id ?>
        <th data-name="emp_id" class="<?= $Page->emp_id->headerCellClass() ?>"><div id="elh_process_action_material_payment_emp_id" class="process_action_material_payment_emp_id"><?= $Page->renderFieldHeader($Page->emp_id) ?></div></th>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
        <th data-name="rid" class="<?= $Page->rid->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_process_action_material_payment_rid" class="process_action_material_payment_rid"><?= $Page->renderFieldHeader($Page->rid) ?></div></th>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
        <th data-name="quantity" class="<?= $Page->quantity->headerCellClass() ?>"><div id="elh_process_action_material_payment_quantity" class="process_action_material_payment_quantity"><?= $Page->renderFieldHeader($Page->quantity) ?></div></th>
<?php } ?>
<?php if ($Page->process_from->Visible) { // process_from ?>
        <th data-name="process_from" class="<?= $Page->process_from->headerCellClass() ?>"><div id="elh_process_action_material_payment_process_from" class="process_action_material_payment_process_from"><?= $Page->renderFieldHeader($Page->process_from) ?></div></th>
<?php } ?>
<?php if ($Page->process_to->Visible) { // process_to ?>
        <th data-name="process_to" class="<?= $Page->process_to->headerCellClass() ?>"><div id="elh_process_action_material_payment_process_to" class="process_action_material_payment_process_to"><?= $Page->renderFieldHeader($Page->process_to) ?></div></th>
<?php } ?>
<?php if ($Page->process_method->Visible) { // process_method ?>
        <th data-name="process_method" class="<?= $Page->process_method->headerCellClass() ?>"><div id="elh_process_action_material_payment_process_method" class="process_action_material_payment_process_method"><?= $Page->renderFieldHeader($Page->process_method) ?></div></th>
<?php } ?>
<?php if ($Page->ply->Visible) { // ply ?>
        <th data-name="ply" class="<?= $Page->ply->headerCellClass() ?>"><div id="elh_process_action_material_payment_ply" class="process_action_material_payment_ply"><?= $Page->renderFieldHeader($Page->ply) ?></div></th>
<?php } ?>
<?php if ($Page->rid_new->Visible) { // rid_new ?>
        <th data-name="rid_new" class="<?= $Page->rid_new->headerCellClass() ?>"><div id="elh_process_action_material_payment_rid_new" class="process_action_material_payment_rid_new"><?= $Page->renderFieldHeader($Page->rid_new) ?></div></th>
<?php } ?>
<?php if ($Page->process_->Visible) { // process_@ ?>
        <th data-name="process_" class="<?= $Page->process_->headerCellClass() ?>"><div id="elh_process_action_material_payment_process_" class="process_action_material_payment_process_"><?= $Page->renderFieldHeader($Page->process_) ?></div></th>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
        <th data-name="amount" class="<?= $Page->amount->headerCellClass() ?>"><div id="elh_process_action_material_payment_amount" class="process_action_material_payment_amount"><?= $Page->renderFieldHeader($Page->amount) ?></div></th>
<?php } ?>
<?php if ($Page->incentive->Visible) { // incentive ?>
        <th data-name="incentive" class="<?= $Page->incentive->headerCellClass() ?>"><div id="elh_process_action_material_payment_incentive" class="process_action_material_payment_incentive"><?= $Page->renderFieldHeader($Page->incentive) ?></div></th>
<?php } ?>
<?php if ($Page->final_amount->Visible) { // final_amount ?>
        <th data-name="final_amount" class="<?= $Page->final_amount->headerCellClass() ?>"><div id="elh_process_action_material_payment_final_amount" class="process_action_material_payment_final_amount"><?= $Page->renderFieldHeader($Page->final_amount) ?></div></th>
<?php } ?>
<?php if ($Page->description->Visible) { // description ?>
        <th data-name="description" class="<?= $Page->description->headerCellClass() ?>"><div id="elh_process_action_material_payment_description" class="process_action_material_payment_description"><?= $Page->renderFieldHeader($Page->description) ?></div></th>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
        <th data-name="remarks" class="<?= $Page->remarks->headerCellClass() ?>"><div id="elh_process_action_material_payment_remarks" class="process_action_material_payment_remarks"><?= $Page->renderFieldHeader($Page->remarks) ?></div></th>
<?php } ?>
<?php if ($Page->payment->Visible) { // payment ?>
        <th data-name="payment" class="<?= $Page->payment->headerCellClass() ?>"><div id="elh_process_action_material_payment_payment" class="process_action_material_payment_payment"><?= $Page->renderFieldHeader($Page->payment) ?></div></th>
<?php } ?>
<?php if ($Page->pp_id->Visible) { // pp_id ?>
        <th data-name="pp_id" class="<?= $Page->pp_id->headerCellClass() ?>"><div id="elh_process_action_material_payment_pp_id" class="process_action_material_payment_pp_id"><?= $Page->renderFieldHeader($Page->pp_id) ?></div></th>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Page->datetime->headerCellClass() ?>"><div id="elh_process_action_material_payment_datetime" class="process_action_material_payment_datetime"><?= $Page->renderFieldHeader($Page->datetime) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_material_payment_id" class="el_process_action_material_payment_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->location->Visible) { // location ?>
        <td data-name="location"<?= $Page->location->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_material_payment_location" class="el_process_action_material_payment_location">
<span<?= $Page->location->viewAttributes() ?>>
<?= $Page->location->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->process->Visible) { // process ?>
        <td data-name="process"<?= $Page->process->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_material_payment_process" class="el_process_action_material_payment_process">
<span<?= $Page->process->viewAttributes() ?>>
<?php if (!EmptyString($Page->process->getViewValue()) && $Page->process->linkAttributes() != "") { ?>
<a<?= $Page->process->linkAttributes() ?>><?= $Page->process->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->process->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->emp_id->Visible) { // emp_id ?>
        <td data-name="emp_id"<?= $Page->emp_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_material_payment_emp_id" class="el_process_action_material_payment_emp_id">
<span<?= $Page->emp_id->viewAttributes() ?>>
<?= $Page->emp_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->rid->Visible) { // rid ?>
        <td data-name="rid"<?= $Page->rid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_material_payment_rid" class="el_process_action_material_payment_rid">
<span<?= $Page->rid->viewAttributes() ?>>
<?= $Page->rid->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->quantity->Visible) { // quantity ?>
        <td data-name="quantity"<?= $Page->quantity->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_material_payment_quantity" class="el_process_action_material_payment_quantity">
<span<?= $Page->quantity->viewAttributes() ?>>
<?= $Page->quantity->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->process_from->Visible) { // process_from ?>
        <td data-name="process_from"<?= $Page->process_from->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_material_payment_process_from" class="el_process_action_material_payment_process_from">
<span<?= $Page->process_from->viewAttributes() ?>>
<?= $Page->process_from->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->process_to->Visible) { // process_to ?>
        <td data-name="process_to"<?= $Page->process_to->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_material_payment_process_to" class="el_process_action_material_payment_process_to">
<span<?= $Page->process_to->viewAttributes() ?>>
<?= $Page->process_to->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->process_method->Visible) { // process_method ?>
        <td data-name="process_method"<?= $Page->process_method->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_material_payment_process_method" class="el_process_action_material_payment_process_method">
<span<?= $Page->process_method->viewAttributes() ?>>
<?= $Page->process_method->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ply->Visible) { // ply ?>
        <td data-name="ply"<?= $Page->ply->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_material_payment_ply" class="el_process_action_material_payment_ply">
<span<?= $Page->ply->viewAttributes() ?>>
<?= $Page->ply->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->rid_new->Visible) { // rid_new ?>
        <td data-name="rid_new"<?= $Page->rid_new->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_material_payment_rid_new" class="el_process_action_material_payment_rid_new">
<span<?= $Page->rid_new->viewAttributes() ?>>
<?= $Page->rid_new->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->process_->Visible) { // process_@ ?>
        <td data-name="process_"<?= $Page->process_->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_material_payment_process_" class="el_process_action_material_payment_process_">
<span<?= $Page->process_->viewAttributes() ?>>
<?= $Page->process_->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->amount->Visible) { // amount ?>
        <td data-name="amount"<?= $Page->amount->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_material_payment_amount" class="el_process_action_material_payment_amount">
<span<?= $Page->amount->viewAttributes() ?>>
<?= $Page->amount->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->incentive->Visible) { // incentive ?>
        <td data-name="incentive"<?= $Page->incentive->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_material_payment_incentive" class="el_process_action_material_payment_incentive">
<span<?= $Page->incentive->viewAttributes() ?>>
<?= $Page->incentive->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->final_amount->Visible) { // final_amount ?>
        <td data-name="final_amount"<?= $Page->final_amount->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_material_payment_final_amount" class="el_process_action_material_payment_final_amount">
<span<?= $Page->final_amount->viewAttributes() ?>>
<?= $Page->final_amount->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->description->Visible) { // description ?>
        <td data-name="description"<?= $Page->description->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_material_payment_description" class="el_process_action_material_payment_description">
<span<?= $Page->description->viewAttributes() ?>>
<?= $Page->description->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->remarks->Visible) { // remarks ?>
        <td data-name="remarks"<?= $Page->remarks->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_material_payment_remarks" class="el_process_action_material_payment_remarks">
<span<?= $Page->remarks->viewAttributes() ?>>
<?= $Page->remarks->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->payment->Visible) { // payment ?>
        <td data-name="payment"<?= $Page->payment->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_material_payment_payment" class="el_process_action_material_payment_payment">
<span<?= $Page->payment->viewAttributes() ?>>
<?= $Page->payment->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pp_id->Visible) { // pp_id ?>
        <td data-name="pp_id"<?= $Page->pp_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_material_payment_pp_id" class="el_process_action_material_payment_pp_id">
<span<?= $Page->pp_id->viewAttributes() ?>>
<?= $Page->pp_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_material_payment_datetime" class="el_process_action_material_payment_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Page->RowType = RowType::AGGREGATE;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->TotalRecords > 0 && !$Page->isGridAdd() && !$Page->isGridEdit() && !$Page->isMultiEdit()) { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (footer, left)
$Page->ListOptions->render("footer", "left");
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id" class="<?= $Page->id->footerCellClass() ?>"><span id="elf_process_action_material_payment_id" class="process_action_material_payment_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->location->Visible) { // location ?>
        <td data-name="location" class="<?= $Page->location->footerCellClass() ?>"><span id="elf_process_action_material_payment_location" class="process_action_material_payment_location">
        </span></td>
    <?php } ?>
    <?php if ($Page->process->Visible) { // process ?>
        <td data-name="process" class="<?= $Page->process->footerCellClass() ?>"><span id="elf_process_action_material_payment_process" class="process_action_material_payment_process">
        </span></td>
    <?php } ?>
    <?php if ($Page->emp_id->Visible) { // emp_id ?>
        <td data-name="emp_id" class="<?= $Page->emp_id->footerCellClass() ?>"><span id="elf_process_action_material_payment_emp_id" class="process_action_material_payment_emp_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->rid->Visible) { // rid ?>
        <td data-name="rid" class="<?= $Page->rid->footerCellClass() ?>"><span id="elf_process_action_material_payment_rid" class="process_action_material_payment_rid">
        </span></td>
    <?php } ?>
    <?php if ($Page->quantity->Visible) { // quantity ?>
        <td data-name="quantity" class="<?= $Page->quantity->footerCellClass() ?>"><span id="elf_process_action_material_payment_quantity" class="process_action_material_payment_quantity">
        </span></td>
    <?php } ?>
    <?php if ($Page->process_from->Visible) { // process_from ?>
        <td data-name="process_from" class="<?= $Page->process_from->footerCellClass() ?>"><span id="elf_process_action_material_payment_process_from" class="process_action_material_payment_process_from">
        </span></td>
    <?php } ?>
    <?php if ($Page->process_to->Visible) { // process_to ?>
        <td data-name="process_to" class="<?= $Page->process_to->footerCellClass() ?>"><span id="elf_process_action_material_payment_process_to" class="process_action_material_payment_process_to">
        </span></td>
    <?php } ?>
    <?php if ($Page->process_method->Visible) { // process_method ?>
        <td data-name="process_method" class="<?= $Page->process_method->footerCellClass() ?>"><span id="elf_process_action_material_payment_process_method" class="process_action_material_payment_process_method">
        </span></td>
    <?php } ?>
    <?php if ($Page->ply->Visible) { // ply ?>
        <td data-name="ply" class="<?= $Page->ply->footerCellClass() ?>"><span id="elf_process_action_material_payment_ply" class="process_action_material_payment_ply">
        </span></td>
    <?php } ?>
    <?php if ($Page->rid_new->Visible) { // rid_new ?>
        <td data-name="rid_new" class="<?= $Page->rid_new->footerCellClass() ?>"><span id="elf_process_action_material_payment_rid_new" class="process_action_material_payment_rid_new">
        </span></td>
    <?php } ?>
    <?php if ($Page->process_->Visible) { // process_@ ?>
        <td data-name="process_" class="<?= $Page->process_->footerCellClass() ?>"><span id="elf_process_action_material_payment_process_" class="process_action_material_payment_process_">
        </span></td>
    <?php } ?>
    <?php if ($Page->amount->Visible) { // amount ?>
        <td data-name="amount" class="<?= $Page->amount->footerCellClass() ?>"><span id="elf_process_action_material_payment_amount" class="process_action_material_payment_amount">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->amount->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->incentive->Visible) { // incentive ?>
        <td data-name="incentive" class="<?= $Page->incentive->footerCellClass() ?>"><span id="elf_process_action_material_payment_incentive" class="process_action_material_payment_incentive">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->incentive->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->final_amount->Visible) { // final_amount ?>
        <td data-name="final_amount" class="<?= $Page->final_amount->footerCellClass() ?>"><span id="elf_process_action_material_payment_final_amount" class="process_action_material_payment_final_amount">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->final_amount->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->description->Visible) { // description ?>
        <td data-name="description" class="<?= $Page->description->footerCellClass() ?>"><span id="elf_process_action_material_payment_description" class="process_action_material_payment_description">
        </span></td>
    <?php } ?>
    <?php if ($Page->remarks->Visible) { // remarks ?>
        <td data-name="remarks" class="<?= $Page->remarks->footerCellClass() ?>"><span id="elf_process_action_material_payment_remarks" class="process_action_material_payment_remarks">
        </span></td>
    <?php } ?>
    <?php if ($Page->payment->Visible) { // payment ?>
        <td data-name="payment" class="<?= $Page->payment->footerCellClass() ?>"><span id="elf_process_action_material_payment_payment" class="process_action_material_payment_payment">
        </span></td>
    <?php } ?>
    <?php if ($Page->pp_id->Visible) { // pp_id ?>
        <td data-name="pp_id" class="<?= $Page->pp_id->footerCellClass() ?>"><span id="elf_process_action_material_payment_pp_id" class="process_action_material_payment_pp_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime" class="<?= $Page->datetime->footerCellClass() ?>"><span id="elf_process_action_material_payment_datetime" class="process_action_material_payment_datetime">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Page->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("process_action_material_payment");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
