<?php

namespace PHPMaker2024\fibre;

// Page object
$ProcessActionMaterialOldSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { process_action_material_old: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fprocess_action_material_oldsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fprocess_action_material_oldsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["site", [], fields.site.isInvalid],
            ["process", [], fields.process.isInvalid],
            ["poid", [], fields.poid.isInvalid],
            ["jc_no", [], fields.jc_no.isInvalid],
            ["emp_name", [], fields.emp_name.isInvalid],
            ["grp", [], fields.grp.isInvalid],
            ["s_grp", [], fields.s_grp.isInvalid],
            ["product", [], fields.product.isInvalid],
            ["rid", [], fields.rid.isInvalid],
            ["quantity", [ew.Validators.float], fields.quantity.isInvalid],
            ["packets", [ew.Validators.float], fields.packets.isInvalid],
            ["lot_no", [], fields.lot_no.isInvalid],
            ["packing", [ew.Validators.integer], fields.packing.isInvalid],
            ["godown", [ew.Validators.integer], fields.godown.isInvalid],
            ["sub_process", [], fields.sub_process.isInvalid],
            ["process_method", [], fields.process_method.isInvalid],
            ["ply", [ew.Validators.integer], fields.ply.isInvalid],
            ["rid_new", [], fields.rid_new.isInvalid],
            ["remark", [], fields.remark.isInvalid],
            ["payment", [], fields.payment.isInvalid],
            ["y_payment", [ew.Validators.between], false],
            ["dated", [ew.Validators.datetime(fields.dated.clientFormatPattern)], fields.dated.isInvalid],
            ["opeartor", [ew.Validators.integer], fields.opeartor.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["y_datetime", [ew.Validators.between], false],
            ["rid_new_lot_no", [], fields.rid_new_lot_no.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "site": <?= $Page->site->toClientList($Page) ?>,
            "process": <?= $Page->process->toClientList($Page) ?>,
            "jc_no": <?= $Page->jc_no->toClientList($Page) ?>,
            "emp_name": <?= $Page->emp_name->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "packing": <?= $Page->packing->toClientList($Page) ?>,
            "godown": <?= $Page->godown->toClientList($Page) ?>,
            "sub_process": <?= $Page->sub_process->toClientList($Page) ?>,
            "process_method": <?= $Page->process_method->toClientList($Page) ?>,
            "rid_new": <?= $Page->rid_new->toClientList($Page) ?>,
            "payment": <?= $Page->payment->toClientList($Page) ?>,
            "opeartor": <?= $Page->opeartor->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fprocess_action_material_oldsearch" id="fprocess_action_material_oldsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="process_action_material_old">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_old_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_old_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="process_action_material_old" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->site->Visible) { // site ?>
    <div id="r_site" class="row"<?= $Page->site->rowAttributes() ?>>
        <label for="x_site" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_old_site"><?= $Page->site->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_site" id="z_site" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->site->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_old_site" class="ew-search-field ew-search-field-single">
    <select
        id="x_site"
        name="x_site"
        class="form-select ew-select<?= $Page->site->isInvalidClass() ?>"
        <?php if (!$Page->site->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_material_oldsearch_x_site"
        <?php } ?>
        data-table="process_action_material_old"
        data-field="x_site"
        data-value-separator="<?= $Page->site->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->site->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->site->editAttributes() ?>>
        <?= $Page->site->selectOptionListHtml("x_site") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->site->getErrorMessage(false) ?></div>
<?= $Page->site->Lookup->getParamTag($Page, "p_x_site") ?>
<?php if (!$Page->site->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_material_oldsearch", function() {
    var options = { name: "x_site", selectId: "fprocess_action_material_oldsearch_x_site" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_material_oldsearch.lists.site?.lookupOptions.length) {
        options.data = { id: "x_site", form: "fprocess_action_material_oldsearch" };
    } else {
        options.ajax = { id: "x_site", form: "fprocess_action_material_oldsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_material_old.fields.site.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->process->Visible) { // process ?>
    <div id="r_process" class="row"<?= $Page->process->rowAttributes() ?>>
        <label for="x_process" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_old_process"><?= $Page->process->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_process" id="z_process" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->process->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_old_process" class="ew-search-field ew-search-field-single">
    <select
        id="x_process"
        name="x_process"
        class="form-select ew-select<?= $Page->process->isInvalidClass() ?>"
        <?php if (!$Page->process->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_material_oldsearch_x_process"
        <?php } ?>
        data-table="process_action_material_old"
        data-field="x_process"
        data-value-separator="<?= $Page->process->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->process->editAttributes() ?>>
        <?= $Page->process->selectOptionListHtml("x_process") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->process->getErrorMessage(false) ?></div>
<?= $Page->process->Lookup->getParamTag($Page, "p_x_process") ?>
<?php if (!$Page->process->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_material_oldsearch", function() {
    var options = { name: "x_process", selectId: "fprocess_action_material_oldsearch_x_process" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_material_oldsearch.lists.process?.lookupOptions.length) {
        options.data = { id: "x_process", form: "fprocess_action_material_oldsearch" };
    } else {
        options.ajax = { id: "x_process", form: "fprocess_action_material_oldsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_material_old.fields.process.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->poid->Visible) { // poid ?>
    <div id="r_poid" class="row"<?= $Page->poid->rowAttributes() ?>>
        <label for="x_poid" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_old_poid"><?= $Page->poid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_poid" id="z_poid" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->poid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_old_poid" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->poid->getInputTextType() ?>" name="x_poid" id="x_poid" data-table="process_action_material_old" data-field="x_poid" value="<?= $Page->poid->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->poid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->poid->formatPattern()) ?>"<?= $Page->poid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->poid->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->jc_no->Visible) { // jc_no ?>
    <div id="r_jc_no" class="row"<?= $Page->jc_no->rowAttributes() ?>>
        <label for="x_jc_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_old_jc_no"><?= $Page->jc_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_jc_no" id="z_jc_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->jc_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_old_jc_no" class="ew-search-field ew-search-field-single">
    <select
        id="x_jc_no"
        name="x_jc_no"
        class="form-select ew-select<?= $Page->jc_no->isInvalidClass() ?>"
        <?php if (!$Page->jc_no->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_material_oldsearch_x_jc_no"
        <?php } ?>
        data-table="process_action_material_old"
        data-field="x_jc_no"
        data-value-separator="<?= $Page->jc_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->jc_no->getPlaceHolder()) ?>"
        <?= $Page->jc_no->editAttributes() ?>>
        <?= $Page->jc_no->selectOptionListHtml("x_jc_no") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->jc_no->getErrorMessage(false) ?></div>
<?= $Page->jc_no->Lookup->getParamTag($Page, "p_x_jc_no") ?>
<?php if (!$Page->jc_no->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_material_oldsearch", function() {
    var options = { name: "x_jc_no", selectId: "fprocess_action_material_oldsearch_x_jc_no" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_material_oldsearch.lists.jc_no?.lookupOptions.length) {
        options.data = { id: "x_jc_no", form: "fprocess_action_material_oldsearch" };
    } else {
        options.ajax = { id: "x_jc_no", form: "fprocess_action_material_oldsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_material_old.fields.jc_no.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->emp_name->Visible) { // emp_name ?>
    <div id="r_emp_name" class="row"<?= $Page->emp_name->rowAttributes() ?>>
        <label for="x_emp_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_old_emp_name"><?= $Page->emp_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_emp_name" id="z_emp_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->emp_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_old_emp_name" class="ew-search-field ew-search-field-single">
    <select
        id="x_emp_name"
        name="x_emp_name"
        class="form-select ew-select<?= $Page->emp_name->isInvalidClass() ?>"
        <?php if (!$Page->emp_name->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_material_oldsearch_x_emp_name"
        <?php } ?>
        data-table="process_action_material_old"
        data-field="x_emp_name"
        data-value-separator="<?= $Page->emp_name->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->emp_name->getPlaceHolder()) ?>"
        <?= $Page->emp_name->editAttributes() ?>>
        <?= $Page->emp_name->selectOptionListHtml("x_emp_name") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->emp_name->getErrorMessage(false) ?></div>
<?= $Page->emp_name->Lookup->getParamTag($Page, "p_x_emp_name") ?>
<?php if (!$Page->emp_name->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_material_oldsearch", function() {
    var options = { name: "x_emp_name", selectId: "fprocess_action_material_oldsearch_x_emp_name" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_material_oldsearch.lists.emp_name?.lookupOptions.length) {
        options.data = { id: "x_emp_name", form: "fprocess_action_material_oldsearch" };
    } else {
        options.ajax = { id: "x_emp_name", form: "fprocess_action_material_oldsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_material_old.fields.emp_name.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp" class="row"<?= $Page->grp->rowAttributes() ?>>
        <label for="x_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_old_grp"><?= $Page->grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_old_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_material_oldsearch_x_grp"
        <?php } ?>
        data-table="process_action_material_old"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_material_oldsearch", function() {
    var options = { name: "x_grp", selectId: "fprocess_action_material_oldsearch_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_material_oldsearch.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fprocess_action_material_oldsearch" };
    } else {
        options.ajax = { id: "x_grp", form: "fprocess_action_material_oldsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_material_old.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp" class="row"<?= $Page->s_grp->rowAttributes() ?>>
        <label for="x_s_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_old_s_grp"><?= $Page->s_grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_s_grp" id="z_s_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->s_grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_old_s_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_material_oldsearch_x_s_grp"
        <?php } ?>
        data-table="process_action_material_old"
        data-field="x_s_grp"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage(false) ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_material_oldsearch", function() {
    var options = { name: "x_s_grp", selectId: "fprocess_action_material_oldsearch_x_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_material_oldsearch.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "fprocess_action_material_oldsearch" };
    } else {
        options.ajax = { id: "x_s_grp", form: "fprocess_action_material_oldsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_material_old.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product" class="row"<?= $Page->product->rowAttributes() ?>>
        <label for="x_product" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_old_product"><?= $Page->product->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product" id="z_product" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_old_product" class="ew-search-field ew-search-field-single">
    <select
        id="x_product"
        name="x_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_material_oldsearch_x_product"
        <?php } ?>
        data-table="process_action_material_old"
        data-field="x_product"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage(false) ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_material_oldsearch", function() {
    var options = { name: "x_product", selectId: "fprocess_action_material_oldsearch_x_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_material_oldsearch.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "fprocess_action_material_oldsearch" };
    } else {
        options.ajax = { id: "x_product", form: "fprocess_action_material_oldsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_material_old.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
    <div id="r_rid" class="row"<?= $Page->rid->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_old_rid"><?= $Page->rid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_rid" id="z_rid" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_old_rid" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->rid->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_rid" class="ew-auto-suggest">
    <input type="<?= $Page->rid->getInputTextType() ?>" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?= RemoveHtml($Page->rid->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rid->formatPattern()) ?>"<?= $Page->rid->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="process_action_material_old" data-field="x_rid" data-input="sv_x_rid" data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?= HtmlEncode($Page->rid->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->rid->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fprocess_action_material_oldsearch", function() {
    fprocess_action_material_oldsearch.createAutoSuggest(Object.assign({"id":"x_rid","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->rid->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.process_action_material_old.fields.rid.autoSuggestOptions));
});
</script>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity" class="row"<?= $Page->quantity->rowAttributes() ?>>
        <label for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_old_quantity"><?= $Page->quantity->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_quantity" id="z_quantity" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->quantity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_old_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->quantity->getInputTextType() ?>" name="x_quantity" id="x_quantity" data-table="process_action_material_old" data-field="x_quantity" value="<?= $Page->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity->formatPattern()) ?>"<?= $Page->quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->quantity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packets->Visible) { // packets ?>
    <div id="r_packets" class="row"<?= $Page->packets->rowAttributes() ?>>
        <label for="x_packets" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_old_packets"><?= $Page->packets->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packets" id="z_packets" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packets->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_old_packets" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->packets->getInputTextType() ?>" name="x_packets" id="x_packets" data-table="process_action_material_old" data-field="x_packets" value="<?= $Page->packets->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->packets->formatPattern()) ?>"<?= $Page->packets->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->packets->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->lot_no->Visible) { // lot_no ?>
    <div id="r_lot_no" class="row"<?= $Page->lot_no->rowAttributes() ?>>
        <label for="x_lot_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_old_lot_no"><?= $Page->lot_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_lot_no" id="z_lot_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->lot_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_old_lot_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->lot_no->getInputTextType() ?>" name="x_lot_no" id="x_lot_no" data-table="process_action_material_old" data-field="x_lot_no" value="<?= $Page->lot_no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->lot_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->lot_no->formatPattern()) ?>"<?= $Page->lot_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->lot_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packing->Visible) { // packing ?>
    <div id="r_packing" class="row"<?= $Page->packing->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_old_packing"><?= $Page->packing->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packing" id="z_packing" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packing->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_old_packing" class="ew-search-field ew-search-field-single">
    <select
        id="x_packing"
        name="x_packing"
        class="form-control ew-select<?= $Page->packing->isInvalidClass() ?>"
        data-select2-id="fprocess_action_material_oldsearch_x_packing"
        data-table="process_action_material_old"
        data-field="x_packing"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->packing->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->packing->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing->getPlaceHolder()) ?>"
        <?= $Page->packing->editAttributes() ?>>
        <?= $Page->packing->selectOptionListHtml("x_packing") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->packing->getErrorMessage(false) ?></div>
<?= $Page->packing->Lookup->getParamTag($Page, "p_x_packing") ?>
<script>
loadjs.ready("fprocess_action_material_oldsearch", function() {
    var options = { name: "x_packing", selectId: "fprocess_action_material_oldsearch_x_packing" };
    if (fprocess_action_material_oldsearch.lists.packing?.lookupOptions.length) {
        options.data = { id: "x_packing", form: "fprocess_action_material_oldsearch" };
    } else {
        options.ajax = { id: "x_packing", form: "fprocess_action_material_oldsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.process_action_material_old.fields.packing.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->godown->Visible) { // godown ?>
    <div id="r_godown" class="row"<?= $Page->godown->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_old_godown"><?= $Page->godown->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_godown" id="z_godown" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->godown->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_old_godown" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->godown->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_godown" class="ew-auto-suggest">
    <input type="<?= $Page->godown->getInputTextType() ?>" class="form-control" name="sv_x_godown" id="sv_x_godown" value="<?= RemoveHtml($Page->godown->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->godown->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->godown->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->godown->formatPattern()) ?>"<?= $Page->godown->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="process_action_material_old" data-field="x_godown" data-input="sv_x_godown" data-value-separator="<?= $Page->godown->displayValueSeparatorAttribute() ?>" name="x_godown" id="x_godown" value="<?= HtmlEncode($Page->godown->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->godown->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fprocess_action_material_oldsearch", function() {
    fprocess_action_material_oldsearch.createAutoSuggest(Object.assign({"id":"x_godown","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->godown->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.process_action_material_old.fields.godown.autoSuggestOptions));
});
</script>
<?= $Page->godown->Lookup->getParamTag($Page, "p_x_godown") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sub_process->Visible) { // sub_process ?>
    <div id="r_sub_process" class="row"<?= $Page->sub_process->rowAttributes() ?>>
        <label for="x_sub_process" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_old_sub_process"><?= $Page->sub_process->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_sub_process" id="z_sub_process" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sub_process->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_old_sub_process" class="ew-search-field ew-search-field-single">
    <select
        id="x_sub_process"
        name="x_sub_process"
        class="form-select ew-select<?= $Page->sub_process->isInvalidClass() ?>"
        <?php if (!$Page->sub_process->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_material_oldsearch_x_sub_process"
        <?php } ?>
        data-table="process_action_material_old"
        data-field="x_sub_process"
        data-value-separator="<?= $Page->sub_process->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->sub_process->getPlaceHolder()) ?>"
        <?= $Page->sub_process->editAttributes() ?>>
        <?= $Page->sub_process->selectOptionListHtml("x_sub_process") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->sub_process->getErrorMessage(false) ?></div>
<?= $Page->sub_process->Lookup->getParamTag($Page, "p_x_sub_process") ?>
<?php if (!$Page->sub_process->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_material_oldsearch", function() {
    var options = { name: "x_sub_process", selectId: "fprocess_action_material_oldsearch_x_sub_process" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_material_oldsearch.lists.sub_process?.lookupOptions.length) {
        options.data = { id: "x_sub_process", form: "fprocess_action_material_oldsearch" };
    } else {
        options.ajax = { id: "x_sub_process", form: "fprocess_action_material_oldsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_material_old.fields.sub_process.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->process_method->Visible) { // process_method ?>
    <div id="r_process_method" class="row"<?= $Page->process_method->rowAttributes() ?>>
        <label for="x_process_method" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_old_process_method"><?= $Page->process_method->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_process_method" id="z_process_method" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->process_method->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_old_process_method" class="ew-search-field ew-search-field-single">
    <select
        id="x_process_method"
        name="x_process_method"
        class="form-select ew-select<?= $Page->process_method->isInvalidClass() ?>"
        <?php if (!$Page->process_method->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_material_oldsearch_x_process_method"
        <?php } ?>
        data-table="process_action_material_old"
        data-field="x_process_method"
        data-value-separator="<?= $Page->process_method->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process_method->getPlaceHolder()) ?>"
        <?= $Page->process_method->editAttributes() ?>>
        <?= $Page->process_method->selectOptionListHtml("x_process_method") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->process_method->getErrorMessage(false) ?></div>
<?php if (!$Page->process_method->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_material_oldsearch", function() {
    var options = { name: "x_process_method", selectId: "fprocess_action_material_oldsearch_x_process_method" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_material_oldsearch.lists.process_method?.lookupOptions.length) {
        options.data = { id: "x_process_method", form: "fprocess_action_material_oldsearch" };
    } else {
        options.ajax = { id: "x_process_method", form: "fprocess_action_material_oldsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_material_old.fields.process_method.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ply->Visible) { // ply ?>
    <div id="r_ply" class="row"<?= $Page->ply->rowAttributes() ?>>
        <label for="x_ply" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_old_ply"><?= $Page->ply->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_ply" id="z_ply" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ply->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_old_ply" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ply->getInputTextType() ?>" name="x_ply" id="x_ply" data-table="process_action_material_old" data-field="x_ply" value="<?= $Page->ply->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->ply->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ply->formatPattern()) ?>"<?= $Page->ply->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ply->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->rid_new->Visible) { // rid_new ?>
    <div id="r_rid_new" class="row"<?= $Page->rid_new->rowAttributes() ?>>
        <label for="x_rid_new" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_old_rid_new"><?= $Page->rid_new->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_rid_new" id="z_rid_new" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rid_new->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_old_rid_new" class="ew-search-field ew-search-field-single">
    <select
        id="x_rid_new"
        name="x_rid_new"
        class="form-select ew-select<?= $Page->rid_new->isInvalidClass() ?>"
        <?php if (!$Page->rid_new->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_material_oldsearch_x_rid_new"
        <?php } ?>
        data-table="process_action_material_old"
        data-field="x_rid_new"
        data-value-separator="<?= $Page->rid_new->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid_new->getPlaceHolder()) ?>"
        <?= $Page->rid_new->editAttributes() ?>>
        <?= $Page->rid_new->selectOptionListHtml("x_rid_new") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->rid_new->getErrorMessage(false) ?></div>
<?= $Page->rid_new->Lookup->getParamTag($Page, "p_x_rid_new") ?>
<?php if (!$Page->rid_new->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_material_oldsearch", function() {
    var options = { name: "x_rid_new", selectId: "fprocess_action_material_oldsearch_x_rid_new" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_material_oldsearch.lists.rid_new?.lookupOptions.length) {
        options.data = { id: "x_rid_new", form: "fprocess_action_material_oldsearch" };
    } else {
        options.ajax = { id: "x_rid_new", form: "fprocess_action_material_oldsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_material_old.fields.rid_new.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remark->Visible) { // remark ?>
    <div id="r_remark" class="row"<?= $Page->remark->rowAttributes() ?>>
        <label for="x_remark" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_old_remark"><?= $Page->remark->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remark" id="z_remark" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remark->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_old_remark" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remark->getInputTextType() ?>" name="x_remark" id="x_remark" data-table="process_action_material_old" data-field="x_remark" value="<?= $Page->remark->EditValue ?>" size="30" maxlength="225" placeholder="<?= HtmlEncode($Page->remark->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remark->formatPattern()) ?>"<?= $Page->remark->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remark->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->payment->Visible) { // payment ?>
    <div id="r_payment" class="row"<?= $Page->payment->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_old_payment"><?= $Page->payment->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->payment->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_payment" id="z_payment" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->payment->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->payment->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_process_action_material_old_payment" class="ew-search-field">
    <select
        id="x_payment[]"
        name="x_payment[]"
        class="form-control ew-select<?= $Page->payment->isInvalidClass() ?>"
        data-select2-id="fprocess_action_material_oldsearch_x_payment[]"
        data-table="process_action_material_old"
        data-field="x_payment"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->payment->caption())) ?>"
        data-modal-lookup="true"
        multiple
        size="1"
        data-value-separator="<?= $Page->payment->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->payment->getPlaceHolder()) ?>"
        <?= $Page->payment->editAttributes() ?>>
        <?= $Page->payment->selectOptionListHtml("x_payment[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->payment->getErrorMessage(false) ?></div>
<?= $Page->payment->Lookup->getParamTag($Page, "p_x_payment") ?>
<script>
loadjs.ready("fprocess_action_material_oldsearch", function() {
    var options = { name: "x_payment[]", selectId: "fprocess_action_material_oldsearch_x_payment[]" };
    options.multiple = true;
    if (fprocess_action_material_oldsearch.lists.payment?.lookupOptions.length) {
        options.data = { id: "x_payment[]", form: "fprocess_action_material_oldsearch" };
    } else {
        options.ajax = { id: "x_payment[]", form: "fprocess_action_material_oldsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.process_action_material_old.fields.payment.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_process_action_material_old_payment" class="ew-search-field2 d-none">
    <select
        id="y_payment[]"
        name="y_payment[]"
        class="form-control ew-select<?= $Page->payment->isInvalidClass() ?>"
        data-select2-id="fprocess_action_material_oldsearch_y_payment[]"
        data-table="process_action_material_old"
        data-field="x_payment"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->payment->caption())) ?>"
        data-modal-lookup="true"
        multiple
        size="1"
        data-value-separator="<?= $Page->payment->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->payment->getPlaceHolder()) ?>"
        <?= $Page->payment->editAttributes() ?>>
        <?= $Page->payment->selectOptionListHtml("y_payment[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->payment->getErrorMessage(false) ?></div>
<?= $Page->payment->Lookup->getParamTag($Page, "p_y_payment") ?>
<script>
loadjs.ready("fprocess_action_material_oldsearch", function() {
    var options = { name: "y_payment[]", selectId: "fprocess_action_material_oldsearch_y_payment[]" };
    options.multiple = true;
    if (fprocess_action_material_oldsearch.lists.payment?.lookupOptions.length) {
        options.data = { id: "y_payment[]", form: "fprocess_action_material_oldsearch" };
    } else {
        options.ajax = { id: "y_payment[]", form: "fprocess_action_material_oldsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.process_action_material_old.fields.payment.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
    <div id="r_dated" class="row"<?= $Page->dated->rowAttributes() ?>>
        <label for="x_dated" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_old_dated"><?= $Page->dated->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_dated" id="z_dated" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->dated->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_old_dated" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->dated->getInputTextType() ?>" name="x_dated" id="x_dated" data-table="process_action_material_old" data-field="x_dated" value="<?= $Page->dated->EditValue ?>" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage(false) ?></div>
<?php if (!$Page->dated->ReadOnly && !$Page->dated->Disabled && !isset($Page->dated->EditAttrs["readonly"]) && !isset($Page->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprocess_action_material_oldsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprocess_action_material_oldsearch", "x_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->opeartor->Visible) { // opeartor ?>
    <div id="r_opeartor" class="row"<?= $Page->opeartor->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_old_opeartor"><?= $Page->opeartor->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_opeartor" id="z_opeartor" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->opeartor->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_old_opeartor" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->opeartor->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_opeartor" class="ew-auto-suggest">
    <input type="<?= $Page->opeartor->getInputTextType() ?>" class="form-control" name="sv_x_opeartor" id="sv_x_opeartor" value="<?= RemoveHtml($Page->opeartor->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->opeartor->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->opeartor->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->opeartor->formatPattern()) ?>"<?= $Page->opeartor->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="process_action_material_old" data-field="x_opeartor" data-input="sv_x_opeartor" data-value-separator="<?= $Page->opeartor->displayValueSeparatorAttribute() ?>" name="x_opeartor" id="x_opeartor" value="<?= HtmlEncode($Page->opeartor->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->opeartor->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fprocess_action_material_oldsearch", function() {
    fprocess_action_material_oldsearch.createAutoSuggest(Object.assign({"id":"x_opeartor","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->opeartor->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.process_action_material_old.fields.opeartor.autoSuggestOptions));
});
</script>
<?= $Page->opeartor->Lookup->getParamTag($Page, "p_x_opeartor") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_old_datetime"><?= $Page->datetime->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_datetime" id="z_datetime" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->datetime->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->datetime->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_process_action_material_old_datetime" class="ew-search-field">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="process_action_material_old" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprocess_action_material_oldsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprocess_action_material_oldsearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_process_action_material_old_datetime" class="ew-search-field2 d-none">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="y_datetime" id="y_datetime" data-table="process_action_material_old" data-field="x_datetime" value="<?= $Page->datetime->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprocess_action_material_oldsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprocess_action_material_oldsearch", "y_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->rid_new_lot_no->Visible) { // rid_new_lot_no ?>
    <div id="r_rid_new_lot_no" class="row"<?= $Page->rid_new_lot_no->rowAttributes() ?>>
        <label for="x_rid_new_lot_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_process_action_material_old_rid_new_lot_no"><?= $Page->rid_new_lot_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_rid_new_lot_no" id="z_rid_new_lot_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rid_new_lot_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_process_action_material_old_rid_new_lot_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->rid_new_lot_no->getInputTextType() ?>" name="x_rid_new_lot_no" id="x_rid_new_lot_no" data-table="process_action_material_old" data-field="x_rid_new_lot_no" value="<?= $Page->rid_new_lot_no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->rid_new_lot_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rid_new_lot_no->formatPattern()) ?>"<?= $Page->rid_new_lot_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->rid_new_lot_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fprocess_action_material_oldsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fprocess_action_material_oldsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fprocess_action_material_oldsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("process_action_material_old");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
