<?php

namespace PHPMaker2024\fibre;

// Page object
$ProcessActionMaterialAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { process_action_material: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fprocess_action_materialadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fprocess_action_materialadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["site", [fields.site.visible && fields.site.required ? ew.Validators.required(fields.site.caption) : null], fields.site.isInvalid],
            ["process", [fields.process.visible && fields.process.required ? ew.Validators.required(fields.process.caption) : null], fields.process.isInvalid],
            ["sub_process", [fields.sub_process.visible && fields.sub_process.required ? ew.Validators.required(fields.sub_process.caption) : null], fields.sub_process.isInvalid],
            ["emp_name", [fields.emp_name.visible && fields.emp_name.required ? ew.Validators.required(fields.emp_name.caption) : null], fields.emp_name.isInvalid],
            ["jc_no", [fields.jc_no.visible && fields.jc_no.required ? ew.Validators.required(fields.jc_no.caption) : null], fields.jc_no.isInvalid],
            ["grp", [fields.grp.visible && fields.grp.required ? ew.Validators.required(fields.grp.caption) : null], fields.grp.isInvalid],
            ["s_grp", [fields.s_grp.visible && fields.s_grp.required ? ew.Validators.required(fields.s_grp.caption) : null], fields.s_grp.isInvalid],
            ["product", [fields.product.visible && fields.product.required ? ew.Validators.required(fields.product.caption) : null], fields.product.isInvalid],
            ["rid_1", [fields.rid_1.visible && fields.rid_1.required ? ew.Validators.required(fields.rid_1.caption) : null], fields.rid_1.isInvalid],
            ["packing", [fields.packing.visible && fields.packing.required ? ew.Validators.required(fields.packing.caption) : null], fields.packing.isInvalid],
            ["rid_2", [fields.rid_2.visible && fields.rid_2.required ? ew.Validators.required(fields.rid_2.caption) : null], fields.rid_2.isInvalid],
            ["rid", [fields.rid.visible && fields.rid.required ? ew.Validators.required(fields.rid.caption) : null], fields.rid.isInvalid],
            ["godown", [fields.godown.visible && fields.godown.required ? ew.Validators.required(fields.godown.caption) : null, ew.Validators.integer], fields.godown.isInvalid],
            ["avg_quantity", [fields.avg_quantity.visible && fields.avg_quantity.required ? ew.Validators.required(fields.avg_quantity.caption) : null, ew.Validators.float], fields.avg_quantity.isInvalid],
            ["lot_no", [fields.lot_no.visible && fields.lot_no.required ? ew.Validators.required(fields.lot_no.caption) : null], fields.lot_no.isInvalid],
            ["avialable_qty", [fields.avialable_qty.visible && fields.avialable_qty.required ? ew.Validators.required(fields.avialable_qty.caption) : null, ew.Validators.float], fields.avialable_qty.isInvalid],
            ["ply", [fields.ply.visible && fields.ply.required ? ew.Validators.required(fields.ply.caption) : null, ew.Validators.integer], fields.ply.isInvalid],
            ["rid_new", [fields.rid_new.visible && fields.rid_new.required ? ew.Validators.required(fields.rid_new.caption) : null], fields.rid_new.isInvalid],
            ["rid_new_lot_no", [fields.rid_new_lot_no.visible && fields.rid_new_lot_no.required ? ew.Validators.required(fields.rid_new_lot_no.caption) : null], fields.rid_new_lot_no.isInvalid],
            ["poid_new", [fields.poid_new.visible && fields.poid_new.required ? ew.Validators.required(fields.poid_new.caption) : null], fields.poid_new.isInvalid],
            ["poid_1", [fields.poid_1.visible && fields.poid_1.required ? ew.Validators.required(fields.poid_1.caption) : null], fields.poid_1.isInvalid],
            ["poid", [fields.poid.visible && fields.poid.required ? ew.Validators.required(fields.poid.caption) : null], fields.poid.isInvalid],
            ["quantity", [fields.quantity.visible && fields.quantity.required ? ew.Validators.required(fields.quantity.caption) : null, ew.Validators.float], fields.quantity.isInvalid],
            ["packets", [fields.packets.visible && fields.packets.required ? ew.Validators.required(fields.packets.caption) : null, ew.Validators.float], fields.packets.isInvalid],
            ["process_method", [fields.process_method.visible && fields.process_method.required ? ew.Validators.required(fields.process_method.caption) : null], fields.process_method.isInvalid],
            ["remark", [fields.remark.visible && fields.remark.required ? ew.Validators.required(fields.remark.caption) : null], fields.remark.isInvalid],
            ["dated", [fields.dated.visible && fields.dated.required ? ew.Validators.required(fields.dated.caption) : null, ew.Validators.datetime(fields.dated.clientFormatPattern)], fields.dated.isInvalid],
            ["opeartor", [fields.opeartor.visible && fields.opeartor.required ? ew.Validators.required(fields.opeartor.caption) : null], fields.opeartor.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "site": <?= $Page->site->toClientList($Page) ?>,
            "process": <?= $Page->process->toClientList($Page) ?>,
            "sub_process": <?= $Page->sub_process->toClientList($Page) ?>,
            "emp_name": <?= $Page->emp_name->toClientList($Page) ?>,
            "jc_no": <?= $Page->jc_no->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "rid_1": <?= $Page->rid_1->toClientList($Page) ?>,
            "packing": <?= $Page->packing->toClientList($Page) ?>,
            "rid_2": <?= $Page->rid_2->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "godown": <?= $Page->godown->toClientList($Page) ?>,
            "rid_new": <?= $Page->rid_new->toClientList($Page) ?>,
            "poid_1": <?= $Page->poid_1->toClientList($Page) ?>,
            "process_method": <?= $Page->process_method->toClientList($Page) ?>,
            "opeartor": <?= $Page->opeartor->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fprocess_action_materialadd" id="fprocess_action_materialadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="process_action_material">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->site->Visible) { // site ?>
    <div id="r_site"<?= $Page->site->rowAttributes() ?>>
        <label id="elh_process_action_material_site" for="x_site" class="<?= $Page->LeftColumnClass ?>"><?= $Page->site->caption() ?><?= $Page->site->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->site->cellAttributes() ?>>
<span id="el_process_action_material_site">
    <select
        id="x_site"
        name="x_site"
        class="form-select ew-select<?= $Page->site->isInvalidClass() ?>"
        <?php if (!$Page->site->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_materialadd_x_site"
        <?php } ?>
        data-table="process_action_material"
        data-field="x_site"
        data-value-separator="<?= $Page->site->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->site->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->site->editAttributes() ?>>
        <?= $Page->site->selectOptionListHtml("x_site") ?>
    </select>
    <?= $Page->site->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->site->getErrorMessage() ?></div>
<?= $Page->site->Lookup->getParamTag($Page, "p_x_site") ?>
<?php if (!$Page->site->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_materialadd", function() {
    var options = { name: "x_site", selectId: "fprocess_action_materialadd_x_site" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_materialadd.lists.site?.lookupOptions.length) {
        options.data = { id: "x_site", form: "fprocess_action_materialadd" };
    } else {
        options.ajax = { id: "x_site", form: "fprocess_action_materialadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_material.fields.site.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->process->Visible) { // process ?>
    <div id="r_process"<?= $Page->process->rowAttributes() ?>>
        <label id="elh_process_action_material_process" for="x_process" class="<?= $Page->LeftColumnClass ?>"><?= $Page->process->caption() ?><?= $Page->process->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->process->cellAttributes() ?>>
<span id="el_process_action_material_process">
    <select
        id="x_process"
        name="x_process"
        class="form-select ew-select<?= $Page->process->isInvalidClass() ?>"
        <?php if (!$Page->process->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_materialadd_x_process"
        <?php } ?>
        data-table="process_action_material"
        data-field="x_process"
        data-value-separator="<?= $Page->process->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->process->editAttributes() ?>>
        <?= $Page->process->selectOptionListHtml("x_process") ?>
    </select>
    <?= $Page->process->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->process->getErrorMessage() ?></div>
<?= $Page->process->Lookup->getParamTag($Page, "p_x_process") ?>
<?php if (!$Page->process->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_materialadd", function() {
    var options = { name: "x_process", selectId: "fprocess_action_materialadd_x_process" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_materialadd.lists.process?.lookupOptions.length) {
        options.data = { id: "x_process", form: "fprocess_action_materialadd" };
    } else {
        options.ajax = { id: "x_process", form: "fprocess_action_materialadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_material.fields.process.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->sub_process->Visible) { // sub_process ?>
    <div id="r_sub_process"<?= $Page->sub_process->rowAttributes() ?>>
        <label id="elh_process_action_material_sub_process" for="x_sub_process" class="<?= $Page->LeftColumnClass ?>"><?= $Page->sub_process->caption() ?><?= $Page->sub_process->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->sub_process->cellAttributes() ?>>
<span id="el_process_action_material_sub_process">
    <select
        id="x_sub_process"
        name="x_sub_process"
        class="form-select ew-select<?= $Page->sub_process->isInvalidClass() ?>"
        <?php if (!$Page->sub_process->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_materialadd_x_sub_process"
        <?php } ?>
        data-table="process_action_material"
        data-field="x_sub_process"
        data-value-separator="<?= $Page->sub_process->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->sub_process->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->sub_process->editAttributes() ?>>
        <?= $Page->sub_process->selectOptionListHtml("x_sub_process") ?>
    </select>
    <?= $Page->sub_process->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->sub_process->getErrorMessage() ?></div>
<?= $Page->sub_process->Lookup->getParamTag($Page, "p_x_sub_process") ?>
<?php if (!$Page->sub_process->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_materialadd", function() {
    var options = { name: "x_sub_process", selectId: "fprocess_action_materialadd_x_sub_process" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_materialadd.lists.sub_process?.lookupOptions.length) {
        options.data = { id: "x_sub_process", form: "fprocess_action_materialadd" };
    } else {
        options.ajax = { id: "x_sub_process", form: "fprocess_action_materialadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_material.fields.sub_process.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->emp_name->Visible) { // emp_name ?>
    <div id="r_emp_name"<?= $Page->emp_name->rowAttributes() ?>>
        <label id="elh_process_action_material_emp_name" for="x_emp_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->emp_name->caption() ?><?= $Page->emp_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->emp_name->cellAttributes() ?>>
<span id="el_process_action_material_emp_name">
    <select
        id="x_emp_name"
        name="x_emp_name"
        class="form-select ew-select<?= $Page->emp_name->isInvalidClass() ?>"
        <?php if (!$Page->emp_name->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_materialadd_x_emp_name"
        <?php } ?>
        data-table="process_action_material"
        data-field="x_emp_name"
        data-value-separator="<?= $Page->emp_name->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->emp_name->getPlaceHolder()) ?>"
        <?= $Page->emp_name->editAttributes() ?>>
        <?= $Page->emp_name->selectOptionListHtml("x_emp_name") ?>
    </select>
    <?= $Page->emp_name->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->emp_name->getErrorMessage() ?></div>
<?= $Page->emp_name->Lookup->getParamTag($Page, "p_x_emp_name") ?>
<?php if (!$Page->emp_name->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_materialadd", function() {
    var options = { name: "x_emp_name", selectId: "fprocess_action_materialadd_x_emp_name" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_materialadd.lists.emp_name?.lookupOptions.length) {
        options.data = { id: "x_emp_name", form: "fprocess_action_materialadd" };
    } else {
        options.ajax = { id: "x_emp_name", form: "fprocess_action_materialadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_material.fields.emp_name.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->jc_no->Visible) { // jc_no ?>
    <div id="r_jc_no"<?= $Page->jc_no->rowAttributes() ?>>
        <label id="elh_process_action_material_jc_no" for="x_jc_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->jc_no->caption() ?><?= $Page->jc_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->jc_no->cellAttributes() ?>>
<span id="el_process_action_material_jc_no">
    <select
        id="x_jc_no"
        name="x_jc_no"
        class="form-select ew-select<?= $Page->jc_no->isInvalidClass() ?>"
        <?php if (!$Page->jc_no->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_materialadd_x_jc_no"
        <?php } ?>
        data-table="process_action_material"
        data-field="x_jc_no"
        data-value-separator="<?= $Page->jc_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->jc_no->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Page->jc_no->editAttributes() ?>>
        <?= $Page->jc_no->selectOptionListHtml("x_jc_no") ?>
    </select>
    <?= $Page->jc_no->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->jc_no->getErrorMessage() ?></div>
<?= $Page->jc_no->Lookup->getParamTag($Page, "p_x_jc_no") ?>
<?php if (!$Page->jc_no->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_materialadd", function() {
    var options = { name: "x_jc_no", selectId: "fprocess_action_materialadd_x_jc_no" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_materialadd.lists.jc_no?.lookupOptions.length) {
        options.data = { id: "x_jc_no", form: "fprocess_action_materialadd" };
    } else {
        options.ajax = { id: "x_jc_no", form: "fprocess_action_materialadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_material.fields.jc_no.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp"<?= $Page->grp->rowAttributes() ?>>
        <label id="elh_process_action_material_grp" for="x_grp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->grp->caption() ?><?= $Page->grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->grp->cellAttributes() ?>>
<span id="el_process_action_material_grp">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_materialadd_x_grp"
        <?php } ?>
        data-table="process_action_material"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <?= $Page->grp->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage() ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_materialadd", function() {
    var options = { name: "x_grp", selectId: "fprocess_action_materialadd_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_materialadd.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fprocess_action_materialadd" };
    } else {
        options.ajax = { id: "x_grp", form: "fprocess_action_materialadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_material.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp"<?= $Page->s_grp->rowAttributes() ?>>
        <label id="elh_process_action_material_s_grp" for="x_s_grp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->s_grp->caption() ?><?= $Page->s_grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->s_grp->cellAttributes() ?>>
<span id="el_process_action_material_s_grp">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-control ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        data-select2-id="fprocess_action_materialadd_x_s_grp"
        data-table="process_action_material"
        data-field="x_s_grp"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->s_grp->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <?= $Page->s_grp->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage() ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<script>
loadjs.ready("fprocess_action_materialadd", function() {
    var options = { name: "x_s_grp", selectId: "fprocess_action_materialadd_x_s_grp" };
    if (fprocess_action_materialadd.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "fprocess_action_materialadd" };
    } else {
        options.ajax = { id: "x_s_grp", form: "fprocess_action_materialadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.process_action_material.fields.s_grp.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product"<?= $Page->product->rowAttributes() ?>>
        <label id="elh_process_action_material_product" for="x_product" class="<?= $Page->LeftColumnClass ?>"><?= $Page->product->caption() ?><?= $Page->product->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->product->cellAttributes() ?>>
<span id="el_process_action_material_product">
    <select
        id="x_product"
        name="x_product"
        class="form-control ew-select<?= $Page->product->isInvalidClass() ?>"
        data-select2-id="fprocess_action_materialadd_x_product"
        data-table="process_action_material"
        data-field="x_product"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->product->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <?= $Page->product->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage() ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<script>
loadjs.ready("fprocess_action_materialadd", function() {
    var options = { name: "x_product", selectId: "fprocess_action_materialadd_x_product" };
    if (fprocess_action_materialadd.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "fprocess_action_materialadd" };
    } else {
        options.ajax = { id: "x_product", form: "fprocess_action_materialadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.process_action_material.fields.product.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->rid_1->Visible) { // rid_1 ?>
    <div id="r_rid_1"<?= $Page->rid_1->rowAttributes() ?>>
        <label id="elh_process_action_material_rid_1" for="x_rid_1" class="<?= $Page->LeftColumnClass ?>"><?= $Page->rid_1->caption() ?><?= $Page->rid_1->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->rid_1->cellAttributes() ?>>
<span id="el_process_action_material_rid_1">
    <select
        id="x_rid_1"
        name="x_rid_1"
        class="form-control ew-select<?= $Page->rid_1->isInvalidClass() ?>"
        data-select2-id="fprocess_action_materialadd_x_rid_1"
        data-table="process_action_material"
        data-field="x_rid_1"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->rid_1->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->rid_1->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid_1->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Page->rid_1->editAttributes() ?>>
        <?= $Page->rid_1->selectOptionListHtml("x_rid_1") ?>
    </select>
    <?= $Page->rid_1->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->rid_1->getErrorMessage() ?></div>
<?= $Page->rid_1->Lookup->getParamTag($Page, "p_x_rid_1") ?>
<script>
loadjs.ready("fprocess_action_materialadd", function() {
    var options = { name: "x_rid_1", selectId: "fprocess_action_materialadd_x_rid_1" };
    if (fprocess_action_materialadd.lists.rid_1?.lookupOptions.length) {
        options.data = { id: "x_rid_1", form: "fprocess_action_materialadd" };
    } else {
        options.ajax = { id: "x_rid_1", form: "fprocess_action_materialadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.process_action_material.fields.rid_1.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->packing->Visible) { // packing ?>
    <div id="r_packing"<?= $Page->packing->rowAttributes() ?>>
        <label id="elh_process_action_material_packing" for="x_packing" class="<?= $Page->LeftColumnClass ?>"><?= $Page->packing->caption() ?><?= $Page->packing->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->packing->cellAttributes() ?>>
<span id="el_process_action_material_packing">
    <select
        id="x_packing"
        name="x_packing"
        class="form-select ew-select<?= $Page->packing->isInvalidClass() ?>"
        <?php if (!$Page->packing->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_materialadd_x_packing"
        <?php } ?>
        data-table="process_action_material"
        data-field="x_packing"
        data-value-separator="<?= $Page->packing->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->packing->editAttributes() ?>>
        <?= $Page->packing->selectOptionListHtml("x_packing") ?>
    </select>
    <?= $Page->packing->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->packing->getErrorMessage() ?></div>
<?= $Page->packing->Lookup->getParamTag($Page, "p_x_packing") ?>
<?php if (!$Page->packing->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_materialadd", function() {
    var options = { name: "x_packing", selectId: "fprocess_action_materialadd_x_packing" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_materialadd.lists.packing?.lookupOptions.length) {
        options.data = { id: "x_packing", form: "fprocess_action_materialadd" };
    } else {
        options.ajax = { id: "x_packing", form: "fprocess_action_materialadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_material.fields.packing.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->rid_2->Visible) { // rid_2 ?>
    <div id="r_rid_2"<?= $Page->rid_2->rowAttributes() ?>>
        <label id="elh_process_action_material_rid_2" for="x_rid_2" class="<?= $Page->LeftColumnClass ?>"><?= $Page->rid_2->caption() ?><?= $Page->rid_2->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->rid_2->cellAttributes() ?>>
<span id="el_process_action_material_rid_2">
    <select
        id="x_rid_2"
        name="x_rid_2"
        class="form-control ew-select<?= $Page->rid_2->isInvalidClass() ?>"
        data-select2-id="fprocess_action_materialadd_x_rid_2"
        data-table="process_action_material"
        data-field="x_rid_2"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->rid_2->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->rid_2->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid_2->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Page->rid_2->editAttributes() ?>>
        <?= $Page->rid_2->selectOptionListHtml("x_rid_2") ?>
    </select>
    <?= $Page->rid_2->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->rid_2->getErrorMessage() ?></div>
<?= $Page->rid_2->Lookup->getParamTag($Page, "p_x_rid_2") ?>
<script>
loadjs.ready("fprocess_action_materialadd", function() {
    var options = { name: "x_rid_2", selectId: "fprocess_action_materialadd_x_rid_2" };
    if (fprocess_action_materialadd.lists.rid_2?.lookupOptions.length) {
        options.data = { id: "x_rid_2", form: "fprocess_action_materialadd" };
    } else {
        options.ajax = { id: "x_rid_2", form: "fprocess_action_materialadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.process_action_material.fields.rid_2.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
    <div id="r_rid"<?= $Page->rid->rowAttributes() ?>>
        <label id="elh_process_action_material_rid" class="<?= $Page->LeftColumnClass ?>"><?= $Page->rid->caption() ?><?= $Page->rid->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->rid->cellAttributes() ?>>
<span id="el_process_action_material_rid">
<?php
if (IsRTL()) {
    $Page->rid->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_rid" class="ew-auto-suggest">
    <input type="<?= $Page->rid->getInputTextType() ?>" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?= RemoveHtml($Page->rid->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rid->formatPattern()) ?>"<?= $Page->rid->editAttributes() ?> aria-describedby="x_rid_help">
</span>
<selection-list hidden class="form-control" data-table="process_action_material" data-field="x_rid" data-input="sv_x_rid" data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?= HtmlEncode($Page->rid->CurrentValue) ?>" data-ew-action="update-options"></selection-list>
<?= $Page->rid->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->rid->getErrorMessage() ?></div>
<script>
loadjs.ready("fprocess_action_materialadd", function() {
    fprocess_action_materialadd.createAutoSuggest(Object.assign({"id":"x_rid","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->rid->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.process_action_material.fields.rid.autoSuggestOptions));
});
</script>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->godown->Visible) { // godown ?>
    <div id="r_godown"<?= $Page->godown->rowAttributes() ?>>
        <label id="elh_process_action_material_godown" class="<?= $Page->LeftColumnClass ?>"><?= $Page->godown->caption() ?><?= $Page->godown->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->godown->cellAttributes() ?>>
<span id="el_process_action_material_godown">
<?php
if (IsRTL()) {
    $Page->godown->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_godown" class="ew-auto-suggest">
    <input type="<?= $Page->godown->getInputTextType() ?>" class="form-control" name="sv_x_godown" id="sv_x_godown" value="<?= RemoveHtml($Page->godown->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->godown->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->godown->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->godown->formatPattern()) ?>"<?= $Page->godown->editAttributes() ?> aria-describedby="x_godown_help">
</span>
<selection-list hidden class="form-control" data-table="process_action_material" data-field="x_godown" data-input="sv_x_godown" data-value-separator="<?= $Page->godown->displayValueSeparatorAttribute() ?>" name="x_godown" id="x_godown" value="<?= HtmlEncode($Page->godown->CurrentValue) ?>"></selection-list>
<?= $Page->godown->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->godown->getErrorMessage() ?></div>
<script>
loadjs.ready("fprocess_action_materialadd", function() {
    fprocess_action_materialadd.createAutoSuggest(Object.assign({"id":"x_godown","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->godown->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.process_action_material.fields.godown.autoSuggestOptions));
});
</script>
<?= $Page->godown->Lookup->getParamTag($Page, "p_x_godown") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->avg_quantity->Visible) { // avg_quantity ?>
    <div id="r_avg_quantity"<?= $Page->avg_quantity->rowAttributes() ?>>
        <label id="elh_process_action_material_avg_quantity" for="x_avg_quantity" class="<?= $Page->LeftColumnClass ?>"><?= $Page->avg_quantity->caption() ?><?= $Page->avg_quantity->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->avg_quantity->cellAttributes() ?>>
<span id="el_process_action_material_avg_quantity">
<input type="<?= $Page->avg_quantity->getInputTextType() ?>" name="x_avg_quantity" id="x_avg_quantity" data-table="process_action_material" data-field="x_avg_quantity" value="<?= $Page->avg_quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->avg_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->avg_quantity->formatPattern()) ?>"<?= $Page->avg_quantity->editAttributes() ?> aria-describedby="x_avg_quantity_help">
<?= $Page->avg_quantity->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->avg_quantity->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->lot_no->Visible) { // lot_no ?>
    <div id="r_lot_no"<?= $Page->lot_no->rowAttributes() ?>>
        <label id="elh_process_action_material_lot_no" for="x_lot_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->lot_no->caption() ?><?= $Page->lot_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->lot_no->cellAttributes() ?>>
<span id="el_process_action_material_lot_no">
<input type="<?= $Page->lot_no->getInputTextType() ?>" name="x_lot_no" id="x_lot_no" data-table="process_action_material" data-field="x_lot_no" value="<?= $Page->lot_no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->lot_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->lot_no->formatPattern()) ?>"<?= $Page->lot_no->editAttributes() ?> aria-describedby="x_lot_no_help">
<?= $Page->lot_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->lot_no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->avialable_qty->Visible) { // avialable_qty ?>
    <div id="r_avialable_qty"<?= $Page->avialable_qty->rowAttributes() ?>>
        <label id="elh_process_action_material_avialable_qty" for="x_avialable_qty" class="<?= $Page->LeftColumnClass ?>"><?= $Page->avialable_qty->caption() ?><?= $Page->avialable_qty->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->avialable_qty->cellAttributes() ?>>
<span id="el_process_action_material_avialable_qty">
<input type="<?= $Page->avialable_qty->getInputTextType() ?>" name="x_avialable_qty" id="x_avialable_qty" data-table="process_action_material" data-field="x_avialable_qty" value="<?= $Page->avialable_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->avialable_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->avialable_qty->formatPattern()) ?>"<?= $Page->avialable_qty->editAttributes() ?> aria-describedby="x_avialable_qty_help">
<?= $Page->avialable_qty->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->avialable_qty->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->ply->Visible) { // ply ?>
    <div id="r_ply"<?= $Page->ply->rowAttributes() ?>>
        <label id="elh_process_action_material_ply" for="x_ply" class="<?= $Page->LeftColumnClass ?>"><?= $Page->ply->caption() ?><?= $Page->ply->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->ply->cellAttributes() ?>>
<span id="el_process_action_material_ply">
<input type="<?= $Page->ply->getInputTextType() ?>" name="x_ply" id="x_ply" data-table="process_action_material" data-field="x_ply" value="<?= $Page->ply->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->ply->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ply->formatPattern()) ?>"<?= $Page->ply->editAttributes() ?> aria-describedby="x_ply_help">
<?= $Page->ply->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->ply->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->rid_new->Visible) { // rid_new ?>
    <div id="r_rid_new"<?= $Page->rid_new->rowAttributes() ?>>
        <label id="elh_process_action_material_rid_new" for="x_rid_new" class="<?= $Page->LeftColumnClass ?>"><?= $Page->rid_new->caption() ?><?= $Page->rid_new->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->rid_new->cellAttributes() ?>>
<span id="el_process_action_material_rid_new">
    <select
        id="x_rid_new"
        name="x_rid_new"
        class="form-select ew-select<?= $Page->rid_new->isInvalidClass() ?>"
        <?php if (!$Page->rid_new->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_materialadd_x_rid_new"
        <?php } ?>
        data-table="process_action_material"
        data-field="x_rid_new"
        data-value-separator="<?= $Page->rid_new->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid_new->getPlaceHolder()) ?>"
        <?= $Page->rid_new->editAttributes() ?>>
        <?= $Page->rid_new->selectOptionListHtml("x_rid_new") ?>
    </select>
    <?= $Page->rid_new->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->rid_new->getErrorMessage() ?></div>
<?= $Page->rid_new->Lookup->getParamTag($Page, "p_x_rid_new") ?>
<?php if (!$Page->rid_new->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_materialadd", function() {
    var options = { name: "x_rid_new", selectId: "fprocess_action_materialadd_x_rid_new" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_materialadd.lists.rid_new?.lookupOptions.length) {
        options.data = { id: "x_rid_new", form: "fprocess_action_materialadd" };
    } else {
        options.ajax = { id: "x_rid_new", form: "fprocess_action_materialadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_material.fields.rid_new.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->rid_new_lot_no->Visible) { // rid_new_lot_no ?>
    <div id="r_rid_new_lot_no"<?= $Page->rid_new_lot_no->rowAttributes() ?>>
        <label id="elh_process_action_material_rid_new_lot_no" for="x_rid_new_lot_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->rid_new_lot_no->caption() ?><?= $Page->rid_new_lot_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->rid_new_lot_no->cellAttributes() ?>>
<span id="el_process_action_material_rid_new_lot_no">
<input type="<?= $Page->rid_new_lot_no->getInputTextType() ?>" name="x_rid_new_lot_no" id="x_rid_new_lot_no" data-table="process_action_material" data-field="x_rid_new_lot_no" value="<?= $Page->rid_new_lot_no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->rid_new_lot_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rid_new_lot_no->formatPattern()) ?>"<?= $Page->rid_new_lot_no->editAttributes() ?> aria-describedby="x_rid_new_lot_no_help">
<?= $Page->rid_new_lot_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->rid_new_lot_no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->poid_new->Visible) { // poid_new ?>
    <div id="r_poid_new"<?= $Page->poid_new->rowAttributes() ?>>
        <label id="elh_process_action_material_poid_new" for="x_poid_new" class="<?= $Page->LeftColumnClass ?>"><?= $Page->poid_new->caption() ?><?= $Page->poid_new->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->poid_new->cellAttributes() ?>>
<span id="el_process_action_material_poid_new">
<input type="<?= $Page->poid_new->getInputTextType() ?>" name="x_poid_new" id="x_poid_new" data-table="process_action_material" data-field="x_poid_new" value="<?= $Page->poid_new->EditValue ?>" placeholder="<?= HtmlEncode($Page->poid_new->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->poid_new->formatPattern()) ?>"<?= $Page->poid_new->editAttributes() ?> aria-describedby="x_poid_new_help">
<?= $Page->poid_new->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->poid_new->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->poid_1->Visible) { // poid_1 ?>
    <div id="r_poid_1"<?= $Page->poid_1->rowAttributes() ?>>
        <label id="elh_process_action_material_poid_1" class="<?= $Page->LeftColumnClass ?>"><?= $Page->poid_1->caption() ?><?= $Page->poid_1->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->poid_1->cellAttributes() ?>>
<span id="el_process_action_material_poid_1">
<template id="tp_x_poid_1">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="process_action_material" data-field="x_poid_1" name="x_poid_1" id="x_poid_1"<?= $Page->poid_1->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_poid_1" class="ew-item-list"></div>
<selection-list hidden
    id="x_poid_1[]"
    name="x_poid_1[]"
    value="<?= HtmlEncode($Page->poid_1->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_poid_1"
    data-target="dsl_x_poid_1"
    data-repeatcolumn="1"
    class="form-control<?= $Page->poid_1->isInvalidClass() ?>"
    data-table="process_action_material"
    data-field="x_poid_1"
    data-value-separator="<?= $Page->poid_1->displayValueSeparatorAttribute() ?>"
    <?= $Page->poid_1->editAttributes() ?>></selection-list>
<?= $Page->poid_1->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->poid_1->getErrorMessage() ?></div>
<?= $Page->poid_1->Lookup->getParamTag($Page, "p_x_poid_1") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->poid->Visible) { // poid ?>
    <div id="r_poid"<?= $Page->poid->rowAttributes() ?>>
        <label id="elh_process_action_material_poid" for="x_poid" class="<?= $Page->LeftColumnClass ?>"><?= $Page->poid->caption() ?><?= $Page->poid->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->poid->cellAttributes() ?>>
<span id="el_process_action_material_poid">
<input type="<?= $Page->poid->getInputTextType() ?>" name="x_poid" id="x_poid" data-table="process_action_material" data-field="x_poid" value="<?= $Page->poid->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->poid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->poid->formatPattern()) ?>"<?= $Page->poid->editAttributes() ?> aria-describedby="x_poid_help">
<?= $Page->poid->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->poid->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity"<?= $Page->quantity->rowAttributes() ?>>
        <label id="elh_process_action_material_quantity" for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><?= $Page->quantity->caption() ?><?= $Page->quantity->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->quantity->cellAttributes() ?>>
<span id="el_process_action_material_quantity">
<input type="<?= $Page->quantity->getInputTextType() ?>" name="x_quantity" id="x_quantity" data-table="process_action_material" data-field="x_quantity" value="<?= $Page->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity->formatPattern()) ?>"<?= $Page->quantity->editAttributes() ?> aria-describedby="x_quantity_help">
<?= $Page->quantity->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->quantity->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->packets->Visible) { // packets ?>
    <div id="r_packets"<?= $Page->packets->rowAttributes() ?>>
        <label id="elh_process_action_material_packets" for="x_packets" class="<?= $Page->LeftColumnClass ?>"><?= $Page->packets->caption() ?><?= $Page->packets->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->packets->cellAttributes() ?>>
<span id="el_process_action_material_packets">
<input type="<?= $Page->packets->getInputTextType() ?>" name="x_packets" id="x_packets" data-table="process_action_material" data-field="x_packets" value="<?= $Page->packets->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->packets->formatPattern()) ?>"<?= $Page->packets->editAttributes() ?> aria-describedby="x_packets_help">
<?= $Page->packets->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->packets->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->process_method->Visible) { // process_method ?>
    <div id="r_process_method"<?= $Page->process_method->rowAttributes() ?>>
        <label id="elh_process_action_material_process_method" for="x_process_method" class="<?= $Page->LeftColumnClass ?>"><?= $Page->process_method->caption() ?><?= $Page->process_method->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->process_method->cellAttributes() ?>>
<span id="el_process_action_material_process_method">
    <select
        id="x_process_method"
        name="x_process_method"
        class="form-select ew-select<?= $Page->process_method->isInvalidClass() ?>"
        <?php if (!$Page->process_method->IsNativeSelect) { ?>
        data-select2-id="fprocess_action_materialadd_x_process_method"
        <?php } ?>
        data-table="process_action_material"
        data-field="x_process_method"
        data-value-separator="<?= $Page->process_method->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process_method->getPlaceHolder()) ?>"
        <?= $Page->process_method->editAttributes() ?>>
        <?= $Page->process_method->selectOptionListHtml("x_process_method") ?>
    </select>
    <?= $Page->process_method->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->process_method->getErrorMessage() ?></div>
<?php if (!$Page->process_method->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_action_materialadd", function() {
    var options = { name: "x_process_method", selectId: "fprocess_action_materialadd_x_process_method" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_action_materialadd.lists.process_method?.lookupOptions.length) {
        options.data = { id: "x_process_method", form: "fprocess_action_materialadd" };
    } else {
        options.ajax = { id: "x_process_method", form: "fprocess_action_materialadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action_material.fields.process_method.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remark->Visible) { // remark ?>
    <div id="r_remark"<?= $Page->remark->rowAttributes() ?>>
        <label id="elh_process_action_material_remark" for="x_remark" class="<?= $Page->LeftColumnClass ?>"><?= $Page->remark->caption() ?><?= $Page->remark->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->remark->cellAttributes() ?>>
<span id="el_process_action_material_remark">
<input type="<?= $Page->remark->getInputTextType() ?>" name="x_remark" id="x_remark" data-table="process_action_material" data-field="x_remark" value="<?= $Page->remark->EditValue ?>" size="30" maxlength="225" placeholder="<?= HtmlEncode($Page->remark->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remark->formatPattern()) ?>"<?= $Page->remark->editAttributes() ?> aria-describedby="x_remark_help">
<?= $Page->remark->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->remark->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
    <div id="r_dated"<?= $Page->dated->rowAttributes() ?>>
        <label id="elh_process_action_material_dated" for="x_dated" class="<?= $Page->LeftColumnClass ?>"><?= $Page->dated->caption() ?><?= $Page->dated->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->dated->cellAttributes() ?>>
<span id="el_process_action_material_dated">
<input type="<?= $Page->dated->getInputTextType() ?>" name="x_dated" id="x_dated" data-table="process_action_material" data-field="x_dated" value="<?= $Page->dated->EditValue ?>" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?> aria-describedby="x_dated_help">
<?= $Page->dated->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage() ?></div>
<?php if (!$Page->dated->ReadOnly && !$Page->dated->Disabled && !isset($Page->dated->EditAttrs["readonly"]) && !isset($Page->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprocess_action_materialadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprocess_action_materialadd", "x_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fprocess_action_materialadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fprocess_action_materialadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("process_action_material");
});
</script>
<script>
loadjs.ready("load", function () {
    // Startup script
    // Write your table-specific startup script here
    // document.write("page loaded");
    	var sprocess = $("#x_sub_process").val();
        if (typeof sprocess !== 'undefined')
        {
    		var sprocess = $("#x_sub_process").val();
            $.getJSON(window.location.origin +"/apcajax?packingtypedetails="+sprocess,function(data)
    		{
    			if (data.ply == 1) 
    			{
    				$("#r_ply").show();
    				$("#r_rid_new").show();
    				$("#r_poid_new").show();
    				$("#r_poid_1").hide();
    				$("#r_rid_new_lot_no").show();
    			}
    			else if (data.ply == 0) 
    			{
    				$("#r_ply").hide();
    				$("#r_rid_new").hide();
    				$("#r_poid_new").hide();
    				$("#r_poid_1").show();
    				$("#r_rid_new_lot_no").hide();
    			}
    			if (data.rid_new == 1 && data.ply == 0) 
    			{
    				$("#r_rid_new").show();
    				$("#r_rid_new_lot_no").show();
    			}
    		});
        }
        else
        {
            $("#r_ply").hide();
    		$("#r_rid_new").hide();
    		$("#r_poid_new").hide();
    		$("#r_poid_1").show();
    		$("#r_rid_new_lot_no").hide();
        }
});
</script>
