<?php

namespace PHPMaker2024\fibre;

// Page object
$ProcessActionList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { process_action: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fprocess_actionsrch" id="fprocess_actionsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fprocess_actionsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { process_action: currentTable } });
var currentForm;
var fprocess_actionsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fprocess_actionsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["location", [], fields.location.isInvalid],
            ["employee_id", [], fields.employee_id.isInvalid],
            ["y_employee_id", [ew.Validators.between], false],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["y_datetime", [ew.Validators.between], false]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "location": <?= $Page->location->toClientList($Page) ?>,
            "employee_id": <?= $Page->employee_id->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->location->Visible) { // location ?>
<?php
if (!$Page->location->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_location" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->location->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_location" class="ew-search-caption ew-label"><?= $Page->location->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_location" id="z_location" value="=">
</div>
        </div>
        <div id="el_process_action_location" class="ew-search-field">
    <select
        id="x_location"
        name="x_location"
        class="form-select ew-select<?= $Page->location->isInvalidClass() ?>"
        <?php if (!$Page->location->IsNativeSelect) { ?>
        data-select2-id="fprocess_actionsrch_x_location"
        <?php } ?>
        data-table="process_action"
        data-field="x_location"
        data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->location->editAttributes() ?>>
        <?= $Page->location->selectOptionListHtml("x_location") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->location->getErrorMessage(false) ?></div>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
<?php if (!$Page->location->IsNativeSelect) { ?>
<script>
loadjs.ready("fprocess_actionsrch", function() {
    var options = { name: "x_location", selectId: "fprocess_actionsrch_x_location" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprocess_actionsrch.lists.location?.lookupOptions.length) {
        options.data = { id: "x_location", form: "fprocess_actionsrch" };
    } else {
        options.ajax = { id: "x_location", form: "fprocess_actionsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.process_action.fields.location.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->employee_id->Visible) { // employee_id ?>
<?php
if (!$Page->employee_id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_employee_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->employee_id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_employee_id" class="ew-search-caption ew-label"><?= $Page->employee_id->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_employee_id" id="z_employee_id" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->employee_id->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->employee_id->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_process_action_employee_id" class="ew-search-field">
    <select
        id="x_employee_id[]"
        name="x_employee_id[]"
        class="form-control ew-select<?= $Page->employee_id->isInvalidClass() ?>"
        data-select2-id="fprocess_actionsrch_x_employee_id[]"
        data-table="process_action"
        data-field="x_employee_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->employee_id->caption())) ?>"
        data-modal-lookup="true"
        multiple
        size="1"
        data-value-separator="<?= $Page->employee_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->employee_id->getPlaceHolder()) ?>"
        <?= $Page->employee_id->editAttributes() ?>>
        <?= $Page->employee_id->selectOptionListHtml("x_employee_id[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->employee_id->getErrorMessage(false) ?></div>
<?= $Page->employee_id->Lookup->getParamTag($Page, "p_x_employee_id") ?>
<script>
loadjs.ready("fprocess_actionsrch", function() {
    var options = { name: "x_employee_id[]", selectId: "fprocess_actionsrch_x_employee_id[]" };
    options.multiple = true;
    if (fprocess_actionsrch.lists.employee_id?.lookupOptions.length) {
        options.data = { id: "x_employee_id[]", form: "fprocess_actionsrch" };
    } else {
        options.ajax = { id: "x_employee_id[]", form: "fprocess_actionsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.process_action.fields.employee_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_process_action_employee_id" class="ew-search-field2 d-none">
    <select
        id="y_employee_id[]"
        name="y_employee_id[]"
        class="form-control ew-select<?= $Page->employee_id->isInvalidClass() ?>"
        data-select2-id="fprocess_actionsrch_y_employee_id[]"
        data-table="process_action"
        data-field="x_employee_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->employee_id->caption())) ?>"
        data-modal-lookup="true"
        multiple
        size="1"
        data-value-separator="<?= $Page->employee_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->employee_id->getPlaceHolder()) ?>"
        <?= $Page->employee_id->editAttributes() ?>>
        <?= $Page->employee_id->selectOptionListHtml("y_employee_id[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->employee_id->getErrorMessage(false) ?></div>
<?= $Page->employee_id->Lookup->getParamTag($Page, "p_y_employee_id") ?>
<script>
loadjs.ready("fprocess_actionsrch", function() {
    var options = { name: "y_employee_id[]", selectId: "fprocess_actionsrch_y_employee_id[]" };
    options.multiple = true;
    if (fprocess_actionsrch.lists.employee_id?.lookupOptions.length) {
        options.data = { id: "y_employee_id[]", form: "fprocess_actionsrch" };
    } else {
        options.ajax = { id: "y_employee_id[]", form: "fprocess_actionsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.process_action.fields.employee_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
<?php
if (!$Page->datetime->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_datetime" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->datetime->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_datetime" class="ew-search-caption ew-label"><?= $Page->datetime->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_datetime" id="z_datetime" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->datetime->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->datetime->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_process_action_datetime" class="ew-search-field">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="process_action" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprocess_actionsrch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprocess_actionsrch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_process_action_datetime" class="ew-search-field2 d-none">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="y_datetime" id="y_datetime" data-table="process_action" data-field="x_datetime" value="<?= $Page->datetime->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprocess_actionsrch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprocess_actionsrch", "y_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fprocess_actionsrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fprocess_actionsrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fprocess_actionsrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fprocess_actionsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fprocess_actionsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fprocess_actionsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fprocess_actionsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="process_action">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_process_action" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_process_actionlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_process_action_id" class="process_action_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->process->Visible) { // process ?>
        <th data-name="process" class="<?= $Page->process->headerCellClass() ?>"><div id="elh_process_action_process" class="process_action_process"><?= $Page->renderFieldHeader($Page->process) ?></div></th>
<?php } ?>
<?php if ($Page->process_other->Visible) { // process_other ?>
        <th data-name="process_other" class="<?= $Page->process_other->headerCellClass() ?>"><div id="elh_process_action_process_other" class="process_action_process_other"><?= $Page->renderFieldHeader($Page->process_other) ?></div></th>
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
        <th data-name="location" class="<?= $Page->location->headerCellClass() ?>"><div id="elh_process_action_location" class="process_action_location"><?= $Page->renderFieldHeader($Page->location) ?></div></th>
<?php } ?>
<?php if ($Page->godown->Visible) { // godown ?>
        <th data-name="godown" class="<?= $Page->godown->headerCellClass() ?>"><div id="elh_process_action_godown" class="process_action_godown"><?= $Page->renderFieldHeader($Page->godown) ?></div></th>
<?php } ?>
<?php if ($Page->code->Visible) { // code ?>
        <th data-name="code" class="<?= $Page->code->headerCellClass() ?>"><div id="elh_process_action_code" class="process_action_code"><?= $Page->renderFieldHeader($Page->code) ?></div></th>
<?php } ?>
<?php if ($Page->code_last->Visible) { // code_last ?>
        <th data-name="code_last" class="<?= $Page->code_last->headerCellClass() ?>"><div id="elh_process_action_code_last" class="process_action_code_last"><?= $Page->renderFieldHeader($Page->code_last) ?></div></th>
<?php } ?>
<?php if ($Page->employee_id->Visible) { // employee_id ?>
        <th data-name="employee_id" class="<?= $Page->employee_id->headerCellClass() ?>"><div id="elh_process_action_employee_id" class="process_action_employee_id"><?= $Page->renderFieldHeader($Page->employee_id) ?></div></th>
<?php } ?>
<?php if ($Page->qty->Visible) { // qty ?>
        <th data-name="qty" class="<?= $Page->qty->headerCellClass() ?>"><div id="elh_process_action_qty" class="process_action_qty"><?= $Page->renderFieldHeader($Page->qty) ?></div></th>
<?php } ?>
<?php if ($Page->roll_no->Visible) { // roll_no ?>
        <th data-name="roll_no" class="<?= $Page->roll_no->headerCellClass() ?>"><div id="elh_process_action_roll_no" class="process_action_roll_no"><?= $Page->renderFieldHeader($Page->roll_no) ?></div></th>
<?php } ?>
<?php if ($Page->size_w->Visible) { // size_w ?>
        <th data-name="size_w" class="<?= $Page->size_w->headerCellClass() ?>"><div id="elh_process_action_size_w" class="process_action_size_w"><?= $Page->renderFieldHeader($Page->size_w) ?></div></th>
<?php } ?>
<?php if ($Page->size_l->Visible) { // size_l ?>
        <th data-name="size_l" class="<?= $Page->size_l->headerCellClass() ?>"><div id="elh_process_action_size_l" class="process_action_size_l"><?= $Page->renderFieldHeader($Page->size_l) ?></div></th>
<?php } ?>
<?php if ($Page->size_h->Visible) { // size_h ?>
        <th data-name="size_h" class="<?= $Page->size_h->headerCellClass() ?>"><div id="elh_process_action_size_h" class="process_action_size_h"><?= $Page->renderFieldHeader($Page->size_h) ?></div></th>
<?php } ?>
<?php if ($Page->size_actual->Visible) { // size_actual ?>
        <th data-name="size_actual" class="<?= $Page->size_actual->headerCellClass() ?>"><div id="elh_process_action_size_actual" class="process_action_size_actual"><?= $Page->renderFieldHeader($Page->size_actual) ?></div></th>
<?php } ?>
<?php if ($Page->weight_actual->Visible) { // weight_actual ?>
        <th data-name="weight_actual" class="<?= $Page->weight_actual->headerCellClass() ?>"><div id="elh_process_action_weight_actual" class="process_action_weight_actual"><?= $Page->renderFieldHeader($Page->weight_actual) ?></div></th>
<?php } ?>
<?php if ($Page->lines_in_30cm->Visible) { // lines_in_30cm ?>
        <th data-name="lines_in_30cm" class="<?= $Page->lines_in_30cm->headerCellClass() ?>"><div id="elh_process_action_lines_in_30cm" class="process_action_lines_in_30cm"><?= $Page->renderFieldHeader($Page->lines_in_30cm) ?></div></th>
<?php } ?>
<?php if ($Page->d_01->Visible) { // d_01 ?>
        <th data-name="d_01" class="<?= $Page->d_01->headerCellClass() ?>"><div id="elh_process_action_d_01" class="process_action_d_01"><?= $Page->renderFieldHeader($Page->d_01) ?></div></th>
<?php } ?>
<?php if ($Page->d_02->Visible) { // d_02 ?>
        <th data-name="d_02" class="<?= $Page->d_02->headerCellClass() ?>"><div id="elh_process_action_d_02" class="process_action_d_02"><?= $Page->renderFieldHeader($Page->d_02) ?></div></th>
<?php } ?>
<?php if ($Page->d_03->Visible) { // d_03 ?>
        <th data-name="d_03" class="<?= $Page->d_03->headerCellClass() ?>"><div id="elh_process_action_d_03" class="process_action_d_03"><?= $Page->renderFieldHeader($Page->d_03) ?></div></th>
<?php } ?>
<?php if ($Page->d_04->Visible) { // d_04 ?>
        <th data-name="d_04" class="<?= $Page->d_04->headerCellClass() ?>"><div id="elh_process_action_d_04" class="process_action_d_04"><?= $Page->renderFieldHeader($Page->d_04) ?></div></th>
<?php } ?>
<?php if ($Page->d_05->Visible) { // d_05 ?>
        <th data-name="d_05" class="<?= $Page->d_05->headerCellClass() ?>"><div id="elh_process_action_d_05" class="process_action_d_05"><?= $Page->renderFieldHeader($Page->d_05) ?></div></th>
<?php } ?>
<?php if ($Page->d_06->Visible) { // d_06 ?>
        <th data-name="d_06" class="<?= $Page->d_06->headerCellClass() ?>"><div id="elh_process_action_d_06" class="process_action_d_06"><?= $Page->renderFieldHeader($Page->d_06) ?></div></th>
<?php } ?>
<?php if ($Page->d_07->Visible) { // d_07 ?>
        <th data-name="d_07" class="<?= $Page->d_07->headerCellClass() ?>"><div id="elh_process_action_d_07" class="process_action_d_07"><?= $Page->renderFieldHeader($Page->d_07) ?></div></th>
<?php } ?>
<?php if ($Page->d_08->Visible) { // d_08 ?>
        <th data-name="d_08" class="<?= $Page->d_08->headerCellClass() ?>"><div id="elh_process_action_d_08" class="process_action_d_08"><?= $Page->renderFieldHeader($Page->d_08) ?></div></th>
<?php } ?>
<?php if ($Page->d_09->Visible) { // d_09 ?>
        <th data-name="d_09" class="<?= $Page->d_09->headerCellClass() ?>"><div id="elh_process_action_d_09" class="process_action_d_09"><?= $Page->renderFieldHeader($Page->d_09) ?></div></th>
<?php } ?>
<?php if ($Page->d_10->Visible) { // d_10 ?>
        <th data-name="d_10" class="<?= $Page->d_10->headerCellClass() ?>"><div id="elh_process_action_d_10" class="process_action_d_10"><?= $Page->renderFieldHeader($Page->d_10) ?></div></th>
<?php } ?>
<?php if ($Page->valuation->Visible) { // valuation ?>
        <th data-name="valuation" class="<?= $Page->valuation->headerCellClass() ?>"><div id="elh_process_action_valuation" class="process_action_valuation"><?= $Page->renderFieldHeader($Page->valuation) ?></div></th>
<?php } ?>
<?php if ($Page->deduction->Visible) { // deduction ?>
        <th data-name="deduction" class="<?= $Page->deduction->headerCellClass() ?>"><div id="elh_process_action_deduction" class="process_action_deduction"><?= $Page->renderFieldHeader($Page->deduction) ?></div></th>
<?php } ?>
<?php if ($Page->remark->Visible) { // remark ?>
        <th data-name="remark" class="<?= $Page->remark->headerCellClass() ?>"><div id="elh_process_action_remark" class="process_action_remark"><?= $Page->renderFieldHeader($Page->remark) ?></div></th>
<?php } ?>
<?php if ($Page->upload->Visible) { // upload ?>
        <th data-name="upload" class="<?= $Page->upload->headerCellClass() ?>"><div id="elh_process_action_upload" class="process_action_upload"><?= $Page->renderFieldHeader($Page->upload) ?></div></th>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Page->operator->headerCellClass() ?>"><div id="elh_process_action_operator" class="process_action_operator"><?= $Page->renderFieldHeader($Page->operator) ?></div></th>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Page->datetime->headerCellClass() ?>"><div id="elh_process_action_datetime" class="process_action_datetime"><?= $Page->renderFieldHeader($Page->datetime) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_id" class="el_process_action_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->process->Visible) { // process ?>
        <td data-name="process"<?= $Page->process->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_process" class="el_process_action_process">
<span<?= $Page->process->viewAttributes() ?>>
<?php if (!EmptyString($Page->process->getViewValue()) && $Page->process->linkAttributes() != "") { ?>
<a<?= $Page->process->linkAttributes() ?>><?= $Page->process->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->process->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->process_other->Visible) { // process_other ?>
        <td data-name="process_other"<?= $Page->process_other->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_process_other" class="el_process_action_process_other">
<span<?= $Page->process_other->viewAttributes() ?>>
<?= $Page->process_other->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->location->Visible) { // location ?>
        <td data-name="location"<?= $Page->location->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_location" class="el_process_action_location">
<span<?= $Page->location->viewAttributes() ?>>
<?= $Page->location->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->godown->Visible) { // godown ?>
        <td data-name="godown"<?= $Page->godown->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_godown" class="el_process_action_godown">
<span<?= $Page->godown->viewAttributes() ?>>
<?= $Page->godown->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->code->Visible) { // code ?>
        <td data-name="code"<?= $Page->code->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_code" class="el_process_action_code">
<span<?= $Page->code->viewAttributes() ?>>
<?php if (!EmptyString($Page->code->getViewValue()) && $Page->code->linkAttributes() != "") { ?>
<a<?= $Page->code->linkAttributes() ?>><?= $Page->code->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->code->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->code_last->Visible) { // code_last ?>
        <td data-name="code_last"<?= $Page->code_last->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_code_last" class="el_process_action_code_last">
<span<?= $Page->code_last->viewAttributes() ?>>
<?= $Page->code_last->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->employee_id->Visible) { // employee_id ?>
        <td data-name="employee_id"<?= $Page->employee_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_employee_id" class="el_process_action_employee_id">
<span<?= $Page->employee_id->viewAttributes() ?>>
<?= $Page->employee_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->qty->Visible) { // qty ?>
        <td data-name="qty"<?= $Page->qty->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_qty" class="el_process_action_qty">
<span<?= $Page->qty->viewAttributes() ?>>
<?= $Page->qty->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->roll_no->Visible) { // roll_no ?>
        <td data-name="roll_no"<?= $Page->roll_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_roll_no" class="el_process_action_roll_no">
<span<?= $Page->roll_no->viewAttributes() ?>>
<?= $Page->roll_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->size_w->Visible) { // size_w ?>
        <td data-name="size_w"<?= $Page->size_w->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_size_w" class="el_process_action_size_w">
<span<?= $Page->size_w->viewAttributes() ?>>
<?= $Page->size_w->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->size_l->Visible) { // size_l ?>
        <td data-name="size_l"<?= $Page->size_l->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_size_l" class="el_process_action_size_l">
<span<?= $Page->size_l->viewAttributes() ?>>
<?= $Page->size_l->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->size_h->Visible) { // size_h ?>
        <td data-name="size_h"<?= $Page->size_h->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_size_h" class="el_process_action_size_h">
<span<?= $Page->size_h->viewAttributes() ?>>
<?= $Page->size_h->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->size_actual->Visible) { // size_actual ?>
        <td data-name="size_actual"<?= $Page->size_actual->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_size_actual" class="el_process_action_size_actual">
<span<?= $Page->size_actual->viewAttributes() ?>>
<?= $Page->size_actual->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->weight_actual->Visible) { // weight_actual ?>
        <td data-name="weight_actual"<?= $Page->weight_actual->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_weight_actual" class="el_process_action_weight_actual">
<span<?= $Page->weight_actual->viewAttributes() ?>>
<?= $Page->weight_actual->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->lines_in_30cm->Visible) { // lines_in_30cm ?>
        <td data-name="lines_in_30cm"<?= $Page->lines_in_30cm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_lines_in_30cm" class="el_process_action_lines_in_30cm">
<span<?= $Page->lines_in_30cm->viewAttributes() ?>>
<?= $Page->lines_in_30cm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->d_01->Visible) { // d_01 ?>
        <td data-name="d_01"<?= $Page->d_01->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_d_01" class="el_process_action_d_01">
<span<?= $Page->d_01->viewAttributes() ?>>
<?= $Page->d_01->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->d_02->Visible) { // d_02 ?>
        <td data-name="d_02"<?= $Page->d_02->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_d_02" class="el_process_action_d_02">
<span<?= $Page->d_02->viewAttributes() ?>>
<?= $Page->d_02->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->d_03->Visible) { // d_03 ?>
        <td data-name="d_03"<?= $Page->d_03->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_d_03" class="el_process_action_d_03">
<span<?= $Page->d_03->viewAttributes() ?>>
<?= $Page->d_03->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->d_04->Visible) { // d_04 ?>
        <td data-name="d_04"<?= $Page->d_04->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_d_04" class="el_process_action_d_04">
<span<?= $Page->d_04->viewAttributes() ?>>
<?= $Page->d_04->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->d_05->Visible) { // d_05 ?>
        <td data-name="d_05"<?= $Page->d_05->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_d_05" class="el_process_action_d_05">
<span<?= $Page->d_05->viewAttributes() ?>>
<?= $Page->d_05->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->d_06->Visible) { // d_06 ?>
        <td data-name="d_06"<?= $Page->d_06->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_d_06" class="el_process_action_d_06">
<span<?= $Page->d_06->viewAttributes() ?>>
<?= $Page->d_06->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->d_07->Visible) { // d_07 ?>
        <td data-name="d_07"<?= $Page->d_07->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_d_07" class="el_process_action_d_07">
<span<?= $Page->d_07->viewAttributes() ?>>
<?= $Page->d_07->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->d_08->Visible) { // d_08 ?>
        <td data-name="d_08"<?= $Page->d_08->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_d_08" class="el_process_action_d_08">
<span<?= $Page->d_08->viewAttributes() ?>>
<?= $Page->d_08->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->d_09->Visible) { // d_09 ?>
        <td data-name="d_09"<?= $Page->d_09->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_d_09" class="el_process_action_d_09">
<span<?= $Page->d_09->viewAttributes() ?>>
<?= $Page->d_09->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->d_10->Visible) { // d_10 ?>
        <td data-name="d_10"<?= $Page->d_10->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_d_10" class="el_process_action_d_10">
<span<?= $Page->d_10->viewAttributes() ?>>
<?= $Page->d_10->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->valuation->Visible) { // valuation ?>
        <td data-name="valuation"<?= $Page->valuation->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_valuation" class="el_process_action_valuation">
<span<?= $Page->valuation->viewAttributes() ?>>
<?= $Page->valuation->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->deduction->Visible) { // deduction ?>
        <td data-name="deduction"<?= $Page->deduction->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_deduction" class="el_process_action_deduction">
<span<?= $Page->deduction->viewAttributes() ?>>
<?= $Page->deduction->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->remark->Visible) { // remark ?>
        <td data-name="remark"<?= $Page->remark->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_remark" class="el_process_action_remark">
<span<?= $Page->remark->viewAttributes() ?>>
<?= $Page->remark->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->upload->Visible) { // upload ?>
        <td data-name="upload"<?= $Page->upload->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_upload" class="el_process_action_upload">
<span>
<?= GetFileViewTag($Page->upload, $Page->upload->getViewValue(), false) ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_operator" class="el_process_action_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_process_action_datetime" class="el_process_action_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("process_action");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
