<?php

namespace PHPMaker2024\fibre;

// Page object
$PpVerifyCompiledSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { pp_verify_compiled: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fpp_verify_compiledsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpp_verify_compiledsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["pid", [ew.Validators.integer], fields.pid.isInvalid],
            ["location", [], fields.location.isInvalid],
            ["product_type", [], fields.product_type.isInvalid],
            ["y_product_type", [ew.Validators.between], false],
            ["shape", [], fields.shape.isInvalid],
            ["plan_type", [], fields.plan_type.isInvalid],
            ["gcode", [], fields.gcode.isInvalid],
            ["design_id", [], fields.design_id.isInvalid],
            ["process", [ew.Validators.integer], fields.process.isInvalid],
            ["yes_no", [], fields.yes_no.isInvalid],
            ["fix", [], fields.fix.isInvalid],
            ["unit", [], fields.unit.isInvalid],
            ["_unit", [ew.Validators.float], fields._unit.isInvalid],
            ["_40", [ew.Validators.float], fields._40.isInvalid],
            ["extra_plan", [], fields.extra_plan.isInvalid],
            ["custom_size", [ew.Validators.float], fields.custom_size.isInvalid],
            ["custom_size_below_st", [ew.Validators.float], fields.custom_size_below_st.isInvalid],
            ["method", [], fields.method.isInvalid],
            ["category", [], fields.category.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "location": <?= $Page->location->toClientList($Page) ?>,
            "product_type": <?= $Page->product_type->toClientList($Page) ?>,
            "shape": <?= $Page->shape->toClientList($Page) ?>,
            "plan_type": <?= $Page->plan_type->toClientList($Page) ?>,
            "design_id": <?= $Page->design_id->toClientList($Page) ?>,
            "process": <?= $Page->process->toClientList($Page) ?>,
            "yes_no": <?= $Page->yes_no->toClientList($Page) ?>,
            "fix": <?= $Page->fix->toClientList($Page) ?>,
            "unit": <?= $Page->unit->toClientList($Page) ?>,
            "extra_plan": <?= $Page->extra_plan->toClientList($Page) ?>,
            "method": <?= $Page->method->toClientList($Page) ?>,
            "category": <?= $Page->category->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fpp_verify_compiledsearch" id="fpp_verify_compiledsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="pp_verify_compiled">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_pp_verify_compiled_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_pp_verify_compiled_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="pp_verify_compiled" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pid->Visible) { // pid ?>
    <div id="r_pid" class="row"<?= $Page->pid->rowAttributes() ?>>
        <label for="x_pid" class="<?= $Page->LeftColumnClass ?>"><span id="elh_pp_verify_compiled_pid"><?= $Page->pid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pid" id="z_pid" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_pp_verify_compiled_pid" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pid->getInputTextType() ?>" name="x_pid" id="x_pid" data-table="pp_verify_compiled" data-field="x_pid" value="<?= $Page->pid->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pid->formatPattern()) ?>"<?= $Page->pid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pid->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
    <div id="r_location" class="row"<?= $Page->location->rowAttributes() ?>>
        <label for="x_location" class="<?= $Page->LeftColumnClass ?>"><span id="elh_pp_verify_compiled_location"><?= $Page->location->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_location" id="z_location" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->location->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_pp_verify_compiled_location" class="ew-search-field ew-search-field-single">
    <select
        id="x_location[]"
        name="x_location[]"
        class="form-select ew-select<?= $Page->location->isInvalidClass() ?>"
        <?php if (!$Page->location->IsNativeSelect) { ?>
        data-select2-id="fpp_verify_compiledsearch_x_location[]"
        <?php } ?>
        data-table="pp_verify_compiled"
        data-field="x_location"
        multiple
        size="1"
        data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>"
        <?= $Page->location->editAttributes() ?>>
        <?= $Page->location->selectOptionListHtml("x_location[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->location->getErrorMessage(false) ?></div>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
<?php if (!$Page->location->IsNativeSelect) { ?>
<script>
loadjs.ready("fpp_verify_compiledsearch", function() {
    var options = { name: "x_location[]", selectId: "fpp_verify_compiledsearch_x_location[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpp_verify_compiledsearch.lists.location?.lookupOptions.length) {
        options.data = { id: "x_location[]", form: "fpp_verify_compiledsearch" };
    } else {
        options.ajax = { id: "x_location[]", form: "fpp_verify_compiledsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.pp_verify_compiled.fields.location.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product_type->Visible) { // product_type ?>
    <div id="r_product_type" class="row"<?= $Page->product_type->rowAttributes() ?>>
        <label for="x_product_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_pp_verify_compiled_product_type"><?= $Page->product_type->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_product_type" id="z_product_type" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->product_type->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->product_type->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_pp_verify_compiled_product_type" class="ew-search-field">
    <select
        id="x_product_type[]"
        name="x_product_type[]"
        class="form-select ew-select<?= $Page->product_type->isInvalidClass() ?>"
        <?php if (!$Page->product_type->IsNativeSelect) { ?>
        data-select2-id="fpp_verify_compiledsearch_x_product_type[]"
        <?php } ?>
        data-table="pp_verify_compiled"
        data-field="x_product_type"
        multiple
        size="1"
        data-value-separator="<?= $Page->product_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product_type->getPlaceHolder()) ?>"
        <?= $Page->product_type->editAttributes() ?>>
        <?= $Page->product_type->selectOptionListHtml("x_product_type[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product_type->getErrorMessage(false) ?></div>
<?= $Page->product_type->Lookup->getParamTag($Page, "p_x_product_type") ?>
<?php if (!$Page->product_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpp_verify_compiledsearch", function() {
    var options = { name: "x_product_type[]", selectId: "fpp_verify_compiledsearch_x_product_type[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpp_verify_compiledsearch.lists.product_type?.lookupOptions.length) {
        options.data = { id: "x_product_type[]", form: "fpp_verify_compiledsearch" };
    } else {
        options.ajax = { id: "x_product_type[]", form: "fpp_verify_compiledsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.pp_verify_compiled.fields.product_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_pp_verify_compiled_product_type" class="ew-search-field2 d-none">
    <select
        id="y_product_type[]"
        name="y_product_type[]"
        class="form-select ew-select<?= $Page->product_type->isInvalidClass() ?>"
        <?php if (!$Page->product_type->IsNativeSelect) { ?>
        data-select2-id="fpp_verify_compiledsearch_y_product_type[]"
        <?php } ?>
        data-table="pp_verify_compiled"
        data-field="x_product_type"
        multiple
        size="1"
        data-value-separator="<?= $Page->product_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product_type->getPlaceHolder()) ?>"
        <?= $Page->product_type->editAttributes() ?>>
        <?= $Page->product_type->selectOptionListHtml("y_product_type[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product_type->getErrorMessage(false) ?></div>
<?= $Page->product_type->Lookup->getParamTag($Page, "p_y_product_type") ?>
<?php if (!$Page->product_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpp_verify_compiledsearch", function() {
    var options = { name: "y_product_type[]", selectId: "fpp_verify_compiledsearch_y_product_type[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpp_verify_compiledsearch.lists.product_type?.lookupOptions.length) {
        options.data = { id: "y_product_type[]", form: "fpp_verify_compiledsearch" };
    } else {
        options.ajax = { id: "y_product_type[]", form: "fpp_verify_compiledsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.pp_verify_compiled.fields.product_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->shape->Visible) { // shape ?>
    <div id="r_shape" class="row"<?= $Page->shape->rowAttributes() ?>>
        <label for="x_shape" class="<?= $Page->LeftColumnClass ?>"><span id="elh_pp_verify_compiled_shape"><?= $Page->shape->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_shape" id="z_shape" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->shape->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_pp_verify_compiled_shape" class="ew-search-field ew-search-field-single">
    <select
        id="x_shape[]"
        name="x_shape[]"
        class="form-select ew-select<?= $Page->shape->isInvalidClass() ?>"
        <?php if (!$Page->shape->IsNativeSelect) { ?>
        data-select2-id="fpp_verify_compiledsearch_x_shape[]"
        <?php } ?>
        data-table="pp_verify_compiled"
        data-field="x_shape"
        multiple
        size="1"
        data-value-separator="<?= $Page->shape->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->shape->getPlaceHolder()) ?>"
        <?= $Page->shape->editAttributes() ?>>
        <?= $Page->shape->selectOptionListHtml("x_shape[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->shape->getErrorMessage(false) ?></div>
<?= $Page->shape->Lookup->getParamTag($Page, "p_x_shape") ?>
<?php if (!$Page->shape->IsNativeSelect) { ?>
<script>
loadjs.ready("fpp_verify_compiledsearch", function() {
    var options = { name: "x_shape[]", selectId: "fpp_verify_compiledsearch_x_shape[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpp_verify_compiledsearch.lists.shape?.lookupOptions.length) {
        options.data = { id: "x_shape[]", form: "fpp_verify_compiledsearch" };
    } else {
        options.ajax = { id: "x_shape[]", form: "fpp_verify_compiledsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.pp_verify_compiled.fields.shape.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->plan_type->Visible) { // plan_type ?>
    <div id="r_plan_type" class="row"<?= $Page->plan_type->rowAttributes() ?>>
        <label for="x_plan_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_pp_verify_compiled_plan_type"><?= $Page->plan_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_plan_type" id="z_plan_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->plan_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_pp_verify_compiled_plan_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_plan_type[]"
        name="x_plan_type[]"
        class="form-select ew-select<?= $Page->plan_type->isInvalidClass() ?>"
        <?php if (!$Page->plan_type->IsNativeSelect) { ?>
        data-select2-id="fpp_verify_compiledsearch_x_plan_type[]"
        <?php } ?>
        data-table="pp_verify_compiled"
        data-field="x_plan_type"
        multiple
        size="1"
        data-value-separator="<?= $Page->plan_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->plan_type->getPlaceHolder()) ?>"
        <?= $Page->plan_type->editAttributes() ?>>
        <?= $Page->plan_type->selectOptionListHtml("x_plan_type[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->plan_type->getErrorMessage(false) ?></div>
<?php if (!$Page->plan_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpp_verify_compiledsearch", function() {
    var options = { name: "x_plan_type[]", selectId: "fpp_verify_compiledsearch_x_plan_type[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpp_verify_compiledsearch.lists.plan_type?.lookupOptions.length) {
        options.data = { id: "x_plan_type[]", form: "fpp_verify_compiledsearch" };
    } else {
        options.ajax = { id: "x_plan_type[]", form: "fpp_verify_compiledsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.pp_verify_compiled.fields.plan_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->gcode->Visible) { // gcode ?>
    <div id="r_gcode" class="row"<?= $Page->gcode->rowAttributes() ?>>
        <label for="x_gcode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_pp_verify_compiled_gcode"><?= $Page->gcode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_gcode" id="z_gcode" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->gcode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_pp_verify_compiled_gcode" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->gcode->getInputTextType() ?>" name="x_gcode" id="x_gcode" data-table="pp_verify_compiled" data-field="x_gcode" value="<?= $Page->gcode->EditValue ?>" size="30" maxlength="8" placeholder="<?= HtmlEncode($Page->gcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->gcode->formatPattern()) ?>"<?= $Page->gcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->gcode->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->design_id->Visible) { // design_id ?>
    <div id="r_design_id" class="row"<?= $Page->design_id->rowAttributes() ?>>
        <label for="x_design_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_pp_verify_compiled_design_id"><?= $Page->design_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_design_id" id="z_design_id" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->design_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_pp_verify_compiled_design_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->design_id->getInputTextType() ?>" name="x_design_id" id="x_design_id" data-table="pp_verify_compiled" data-field="x_design_id" value="<?= $Page->design_id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->design_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->design_id->formatPattern()) ?>"<?= $Page->design_id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->design_id->getErrorMessage(false) ?></div>
<?= $Page->design_id->Lookup->getParamTag($Page, "p_x_design_id") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->process->Visible) { // process ?>
    <div id="r_process" class="row"<?= $Page->process->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_pp_verify_compiled_process"><?= $Page->process->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_process" id="z_process" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->process->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_pp_verify_compiled_process" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->process->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_process" class="ew-auto-suggest">
    <input type="<?= $Page->process->getInputTextType() ?>" class="form-control" name="sv_x_process" id="sv_x_process" value="<?= RemoveHtml($Page->process->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->process->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->process->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->process->formatPattern()) ?>"<?= $Page->process->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="pp_verify_compiled" data-field="x_process" data-input="sv_x_process" data-value-separator="<?= $Page->process->displayValueSeparatorAttribute() ?>" name="x_process" id="x_process" value="<?= HtmlEncode($Page->process->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->process->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fpp_verify_compiledsearch", function() {
    fpp_verify_compiledsearch.createAutoSuggest(Object.assign({"id":"x_process","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->process->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.pp_verify_compiled.fields.process.autoSuggestOptions));
});
</script>
<?= $Page->process->Lookup->getParamTag($Page, "p_x_process") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->yes_no->Visible) { // yes_no ?>
    <div id="r_yes_no" class="row"<?= $Page->yes_no->rowAttributes() ?>>
        <label for="x_yes_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_pp_verify_compiled_yes_no"><?= $Page->yes_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_yes_no" id="z_yes_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->yes_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_pp_verify_compiled_yes_no" class="ew-search-field ew-search-field-single">
    <select
        id="x_yes_no[]"
        name="x_yes_no[]"
        class="form-select ew-select<?= $Page->yes_no->isInvalidClass() ?>"
        <?php if (!$Page->yes_no->IsNativeSelect) { ?>
        data-select2-id="fpp_verify_compiledsearch_x_yes_no[]"
        <?php } ?>
        data-table="pp_verify_compiled"
        data-field="x_yes_no"
        multiple
        size="1"
        data-value-separator="<?= $Page->yes_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->yes_no->getPlaceHolder()) ?>"
        <?= $Page->yes_no->editAttributes() ?>>
        <?= $Page->yes_no->selectOptionListHtml("x_yes_no[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->yes_no->getErrorMessage(false) ?></div>
<?php if (!$Page->yes_no->IsNativeSelect) { ?>
<script>
loadjs.ready("fpp_verify_compiledsearch", function() {
    var options = { name: "x_yes_no[]", selectId: "fpp_verify_compiledsearch_x_yes_no[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpp_verify_compiledsearch.lists.yes_no?.lookupOptions.length) {
        options.data = { id: "x_yes_no[]", form: "fpp_verify_compiledsearch" };
    } else {
        options.ajax = { id: "x_yes_no[]", form: "fpp_verify_compiledsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.pp_verify_compiled.fields.yes_no.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->fix->Visible) { // fix ?>
    <div id="r_fix" class="row"<?= $Page->fix->rowAttributes() ?>>
        <label for="x_fix" class="<?= $Page->LeftColumnClass ?>"><span id="elh_pp_verify_compiled_fix"><?= $Page->fix->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_fix" id="z_fix" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->fix->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_pp_verify_compiled_fix" class="ew-search-field ew-search-field-single">
    <select
        id="x_fix[]"
        name="x_fix[]"
        class="form-select ew-select<?= $Page->fix->isInvalidClass() ?>"
        <?php if (!$Page->fix->IsNativeSelect) { ?>
        data-select2-id="fpp_verify_compiledsearch_x_fix[]"
        <?php } ?>
        data-table="pp_verify_compiled"
        data-field="x_fix"
        multiple
        size="1"
        data-value-separator="<?= $Page->fix->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->fix->getPlaceHolder()) ?>"
        <?= $Page->fix->editAttributes() ?>>
        <?= $Page->fix->selectOptionListHtml("x_fix[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->fix->getErrorMessage(false) ?></div>
<?php if (!$Page->fix->IsNativeSelect) { ?>
<script>
loadjs.ready("fpp_verify_compiledsearch", function() {
    var options = { name: "x_fix[]", selectId: "fpp_verify_compiledsearch_x_fix[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpp_verify_compiledsearch.lists.fix?.lookupOptions.length) {
        options.data = { id: "x_fix[]", form: "fpp_verify_compiledsearch" };
    } else {
        options.ajax = { id: "x_fix[]", form: "fpp_verify_compiledsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.pp_verify_compiled.fields.fix.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->unit->Visible) { // unit ?>
    <div id="r_unit" class="row"<?= $Page->unit->rowAttributes() ?>>
        <label for="x_unit" class="<?= $Page->LeftColumnClass ?>"><span id="elh_pp_verify_compiled_unit"><?= $Page->unit->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_unit" id="z_unit" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->unit->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_pp_verify_compiled_unit" class="ew-search-field ew-search-field-single">
    <select
        id="x_unit[]"
        name="x_unit[]"
        class="form-select ew-select<?= $Page->unit->isInvalidClass() ?>"
        <?php if (!$Page->unit->IsNativeSelect) { ?>
        data-select2-id="fpp_verify_compiledsearch_x_unit[]"
        <?php } ?>
        data-table="pp_verify_compiled"
        data-field="x_unit"
        multiple
        size="1"
        data-value-separator="<?= $Page->unit->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->unit->getPlaceHolder()) ?>"
        <?= $Page->unit->editAttributes() ?>>
        <?= $Page->unit->selectOptionListHtml("x_unit[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->unit->getErrorMessage(false) ?></div>
<?php if (!$Page->unit->IsNativeSelect) { ?>
<script>
loadjs.ready("fpp_verify_compiledsearch", function() {
    var options = { name: "x_unit[]", selectId: "fpp_verify_compiledsearch_x_unit[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpp_verify_compiledsearch.lists.unit?.lookupOptions.length) {
        options.data = { id: "x_unit[]", form: "fpp_verify_compiledsearch" };
    } else {
        options.ajax = { id: "x_unit[]", form: "fpp_verify_compiledsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.pp_verify_compiled.fields.unit.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_unit->Visible) { // @unit ?>
    <div id="r__unit" class="row"<?= $Page->_unit->rowAttributes() ?>>
        <label for="x__unit" class="<?= $Page->LeftColumnClass ?>"><span id="elh_pp_verify_compiled__unit"><?= $Page->_unit->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__unit" id="z__unit" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_unit->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_pp_verify_compiled__unit" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_unit->getInputTextType() ?>" name="x__unit" id="x__unit" data-table="pp_verify_compiled" data-field="x__unit" value="<?= $Page->_unit->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_unit->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_unit->formatPattern()) ?>"<?= $Page->_unit->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_unit->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_40->Visible) { // @ ?>
    <div id="r__40" class="row"<?= $Page->_40->rowAttributes() ?>>
        <label for="x__40" class="<?= $Page->LeftColumnClass ?>"><span id="elh_pp_verify_compiled__40"><?= $Page->_40->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__40" id="z__40" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_40->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_pp_verify_compiled__40" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_40->getInputTextType() ?>" name="x__40" id="x__40" data-table="pp_verify_compiled" data-field="x__40" value="<?= $Page->_40->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_40->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_40->formatPattern()) ?>"<?= $Page->_40->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_40->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->extra_plan->Visible) { // extra_plan ?>
    <div id="r_extra_plan" class="row"<?= $Page->extra_plan->rowAttributes() ?>>
        <label for="x_extra_plan" class="<?= $Page->LeftColumnClass ?>"><span id="elh_pp_verify_compiled_extra_plan"><?= $Page->extra_plan->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_extra_plan" id="z_extra_plan" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->extra_plan->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_pp_verify_compiled_extra_plan" class="ew-search-field ew-search-field-single">
    <select
        id="x_extra_plan[]"
        name="x_extra_plan[]"
        class="form-select ew-select<?= $Page->extra_plan->isInvalidClass() ?>"
        <?php if (!$Page->extra_plan->IsNativeSelect) { ?>
        data-select2-id="fpp_verify_compiledsearch_x_extra_plan[]"
        <?php } ?>
        data-table="pp_verify_compiled"
        data-field="x_extra_plan"
        multiple
        size="1"
        data-value-separator="<?= $Page->extra_plan->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->extra_plan->getPlaceHolder()) ?>"
        <?= $Page->extra_plan->editAttributes() ?>>
        <?= $Page->extra_plan->selectOptionListHtml("x_extra_plan[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->extra_plan->getErrorMessage(false) ?></div>
<?php if (!$Page->extra_plan->IsNativeSelect) { ?>
<script>
loadjs.ready("fpp_verify_compiledsearch", function() {
    var options = { name: "x_extra_plan[]", selectId: "fpp_verify_compiledsearch_x_extra_plan[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpp_verify_compiledsearch.lists.extra_plan?.lookupOptions.length) {
        options.data = { id: "x_extra_plan[]", form: "fpp_verify_compiledsearch" };
    } else {
        options.ajax = { id: "x_extra_plan[]", form: "fpp_verify_compiledsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.pp_verify_compiled.fields.extra_plan.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->custom_size->Visible) { // custom_size ?>
    <div id="r_custom_size" class="row"<?= $Page->custom_size->rowAttributes() ?>>
        <label for="x_custom_size" class="<?= $Page->LeftColumnClass ?>"><span id="elh_pp_verify_compiled_custom_size"><?= $Page->custom_size->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_custom_size" id="z_custom_size" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->custom_size->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_pp_verify_compiled_custom_size" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->custom_size->getInputTextType() ?>" name="x_custom_size" id="x_custom_size" data-table="pp_verify_compiled" data-field="x_custom_size" value="<?= $Page->custom_size->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->custom_size->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->custom_size->formatPattern()) ?>"<?= $Page->custom_size->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->custom_size->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->custom_size_below_st->Visible) { // custom_size_below_st ?>
    <div id="r_custom_size_below_st" class="row"<?= $Page->custom_size_below_st->rowAttributes() ?>>
        <label for="x_custom_size_below_st" class="<?= $Page->LeftColumnClass ?>"><span id="elh_pp_verify_compiled_custom_size_below_st"><?= $Page->custom_size_below_st->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_custom_size_below_st" id="z_custom_size_below_st" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->custom_size_below_st->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_pp_verify_compiled_custom_size_below_st" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->custom_size_below_st->getInputTextType() ?>" name="x_custom_size_below_st" id="x_custom_size_below_st" data-table="pp_verify_compiled" data-field="x_custom_size_below_st" value="<?= $Page->custom_size_below_st->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->custom_size_below_st->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->custom_size_below_st->formatPattern()) ?>"<?= $Page->custom_size_below_st->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->custom_size_below_st->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->method->Visible) { // method ?>
    <div id="r_method" class="row"<?= $Page->method->rowAttributes() ?>>
        <label for="x_method" class="<?= $Page->LeftColumnClass ?>"><span id="elh_pp_verify_compiled_method"><?= $Page->method->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_method" id="z_method" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->method->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_pp_verify_compiled_method" class="ew-search-field ew-search-field-single">
    <select
        id="x_method[]"
        name="x_method[]"
        class="form-select ew-select<?= $Page->method->isInvalidClass() ?>"
        <?php if (!$Page->method->IsNativeSelect) { ?>
        data-select2-id="fpp_verify_compiledsearch_x_method[]"
        <?php } ?>
        data-table="pp_verify_compiled"
        data-field="x_method"
        multiple
        size="1"
        data-value-separator="<?= $Page->method->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->method->getPlaceHolder()) ?>"
        <?= $Page->method->editAttributes() ?>>
        <?= $Page->method->selectOptionListHtml("x_method[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->method->getErrorMessage(false) ?></div>
<?= $Page->method->Lookup->getParamTag($Page, "p_x_method") ?>
<?php if (!$Page->method->IsNativeSelect) { ?>
<script>
loadjs.ready("fpp_verify_compiledsearch", function() {
    var options = { name: "x_method[]", selectId: "fpp_verify_compiledsearch_x_method[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpp_verify_compiledsearch.lists.method?.lookupOptions.length) {
        options.data = { id: "x_method[]", form: "fpp_verify_compiledsearch" };
    } else {
        options.ajax = { id: "x_method[]", form: "fpp_verify_compiledsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.pp_verify_compiled.fields.method.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
    <div id="r_category" class="row"<?= $Page->category->rowAttributes() ?>>
        <label for="x_category" class="<?= $Page->LeftColumnClass ?>"><span id="elh_pp_verify_compiled_category"><?= $Page->category->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_category" id="z_category" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->category->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_pp_verify_compiled_category" class="ew-search-field ew-search-field-single">
    <select
        id="x_category[]"
        name="x_category[]"
        class="form-select ew-select<?= $Page->category->isInvalidClass() ?>"
        <?php if (!$Page->category->IsNativeSelect) { ?>
        data-select2-id="fpp_verify_compiledsearch_x_category[]"
        <?php } ?>
        data-table="pp_verify_compiled"
        data-field="x_category"
        multiple
        size="1"
        data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->category->getPlaceHolder()) ?>"
        <?= $Page->category->editAttributes() ?>>
        <?= $Page->category->selectOptionListHtml("x_category[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->category->getErrorMessage(false) ?></div>
<?= $Page->category->Lookup->getParamTag($Page, "p_x_category") ?>
<?php if (!$Page->category->IsNativeSelect) { ?>
<script>
loadjs.ready("fpp_verify_compiledsearch", function() {
    var options = { name: "x_category[]", selectId: "fpp_verify_compiledsearch_x_category[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpp_verify_compiledsearch.lists.category?.lookupOptions.length) {
        options.data = { id: "x_category[]", form: "fpp_verify_compiledsearch" };
    } else {
        options.ajax = { id: "x_category[]", form: "fpp_verify_compiledsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.pp_verify_compiled.fields.category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fpp_verify_compiledsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpp_verify_compiledsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fpp_verify_compiledsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("pp_verify_compiled");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
