<?php

namespace PHPMaker2024\fibre;

// Page object
$PortalVersionSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { portal_version: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fportal_versionsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fportal_versionsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["version", [], fields.version.isInvalid],
            ["php_code", [], fields.php_code.isInvalid],
            ["portal_d_php_code", [], fields.portal_d_php_code.isInvalid],
            ["portal_d_apc_query", [], fields.portal_d_apc_query.isInvalid],
            ["portal_d_mysql_query", [], fields.portal_d_mysql_query.isInvalid],
            ["portal_d_sp_query", [], fields.portal_d_sp_query.isInvalid],
            ["portal_d_url_link", [], fields.portal_d_url_link.isInvalid],
            ["portal_c_php_code", [], fields.portal_c_php_code.isInvalid],
            ["mysql_query", [], fields.mysql_query.isInvalid],
            ["portal_c_mysql_query", [], fields.portal_c_mysql_query.isInvalid],
            ["sp_query", [], fields.sp_query.isInvalid],
            ["portal_c_sp_query", [], fields.portal_c_sp_query.isInvalid],
            ["apc_query", [], fields.apc_query.isInvalid],
            ["portal_c_apc_query", [], fields.portal_c_apc_query.isInvalid],
            ["url_link", [], fields.url_link.isInvalid],
            ["u_type", [ew.Validators.integer], fields.u_type.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "portal_c_php_code": <?= $Page->portal_c_php_code->toClientList($Page) ?>,
            "portal_c_mysql_query": <?= $Page->portal_c_mysql_query->toClientList($Page) ?>,
            "portal_c_sp_query": <?= $Page->portal_c_sp_query->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fportal_versionsearch" id="fportal_versionsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="portal_version">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="ew-nav<?= $Page->MultiPages->containerClasses() ?>" id="pages_PortalVersionSearch"><!-- multi-page tabs -->
    <ul class="<?= $Page->MultiPages->navClasses() ?>" role="tablist">
        <li class="nav-item"><button class="<?= $Page->MultiPages->navLinkClasses(1) ?>" data-bs-target="#tab_portal_version1" data-bs-toggle="tab" type="button" role="tab" aria-controls="tab_portal_version1" aria-selected="<?= JsonEncode($Page->MultiPages->isActive(1)) ?>"><?= $Page->pageCaption(1) ?></button></li>
        <li class="nav-item"><button class="<?= $Page->MultiPages->navLinkClasses(2) ?>" data-bs-target="#tab_portal_version2" data-bs-toggle="tab" type="button" role="tab" aria-controls="tab_portal_version2" aria-selected="<?= JsonEncode($Page->MultiPages->isActive(2)) ?>"><?= $Page->pageCaption(2) ?></button></li>
        <li class="nav-item"><button class="<?= $Page->MultiPages->navLinkClasses(3) ?>" data-bs-target="#tab_portal_version3" data-bs-toggle="tab" type="button" role="tab" aria-controls="tab_portal_version3" aria-selected="<?= JsonEncode($Page->MultiPages->isActive(3)) ?>"><?= $Page->pageCaption(3) ?></button></li>
        <li class="nav-item"><button class="<?= $Page->MultiPages->navLinkClasses(4) ?>" data-bs-target="#tab_portal_version4" data-bs-toggle="tab" type="button" role="tab" aria-controls="tab_portal_version4" aria-selected="<?= JsonEncode($Page->MultiPages->isActive(4)) ?>"><?= $Page->pageCaption(4) ?></button></li>
        <li class="nav-item"><button class="<?= $Page->MultiPages->navLinkClasses(5) ?>" data-bs-target="#tab_portal_version5" data-bs-toggle="tab" type="button" role="tab" aria-controls="tab_portal_version5" aria-selected="<?= JsonEncode($Page->MultiPages->isActive(5)) ?>"><?= $Page->pageCaption(5) ?></button></li>
    </ul>
    <div class="<?= $Page->MultiPages->tabContentClasses() ?>"><!-- multi-page tabs .tab-content -->
        <div class="<?= $Page->MultiPages->tabPaneClasses(1) ?>" id="tab_portal_version1" role="tabpanel"><!-- multi-page .tab-pane -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_portal_version_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_portal_version_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="portal_version" data-field="x_id" value="<?= $Page->id->EditValue ?>" data-page="1" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_portal_version_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_portal_version_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="portal_version" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" data-page="1" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fportal_versionsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fportal_versionsearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->version->Visible) { // version ?>
    <div id="r_version" class="row"<?= $Page->version->rowAttributes() ?>>
        <label for="x_version" class="<?= $Page->LeftColumnClass ?>"><span id="elh_portal_version_version"><?= $Page->version->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_version" id="z_version" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->version->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_portal_version_version" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->version->getInputTextType() ?>" name="x_version" id="x_version" data-table="portal_version" data-field="x_version" value="<?= $Page->version->EditValue ?>" data-page="1" size="30" maxlength="12" placeholder="<?= HtmlEncode($Page->version->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->version->formatPattern()) ?>"<?= $Page->version->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->version->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->php_code->Visible) { // php_code ?>
    <div id="r_php_code" class="row"<?= $Page->php_code->rowAttributes() ?>>
        <label for="x_php_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_portal_version_php_code"><?= $Page->php_code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_php_code" id="z_php_code" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->php_code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_portal_version_php_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->php_code->getInputTextType() ?>" name="x_php_code" id="x_php_code" data-table="portal_version" data-field="x_php_code" value="<?= $Page->php_code->EditValue ?>" data-page="1" size="30" maxlength="200" placeholder="<?= HtmlEncode($Page->php_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->php_code->formatPattern()) ?>"<?= $Page->php_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->php_code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->portal_d_php_code->Visible) { // portal_d_php_code ?>
    <div id="r_portal_d_php_code" class="row"<?= $Page->portal_d_php_code->rowAttributes() ?>>
        <label for="x_portal_d_php_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_portal_version_portal_d_php_code"><?= $Page->portal_d_php_code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_portal_d_php_code" id="z_portal_d_php_code" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->portal_d_php_code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_portal_version_portal_d_php_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->portal_d_php_code->getInputTextType() ?>" name="x_portal_d_php_code" id="x_portal_d_php_code" data-table="portal_version" data-field="x_portal_d_php_code" value="<?= $Page->portal_d_php_code->EditValue ?>" data-page="1" maxlength="65535" placeholder="<?= HtmlEncode($Page->portal_d_php_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->portal_d_php_code->formatPattern()) ?>"<?= $Page->portal_d_php_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->portal_d_php_code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->portal_c_php_code->Visible) { // portal_c_php_code ?>
    <div id="r_portal_c_php_code" class="row"<?= $Page->portal_c_php_code->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_portal_version_portal_c_php_code"><?= $Page->portal_c_php_code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_portal_c_php_code" id="z_portal_c_php_code" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->portal_c_php_code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_portal_version_portal_c_php_code" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->portal_c_php_code->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_portal_c_php_code" class="ew-auto-suggest">
    <input type="<?= $Page->portal_c_php_code->getInputTextType() ?>" class="form-control" name="sv_x_portal_c_php_code" id="sv_x_portal_c_php_code" value="<?= RemoveHtml($Page->portal_c_php_code->EditValue) ?>" autocomplete="off" maxlength="1000" placeholder="<?= HtmlEncode($Page->portal_c_php_code->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->portal_c_php_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->portal_c_php_code->formatPattern()) ?>"<?= $Page->portal_c_php_code->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="portal_version" data-field="x_portal_c_php_code" data-input="sv_x_portal_c_php_code" data-page="1" data-value-separator="<?= $Page->portal_c_php_code->displayValueSeparatorAttribute() ?>" name="x_portal_c_php_code" id="x_portal_c_php_code" value="<?= HtmlEncode($Page->portal_c_php_code->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->portal_c_php_code->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fportal_versionsearch", function() {
    fportal_versionsearch.createAutoSuggest(Object.assign({"id":"x_portal_c_php_code","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->portal_c_php_code->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.portal_version.fields.portal_c_php_code.autoSuggestOptions));
});
</script>
<?= $Page->portal_c_php_code->Lookup->getParamTag($Page, "p_x_portal_c_php_code") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
        </div><!-- /multi-page .tab-pane -->
        <div class="<?= $Page->MultiPages->tabPaneClasses(2) ?>" id="tab_portal_version2" role="tabpanel"><!-- multi-page .tab-pane -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->portal_d_mysql_query->Visible) { // portal_d_mysql_query ?>
    <div id="r_portal_d_mysql_query" class="row"<?= $Page->portal_d_mysql_query->rowAttributes() ?>>
        <label for="x_portal_d_mysql_query" class="<?= $Page->LeftColumnClass ?>"><span id="elh_portal_version_portal_d_mysql_query"><?= $Page->portal_d_mysql_query->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_portal_d_mysql_query" id="z_portal_d_mysql_query" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->portal_d_mysql_query->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_portal_version_portal_d_mysql_query" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->portal_d_mysql_query->getInputTextType() ?>" name="x_portal_d_mysql_query" id="x_portal_d_mysql_query" data-table="portal_version" data-field="x_portal_d_mysql_query" value="<?= $Page->portal_d_mysql_query->EditValue ?>" data-page="2" placeholder="<?= HtmlEncode($Page->portal_d_mysql_query->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->portal_d_mysql_query->formatPattern()) ?>"<?= $Page->portal_d_mysql_query->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->portal_d_mysql_query->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->mysql_query->Visible) { // mysql_query ?>
    <div id="r_mysql_query" class="row"<?= $Page->mysql_query->rowAttributes() ?>>
        <label for="x_mysql_query" class="<?= $Page->LeftColumnClass ?>"><span id="elh_portal_version_mysql_query"><?= $Page->mysql_query->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_mysql_query" id="z_mysql_query" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->mysql_query->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_portal_version_mysql_query" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->mysql_query->getInputTextType() ?>" name="x_mysql_query" id="x_mysql_query" data-table="portal_version" data-field="x_mysql_query" value="<?= $Page->mysql_query->EditValue ?>" data-page="2" size="35" maxlength="65535" placeholder="<?= HtmlEncode($Page->mysql_query->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mysql_query->formatPattern()) ?>"<?= $Page->mysql_query->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->mysql_query->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->portal_c_mysql_query->Visible) { // portal_c_mysql_query ?>
    <div id="r_portal_c_mysql_query" class="row"<?= $Page->portal_c_mysql_query->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_portal_version_portal_c_mysql_query"><?= $Page->portal_c_mysql_query->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_portal_c_mysql_query" id="z_portal_c_mysql_query" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->portal_c_mysql_query->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_portal_version_portal_c_mysql_query" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->portal_c_mysql_query->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_portal_c_mysql_query" class="ew-auto-suggest">
    <input type="<?= $Page->portal_c_mysql_query->getInputTextType() ?>" class="form-control" name="sv_x_portal_c_mysql_query" id="sv_x_portal_c_mysql_query" value="<?= RemoveHtml($Page->portal_c_mysql_query->EditValue) ?>" autocomplete="off" maxlength="1000" placeholder="<?= HtmlEncode($Page->portal_c_mysql_query->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->portal_c_mysql_query->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->portal_c_mysql_query->formatPattern()) ?>"<?= $Page->portal_c_mysql_query->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="portal_version" data-field="x_portal_c_mysql_query" data-input="sv_x_portal_c_mysql_query" data-page="2" data-value-separator="<?= $Page->portal_c_mysql_query->displayValueSeparatorAttribute() ?>" name="x_portal_c_mysql_query" id="x_portal_c_mysql_query" value="<?= HtmlEncode($Page->portal_c_mysql_query->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->portal_c_mysql_query->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fportal_versionsearch", function() {
    fportal_versionsearch.createAutoSuggest(Object.assign({"id":"x_portal_c_mysql_query","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->portal_c_mysql_query->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.portal_version.fields.portal_c_mysql_query.autoSuggestOptions));
});
</script>
<?= $Page->portal_c_mysql_query->Lookup->getParamTag($Page, "p_x_portal_c_mysql_query") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
        </div><!-- /multi-page .tab-pane -->
        <div class="<?= $Page->MultiPages->tabPaneClasses(3) ?>" id="tab_portal_version3" role="tabpanel"><!-- multi-page .tab-pane -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->portal_d_sp_query->Visible) { // portal_d_sp_query ?>
    <div id="r_portal_d_sp_query" class="row"<?= $Page->portal_d_sp_query->rowAttributes() ?>>
        <label for="x_portal_d_sp_query" class="<?= $Page->LeftColumnClass ?>"><span id="elh_portal_version_portal_d_sp_query"><?= $Page->portal_d_sp_query->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_portal_d_sp_query" id="z_portal_d_sp_query" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->portal_d_sp_query->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_portal_version_portal_d_sp_query" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->portal_d_sp_query->getInputTextType() ?>" name="x_portal_d_sp_query" id="x_portal_d_sp_query" data-table="portal_version" data-field="x_portal_d_sp_query" value="<?= $Page->portal_d_sp_query->EditValue ?>" data-page="3" placeholder="<?= HtmlEncode($Page->portal_d_sp_query->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->portal_d_sp_query->formatPattern()) ?>"<?= $Page->portal_d_sp_query->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->portal_d_sp_query->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sp_query->Visible) { // sp_query ?>
    <div id="r_sp_query" class="row"<?= $Page->sp_query->rowAttributes() ?>>
        <label for="x_sp_query" class="<?= $Page->LeftColumnClass ?>"><span id="elh_portal_version_sp_query"><?= $Page->sp_query->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_sp_query" id="z_sp_query" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sp_query->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_portal_version_sp_query" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sp_query->getInputTextType() ?>" name="x_sp_query" id="x_sp_query" data-table="portal_version" data-field="x_sp_query" value="<?= $Page->sp_query->EditValue ?>" data-page="3" size="35" maxlength="65535" placeholder="<?= HtmlEncode($Page->sp_query->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sp_query->formatPattern()) ?>"<?= $Page->sp_query->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sp_query->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->portal_c_sp_query->Visible) { // portal_c_sp_query ?>
    <div id="r_portal_c_sp_query" class="row"<?= $Page->portal_c_sp_query->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_portal_version_portal_c_sp_query"><?= $Page->portal_c_sp_query->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_portal_c_sp_query" id="z_portal_c_sp_query" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->portal_c_sp_query->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_portal_version_portal_c_sp_query" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->portal_c_sp_query->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_portal_c_sp_query" class="ew-auto-suggest">
    <input type="<?= $Page->portal_c_sp_query->getInputTextType() ?>" class="form-control" name="sv_x_portal_c_sp_query" id="sv_x_portal_c_sp_query" value="<?= RemoveHtml($Page->portal_c_sp_query->EditValue) ?>" autocomplete="off" maxlength="1000" placeholder="<?= HtmlEncode($Page->portal_c_sp_query->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->portal_c_sp_query->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->portal_c_sp_query->formatPattern()) ?>"<?= $Page->portal_c_sp_query->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="portal_version" data-field="x_portal_c_sp_query" data-input="sv_x_portal_c_sp_query" data-page="3" data-value-separator="<?= $Page->portal_c_sp_query->displayValueSeparatorAttribute() ?>" name="x_portal_c_sp_query" id="x_portal_c_sp_query" value="<?= HtmlEncode($Page->portal_c_sp_query->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->portal_c_sp_query->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fportal_versionsearch", function() {
    fportal_versionsearch.createAutoSuggest(Object.assign({"id":"x_portal_c_sp_query","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->portal_c_sp_query->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.portal_version.fields.portal_c_sp_query.autoSuggestOptions));
});
</script>
<?= $Page->portal_c_sp_query->Lookup->getParamTag($Page, "p_x_portal_c_sp_query") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
        </div><!-- /multi-page .tab-pane -->
        <div class="<?= $Page->MultiPages->tabPaneClasses(4) ?>" id="tab_portal_version4" role="tabpanel"><!-- multi-page .tab-pane -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->portal_d_apc_query->Visible) { // portal_d_apc_query ?>
    <div id="r_portal_d_apc_query" class="row"<?= $Page->portal_d_apc_query->rowAttributes() ?>>
        <label for="x_portal_d_apc_query" class="<?= $Page->LeftColumnClass ?>"><span id="elh_portal_version_portal_d_apc_query"><?= $Page->portal_d_apc_query->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_portal_d_apc_query" id="z_portal_d_apc_query" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->portal_d_apc_query->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_portal_version_portal_d_apc_query" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->portal_d_apc_query->getInputTextType() ?>" name="x_portal_d_apc_query" id="x_portal_d_apc_query" data-table="portal_version" data-field="x_portal_d_apc_query" value="<?= $Page->portal_d_apc_query->EditValue ?>" data-page="4" size="35" placeholder="<?= HtmlEncode($Page->portal_d_apc_query->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->portal_d_apc_query->formatPattern()) ?>"<?= $Page->portal_d_apc_query->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->portal_d_apc_query->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->apc_query->Visible) { // apc_query ?>
    <div id="r_apc_query" class="row"<?= $Page->apc_query->rowAttributes() ?>>
        <label for="x_apc_query" class="<?= $Page->LeftColumnClass ?>"><span id="elh_portal_version_apc_query"><?= $Page->apc_query->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_apc_query" id="z_apc_query" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->apc_query->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_portal_version_apc_query" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->apc_query->getInputTextType() ?>" name="x_apc_query" id="x_apc_query" data-table="portal_version" data-field="x_apc_query" value="<?= $Page->apc_query->EditValue ?>" data-page="4" size="35" placeholder="<?= HtmlEncode($Page->apc_query->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->apc_query->formatPattern()) ?>"<?= $Page->apc_query->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->apc_query->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->portal_c_apc_query->Visible) { // portal_c_apc_query ?>
    <div id="r_portal_c_apc_query" class="row"<?= $Page->portal_c_apc_query->rowAttributes() ?>>
        <label for="x_portal_c_apc_query" class="<?= $Page->LeftColumnClass ?>"><span id="elh_portal_version_portal_c_apc_query"><?= $Page->portal_c_apc_query->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_portal_c_apc_query" id="z_portal_c_apc_query" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->portal_c_apc_query->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_portal_version_portal_c_apc_query" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->portal_c_apc_query->getInputTextType() ?>" name="x_portal_c_apc_query" id="x_portal_c_apc_query" data-table="portal_version" data-field="x_portal_c_apc_query" value="<?= $Page->portal_c_apc_query->EditValue ?>" data-page="4" size="35" placeholder="<?= HtmlEncode($Page->portal_c_apc_query->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->portal_c_apc_query->formatPattern()) ?>"<?= $Page->portal_c_apc_query->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->portal_c_apc_query->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
        </div><!-- /multi-page .tab-pane -->
        <div class="<?= $Page->MultiPages->tabPaneClasses(5) ?>" id="tab_portal_version5" role="tabpanel"><!-- multi-page .tab-pane -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->portal_d_url_link->Visible) { // portal_d_url_link ?>
    <div id="r_portal_d_url_link" class="row"<?= $Page->portal_d_url_link->rowAttributes() ?>>
        <label for="x_portal_d_url_link" class="<?= $Page->LeftColumnClass ?>"><span id="elh_portal_version_portal_d_url_link"><?= $Page->portal_d_url_link->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_portal_d_url_link" id="z_portal_d_url_link" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->portal_d_url_link->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_portal_version_portal_d_url_link" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->portal_d_url_link->getInputTextType() ?>" name="x_portal_d_url_link" id="x_portal_d_url_link" data-table="portal_version" data-field="x_portal_d_url_link" value="<?= $Page->portal_d_url_link->EditValue ?>" data-page="5" size="35" maxlength="65535" placeholder="<?= HtmlEncode($Page->portal_d_url_link->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->portal_d_url_link->formatPattern()) ?>"<?= $Page->portal_d_url_link->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->portal_d_url_link->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->url_link->Visible) { // url_link ?>
    <div id="r_url_link" class="row"<?= $Page->url_link->rowAttributes() ?>>
        <label for="x_url_link" class="<?= $Page->LeftColumnClass ?>"><span id="elh_portal_version_url_link"><?= $Page->url_link->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_url_link" id="z_url_link" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->url_link->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_portal_version_url_link" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->url_link->getInputTextType() ?>" name="x_url_link" id="x_url_link" data-table="portal_version" data-field="x_url_link" value="<?= $Page->url_link->EditValue ?>" data-page="5" size="30" maxlength="196" placeholder="<?= HtmlEncode($Page->url_link->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->url_link->formatPattern()) ?>"<?= $Page->url_link->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->url_link->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->u_type->Visible) { // u_type ?>
    <div id="r_u_type" class="row"<?= $Page->u_type->rowAttributes() ?>>
        <label for="x_u_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_portal_version_u_type"><?= $Page->u_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_u_type" id="z_u_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->u_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_portal_version_u_type" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->u_type->getInputTextType() ?>" name="x_u_type" id="x_u_type" data-table="portal_version" data-field="x_u_type" value="<?= $Page->u_type->EditValue ?>" data-page="5" size="30" placeholder="<?= HtmlEncode($Page->u_type->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->u_type->formatPattern()) ?>"<?= $Page->u_type->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->u_type->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
        </div><!-- /multi-page .tab-pane -->
    </div><!-- /multi-page tabs .tab-content -->
</div><!-- /multi-page tabs -->
</div><!-- /multi-page -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fportal_versionsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fportal_versionsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fportal_versionsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("portal_version");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
