<?php

namespace PHPMaker2024\fibre;

// Page object
$PortalSetupEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<form name="fportal_setupedit" id="fportal_setupedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { portal_setup: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fportal_setupedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fportal_setupedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["url", [fields.url.visible && fields.url.required ? ew.Validators.required(fields.url.caption) : null], fields.url.isInvalid],
            ["admin_url", [fields.admin_url.visible && fields.admin_url.required ? ew.Validators.required(fields.admin_url.caption) : null], fields.admin_url.isInvalid],
            ["mail_code", [fields.mail_code.visible && fields.mail_code.required ? ew.Validators.required(fields.mail_code.caption) : null], fields.mail_code.isInvalid],
            ["footer_line", [fields.footer_line.visible && fields.footer_line.required ? ew.Validators.required(fields.footer_line.caption) : null], fields.footer_line.isInvalid],
            ["portal_category", [fields.portal_category.visible && fields.portal_category.required ? ew.Validators.required(fields.portal_category.caption) : null], fields.portal_category.isInvalid],
            ["mcu", [fields.mcu.visible && fields.mcu.required ? ew.Validators.required(fields.mcu.caption) : null, ew.Validators.integer], fields.mcu.isInvalid],
            ["fcm_server_key", [fields.fcm_server_key.visible && fields.fcm_server_key.required ? ew.Validators.required(fields.fcm_server_key.caption) : null], fields.fcm_server_key.isInvalid],
            ["app_version", [fields.app_version.visible && fields.app_version.required ? ew.Validators.required(fields.app_version.caption) : null, ew.Validators.integer], fields.app_version.isInvalid],
            ["pd_byepass", [fields.pd_byepass.visible && fields.pd_byepass.required ? ew.Validators.required(fields.pd_byepass.caption) : null], fields.pd_byepass.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null, ew.Validators.integer], fields.operator.isInvalid],
            ["google_map_api", [fields.google_map_api.visible && fields.google_map_api.required ? ew.Validators.required(fields.google_map_api.caption) : null], fields.google_map_api.isInvalid],
            ["material_payment_type", [fields.material_payment_type.visible && fields.material_payment_type.required ? ew.Validators.required(fields.material_payment_type.caption) : null, ew.Validators.integer], fields.material_payment_type.isInvalid],
            ["material_payment_varient", [fields.material_payment_varient.visible && fields.material_payment_varient.required ? ew.Validators.required(fields.material_payment_varient.caption) : null, ew.Validators.integer], fields.material_payment_varient.isInvalid],
            ["footer_line_be", [fields.footer_line_be.visible && fields.footer_line_be.required ? ew.Validators.required(fields.footer_line_be.caption) : null], fields.footer_line_be.isInvalid],
            ["allow_reg", [fields.allow_reg.visible && fields.allow_reg.required ? ew.Validators.required(fields.allow_reg.caption) : null, ew.Validators.integer], fields.allow_reg.isInvalid],
            ["login_remember", [fields.login_remember.visible && fields.login_remember.required ? ew.Validators.required(fields.login_remember.caption) : null, ew.Validators.integer], fields.login_remember.isInvalid],
            ["gp_p_check", [fields.gp_p_check.visible && fields.gp_p_check.required ? ew.Validators.required(fields.gp_p_check.caption) : null, ew.Validators.integer], fields.gp_p_check.isInvalid],
            ["fe_version", [fields.fe_version.visible && fields.fe_version.required ? ew.Validators.required(fields.fe_version.caption) : null], fields.fe_version.isInvalid],
            ["admin_version", [fields.admin_version.visible && fields.admin_version.required ? ew.Validators.required(fields.admin_version.caption) : null], fields.admin_version.isInvalid],
            ["_dashboard", [fields._dashboard.visible && fields._dashboard.required ? ew.Validators.required(fields._dashboard.caption) : null], fields._dashboard.isInvalid],
            ["developer_upi_id", [fields.developer_upi_id.visible && fields.developer_upi_id.required ? ew.Validators.required(fields.developer_upi_id.caption) : null], fields.developer_upi_id.isInvalid],
            ["developer_company", [fields.developer_company.visible && fields.developer_company.required ? ew.Validators.required(fields.developer_company.caption) : null], fields.developer_company.isInvalid],
            ["default_page", [fields.default_page.visible && fields.default_page.required ? ew.Validators.required(fields.default_page.caption) : null], fields.default_page.isInvalid],
            ["bom_edit", [fields.bom_edit.visible && fields.bom_edit.required ? ew.Validators.required(fields.bom_edit.caption) : null], fields.bom_edit.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "portal_category": <?= $Page->portal_category->toClientList($Page) ?>,
            "pd_byepass": <?= $Page->pd_byepass->toClientList($Page) ?>,
            "_dashboard": <?= $Page->_dashboard->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="portal_setup">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_portal_setup_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>>
<span id="el_portal_setup_id">
<span<?= $Page->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>"></span>
<input type="hidden" data-table="portal_setup" data-field="x_id" data-hidden="1" name="x_id" id="x_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->url->Visible) { // url ?>
    <div id="r_url"<?= $Page->url->rowAttributes() ?>>
        <label id="elh_portal_setup_url" for="x_url" class="<?= $Page->LeftColumnClass ?>"><?= $Page->url->caption() ?><?= $Page->url->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->url->cellAttributes() ?>>
<span id="el_portal_setup_url">
<input type="<?= $Page->url->getInputTextType() ?>" name="x_url" id="x_url" data-table="portal_setup" data-field="x_url" value="<?= $Page->url->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->url->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->url->formatPattern()) ?>"<?= $Page->url->editAttributes() ?> aria-describedby="x_url_help">
<?= $Page->url->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->url->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->admin_url->Visible) { // admin_url ?>
    <div id="r_admin_url"<?= $Page->admin_url->rowAttributes() ?>>
        <label id="elh_portal_setup_admin_url" for="x_admin_url" class="<?= $Page->LeftColumnClass ?>"><?= $Page->admin_url->caption() ?><?= $Page->admin_url->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->admin_url->cellAttributes() ?>>
<span id="el_portal_setup_admin_url">
<input type="<?= $Page->admin_url->getInputTextType() ?>" name="x_admin_url" id="x_admin_url" data-table="portal_setup" data-field="x_admin_url" value="<?= $Page->admin_url->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->admin_url->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->admin_url->formatPattern()) ?>"<?= $Page->admin_url->editAttributes() ?> aria-describedby="x_admin_url_help">
<?= $Page->admin_url->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->admin_url->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->mail_code->Visible) { // mail_code ?>
    <div id="r_mail_code"<?= $Page->mail_code->rowAttributes() ?>>
        <label id="elh_portal_setup_mail_code" for="x_mail_code" class="<?= $Page->LeftColumnClass ?>"><?= $Page->mail_code->caption() ?><?= $Page->mail_code->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->mail_code->cellAttributes() ?>>
<span id="el_portal_setup_mail_code">
<textarea data-table="portal_setup" data-field="x_mail_code" name="x_mail_code" id="x_mail_code" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->mail_code->getPlaceHolder()) ?>"<?= $Page->mail_code->editAttributes() ?> aria-describedby="x_mail_code_help"><?= $Page->mail_code->EditValue ?></textarea>
<?= $Page->mail_code->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->mail_code->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->footer_line->Visible) { // footer_line ?>
    <div id="r_footer_line"<?= $Page->footer_line->rowAttributes() ?>>
        <label id="elh_portal_setup_footer_line" for="x_footer_line" class="<?= $Page->LeftColumnClass ?>"><?= $Page->footer_line->caption() ?><?= $Page->footer_line->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->footer_line->cellAttributes() ?>>
<span id="el_portal_setup_footer_line">
<textarea data-table="portal_setup" data-field="x_footer_line" name="x_footer_line" id="x_footer_line" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->footer_line->getPlaceHolder()) ?>"<?= $Page->footer_line->editAttributes() ?> aria-describedby="x_footer_line_help"><?= $Page->footer_line->EditValue ?></textarea>
<?= $Page->footer_line->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->footer_line->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->portal_category->Visible) { // portal_category ?>
    <div id="r_portal_category"<?= $Page->portal_category->rowAttributes() ?>>
        <label id="elh_portal_setup_portal_category" class="<?= $Page->LeftColumnClass ?>"><?= $Page->portal_category->caption() ?><?= $Page->portal_category->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->portal_category->cellAttributes() ?>>
<span id="el_portal_setup_portal_category">
<template id="tp_x_portal_category">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="portal_setup" data-field="x_portal_category" name="x_portal_category" id="x_portal_category"<?= $Page->portal_category->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_portal_category" class="ew-item-list"></div>
<selection-list hidden
    id="x_portal_category[]"
    name="x_portal_category[]"
    value="<?= HtmlEncode($Page->portal_category->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_portal_category"
    data-target="dsl_x_portal_category"
    data-repeatcolumn="5"
    class="form-control<?= $Page->portal_category->isInvalidClass() ?>"
    data-table="portal_setup"
    data-field="x_portal_category"
    data-value-separator="<?= $Page->portal_category->displayValueSeparatorAttribute() ?>"
    <?= $Page->portal_category->editAttributes() ?>></selection-list>
<?= $Page->portal_category->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->portal_category->getErrorMessage() ?></div>
<?= $Page->portal_category->Lookup->getParamTag($Page, "p_x_portal_category") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->mcu->Visible) { // mcu ?>
    <div id="r_mcu"<?= $Page->mcu->rowAttributes() ?>>
        <label id="elh_portal_setup_mcu" for="x_mcu" class="<?= $Page->LeftColumnClass ?>"><?= $Page->mcu->caption() ?><?= $Page->mcu->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->mcu->cellAttributes() ?>>
<span id="el_portal_setup_mcu">
<input type="<?= $Page->mcu->getInputTextType() ?>" name="x_mcu" id="x_mcu" data-table="portal_setup" data-field="x_mcu" value="<?= $Page->mcu->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->mcu->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mcu->formatPattern()) ?>"<?= $Page->mcu->editAttributes() ?> aria-describedby="x_mcu_help">
<?= $Page->mcu->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->mcu->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->fcm_server_key->Visible) { // fcm_server_key ?>
    <div id="r_fcm_server_key"<?= $Page->fcm_server_key->rowAttributes() ?>>
        <label id="elh_portal_setup_fcm_server_key" for="x_fcm_server_key" class="<?= $Page->LeftColumnClass ?>"><?= $Page->fcm_server_key->caption() ?><?= $Page->fcm_server_key->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->fcm_server_key->cellAttributes() ?>>
<span id="el_portal_setup_fcm_server_key">
<input type="<?= $Page->fcm_server_key->getInputTextType() ?>" name="x_fcm_server_key" id="x_fcm_server_key" data-table="portal_setup" data-field="x_fcm_server_key" value="<?= $Page->fcm_server_key->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->fcm_server_key->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->fcm_server_key->formatPattern()) ?>"<?= $Page->fcm_server_key->editAttributes() ?> aria-describedby="x_fcm_server_key_help">
<?= $Page->fcm_server_key->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->fcm_server_key->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->app_version->Visible) { // app_version ?>
    <div id="r_app_version"<?= $Page->app_version->rowAttributes() ?>>
        <label id="elh_portal_setup_app_version" for="x_app_version" class="<?= $Page->LeftColumnClass ?>"><?= $Page->app_version->caption() ?><?= $Page->app_version->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->app_version->cellAttributes() ?>>
<span id="el_portal_setup_app_version">
<input type="<?= $Page->app_version->getInputTextType() ?>" name="x_app_version" id="x_app_version" data-table="portal_setup" data-field="x_app_version" value="<?= $Page->app_version->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->app_version->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->app_version->formatPattern()) ?>"<?= $Page->app_version->editAttributes() ?> aria-describedby="x_app_version_help">
<?= $Page->app_version->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->app_version->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->pd_byepass->Visible) { // pd_byepass ?>
    <div id="r_pd_byepass"<?= $Page->pd_byepass->rowAttributes() ?>>
        <label id="elh_portal_setup_pd_byepass" for="x_pd_byepass" class="<?= $Page->LeftColumnClass ?>"><?= $Page->pd_byepass->caption() ?><?= $Page->pd_byepass->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->pd_byepass->cellAttributes() ?>>
<span id="el_portal_setup_pd_byepass">
    <select
        id="x_pd_byepass"
        name="x_pd_byepass"
        class="form-select ew-select<?= $Page->pd_byepass->isInvalidClass() ?>"
        <?php if (!$Page->pd_byepass->IsNativeSelect) { ?>
        data-select2-id="fportal_setupedit_x_pd_byepass"
        <?php } ?>
        data-table="portal_setup"
        data-field="x_pd_byepass"
        data-value-separator="<?= $Page->pd_byepass->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->pd_byepass->getPlaceHolder()) ?>"
        <?= $Page->pd_byepass->editAttributes() ?>>
        <?= $Page->pd_byepass->selectOptionListHtml("x_pd_byepass") ?>
    </select>
    <?= $Page->pd_byepass->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->pd_byepass->getErrorMessage() ?></div>
<?php if (!$Page->pd_byepass->IsNativeSelect) { ?>
<script>
loadjs.ready("fportal_setupedit", function() {
    var options = { name: "x_pd_byepass", selectId: "fportal_setupedit_x_pd_byepass" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fportal_setupedit.lists.pd_byepass?.lookupOptions.length) {
        options.data = { id: "x_pd_byepass", form: "fportal_setupedit" };
    } else {
        options.ajax = { id: "x_pd_byepass", form: "fportal_setupedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.portal_setup.fields.pd_byepass.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator"<?= $Page->operator->rowAttributes() ?>>
        <label id="elh_portal_setup_operator" for="x_operator" class="<?= $Page->LeftColumnClass ?>"><?= $Page->operator->caption() ?><?= $Page->operator->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->operator->cellAttributes() ?>>
<span id="el_portal_setup_operator">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="portal_setup" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?> aria-describedby="x_operator_help">
<?= $Page->operator->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->google_map_api->Visible) { // google_map_api ?>
    <div id="r_google_map_api"<?= $Page->google_map_api->rowAttributes() ?>>
        <label id="elh_portal_setup_google_map_api" for="x_google_map_api" class="<?= $Page->LeftColumnClass ?>"><?= $Page->google_map_api->caption() ?><?= $Page->google_map_api->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->google_map_api->cellAttributes() ?>>
<span id="el_portal_setup_google_map_api">
<input type="<?= $Page->google_map_api->getInputTextType() ?>" name="x_google_map_api" id="x_google_map_api" data-table="portal_setup" data-field="x_google_map_api" value="<?= $Page->google_map_api->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->google_map_api->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->google_map_api->formatPattern()) ?>"<?= $Page->google_map_api->editAttributes() ?> aria-describedby="x_google_map_api_help">
<?= $Page->google_map_api->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->google_map_api->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->material_payment_type->Visible) { // material_payment_type ?>
    <div id="r_material_payment_type"<?= $Page->material_payment_type->rowAttributes() ?>>
        <label id="elh_portal_setup_material_payment_type" for="x_material_payment_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->material_payment_type->caption() ?><?= $Page->material_payment_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->material_payment_type->cellAttributes() ?>>
<span id="el_portal_setup_material_payment_type">
<input type="<?= $Page->material_payment_type->getInputTextType() ?>" name="x_material_payment_type" id="x_material_payment_type" data-table="portal_setup" data-field="x_material_payment_type" value="<?= $Page->material_payment_type->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->material_payment_type->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->material_payment_type->formatPattern()) ?>"<?= $Page->material_payment_type->editAttributes() ?> aria-describedby="x_material_payment_type_help">
<?= $Page->material_payment_type->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->material_payment_type->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->material_payment_varient->Visible) { // material_payment_varient ?>
    <div id="r_material_payment_varient"<?= $Page->material_payment_varient->rowAttributes() ?>>
        <label id="elh_portal_setup_material_payment_varient" for="x_material_payment_varient" class="<?= $Page->LeftColumnClass ?>"><?= $Page->material_payment_varient->caption() ?><?= $Page->material_payment_varient->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->material_payment_varient->cellAttributes() ?>>
<span id="el_portal_setup_material_payment_varient">
<input type="<?= $Page->material_payment_varient->getInputTextType() ?>" name="x_material_payment_varient" id="x_material_payment_varient" data-table="portal_setup" data-field="x_material_payment_varient" value="<?= $Page->material_payment_varient->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->material_payment_varient->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->material_payment_varient->formatPattern()) ?>"<?= $Page->material_payment_varient->editAttributes() ?> aria-describedby="x_material_payment_varient_help">
<?= $Page->material_payment_varient->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->material_payment_varient->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->footer_line_be->Visible) { // footer_line_be ?>
    <div id="r_footer_line_be"<?= $Page->footer_line_be->rowAttributes() ?>>
        <label id="elh_portal_setup_footer_line_be" for="x_footer_line_be" class="<?= $Page->LeftColumnClass ?>"><?= $Page->footer_line_be->caption() ?><?= $Page->footer_line_be->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->footer_line_be->cellAttributes() ?>>
<span id="el_portal_setup_footer_line_be">
<input type="<?= $Page->footer_line_be->getInputTextType() ?>" name="x_footer_line_be" id="x_footer_line_be" data-table="portal_setup" data-field="x_footer_line_be" value="<?= $Page->footer_line_be->EditValue ?>" size="30" maxlength="144" placeholder="<?= HtmlEncode($Page->footer_line_be->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->footer_line_be->formatPattern()) ?>"<?= $Page->footer_line_be->editAttributes() ?> aria-describedby="x_footer_line_be_help">
<?= $Page->footer_line_be->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->footer_line_be->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->allow_reg->Visible) { // allow_reg ?>
    <div id="r_allow_reg"<?= $Page->allow_reg->rowAttributes() ?>>
        <label id="elh_portal_setup_allow_reg" for="x_allow_reg" class="<?= $Page->LeftColumnClass ?>"><?= $Page->allow_reg->caption() ?><?= $Page->allow_reg->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->allow_reg->cellAttributes() ?>>
<span id="el_portal_setup_allow_reg">
<input type="<?= $Page->allow_reg->getInputTextType() ?>" name="x_allow_reg" id="x_allow_reg" data-table="portal_setup" data-field="x_allow_reg" value="<?= $Page->allow_reg->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->allow_reg->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->allow_reg->formatPattern()) ?>"<?= $Page->allow_reg->editAttributes() ?> aria-describedby="x_allow_reg_help">
<?= $Page->allow_reg->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->allow_reg->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->login_remember->Visible) { // login_remember ?>
    <div id="r_login_remember"<?= $Page->login_remember->rowAttributes() ?>>
        <label id="elh_portal_setup_login_remember" for="x_login_remember" class="<?= $Page->LeftColumnClass ?>"><?= $Page->login_remember->caption() ?><?= $Page->login_remember->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->login_remember->cellAttributes() ?>>
<span id="el_portal_setup_login_remember">
<input type="<?= $Page->login_remember->getInputTextType() ?>" name="x_login_remember" id="x_login_remember" data-table="portal_setup" data-field="x_login_remember" value="<?= $Page->login_remember->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->login_remember->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->login_remember->formatPattern()) ?>"<?= $Page->login_remember->editAttributes() ?> aria-describedby="x_login_remember_help">
<?= $Page->login_remember->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->login_remember->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->gp_p_check->Visible) { // gp_p_check ?>
    <div id="r_gp_p_check"<?= $Page->gp_p_check->rowAttributes() ?>>
        <label id="elh_portal_setup_gp_p_check" for="x_gp_p_check" class="<?= $Page->LeftColumnClass ?>"><?= $Page->gp_p_check->caption() ?><?= $Page->gp_p_check->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->gp_p_check->cellAttributes() ?>>
<span id="el_portal_setup_gp_p_check">
<input type="<?= $Page->gp_p_check->getInputTextType() ?>" name="x_gp_p_check" id="x_gp_p_check" data-table="portal_setup" data-field="x_gp_p_check" value="<?= $Page->gp_p_check->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->gp_p_check->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->gp_p_check->formatPattern()) ?>"<?= $Page->gp_p_check->editAttributes() ?> aria-describedby="x_gp_p_check_help">
<?= $Page->gp_p_check->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->gp_p_check->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->fe_version->Visible) { // fe_version ?>
    <div id="r_fe_version"<?= $Page->fe_version->rowAttributes() ?>>
        <label id="elh_portal_setup_fe_version" for="x_fe_version" class="<?= $Page->LeftColumnClass ?>"><?= $Page->fe_version->caption() ?><?= $Page->fe_version->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->fe_version->cellAttributes() ?>>
<span id="el_portal_setup_fe_version">
<input type="<?= $Page->fe_version->getInputTextType() ?>" name="x_fe_version" id="x_fe_version" data-table="portal_setup" data-field="x_fe_version" value="<?= $Page->fe_version->EditValue ?>" size="30" maxlength="12" placeholder="<?= HtmlEncode($Page->fe_version->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->fe_version->formatPattern()) ?>"<?= $Page->fe_version->editAttributes() ?> aria-describedby="x_fe_version_help">
<?= $Page->fe_version->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->fe_version->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->admin_version->Visible) { // admin_version ?>
    <div id="r_admin_version"<?= $Page->admin_version->rowAttributes() ?>>
        <label id="elh_portal_setup_admin_version" for="x_admin_version" class="<?= $Page->LeftColumnClass ?>"><?= $Page->admin_version->caption() ?><?= $Page->admin_version->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->admin_version->cellAttributes() ?>>
<span id="el_portal_setup_admin_version">
<input type="<?= $Page->admin_version->getInputTextType() ?>" name="x_admin_version" id="x_admin_version" data-table="portal_setup" data-field="x_admin_version" value="<?= $Page->admin_version->EditValue ?>" size="30" maxlength="12" placeholder="<?= HtmlEncode($Page->admin_version->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->admin_version->formatPattern()) ?>"<?= $Page->admin_version->editAttributes() ?> aria-describedby="x_admin_version_help">
<?= $Page->admin_version->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->admin_version->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_dashboard->Visible) { // dashboard ?>
    <div id="r__dashboard"<?= $Page->_dashboard->rowAttributes() ?>>
        <label id="elh_portal_setup__dashboard" for="x__dashboard" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_dashboard->caption() ?><?= $Page->_dashboard->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_dashboard->cellAttributes() ?>>
<span id="el_portal_setup__dashboard">
    <select
        id="x__dashboard"
        name="x__dashboard"
        class="form-select ew-select<?= $Page->_dashboard->isInvalidClass() ?>"
        <?php if (!$Page->_dashboard->IsNativeSelect) { ?>
        data-select2-id="fportal_setupedit_x__dashboard"
        <?php } ?>
        data-table="portal_setup"
        data-field="x__dashboard"
        data-value-separator="<?= $Page->_dashboard->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->_dashboard->getPlaceHolder()) ?>"
        <?= $Page->_dashboard->editAttributes() ?>>
        <?= $Page->_dashboard->selectOptionListHtml("x__dashboard") ?>
    </select>
    <?= $Page->_dashboard->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->_dashboard->getErrorMessage() ?></div>
<?php if (!$Page->_dashboard->IsNativeSelect) { ?>
<script>
loadjs.ready("fportal_setupedit", function() {
    var options = { name: "x__dashboard", selectId: "fportal_setupedit_x__dashboard" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fportal_setupedit.lists._dashboard?.lookupOptions.length) {
        options.data = { id: "x__dashboard", form: "fportal_setupedit" };
    } else {
        options.ajax = { id: "x__dashboard", form: "fportal_setupedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.portal_setup.fields._dashboard.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->developer_upi_id->Visible) { // developer_upi_id ?>
    <div id="r_developer_upi_id"<?= $Page->developer_upi_id->rowAttributes() ?>>
        <label id="elh_portal_setup_developer_upi_id" for="x_developer_upi_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->developer_upi_id->caption() ?><?= $Page->developer_upi_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->developer_upi_id->cellAttributes() ?>>
<span id="el_portal_setup_developer_upi_id">
<input type="<?= $Page->developer_upi_id->getInputTextType() ?>" name="x_developer_upi_id" id="x_developer_upi_id" data-table="portal_setup" data-field="x_developer_upi_id" value="<?= $Page->developer_upi_id->EditValue ?>" size="30" maxlength="200" placeholder="<?= HtmlEncode($Page->developer_upi_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->developer_upi_id->formatPattern()) ?>"<?= $Page->developer_upi_id->editAttributes() ?> aria-describedby="x_developer_upi_id_help">
<?= $Page->developer_upi_id->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->developer_upi_id->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->developer_company->Visible) { // developer_company ?>
    <div id="r_developer_company"<?= $Page->developer_company->rowAttributes() ?>>
        <label id="elh_portal_setup_developer_company" for="x_developer_company" class="<?= $Page->LeftColumnClass ?>"><?= $Page->developer_company->caption() ?><?= $Page->developer_company->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->developer_company->cellAttributes() ?>>
<span id="el_portal_setup_developer_company">
<input type="<?= $Page->developer_company->getInputTextType() ?>" name="x_developer_company" id="x_developer_company" data-table="portal_setup" data-field="x_developer_company" value="<?= $Page->developer_company->EditValue ?>" size="30" maxlength="200" placeholder="<?= HtmlEncode($Page->developer_company->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->developer_company->formatPattern()) ?>"<?= $Page->developer_company->editAttributes() ?> aria-describedby="x_developer_company_help">
<?= $Page->developer_company->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->developer_company->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->default_page->Visible) { // default_page ?>
    <div id="r_default_page"<?= $Page->default_page->rowAttributes() ?>>
        <label id="elh_portal_setup_default_page" for="x_default_page" class="<?= $Page->LeftColumnClass ?>"><?= $Page->default_page->caption() ?><?= $Page->default_page->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->default_page->cellAttributes() ?>>
<span id="el_portal_setup_default_page">
<input type="<?= $Page->default_page->getInputTextType() ?>" name="x_default_page" id="x_default_page" data-table="portal_setup" data-field="x_default_page" value="<?= $Page->default_page->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->default_page->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->default_page->formatPattern()) ?>"<?= $Page->default_page->editAttributes() ?> aria-describedby="x_default_page_help">
<?= $Page->default_page->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->default_page->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->bom_edit->Visible) { // bom_edit ?>
    <div id="r_bom_edit"<?= $Page->bom_edit->rowAttributes() ?>>
        <label id="elh_portal_setup_bom_edit" for="x_bom_edit" class="<?= $Page->LeftColumnClass ?>"><?= $Page->bom_edit->caption() ?><?= $Page->bom_edit->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->bom_edit->cellAttributes() ?>>
<span id="el_portal_setup_bom_edit">
<input type="<?= $Page->bom_edit->getInputTextType() ?>" name="x_bom_edit" id="x_bom_edit" data-table="portal_setup" data-field="x_bom_edit" value="<?= $Page->bom_edit->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->bom_edit->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bom_edit->formatPattern()) ?>"<?= $Page->bom_edit->editAttributes() ?> aria-describedby="x_bom_edit_help">
<?= $Page->bom_edit->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->bom_edit->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fportal_setupedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fportal_setupedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("portal_setup");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
