<?php

namespace PHPMaker2024\fibre;

// Page object
$PortalListEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<form name="fportal_listedit" id="fportal_listedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { portal_list: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fportal_listedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fportal_listedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["url", [fields.url.visible && fields.url.required ? ew.Validators.required(fields.url.caption) : null], fields.url.isInvalid],
            ["_db", [fields._db.visible && fields._db.required ? ew.Validators.required(fields._db.caption) : null], fields._db.isInvalid],
            ["category", [fields.category.visible && fields.category.required ? ew.Validators.required(fields.category.caption) : null], fields.category.isInvalid],
            ["php_version", [fields.php_version.visible && fields.php_version.required ? ew.Validators.required(fields.php_version.caption) : null], fields.php_version.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "category": <?= $Page->category->toClientList($Page) ?>,
            "php_version": <?= $Page->php_version->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="portal_list">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_portal_list_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>>
<span id="el_portal_list_id">
<span<?= $Page->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>"></span>
<input type="hidden" data-table="portal_list" data-field="x_id" data-hidden="1" name="x_id" id="x_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->url->Visible) { // url ?>
    <div id="r_url"<?= $Page->url->rowAttributes() ?>>
        <label id="elh_portal_list_url" for="x_url" class="<?= $Page->LeftColumnClass ?>"><?= $Page->url->caption() ?><?= $Page->url->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->url->cellAttributes() ?>>
<span id="el_portal_list_url">
<input type="<?= $Page->url->getInputTextType() ?>" name="x_url" id="x_url" data-table="portal_list" data-field="x_url" value="<?= $Page->url->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->url->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->url->formatPattern()) ?>"<?= $Page->url->editAttributes() ?> aria-describedby="x_url_help">
<?= $Page->url->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->url->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_db->Visible) { // db ?>
    <div id="r__db"<?= $Page->_db->rowAttributes() ?>>
        <label id="elh_portal_list__db" for="x__db" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_db->caption() ?><?= $Page->_db->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_db->cellAttributes() ?>>
<span id="el_portal_list__db">
<input type="<?= $Page->_db->getInputTextType() ?>" name="x__db" id="x__db" data-table="portal_list" data-field="x__db" value="<?= $Page->_db->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_db->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_db->formatPattern()) ?>"<?= $Page->_db->editAttributes() ?> aria-describedby="x__db_help">
<?= $Page->_db->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_db->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
    <div id="r_category"<?= $Page->category->rowAttributes() ?>>
        <label id="elh_portal_list_category" class="<?= $Page->LeftColumnClass ?>"><?= $Page->category->caption() ?><?= $Page->category->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->category->cellAttributes() ?>>
<span id="el_portal_list_category">
<?php
if (IsRTL()) {
    $Page->category->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_category" class="ew-auto-suggest">
    <input type="<?= $Page->category->getInputTextType() ?>" class="form-control" name="sv_x_category" id="sv_x_category" value="<?= RemoveHtml($Page->category->EditValue) ?>" autocomplete="off" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->category->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->category->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->category->formatPattern()) ?>"<?= $Page->category->editAttributes() ?> aria-describedby="x_category_help">
</span>
<selection-list hidden class="form-control" data-table="portal_list" data-field="x_category" data-input="sv_x_category" data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>" name="x_category" id="x_category" value="<?= HtmlEncode($Page->category->CurrentValue) ?>"></selection-list>
<?= $Page->category->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->category->getErrorMessage() ?></div>
<script>
loadjs.ready("fportal_listedit", function() {
    fportal_listedit.createAutoSuggest(Object.assign({"id":"x_category","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->category->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.portal_list.fields.category.autoSuggestOptions));
});
</script>
<?= $Page->category->Lookup->getParamTag($Page, "p_x_category") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->php_version->Visible) { // php_version ?>
    <div id="r_php_version"<?= $Page->php_version->rowAttributes() ?>>
        <label id="elh_portal_list_php_version" class="<?= $Page->LeftColumnClass ?>"><?= $Page->php_version->caption() ?><?= $Page->php_version->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->php_version->cellAttributes() ?>>
<span id="el_portal_list_php_version">
<?php
if (IsRTL()) {
    $Page->php_version->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_php_version" class="ew-auto-suggest">
    <input type="<?= $Page->php_version->getInputTextType() ?>" class="form-control" name="sv_x_php_version" id="sv_x_php_version" value="<?= RemoveHtml($Page->php_version->EditValue) ?>" autocomplete="off" size="30" maxlength="5" placeholder="<?= HtmlEncode($Page->php_version->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->php_version->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->php_version->formatPattern()) ?>"<?= $Page->php_version->editAttributes() ?> aria-describedby="x_php_version_help">
</span>
<selection-list hidden class="form-control" data-table="portal_list" data-field="x_php_version" data-input="sv_x_php_version" data-value-separator="<?= $Page->php_version->displayValueSeparatorAttribute() ?>" name="x_php_version" id="x_php_version" value="<?= HtmlEncode($Page->php_version->CurrentValue) ?>"></selection-list>
<?= $Page->php_version->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->php_version->getErrorMessage() ?></div>
<script>
loadjs.ready("fportal_listedit", function() {
    fportal_listedit.createAutoSuggest(Object.assign({"id":"x_php_version","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->php_version->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.portal_list.fields.php_version.autoSuggestOptions));
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label id="elh_portal_list_status" for="x_status" class="<?= $Page->LeftColumnClass ?>"><?= $Page->status->caption() ?><?= $Page->status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->status->cellAttributes() ?>>
<span id="el_portal_list_status">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fportal_listedit_x_status"
        <?php } ?>
        data-table="portal_list"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <?= $Page->status->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fportal_listedit", function() {
    var options = { name: "x_status", selectId: "fportal_listedit_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fportal_listedit.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fportal_listedit" };
    } else {
        options.ajax = { id: "x_status", form: "fportal_listedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.portal_list.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fportal_listedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fportal_listedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("portal_list");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
