<?php

namespace PHPMaker2024\fibre;

// Page object
$PortalInfoSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { portal_info: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fportal_infosearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fportal_infosearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["logo", [], fields.logo.isInvalid],
            ["mobile_logo", [], fields.mobile_logo.isInvalid],
            ["name", [], fields.name.isInvalid],
            ["address", [], fields.address.isInvalid],
            ["_email", [], fields._email.isInvalid],
            ["mobile", [], fields.mobile.isInvalid],
            ["gst", [], fields.gst.isInvalid],
            ["other", [], fields.other.isInvalid],
            ["admin_mobile", [], fields.admin_mobile.isInvalid],
            ["header", [], fields.header.isInvalid],
            ["footer", [], fields.footer.isInvalid],
            ["tag_line", [], fields.tag_line.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fportal_infosearch" id="fportal_infosearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="portal_info">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_portal_info_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_portal_info_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="portal_info" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->logo->Visible) { // logo ?>
    <div id="r_logo" class="row"<?= $Page->logo->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_portal_info_logo"><?= $Page->logo->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_logo" id="z_logo" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->logo->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_portal_info_logo" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->logo->getInputTextType() ?>" name="x_logo" id="x_logo" data-table="portal_info" data-field="x_logo" value="<?= $Page->logo->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->logo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->logo->formatPattern()) ?>"<?= $Page->logo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->logo->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->mobile_logo->Visible) { // mobile_logo ?>
    <div id="r_mobile_logo" class="row"<?= $Page->mobile_logo->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_portal_info_mobile_logo"><?= $Page->mobile_logo->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_mobile_logo" id="z_mobile_logo" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->mobile_logo->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_portal_info_mobile_logo" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->mobile_logo->getInputTextType() ?>" name="x_mobile_logo" id="x_mobile_logo" data-table="portal_info" data-field="x_mobile_logo" value="<?= $Page->mobile_logo->EditValue ?>" size="30" maxlength="30" placeholder="<?= HtmlEncode($Page->mobile_logo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile_logo->formatPattern()) ?>"<?= $Page->mobile_logo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->mobile_logo->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->name->Visible) { // name ?>
    <div id="r_name" class="row"<?= $Page->name->rowAttributes() ?>>
        <label for="x_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_portal_info_name"><?= $Page->name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_name" id="z_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_portal_info_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->name->getInputTextType() ?>" name="x_name" id="x_name" data-table="portal_info" data-field="x_name" value="<?= $Page->name->EditValue ?>" size="30" maxlength="75" placeholder="<?= HtmlEncode($Page->name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->name->formatPattern()) ?>"<?= $Page->name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->address->Visible) { // address ?>
    <div id="r_address" class="row"<?= $Page->address->rowAttributes() ?>>
        <label for="x_address" class="<?= $Page->LeftColumnClass ?>"><span id="elh_portal_info_address"><?= $Page->address->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_address" id="z_address" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->address->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_portal_info_address" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->address->getInputTextType() ?>" name="x_address" id="x_address" data-table="portal_info" data-field="x_address" value="<?= $Page->address->EditValue ?>" size="35" maxlength="65535" placeholder="<?= HtmlEncode($Page->address->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->address->formatPattern()) ?>"<?= $Page->address->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->address->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_email->Visible) { // email ?>
    <div id="r__email" class="row"<?= $Page->_email->rowAttributes() ?>>
        <label for="x__email" class="<?= $Page->LeftColumnClass ?>"><span id="elh_portal_info__email"><?= $Page->_email->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__email" id="z__email" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_email->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_portal_info__email" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_email->getInputTextType() ?>" name="x__email" id="x__email" data-table="portal_info" data-field="x__email" value="<?= $Page->_email->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->_email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_email->formatPattern()) ?>"<?= $Page->_email->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_email->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->mobile->Visible) { // mobile ?>
    <div id="r_mobile" class="row"<?= $Page->mobile->rowAttributes() ?>>
        <label for="x_mobile" class="<?= $Page->LeftColumnClass ?>"><span id="elh_portal_info_mobile"><?= $Page->mobile->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_mobile" id="z_mobile" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->mobile->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_portal_info_mobile" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->mobile->getInputTextType() ?>" name="x_mobile" id="x_mobile" data-table="portal_info" data-field="x_mobile" value="<?= $Page->mobile->EditValue ?>" size="30" maxlength="20" placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile->formatPattern()) ?>"<?= $Page->mobile->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->mobile->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->gst->Visible) { // gst ?>
    <div id="r_gst" class="row"<?= $Page->gst->rowAttributes() ?>>
        <label for="x_gst" class="<?= $Page->LeftColumnClass ?>"><span id="elh_portal_info_gst"><?= $Page->gst->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_gst" id="z_gst" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->gst->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_portal_info_gst" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->gst->getInputTextType() ?>" name="x_gst" id="x_gst" data-table="portal_info" data-field="x_gst" value="<?= $Page->gst->EditValue ?>" size="30" maxlength="20" placeholder="<?= HtmlEncode($Page->gst->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->gst->formatPattern()) ?>"<?= $Page->gst->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->gst->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->other->Visible) { // other ?>
    <div id="r_other" class="row"<?= $Page->other->rowAttributes() ?>>
        <label for="x_other" class="<?= $Page->LeftColumnClass ?>"><span id="elh_portal_info_other"><?= $Page->other->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_other" id="z_other" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->other->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_portal_info_other" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->other->getInputTextType() ?>" name="x_other" id="x_other" data-table="portal_info" data-field="x_other" value="<?= $Page->other->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->other->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->other->formatPattern()) ?>"<?= $Page->other->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->other->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->admin_mobile->Visible) { // admin_mobile ?>
    <div id="r_admin_mobile" class="row"<?= $Page->admin_mobile->rowAttributes() ?>>
        <label for="x_admin_mobile" class="<?= $Page->LeftColumnClass ?>"><span id="elh_portal_info_admin_mobile"><?= $Page->admin_mobile->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_admin_mobile" id="z_admin_mobile" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->admin_mobile->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_portal_info_admin_mobile" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->admin_mobile->getInputTextType() ?>" name="x_admin_mobile" id="x_admin_mobile" data-table="portal_info" data-field="x_admin_mobile" value="<?= $Page->admin_mobile->EditValue ?>" size="30" maxlength="44" placeholder="<?= HtmlEncode($Page->admin_mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->admin_mobile->formatPattern()) ?>"<?= $Page->admin_mobile->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->admin_mobile->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->header->Visible) { // header ?>
    <div id="r_header" class="row"<?= $Page->header->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_portal_info_header"><?= $Page->header->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_header" id="z_header" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->header->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_portal_info_header" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->header->getInputTextType() ?>" name="x_header" id="x_header" data-table="portal_info" data-field="x_header" value="<?= $Page->header->EditValue ?>" size="35" maxlength="65535" placeholder="<?= HtmlEncode($Page->header->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->header->formatPattern()) ?>"<?= $Page->header->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->header->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->footer->Visible) { // footer ?>
    <div id="r_footer" class="row"<?= $Page->footer->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_portal_info_footer"><?= $Page->footer->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_footer" id="z_footer" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->footer->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_portal_info_footer" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->footer->getInputTextType() ?>" name="x_footer" id="x_footer" data-table="portal_info" data-field="x_footer" value="<?= $Page->footer->EditValue ?>" size="35" maxlength="65535" placeholder="<?= HtmlEncode($Page->footer->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->footer->formatPattern()) ?>"<?= $Page->footer->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->footer->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->tag_line->Visible) { // tag_line ?>
    <div id="r_tag_line" class="row"<?= $Page->tag_line->rowAttributes() ?>>
        <label for="x_tag_line" class="<?= $Page->LeftColumnClass ?>"><span id="elh_portal_info_tag_line"><?= $Page->tag_line->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_tag_line" id="z_tag_line" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->tag_line->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_portal_info_tag_line" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->tag_line->getInputTextType() ?>" name="x_tag_line" id="x_tag_line" data-table="portal_info" data-field="x_tag_line" value="<?= $Page->tag_line->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->tag_line->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->tag_line->formatPattern()) ?>"<?= $Page->tag_line->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->tag_line->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_portal_info_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_portal_info_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fportal_infosearch_x_operator"
        <?php } ?>
        data-table="portal_info"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fportal_infosearch", function() {
    var options = { name: "x_operator", selectId: "fportal_infosearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fportal_infosearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fportal_infosearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fportal_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.portal_info.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_portal_info_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_portal_info_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="portal_info" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fportal_infosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fportal_infosearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fportal_infosearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fportal_infosearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fportal_infosearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("portal_info");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
