<?php

namespace PHPMaker2024\fibre;

// Page object
$PortalInfoEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<form name="fportal_infoedit" id="fportal_infoedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { portal_info: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fportal_infoedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fportal_infoedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["logo", [fields.logo.visible && fields.logo.required ? ew.Validators.fileRequired(fields.logo.caption) : null], fields.logo.isInvalid],
            ["mobile_logo", [fields.mobile_logo.visible && fields.mobile_logo.required ? ew.Validators.fileRequired(fields.mobile_logo.caption) : null], fields.mobile_logo.isInvalid],
            ["name", [fields.name.visible && fields.name.required ? ew.Validators.required(fields.name.caption) : null], fields.name.isInvalid],
            ["address", [fields.address.visible && fields.address.required ? ew.Validators.required(fields.address.caption) : null], fields.address.isInvalid],
            ["_email", [fields._email.visible && fields._email.required ? ew.Validators.required(fields._email.caption) : null], fields._email.isInvalid],
            ["mobile", [fields.mobile.visible && fields.mobile.required ? ew.Validators.required(fields.mobile.caption) : null], fields.mobile.isInvalid],
            ["gst", [fields.gst.visible && fields.gst.required ? ew.Validators.required(fields.gst.caption) : null], fields.gst.isInvalid],
            ["other", [fields.other.visible && fields.other.required ? ew.Validators.required(fields.other.caption) : null], fields.other.isInvalid],
            ["admin_mobile", [fields.admin_mobile.visible && fields.admin_mobile.required ? ew.Validators.required(fields.admin_mobile.caption) : null], fields.admin_mobile.isInvalid],
            ["header", [fields.header.visible && fields.header.required ? ew.Validators.required(fields.header.caption) : null], fields.header.isInvalid],
            ["footer", [fields.footer.visible && fields.footer.required ? ew.Validators.required(fields.footer.caption) : null], fields.footer.isInvalid],
            ["tag_line", [fields.tag_line.visible && fields.tag_line.required ? ew.Validators.required(fields.tag_line.caption) : null], fields.tag_line.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="portal_info">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_portal_info_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>>
<span id="el_portal_info_id">
<span<?= $Page->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>"></span>
<input type="hidden" data-table="portal_info" data-field="x_id" data-hidden="1" name="x_id" id="x_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->logo->Visible) { // logo ?>
    <div id="r_logo"<?= $Page->logo->rowAttributes() ?>>
        <label id="elh_portal_info_logo" class="<?= $Page->LeftColumnClass ?>"><?= $Page->logo->caption() ?><?= $Page->logo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->logo->cellAttributes() ?>>
<span id="el_portal_info_logo">
<div id="fd_x_logo" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x_logo"
        name="x_logo"
        class="form-control ew-file-input"
        title="<?= $Page->logo->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="portal_info"
        data-field="x_logo"
        data-size="50"
        data-accept-file-types="<?= $Page->logo->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->logo->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Page->logo->ImageCropper ? 0 : 1 ?>"
        aria-describedby="x_logo_help"
        <?= ($Page->logo->ReadOnly || $Page->logo->Disabled) ? " disabled" : "" ?>
        <?= $Page->logo->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFile") ?></div>
    <?= $Page->logo->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->logo->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x_logo" id= "fn_x_logo" value="<?= $Page->logo->Upload->FileName ?>">
<input type="hidden" name="fa_x_logo" id= "fa_x_logo" value="<?= (Post("fa_x_logo") == "0") ? "0" : "1" ?>">
<table id="ft_x_logo" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->mobile_logo->Visible) { // mobile_logo ?>
    <div id="r_mobile_logo"<?= $Page->mobile_logo->rowAttributes() ?>>
        <label id="elh_portal_info_mobile_logo" class="<?= $Page->LeftColumnClass ?>"><?= $Page->mobile_logo->caption() ?><?= $Page->mobile_logo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->mobile_logo->cellAttributes() ?>>
<span id="el_portal_info_mobile_logo">
<div id="fd_x_mobile_logo" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x_mobile_logo"
        name="x_mobile_logo"
        class="form-control ew-file-input"
        title="<?= $Page->mobile_logo->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="portal_info"
        data-field="x_mobile_logo"
        data-size="30"
        data-accept-file-types="<?= $Page->mobile_logo->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->mobile_logo->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Page->mobile_logo->ImageCropper ? 0 : 1 ?>"
        aria-describedby="x_mobile_logo_help"
        <?= ($Page->mobile_logo->ReadOnly || $Page->mobile_logo->Disabled) ? " disabled" : "" ?>
        <?= $Page->mobile_logo->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFile") ?></div>
    <?= $Page->mobile_logo->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->mobile_logo->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x_mobile_logo" id= "fn_x_mobile_logo" value="<?= $Page->mobile_logo->Upload->FileName ?>">
<input type="hidden" name="fa_x_mobile_logo" id= "fa_x_mobile_logo" value="<?= (Post("fa_x_mobile_logo") == "0") ? "0" : "1" ?>">
<table id="ft_x_mobile_logo" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->name->Visible) { // name ?>
    <div id="r_name"<?= $Page->name->rowAttributes() ?>>
        <label id="elh_portal_info_name" for="x_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->name->caption() ?><?= $Page->name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->name->cellAttributes() ?>>
<span id="el_portal_info_name">
<input type="<?= $Page->name->getInputTextType() ?>" name="x_name" id="x_name" data-table="portal_info" data-field="x_name" value="<?= $Page->name->EditValue ?>" size="30" maxlength="75" placeholder="<?= HtmlEncode($Page->name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->name->formatPattern()) ?>"<?= $Page->name->editAttributes() ?> aria-describedby="x_name_help">
<?= $Page->name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->name->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->address->Visible) { // address ?>
    <div id="r_address"<?= $Page->address->rowAttributes() ?>>
        <label id="elh_portal_info_address" for="x_address" class="<?= $Page->LeftColumnClass ?>"><?= $Page->address->caption() ?><?= $Page->address->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->address->cellAttributes() ?>>
<span id="el_portal_info_address">
<textarea data-table="portal_info" data-field="x_address" name="x_address" id="x_address" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->address->getPlaceHolder()) ?>"<?= $Page->address->editAttributes() ?> aria-describedby="x_address_help"><?= $Page->address->EditValue ?></textarea>
<?= $Page->address->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->address->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_email->Visible) { // email ?>
    <div id="r__email"<?= $Page->_email->rowAttributes() ?>>
        <label id="elh_portal_info__email" for="x__email" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_email->caption() ?><?= $Page->_email->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_email->cellAttributes() ?>>
<span id="el_portal_info__email">
<input type="<?= $Page->_email->getInputTextType() ?>" name="x__email" id="x__email" data-table="portal_info" data-field="x__email" value="<?= $Page->_email->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->_email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_email->formatPattern()) ?>"<?= $Page->_email->editAttributes() ?> aria-describedby="x__email_help">
<?= $Page->_email->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_email->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->mobile->Visible) { // mobile ?>
    <div id="r_mobile"<?= $Page->mobile->rowAttributes() ?>>
        <label id="elh_portal_info_mobile" for="x_mobile" class="<?= $Page->LeftColumnClass ?>"><?= $Page->mobile->caption() ?><?= $Page->mobile->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->mobile->cellAttributes() ?>>
<span id="el_portal_info_mobile">
<input type="<?= $Page->mobile->getInputTextType() ?>" name="x_mobile" id="x_mobile" data-table="portal_info" data-field="x_mobile" value="<?= $Page->mobile->EditValue ?>" size="30" maxlength="20" placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile->formatPattern()) ?>"<?= $Page->mobile->editAttributes() ?> aria-describedby="x_mobile_help">
<?= $Page->mobile->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->mobile->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->gst->Visible) { // gst ?>
    <div id="r_gst"<?= $Page->gst->rowAttributes() ?>>
        <label id="elh_portal_info_gst" for="x_gst" class="<?= $Page->LeftColumnClass ?>"><?= $Page->gst->caption() ?><?= $Page->gst->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->gst->cellAttributes() ?>>
<span id="el_portal_info_gst">
<input type="<?= $Page->gst->getInputTextType() ?>" name="x_gst" id="x_gst" data-table="portal_info" data-field="x_gst" value="<?= $Page->gst->EditValue ?>" size="30" maxlength="20" placeholder="<?= HtmlEncode($Page->gst->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->gst->formatPattern()) ?>"<?= $Page->gst->editAttributes() ?> aria-describedby="x_gst_help">
<?= $Page->gst->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->gst->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->other->Visible) { // other ?>
    <div id="r_other"<?= $Page->other->rowAttributes() ?>>
        <label id="elh_portal_info_other" for="x_other" class="<?= $Page->LeftColumnClass ?>"><?= $Page->other->caption() ?><?= $Page->other->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->other->cellAttributes() ?>>
<span id="el_portal_info_other">
<input type="<?= $Page->other->getInputTextType() ?>" name="x_other" id="x_other" data-table="portal_info" data-field="x_other" value="<?= $Page->other->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->other->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->other->formatPattern()) ?>"<?= $Page->other->editAttributes() ?> aria-describedby="x_other_help">
<?= $Page->other->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->other->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->admin_mobile->Visible) { // admin_mobile ?>
    <div id="r_admin_mobile"<?= $Page->admin_mobile->rowAttributes() ?>>
        <label id="elh_portal_info_admin_mobile" for="x_admin_mobile" class="<?= $Page->LeftColumnClass ?>"><?= $Page->admin_mobile->caption() ?><?= $Page->admin_mobile->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->admin_mobile->cellAttributes() ?>>
<span id="el_portal_info_admin_mobile">
<input type="<?= $Page->admin_mobile->getInputTextType() ?>" name="x_admin_mobile" id="x_admin_mobile" data-table="portal_info" data-field="x_admin_mobile" value="<?= $Page->admin_mobile->EditValue ?>" size="30" maxlength="44" placeholder="<?= HtmlEncode($Page->admin_mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->admin_mobile->formatPattern()) ?>"<?= $Page->admin_mobile->editAttributes() ?> aria-describedby="x_admin_mobile_help">
<?= $Page->admin_mobile->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->admin_mobile->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->header->Visible) { // header ?>
    <div id="r_header"<?= $Page->header->rowAttributes() ?>>
        <label id="elh_portal_info_header" class="<?= $Page->LeftColumnClass ?>"><?= $Page->header->caption() ?><?= $Page->header->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->header->cellAttributes() ?>>
<span id="el_portal_info_header">
<?php $Page->header->EditAttrs->appendClass("editor"); ?>
<textarea data-table="portal_info" data-field="x_header" name="x_header" id="x_header" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->header->getPlaceHolder()) ?>"<?= $Page->header->editAttributes() ?> aria-describedby="x_header_help"><?= $Page->header->EditValue ?></textarea>
<?= $Page->header->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->header->getErrorMessage() ?></div>
<script>
loadjs.ready(["fportal_infoedit", "editor"], function() {
    ew.createEditor("fportal_infoedit", "x_header", 35, 4, <?= $Page->header->ReadOnly || false ? "true" : "false" ?>);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->footer->Visible) { // footer ?>
    <div id="r_footer"<?= $Page->footer->rowAttributes() ?>>
        <label id="elh_portal_info_footer" class="<?= $Page->LeftColumnClass ?>"><?= $Page->footer->caption() ?><?= $Page->footer->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->footer->cellAttributes() ?>>
<span id="el_portal_info_footer">
<?php $Page->footer->EditAttrs->appendClass("editor"); ?>
<textarea data-table="portal_info" data-field="x_footer" name="x_footer" id="x_footer" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->footer->getPlaceHolder()) ?>"<?= $Page->footer->editAttributes() ?> aria-describedby="x_footer_help"><?= $Page->footer->EditValue ?></textarea>
<?= $Page->footer->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->footer->getErrorMessage() ?></div>
<script>
loadjs.ready(["fportal_infoedit", "editor"], function() {
    ew.createEditor("fportal_infoedit", "x_footer", 35, 4, <?= $Page->footer->ReadOnly || false ? "true" : "false" ?>);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->tag_line->Visible) { // tag_line ?>
    <div id="r_tag_line"<?= $Page->tag_line->rowAttributes() ?>>
        <label id="elh_portal_info_tag_line" for="x_tag_line" class="<?= $Page->LeftColumnClass ?>"><?= $Page->tag_line->caption() ?><?= $Page->tag_line->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->tag_line->cellAttributes() ?>>
<span id="el_portal_info_tag_line">
<input type="<?= $Page->tag_line->getInputTextType() ?>" name="x_tag_line" id="x_tag_line" data-table="portal_info" data-field="x_tag_line" value="<?= $Page->tag_line->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->tag_line->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->tag_line->formatPattern()) ?>"<?= $Page->tag_line->editAttributes() ?> aria-describedby="x_tag_line_help">
<?= $Page->tag_line->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->tag_line->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fportal_infoedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fportal_infoedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("portal_info");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
