<?php

namespace PHPMaker2024\fibre;

// Page object
$PortalImageSizeAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { portal_image_size: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fportal_image_sizeadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fportal_image_sizeadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["type", [fields.type.visible && fields.type.required ? ew.Validators.required(fields.type.caption) : null, ew.Validators.integer], fields.type.isInvalid],
            ["image_type", [fields.image_type.visible && fields.image_type.required ? ew.Validators.required(fields.image_type.caption) : null, ew.Validators.integer], fields.image_type.isInvalid],
            ["folder", [fields.folder.visible && fields.folder.required ? ew.Validators.required(fields.folder.caption) : null], fields.folder.isInvalid],
            ["width", [fields.width.visible && fields.width.required ? ew.Validators.required(fields.width.caption) : null, ew.Validators.integer], fields.width.isInvalid],
            ["height", [fields.height.visible && fields.height.required ? ew.Validators.required(fields.height.caption) : null, ew.Validators.integer], fields.height.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "status": <?= $Page->status->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fportal_image_sizeadd" id="fportal_image_sizeadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="portal_image_size">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->type->Visible) { // type ?>
    <div id="r_type"<?= $Page->type->rowAttributes() ?>>
        <label id="elh_portal_image_size_type" for="x_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->type->caption() ?><?= $Page->type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->type->cellAttributes() ?>>
<span id="el_portal_image_size_type">
<input type="<?= $Page->type->getInputTextType() ?>" name="x_type" id="x_type" data-table="portal_image_size" data-field="x_type" value="<?= $Page->type->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->type->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->type->formatPattern()) ?>"<?= $Page->type->editAttributes() ?> aria-describedby="x_type_help">
<?= $Page->type->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->type->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->image_type->Visible) { // image_type ?>
    <div id="r_image_type"<?= $Page->image_type->rowAttributes() ?>>
        <label id="elh_portal_image_size_image_type" for="x_image_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->image_type->caption() ?><?= $Page->image_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->image_type->cellAttributes() ?>>
<span id="el_portal_image_size_image_type">
<input type="<?= $Page->image_type->getInputTextType() ?>" name="x_image_type" id="x_image_type" data-table="portal_image_size" data-field="x_image_type" value="<?= $Page->image_type->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->image_type->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->image_type->formatPattern()) ?>"<?= $Page->image_type->editAttributes() ?> aria-describedby="x_image_type_help">
<?= $Page->image_type->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->image_type->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->folder->Visible) { // folder ?>
    <div id="r_folder"<?= $Page->folder->rowAttributes() ?>>
        <label id="elh_portal_image_size_folder" for="x_folder" class="<?= $Page->LeftColumnClass ?>"><?= $Page->folder->caption() ?><?= $Page->folder->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->folder->cellAttributes() ?>>
<span id="el_portal_image_size_folder">
<input type="<?= $Page->folder->getInputTextType() ?>" name="x_folder" id="x_folder" data-table="portal_image_size" data-field="x_folder" value="<?= $Page->folder->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->folder->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->folder->formatPattern()) ?>"<?= $Page->folder->editAttributes() ?> aria-describedby="x_folder_help">
<?= $Page->folder->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->folder->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->width->Visible) { // width ?>
    <div id="r_width"<?= $Page->width->rowAttributes() ?>>
        <label id="elh_portal_image_size_width" for="x_width" class="<?= $Page->LeftColumnClass ?>"><?= $Page->width->caption() ?><?= $Page->width->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->width->cellAttributes() ?>>
<span id="el_portal_image_size_width">
<input type="<?= $Page->width->getInputTextType() ?>" name="x_width" id="x_width" data-table="portal_image_size" data-field="x_width" value="<?= $Page->width->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->width->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->width->formatPattern()) ?>"<?= $Page->width->editAttributes() ?> aria-describedby="x_width_help">
<?= $Page->width->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->width->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->height->Visible) { // height ?>
    <div id="r_height"<?= $Page->height->rowAttributes() ?>>
        <label id="elh_portal_image_size_height" for="x_height" class="<?= $Page->LeftColumnClass ?>"><?= $Page->height->caption() ?><?= $Page->height->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->height->cellAttributes() ?>>
<span id="el_portal_image_size_height">
<input type="<?= $Page->height->getInputTextType() ?>" name="x_height" id="x_height" data-table="portal_image_size" data-field="x_height" value="<?= $Page->height->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->height->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->height->formatPattern()) ?>"<?= $Page->height->editAttributes() ?> aria-describedby="x_height_help">
<?= $Page->height->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->height->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label id="elh_portal_image_size_status" for="x_status" class="<?= $Page->LeftColumnClass ?>"><?= $Page->status->caption() ?><?= $Page->status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->status->cellAttributes() ?>>
<span id="el_portal_image_size_status">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fportal_image_sizeadd_x_status"
        <?php } ?>
        data-table="portal_image_size"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <?= $Page->status->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fportal_image_sizeadd", function() {
    var options = { name: "x_status", selectId: "fportal_image_sizeadd_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fportal_image_sizeadd.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fportal_image_sizeadd" };
    } else {
        options.ajax = { id: "x_status", form: "fportal_image_sizeadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.portal_image_size.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fportal_image_sizeadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fportal_image_sizeadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("portal_image_size");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
