<?php

namespace PHPMaker2024\fibre;

// Page object
$PortAddopt = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { port: currentTable } });
var currentPageID = ew.PAGE_ID = "addopt";
var currentForm;
var fportaddopt;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fportaddopt")
        .setPageId("addopt")

        // Add fields
        .setFields([
            ["port", [fields.port.visible && fields.port.required ? ew.Validators.required(fields.port.caption) : null], fields.port.isInvalid],
            ["code", [fields.code.visible && fields.code.required ? ew.Validators.required(fields.code.caption) : null, ew.Validators.regex(/^([a-zA-Z0-9_-]){3,3}$/)], fields.code.isInvalid],
            ["mode", [fields.mode.visible && fields.mode.required ? ew.Validators.required(fields.mode.caption) : null], fields.mode.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "mode": <?= $Page->mode->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<form name="fportaddopt" id="fportaddopt" class="ew-form" action="<?= HtmlEncode(GetUrl(Config("API_URL"))) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="<?= Config("API_ACTION_NAME") ?>" id="<?= Config("API_ACTION_NAME") ?>" value="<?= Config("API_ADD_ACTION") ?>">
<input type="hidden" name="<?= Config("API_OBJECT_NAME") ?>" id="<?= Config("API_OBJECT_NAME") ?>" value="port">
<input type="hidden" name="addopt" id="addopt" value="1">
<?php if ($Page->port->Visible) { // port ?>
    <div id="r_port"<?= $Page->port->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_port"><?= $Page->port->caption() ?><?= $Page->port->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->port->cellAttributes() ?>>
<input type="<?= $Page->port->getInputTextType() ?>" name="x_port" id="x_port" data-table="port" data-field="x_port" value="<?= $Page->port->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->port->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->port->formatPattern()) ?>"<?= $Page->port->editAttributes() ?> aria-describedby="x_port_help">
<?= $Page->port->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->port->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->code->Visible) { // code ?>
    <div id="r_code"<?= $Page->code->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_code"><?= $Page->code->caption() ?><?= $Page->code->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->code->cellAttributes() ?>>
<input type="<?= $Page->code->getInputTextType() ?>" name="x_code" id="x_code" data-table="port" data-field="x_code" value="<?= $Page->code->EditValue ?>" size="30" maxlength="3" placeholder="<?= HtmlEncode($Page->code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->code->formatPattern()) ?>"<?= $Page->code->editAttributes() ?> aria-describedby="x_code_help">
<?= $Page->code->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->code->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->mode->Visible) { // mode ?>
    <div id="r_mode"<?= $Page->mode->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_mode"><?= $Page->mode->caption() ?><?= $Page->mode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->mode->cellAttributes() ?>>
    <select
        id="x_mode"
        name="x_mode"
        class="form-select ew-select<?= $Page->mode->isInvalidClass() ?>"
        <?php if (!$Page->mode->IsNativeSelect) { ?>
        data-select2-id="fportaddopt_x_mode"
        <?php } ?>
        data-table="port"
        data-field="x_mode"
        data-value-separator="<?= $Page->mode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->mode->getPlaceHolder()) ?>"
        <?= $Page->mode->editAttributes() ?>>
        <?= $Page->mode->selectOptionListHtml("x_mode") ?>
    </select>
    <?= $Page->mode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->mode->getErrorMessage() ?></div>
<?php if (!$Page->mode->IsNativeSelect) { ?>
<script>
loadjs.ready("fportaddopt", function() {
    var options = { name: "x_mode", selectId: "fportaddopt_x_mode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fportaddopt.lists.mode?.lookupOptions.length) {
        options.data = { id: "x_mode", form: "fportaddopt" };
    } else {
        options.ajax = { id: "x_mode", form: "fportaddopt", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.port.fields.mode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_status"><?= $Page->status->caption() ?><?= $Page->status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->status->cellAttributes() ?>>
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fportaddopt_x_status"
        <?php } ?>
        data-table="port"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <?= $Page->status->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fportaddopt", function() {
    var options = { name: "x_status", selectId: "fportaddopt_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fportaddopt.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fportaddopt" };
    } else {
        options.ajax = { id: "x_status", form: "fportaddopt", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.port.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <input type="hidden" data-table="port" data-field="x_operator" data-hidden="1" name="x_operator" id="x_operator" value="<?= HtmlEncode($Page->operator->CurrentValue) ?>">
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <input type="hidden" data-table="port" data-field="x_datetime" data-hidden="1" name="x_datetime" id="x_datetime" value="<?= HtmlEncode($Page->datetime->CurrentValue) ?>">
<?php } ?>
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("port");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
