<?php

namespace PHPMaker2024\fibre;

// Page object
$PoSetupAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { po_setup: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fpo_setupadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fpo_setupadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null, ew.Validators.integer], fields.id.isInvalid],
            ["gst_included", [fields.gst_included.visible && fields.gst_included.required ? ew.Validators.required(fields.gst_included.caption) : null], fields.gst_included.isInvalid],
            ["po_b_transfer", [fields.po_b_transfer.visible && fields.po_b_transfer.required ? ew.Validators.required(fields.po_b_transfer.caption) : null], fields.po_b_transfer.isInvalid],
            ["po_b_sample_auto_auth", [fields.po_b_sample_auto_auth.visible && fields.po_b_sample_auto_auth.required ? ew.Validators.required(fields.po_b_sample_auto_auth.caption) : null], fields.po_b_sample_auto_auth.isInvalid],
            ["po_s_sample_auto_auth", [fields.po_s_sample_auto_auth.visible && fields.po_s_sample_auto_auth.required ? ew.Validators.required(fields.po_s_sample_auto_auth.caption) : null], fields.po_s_sample_auto_auth.isInvalid],
            ["po_cbm", [fields.po_cbm.visible && fields.po_cbm.required ? ew.Validators.required(fields.po_cbm.caption) : null], fields.po_cbm.isInvalid],
            ["po_buyer_uid", [fields.po_buyer_uid.visible && fields.po_buyer_uid.required ? ew.Validators.required(fields.po_buyer_uid.caption) : null], fields.po_buyer_uid.isInvalid],
            ["po_gst", [fields.po_gst.visible && fields.po_gst.required ? ew.Validators.required(fields.po_gst.caption) : null], fields.po_gst.isInvalid],
            ["po_sqm", [fields.po_sqm.visible && fields.po_sqm.required ? ew.Validators.required(fields.po_sqm.caption) : null], fields.po_sqm.isInvalid],
            ["po_prod_price", [fields.po_prod_price.visible && fields.po_prod_price.required ? ew.Validators.required(fields.po_prod_price.caption) : null], fields.po_prod_price.isInvalid],
            ["po_size", [fields.po_size.visible && fields.po_size.required ? ew.Validators.required(fields.po_size.caption) : null, ew.Validators.integer], fields.po_size.isInvalid],
            ["po_bom", [fields.po_bom.visible && fields.po_bom.required ? ew.Validators.required(fields.po_bom.caption) : null, ew.Validators.integer], fields.po_bom.isInvalid],
            ["po_process", [fields.po_process.visible && fields.po_process.required ? ew.Validators.required(fields.po_process.caption) : null, ew.Validators.integer], fields.po_process.isInvalid],
            ["po_buyer_code_prod", [fields.po_buyer_code_prod.visible && fields.po_buyer_code_prod.required ? ew.Validators.required(fields.po_buyer_code_prod.caption) : null, ew.Validators.integer], fields.po_buyer_code_prod.isInvalid],
            ["mr_live_datetime", [fields.mr_live_datetime.visible && fields.mr_live_datetime.required ? ew.Validators.required(fields.mr_live_datetime.caption) : null, ew.Validators.datetime(fields.mr_live_datetime.clientFormatPattern)], fields.mr_live_datetime.isInvalid],
            ["po_b_unauthorize", [fields.po_b_unauthorize.visible && fields.po_b_unauthorize.required ? ew.Validators.required(fields.po_b_unauthorize.caption) : null], fields.po_b_unauthorize.isInvalid],
            ["cart_b_password", [fields.cart_b_password.visible && fields.cart_b_password.required ? ew.Validators.required(fields.cart_b_password.caption) : null], fields.cart_b_password.isInvalid],
            ["cart_s_password", [fields.cart_s_password.visible && fields.cart_s_password.required ? ew.Validators.required(fields.cart_s_password.caption) : null], fields.cart_s_password.isInvalid],
            ["jc_po_yesno", [fields.jc_po_yesno.visible && fields.jc_po_yesno.required ? ew.Validators.required(fields.jc_po_yesno.caption) : null, ew.Validators.integer], fields.jc_po_yesno.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "gst_included": <?= $Page->gst_included->toClientList($Page) ?>,
            "po_b_transfer": <?= $Page->po_b_transfer->toClientList($Page) ?>,
            "po_b_sample_auto_auth": <?= $Page->po_b_sample_auto_auth->toClientList($Page) ?>,
            "po_s_sample_auto_auth": <?= $Page->po_s_sample_auto_auth->toClientList($Page) ?>,
            "po_cbm": <?= $Page->po_cbm->toClientList($Page) ?>,
            "po_buyer_uid": <?= $Page->po_buyer_uid->toClientList($Page) ?>,
            "po_gst": <?= $Page->po_gst->toClientList($Page) ?>,
            "po_sqm": <?= $Page->po_sqm->toClientList($Page) ?>,
            "po_prod_price": <?= $Page->po_prod_price->toClientList($Page) ?>,
            "po_b_unauthorize": <?= $Page->po_b_unauthorize->toClientList($Page) ?>,
            "jc_po_yesno": <?= $Page->jc_po_yesno->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fpo_setupadd" id="fpo_setupadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="po_setup">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_po_setup_id" for="x_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>>
<span id="el_po_setup_id">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="po_setup" data-field="x_id" value="<?= $Page->id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?> aria-describedby="x_id_help">
<?= $Page->id->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->gst_included->Visible) { // gst_included ?>
    <div id="r_gst_included"<?= $Page->gst_included->rowAttributes() ?>>
        <label id="elh_po_setup_gst_included" for="x_gst_included" class="<?= $Page->LeftColumnClass ?>"><?= $Page->gst_included->caption() ?><?= $Page->gst_included->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->gst_included->cellAttributes() ?>>
<span id="el_po_setup_gst_included">
    <select
        id="x_gst_included"
        name="x_gst_included"
        class="form-select ew-select<?= $Page->gst_included->isInvalidClass() ?>"
        <?php if (!$Page->gst_included->IsNativeSelect) { ?>
        data-select2-id="fpo_setupadd_x_gst_included"
        <?php } ?>
        data-table="po_setup"
        data-field="x_gst_included"
        data-value-separator="<?= $Page->gst_included->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->gst_included->getPlaceHolder()) ?>"
        <?= $Page->gst_included->editAttributes() ?>>
        <?= $Page->gst_included->selectOptionListHtml("x_gst_included") ?>
    </select>
    <?= $Page->gst_included->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->gst_included->getErrorMessage() ?></div>
<?php if (!$Page->gst_included->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_setupadd", function() {
    var options = { name: "x_gst_included", selectId: "fpo_setupadd_x_gst_included" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_setupadd.lists.gst_included?.lookupOptions.length) {
        options.data = { id: "x_gst_included", form: "fpo_setupadd" };
    } else {
        options.ajax = { id: "x_gst_included", form: "fpo_setupadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_setup.fields.gst_included.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->po_b_transfer->Visible) { // po_b_transfer ?>
    <div id="r_po_b_transfer"<?= $Page->po_b_transfer->rowAttributes() ?>>
        <label id="elh_po_setup_po_b_transfer" for="x_po_b_transfer" class="<?= $Page->LeftColumnClass ?>"><?= $Page->po_b_transfer->caption() ?><?= $Page->po_b_transfer->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->po_b_transfer->cellAttributes() ?>>
<span id="el_po_setup_po_b_transfer">
    <select
        id="x_po_b_transfer"
        name="x_po_b_transfer"
        class="form-select ew-select<?= $Page->po_b_transfer->isInvalidClass() ?>"
        <?php if (!$Page->po_b_transfer->IsNativeSelect) { ?>
        data-select2-id="fpo_setupadd_x_po_b_transfer"
        <?php } ?>
        data-table="po_setup"
        data-field="x_po_b_transfer"
        data-value-separator="<?= $Page->po_b_transfer->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->po_b_transfer->getPlaceHolder()) ?>"
        <?= $Page->po_b_transfer->editAttributes() ?>>
        <?= $Page->po_b_transfer->selectOptionListHtml("x_po_b_transfer") ?>
    </select>
    <?= $Page->po_b_transfer->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->po_b_transfer->getErrorMessage() ?></div>
<?php if (!$Page->po_b_transfer->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_setupadd", function() {
    var options = { name: "x_po_b_transfer", selectId: "fpo_setupadd_x_po_b_transfer" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_setupadd.lists.po_b_transfer?.lookupOptions.length) {
        options.data = { id: "x_po_b_transfer", form: "fpo_setupadd" };
    } else {
        options.ajax = { id: "x_po_b_transfer", form: "fpo_setupadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_setup.fields.po_b_transfer.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->po_b_sample_auto_auth->Visible) { // po_b_sample_auto_auth ?>
    <div id="r_po_b_sample_auto_auth"<?= $Page->po_b_sample_auto_auth->rowAttributes() ?>>
        <label id="elh_po_setup_po_b_sample_auto_auth" for="x_po_b_sample_auto_auth" class="<?= $Page->LeftColumnClass ?>"><?= $Page->po_b_sample_auto_auth->caption() ?><?= $Page->po_b_sample_auto_auth->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->po_b_sample_auto_auth->cellAttributes() ?>>
<span id="el_po_setup_po_b_sample_auto_auth">
    <select
        id="x_po_b_sample_auto_auth"
        name="x_po_b_sample_auto_auth"
        class="form-select ew-select<?= $Page->po_b_sample_auto_auth->isInvalidClass() ?>"
        <?php if (!$Page->po_b_sample_auto_auth->IsNativeSelect) { ?>
        data-select2-id="fpo_setupadd_x_po_b_sample_auto_auth"
        <?php } ?>
        data-table="po_setup"
        data-field="x_po_b_sample_auto_auth"
        data-value-separator="<?= $Page->po_b_sample_auto_auth->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->po_b_sample_auto_auth->getPlaceHolder()) ?>"
        <?= $Page->po_b_sample_auto_auth->editAttributes() ?>>
        <?= $Page->po_b_sample_auto_auth->selectOptionListHtml("x_po_b_sample_auto_auth") ?>
    </select>
    <?= $Page->po_b_sample_auto_auth->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->po_b_sample_auto_auth->getErrorMessage() ?></div>
<?php if (!$Page->po_b_sample_auto_auth->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_setupadd", function() {
    var options = { name: "x_po_b_sample_auto_auth", selectId: "fpo_setupadd_x_po_b_sample_auto_auth" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_setupadd.lists.po_b_sample_auto_auth?.lookupOptions.length) {
        options.data = { id: "x_po_b_sample_auto_auth", form: "fpo_setupadd" };
    } else {
        options.ajax = { id: "x_po_b_sample_auto_auth", form: "fpo_setupadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_setup.fields.po_b_sample_auto_auth.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->po_s_sample_auto_auth->Visible) { // po_s_sample_auto_auth ?>
    <div id="r_po_s_sample_auto_auth"<?= $Page->po_s_sample_auto_auth->rowAttributes() ?>>
        <label id="elh_po_setup_po_s_sample_auto_auth" for="x_po_s_sample_auto_auth" class="<?= $Page->LeftColumnClass ?>"><?= $Page->po_s_sample_auto_auth->caption() ?><?= $Page->po_s_sample_auto_auth->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->po_s_sample_auto_auth->cellAttributes() ?>>
<span id="el_po_setup_po_s_sample_auto_auth">
    <select
        id="x_po_s_sample_auto_auth"
        name="x_po_s_sample_auto_auth"
        class="form-select ew-select<?= $Page->po_s_sample_auto_auth->isInvalidClass() ?>"
        <?php if (!$Page->po_s_sample_auto_auth->IsNativeSelect) { ?>
        data-select2-id="fpo_setupadd_x_po_s_sample_auto_auth"
        <?php } ?>
        data-table="po_setup"
        data-field="x_po_s_sample_auto_auth"
        data-value-separator="<?= $Page->po_s_sample_auto_auth->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->po_s_sample_auto_auth->getPlaceHolder()) ?>"
        <?= $Page->po_s_sample_auto_auth->editAttributes() ?>>
        <?= $Page->po_s_sample_auto_auth->selectOptionListHtml("x_po_s_sample_auto_auth") ?>
    </select>
    <?= $Page->po_s_sample_auto_auth->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->po_s_sample_auto_auth->getErrorMessage() ?></div>
<?php if (!$Page->po_s_sample_auto_auth->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_setupadd", function() {
    var options = { name: "x_po_s_sample_auto_auth", selectId: "fpo_setupadd_x_po_s_sample_auto_auth" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_setupadd.lists.po_s_sample_auto_auth?.lookupOptions.length) {
        options.data = { id: "x_po_s_sample_auto_auth", form: "fpo_setupadd" };
    } else {
        options.ajax = { id: "x_po_s_sample_auto_auth", form: "fpo_setupadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_setup.fields.po_s_sample_auto_auth.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->po_cbm->Visible) { // po_cbm ?>
    <div id="r_po_cbm"<?= $Page->po_cbm->rowAttributes() ?>>
        <label id="elh_po_setup_po_cbm" for="x_po_cbm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->po_cbm->caption() ?><?= $Page->po_cbm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->po_cbm->cellAttributes() ?>>
<span id="el_po_setup_po_cbm">
    <select
        id="x_po_cbm"
        name="x_po_cbm"
        class="form-select ew-select<?= $Page->po_cbm->isInvalidClass() ?>"
        <?php if (!$Page->po_cbm->IsNativeSelect) { ?>
        data-select2-id="fpo_setupadd_x_po_cbm"
        <?php } ?>
        data-table="po_setup"
        data-field="x_po_cbm"
        data-value-separator="<?= $Page->po_cbm->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->po_cbm->getPlaceHolder()) ?>"
        <?= $Page->po_cbm->editAttributes() ?>>
        <?= $Page->po_cbm->selectOptionListHtml("x_po_cbm") ?>
    </select>
    <?= $Page->po_cbm->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->po_cbm->getErrorMessage() ?></div>
<?php if (!$Page->po_cbm->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_setupadd", function() {
    var options = { name: "x_po_cbm", selectId: "fpo_setupadd_x_po_cbm" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_setupadd.lists.po_cbm?.lookupOptions.length) {
        options.data = { id: "x_po_cbm", form: "fpo_setupadd" };
    } else {
        options.ajax = { id: "x_po_cbm", form: "fpo_setupadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_setup.fields.po_cbm.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->po_buyer_uid->Visible) { // po_buyer_uid ?>
    <div id="r_po_buyer_uid"<?= $Page->po_buyer_uid->rowAttributes() ?>>
        <label id="elh_po_setup_po_buyer_uid" for="x_po_buyer_uid" class="<?= $Page->LeftColumnClass ?>"><?= $Page->po_buyer_uid->caption() ?><?= $Page->po_buyer_uid->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->po_buyer_uid->cellAttributes() ?>>
<span id="el_po_setup_po_buyer_uid">
    <select
        id="x_po_buyer_uid"
        name="x_po_buyer_uid"
        class="form-select ew-select<?= $Page->po_buyer_uid->isInvalidClass() ?>"
        <?php if (!$Page->po_buyer_uid->IsNativeSelect) { ?>
        data-select2-id="fpo_setupadd_x_po_buyer_uid"
        <?php } ?>
        data-table="po_setup"
        data-field="x_po_buyer_uid"
        data-value-separator="<?= $Page->po_buyer_uid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->po_buyer_uid->getPlaceHolder()) ?>"
        <?= $Page->po_buyer_uid->editAttributes() ?>>
        <?= $Page->po_buyer_uid->selectOptionListHtml("x_po_buyer_uid") ?>
    </select>
    <?= $Page->po_buyer_uid->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->po_buyer_uid->getErrorMessage() ?></div>
<?php if (!$Page->po_buyer_uid->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_setupadd", function() {
    var options = { name: "x_po_buyer_uid", selectId: "fpo_setupadd_x_po_buyer_uid" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_setupadd.lists.po_buyer_uid?.lookupOptions.length) {
        options.data = { id: "x_po_buyer_uid", form: "fpo_setupadd" };
    } else {
        options.ajax = { id: "x_po_buyer_uid", form: "fpo_setupadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_setup.fields.po_buyer_uid.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->po_gst->Visible) { // po_gst ?>
    <div id="r_po_gst"<?= $Page->po_gst->rowAttributes() ?>>
        <label id="elh_po_setup_po_gst" for="x_po_gst" class="<?= $Page->LeftColumnClass ?>"><?= $Page->po_gst->caption() ?><?= $Page->po_gst->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->po_gst->cellAttributes() ?>>
<span id="el_po_setup_po_gst">
    <select
        id="x_po_gst"
        name="x_po_gst"
        class="form-select ew-select<?= $Page->po_gst->isInvalidClass() ?>"
        <?php if (!$Page->po_gst->IsNativeSelect) { ?>
        data-select2-id="fpo_setupadd_x_po_gst"
        <?php } ?>
        data-table="po_setup"
        data-field="x_po_gst"
        data-value-separator="<?= $Page->po_gst->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->po_gst->getPlaceHolder()) ?>"
        <?= $Page->po_gst->editAttributes() ?>>
        <?= $Page->po_gst->selectOptionListHtml("x_po_gst") ?>
    </select>
    <?= $Page->po_gst->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->po_gst->getErrorMessage() ?></div>
<?php if (!$Page->po_gst->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_setupadd", function() {
    var options = { name: "x_po_gst", selectId: "fpo_setupadd_x_po_gst" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_setupadd.lists.po_gst?.lookupOptions.length) {
        options.data = { id: "x_po_gst", form: "fpo_setupadd" };
    } else {
        options.ajax = { id: "x_po_gst", form: "fpo_setupadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_setup.fields.po_gst.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->po_sqm->Visible) { // po_sqm ?>
    <div id="r_po_sqm"<?= $Page->po_sqm->rowAttributes() ?>>
        <label id="elh_po_setup_po_sqm" for="x_po_sqm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->po_sqm->caption() ?><?= $Page->po_sqm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->po_sqm->cellAttributes() ?>>
<span id="el_po_setup_po_sqm">
    <select
        id="x_po_sqm"
        name="x_po_sqm"
        class="form-select ew-select<?= $Page->po_sqm->isInvalidClass() ?>"
        <?php if (!$Page->po_sqm->IsNativeSelect) { ?>
        data-select2-id="fpo_setupadd_x_po_sqm"
        <?php } ?>
        data-table="po_setup"
        data-field="x_po_sqm"
        data-value-separator="<?= $Page->po_sqm->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->po_sqm->getPlaceHolder()) ?>"
        <?= $Page->po_sqm->editAttributes() ?>>
        <?= $Page->po_sqm->selectOptionListHtml("x_po_sqm") ?>
    </select>
    <?= $Page->po_sqm->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->po_sqm->getErrorMessage() ?></div>
<?php if (!$Page->po_sqm->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_setupadd", function() {
    var options = { name: "x_po_sqm", selectId: "fpo_setupadd_x_po_sqm" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_setupadd.lists.po_sqm?.lookupOptions.length) {
        options.data = { id: "x_po_sqm", form: "fpo_setupadd" };
    } else {
        options.ajax = { id: "x_po_sqm", form: "fpo_setupadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_setup.fields.po_sqm.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->po_prod_price->Visible) { // po_prod_price ?>
    <div id="r_po_prod_price"<?= $Page->po_prod_price->rowAttributes() ?>>
        <label id="elh_po_setup_po_prod_price" for="x_po_prod_price" class="<?= $Page->LeftColumnClass ?>"><?= $Page->po_prod_price->caption() ?><?= $Page->po_prod_price->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->po_prod_price->cellAttributes() ?>>
<span id="el_po_setup_po_prod_price">
    <select
        id="x_po_prod_price"
        name="x_po_prod_price"
        class="form-select ew-select<?= $Page->po_prod_price->isInvalidClass() ?>"
        <?php if (!$Page->po_prod_price->IsNativeSelect) { ?>
        data-select2-id="fpo_setupadd_x_po_prod_price"
        <?php } ?>
        data-table="po_setup"
        data-field="x_po_prod_price"
        data-value-separator="<?= $Page->po_prod_price->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->po_prod_price->getPlaceHolder()) ?>"
        <?= $Page->po_prod_price->editAttributes() ?>>
        <?= $Page->po_prod_price->selectOptionListHtml("x_po_prod_price") ?>
    </select>
    <?= $Page->po_prod_price->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->po_prod_price->getErrorMessage() ?></div>
<?php if (!$Page->po_prod_price->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_setupadd", function() {
    var options = { name: "x_po_prod_price", selectId: "fpo_setupadd_x_po_prod_price" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_setupadd.lists.po_prod_price?.lookupOptions.length) {
        options.data = { id: "x_po_prod_price", form: "fpo_setupadd" };
    } else {
        options.ajax = { id: "x_po_prod_price", form: "fpo_setupadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_setup.fields.po_prod_price.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->po_size->Visible) { // po_size ?>
    <div id="r_po_size"<?= $Page->po_size->rowAttributes() ?>>
        <label id="elh_po_setup_po_size" for="x_po_size" class="<?= $Page->LeftColumnClass ?>"><?= $Page->po_size->caption() ?><?= $Page->po_size->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->po_size->cellAttributes() ?>>
<span id="el_po_setup_po_size">
<input type="<?= $Page->po_size->getInputTextType() ?>" name="x_po_size" id="x_po_size" data-table="po_setup" data-field="x_po_size" value="<?= $Page->po_size->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po_size->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po_size->formatPattern()) ?>"<?= $Page->po_size->editAttributes() ?> aria-describedby="x_po_size_help">
<?= $Page->po_size->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->po_size->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->po_bom->Visible) { // po_bom ?>
    <div id="r_po_bom"<?= $Page->po_bom->rowAttributes() ?>>
        <label id="elh_po_setup_po_bom" for="x_po_bom" class="<?= $Page->LeftColumnClass ?>"><?= $Page->po_bom->caption() ?><?= $Page->po_bom->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->po_bom->cellAttributes() ?>>
<span id="el_po_setup_po_bom">
<input type="<?= $Page->po_bom->getInputTextType() ?>" name="x_po_bom" id="x_po_bom" data-table="po_setup" data-field="x_po_bom" value="<?= $Page->po_bom->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po_bom->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po_bom->formatPattern()) ?>"<?= $Page->po_bom->editAttributes() ?> aria-describedby="x_po_bom_help">
<?= $Page->po_bom->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->po_bom->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->po_process->Visible) { // po_process ?>
    <div id="r_po_process"<?= $Page->po_process->rowAttributes() ?>>
        <label id="elh_po_setup_po_process" for="x_po_process" class="<?= $Page->LeftColumnClass ?>"><?= $Page->po_process->caption() ?><?= $Page->po_process->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->po_process->cellAttributes() ?>>
<span id="el_po_setup_po_process">
<input type="<?= $Page->po_process->getInputTextType() ?>" name="x_po_process" id="x_po_process" data-table="po_setup" data-field="x_po_process" value="<?= $Page->po_process->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po_process->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po_process->formatPattern()) ?>"<?= $Page->po_process->editAttributes() ?> aria-describedby="x_po_process_help">
<?= $Page->po_process->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->po_process->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->po_buyer_code_prod->Visible) { // po_buyer_code_prod ?>
    <div id="r_po_buyer_code_prod"<?= $Page->po_buyer_code_prod->rowAttributes() ?>>
        <label id="elh_po_setup_po_buyer_code_prod" for="x_po_buyer_code_prod" class="<?= $Page->LeftColumnClass ?>"><?= $Page->po_buyer_code_prod->caption() ?><?= $Page->po_buyer_code_prod->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->po_buyer_code_prod->cellAttributes() ?>>
<span id="el_po_setup_po_buyer_code_prod">
<input type="<?= $Page->po_buyer_code_prod->getInputTextType() ?>" name="x_po_buyer_code_prod" id="x_po_buyer_code_prod" data-table="po_setup" data-field="x_po_buyer_code_prod" value="<?= $Page->po_buyer_code_prod->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po_buyer_code_prod->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po_buyer_code_prod->formatPattern()) ?>"<?= $Page->po_buyer_code_prod->editAttributes() ?> aria-describedby="x_po_buyer_code_prod_help">
<?= $Page->po_buyer_code_prod->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->po_buyer_code_prod->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->mr_live_datetime->Visible) { // mr_live_datetime ?>
    <div id="r_mr_live_datetime"<?= $Page->mr_live_datetime->rowAttributes() ?>>
        <label id="elh_po_setup_mr_live_datetime" for="x_mr_live_datetime" class="<?= $Page->LeftColumnClass ?>"><?= $Page->mr_live_datetime->caption() ?><?= $Page->mr_live_datetime->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->mr_live_datetime->cellAttributes() ?>>
<span id="el_po_setup_mr_live_datetime">
<input type="<?= $Page->mr_live_datetime->getInputTextType() ?>" name="x_mr_live_datetime" id="x_mr_live_datetime" data-table="po_setup" data-field="x_mr_live_datetime" value="<?= $Page->mr_live_datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->mr_live_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mr_live_datetime->formatPattern()) ?>"<?= $Page->mr_live_datetime->editAttributes() ?> aria-describedby="x_mr_live_datetime_help">
<?= $Page->mr_live_datetime->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->mr_live_datetime->getErrorMessage() ?></div>
<?php if (!$Page->mr_live_datetime->ReadOnly && !$Page->mr_live_datetime->Disabled && !isset($Page->mr_live_datetime->EditAttrs["readonly"]) && !isset($Page->mr_live_datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpo_setupadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpo_setupadd", "x_mr_live_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->po_b_unauthorize->Visible) { // po_b_unauthorize ?>
    <div id="r_po_b_unauthorize"<?= $Page->po_b_unauthorize->rowAttributes() ?>>
        <label id="elh_po_setup_po_b_unauthorize" for="x_po_b_unauthorize" class="<?= $Page->LeftColumnClass ?>"><?= $Page->po_b_unauthorize->caption() ?><?= $Page->po_b_unauthorize->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->po_b_unauthorize->cellAttributes() ?>>
<span id="el_po_setup_po_b_unauthorize">
    <select
        id="x_po_b_unauthorize[]"
        name="x_po_b_unauthorize[]"
        class="form-select ew-select<?= $Page->po_b_unauthorize->isInvalidClass() ?>"
        <?php if (!$Page->po_b_unauthorize->IsNativeSelect) { ?>
        data-select2-id="fpo_setupadd_x_po_b_unauthorize[]"
        <?php } ?>
        data-table="po_setup"
        data-field="x_po_b_unauthorize"
        multiple
        size="1"
        data-value-separator="<?= $Page->po_b_unauthorize->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->po_b_unauthorize->getPlaceHolder()) ?>"
        <?= $Page->po_b_unauthorize->editAttributes() ?>>
        <?= $Page->po_b_unauthorize->selectOptionListHtml("x_po_b_unauthorize[]") ?>
    </select>
    <?= $Page->po_b_unauthorize->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->po_b_unauthorize->getErrorMessage() ?></div>
<?= $Page->po_b_unauthorize->Lookup->getParamTag($Page, "p_x_po_b_unauthorize") ?>
<?php if (!$Page->po_b_unauthorize->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_setupadd", function() {
    var options = { name: "x_po_b_unauthorize[]", selectId: "fpo_setupadd_x_po_b_unauthorize[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_setupadd.lists.po_b_unauthorize?.lookupOptions.length) {
        options.data = { id: "x_po_b_unauthorize[]", form: "fpo_setupadd" };
    } else {
        options.ajax = { id: "x_po_b_unauthorize[]", form: "fpo_setupadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_setup.fields.po_b_unauthorize.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->cart_b_password->Visible) { // cart_b_password ?>
    <div id="r_cart_b_password"<?= $Page->cart_b_password->rowAttributes() ?>>
        <label id="elh_po_setup_cart_b_password" for="x_cart_b_password" class="<?= $Page->LeftColumnClass ?>"><?= $Page->cart_b_password->caption() ?><?= $Page->cart_b_password->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->cart_b_password->cellAttributes() ?>>
<span id="el_po_setup_cart_b_password">
<input type="<?= $Page->cart_b_password->getInputTextType() ?>" name="x_cart_b_password" id="x_cart_b_password" data-table="po_setup" data-field="x_cart_b_password" value="<?= $Page->cart_b_password->EditValue ?>" size="30" maxlength="8" placeholder="<?= HtmlEncode($Page->cart_b_password->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cart_b_password->formatPattern()) ?>"<?= $Page->cart_b_password->editAttributes() ?> aria-describedby="x_cart_b_password_help">
<?= $Page->cart_b_password->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->cart_b_password->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->cart_s_password->Visible) { // cart_s_password ?>
    <div id="r_cart_s_password"<?= $Page->cart_s_password->rowAttributes() ?>>
        <label id="elh_po_setup_cart_s_password" for="x_cart_s_password" class="<?= $Page->LeftColumnClass ?>"><?= $Page->cart_s_password->caption() ?><?= $Page->cart_s_password->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->cart_s_password->cellAttributes() ?>>
<span id="el_po_setup_cart_s_password">
<input type="<?= $Page->cart_s_password->getInputTextType() ?>" name="x_cart_s_password" id="x_cart_s_password" data-table="po_setup" data-field="x_cart_s_password" value="<?= $Page->cart_s_password->EditValue ?>" size="30" maxlength="8" placeholder="<?= HtmlEncode($Page->cart_s_password->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cart_s_password->formatPattern()) ?>"<?= $Page->cart_s_password->editAttributes() ?> aria-describedby="x_cart_s_password_help">
<?= $Page->cart_s_password->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->cart_s_password->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->jc_po_yesno->Visible) { // jc_po_yesno ?>
    <div id="r_jc_po_yesno"<?= $Page->jc_po_yesno->rowAttributes() ?>>
        <label id="elh_po_setup_jc_po_yesno" class="<?= $Page->LeftColumnClass ?>"><?= $Page->jc_po_yesno->caption() ?><?= $Page->jc_po_yesno->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->jc_po_yesno->cellAttributes() ?>>
<span id="el_po_setup_jc_po_yesno">
<?php
if (IsRTL()) {
    $Page->jc_po_yesno->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_jc_po_yesno" class="ew-auto-suggest">
    <input type="<?= $Page->jc_po_yesno->getInputTextType() ?>" class="form-control" name="sv_x_jc_po_yesno" id="sv_x_jc_po_yesno" value="<?= RemoveHtml($Page->jc_po_yesno->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->jc_po_yesno->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->jc_po_yesno->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->jc_po_yesno->formatPattern()) ?>"<?= $Page->jc_po_yesno->editAttributes() ?> aria-describedby="x_jc_po_yesno_help">
</span>
<selection-list hidden class="form-control" data-table="po_setup" data-field="x_jc_po_yesno" data-input="sv_x_jc_po_yesno" data-value-separator="<?= $Page->jc_po_yesno->displayValueSeparatorAttribute() ?>" name="x_jc_po_yesno" id="x_jc_po_yesno" value="<?= HtmlEncode($Page->jc_po_yesno->CurrentValue) ?>"></selection-list>
<?= $Page->jc_po_yesno->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->jc_po_yesno->getErrorMessage() ?></div>
<script>
loadjs.ready("fpo_setupadd", function() {
    fpo_setupadd.createAutoSuggest(Object.assign({"id":"x_jc_po_yesno","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->jc_po_yesno->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.po_setup.fields.jc_po_yesno.autoSuggestOptions));
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fpo_setupadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpo_setupadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("po_setup");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
