<?php

namespace PHPMaker2024\fibre;

// Page object
$PoSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { po: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fposearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fposearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["order_type", [], fields.order_type.isInvalid],
            ["buyer_id", [], fields.buyer_id.isInvalid],
            ["buyer_order_no", [], fields.buyer_order_no.isInvalid],
            ["buyer_order_date", [ew.Validators.datetime(fields.buyer_order_date.clientFormatPattern)], fields.buyer_order_date.isInvalid],
            ["cart_id", [], fields.cart_id.isInvalid],
            ["buyer_product_ref", [], fields.buyer_product_ref.isInvalid],
            ["grp", [], fields.grp.isInvalid],
            ["s_grp", [], fields.s_grp.isInvalid],
            ["product", [], fields.product.isInvalid],
            ["rid", [], fields.rid.isInvalid],
            ["despatch_week", [], fields.despatch_week.isInvalid],
            ["payment_terms", [], fields.payment_terms.isInvalid],
            ["transport_terms", [], fields.transport_terms.isInvalid],
            ["buyer_shipping_id", [ew.Validators.integer], fields.buyer_shipping_id.isInvalid],
            ["description_03", [], fields.description_03.isInvalid],
            ["description_07", [ew.Validators.float], fields.description_07.isInvalid],
            ["description_20", [], fields.description_20.isInvalid],
            ["description_17", [ew.Validators.float], fields.description_17.isInvalid],
            ["description_18", [ew.Validators.float], fields.description_18.isInvalid],
            ["description_19", [ew.Validators.float], fields.description_19.isInvalid],
            ["quantity", [], fields.quantity.isInvalid],
            ["price", [], fields.price.isInvalid],
            ["currency", [], fields.currency.isInvalid],
            ["amount", [ew.Validators.float], fields.amount.isInvalid],
            ["cbm", [ew.Validators.float], fields.cbm.isInvalid],
            ["buyer_size", [], fields.buyer_size.isInvalid],
            ["description_05", [], fields.description_05.isInvalid],
            ["description_06", [], fields.description_06.isInvalid],
            ["description_08", [ew.Validators.float], fields.description_08.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [], fields.datetime.isInvalid],
            ["a_operator", [], fields.a_operator.isInvalid],
            ["a_datetime", [], fields.a_datetime.isInvalid],
            ["buyer_instruction", [], fields.buyer_instruction.isInvalid],
            ["d_09_head", [], fields.d_09_head.isInvalid],
            ["description_09", [], fields.description_09.isInvalid],
            ["d_10_head", [], fields.d_10_head.isInvalid],
            ["description_10", [], fields.description_10.isInvalid],
            ["d_11_head", [], fields.d_11_head.isInvalid],
            ["description_11", [], fields.description_11.isInvalid],
            ["d_12_head", [], fields.d_12_head.isInvalid],
            ["description_12", [], fields.description_12.isInvalid],
            ["_action", [], fields._action.isInvalid],
            ["url", [], fields.url.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "order_type": <?= $Page->order_type->toClientList($Page) ?>,
            "buyer_id": <?= $Page->buyer_id->toClientList($Page) ?>,
            "cart_id": <?= $Page->cart_id->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "despatch_week": <?= $Page->despatch_week->toClientList($Page) ?>,
            "payment_terms": <?= $Page->payment_terms->toClientList($Page) ?>,
            "description_03": <?= $Page->description_03->toClientList($Page) ?>,
            "description_20": <?= $Page->description_20->toClientList($Page) ?>,
            "currency": <?= $Page->currency->toClientList($Page) ?>,
            "description_05": <?= $Page->description_05->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
            "a_operator": <?= $Page->a_operator->toClientList($Page) ?>,
            "d_09_head": <?= $Page->d_09_head->toClientList($Page) ?>,
            "d_10_head": <?= $Page->d_10_head->toClientList($Page) ?>,
            "d_11_head": <?= $Page->d_11_head->toClientList($Page) ?>,
            "d_12_head": <?= $Page->d_12_head->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fposearch" id="fposearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="po">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<?php if ($Page->MultiPages->Items[0]->Visible) { ?>
<div class="ew-search-div"><!-- page0 -->
<?php if ($Page->order_type->Visible) { // order_type ?>
    <div id="r_order_type" class="row"<?= $Page->order_type->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_order_type"><?= $Page->order_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_order_type" id="z_order_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->order_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_order_type" class="ew-search-field ew-search-field-single">
<template id="tp_x_order_type">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="po" data-field="x_order_type" name="x_order_type" id="x_order_type"<?= $Page->order_type->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_order_type" class="ew-item-list"></div>
<selection-list hidden
    id="x_order_type"
    name="x_order_type"
    value="<?= HtmlEncode($Page->order_type->AdvancedSearch->SearchValue) ?>"
    data-type="select-one"
    data-template="tp_x_order_type"
    data-target="dsl_x_order_type"
    data-repeatcolumn="5"
    class="form-control<?= $Page->order_type->isInvalidClass() ?>"
    data-table="po"
    data-field="x_order_type"
    data-page="0"
    data-value-separator="<?= $Page->order_type->displayValueSeparatorAttribute() ?>"
    <?= $Page->order_type->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->order_type->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->cart_id->Visible) { // cart_id ?>
    <div id="r_cart_id" class="row"<?= $Page->cart_id->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_cart_id"><?= $Page->cart_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_cart_id" id="z_cart_id" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->cart_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_cart_id" class="ew-search-field ew-search-field-single">
<template id="tp_x_cart_id">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="po" data-field="x_cart_id" name="x_cart_id" id="x_cart_id"<?= $Page->cart_id->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_cart_id" class="ew-item-list"></div>
<selection-list hidden
    id="x_cart_id[]"
    name="x_cart_id[]"
    value="<?= HtmlEncode($Page->cart_id->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_cart_id"
    data-target="dsl_x_cart_id"
    data-repeatcolumn="1"
    class="form-control<?= $Page->cart_id->isInvalidClass() ?>"
    data-table="po"
    data-field="x_cart_id"
    data-page="0"
    data-value-separator="<?= $Page->cart_id->displayValueSeparatorAttribute() ?>"
    <?= $Page->cart_id->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->cart_id->getErrorMessage(false) ?></div>
<?= $Page->cart_id->Lookup->getParamTag($Page, "p_x_cart_id") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp" class="row"<?= $Page->grp->rowAttributes() ?>>
        <label for="x_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_grp"><?= $Page->grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fposearch_x_grp"
        <?php } ?>
        data-table="po"
        data-field="x_grp"
        data-page="0"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fposearch", function() {
    var options = { name: "x_grp", selectId: "fposearch_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fposearch.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fposearch" };
    } else {
        options.ajax = { id: "x_grp", form: "fposearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp" class="row"<?= $Page->s_grp->rowAttributes() ?>>
        <label for="x_s_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_grp"><?= $Page->s_grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_s_grp" id="z_s_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->s_grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="fposearch_x_s_grp"
        <?php } ?>
        data-table="po"
        data-field="x_s_grp"
        data-page="0"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage(false) ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fposearch", function() {
    var options = { name: "x_s_grp", selectId: "fposearch_x_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fposearch.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "fposearch" };
    } else {
        options.ajax = { id: "x_s_grp", form: "fposearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product" class="row"<?= $Page->product->rowAttributes() ?>>
        <label for="x_product" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_product"><?= $Page->product->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product" id="z_product" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_product" class="ew-search-field ew-search-field-single">
    <select
        id="x_product"
        name="x_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="fposearch_x_product"
        <?php } ?>
        data-table="po"
        data-field="x_product"
        data-page="0"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage(false) ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fposearch", function() {
    var options = { name: "x_product", selectId: "fposearch_x_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fposearch.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "fposearch" };
    } else {
        options.ajax = { id: "x_product", form: "fposearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
    <div id="r_rid" class="row"<?= $Page->rid->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_rid"><?= $Page->rid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_rid" id="z_rid" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_rid" class="ew-search-field ew-search-field-single">
<template id="tp_x_rid">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="po" data-field="x_rid" name="x_rid" id="x_rid"<?= $Page->rid->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_rid" class="ew-item-list"></div>
<selection-list hidden
    id="x_rid"
    name="x_rid"
    value="<?= HtmlEncode($Page->rid->AdvancedSearch->SearchValue) ?>"
    data-type="select-one"
    data-template="tp_x_rid"
    data-target="dsl_x_rid"
    data-repeatcolumn="1"
    class="form-control<?= $Page->rid->isInvalidClass() ?>"
    data-table="po"
    data-field="x_rid"
    data-page="0"
    data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>"
    <?= $Page->rid->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->rid->getErrorMessage(false) ?></div>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="accordion ew-accordion" id="accordion_PoSearch"><!-- multi-page accordion -->
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(1)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(1)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_po1"><?= $Page->pageCaption(1) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(1)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_po1"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="po" data-field="x_id" value="<?= $Page->id->EditValue ?>" data-page="1" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_id->Visible) { // buyer_id ?>
    <div id="r_buyer_id" class="row"<?= $Page->buyer_id->rowAttributes() ?>>
        <label for="x_buyer_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_buyer_id"><?= $Page->buyer_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyer_id" id="z_buyer_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_buyer_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_buyer_id"
        name="x_buyer_id"
        class="form-select ew-select<?= $Page->buyer_id->isInvalidClass() ?>"
        <?php if (!$Page->buyer_id->IsNativeSelect) { ?>
        data-select2-id="fposearch_x_buyer_id"
        <?php } ?>
        data-table="po"
        data-field="x_buyer_id"
        data-page="1"
        data-value-separator="<?= $Page->buyer_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyer_id->getPlaceHolder()) ?>"
        <?= $Page->buyer_id->editAttributes() ?>>
        <?= $Page->buyer_id->selectOptionListHtml("x_buyer_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyer_id->getErrorMessage(false) ?></div>
<?= $Page->buyer_id->Lookup->getParamTag($Page, "p_x_buyer_id") ?>
<?php if (!$Page->buyer_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fposearch", function() {
    var options = { name: "x_buyer_id", selectId: "fposearch_x_buyer_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fposearch.lists.buyer_id?.lookupOptions.length) {
        options.data = { id: "x_buyer_id", form: "fposearch" };
    } else {
        options.ajax = { id: "x_buyer_id", form: "fposearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po.fields.buyer_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_order_no->Visible) { // buyer_order_no ?>
    <div id="r_buyer_order_no" class="row"<?= $Page->buyer_order_no->rowAttributes() ?>>
        <label for="x_buyer_order_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_buyer_order_no"><?= $Page->buyer_order_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_buyer_order_no" id="z_buyer_order_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_order_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_buyer_order_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_order_no->getInputTextType() ?>" name="x_buyer_order_no" id="x_buyer_order_no" data-table="po" data-field="x_buyer_order_no" value="<?= $Page->buyer_order_no->EditValue ?>" data-page="1" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->buyer_order_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_order_no->formatPattern()) ?>"<?= $Page->buyer_order_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_order_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_order_date->Visible) { // buyer_order_date ?>
    <div id="r_buyer_order_date" class="row"<?= $Page->buyer_order_date->rowAttributes() ?>>
        <label for="x_buyer_order_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_buyer_order_date"><?= $Page->buyer_order_date->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyer_order_date" id="z_buyer_order_date" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_order_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_buyer_order_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_order_date->getInputTextType() ?>" name="x_buyer_order_date" id="x_buyer_order_date" data-table="po" data-field="x_buyer_order_date" value="<?= $Page->buyer_order_date->EditValue ?>" data-page="1" placeholder="<?= HtmlEncode($Page->buyer_order_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_order_date->formatPattern()) ?>"<?= $Page->buyer_order_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_order_date->getErrorMessage(false) ?></div>
<?php if (!$Page->buyer_order_date->ReadOnly && !$Page->buyer_order_date->Disabled && !isset($Page->buyer_order_date->EditAttrs["readonly"]) && !isset($Page->buyer_order_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fposearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fposearch", "x_buyer_order_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_product_ref->Visible) { // buyer_product_ref ?>
    <div id="r_buyer_product_ref" class="row"<?= $Page->buyer_product_ref->rowAttributes() ?>>
        <label for="x_buyer_product_ref" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_buyer_product_ref"><?= $Page->buyer_product_ref->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_buyer_product_ref" id="z_buyer_product_ref" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_product_ref->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_buyer_product_ref" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_product_ref->getInputTextType() ?>" name="x_buyer_product_ref" id="x_buyer_product_ref" data-table="po" data-field="x_buyer_product_ref" value="<?= $Page->buyer_product_ref->EditValue ?>" data-page="1" size="30" maxlength="65535" placeholder="<?= HtmlEncode($Page->buyer_product_ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_product_ref->formatPattern()) ?>"<?= $Page->buyer_product_ref->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_product_ref->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->despatch_week->Visible) { // despatch_week ?>
    <div id="r_despatch_week" class="row"<?= $Page->despatch_week->rowAttributes() ?>>
        <label for="x_despatch_week" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_despatch_week"><?= $Page->despatch_week->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_despatch_week" id="z_despatch_week" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->despatch_week->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_despatch_week" class="ew-search-field ew-search-field-single">
    <select
        id="x_despatch_week"
        name="x_despatch_week"
        class="form-select ew-select<?= $Page->despatch_week->isInvalidClass() ?>"
        <?php if (!$Page->despatch_week->IsNativeSelect) { ?>
        data-select2-id="fposearch_x_despatch_week"
        <?php } ?>
        data-table="po"
        data-field="x_despatch_week"
        data-page="1"
        data-value-separator="<?= $Page->despatch_week->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->despatch_week->getPlaceHolder()) ?>"
        <?= $Page->despatch_week->editAttributes() ?>>
        <?= $Page->despatch_week->selectOptionListHtml("x_despatch_week") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->despatch_week->getErrorMessage(false) ?></div>
<?= $Page->despatch_week->Lookup->getParamTag($Page, "p_x_despatch_week") ?>
<?php if (!$Page->despatch_week->IsNativeSelect) { ?>
<script>
loadjs.ready("fposearch", function() {
    var options = { name: "x_despatch_week", selectId: "fposearch_x_despatch_week" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fposearch.lists.despatch_week?.lookupOptions.length) {
        options.data = { id: "x_despatch_week", form: "fposearch" };
    } else {
        options.ajax = { id: "x_despatch_week", form: "fposearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po.fields.despatch_week.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->payment_terms->Visible) { // payment_terms ?>
    <div id="r_payment_terms" class="row"<?= $Page->payment_terms->rowAttributes() ?>>
        <label for="x_payment_terms" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_payment_terms"><?= $Page->payment_terms->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_payment_terms" id="z_payment_terms" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->payment_terms->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_payment_terms" class="ew-search-field ew-search-field-single">
    <select
        id="x_payment_terms"
        name="x_payment_terms"
        class="form-select ew-select<?= $Page->payment_terms->isInvalidClass() ?>"
        <?php if (!$Page->payment_terms->IsNativeSelect) { ?>
        data-select2-id="fposearch_x_payment_terms"
        <?php } ?>
        data-table="po"
        data-field="x_payment_terms"
        data-page="1"
        data-value-separator="<?= $Page->payment_terms->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->payment_terms->getPlaceHolder()) ?>"
        <?= $Page->payment_terms->editAttributes() ?>>
        <?= $Page->payment_terms->selectOptionListHtml("x_payment_terms") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->payment_terms->getErrorMessage(false) ?></div>
<?= $Page->payment_terms->Lookup->getParamTag($Page, "p_x_payment_terms") ?>
<?php if (!$Page->payment_terms->IsNativeSelect) { ?>
<script>
loadjs.ready("fposearch", function() {
    var options = { name: "x_payment_terms", selectId: "fposearch_x_payment_terms" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fposearch.lists.payment_terms?.lookupOptions.length) {
        options.data = { id: "x_payment_terms", form: "fposearch" };
    } else {
        options.ajax = { id: "x_payment_terms", form: "fposearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po.fields.payment_terms.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->transport_terms->Visible) { // transport_terms ?>
    <div id="r_transport_terms" class="row"<?= $Page->transport_terms->rowAttributes() ?>>
        <label for="x_transport_terms" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_transport_terms"><?= $Page->transport_terms->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_transport_terms" id="z_transport_terms" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->transport_terms->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_transport_terms" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->transport_terms->getInputTextType() ?>" name="x_transport_terms" id="x_transport_terms" data-table="po" data-field="x_transport_terms" value="<?= $Page->transport_terms->EditValue ?>" data-page="1" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->transport_terms->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->transport_terms->formatPattern()) ?>"<?= $Page->transport_terms->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->transport_terms->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_shipping_id->Visible) { // buyer_shipping _id ?>
    <div id="r_buyer_shipping_id" class="row"<?= $Page->buyer_shipping_id->rowAttributes() ?>>
        <label for="x_buyer_shipping_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_buyer_shipping_id"><?= $Page->buyer_shipping_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyer_shipping_id" id="z_buyer_shipping_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_shipping_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_buyer_shipping_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_shipping_id->getInputTextType() ?>" name="x_buyer_shipping_id" id="x_buyer_shipping_id" data-table="po" data-field="x_buyer_shipping_id" value="<?= $Page->buyer_shipping_id->EditValue ?>" data-page="1" size="30" placeholder="<?= HtmlEncode($Page->buyer_shipping_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_shipping_id->formatPattern()) ?>"<?= $Page->buyer_shipping_id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_shipping_id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->currency->Visible) { // currency ?>
    <div id="r_currency" class="row"<?= $Page->currency->rowAttributes() ?>>
        <label for="x_currency" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_currency"><?= $Page->currency->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_currency" id="z_currency" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->currency->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_currency" class="ew-search-field ew-search-field-single">
    <select
        id="x_currency"
        name="x_currency"
        class="form-select ew-select<?= $Page->currency->isInvalidClass() ?>"
        <?php if (!$Page->currency->IsNativeSelect) { ?>
        data-select2-id="fposearch_x_currency"
        <?php } ?>
        data-table="po"
        data-field="x_currency"
        data-page="1"
        data-value-separator="<?= $Page->currency->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->currency->getPlaceHolder()) ?>"
        <?= $Page->currency->editAttributes() ?>>
        <?= $Page->currency->selectOptionListHtml("x_currency") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->currency->getErrorMessage(false) ?></div>
<?= $Page->currency->Lookup->getParamTag($Page, "p_x_currency") ?>
<?php if (!$Page->currency->IsNativeSelect) { ?>
<script>
loadjs.ready("fposearch", function() {
    var options = { name: "x_currency", selectId: "fposearch_x_currency" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fposearch.lists.currency?.lookupOptions.length) {
        options.data = { id: "x_currency", form: "fposearch" };
    } else {
        options.ajax = { id: "x_currency", form: "fposearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po.fields.currency.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="po" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" data-page="1" size="30" maxlength="500" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_instruction->Visible) { // buyer_instruction ?>
    <div id="r_buyer_instruction" class="row"<?= $Page->buyer_instruction->rowAttributes() ?>>
        <label for="x_buyer_instruction" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_buyer_instruction"><?= $Page->buyer_instruction->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_buyer_instruction" id="z_buyer_instruction" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_instruction->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_buyer_instruction" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_instruction->getInputTextType() ?>" name="x_buyer_instruction" id="x_buyer_instruction" data-table="po" data-field="x_buyer_instruction" value="<?= $Page->buyer_instruction->EditValue ?>" data-page="1" size="30" maxlength="500" placeholder="<?= HtmlEncode($Page->buyer_instruction->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_instruction->formatPattern()) ?>"<?= $Page->buyer_instruction->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_instruction->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_action->Visible) { // action ?>
    <div id="r__action" class="row"<?= $Page->_action->rowAttributes() ?>>
        <label for="x__action" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po__action"><?= $Page->_action->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__action" id="z__action" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_action->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po__action" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_action->getInputTextType() ?>" name="x__action" id="x__action" data-table="po" data-field="x__action" value="<?= $Page->_action->EditValue ?>" data-page="1" size="30" maxlength="45" placeholder="<?= HtmlEncode($Page->_action->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_action->formatPattern()) ?>"<?= $Page->_action->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_action->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->url->Visible) { // url ?>
    <div id="r_url" class="row"<?= $Page->url->rowAttributes() ?>>
        <label for="x_url" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_url"><?= $Page->url->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_url" id="z_url" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->url->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_url" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->url->getInputTextType() ?>" name="x_url" id="x_url" data-table="po" data-field="x_url" value="<?= $Page->url->EditValue ?>" data-page="1" size="30" maxlength="27" placeholder="<?= HtmlEncode($Page->url->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->url->formatPattern()) ?>"<?= $Page->url->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->url->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(2)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(2)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_po2"><?= $Page->pageCaption(2) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(2)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_po2"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->description_03->Visible) { // description_03 ?>
    <div id="r_description_03" class="row"<?= $Page->description_03->rowAttributes() ?>>
        <label for="x_description_03" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_description_03"><?= $Page->description_03->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_description_03" id="z_description_03" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description_03->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_description_03" class="ew-search-field ew-search-field-single">
    <select
        id="x_description_03"
        name="x_description_03"
        class="form-select ew-select<?= $Page->description_03->isInvalidClass() ?>"
        <?php if (!$Page->description_03->IsNativeSelect) { ?>
        data-select2-id="fposearch_x_description_03"
        <?php } ?>
        data-table="po"
        data-field="x_description_03"
        data-page="2"
        data-value-separator="<?= $Page->description_03->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->description_03->getPlaceHolder()) ?>"
        <?= $Page->description_03->editAttributes() ?>>
        <?= $Page->description_03->selectOptionListHtml("x_description_03") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->description_03->getErrorMessage(false) ?></div>
<?php if (!$Page->description_03->IsNativeSelect) { ?>
<script>
loadjs.ready("fposearch", function() {
    var options = { name: "x_description_03", selectId: "fposearch_x_description_03" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fposearch.lists.description_03?.lookupOptions.length) {
        options.data = { id: "x_description_03", form: "fposearch" };
    } else {
        options.ajax = { id: "x_description_03", form: "fposearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po.fields.description_03.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->description_07->Visible) { // description_07 ?>
    <div id="r_description_07" class="row"<?= $Page->description_07->rowAttributes() ?>>
        <label for="x_description_07" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_description_07"><?= $Page->description_07->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_description_07" id="z_description_07" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description_07->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_description_07" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->description_07->getInputTextType() ?>" name="x_description_07" id="x_description_07" data-table="po" data-field="x_description_07" value="<?= $Page->description_07->EditValue ?>" data-page="2" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->description_07->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description_07->formatPattern()) ?>"<?= $Page->description_07->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->description_07->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->description_20->Visible) { // description_20 ?>
    <div id="r_description_20" class="row"<?= $Page->description_20->rowAttributes() ?>>
        <label for="x_description_20" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_description_20"><?= $Page->description_20->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_description_20" id="z_description_20" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description_20->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_description_20" class="ew-search-field ew-search-field-single">
    <select
        id="x_description_20"
        name="x_description_20"
        class="form-select ew-select<?= $Page->description_20->isInvalidClass() ?>"
        <?php if (!$Page->description_20->IsNativeSelect) { ?>
        data-select2-id="fposearch_x_description_20"
        <?php } ?>
        data-table="po"
        data-field="x_description_20"
        data-page="2"
        data-value-separator="<?= $Page->description_20->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->description_20->getPlaceHolder()) ?>"
        <?= $Page->description_20->editAttributes() ?>>
        <?= $Page->description_20->selectOptionListHtml("x_description_20") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->description_20->getErrorMessage(false) ?></div>
<?php if (!$Page->description_20->IsNativeSelect) { ?>
<script>
loadjs.ready("fposearch", function() {
    var options = { name: "x_description_20", selectId: "fposearch_x_description_20" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fposearch.lists.description_20?.lookupOptions.length) {
        options.data = { id: "x_description_20", form: "fposearch" };
    } else {
        options.ajax = { id: "x_description_20", form: "fposearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po.fields.description_20.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->description_17->Visible) { // description_17 ?>
    <div id="r_description_17" class="row"<?= $Page->description_17->rowAttributes() ?>>
        <label for="x_description_17" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_description_17"><?= $Page->description_17->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_description_17" id="z_description_17" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description_17->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_description_17" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->description_17->getInputTextType() ?>" name="x_description_17" id="x_description_17" data-table="po" data-field="x_description_17" value="<?= $Page->description_17->EditValue ?>" data-page="2" size="30" placeholder="<?= HtmlEncode($Page->description_17->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description_17->formatPattern()) ?>"<?= $Page->description_17->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->description_17->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->description_18->Visible) { // description_18 ?>
    <div id="r_description_18" class="row"<?= $Page->description_18->rowAttributes() ?>>
        <label for="x_description_18" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_description_18"><?= $Page->description_18->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_description_18" id="z_description_18" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description_18->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_description_18" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->description_18->getInputTextType() ?>" name="x_description_18" id="x_description_18" data-table="po" data-field="x_description_18" value="<?= $Page->description_18->EditValue ?>" data-page="2" size="30" placeholder="<?= HtmlEncode($Page->description_18->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description_18->formatPattern()) ?>"<?= $Page->description_18->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->description_18->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->description_19->Visible) { // description_19 ?>
    <div id="r_description_19" class="row"<?= $Page->description_19->rowAttributes() ?>>
        <label for="x_description_19" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_description_19"><?= $Page->description_19->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_description_19" id="z_description_19" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description_19->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_description_19" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->description_19->getInputTextType() ?>" name="x_description_19" id="x_description_19" data-table="po" data-field="x_description_19" value="<?= $Page->description_19->EditValue ?>" data-page="2" size="30" placeholder="<?= HtmlEncode($Page->description_19->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description_19->formatPattern()) ?>"<?= $Page->description_19->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->description_19->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity" class="row"<?= $Page->quantity->rowAttributes() ?>>
        <label for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_quantity"><?= $Page->quantity->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_quantity" id="z_quantity" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->quantity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->quantity->getInputTextType() ?>" name="x_quantity" id="x_quantity" data-table="po" data-field="x_quantity" value="<?= $Page->quantity->EditValue ?>" data-page="2" size="30" placeholder="<?= HtmlEncode($Page->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity->formatPattern()) ?>"<?= $Page->quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->quantity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->price->Visible) { // price ?>
    <div id="r_price" class="row"<?= $Page->price->rowAttributes() ?>>
        <label for="x_price" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_price"><?= $Page->price->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_price" id="z_price" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->price->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_price" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->price->getInputTextType() ?>" name="x_price" id="x_price" data-table="po" data-field="x_price" value="<?= $Page->price->EditValue ?>" data-page="2" size="30" placeholder="<?= HtmlEncode($Page->price->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->price->formatPattern()) ?>"<?= $Page->price->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->price->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
    <div id="r_amount" class="row"<?= $Page->amount->rowAttributes() ?>>
        <label for="x_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_amount"><?= $Page->amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_amount" id="z_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->amount->getInputTextType() ?>" name="x_amount" id="x_amount" data-table="po" data-field="x_amount" value="<?= $Page->amount->EditValue ?>" data-page="2" size="30" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->cbm->Visible) { // cbm ?>
    <div id="r_cbm" class="row"<?= $Page->cbm->rowAttributes() ?>>
        <label for="x_cbm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_cbm"><?= $Page->cbm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_cbm" id="z_cbm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->cbm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_cbm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->cbm->getInputTextType() ?>" name="x_cbm" id="x_cbm" data-table="po" data-field="x_cbm" value="<?= $Page->cbm->EditValue ?>" data-page="2" size="30" placeholder="<?= HtmlEncode($Page->cbm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cbm->formatPattern()) ?>"<?= $Page->cbm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->cbm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_size->Visible) { // buyer_size ?>
    <div id="r_buyer_size" class="row"<?= $Page->buyer_size->rowAttributes() ?>>
        <label for="x_buyer_size" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_buyer_size"><?= $Page->buyer_size->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_buyer_size" id="z_buyer_size" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_size->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_buyer_size" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_size->getInputTextType() ?>" name="x_buyer_size" id="x_buyer_size" data-table="po" data-field="x_buyer_size" value="<?= $Page->buyer_size->EditValue ?>" data-page="2" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->buyer_size->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_size->formatPattern()) ?>"<?= $Page->buyer_size->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_size->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->description_05->Visible) { // description_05 ?>
    <div id="r_description_05" class="row"<?= $Page->description_05->rowAttributes() ?>>
        <label for="x_description_05" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_description_05"><?= $Page->description_05->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_description_05" id="z_description_05" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description_05->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_description_05" class="ew-search-field ew-search-field-single">
    <select
        id="x_description_05"
        name="x_description_05"
        class="form-select ew-select<?= $Page->description_05->isInvalidClass() ?>"
        <?php if (!$Page->description_05->IsNativeSelect) { ?>
        data-select2-id="fposearch_x_description_05"
        <?php } ?>
        data-table="po"
        data-field="x_description_05"
        data-page="2"
        data-value-separator="<?= $Page->description_05->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->description_05->getPlaceHolder()) ?>"
        <?= $Page->description_05->editAttributes() ?>>
        <?= $Page->description_05->selectOptionListHtml("x_description_05") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->description_05->getErrorMessage(false) ?></div>
<?= $Page->description_05->Lookup->getParamTag($Page, "p_x_description_05") ?>
<?php if (!$Page->description_05->IsNativeSelect) { ?>
<script>
loadjs.ready("fposearch", function() {
    var options = { name: "x_description_05", selectId: "fposearch_x_description_05" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fposearch.lists.description_05?.lookupOptions.length) {
        options.data = { id: "x_description_05", form: "fposearch" };
    } else {
        options.ajax = { id: "x_description_05", form: "fposearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po.fields.description_05.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->description_06->Visible) { // description_06 ?>
    <div id="r_description_06" class="row"<?= $Page->description_06->rowAttributes() ?>>
        <label for="x_description_06" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_description_06"><?= $Page->description_06->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_description_06" id="z_description_06" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description_06->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_description_06" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->description_06->getInputTextType() ?>" name="x_description_06" id="x_description_06" data-table="po" data-field="x_description_06" value="<?= $Page->description_06->EditValue ?>" data-page="2" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->description_06->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description_06->formatPattern()) ?>"<?= $Page->description_06->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->description_06->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->description_08->Visible) { // description_08 ?>
    <div id="r_description_08" class="row"<?= $Page->description_08->rowAttributes() ?>>
        <label for="x_description_08" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_description_08"><?= $Page->description_08->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_description_08" id="z_description_08" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description_08->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_description_08" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->description_08->getInputTextType() ?>" name="x_description_08" id="x_description_08" data-table="po" data-field="x_description_08" value="<?= $Page->description_08->EditValue ?>" data-page="2" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->description_08->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description_08->formatPattern()) ?>"<?= $Page->description_08->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->description_08->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(3)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(3)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_po3"><?= $Page->pageCaption(3) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(3)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_po3"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->d_09_head->Visible) { // d_09_head ?>
    <div id="r_d_09_head" class="row"<?= $Page->d_09_head->rowAttributes() ?>>
        <label for="x_d_09_head" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_d_09_head"><?= $Page->d_09_head->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_d_09_head" id="z_d_09_head" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_09_head->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_d_09_head" class="ew-search-field ew-search-field-single">
    <select
        id="x_d_09_head"
        name="x_d_09_head"
        class="form-select ew-select<?= $Page->d_09_head->isInvalidClass() ?>"
        <?php if (!$Page->d_09_head->IsNativeSelect) { ?>
        data-select2-id="fposearch_x_d_09_head"
        <?php } ?>
        data-table="po"
        data-field="x_d_09_head"
        data-page="3"
        data-value-separator="<?= $Page->d_09_head->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->d_09_head->getPlaceHolder()) ?>"
        <?= $Page->d_09_head->editAttributes() ?>>
        <?= $Page->d_09_head->selectOptionListHtml("x_d_09_head") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->d_09_head->getErrorMessage(false) ?></div>
<?= $Page->d_09_head->Lookup->getParamTag($Page, "p_x_d_09_head") ?>
<?php if (!$Page->d_09_head->IsNativeSelect) { ?>
<script>
loadjs.ready("fposearch", function() {
    var options = { name: "x_d_09_head", selectId: "fposearch_x_d_09_head" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fposearch.lists.d_09_head?.lookupOptions.length) {
        options.data = { id: "x_d_09_head", form: "fposearch" };
    } else {
        options.ajax = { id: "x_d_09_head", form: "fposearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po.fields.d_09_head.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->description_09->Visible) { // description_09 ?>
    <div id="r_description_09" class="row"<?= $Page->description_09->rowAttributes() ?>>
        <label for="x_description_09" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_description_09"><?= $Page->description_09->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_description_09" id="z_description_09" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description_09->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_description_09" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->description_09->getInputTextType() ?>" name="x_description_09" id="x_description_09" data-table="po" data-field="x_description_09" value="<?= $Page->description_09->EditValue ?>" data-page="3" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->description_09->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description_09->formatPattern()) ?>"<?= $Page->description_09->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->description_09->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_10_head->Visible) { // d_10_head ?>
    <div id="r_d_10_head" class="row"<?= $Page->d_10_head->rowAttributes() ?>>
        <label for="x_d_10_head" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_d_10_head"><?= $Page->d_10_head->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_d_10_head" id="z_d_10_head" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_10_head->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_d_10_head" class="ew-search-field ew-search-field-single">
    <select
        id="x_d_10_head"
        name="x_d_10_head"
        class="form-select ew-select<?= $Page->d_10_head->isInvalidClass() ?>"
        <?php if (!$Page->d_10_head->IsNativeSelect) { ?>
        data-select2-id="fposearch_x_d_10_head"
        <?php } ?>
        data-table="po"
        data-field="x_d_10_head"
        data-page="3"
        data-value-separator="<?= $Page->d_10_head->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->d_10_head->getPlaceHolder()) ?>"
        <?= $Page->d_10_head->editAttributes() ?>>
        <?= $Page->d_10_head->selectOptionListHtml("x_d_10_head") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->d_10_head->getErrorMessage(false) ?></div>
<?= $Page->d_10_head->Lookup->getParamTag($Page, "p_x_d_10_head") ?>
<?php if (!$Page->d_10_head->IsNativeSelect) { ?>
<script>
loadjs.ready("fposearch", function() {
    var options = { name: "x_d_10_head", selectId: "fposearch_x_d_10_head" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fposearch.lists.d_10_head?.lookupOptions.length) {
        options.data = { id: "x_d_10_head", form: "fposearch" };
    } else {
        options.ajax = { id: "x_d_10_head", form: "fposearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po.fields.d_10_head.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->description_10->Visible) { // description_10 ?>
    <div id="r_description_10" class="row"<?= $Page->description_10->rowAttributes() ?>>
        <label for="x_description_10" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_description_10"><?= $Page->description_10->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_description_10" id="z_description_10" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description_10->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_description_10" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->description_10->getInputTextType() ?>" name="x_description_10" id="x_description_10" data-table="po" data-field="x_description_10" value="<?= $Page->description_10->EditValue ?>" data-page="3" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->description_10->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description_10->formatPattern()) ?>"<?= $Page->description_10->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->description_10->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_11_head->Visible) { // d_11_head ?>
    <div id="r_d_11_head" class="row"<?= $Page->d_11_head->rowAttributes() ?>>
        <label for="x_d_11_head" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_d_11_head"><?= $Page->d_11_head->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_d_11_head" id="z_d_11_head" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_11_head->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_d_11_head" class="ew-search-field ew-search-field-single">
    <select
        id="x_d_11_head"
        name="x_d_11_head"
        class="form-select ew-select<?= $Page->d_11_head->isInvalidClass() ?>"
        <?php if (!$Page->d_11_head->IsNativeSelect) { ?>
        data-select2-id="fposearch_x_d_11_head"
        <?php } ?>
        data-table="po"
        data-field="x_d_11_head"
        data-page="3"
        data-value-separator="<?= $Page->d_11_head->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->d_11_head->getPlaceHolder()) ?>"
        <?= $Page->d_11_head->editAttributes() ?>>
        <?= $Page->d_11_head->selectOptionListHtml("x_d_11_head") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->d_11_head->getErrorMessage(false) ?></div>
<?= $Page->d_11_head->Lookup->getParamTag($Page, "p_x_d_11_head") ?>
<?php if (!$Page->d_11_head->IsNativeSelect) { ?>
<script>
loadjs.ready("fposearch", function() {
    var options = { name: "x_d_11_head", selectId: "fposearch_x_d_11_head" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fposearch.lists.d_11_head?.lookupOptions.length) {
        options.data = { id: "x_d_11_head", form: "fposearch" };
    } else {
        options.ajax = { id: "x_d_11_head", form: "fposearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po.fields.d_11_head.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->description_11->Visible) { // description_11 ?>
    <div id="r_description_11" class="row"<?= $Page->description_11->rowAttributes() ?>>
        <label for="x_description_11" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_description_11"><?= $Page->description_11->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_description_11" id="z_description_11" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description_11->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_description_11" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->description_11->getInputTextType() ?>" name="x_description_11" id="x_description_11" data-table="po" data-field="x_description_11" value="<?= $Page->description_11->EditValue ?>" data-page="3" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->description_11->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description_11->formatPattern()) ?>"<?= $Page->description_11->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->description_11->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_12_head->Visible) { // d_12_head ?>
    <div id="r_d_12_head" class="row"<?= $Page->d_12_head->rowAttributes() ?>>
        <label for="x_d_12_head" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_d_12_head"><?= $Page->d_12_head->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_d_12_head" id="z_d_12_head" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_12_head->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_d_12_head" class="ew-search-field ew-search-field-single">
    <select
        id="x_d_12_head"
        name="x_d_12_head"
        class="form-select ew-select<?= $Page->d_12_head->isInvalidClass() ?>"
        <?php if (!$Page->d_12_head->IsNativeSelect) { ?>
        data-select2-id="fposearch_x_d_12_head"
        <?php } ?>
        data-table="po"
        data-field="x_d_12_head"
        data-page="3"
        data-value-separator="<?= $Page->d_12_head->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->d_12_head->getPlaceHolder()) ?>"
        <?= $Page->d_12_head->editAttributes() ?>>
        <?= $Page->d_12_head->selectOptionListHtml("x_d_12_head") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->d_12_head->getErrorMessage(false) ?></div>
<?= $Page->d_12_head->Lookup->getParamTag($Page, "p_x_d_12_head") ?>
<?php if (!$Page->d_12_head->IsNativeSelect) { ?>
<script>
loadjs.ready("fposearch", function() {
    var options = { name: "x_d_12_head", selectId: "fposearch_x_d_12_head" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fposearch.lists.d_12_head?.lookupOptions.length) {
        options.data = { id: "x_d_12_head", form: "fposearch" };
    } else {
        options.ajax = { id: "x_d_12_head", form: "fposearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po.fields.d_12_head.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->description_12->Visible) { // description_12 ?>
    <div id="r_description_12" class="row"<?= $Page->description_12->rowAttributes() ?>>
        <label for="x_description_12" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_description_12"><?= $Page->description_12->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_description_12" id="z_description_12" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description_12->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_description_12" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->description_12->getInputTextType() ?>" name="x_description_12" id="x_description_12" data-table="po" data-field="x_description_12" value="<?= $Page->description_12->EditValue ?>" data-page="3" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->description_12->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description_12->formatPattern()) ?>"<?= $Page->description_12->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->description_12->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(4)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(4)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_po4"><?= $Page->pageCaption(4) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(4)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_po4"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fposearch_x_operator"
        <?php } ?>
        data-table="po"
        data-field="x_operator"
        data-page="4"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fposearch", function() {
    var options = { name: "x_operator", selectId: "fposearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fposearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fposearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fposearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="po" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" data-page="4" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->a_operator->Visible) { // a_operator ?>
    <div id="r_a_operator" class="row"<?= $Page->a_operator->rowAttributes() ?>>
        <label for="x_a_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_a_operator"><?= $Page->a_operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_a_operator" id="z_a_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->a_operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_a_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_a_operator"
        name="x_a_operator"
        class="form-select ew-select<?= $Page->a_operator->isInvalidClass() ?>"
        <?php if (!$Page->a_operator->IsNativeSelect) { ?>
        data-select2-id="fposearch_x_a_operator"
        <?php } ?>
        data-table="po"
        data-field="x_a_operator"
        data-page="4"
        data-value-separator="<?= $Page->a_operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->a_operator->getPlaceHolder()) ?>"
        <?= $Page->a_operator->editAttributes() ?>>
        <?= $Page->a_operator->selectOptionListHtml("x_a_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->a_operator->getErrorMessage(false) ?></div>
<?= $Page->a_operator->Lookup->getParamTag($Page, "p_x_a_operator") ?>
<?php if (!$Page->a_operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fposearch", function() {
    var options = { name: "x_a_operator", selectId: "fposearch_x_a_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fposearch.lists.a_operator?.lookupOptions.length) {
        options.data = { id: "x_a_operator", form: "fposearch" };
    } else {
        options.ajax = { id: "x_a_operator", form: "fposearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po.fields.a_operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->a_datetime->Visible) { // a_datetime ?>
    <div id="r_a_datetime" class="row"<?= $Page->a_datetime->rowAttributes() ?>>
        <label for="x_a_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_a_datetime"><?= $Page->a_datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_a_datetime" id="z_a_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->a_datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_a_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->a_datetime->getInputTextType() ?>" name="x_a_datetime" id="x_a_datetime" data-table="po" data-field="x_a_datetime" value="<?= $Page->a_datetime->EditValue ?>" data-page="4" placeholder="<?= HtmlEncode($Page->a_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->a_datetime->formatPattern()) ?>"<?= $Page->a_datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->a_datetime->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
</div><!-- /multi-page accordion -->
</div><!-- /multi-page -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fposearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fposearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fposearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("po");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
