<?php

namespace PHPMaker2024\fibre;

// Page object
$PoSSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { po_s: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fpo_ssearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpo_ssearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["po", [], fields.po.isInvalid],
            ["company_id", [], fields.company_id.isInvalid],
            ["partner_id", [ew.Validators.integer], fields.partner_id.isInvalid],
            ["copy", [], fields.copy.isInvalid],
            ["cart_id", [], fields.cart_id.isInvalid],
            ["quantity", [], fields.quantity.isInvalid],
            ["sqm", [ew.Validators.float], fields.sqm.isInvalid],
            ["amount", [], fields.amount.isInvalid],
            ["cbm", [ew.Validators.float], fields.cbm.isInvalid],
            ["gst", [], fields.gst.isInvalid],
            ["despatch_week", [], fields.despatch_week.isInvalid],
            ["payment_terms", [], fields.payment_terms.isInvalid],
            ["transport_type", [], fields.transport_type.isInvalid],
            ["partner_shipping_id", [], fields.partner_shipping_id.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [], fields.datetime.isInvalid],
            ["a_operator", [], fields.a_operator.isInvalid],
            ["a_datetime", [], fields.a_datetime.isInvalid],
            ["buyer_instruction", [], fields.buyer_instruction.isInvalid],
            ["d_09_head", [], fields.d_09_head.isInvalid],
            ["description_09", [], fields.description_09.isInvalid],
            ["d_10_head", [], fields.d_10_head.isInvalid],
            ["description_10", [], fields.description_10.isInvalid],
            ["d_11_head", [], fields.d_11_head.isInvalid],
            ["description_11", [], fields.description_11.isInvalid],
            ["d_12_head", [], fields.d_12_head.isInvalid],
            ["description_12", [], fields.description_12.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
            "partner_id": <?= $Page->partner_id->toClientList($Page) ?>,
            "copy": <?= $Page->copy->toClientList($Page) ?>,
            "cart_id": <?= $Page->cart_id->toClientList($Page) ?>,
            "gst": <?= $Page->gst->toClientList($Page) ?>,
            "despatch_week": <?= $Page->despatch_week->toClientList($Page) ?>,
            "payment_terms": <?= $Page->payment_terms->toClientList($Page) ?>,
            "transport_type": <?= $Page->transport_type->toClientList($Page) ?>,
            "partner_shipping_id": <?= $Page->partner_shipping_id->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
            "a_operator": <?= $Page->a_operator->toClientList($Page) ?>,
            "d_09_head": <?= $Page->d_09_head->toClientList($Page) ?>,
            "d_10_head": <?= $Page->d_10_head->toClientList($Page) ?>,
            "d_11_head": <?= $Page->d_11_head->toClientList($Page) ?>,
            "d_12_head": <?= $Page->d_12_head->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fpo_ssearch" id="fpo_ssearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="po_s">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<?php if ($Page->MultiPages->Items[0]->Visible) { ?>
<div class="ew-search-div"><!-- page0 -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="po_s" data-field="x_id" value="<?= $Page->id->EditValue ?>" data-page="0" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
    <div id="r_po" class="row"<?= $Page->po->rowAttributes() ?>>
        <label for="x_po" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_po"><?= $Page->po->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_po" id="z_po" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_po" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->po->getInputTextType() ?>" name="x_po" id="x_po" data-table="po_s" data-field="x_po" value="<?= $Page->po->EditValue ?>" data-page="0" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
    <div id="r_company_id" class="row"<?= $Page->company_id->rowAttributes() ?>>
        <label for="x_company_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_company_id"><?= $Page->company_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_company_id" id="z_company_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->company_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_company_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_company_id"
        name="x_company_id"
        class="form-select ew-select<?= $Page->company_id->isInvalidClass() ?>"
        <?php if (!$Page->company_id->IsNativeSelect) { ?>
        data-select2-id="fpo_ssearch_x_company_id"
        <?php } ?>
        data-table="po_s"
        data-field="x_company_id"
        data-page="0"
        data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->company_id->editAttributes() ?>>
        <?= $Page->company_id->selectOptionListHtml("x_company_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->company_id->getErrorMessage(false) ?></div>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
<?php if (!$Page->company_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_ssearch", function() {
    var options = { name: "x_company_id", selectId: "fpo_ssearch_x_company_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_ssearch.lists.company_id?.lookupOptions.length) {
        options.data = { id: "x_company_id", form: "fpo_ssearch" };
    } else {
        options.ajax = { id: "x_company_id", form: "fpo_ssearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_s.fields.company_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->partner_id->Visible) { // partner_id ?>
    <div id="r_partner_id" class="row"<?= $Page->partner_id->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_partner_id"><?= $Page->partner_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_partner_id" id="z_partner_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->partner_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_partner_id" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->partner_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_partner_id" class="ew-auto-suggest">
    <input type="<?= $Page->partner_id->getInputTextType() ?>" class="form-control" name="sv_x_partner_id" id="sv_x_partner_id" value="<?= RemoveHtml($Page->partner_id->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->partner_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->partner_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->partner_id->formatPattern()) ?>"<?= $Page->partner_id->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="po_s" data-field="x_partner_id" data-input="sv_x_partner_id" data-page="0" data-value-separator="<?= $Page->partner_id->displayValueSeparatorAttribute() ?>" name="x_partner_id" id="x_partner_id" value="<?= HtmlEncode($Page->partner_id->AdvancedSearch->SearchValue) ?>" data-ew-action="update-options"></selection-list>
<div class="invalid-feedback"><?= $Page->partner_id->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fpo_ssearch", function() {
    fpo_ssearch.createAutoSuggest(Object.assign({"id":"x_partner_id","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->partner_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.po_s.fields.partner_id.autoSuggestOptions));
});
</script>
<?= $Page->partner_id->Lookup->getParamTag($Page, "p_x_partner_id") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->copy->Visible) { // copy ?>
    <div id="r_copy" class="row"<?= $Page->copy->rowAttributes() ?>>
        <label for="x_copy" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_copy"><?= $Page->copy->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_copy" id="z_copy" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->copy->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_copy" class="ew-search-field ew-search-field-single">
    <select
        id="x_copy"
        name="x_copy"
        class="form-select ew-select<?= $Page->copy->isInvalidClass() ?>"
        <?php if (!$Page->copy->IsNativeSelect) { ?>
        data-select2-id="fpo_ssearch_x_copy"
        <?php } ?>
        data-table="po_s"
        data-field="x_copy"
        data-page="0"
        data-value-separator="<?= $Page->copy->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->copy->getPlaceHolder()) ?>"
        <?= $Page->copy->editAttributes() ?>>
        <?= $Page->copy->selectOptionListHtml("x_copy") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->copy->getErrorMessage(false) ?></div>
<?= $Page->copy->Lookup->getParamTag($Page, "p_x_copy") ?>
<?php if (!$Page->copy->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_ssearch", function() {
    var options = { name: "x_copy", selectId: "fpo_ssearch_x_copy" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_ssearch.lists.copy?.lookupOptions.length) {
        options.data = { id: "x_copy", form: "fpo_ssearch" };
    } else {
        options.ajax = { id: "x_copy", form: "fpo_ssearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_s.fields.copy.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->cart_id->Visible) { // cart_id ?>
    <div id="r_cart_id" class="row"<?= $Page->cart_id->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_cart_id"><?= $Page->cart_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_cart_id" id="z_cart_id" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->cart_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_cart_id" class="ew-search-field ew-search-field-single">
<template id="tp_x_cart_id">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="po_s" data-field="x_cart_id" name="x_cart_id" id="x_cart_id"<?= $Page->cart_id->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_cart_id" class="ew-item-list"></div>
<selection-list hidden
    id="x_cart_id[]"
    name="x_cart_id[]"
    value="<?= HtmlEncode($Page->cart_id->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_cart_id"
    data-target="dsl_x_cart_id"
    data-repeatcolumn="1"
    class="form-control<?= $Page->cart_id->isInvalidClass() ?>"
    data-table="po_s"
    data-field="x_cart_id"
    data-page="0"
    data-value-separator="<?= $Page->cart_id->displayValueSeparatorAttribute() ?>"
    <?= $Page->cart_id->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->cart_id->getErrorMessage(false) ?></div>
<?= $Page->cart_id->Lookup->getParamTag($Page, "p_x_cart_id") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="accordion ew-accordion" id="accordion_PoSSearch"><!-- multi-page accordion -->
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(1)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(1)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_po_s1"><?= $Page->pageCaption(1) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(1)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_po_s1"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity" class="row"<?= $Page->quantity->rowAttributes() ?>>
        <label for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_quantity"><?= $Page->quantity->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_quantity" id="z_quantity" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->quantity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->quantity->getInputTextType() ?>" name="x_quantity" id="x_quantity" data-table="po_s" data-field="x_quantity" value="<?= $Page->quantity->EditValue ?>" data-page="1" size="30" placeholder="<?= HtmlEncode($Page->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity->formatPattern()) ?>"<?= $Page->quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->quantity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
    <div id="r_sqm" class="row"<?= $Page->sqm->rowAttributes() ?>>
        <label for="x_sqm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_sqm"><?= $Page->sqm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_sqm" id="z_sqm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sqm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_sqm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sqm->getInputTextType() ?>" name="x_sqm" id="x_sqm" data-table="po_s" data-field="x_sqm" value="<?= $Page->sqm->EditValue ?>" data-page="1" size="30" placeholder="<?= HtmlEncode($Page->sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm->formatPattern()) ?>"<?= $Page->sqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sqm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
    <div id="r_amount" class="row"<?= $Page->amount->rowAttributes() ?>>
        <label for="x_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_amount"><?= $Page->amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_amount" id="z_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->amount->getInputTextType() ?>" name="x_amount" id="x_amount" data-table="po_s" data-field="x_amount" value="<?= $Page->amount->EditValue ?>" data-page="1" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->cbm->Visible) { // cbm ?>
    <div id="r_cbm" class="row"<?= $Page->cbm->rowAttributes() ?>>
        <label for="x_cbm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_cbm"><?= $Page->cbm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_cbm" id="z_cbm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->cbm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_cbm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->cbm->getInputTextType() ?>" name="x_cbm" id="x_cbm" data-table="po_s" data-field="x_cbm" value="<?= $Page->cbm->EditValue ?>" data-page="1" size="30" placeholder="<?= HtmlEncode($Page->cbm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cbm->formatPattern()) ?>"<?= $Page->cbm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->cbm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->gst->Visible) { // gst ?>
    <div id="r_gst" class="row"<?= $Page->gst->rowAttributes() ?>>
        <label for="x_gst" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_gst"><?= $Page->gst->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_gst" id="z_gst" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->gst->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_gst" class="ew-search-field ew-search-field-single">
    <select
        id="x_gst"
        name="x_gst"
        class="form-select ew-select<?= $Page->gst->isInvalidClass() ?>"
        <?php if (!$Page->gst->IsNativeSelect) { ?>
        data-select2-id="fpo_ssearch_x_gst"
        <?php } ?>
        data-table="po_s"
        data-field="x_gst"
        data-page="1"
        data-value-separator="<?= $Page->gst->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->gst->getPlaceHolder()) ?>"
        <?= $Page->gst->editAttributes() ?>>
        <?= $Page->gst->selectOptionListHtml("x_gst") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->gst->getErrorMessage(false) ?></div>
<?= $Page->gst->Lookup->getParamTag($Page, "p_x_gst") ?>
<?php if (!$Page->gst->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_ssearch", function() {
    var options = { name: "x_gst", selectId: "fpo_ssearch_x_gst" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_ssearch.lists.gst?.lookupOptions.length) {
        options.data = { id: "x_gst", form: "fpo_ssearch" };
    } else {
        options.ajax = { id: "x_gst", form: "fpo_ssearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_s.fields.gst.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(2)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(2)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_po_s2"><?= $Page->pageCaption(2) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(2)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_po_s2"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->despatch_week->Visible) { // despatch_week ?>
    <div id="r_despatch_week" class="row"<?= $Page->despatch_week->rowAttributes() ?>>
        <label for="x_despatch_week" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_despatch_week"><?= $Page->despatch_week->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_despatch_week" id="z_despatch_week" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->despatch_week->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_despatch_week" class="ew-search-field ew-search-field-single">
    <select
        id="x_despatch_week"
        name="x_despatch_week"
        class="form-select ew-select<?= $Page->despatch_week->isInvalidClass() ?>"
        <?php if (!$Page->despatch_week->IsNativeSelect) { ?>
        data-select2-id="fpo_ssearch_x_despatch_week"
        <?php } ?>
        data-table="po_s"
        data-field="x_despatch_week"
        data-page="2"
        data-value-separator="<?= $Page->despatch_week->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->despatch_week->getPlaceHolder()) ?>"
        <?= $Page->despatch_week->editAttributes() ?>>
        <?= $Page->despatch_week->selectOptionListHtml("x_despatch_week") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->despatch_week->getErrorMessage(false) ?></div>
<?= $Page->despatch_week->Lookup->getParamTag($Page, "p_x_despatch_week") ?>
<?php if (!$Page->despatch_week->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_ssearch", function() {
    var options = { name: "x_despatch_week", selectId: "fpo_ssearch_x_despatch_week" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_ssearch.lists.despatch_week?.lookupOptions.length) {
        options.data = { id: "x_despatch_week", form: "fpo_ssearch" };
    } else {
        options.ajax = { id: "x_despatch_week", form: "fpo_ssearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_s.fields.despatch_week.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->payment_terms->Visible) { // payment_terms ?>
    <div id="r_payment_terms" class="row"<?= $Page->payment_terms->rowAttributes() ?>>
        <label for="x_payment_terms" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_payment_terms"><?= $Page->payment_terms->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_payment_terms" id="z_payment_terms" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->payment_terms->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_payment_terms" class="ew-search-field ew-search-field-single">
    <select
        id="x_payment_terms"
        name="x_payment_terms"
        class="form-select ew-select<?= $Page->payment_terms->isInvalidClass() ?>"
        <?php if (!$Page->payment_terms->IsNativeSelect) { ?>
        data-select2-id="fpo_ssearch_x_payment_terms"
        <?php } ?>
        data-table="po_s"
        data-field="x_payment_terms"
        data-page="2"
        data-value-separator="<?= $Page->payment_terms->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->payment_terms->getPlaceHolder()) ?>"
        <?= $Page->payment_terms->editAttributes() ?>>
        <?= $Page->payment_terms->selectOptionListHtml("x_payment_terms") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->payment_terms->getErrorMessage(false) ?></div>
<?= $Page->payment_terms->Lookup->getParamTag($Page, "p_x_payment_terms") ?>
<?php if (!$Page->payment_terms->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_ssearch", function() {
    var options = { name: "x_payment_terms", selectId: "fpo_ssearch_x_payment_terms" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_ssearch.lists.payment_terms?.lookupOptions.length) {
        options.data = { id: "x_payment_terms", form: "fpo_ssearch" };
    } else {
        options.ajax = { id: "x_payment_terms", form: "fpo_ssearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_s.fields.payment_terms.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->transport_type->Visible) { // transport_type ?>
    <div id="r_transport_type" class="row"<?= $Page->transport_type->rowAttributes() ?>>
        <label for="x_transport_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_transport_type"><?= $Page->transport_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_transport_type" id="z_transport_type" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->transport_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_transport_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_transport_type"
        name="x_transport_type"
        class="form-select ew-select<?= $Page->transport_type->isInvalidClass() ?>"
        <?php if (!$Page->transport_type->IsNativeSelect) { ?>
        data-select2-id="fpo_ssearch_x_transport_type"
        <?php } ?>
        data-table="po_s"
        data-field="x_transport_type"
        data-page="2"
        data-value-separator="<?= $Page->transport_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->transport_type->getPlaceHolder()) ?>"
        <?= $Page->transport_type->editAttributes() ?>>
        <?= $Page->transport_type->selectOptionListHtml("x_transport_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->transport_type->getErrorMessage(false) ?></div>
<?= $Page->transport_type->Lookup->getParamTag($Page, "p_x_transport_type") ?>
<?php if (!$Page->transport_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_ssearch", function() {
    var options = { name: "x_transport_type", selectId: "fpo_ssearch_x_transport_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_ssearch.lists.transport_type?.lookupOptions.length) {
        options.data = { id: "x_transport_type", form: "fpo_ssearch" };
    } else {
        options.ajax = { id: "x_transport_type", form: "fpo_ssearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_s.fields.transport_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->partner_shipping_id->Visible) { // partner_shipping_id ?>
    <div id="r_partner_shipping_id" class="row"<?= $Page->partner_shipping_id->rowAttributes() ?>>
        <label for="x_partner_shipping_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_partner_shipping_id"><?= $Page->partner_shipping_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_partner_shipping_id" id="z_partner_shipping_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->partner_shipping_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_partner_shipping_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_partner_shipping_id"
        name="x_partner_shipping_id"
        class="form-select ew-select<?= $Page->partner_shipping_id->isInvalidClass() ?>"
        <?php if (!$Page->partner_shipping_id->IsNativeSelect) { ?>
        data-select2-id="fpo_ssearch_x_partner_shipping_id"
        <?php } ?>
        data-table="po_s"
        data-field="x_partner_shipping_id"
        data-page="2"
        data-value-separator="<?= $Page->partner_shipping_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->partner_shipping_id->getPlaceHolder()) ?>"
        <?= $Page->partner_shipping_id->editAttributes() ?>>
        <?= $Page->partner_shipping_id->selectOptionListHtml("x_partner_shipping_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->partner_shipping_id->getErrorMessage(false) ?></div>
<?= $Page->partner_shipping_id->Lookup->getParamTag($Page, "p_x_partner_shipping_id") ?>
<?php if (!$Page->partner_shipping_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_ssearch", function() {
    var options = { name: "x_partner_shipping_id", selectId: "fpo_ssearch_x_partner_shipping_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_ssearch.lists.partner_shipping_id?.lookupOptions.length) {
        options.data = { id: "x_partner_shipping_id", form: "fpo_ssearch" };
    } else {
        options.ajax = { id: "x_partner_shipping_id", form: "fpo_ssearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_s.fields.partner_shipping_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="po_s" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" data-page="2" size="30" maxlength="500" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_instruction->Visible) { // buyer_instruction ?>
    <div id="r_buyer_instruction" class="row"<?= $Page->buyer_instruction->rowAttributes() ?>>
        <label for="x_buyer_instruction" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_buyer_instruction"><?= $Page->buyer_instruction->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_buyer_instruction" id="z_buyer_instruction" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_instruction->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_buyer_instruction" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_instruction->getInputTextType() ?>" name="x_buyer_instruction" id="x_buyer_instruction" data-table="po_s" data-field="x_buyer_instruction" value="<?= $Page->buyer_instruction->EditValue ?>" data-page="2" size="30" maxlength="500" placeholder="<?= HtmlEncode($Page->buyer_instruction->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_instruction->formatPattern()) ?>"<?= $Page->buyer_instruction->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_instruction->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(3)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(3)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_po_s3"><?= $Page->pageCaption(3) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(3)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_po_s3"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->d_09_head->Visible) { // d_09_head ?>
    <div id="r_d_09_head" class="row"<?= $Page->d_09_head->rowAttributes() ?>>
        <label for="x_d_09_head" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_d_09_head"><?= $Page->d_09_head->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_d_09_head" id="z_d_09_head" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_09_head->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_d_09_head" class="ew-search-field ew-search-field-single">
    <select
        id="x_d_09_head"
        name="x_d_09_head"
        class="form-select ew-select<?= $Page->d_09_head->isInvalidClass() ?>"
        <?php if (!$Page->d_09_head->IsNativeSelect) { ?>
        data-select2-id="fpo_ssearch_x_d_09_head"
        <?php } ?>
        data-table="po_s"
        data-field="x_d_09_head"
        data-page="3"
        data-value-separator="<?= $Page->d_09_head->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->d_09_head->getPlaceHolder()) ?>"
        <?= $Page->d_09_head->editAttributes() ?>>
        <?= $Page->d_09_head->selectOptionListHtml("x_d_09_head") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->d_09_head->getErrorMessage(false) ?></div>
<?= $Page->d_09_head->Lookup->getParamTag($Page, "p_x_d_09_head") ?>
<?php if (!$Page->d_09_head->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_ssearch", function() {
    var options = { name: "x_d_09_head", selectId: "fpo_ssearch_x_d_09_head" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_ssearch.lists.d_09_head?.lookupOptions.length) {
        options.data = { id: "x_d_09_head", form: "fpo_ssearch" };
    } else {
        options.ajax = { id: "x_d_09_head", form: "fpo_ssearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_s.fields.d_09_head.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->description_09->Visible) { // description_09 ?>
    <div id="r_description_09" class="row"<?= $Page->description_09->rowAttributes() ?>>
        <label for="x_description_09" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_description_09"><?= $Page->description_09->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_description_09" id="z_description_09" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description_09->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_description_09" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->description_09->getInputTextType() ?>" name="x_description_09" id="x_description_09" data-table="po_s" data-field="x_description_09" value="<?= $Page->description_09->EditValue ?>" data-page="3" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->description_09->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description_09->formatPattern()) ?>"<?= $Page->description_09->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->description_09->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_10_head->Visible) { // d_10_head ?>
    <div id="r_d_10_head" class="row"<?= $Page->d_10_head->rowAttributes() ?>>
        <label for="x_d_10_head" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_d_10_head"><?= $Page->d_10_head->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_d_10_head" id="z_d_10_head" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_10_head->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_d_10_head" class="ew-search-field ew-search-field-single">
    <select
        id="x_d_10_head"
        name="x_d_10_head"
        class="form-select ew-select<?= $Page->d_10_head->isInvalidClass() ?>"
        <?php if (!$Page->d_10_head->IsNativeSelect) { ?>
        data-select2-id="fpo_ssearch_x_d_10_head"
        <?php } ?>
        data-table="po_s"
        data-field="x_d_10_head"
        data-page="3"
        data-value-separator="<?= $Page->d_10_head->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->d_10_head->getPlaceHolder()) ?>"
        <?= $Page->d_10_head->editAttributes() ?>>
        <?= $Page->d_10_head->selectOptionListHtml("x_d_10_head") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->d_10_head->getErrorMessage(false) ?></div>
<?= $Page->d_10_head->Lookup->getParamTag($Page, "p_x_d_10_head") ?>
<?php if (!$Page->d_10_head->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_ssearch", function() {
    var options = { name: "x_d_10_head", selectId: "fpo_ssearch_x_d_10_head" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_ssearch.lists.d_10_head?.lookupOptions.length) {
        options.data = { id: "x_d_10_head", form: "fpo_ssearch" };
    } else {
        options.ajax = { id: "x_d_10_head", form: "fpo_ssearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_s.fields.d_10_head.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->description_10->Visible) { // description_10 ?>
    <div id="r_description_10" class="row"<?= $Page->description_10->rowAttributes() ?>>
        <label for="x_description_10" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_description_10"><?= $Page->description_10->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_description_10" id="z_description_10" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description_10->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_description_10" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->description_10->getInputTextType() ?>" name="x_description_10" id="x_description_10" data-table="po_s" data-field="x_description_10" value="<?= $Page->description_10->EditValue ?>" data-page="3" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->description_10->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description_10->formatPattern()) ?>"<?= $Page->description_10->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->description_10->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_11_head->Visible) { // d_11_head ?>
    <div id="r_d_11_head" class="row"<?= $Page->d_11_head->rowAttributes() ?>>
        <label for="x_d_11_head" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_d_11_head"><?= $Page->d_11_head->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_d_11_head" id="z_d_11_head" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_11_head->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_d_11_head" class="ew-search-field ew-search-field-single">
    <select
        id="x_d_11_head"
        name="x_d_11_head"
        class="form-select ew-select<?= $Page->d_11_head->isInvalidClass() ?>"
        <?php if (!$Page->d_11_head->IsNativeSelect) { ?>
        data-select2-id="fpo_ssearch_x_d_11_head"
        <?php } ?>
        data-table="po_s"
        data-field="x_d_11_head"
        data-page="3"
        data-value-separator="<?= $Page->d_11_head->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->d_11_head->getPlaceHolder()) ?>"
        <?= $Page->d_11_head->editAttributes() ?>>
        <?= $Page->d_11_head->selectOptionListHtml("x_d_11_head") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->d_11_head->getErrorMessage(false) ?></div>
<?= $Page->d_11_head->Lookup->getParamTag($Page, "p_x_d_11_head") ?>
<?php if (!$Page->d_11_head->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_ssearch", function() {
    var options = { name: "x_d_11_head", selectId: "fpo_ssearch_x_d_11_head" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_ssearch.lists.d_11_head?.lookupOptions.length) {
        options.data = { id: "x_d_11_head", form: "fpo_ssearch" };
    } else {
        options.ajax = { id: "x_d_11_head", form: "fpo_ssearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_s.fields.d_11_head.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->description_11->Visible) { // description_11 ?>
    <div id="r_description_11" class="row"<?= $Page->description_11->rowAttributes() ?>>
        <label for="x_description_11" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_description_11"><?= $Page->description_11->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_description_11" id="z_description_11" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description_11->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_description_11" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->description_11->getInputTextType() ?>" name="x_description_11" id="x_description_11" data-table="po_s" data-field="x_description_11" value="<?= $Page->description_11->EditValue ?>" data-page="3" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->description_11->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description_11->formatPattern()) ?>"<?= $Page->description_11->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->description_11->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_12_head->Visible) { // d_12_head ?>
    <div id="r_d_12_head" class="row"<?= $Page->d_12_head->rowAttributes() ?>>
        <label for="x_d_12_head" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_d_12_head"><?= $Page->d_12_head->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_d_12_head" id="z_d_12_head" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_12_head->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_d_12_head" class="ew-search-field ew-search-field-single">
    <select
        id="x_d_12_head"
        name="x_d_12_head"
        class="form-select ew-select<?= $Page->d_12_head->isInvalidClass() ?>"
        <?php if (!$Page->d_12_head->IsNativeSelect) { ?>
        data-select2-id="fpo_ssearch_x_d_12_head"
        <?php } ?>
        data-table="po_s"
        data-field="x_d_12_head"
        data-page="3"
        data-value-separator="<?= $Page->d_12_head->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->d_12_head->getPlaceHolder()) ?>"
        <?= $Page->d_12_head->editAttributes() ?>>
        <?= $Page->d_12_head->selectOptionListHtml("x_d_12_head") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->d_12_head->getErrorMessage(false) ?></div>
<?= $Page->d_12_head->Lookup->getParamTag($Page, "p_x_d_12_head") ?>
<?php if (!$Page->d_12_head->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_ssearch", function() {
    var options = { name: "x_d_12_head", selectId: "fpo_ssearch_x_d_12_head" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_ssearch.lists.d_12_head?.lookupOptions.length) {
        options.data = { id: "x_d_12_head", form: "fpo_ssearch" };
    } else {
        options.ajax = { id: "x_d_12_head", form: "fpo_ssearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_s.fields.d_12_head.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->description_12->Visible) { // description_12 ?>
    <div id="r_description_12" class="row"<?= $Page->description_12->rowAttributes() ?>>
        <label for="x_description_12" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_description_12"><?= $Page->description_12->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_description_12" id="z_description_12" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description_12->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_description_12" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->description_12->getInputTextType() ?>" name="x_description_12" id="x_description_12" data-table="po_s" data-field="x_description_12" value="<?= $Page->description_12->EditValue ?>" data-page="3" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->description_12->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description_12->formatPattern()) ?>"<?= $Page->description_12->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->description_12->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(4)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(4)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_po_s4"><?= $Page->pageCaption(4) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(4)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_po_s4"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fpo_ssearch_x_operator"
        <?php } ?>
        data-table="po_s"
        data-field="x_operator"
        data-page="4"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_ssearch", function() {
    var options = { name: "x_operator", selectId: "fpo_ssearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_ssearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fpo_ssearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fpo_ssearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_s.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="po_s" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" data-page="4" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->a_operator->Visible) { // a_operator ?>
    <div id="r_a_operator" class="row"<?= $Page->a_operator->rowAttributes() ?>>
        <label for="x_a_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_a_operator"><?= $Page->a_operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_a_operator" id="z_a_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->a_operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_a_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_a_operator"
        name="x_a_operator"
        class="form-select ew-select<?= $Page->a_operator->isInvalidClass() ?>"
        <?php if (!$Page->a_operator->IsNativeSelect) { ?>
        data-select2-id="fpo_ssearch_x_a_operator"
        <?php } ?>
        data-table="po_s"
        data-field="x_a_operator"
        data-page="4"
        data-value-separator="<?= $Page->a_operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->a_operator->getPlaceHolder()) ?>"
        <?= $Page->a_operator->editAttributes() ?>>
        <?= $Page->a_operator->selectOptionListHtml("x_a_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->a_operator->getErrorMessage(false) ?></div>
<?= $Page->a_operator->Lookup->getParamTag($Page, "p_x_a_operator") ?>
<?php if (!$Page->a_operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_ssearch", function() {
    var options = { name: "x_a_operator", selectId: "fpo_ssearch_x_a_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_ssearch.lists.a_operator?.lookupOptions.length) {
        options.data = { id: "x_a_operator", form: "fpo_ssearch" };
    } else {
        options.ajax = { id: "x_a_operator", form: "fpo_ssearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_s.fields.a_operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->a_datetime->Visible) { // a_datetime ?>
    <div id="r_a_datetime" class="row"<?= $Page->a_datetime->rowAttributes() ?>>
        <label for="x_a_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_a_datetime"><?= $Page->a_datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_a_datetime" id="z_a_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->a_datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_a_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->a_datetime->getInputTextType() ?>" name="x_a_datetime" id="x_a_datetime" data-table="po_s" data-field="x_a_datetime" value="<?= $Page->a_datetime->EditValue ?>" data-page="4" placeholder="<?= HtmlEncode($Page->a_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->a_datetime->formatPattern()) ?>"<?= $Page->a_datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->a_datetime->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
</div><!-- /multi-page accordion -->
</div><!-- /multi-page -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fpo_ssearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpo_ssearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fpo_ssearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("po_s");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
