<?php

namespace PHPMaker2024\fibre;

// Page object
$PoSPendingSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { po_s_pending: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fpo_s_pendingsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpo_s_pendingsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["cart_id", [ew.Validators.integer], fields.cart_id.isInvalid],
            ["po_id", [], fields.po_id.isInvalid],
            ["y_po_id", [ew.Validators.between], false],
            ["company_id", [], fields.company_id.isInvalid],
            ["partner_id", [], fields.partner_id.isInvalid],
            ["partner_order_no", [], fields.partner_order_no.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["p_remarks", [], fields.p_remarks.isInvalid],
            ["grp", [], fields.grp.isInvalid],
            ["s_grp", [], fields.s_grp.isInvalid],
            ["product", [], fields.product.isInvalid],
            ["ref", [], fields.ref.isInvalid],
            ["product_code", [], fields.product_code.isInvalid],
            ["order_quantity", [ew.Validators.float], fields.order_quantity.isInvalid],
            ["pending_qty", [ew.Validators.float], fields.pending_qty.isInvalid],
            ["y_pending_qty", [ew.Validators.between], false],
            ["order_date", [ew.Validators.datetime(fields.order_date.clientFormatPattern)], fields.order_date.isInvalid],
            ["despatch_date", [ew.Validators.datetime(fields.despatch_date.clientFormatPattern)], fields.despatch_date.isInvalid],
            ["avg_quantity", [ew.Validators.integer], fields.avg_quantity.isInvalid],
            ["packing_type", [], fields.packing_type.isInvalid],
            ["status", [ew.Validators.integer], fields.status.isInvalid],
            ["p_qty", [ew.Validators.float], fields.p_qty.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "po_id": <?= $Page->po_id->toClientList($Page) ?>,
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
            "partner_id": <?= $Page->partner_id->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "ref": <?= $Page->ref->toClientList($Page) ?>,
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fpo_s_pendingsearch" id="fpo_s_pendingsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="po_s_pending">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->cart_id->Visible) { // cart_id ?>
    <div id="r_cart_id" class="row"<?= $Page->cart_id->rowAttributes() ?>>
        <label for="x_cart_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_pending_cart_id"><?= $Page->cart_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_cart_id" id="z_cart_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->cart_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_pending_cart_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->cart_id->getInputTextType() ?>" name="x_cart_id" id="x_cart_id" data-table="po_s_pending" data-field="x_cart_id" value="<?= $Page->cart_id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->cart_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cart_id->formatPattern()) ?>"<?= $Page->cart_id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->cart_id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->po_id->Visible) { // po_id ?>
    <div id="r_po_id" class="row"<?= $Page->po_id->rowAttributes() ?>>
        <label for="x_po_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_pending_po_id"><?= $Page->po_id->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_po_id" id="z_po_id" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->po_id->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->po_id->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_po_s_pending_po_id" class="ew-search-field">
    <select
        id="x_po_id"
        name="x_po_id"
        class="form-select ew-select<?= $Page->po_id->isInvalidClass() ?>"
        <?php if (!$Page->po_id->IsNativeSelect) { ?>
        data-select2-id="fpo_s_pendingsearch_x_po_id"
        <?php } ?>
        data-table="po_s_pending"
        data-field="x_po_id"
        data-value-separator="<?= $Page->po_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->po_id->getPlaceHolder()) ?>"
        <?= $Page->po_id->editAttributes() ?>>
        <?= $Page->po_id->selectOptionListHtml("x_po_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->po_id->getErrorMessage(false) ?></div>
<?= $Page->po_id->Lookup->getParamTag($Page, "p_x_po_id") ?>
<?php if (!$Page->po_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_s_pendingsearch", function() {
    var options = { name: "x_po_id", selectId: "fpo_s_pendingsearch_x_po_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_s_pendingsearch.lists.po_id?.lookupOptions.length) {
        options.data = { id: "x_po_id", form: "fpo_s_pendingsearch" };
    } else {
        options.ajax = { id: "x_po_id", form: "fpo_s_pendingsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_s_pending.fields.po_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_po_s_pending_po_id" class="ew-search-field2 d-none">
    <select
        id="y_po_id"
        name="y_po_id"
        class="form-select ew-select<?= $Page->po_id->isInvalidClass() ?>"
        <?php if (!$Page->po_id->IsNativeSelect) { ?>
        data-select2-id="fpo_s_pendingsearch_y_po_id"
        <?php } ?>
        data-table="po_s_pending"
        data-field="x_po_id"
        data-value-separator="<?= $Page->po_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->po_id->getPlaceHolder()) ?>"
        <?= $Page->po_id->editAttributes() ?>>
        <?= $Page->po_id->selectOptionListHtml("y_po_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->po_id->getErrorMessage(false) ?></div>
<?= $Page->po_id->Lookup->getParamTag($Page, "p_y_po_id") ?>
<?php if (!$Page->po_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_s_pendingsearch", function() {
    var options = { name: "y_po_id", selectId: "fpo_s_pendingsearch_y_po_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_s_pendingsearch.lists.po_id?.lookupOptions.length) {
        options.data = { id: "y_po_id", form: "fpo_s_pendingsearch" };
    } else {
        options.ajax = { id: "y_po_id", form: "fpo_s_pendingsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_s_pending.fields.po_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
    <div id="r_company_id" class="row"<?= $Page->company_id->rowAttributes() ?>>
        <label for="x_company_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_pending_company_id"><?= $Page->company_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_company_id" id="z_company_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->company_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_pending_company_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_company_id"
        name="x_company_id"
        class="form-select ew-select<?= $Page->company_id->isInvalidClass() ?>"
        <?php if (!$Page->company_id->IsNativeSelect) { ?>
        data-select2-id="fpo_s_pendingsearch_x_company_id"
        <?php } ?>
        data-table="po_s_pending"
        data-field="x_company_id"
        data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>"
        <?= $Page->company_id->editAttributes() ?>>
        <?= $Page->company_id->selectOptionListHtml("x_company_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->company_id->getErrorMessage(false) ?></div>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
<?php if (!$Page->company_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_s_pendingsearch", function() {
    var options = { name: "x_company_id", selectId: "fpo_s_pendingsearch_x_company_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_s_pendingsearch.lists.company_id?.lookupOptions.length) {
        options.data = { id: "x_company_id", form: "fpo_s_pendingsearch" };
    } else {
        options.ajax = { id: "x_company_id", form: "fpo_s_pendingsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_s_pending.fields.company_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->partner_id->Visible) { // partner_id ?>
    <div id="r_partner_id" class="row"<?= $Page->partner_id->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_pending_partner_id"><?= $Page->partner_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_partner_id" id="z_partner_id" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->partner_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_pending_partner_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_partner_id"
        name="x_partner_id"
        class="form-control ew-select<?= $Page->partner_id->isInvalidClass() ?>"
        data-select2-id="fpo_s_pendingsearch_x_partner_id"
        data-table="po_s_pending"
        data-field="x_partner_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->partner_id->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->partner_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->partner_id->getPlaceHolder()) ?>"
        <?= $Page->partner_id->editAttributes() ?>>
        <?= $Page->partner_id->selectOptionListHtml("x_partner_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->partner_id->getErrorMessage(false) ?></div>
<?= $Page->partner_id->Lookup->getParamTag($Page, "p_x_partner_id") ?>
<script>
loadjs.ready("fpo_s_pendingsearch", function() {
    var options = { name: "x_partner_id", selectId: "fpo_s_pendingsearch_x_partner_id" };
    if (fpo_s_pendingsearch.lists.partner_id?.lookupOptions.length) {
        options.data = { id: "x_partner_id", form: "fpo_s_pendingsearch" };
    } else {
        options.ajax = { id: "x_partner_id", form: "fpo_s_pendingsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.po_s_pending.fields.partner_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->partner_order_no->Visible) { // partner_order_no ?>
    <div id="r_partner_order_no" class="row"<?= $Page->partner_order_no->rowAttributes() ?>>
        <label for="x_partner_order_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_pending_partner_order_no"><?= $Page->partner_order_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_partner_order_no" id="z_partner_order_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->partner_order_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_pending_partner_order_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->partner_order_no->getInputTextType() ?>" name="x_partner_order_no" id="x_partner_order_no" data-table="po_s_pending" data-field="x_partner_order_no" value="<?= $Page->partner_order_no->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->partner_order_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->partner_order_no->formatPattern()) ?>"<?= $Page->partner_order_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->partner_order_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_pending_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_pending_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="po_s_pending" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->p_remarks->Visible) { // p_remarks ?>
    <div id="r_p_remarks" class="row"<?= $Page->p_remarks->rowAttributes() ?>>
        <label for="x_p_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_pending_p_remarks"><?= $Page->p_remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_p_remarks" id="z_p_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->p_remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_pending_p_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->p_remarks->getInputTextType() ?>" name="x_p_remarks" id="x_p_remarks" data-table="po_s_pending" data-field="x_p_remarks" value="<?= $Page->p_remarks->EditValue ?>" maxlength="500" placeholder="<?= HtmlEncode($Page->p_remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->p_remarks->formatPattern()) ?>"<?= $Page->p_remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->p_remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp" class="row"<?= $Page->grp->rowAttributes() ?>>
        <label for="x_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_pending_grp"><?= $Page->grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_pending_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fpo_s_pendingsearch_x_grp"
        <?php } ?>
        data-table="po_s_pending"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_s_pendingsearch", function() {
    var options = { name: "x_grp", selectId: "fpo_s_pendingsearch_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_s_pendingsearch.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fpo_s_pendingsearch" };
    } else {
        options.ajax = { id: "x_grp", form: "fpo_s_pendingsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_s_pending.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp" class="row"<?= $Page->s_grp->rowAttributes() ?>>
        <label for="x_s_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_pending_s_grp"><?= $Page->s_grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_s_grp" id="z_s_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->s_grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_pending_s_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="fpo_s_pendingsearch_x_s_grp"
        <?php } ?>
        data-table="po_s_pending"
        data-field="x_s_grp"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage(false) ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_s_pendingsearch", function() {
    var options = { name: "x_s_grp", selectId: "fpo_s_pendingsearch_x_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_s_pendingsearch.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "fpo_s_pendingsearch" };
    } else {
        options.ajax = { id: "x_s_grp", form: "fpo_s_pendingsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_s_pending.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product" class="row"<?= $Page->product->rowAttributes() ?>>
        <label for="x_product" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_pending_product"><?= $Page->product->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product" id="z_product" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_pending_product" class="ew-search-field ew-search-field-single">
    <select
        id="x_product"
        name="x_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="fpo_s_pendingsearch_x_product"
        <?php } ?>
        data-table="po_s_pending"
        data-field="x_product"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage(false) ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_s_pendingsearch", function() {
    var options = { name: "x_product", selectId: "fpo_s_pendingsearch_x_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_s_pendingsearch.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "fpo_s_pendingsearch" };
    } else {
        options.ajax = { id: "x_product", form: "fpo_s_pendingsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_s_pending.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ref->Visible) { // ref ?>
    <div id="r_ref" class="row"<?= $Page->ref->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_pending_ref"><?= $Page->ref->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_ref" id="z_ref" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ref->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_pending_ref" class="ew-search-field ew-search-field-single">
    <select
        id="x_ref"
        name="x_ref"
        class="form-control ew-select<?= $Page->ref->isInvalidClass() ?>"
        data-select2-id="fpo_s_pendingsearch_x_ref"
        data-table="po_s_pending"
        data-field="x_ref"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->ref->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->ref->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ref->getPlaceHolder()) ?>"
        <?= $Page->ref->editAttributes() ?>>
        <?= $Page->ref->selectOptionListHtml("x_ref") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->ref->getErrorMessage(false) ?></div>
<?= $Page->ref->Lookup->getParamTag($Page, "p_x_ref") ?>
<script>
loadjs.ready("fpo_s_pendingsearch", function() {
    var options = { name: "x_ref", selectId: "fpo_s_pendingsearch_x_ref" };
    if (fpo_s_pendingsearch.lists.ref?.lookupOptions.length) {
        options.data = { id: "x_ref", form: "fpo_s_pendingsearch" };
    } else {
        options.ajax = { id: "x_ref", form: "fpo_s_pendingsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.po_s_pending.fields.ref.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product_code->Visible) { // product_code ?>
    <div id="r_product_code" class="row"<?= $Page->product_code->rowAttributes() ?>>
        <label for="x_product_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_pending_product_code"><?= $Page->product_code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_product_code" id="z_product_code" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product_code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_pending_product_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->product_code->getInputTextType() ?>" name="x_product_code" id="x_product_code" data-table="po_s_pending" data-field="x_product_code" value="<?= $Page->product_code->EditValue ?>" maxlength="300" placeholder="<?= HtmlEncode($Page->product_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->product_code->formatPattern()) ?>"<?= $Page->product_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->product_code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->order_quantity->Visible) { // order_quantity ?>
    <div id="r_order_quantity" class="row"<?= $Page->order_quantity->rowAttributes() ?>>
        <label for="x_order_quantity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_pending_order_quantity"><?= $Page->order_quantity->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_order_quantity" id="z_order_quantity" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->order_quantity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_pending_order_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->order_quantity->getInputTextType() ?>" name="x_order_quantity" id="x_order_quantity" data-table="po_s_pending" data-field="x_order_quantity" value="<?= $Page->order_quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->order_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->order_quantity->formatPattern()) ?>"<?= $Page->order_quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->order_quantity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pending_qty->Visible) { // pending_qty ?>
    <div id="r_pending_qty" class="row"<?= $Page->pending_qty->rowAttributes() ?>>
        <label for="x_pending_qty" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_pending_pending_qty"><?= $Page->pending_qty->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pending_qty->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_pending_qty" id="z_pending_qty" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->pending_qty->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->pending_qty->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_po_s_pending_pending_qty" class="ew-search-field">
<input type="<?= $Page->pending_qty->getInputTextType() ?>" name="x_pending_qty" id="x_pending_qty" data-table="po_s_pending" data-field="x_pending_qty" value="<?= $Page->pending_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pending_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pending_qty->formatPattern()) ?>"<?= $Page->pending_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pending_qty->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_po_s_pending_pending_qty" class="ew-search-field2 d-none">
<input type="<?= $Page->pending_qty->getInputTextType() ?>" name="y_pending_qty" id="y_pending_qty" data-table="po_s_pending" data-field="x_pending_qty" value="<?= $Page->pending_qty->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->pending_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pending_qty->formatPattern()) ?>"<?= $Page->pending_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pending_qty->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->order_date->Visible) { // order_date ?>
    <div id="r_order_date" class="row"<?= $Page->order_date->rowAttributes() ?>>
        <label for="x_order_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_pending_order_date"><?= $Page->order_date->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_order_date" id="z_order_date" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->order_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_pending_order_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->order_date->getInputTextType() ?>" name="x_order_date" id="x_order_date" data-table="po_s_pending" data-field="x_order_date" value="<?= $Page->order_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->order_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->order_date->formatPattern()) ?>"<?= $Page->order_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->order_date->getErrorMessage(false) ?></div>
<?php if (!$Page->order_date->ReadOnly && !$Page->order_date->Disabled && !isset($Page->order_date->EditAttrs["readonly"]) && !isset($Page->order_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpo_s_pendingsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpo_s_pendingsearch", "x_order_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->despatch_date->Visible) { // despatch_date ?>
    <div id="r_despatch_date" class="row"<?= $Page->despatch_date->rowAttributes() ?>>
        <label for="x_despatch_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_pending_despatch_date"><?= $Page->despatch_date->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_despatch_date" id="z_despatch_date" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->despatch_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_pending_despatch_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->despatch_date->getInputTextType() ?>" name="x_despatch_date" id="x_despatch_date" data-table="po_s_pending" data-field="x_despatch_date" value="<?= $Page->despatch_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->despatch_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->despatch_date->formatPattern()) ?>"<?= $Page->despatch_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->despatch_date->getErrorMessage(false) ?></div>
<?php if (!$Page->despatch_date->ReadOnly && !$Page->despatch_date->Disabled && !isset($Page->despatch_date->EditAttrs["readonly"]) && !isset($Page->despatch_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpo_s_pendingsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpo_s_pendingsearch", "x_despatch_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->avg_quantity->Visible) { // avg_quantity ?>
    <div id="r_avg_quantity" class="row"<?= $Page->avg_quantity->rowAttributes() ?>>
        <label for="x_avg_quantity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_pending_avg_quantity"><?= $Page->avg_quantity->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_avg_quantity" id="z_avg_quantity" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->avg_quantity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_pending_avg_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->avg_quantity->getInputTextType() ?>" name="x_avg_quantity" id="x_avg_quantity" data-table="po_s_pending" data-field="x_avg_quantity" value="<?= $Page->avg_quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->avg_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->avg_quantity->formatPattern()) ?>"<?= $Page->avg_quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->avg_quantity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type" class="row"<?= $Page->packing_type->rowAttributes() ?>>
        <label for="x_packing_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_pending_packing_type"><?= $Page->packing_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packing_type" id="z_packing_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packing_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_pending_packing_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_packing_type"
        name="x_packing_type"
        class="form-select ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_type->IsNativeSelect) { ?>
        data-select2-id="fpo_s_pendingsearch_x_packing_type"
        <?php } ?>
        data-table="po_s_pending"
        data-field="x_packing_type"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage(false) ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x_packing_type") ?>
<?php if (!$Page->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_s_pendingsearch", function() {
    var options = { name: "x_packing_type", selectId: "fpo_s_pendingsearch_x_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_s_pendingsearch.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x_packing_type", form: "fpo_s_pendingsearch" };
    } else {
        options.ajax = { id: "x_packing_type", form: "fpo_s_pendingsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_s_pending.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_pending_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_pending_status" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->status->getInputTextType() ?>" name="x_status" id="x_status" data-table="po_s_pending" data-field="x_status" value="<?= $Page->status->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->status->formatPattern()) ?>"<?= $Page->status->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->p_qty->Visible) { // p_qty ?>
    <div id="r_p_qty" class="row"<?= $Page->p_qty->rowAttributes() ?>>
        <label for="x_p_qty" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_pending_p_qty"><?= $Page->p_qty->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_p_qty" id="z_p_qty" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->p_qty->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_pending_p_qty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->p_qty->getInputTextType() ?>" name="x_p_qty" id="x_p_qty" data-table="po_s_pending" data-field="x_p_qty" value="<?= $Page->p_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->p_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->p_qty->formatPattern()) ?>"<?= $Page->p_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->p_qty->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fpo_s_pendingsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpo_s_pendingsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fpo_s_pendingsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("po_s_pending");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
