<?php

namespace PHPMaker2024\fibre;

// Page object
$PoSPendingList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { po_s_pending: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fpo_s_pendingsrch" id="fpo_s_pendingsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fpo_s_pendingsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { po_s_pending: currentTable } });
var currentForm;
var fpo_s_pendingsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpo_s_pendingsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["po_id", [], fields.po_id.isInvalid],
            ["y_po_id", [ew.Validators.between], false],
            ["partner_id", [], fields.partner_id.isInvalid],
            ["ref", [], fields.ref.isInvalid],
            ["pending_qty", [ew.Validators.float], fields.pending_qty.isInvalid],
            ["y_pending_qty", [ew.Validators.between], false]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "po_id": <?= $Page->po_id->toClientList($Page) ?>,
            "partner_id": <?= $Page->partner_id->toClientList($Page) ?>,
            "ref": <?= $Page->ref->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->po_id->Visible) { // po_id ?>
<?php
if (!$Page->po_id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_po_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->po_id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_po_id" class="ew-search-caption ew-label"><?= $Page->po_id->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_po_id" id="z_po_id" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->po_id->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->po_id->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_po_s_pending_po_id" class="ew-search-field">
    <select
        id="x_po_id"
        name="x_po_id"
        class="form-select ew-select<?= $Page->po_id->isInvalidClass() ?>"
        <?php if (!$Page->po_id->IsNativeSelect) { ?>
        data-select2-id="fpo_s_pendingsrch_x_po_id"
        <?php } ?>
        data-table="po_s_pending"
        data-field="x_po_id"
        data-value-separator="<?= $Page->po_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->po_id->getPlaceHolder()) ?>"
        <?= $Page->po_id->editAttributes() ?>>
        <?= $Page->po_id->selectOptionListHtml("x_po_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->po_id->getErrorMessage(false) ?></div>
<?= $Page->po_id->Lookup->getParamTag($Page, "p_x_po_id") ?>
<?php if (!$Page->po_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_s_pendingsrch", function() {
    var options = { name: "x_po_id", selectId: "fpo_s_pendingsrch_x_po_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_s_pendingsrch.lists.po_id?.lookupOptions.length) {
        options.data = { id: "x_po_id", form: "fpo_s_pendingsrch" };
    } else {
        options.ajax = { id: "x_po_id", form: "fpo_s_pendingsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_s_pending.fields.po_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_po_s_pending_po_id" class="ew-search-field2 d-none">
    <select
        id="y_po_id"
        name="y_po_id"
        class="form-select ew-select<?= $Page->po_id->isInvalidClass() ?>"
        <?php if (!$Page->po_id->IsNativeSelect) { ?>
        data-select2-id="fpo_s_pendingsrch_y_po_id"
        <?php } ?>
        data-table="po_s_pending"
        data-field="x_po_id"
        data-value-separator="<?= $Page->po_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->po_id->getPlaceHolder()) ?>"
        <?= $Page->po_id->editAttributes() ?>>
        <?= $Page->po_id->selectOptionListHtml("y_po_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->po_id->getErrorMessage(false) ?></div>
<?= $Page->po_id->Lookup->getParamTag($Page, "p_y_po_id") ?>
<?php if (!$Page->po_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_s_pendingsrch", function() {
    var options = { name: "y_po_id", selectId: "fpo_s_pendingsrch_y_po_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_s_pendingsrch.lists.po_id?.lookupOptions.length) {
        options.data = { id: "y_po_id", form: "fpo_s_pendingsrch" };
    } else {
        options.ajax = { id: "y_po_id", form: "fpo_s_pendingsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_s_pending.fields.po_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->partner_id->Visible) { // partner_id ?>
<?php
if (!$Page->partner_id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_partner_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->partner_id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->partner_id->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_partner_id" id="z_partner_id" value="LIKE">
</div>
        </div>
        <div id="el_po_s_pending_partner_id" class="ew-search-field">
    <select
        id="x_partner_id"
        name="x_partner_id"
        class="form-control ew-select<?= $Page->partner_id->isInvalidClass() ?>"
        data-select2-id="fpo_s_pendingsrch_x_partner_id"
        data-table="po_s_pending"
        data-field="x_partner_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->partner_id->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->partner_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->partner_id->getPlaceHolder()) ?>"
        <?= $Page->partner_id->editAttributes() ?>>
        <?= $Page->partner_id->selectOptionListHtml("x_partner_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->partner_id->getErrorMessage(false) ?></div>
<?= $Page->partner_id->Lookup->getParamTag($Page, "p_x_partner_id") ?>
<script>
loadjs.ready("fpo_s_pendingsrch", function() {
    var options = { name: "x_partner_id", selectId: "fpo_s_pendingsrch_x_partner_id" };
    if (fpo_s_pendingsrch.lists.partner_id?.lookupOptions.length) {
        options.data = { id: "x_partner_id", form: "fpo_s_pendingsrch" };
    } else {
        options.ajax = { id: "x_partner_id", form: "fpo_s_pendingsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.po_s_pending.fields.partner_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->ref->Visible) { // ref ?>
<?php
if (!$Page->ref->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_ref" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->ref->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->ref->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_ref" id="z_ref" value="=">
</div>
        </div>
        <div id="el_po_s_pending_ref" class="ew-search-field">
    <select
        id="x_ref"
        name="x_ref"
        class="form-control ew-select<?= $Page->ref->isInvalidClass() ?>"
        data-select2-id="fpo_s_pendingsrch_x_ref"
        data-table="po_s_pending"
        data-field="x_ref"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->ref->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->ref->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ref->getPlaceHolder()) ?>"
        <?= $Page->ref->editAttributes() ?>>
        <?= $Page->ref->selectOptionListHtml("x_ref") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->ref->getErrorMessage(false) ?></div>
<?= $Page->ref->Lookup->getParamTag($Page, "p_x_ref") ?>
<script>
loadjs.ready("fpo_s_pendingsrch", function() {
    var options = { name: "x_ref", selectId: "fpo_s_pendingsrch_x_ref" };
    if (fpo_s_pendingsrch.lists.ref?.lookupOptions.length) {
        options.data = { id: "x_ref", form: "fpo_s_pendingsrch" };
    } else {
        options.ajax = { id: "x_ref", form: "fpo_s_pendingsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.po_s_pending.fields.ref.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->pending_qty->Visible) { // pending_qty ?>
<?php
if (!$Page->pending_qty->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_pending_qty" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->pending_qty->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_pending_qty" class="ew-search-caption ew-label"><?= $Page->pending_qty->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_pending_qty" id="z_pending_qty" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->pending_qty->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->pending_qty->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_po_s_pending_pending_qty" class="ew-search-field">
<input type="<?= $Page->pending_qty->getInputTextType() ?>" name="x_pending_qty" id="x_pending_qty" data-table="po_s_pending" data-field="x_pending_qty" value="<?= $Page->pending_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pending_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pending_qty->formatPattern()) ?>"<?= $Page->pending_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pending_qty->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_po_s_pending_pending_qty" class="ew-search-field2 d-none">
<input type="<?= $Page->pending_qty->getInputTextType() ?>" name="y_pending_qty" id="y_pending_qty" data-table="po_s_pending" data-field="x_pending_qty" value="<?= $Page->pending_qty->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->pending_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pending_qty->formatPattern()) ?>"<?= $Page->pending_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pending_qty->getErrorMessage(false) ?></div>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fpo_s_pendingsrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fpo_s_pendingsrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fpo_s_pendingsrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fpo_s_pendingsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fpo_s_pendingsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fpo_s_pendingsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fpo_s_pendingsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="po_s_pending">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_po_s_pending" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_po_s_pendinglist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->cart_id->Visible) { // cart_id ?>
        <th data-name="cart_id" class="<?= $Page->cart_id->headerCellClass() ?>"><div id="elh_po_s_pending_cart_id" class="po_s_pending_cart_id"><?= $Page->renderFieldHeader($Page->cart_id) ?></div></th>
<?php } ?>
<?php if ($Page->po_id->Visible) { // po_id ?>
        <th data-name="po_id" class="<?= $Page->po_id->headerCellClass() ?>"><div id="elh_po_s_pending_po_id" class="po_s_pending_po_id"><?= $Page->renderFieldHeader($Page->po_id) ?></div></th>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
        <th data-name="company_id" class="<?= $Page->company_id->headerCellClass() ?>"><div id="elh_po_s_pending_company_id" class="po_s_pending_company_id"><?= $Page->renderFieldHeader($Page->company_id) ?></div></th>
<?php } ?>
<?php if ($Page->partner_id->Visible) { // partner_id ?>
        <th data-name="partner_id" class="<?= $Page->partner_id->headerCellClass() ?>"><div id="elh_po_s_pending_partner_id" class="po_s_pending_partner_id"><?= $Page->renderFieldHeader($Page->partner_id) ?></div></th>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
        <th data-name="remarks" class="<?= $Page->remarks->headerCellClass() ?>"><div id="elh_po_s_pending_remarks" class="po_s_pending_remarks"><?= $Page->renderFieldHeader($Page->remarks) ?></div></th>
<?php } ?>
<?php if ($Page->p_remarks->Visible) { // p_remarks ?>
        <th data-name="p_remarks" class="<?= $Page->p_remarks->headerCellClass() ?>"><div id="elh_po_s_pending_p_remarks" class="po_s_pending_p_remarks"><?= $Page->renderFieldHeader($Page->p_remarks) ?></div></th>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
        <th data-name="grp" class="<?= $Page->grp->headerCellClass() ?>"><div id="elh_po_s_pending_grp" class="po_s_pending_grp"><?= $Page->renderFieldHeader($Page->grp) ?></div></th>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
        <th data-name="product" class="<?= $Page->product->headerCellClass() ?>"><div id="elh_po_s_pending_product" class="po_s_pending_product"><?= $Page->renderFieldHeader($Page->product) ?></div></th>
<?php } ?>
<?php if ($Page->ref->Visible) { // ref ?>
        <th data-name="ref" class="<?= $Page->ref->headerCellClass() ?>"><div id="elh_po_s_pending_ref" class="po_s_pending_ref"><?= $Page->renderFieldHeader($Page->ref) ?></div></th>
<?php } ?>
<?php if ($Page->order_quantity->Visible) { // order_quantity ?>
        <th data-name="order_quantity" class="<?= $Page->order_quantity->headerCellClass() ?>"><div id="elh_po_s_pending_order_quantity" class="po_s_pending_order_quantity"><?= $Page->renderFieldHeader($Page->order_quantity) ?></div></th>
<?php } ?>
<?php if ($Page->pending_qty->Visible) { // pending_qty ?>
        <th data-name="pending_qty" class="<?= $Page->pending_qty->headerCellClass() ?>"><div id="elh_po_s_pending_pending_qty" class="po_s_pending_pending_qty"><?= $Page->renderFieldHeader($Page->pending_qty) ?></div></th>
<?php } ?>
<?php if ($Page->order_date->Visible) { // order_date ?>
        <th data-name="order_date" class="<?= $Page->order_date->headerCellClass() ?>"><div id="elh_po_s_pending_order_date" class="po_s_pending_order_date"><?= $Page->renderFieldHeader($Page->order_date) ?></div></th>
<?php } ?>
<?php if ($Page->despatch_date->Visible) { // despatch_date ?>
        <th data-name="despatch_date" class="<?= $Page->despatch_date->headerCellClass() ?>"><div id="elh_po_s_pending_despatch_date" class="po_s_pending_despatch_date"><?= $Page->renderFieldHeader($Page->despatch_date) ?></div></th>
<?php } ?>
<?php if ($Page->avg_quantity->Visible) { // avg_quantity ?>
        <th data-name="avg_quantity" class="<?= $Page->avg_quantity->headerCellClass() ?>"><div id="elh_po_s_pending_avg_quantity" class="po_s_pending_avg_quantity"><?= $Page->renderFieldHeader($Page->avg_quantity) ?></div></th>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
        <th data-name="packing_type" class="<?= $Page->packing_type->headerCellClass() ?>"><div id="elh_po_s_pending_packing_type" class="po_s_pending_packing_type"><?= $Page->renderFieldHeader($Page->packing_type) ?></div></th>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
        <th data-name="status" class="<?= $Page->status->headerCellClass() ?>"><div id="elh_po_s_pending_status" class="po_s_pending_status"><?= $Page->renderFieldHeader($Page->status) ?></div></th>
<?php } ?>
<?php if ($Page->p_qty->Visible) { // p_qty ?>
        <th data-name="p_qty" class="<?= $Page->p_qty->headerCellClass() ?>"><div id="elh_po_s_pending_p_qty" class="po_s_pending_p_qty"><?= $Page->renderFieldHeader($Page->p_qty) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->cart_id->Visible) { // cart_id ?>
        <td data-name="cart_id"<?= $Page->cart_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_s_pending_cart_id" class="el_po_s_pending_cart_id">
<span<?= $Page->cart_id->viewAttributes() ?>>
<?= $Page->cart_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->po_id->Visible) { // po_id ?>
        <td data-name="po_id"<?= $Page->po_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_s_pending_po_id" class="el_po_s_pending_po_id">
<span<?= $Page->po_id->viewAttributes() ?>>
<?= $Page->po_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->company_id->Visible) { // company_id ?>
        <td data-name="company_id"<?= $Page->company_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_s_pending_company_id" class="el_po_s_pending_company_id">
<span<?= $Page->company_id->viewAttributes() ?>>
<?= $Page->company_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->partner_id->Visible) { // partner_id ?>
        <td data-name="partner_id"<?= $Page->partner_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_s_pending_partner_id" class="el_po_s_pending_partner_id">
<span<?= $Page->partner_id->viewAttributes() ?>>
<?= $Page->partner_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->remarks->Visible) { // remarks ?>
        <td data-name="remarks"<?= $Page->remarks->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_s_pending_remarks" class="el_po_s_pending_remarks">
<span<?= $Page->remarks->viewAttributes() ?>>
<?= $Page->remarks->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->p_remarks->Visible) { // p_remarks ?>
        <td data-name="p_remarks"<?= $Page->p_remarks->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_s_pending_p_remarks" class="el_po_s_pending_p_remarks">
<span<?= $Page->p_remarks->viewAttributes() ?>>
<?= $Page->p_remarks->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->grp->Visible) { // grp ?>
        <td data-name="grp"<?= $Page->grp->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_s_pending_grp" class="el_po_s_pending_grp">
<span<?= $Page->grp->viewAttributes() ?>>
<?= $Page->grp->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->product->Visible) { // product ?>
        <td data-name="product"<?= $Page->product->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_s_pending_product" class="el_po_s_pending_product">
<span<?= $Page->product->viewAttributes() ?>>
<?= $Page->product->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ref->Visible) { // ref ?>
        <td data-name="ref"<?= $Page->ref->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_s_pending_ref" class="el_po_s_pending_ref">
<span<?= $Page->ref->viewAttributes() ?>>
<?= $Page->ref->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->order_quantity->Visible) { // order_quantity ?>
        <td data-name="order_quantity"<?= $Page->order_quantity->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_s_pending_order_quantity" class="el_po_s_pending_order_quantity">
<span<?= $Page->order_quantity->viewAttributes() ?>>
<?= $Page->order_quantity->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pending_qty->Visible) { // pending_qty ?>
        <td data-name="pending_qty"<?= $Page->pending_qty->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_s_pending_pending_qty" class="el_po_s_pending_pending_qty">
<span<?= $Page->pending_qty->viewAttributes() ?>>
<?= $Page->pending_qty->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->order_date->Visible) { // order_date ?>
        <td data-name="order_date"<?= $Page->order_date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_s_pending_order_date" class="el_po_s_pending_order_date">
<span<?= $Page->order_date->viewAttributes() ?>>
<?= $Page->order_date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->despatch_date->Visible) { // despatch_date ?>
        <td data-name="despatch_date"<?= $Page->despatch_date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_s_pending_despatch_date" class="el_po_s_pending_despatch_date">
<span<?= $Page->despatch_date->viewAttributes() ?>>
<?= $Page->despatch_date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->avg_quantity->Visible) { // avg_quantity ?>
        <td data-name="avg_quantity"<?= $Page->avg_quantity->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_s_pending_avg_quantity" class="el_po_s_pending_avg_quantity">
<span<?= $Page->avg_quantity->viewAttributes() ?>>
<?= $Page->avg_quantity->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->packing_type->Visible) { // packing_type ?>
        <td data-name="packing_type"<?= $Page->packing_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_s_pending_packing_type" class="el_po_s_pending_packing_type">
<span<?= $Page->packing_type->viewAttributes() ?>>
<?= $Page->packing_type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->status->Visible) { // status ?>
        <td data-name="status"<?= $Page->status->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_s_pending_status" class="el_po_s_pending_status">
<span<?= $Page->status->viewAttributes() ?>>
<?= $Page->status->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->p_qty->Visible) { // p_qty ?>
        <td data-name="p_qty"<?= $Page->p_qty->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_s_pending_p_qty" class="el_po_s_pending_p_qty">
<span<?= $Page->p_qty->viewAttributes() ?>>
<?= $Page->p_qty->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Page->RowType = RowType::AGGREGATE;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->TotalRecords > 0 && !$Page->isGridAdd() && !$Page->isGridEdit() && !$Page->isMultiEdit()) { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (footer, left)
$Page->ListOptions->render("footer", "left");
?>
    <?php if ($Page->cart_id->Visible) { // cart_id ?>
        <td data-name="cart_id" class="<?= $Page->cart_id->footerCellClass() ?>"><span id="elf_po_s_pending_cart_id" class="po_s_pending_cart_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->po_id->Visible) { // po_id ?>
        <td data-name="po_id" class="<?= $Page->po_id->footerCellClass() ?>"><span id="elf_po_s_pending_po_id" class="po_s_pending_po_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->company_id->Visible) { // company_id ?>
        <td data-name="company_id" class="<?= $Page->company_id->footerCellClass() ?>"><span id="elf_po_s_pending_company_id" class="po_s_pending_company_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->partner_id->Visible) { // partner_id ?>
        <td data-name="partner_id" class="<?= $Page->partner_id->footerCellClass() ?>"><span id="elf_po_s_pending_partner_id" class="po_s_pending_partner_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->remarks->Visible) { // remarks ?>
        <td data-name="remarks" class="<?= $Page->remarks->footerCellClass() ?>"><span id="elf_po_s_pending_remarks" class="po_s_pending_remarks">
        </span></td>
    <?php } ?>
    <?php if ($Page->p_remarks->Visible) { // p_remarks ?>
        <td data-name="p_remarks" class="<?= $Page->p_remarks->footerCellClass() ?>"><span id="elf_po_s_pending_p_remarks" class="po_s_pending_p_remarks">
        </span></td>
    <?php } ?>
    <?php if ($Page->grp->Visible) { // grp ?>
        <td data-name="grp" class="<?= $Page->grp->footerCellClass() ?>"><span id="elf_po_s_pending_grp" class="po_s_pending_grp">
        </span></td>
    <?php } ?>
    <?php if ($Page->product->Visible) { // product ?>
        <td data-name="product" class="<?= $Page->product->footerCellClass() ?>"><span id="elf_po_s_pending_product" class="po_s_pending_product">
        </span></td>
    <?php } ?>
    <?php if ($Page->ref->Visible) { // ref ?>
        <td data-name="ref" class="<?= $Page->ref->footerCellClass() ?>"><span id="elf_po_s_pending_ref" class="po_s_pending_ref">
        </span></td>
    <?php } ?>
    <?php if ($Page->order_quantity->Visible) { // order_quantity ?>
        <td data-name="order_quantity" class="<?= $Page->order_quantity->footerCellClass() ?>"><span id="elf_po_s_pending_order_quantity" class="po_s_pending_order_quantity">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->order_quantity->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->pending_qty->Visible) { // pending_qty ?>
        <td data-name="pending_qty" class="<?= $Page->pending_qty->footerCellClass() ?>"><span id="elf_po_s_pending_pending_qty" class="po_s_pending_pending_qty">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->pending_qty->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->order_date->Visible) { // order_date ?>
        <td data-name="order_date" class="<?= $Page->order_date->footerCellClass() ?>"><span id="elf_po_s_pending_order_date" class="po_s_pending_order_date">
        </span></td>
    <?php } ?>
    <?php if ($Page->despatch_date->Visible) { // despatch_date ?>
        <td data-name="despatch_date" class="<?= $Page->despatch_date->footerCellClass() ?>"><span id="elf_po_s_pending_despatch_date" class="po_s_pending_despatch_date">
        </span></td>
    <?php } ?>
    <?php if ($Page->avg_quantity->Visible) { // avg_quantity ?>
        <td data-name="avg_quantity" class="<?= $Page->avg_quantity->footerCellClass() ?>"><span id="elf_po_s_pending_avg_quantity" class="po_s_pending_avg_quantity">
        <span class="ew-aggregate"><?= $Language->phrase("AVERAGE") ?></span><span class="ew-aggregate-value">
        <?= $Page->avg_quantity->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->packing_type->Visible) { // packing_type ?>
        <td data-name="packing_type" class="<?= $Page->packing_type->footerCellClass() ?>"><span id="elf_po_s_pending_packing_type" class="po_s_pending_packing_type">
        </span></td>
    <?php } ?>
    <?php if ($Page->status->Visible) { // status ?>
        <td data-name="status" class="<?= $Page->status->footerCellClass() ?>"><span id="elf_po_s_pending_status" class="po_s_pending_status">
        </span></td>
    <?php } ?>
    <?php if ($Page->p_qty->Visible) { // p_qty ?>
        <td data-name="p_qty" class="<?= $Page->p_qty->footerCellClass() ?>"><span id="elf_po_s_pending_p_qty" class="po_s_pending_p_qty">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Page->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("po_s_pending");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
