<?php

namespace PHPMaker2024\fibre;

// Page object
$PoSList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { po_s: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fpo_ssrch" id="fpo_ssrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fpo_ssrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { po_s: currentTable } });
var currentForm;
var fpo_ssrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpo_ssrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["po", [], fields.po.isInvalid],
            ["partner_id", [ew.Validators.integer], fields.partner_id.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "partner_id": <?= $Page->partner_id->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->po->Visible) { // po ?>
<?php
if (!$Page->po->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_po" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->po->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_po" class="ew-search-caption ew-label"><?= $Page->po->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_po" id="z_po" value="=">
</div>
        </div>
        <div id="el_po_s_po" class="ew-search-field">
<input type="<?= $Page->po->getInputTextType() ?>" name="x_po" id="x_po" data-table="po_s" data-field="x_po" value="<?= $Page->po->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->partner_id->Visible) { // partner_id ?>
<?php
if (!$Page->partner_id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_partner_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->partner_id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->partner_id->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_partner_id" id="z_partner_id" value="=">
</div>
        </div>
        <div id="el_po_s_partner_id" class="ew-search-field">
<?php
if (IsRTL()) {
    $Page->partner_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_partner_id" class="ew-auto-suggest">
    <input type="<?= $Page->partner_id->getInputTextType() ?>" class="form-control" name="sv_x_partner_id" id="sv_x_partner_id" value="<?= RemoveHtml($Page->partner_id->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->partner_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->partner_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->partner_id->formatPattern()) ?>"<?= $Page->partner_id->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="po_s" data-field="x_partner_id" data-input="sv_x_partner_id" data-value-separator="<?= $Page->partner_id->displayValueSeparatorAttribute() ?>" name="x_partner_id" id="x_partner_id" value="<?= HtmlEncode($Page->partner_id->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->partner_id->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fpo_ssrch", function() {
    fpo_ssrch.createAutoSuggest(Object.assign({"id":"x_partner_id","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->partner_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.po_s.fields.partner_id.autoSuggestOptions));
});
</script>
<?= $Page->partner_id->Lookup->getParamTag($Page, "p_x_partner_id") ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fpo_ssrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fpo_ssrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fpo_ssrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fpo_ssrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fpo_ssrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fpo_ssrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fpo_ssrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="po_s">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_po_s" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_po_slist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_po_s_id" class="po_s_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
        <th data-name="po" class="<?= $Page->po->headerCellClass() ?>"><div id="elh_po_s_po" class="po_s_po"><?= $Page->renderFieldHeader($Page->po) ?></div></th>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
        <th data-name="company_id" class="<?= $Page->company_id->headerCellClass() ?>"><div id="elh_po_s_company_id" class="po_s_company_id"><?= $Page->renderFieldHeader($Page->company_id) ?></div></th>
<?php } ?>
<?php if ($Page->partner_id->Visible) { // partner_id ?>
        <th data-name="partner_id" class="<?= $Page->partner_id->headerCellClass() ?>"><div id="elh_po_s_partner_id" class="po_s_partner_id"><?= $Page->renderFieldHeader($Page->partner_id) ?></div></th>
<?php } ?>
<?php if ($Page->copy->Visible) { // copy ?>
        <th data-name="copy" class="<?= $Page->copy->headerCellClass() ?>"><div id="elh_po_s_copy" class="po_s_copy"><?= $Page->renderFieldHeader($Page->copy) ?></div></th>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
        <th data-name="quantity" class="<?= $Page->quantity->headerCellClass() ?>"><div id="elh_po_s_quantity" class="po_s_quantity"><?= $Page->renderFieldHeader($Page->quantity) ?></div></th>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
        <th data-name="sqm" class="<?= $Page->sqm->headerCellClass() ?>"><div id="elh_po_s_sqm" class="po_s_sqm"><?= $Page->renderFieldHeader($Page->sqm) ?></div></th>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
        <th data-name="amount" class="<?= $Page->amount->headerCellClass() ?>"><div id="elh_po_s_amount" class="po_s_amount"><?= $Page->renderFieldHeader($Page->amount) ?></div></th>
<?php } ?>
<?php if ($Page->cbm->Visible) { // cbm ?>
        <th data-name="cbm" class="<?= $Page->cbm->headerCellClass() ?>"><div id="elh_po_s_cbm" class="po_s_cbm"><?= $Page->renderFieldHeader($Page->cbm) ?></div></th>
<?php } ?>
<?php if ($Page->gst->Visible) { // gst ?>
        <th data-name="gst" class="<?= $Page->gst->headerCellClass() ?>"><div id="elh_po_s_gst" class="po_s_gst"><?= $Page->renderFieldHeader($Page->gst) ?></div></th>
<?php } ?>
<?php if ($Page->despatch_date->Visible) { // despatch_date ?>
        <th data-name="despatch_date" class="<?= $Page->despatch_date->headerCellClass() ?>"><div id="elh_po_s_despatch_date" class="po_s_despatch_date"><?= $Page->renderFieldHeader($Page->despatch_date) ?></div></th>
<?php } ?>
<?php if ($Page->despatch_week->Visible) { // despatch_week ?>
        <th data-name="despatch_week" class="<?= $Page->despatch_week->headerCellClass() ?>"><div id="elh_po_s_despatch_week" class="po_s_despatch_week"><?= $Page->renderFieldHeader($Page->despatch_week) ?></div></th>
<?php } ?>
<?php if ($Page->fob_date->Visible) { // fob_date ?>
        <th data-name="fob_date" class="<?= $Page->fob_date->headerCellClass() ?>"><div id="elh_po_s_fob_date" class="po_s_fob_date"><?= $Page->renderFieldHeader($Page->fob_date) ?></div></th>
<?php } ?>
<?php if ($Page->payment_terms->Visible) { // payment_terms ?>
        <th data-name="payment_terms" class="<?= $Page->payment_terms->headerCellClass() ?>"><div id="elh_po_s_payment_terms" class="po_s_payment_terms"><?= $Page->renderFieldHeader($Page->payment_terms) ?></div></th>
<?php } ?>
<?php if ($Page->transport_type->Visible) { // transport_type ?>
        <th data-name="transport_type" class="<?= $Page->transport_type->headerCellClass() ?>"><div id="elh_po_s_transport_type" class="po_s_transport_type"><?= $Page->renderFieldHeader($Page->transport_type) ?></div></th>
<?php } ?>
<?php if ($Page->partner_shipping_id->Visible) { // partner_shipping_id ?>
        <th data-name="partner_shipping_id" class="<?= $Page->partner_shipping_id->headerCellClass() ?>"><div id="elh_po_s_partner_shipping_id" class="po_s_partner_shipping_id"><?= $Page->renderFieldHeader($Page->partner_shipping_id) ?></div></th>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Page->operator->headerCellClass() ?>"><div id="elh_po_s_operator" class="po_s_operator"><?= $Page->renderFieldHeader($Page->operator) ?></div></th>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Page->datetime->headerCellClass() ?>"><div id="elh_po_s_datetime" class="po_s_datetime"><?= $Page->renderFieldHeader($Page->datetime) ?></div></th>
<?php } ?>
<?php if ($Page->a_operator->Visible) { // a_operator ?>
        <th data-name="a_operator" class="<?= $Page->a_operator->headerCellClass() ?>"><div id="elh_po_s_a_operator" class="po_s_a_operator"><?= $Page->renderFieldHeader($Page->a_operator) ?></div></th>
<?php } ?>
<?php if ($Page->a_datetime->Visible) { // a_datetime ?>
        <th data-name="a_datetime" class="<?= $Page->a_datetime->headerCellClass() ?>"><div id="elh_po_s_a_datetime" class="po_s_a_datetime"><?= $Page->renderFieldHeader($Page->a_datetime) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_s_id" class="el_po_s_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->po->Visible) { // po ?>
        <td data-name="po"<?= $Page->po->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_s_po" class="el_po_s_po">
<span<?= $Page->po->viewAttributes() ?>>
<?php if (!EmptyString($Page->po->getViewValue()) && $Page->po->linkAttributes() != "") { ?>
<a<?= $Page->po->linkAttributes() ?>><?= $Page->po->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->po->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->company_id->Visible) { // company_id ?>
        <td data-name="company_id"<?= $Page->company_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_s_company_id" class="el_po_s_company_id">
<span<?= $Page->company_id->viewAttributes() ?>>
<?= $Page->company_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->partner_id->Visible) { // partner_id ?>
        <td data-name="partner_id"<?= $Page->partner_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_s_partner_id" class="el_po_s_partner_id">
<span<?= $Page->partner_id->viewAttributes() ?>>
<?php if (!EmptyString($Page->partner_id->getViewValue()) && $Page->partner_id->linkAttributes() != "") { ?>
<a<?= $Page->partner_id->linkAttributes() ?>><?= $Page->partner_id->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->partner_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->copy->Visible) { // copy ?>
        <td data-name="copy"<?= $Page->copy->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_s_copy" class="el_po_s_copy">
<span<?= $Page->copy->viewAttributes() ?>>
<?= $Page->copy->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->quantity->Visible) { // quantity ?>
        <td data-name="quantity"<?= $Page->quantity->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_s_quantity" class="el_po_s_quantity">
<span<?= $Page->quantity->viewAttributes() ?>>
<?= $Page->quantity->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sqm->Visible) { // sqm ?>
        <td data-name="sqm"<?= $Page->sqm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_s_sqm" class="el_po_s_sqm">
<span<?= $Page->sqm->viewAttributes() ?>>
<?= $Page->sqm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->amount->Visible) { // amount ?>
        <td data-name="amount"<?= $Page->amount->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_s_amount" class="el_po_s_amount">
<span<?= $Page->amount->viewAttributes() ?>>
<?= $Page->amount->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->cbm->Visible) { // cbm ?>
        <td data-name="cbm"<?= $Page->cbm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_s_cbm" class="el_po_s_cbm">
<span<?= $Page->cbm->viewAttributes() ?>>
<?= $Page->cbm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->gst->Visible) { // gst ?>
        <td data-name="gst"<?= $Page->gst->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_s_gst" class="el_po_s_gst">
<span<?= $Page->gst->viewAttributes() ?>>
<?= $Page->gst->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->despatch_date->Visible) { // despatch_date ?>
        <td data-name="despatch_date"<?= $Page->despatch_date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_s_despatch_date" class="el_po_s_despatch_date">
<span<?= $Page->despatch_date->viewAttributes() ?>>
<?= $Page->despatch_date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->despatch_week->Visible) { // despatch_week ?>
        <td data-name="despatch_week"<?= $Page->despatch_week->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_s_despatch_week" class="el_po_s_despatch_week">
<span<?= $Page->despatch_week->viewAttributes() ?>>
<?= $Page->despatch_week->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->fob_date->Visible) { // fob_date ?>
        <td data-name="fob_date"<?= $Page->fob_date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_s_fob_date" class="el_po_s_fob_date">
<span<?= $Page->fob_date->viewAttributes() ?>>
<?= $Page->fob_date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->payment_terms->Visible) { // payment_terms ?>
        <td data-name="payment_terms"<?= $Page->payment_terms->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_s_payment_terms" class="el_po_s_payment_terms">
<span<?= $Page->payment_terms->viewAttributes() ?>>
<?php if (!EmptyString($Page->payment_terms->getViewValue()) && $Page->payment_terms->linkAttributes() != "") { ?>
<a<?= $Page->payment_terms->linkAttributes() ?>><?= $Page->payment_terms->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->payment_terms->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->transport_type->Visible) { // transport_type ?>
        <td data-name="transport_type"<?= $Page->transport_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_s_transport_type" class="el_po_s_transport_type">
<span<?= $Page->transport_type->viewAttributes() ?>>
<?php if (!EmptyString($Page->transport_type->getViewValue()) && $Page->transport_type->linkAttributes() != "") { ?>
<a<?= $Page->transport_type->linkAttributes() ?>><?= $Page->transport_type->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->transport_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->partner_shipping_id->Visible) { // partner_shipping_id ?>
        <td data-name="partner_shipping_id"<?= $Page->partner_shipping_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_s_partner_shipping_id" class="el_po_s_partner_shipping_id">
<span<?= $Page->partner_shipping_id->viewAttributes() ?>>
<?= $Page->partner_shipping_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_s_operator" class="el_po_s_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_s_datetime" class="el_po_s_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->a_operator->Visible) { // a_operator ?>
        <td data-name="a_operator"<?= $Page->a_operator->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_s_a_operator" class="el_po_s_a_operator">
<span<?= $Page->a_operator->viewAttributes() ?>>
<?= $Page->a_operator->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->a_datetime->Visible) { // a_datetime ?>
        <td data-name="a_datetime"<?= $Page->a_datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_s_a_datetime" class="el_po_s_a_datetime">
<span<?= $Page->a_datetime->viewAttributes() ?>>
<?= $Page->a_datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("po_s");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
