<?php

namespace PHPMaker2024\fibre;

// Page object
$PoSAuthSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { po_s_auth: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fpo_s_authsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpo_s_authsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["po", [ew.Validators.integer], fields.po.isInvalid],
            ["company_id", [], fields.company_id.isInvalid],
            ["partner_id", [], fields.partner_id.isInvalid],
            ["quantity", [ew.Validators.integer], fields.quantity.isInvalid],
            ["sqm", [ew.Validators.float], fields.sqm.isInvalid],
            ["cbm", [ew.Validators.float], fields.cbm.isInvalid],
            ["amount", [], fields.amount.isInvalid],
            ["a_operator", [], fields.a_operator.isInvalid],
            ["a_datetime", [ew.Validators.datetime(fields.a_datetime.clientFormatPattern)], fields.a_datetime.isInvalid],
            ["e_mail", [], fields.e_mail.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
            "partner_id": <?= $Page->partner_id->toClientList($Page) ?>,
            "a_operator": <?= $Page->a_operator->toClientList($Page) ?>,
            "e_mail": <?= $Page->e_mail->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fpo_s_authsearch" id="fpo_s_authsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="po_s_auth">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_auth_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_auth_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="po_s_auth" data-field="x_id" value="<?= $Page->id->EditValue ?>" data-page="1" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
    <div id="r_po" class="row"<?= $Page->po->rowAttributes() ?>>
        <label for="x_po" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_auth_po"><?= $Page->po->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_po" id="z_po" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_auth_po" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->po->getInputTextType() ?>" name="x_po" id="x_po" data-table="po_s_auth" data-field="x_po" value="<?= $Page->po->EditValue ?>" data-page="1" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
    <div id="r_company_id" class="row"<?= $Page->company_id->rowAttributes() ?>>
        <label for="x_company_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_auth_company_id"><?= $Page->company_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_company_id" id="z_company_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->company_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_auth_company_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_company_id"
        name="x_company_id"
        class="form-select ew-select<?= $Page->company_id->isInvalidClass() ?>"
        <?php if (!$Page->company_id->IsNativeSelect) { ?>
        data-select2-id="fpo_s_authsearch_x_company_id"
        <?php } ?>
        data-table="po_s_auth"
        data-field="x_company_id"
        data-page="1"
        data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>"
        <?= $Page->company_id->editAttributes() ?>>
        <?= $Page->company_id->selectOptionListHtml("x_company_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->company_id->getErrorMessage(false) ?></div>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
<?php if (!$Page->company_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_s_authsearch", function() {
    var options = { name: "x_company_id", selectId: "fpo_s_authsearch_x_company_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_s_authsearch.lists.company_id?.lookupOptions.length) {
        options.data = { id: "x_company_id", form: "fpo_s_authsearch" };
    } else {
        options.ajax = { id: "x_company_id", form: "fpo_s_authsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_s_auth.fields.company_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->partner_id->Visible) { // partner_id ?>
    <div id="r_partner_id" class="row"<?= $Page->partner_id->rowAttributes() ?>>
        <label for="x_partner_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_auth_partner_id"><?= $Page->partner_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_partner_id" id="z_partner_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->partner_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_auth_partner_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_partner_id"
        name="x_partner_id"
        class="form-select ew-select<?= $Page->partner_id->isInvalidClass() ?>"
        <?php if (!$Page->partner_id->IsNativeSelect) { ?>
        data-select2-id="fpo_s_authsearch_x_partner_id"
        <?php } ?>
        data-table="po_s_auth"
        data-field="x_partner_id"
        data-page="1"
        data-value-separator="<?= $Page->partner_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->partner_id->getPlaceHolder()) ?>"
        <?= $Page->partner_id->editAttributes() ?>>
        <?= $Page->partner_id->selectOptionListHtml("x_partner_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->partner_id->getErrorMessage(false) ?></div>
<?= $Page->partner_id->Lookup->getParamTag($Page, "p_x_partner_id") ?>
<?php if (!$Page->partner_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_s_authsearch", function() {
    var options = { name: "x_partner_id", selectId: "fpo_s_authsearch_x_partner_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_s_authsearch.lists.partner_id?.lookupOptions.length) {
        options.data = { id: "x_partner_id", form: "fpo_s_authsearch" };
    } else {
        options.ajax = { id: "x_partner_id", form: "fpo_s_authsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_s_auth.fields.partner_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity" class="row"<?= $Page->quantity->rowAttributes() ?>>
        <label for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_auth_quantity"><?= $Page->quantity->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_quantity" id="z_quantity" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->quantity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_auth_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->quantity->getInputTextType() ?>" name="x_quantity" id="x_quantity" data-table="po_s_auth" data-field="x_quantity" value="<?= $Page->quantity->EditValue ?>" data-page="1" size="30" placeholder="<?= HtmlEncode($Page->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity->formatPattern()) ?>"<?= $Page->quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->quantity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
    <div id="r_sqm" class="row"<?= $Page->sqm->rowAttributes() ?>>
        <label for="x_sqm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_auth_sqm"><?= $Page->sqm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_sqm" id="z_sqm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sqm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_auth_sqm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sqm->getInputTextType() ?>" name="x_sqm" id="x_sqm" data-table="po_s_auth" data-field="x_sqm" value="<?= $Page->sqm->EditValue ?>" data-page="1" size="30" placeholder="<?= HtmlEncode($Page->sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm->formatPattern()) ?>"<?= $Page->sqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sqm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->cbm->Visible) { // cbm ?>
    <div id="r_cbm" class="row"<?= $Page->cbm->rowAttributes() ?>>
        <label for="x_cbm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_auth_cbm"><?= $Page->cbm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_cbm" id="z_cbm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->cbm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_auth_cbm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->cbm->getInputTextType() ?>" name="x_cbm" id="x_cbm" data-table="po_s_auth" data-field="x_cbm" value="<?= $Page->cbm->EditValue ?>" data-page="1" size="30" placeholder="<?= HtmlEncode($Page->cbm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cbm->formatPattern()) ?>"<?= $Page->cbm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->cbm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
    <div id="r_amount" class="row"<?= $Page->amount->rowAttributes() ?>>
        <label for="x_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_auth_amount"><?= $Page->amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_amount" id="z_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_auth_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->amount->getInputTextType() ?>" name="x_amount" id="x_amount" data-table="po_s_auth" data-field="x_amount" value="<?= $Page->amount->EditValue ?>" data-page="1" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->a_operator->Visible) { // a_operator ?>
    <div id="r_a_operator" class="row"<?= $Page->a_operator->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_auth_a_operator"><?= $Page->a_operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_a_operator" id="z_a_operator" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->a_operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_auth_a_operator" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->a_operator->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_a_operator" class="ew-auto-suggest">
    <input type="<?= $Page->a_operator->getInputTextType() ?>" class="form-control" name="sv_x_a_operator" id="sv_x_a_operator" value="<?= RemoveHtml($Page->a_operator->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->a_operator->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->a_operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->a_operator->formatPattern()) ?>"<?= $Page->a_operator->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="po_s_auth" data-field="x_a_operator" data-input="sv_x_a_operator" data-page="1" data-value-separator="<?= $Page->a_operator->displayValueSeparatorAttribute() ?>" name="x_a_operator" id="x_a_operator" value="<?= HtmlEncode($Page->a_operator->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->a_operator->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fpo_s_authsearch", function() {
    fpo_s_authsearch.createAutoSuggest(Object.assign({"id":"x_a_operator","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->a_operator->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.po_s_auth.fields.a_operator.autoSuggestOptions));
});
</script>
<?= $Page->a_operator->Lookup->getParamTag($Page, "p_x_a_operator") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->a_datetime->Visible) { // a_datetime ?>
    <div id="r_a_datetime" class="row"<?= $Page->a_datetime->rowAttributes() ?>>
        <label for="x_a_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_auth_a_datetime"><?= $Page->a_datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_a_datetime" id="z_a_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->a_datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_auth_a_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->a_datetime->getInputTextType() ?>" name="x_a_datetime" id="x_a_datetime" data-table="po_s_auth" data-field="x_a_datetime" value="<?= $Page->a_datetime->EditValue ?>" data-page="1" placeholder="<?= HtmlEncode($Page->a_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->a_datetime->formatPattern()) ?>"<?= $Page->a_datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->a_datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->a_datetime->ReadOnly && !$Page->a_datetime->Disabled && !isset($Page->a_datetime->EditAttrs["readonly"]) && !isset($Page->a_datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpo_s_authsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpo_s_authsearch", "x_a_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->e_mail->Visible) { // e_mail ?>
    <div id="r_e_mail" class="row"<?= $Page->e_mail->rowAttributes() ?>>
        <label for="x_e_mail" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_s_auth_e_mail"><?= $Page->e_mail->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_e_mail" id="z_e_mail" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->e_mail->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_s_auth_e_mail" class="ew-search-field ew-search-field-single">
    <select
        id="x_e_mail"
        name="x_e_mail"
        class="form-select ew-select<?= $Page->e_mail->isInvalidClass() ?>"
        <?php if (!$Page->e_mail->IsNativeSelect) { ?>
        data-select2-id="fpo_s_authsearch_x_e_mail"
        <?php } ?>
        data-table="po_s_auth"
        data-field="x_e_mail"
        data-page="1"
        data-value-separator="<?= $Page->e_mail->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->e_mail->getPlaceHolder()) ?>"
        <?= $Page->e_mail->editAttributes() ?>>
        <?= $Page->e_mail->selectOptionListHtml("x_e_mail") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->e_mail->getErrorMessage(false) ?></div>
<?php if (!$Page->e_mail->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_s_authsearch", function() {
    var options = { name: "x_e_mail", selectId: "fpo_s_authsearch_x_e_mail" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_s_authsearch.lists.e_mail?.lookupOptions.length) {
        options.data = { id: "x_e_mail", form: "fpo_s_authsearch" };
    } else {
        options.ajax = { id: "x_e_mail", form: "fpo_s_authsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_s_auth.fields.e_mail.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fpo_s_authsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpo_s_authsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fpo_s_authsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("po_s_auth");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
