<?php

namespace PHPMaker2024\fibre;

// Page object
$PoPendingWbcSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { po_pending_wbc: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fpo_pending_wbcsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpo_pending_wbcsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["po", [ew.Validators.integer], fields.po.isInvalid],
            ["pod", [], fields.pod.isInvalid],
            ["jc_no", [ew.Validators.integer], fields.jc_no.isInvalid],
            ["product_code", [], fields.product_code.isInvalid],
            ["batch_no", [], fields.batch_no.isInvalid],
            ["cart_quantity", [ew.Validators.integer], fields.cart_quantity.isInvalid],
            ["pam_qty", [ew.Validators.float], fields.pam_qty.isInvalid],
            ["pending_qty", [ew.Validators.float], fields.pending_qty.isInvalid],
            ["despatch_week", [], fields.despatch_week.isInvalid],
            ["packing_type", [], fields.packing_type.isInvalid],
            ["process", [], fields.process.isInvalid],
            ["pam_id", [], fields.pam_id.isInvalid],
            ["issue_to", [], fields.issue_to.isInvalid],
            ["pp_qty", [ew.Validators.float], fields.pp_qty.isInvalid],
            ["company_id", [], fields.company_id.isInvalid],
            ["jc_quantity", [ew.Validators.float], fields.jc_quantity.isInvalid],
            ["buyer_id", [ew.Validators.integer], fields.buyer_id.isInvalid],
            ["level", [ew.Validators.integer], fields.level.isInvalid],
            ["balance", [ew.Validators.float], fields.balance.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "batch_no": <?= $Page->batch_no->toClientList($Page) ?>,
            "despatch_week": <?= $Page->despatch_week->toClientList($Page) ?>,
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
            "process": <?= $Page->process->toClientList($Page) ?>,
            "issue_to": <?= $Page->issue_to->toClientList($Page) ?>,
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
            "buyer_id": <?= $Page->buyer_id->toClientList($Page) ?>,
            "level": <?= $Page->level->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fpo_pending_wbcsearch" id="fpo_pending_wbcsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="po_pending_wbc">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_pending_wbc_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_pending_wbc_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="po_pending_wbc" data-field="x_id" value="<?= $Page->id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
    <div id="r_po" class="row"<?= $Page->po->rowAttributes() ?>>
        <label for="x_po" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_pending_wbc_po"><?= $Page->po->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_po" id="z_po" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_pending_wbc_po" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->po->getInputTextType() ?>" name="x_po" id="x_po" data-table="po_pending_wbc" data-field="x_po" value="<?= $Page->po->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pod->Visible) { // pod ?>
    <div id="r_pod" class="row"<?= $Page->pod->rowAttributes() ?>>
        <label for="x_pod" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_pending_wbc_pod"><?= $Page->pod->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_pod" id="z_pod" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pod->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_pending_wbc_pod" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pod->getInputTextType() ?>" name="x_pod" id="x_pod" data-table="po_pending_wbc" data-field="x_pod" value="<?= $Page->pod->EditValue ?>" size="30" maxlength="63" placeholder="<?= HtmlEncode($Page->pod->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pod->formatPattern()) ?>"<?= $Page->pod->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pod->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->jc_no->Visible) { // jc_no ?>
    <div id="r_jc_no" class="row"<?= $Page->jc_no->rowAttributes() ?>>
        <label for="x_jc_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_pending_wbc_jc_no"><?= $Page->jc_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_jc_no" id="z_jc_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->jc_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_pending_wbc_jc_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->jc_no->getInputTextType() ?>" name="x_jc_no" id="x_jc_no" data-table="po_pending_wbc" data-field="x_jc_no" value="<?= $Page->jc_no->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->jc_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->jc_no->formatPattern()) ?>"<?= $Page->jc_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->jc_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product_code->Visible) { // product_code ?>
    <div id="r_product_code" class="row"<?= $Page->product_code->rowAttributes() ?>>
        <label for="x_product_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_pending_wbc_product_code"><?= $Page->product_code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_product_code" id="z_product_code" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product_code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_pending_wbc_product_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->product_code->getInputTextType() ?>" name="x_product_code" id="x_product_code" data-table="po_pending_wbc" data-field="x_product_code" value="<?= $Page->product_code->EditValue ?>" size="30" maxlength="351" placeholder="<?= HtmlEncode($Page->product_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->product_code->formatPattern()) ?>"<?= $Page->product_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->product_code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
    <div id="r_batch_no" class="row"<?= $Page->batch_no->rowAttributes() ?>>
        <label for="x_batch_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_pending_wbc_batch_no"><?= $Page->batch_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_batch_no" id="z_batch_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->batch_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_pending_wbc_batch_no" class="ew-search-field ew-search-field-single">
    <select
        id="x_batch_no"
        name="x_batch_no"
        class="form-select ew-select<?= $Page->batch_no->isInvalidClass() ?>"
        <?php if (!$Page->batch_no->IsNativeSelect) { ?>
        data-select2-id="fpo_pending_wbcsearch_x_batch_no"
        <?php } ?>
        data-table="po_pending_wbc"
        data-field="x_batch_no"
        data-value-separator="<?= $Page->batch_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>"
        <?= $Page->batch_no->editAttributes() ?>>
        <?= $Page->batch_no->selectOptionListHtml("x_batch_no") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->batch_no->getErrorMessage(false) ?></div>
<?= $Page->batch_no->Lookup->getParamTag($Page, "p_x_batch_no") ?>
<?php if (!$Page->batch_no->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_pending_wbcsearch", function() {
    var options = { name: "x_batch_no", selectId: "fpo_pending_wbcsearch_x_batch_no" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_pending_wbcsearch.lists.batch_no?.lookupOptions.length) {
        options.data = { id: "x_batch_no", form: "fpo_pending_wbcsearch" };
    } else {
        options.ajax = { id: "x_batch_no", form: "fpo_pending_wbcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_pending_wbc.fields.batch_no.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->cart_quantity->Visible) { // cart_quantity ?>
    <div id="r_cart_quantity" class="row"<?= $Page->cart_quantity->rowAttributes() ?>>
        <label for="x_cart_quantity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_pending_wbc_cart_quantity"><?= $Page->cart_quantity->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_cart_quantity" id="z_cart_quantity" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->cart_quantity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_pending_wbc_cart_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->cart_quantity->getInputTextType() ?>" name="x_cart_quantity" id="x_cart_quantity" data-table="po_pending_wbc" data-field="x_cart_quantity" value="<?= $Page->cart_quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->cart_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cart_quantity->formatPattern()) ?>"<?= $Page->cart_quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->cart_quantity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pam_qty->Visible) { // pam_qty ?>
    <div id="r_pam_qty" class="row"<?= $Page->pam_qty->rowAttributes() ?>>
        <label for="x_pam_qty" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_pending_wbc_pam_qty"><?= $Page->pam_qty->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pam_qty" id="z_pam_qty" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pam_qty->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_pending_wbc_pam_qty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pam_qty->getInputTextType() ?>" name="x_pam_qty" id="x_pam_qty" data-table="po_pending_wbc" data-field="x_pam_qty" value="<?= $Page->pam_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pam_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pam_qty->formatPattern()) ?>"<?= $Page->pam_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pam_qty->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pending_qty->Visible) { // pending_qty ?>
    <div id="r_pending_qty" class="row"<?= $Page->pending_qty->rowAttributes() ?>>
        <label for="x_pending_qty" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_pending_wbc_pending_qty"><?= $Page->pending_qty->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pending_qty" id="z_pending_qty" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pending_qty->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_pending_wbc_pending_qty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pending_qty->getInputTextType() ?>" name="x_pending_qty" id="x_pending_qty" data-table="po_pending_wbc" data-field="x_pending_qty" value="<?= $Page->pending_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pending_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pending_qty->formatPattern()) ?>"<?= $Page->pending_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pending_qty->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->despatch_week->Visible) { // despatch_week ?>
    <div id="r_despatch_week" class="row"<?= $Page->despatch_week->rowAttributes() ?>>
        <label for="x_despatch_week" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_pending_wbc_despatch_week"><?= $Page->despatch_week->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_despatch_week" id="z_despatch_week" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->despatch_week->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_pending_wbc_despatch_week" class="ew-search-field ew-search-field-single">
    <select
        id="x_despatch_week"
        name="x_despatch_week"
        class="form-select ew-select<?= $Page->despatch_week->isInvalidClass() ?>"
        <?php if (!$Page->despatch_week->IsNativeSelect) { ?>
        data-select2-id="fpo_pending_wbcsearch_x_despatch_week"
        <?php } ?>
        data-table="po_pending_wbc"
        data-field="x_despatch_week"
        data-value-separator="<?= $Page->despatch_week->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->despatch_week->getPlaceHolder()) ?>"
        <?= $Page->despatch_week->editAttributes() ?>>
        <?= $Page->despatch_week->selectOptionListHtml("x_despatch_week") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->despatch_week->getErrorMessage(false) ?></div>
<?= $Page->despatch_week->Lookup->getParamTag($Page, "p_x_despatch_week") ?>
<?php if (!$Page->despatch_week->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_pending_wbcsearch", function() {
    var options = { name: "x_despatch_week", selectId: "fpo_pending_wbcsearch_x_despatch_week" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_pending_wbcsearch.lists.despatch_week?.lookupOptions.length) {
        options.data = { id: "x_despatch_week", form: "fpo_pending_wbcsearch" };
    } else {
        options.ajax = { id: "x_despatch_week", form: "fpo_pending_wbcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_pending_wbc.fields.despatch_week.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type" class="row"<?= $Page->packing_type->rowAttributes() ?>>
        <label for="x_packing_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_pending_wbc_packing_type"><?= $Page->packing_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packing_type" id="z_packing_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packing_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_pending_wbc_packing_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_packing_type"
        name="x_packing_type"
        class="form-select ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_type->IsNativeSelect) { ?>
        data-select2-id="fpo_pending_wbcsearch_x_packing_type"
        <?php } ?>
        data-table="po_pending_wbc"
        data-field="x_packing_type"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage(false) ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x_packing_type") ?>
<?php if (!$Page->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_pending_wbcsearch", function() {
    var options = { name: "x_packing_type", selectId: "fpo_pending_wbcsearch_x_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_pending_wbcsearch.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x_packing_type", form: "fpo_pending_wbcsearch" };
    } else {
        options.ajax = { id: "x_packing_type", form: "fpo_pending_wbcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_pending_wbc.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->process->Visible) { // process ?>
    <div id="r_process" class="row"<?= $Page->process->rowAttributes() ?>>
        <label for="x_process" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_pending_wbc_process"><?= $Page->process->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_process" id="z_process" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->process->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_pending_wbc_process" class="ew-search-field ew-search-field-single">
    <select
        id="x_process"
        name="x_process"
        class="form-select ew-select<?= $Page->process->isInvalidClass() ?>"
        <?php if (!$Page->process->IsNativeSelect) { ?>
        data-select2-id="fpo_pending_wbcsearch_x_process"
        <?php } ?>
        data-table="po_pending_wbc"
        data-field="x_process"
        data-value-separator="<?= $Page->process->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process->getPlaceHolder()) ?>"
        <?= $Page->process->editAttributes() ?>>
        <?= $Page->process->selectOptionListHtml("x_process") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->process->getErrorMessage(false) ?></div>
<?= $Page->process->Lookup->getParamTag($Page, "p_x_process") ?>
<?php if (!$Page->process->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_pending_wbcsearch", function() {
    var options = { name: "x_process", selectId: "fpo_pending_wbcsearch_x_process" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_pending_wbcsearch.lists.process?.lookupOptions.length) {
        options.data = { id: "x_process", form: "fpo_pending_wbcsearch" };
    } else {
        options.ajax = { id: "x_process", form: "fpo_pending_wbcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_pending_wbc.fields.process.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pam_id->Visible) { // pam_id ?>
    <div id="r_pam_id" class="row"<?= $Page->pam_id->rowAttributes() ?>>
        <label for="x_pam_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_pending_wbc_pam_id"><?= $Page->pam_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_pam_id" id="z_pam_id" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pam_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_pending_wbc_pam_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pam_id->getInputTextType() ?>" name="x_pam_id" id="x_pam_id" data-table="po_pending_wbc" data-field="x_pam_id" value="<?= $Page->pam_id->EditValue ?>" size="30" maxlength="500" placeholder="<?= HtmlEncode($Page->pam_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pam_id->formatPattern()) ?>"<?= $Page->pam_id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pam_id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->issue_to->Visible) { // issue_to ?>
    <div id="r_issue_to" class="row"<?= $Page->issue_to->rowAttributes() ?>>
        <label for="x_issue_to" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_pending_wbc_issue_to"><?= $Page->issue_to->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_issue_to" id="z_issue_to" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->issue_to->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_pending_wbc_issue_to" class="ew-search-field ew-search-field-single">
    <select
        id="x_issue_to"
        name="x_issue_to"
        class="form-select ew-select<?= $Page->issue_to->isInvalidClass() ?>"
        <?php if (!$Page->issue_to->IsNativeSelect) { ?>
        data-select2-id="fpo_pending_wbcsearch_x_issue_to"
        <?php } ?>
        data-table="po_pending_wbc"
        data-field="x_issue_to"
        data-value-separator="<?= $Page->issue_to->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->issue_to->getPlaceHolder()) ?>"
        <?= $Page->issue_to->editAttributes() ?>>
        <?= $Page->issue_to->selectOptionListHtml("x_issue_to") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->issue_to->getErrorMessage(false) ?></div>
<?= $Page->issue_to->Lookup->getParamTag($Page, "p_x_issue_to") ?>
<?php if (!$Page->issue_to->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_pending_wbcsearch", function() {
    var options = { name: "x_issue_to", selectId: "fpo_pending_wbcsearch_x_issue_to" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_pending_wbcsearch.lists.issue_to?.lookupOptions.length) {
        options.data = { id: "x_issue_to", form: "fpo_pending_wbcsearch" };
    } else {
        options.ajax = { id: "x_issue_to", form: "fpo_pending_wbcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_pending_wbc.fields.issue_to.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pp_qty->Visible) { // pp_qty ?>
    <div id="r_pp_qty" class="row"<?= $Page->pp_qty->rowAttributes() ?>>
        <label for="x_pp_qty" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_pending_wbc_pp_qty"><?= $Page->pp_qty->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pp_qty" id="z_pp_qty" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pp_qty->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_pending_wbc_pp_qty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pp_qty->getInputTextType() ?>" name="x_pp_qty" id="x_pp_qty" data-table="po_pending_wbc" data-field="x_pp_qty" value="<?= $Page->pp_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pp_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pp_qty->formatPattern()) ?>"<?= $Page->pp_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pp_qty->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
    <div id="r_company_id" class="row"<?= $Page->company_id->rowAttributes() ?>>
        <label for="x_company_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_pending_wbc_company_id"><?= $Page->company_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_company_id" id="z_company_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->company_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_pending_wbc_company_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_company_id"
        name="x_company_id"
        class="form-select ew-select<?= $Page->company_id->isInvalidClass() ?>"
        <?php if (!$Page->company_id->IsNativeSelect) { ?>
        data-select2-id="fpo_pending_wbcsearch_x_company_id"
        <?php } ?>
        data-table="po_pending_wbc"
        data-field="x_company_id"
        data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>"
        <?= $Page->company_id->editAttributes() ?>>
        <?= $Page->company_id->selectOptionListHtml("x_company_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->company_id->getErrorMessage(false) ?></div>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
<?php if (!$Page->company_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_pending_wbcsearch", function() {
    var options = { name: "x_company_id", selectId: "fpo_pending_wbcsearch_x_company_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_pending_wbcsearch.lists.company_id?.lookupOptions.length) {
        options.data = { id: "x_company_id", form: "fpo_pending_wbcsearch" };
    } else {
        options.ajax = { id: "x_company_id", form: "fpo_pending_wbcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_pending_wbc.fields.company_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->jc_quantity->Visible) { // jc_quantity ?>
    <div id="r_jc_quantity" class="row"<?= $Page->jc_quantity->rowAttributes() ?>>
        <label for="x_jc_quantity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_pending_wbc_jc_quantity"><?= $Page->jc_quantity->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_jc_quantity" id="z_jc_quantity" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->jc_quantity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_pending_wbc_jc_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->jc_quantity->getInputTextType() ?>" name="x_jc_quantity" id="x_jc_quantity" data-table="po_pending_wbc" data-field="x_jc_quantity" value="<?= $Page->jc_quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->jc_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->jc_quantity->formatPattern()) ?>"<?= $Page->jc_quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->jc_quantity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_id->Visible) { // buyer_id ?>
    <div id="r_buyer_id" class="row"<?= $Page->buyer_id->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_pending_wbc_buyer_id"><?= $Page->buyer_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyer_id" id="z_buyer_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_pending_wbc_buyer_id" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->buyer_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_buyer_id" class="ew-auto-suggest">
    <input type="<?= $Page->buyer_id->getInputTextType() ?>" class="form-control" name="sv_x_buyer_id" id="sv_x_buyer_id" value="<?= RemoveHtml($Page->buyer_id->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->buyer_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->buyer_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_id->formatPattern()) ?>"<?= $Page->buyer_id->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="po_pending_wbc" data-field="x_buyer_id" data-input="sv_x_buyer_id" data-value-separator="<?= $Page->buyer_id->displayValueSeparatorAttribute() ?>" name="x_buyer_id" id="x_buyer_id" value="<?= HtmlEncode($Page->buyer_id->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->buyer_id->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fpo_pending_wbcsearch", function() {
    fpo_pending_wbcsearch.createAutoSuggest(Object.assign({"id":"x_buyer_id","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->buyer_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.po_pending_wbc.fields.buyer_id.autoSuggestOptions));
});
</script>
<?= $Page->buyer_id->Lookup->getParamTag($Page, "p_x_buyer_id") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->level->Visible) { // level ?>
    <div id="r_level" class="row"<?= $Page->level->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_pending_wbc_level"><?= $Page->level->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_level" id="z_level" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->level->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_pending_wbc_level" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->level->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_level" class="ew-auto-suggest">
    <input type="<?= $Page->level->getInputTextType() ?>" class="form-control" name="sv_x_level" id="sv_x_level" value="<?= RemoveHtml($Page->level->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->level->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->level->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->level->formatPattern()) ?>"<?= $Page->level->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="po_pending_wbc" data-field="x_level" data-input="sv_x_level" data-value-separator="<?= $Page->level->displayValueSeparatorAttribute() ?>" name="x_level" id="x_level" value="<?= HtmlEncode($Page->level->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->level->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fpo_pending_wbcsearch", function() {
    fpo_pending_wbcsearch.createAutoSuggest(Object.assign({"id":"x_level","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->level->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.po_pending_wbc.fields.level.autoSuggestOptions));
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->balance->Visible) { // balance ?>
    <div id="r_balance" class="row"<?= $Page->balance->rowAttributes() ?>>
        <label for="x_balance" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_pending_wbc_balance"><?= $Page->balance->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_balance" id="z_balance" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->balance->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_pending_wbc_balance" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->balance->getInputTextType() ?>" name="x_balance" id="x_balance" data-table="po_pending_wbc" data-field="x_balance" value="<?= $Page->balance->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->balance->formatPattern()) ?>"<?= $Page->balance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->balance->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fpo_pending_wbcsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpo_pending_wbcsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fpo_pending_wbcsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("po_pending_wbc");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
