<?php

namespace PHPMaker2024\fibre;

// Page object
$PoPendingWbcSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { po_pending_wbc: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fpo_pending_wbcsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpo_pending_wbcsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["po", [ew.Validators.integer], fields.po.isInvalid],
            ["pod", [], fields.pod.isInvalid],
            ["jc_no", [ew.Validators.integer], fields.jc_no.isInvalid],
            ["product_code", [], fields.product_code.isInvalid],
            ["batch_no", [], fields.batch_no.isInvalid],
            ["cart_quantity", [ew.Validators.integer], fields.cart_quantity.isInvalid],
            ["pam_qty", [ew.Validators.float], fields.pam_qty.isInvalid],
            ["pending_qty", [ew.Validators.float], fields.pending_qty.isInvalid],
            ["despatch_week", [], fields.despatch_week.isInvalid],
            ["packing_type", [], fields.packing_type.isInvalid],
            ["process", [], fields.process.isInvalid],
            ["pam_id", [], fields.pam_id.isInvalid],
            ["issue_to", [], fields.issue_to.isInvalid],
            ["pp_qty", [ew.Validators.float], fields.pp_qty.isInvalid],
            ["company_id", [], fields.company_id.isInvalid],
            ["jc_quantity", [ew.Validators.float], fields.jc_quantity.isInvalid],
            ["buyer_id", [ew.Validators.integer], fields.buyer_id.isInvalid],
            ["level", [ew.Validators.integer], fields.level.isInvalid],
            ["balance", [ew.Validators.float], fields.balance.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setQueryBuilderLists({
            "batch_no": <?= $Page->batch_no->toClientList($Page) ?>,
            "despatch_week": <?= $Page->despatch_week->toClientList($Page) ?>,
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
            "process": <?= $Page->process->toClientList($Page) ?>,
            "issue_to": <?= $Page->issue_to->toClientList($Page) ?>,
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
            "buyer_id": <?= $Page->buyer_id->toClientList($Page) ?>,
            "level": <?= $Page->level->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fpo_pending_wbcsearch" id="fpo_pending_wbcsearch" class="<?= $Page->FormClassName ?>" action="<?= HtmlEncode(GetUrl("popendingwbclist")) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="po_pending_wbc">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<input type="hidden" name="rules" value="<?= HtmlEncode($Page->getSessionRules()) ?>">
<template id="tpx_po_pending_wbc_id" class="po_pending_wbcsearch"><span id="el_po_pending_wbc_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="po_pending_wbc" data-field="x_id" value="<?= $Page->id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_po_pending_wbc_po" class="po_pending_wbcsearch"><span id="el_po_pending_wbc_po" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->po->getInputTextType() ?>" name="x_po" id="x_po" data-table="po_pending_wbc" data-field="x_po" value="<?= $Page->po->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_po_pending_wbc_pod" class="po_pending_wbcsearch"><span id="el_po_pending_wbc_pod" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pod->getInputTextType() ?>" name="x_pod" id="x_pod" data-table="po_pending_wbc" data-field="x_pod" value="<?= $Page->pod->EditValue ?>" size="30" maxlength="63" placeholder="<?= HtmlEncode($Page->pod->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pod->formatPattern()) ?>"<?= $Page->pod->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pod->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_po_pending_wbc_jc_no" class="po_pending_wbcsearch"><span id="el_po_pending_wbc_jc_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->jc_no->getInputTextType() ?>" name="x_jc_no" id="x_jc_no" data-table="po_pending_wbc" data-field="x_jc_no" value="<?= $Page->jc_no->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->jc_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->jc_no->formatPattern()) ?>"<?= $Page->jc_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->jc_no->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_po_pending_wbc_product_code" class="po_pending_wbcsearch"><span id="el_po_pending_wbc_product_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->product_code->getInputTextType() ?>" name="x_product_code" id="x_product_code" data-table="po_pending_wbc" data-field="x_product_code" value="<?= $Page->product_code->EditValue ?>" size="30" maxlength="351" placeholder="<?= HtmlEncode($Page->product_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->product_code->formatPattern()) ?>"<?= $Page->product_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->product_code->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_po_pending_wbc_batch_no" class="po_pending_wbcsearch"><span id="el_po_pending_wbc_batch_no" class="ew-search-field ew-search-field-single">
    <select
        id="x_batch_no"
        name="x_batch_no"
        class="form-select ew-select<?= $Page->batch_no->isInvalidClass() ?>"
        <?php if (!$Page->batch_no->IsNativeSelect) { ?>
        data-select2-id="fpo_pending_wbcsearch_x_batch_no"
        <?php } ?>
        data-table="po_pending_wbc"
        data-field="x_batch_no"
        data-value-separator="<?= $Page->batch_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>"
        <?= $Page->batch_no->editAttributes() ?>>
        <?= $Page->batch_no->selectOptionListHtml("x_batch_no") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->batch_no->getErrorMessage(false) ?></div>
<?= $Page->batch_no->Lookup->getParamTag($Page, "p_x_batch_no") ?>
<?php if (!$Page->batch_no->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_pending_wbcsearch", function() {
    var options = { name: "x_batch_no", selectId: "fpo_pending_wbcsearch_x_batch_no" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_pending_wbcsearch.lists.batch_no?.lookupOptions.length) {
        options.data = { id: "x_batch_no", form: "fpo_pending_wbcsearch" };
    } else {
        options.ajax = { id: "x_batch_no", form: "fpo_pending_wbcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_pending_wbc.fields.batch_no.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_po_pending_wbc_cart_quantity" class="po_pending_wbcsearch"><span id="el_po_pending_wbc_cart_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->cart_quantity->getInputTextType() ?>" name="x_cart_quantity" id="x_cart_quantity" data-table="po_pending_wbc" data-field="x_cart_quantity" value="<?= $Page->cart_quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->cart_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cart_quantity->formatPattern()) ?>"<?= $Page->cart_quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->cart_quantity->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_po_pending_wbc_pam_qty" class="po_pending_wbcsearch"><span id="el_po_pending_wbc_pam_qty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pam_qty->getInputTextType() ?>" name="x_pam_qty" id="x_pam_qty" data-table="po_pending_wbc" data-field="x_pam_qty" value="<?= $Page->pam_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pam_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pam_qty->formatPattern()) ?>"<?= $Page->pam_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pam_qty->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_po_pending_wbc_pending_qty" class="po_pending_wbcsearch"><span id="el_po_pending_wbc_pending_qty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pending_qty->getInputTextType() ?>" name="x_pending_qty" id="x_pending_qty" data-table="po_pending_wbc" data-field="x_pending_qty" value="<?= $Page->pending_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pending_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pending_qty->formatPattern()) ?>"<?= $Page->pending_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pending_qty->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_po_pending_wbc_despatch_week" class="po_pending_wbcsearch"><span id="el_po_pending_wbc_despatch_week" class="ew-search-field ew-search-field-single">
    <select
        id="x_despatch_week"
        name="x_despatch_week"
        class="form-select ew-select<?= $Page->despatch_week->isInvalidClass() ?>"
        <?php if (!$Page->despatch_week->IsNativeSelect) { ?>
        data-select2-id="fpo_pending_wbcsearch_x_despatch_week"
        <?php } ?>
        data-table="po_pending_wbc"
        data-field="x_despatch_week"
        data-value-separator="<?= $Page->despatch_week->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->despatch_week->getPlaceHolder()) ?>"
        <?= $Page->despatch_week->editAttributes() ?>>
        <?= $Page->despatch_week->selectOptionListHtml("x_despatch_week") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->despatch_week->getErrorMessage(false) ?></div>
<?= $Page->despatch_week->Lookup->getParamTag($Page, "p_x_despatch_week") ?>
<?php if (!$Page->despatch_week->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_pending_wbcsearch", function() {
    var options = { name: "x_despatch_week", selectId: "fpo_pending_wbcsearch_x_despatch_week" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_pending_wbcsearch.lists.despatch_week?.lookupOptions.length) {
        options.data = { id: "x_despatch_week", form: "fpo_pending_wbcsearch" };
    } else {
        options.ajax = { id: "x_despatch_week", form: "fpo_pending_wbcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_pending_wbc.fields.despatch_week.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_po_pending_wbc_packing_type" class="po_pending_wbcsearch"><span id="el_po_pending_wbc_packing_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_packing_type"
        name="x_packing_type"
        class="form-select ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_type->IsNativeSelect) { ?>
        data-select2-id="fpo_pending_wbcsearch_x_packing_type"
        <?php } ?>
        data-table="po_pending_wbc"
        data-field="x_packing_type"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage(false) ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x_packing_type") ?>
<?php if (!$Page->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_pending_wbcsearch", function() {
    var options = { name: "x_packing_type", selectId: "fpo_pending_wbcsearch_x_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_pending_wbcsearch.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x_packing_type", form: "fpo_pending_wbcsearch" };
    } else {
        options.ajax = { id: "x_packing_type", form: "fpo_pending_wbcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_pending_wbc.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_po_pending_wbc_process" class="po_pending_wbcsearch"><span id="el_po_pending_wbc_process" class="ew-search-field ew-search-field-single">
    <select
        id="x_process"
        name="x_process"
        class="form-select ew-select<?= $Page->process->isInvalidClass() ?>"
        <?php if (!$Page->process->IsNativeSelect) { ?>
        data-select2-id="fpo_pending_wbcsearch_x_process"
        <?php } ?>
        data-table="po_pending_wbc"
        data-field="x_process"
        data-value-separator="<?= $Page->process->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process->getPlaceHolder()) ?>"
        <?= $Page->process->editAttributes() ?>>
        <?= $Page->process->selectOptionListHtml("x_process") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->process->getErrorMessage(false) ?></div>
<?= $Page->process->Lookup->getParamTag($Page, "p_x_process") ?>
<?php if (!$Page->process->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_pending_wbcsearch", function() {
    var options = { name: "x_process", selectId: "fpo_pending_wbcsearch_x_process" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_pending_wbcsearch.lists.process?.lookupOptions.length) {
        options.data = { id: "x_process", form: "fpo_pending_wbcsearch" };
    } else {
        options.ajax = { id: "x_process", form: "fpo_pending_wbcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_pending_wbc.fields.process.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_po_pending_wbc_pam_id" class="po_pending_wbcsearch"><span id="el_po_pending_wbc_pam_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pam_id->getInputTextType() ?>" name="x_pam_id" id="x_pam_id" data-table="po_pending_wbc" data-field="x_pam_id" value="<?= $Page->pam_id->EditValue ?>" size="30" maxlength="500" placeholder="<?= HtmlEncode($Page->pam_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pam_id->formatPattern()) ?>"<?= $Page->pam_id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pam_id->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_po_pending_wbc_issue_to" class="po_pending_wbcsearch"><span id="el_po_pending_wbc_issue_to" class="ew-search-field ew-search-field-single">
    <select
        id="x_issue_to"
        name="x_issue_to"
        class="form-select ew-select<?= $Page->issue_to->isInvalidClass() ?>"
        <?php if (!$Page->issue_to->IsNativeSelect) { ?>
        data-select2-id="fpo_pending_wbcsearch_x_issue_to"
        <?php } ?>
        data-table="po_pending_wbc"
        data-field="x_issue_to"
        data-value-separator="<?= $Page->issue_to->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->issue_to->getPlaceHolder()) ?>"
        <?= $Page->issue_to->editAttributes() ?>>
        <?= $Page->issue_to->selectOptionListHtml("x_issue_to") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->issue_to->getErrorMessage(false) ?></div>
<?= $Page->issue_to->Lookup->getParamTag($Page, "p_x_issue_to") ?>
<?php if (!$Page->issue_to->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_pending_wbcsearch", function() {
    var options = { name: "x_issue_to", selectId: "fpo_pending_wbcsearch_x_issue_to" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_pending_wbcsearch.lists.issue_to?.lookupOptions.length) {
        options.data = { id: "x_issue_to", form: "fpo_pending_wbcsearch" };
    } else {
        options.ajax = { id: "x_issue_to", form: "fpo_pending_wbcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_pending_wbc.fields.issue_to.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_po_pending_wbc_pp_qty" class="po_pending_wbcsearch"><span id="el_po_pending_wbc_pp_qty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pp_qty->getInputTextType() ?>" name="x_pp_qty" id="x_pp_qty" data-table="po_pending_wbc" data-field="x_pp_qty" value="<?= $Page->pp_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pp_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pp_qty->formatPattern()) ?>"<?= $Page->pp_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pp_qty->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_po_pending_wbc_company_id" class="po_pending_wbcsearch"><span id="el_po_pending_wbc_company_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_company_id"
        name="x_company_id"
        class="form-select ew-select<?= $Page->company_id->isInvalidClass() ?>"
        <?php if (!$Page->company_id->IsNativeSelect) { ?>
        data-select2-id="fpo_pending_wbcsearch_x_company_id"
        <?php } ?>
        data-table="po_pending_wbc"
        data-field="x_company_id"
        data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>"
        <?= $Page->company_id->editAttributes() ?>>
        <?= $Page->company_id->selectOptionListHtml("x_company_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->company_id->getErrorMessage(false) ?></div>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
<?php if (!$Page->company_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_pending_wbcsearch", function() {
    var options = { name: "x_company_id", selectId: "fpo_pending_wbcsearch_x_company_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_pending_wbcsearch.lists.company_id?.lookupOptions.length) {
        options.data = { id: "x_company_id", form: "fpo_pending_wbcsearch" };
    } else {
        options.ajax = { id: "x_company_id", form: "fpo_pending_wbcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_pending_wbc.fields.company_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_po_pending_wbc_jc_quantity" class="po_pending_wbcsearch"><span id="el_po_pending_wbc_jc_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->jc_quantity->getInputTextType() ?>" name="x_jc_quantity" id="x_jc_quantity" data-table="po_pending_wbc" data-field="x_jc_quantity" value="<?= $Page->jc_quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->jc_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->jc_quantity->formatPattern()) ?>"<?= $Page->jc_quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->jc_quantity->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_po_pending_wbc_buyer_id" class="po_pending_wbcsearch"><span id="el_po_pending_wbc_buyer_id" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->buyer_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_buyer_id" class="ew-auto-suggest">
    <input type="<?= $Page->buyer_id->getInputTextType() ?>" class="form-control" name="sv_x_buyer_id" id="sv_x_buyer_id" value="<?= RemoveHtml($Page->buyer_id->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->buyer_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->buyer_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_id->formatPattern()) ?>"<?= $Page->buyer_id->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="po_pending_wbc" data-field="x_buyer_id" data-input="sv_x_buyer_id" data-value-separator="<?= $Page->buyer_id->displayValueSeparatorAttribute() ?>" name="x_buyer_id" id="x_buyer_id" value="<?= HtmlEncode($Page->buyer_id->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->buyer_id->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fpo_pending_wbcsearch", function() {
    fpo_pending_wbcsearch.createAutoSuggest(Object.assign({"id":"x_buyer_id","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->buyer_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.po_pending_wbc.fields.buyer_id.autoSuggestOptions));
});
</script>
<?= $Page->buyer_id->Lookup->getParamTag($Page, "p_x_buyer_id") ?>
</span></template>
<template id="tpx_po_pending_wbc_level" class="po_pending_wbcsearch"><span id="el_po_pending_wbc_level" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->level->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_level" class="ew-auto-suggest">
    <input type="<?= $Page->level->getInputTextType() ?>" class="form-control" name="sv_x_level" id="sv_x_level" value="<?= RemoveHtml($Page->level->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->level->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->level->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->level->formatPattern()) ?>"<?= $Page->level->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="po_pending_wbc" data-field="x_level" data-input="sv_x_level" data-value-separator="<?= $Page->level->displayValueSeparatorAttribute() ?>" name="x_level" id="x_level" value="<?= HtmlEncode($Page->level->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->level->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fpo_pending_wbcsearch", function() {
    fpo_pending_wbcsearch.createAutoSuggest(Object.assign({"id":"x_level","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->level->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.po_pending_wbc.fields.level.autoSuggestOptions));
});
</script>
</span></template>
<template id="tpx_po_pending_wbc_balance" class="po_pending_wbcsearch"><span id="el_po_pending_wbc_balance" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->balance->getInputTextType() ?>" name="x_balance" id="x_balance" data-table="po_pending_wbc" data-field="x_balance" value="<?= $Page->balance->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->balance->formatPattern()) ?>"<?= $Page->balance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->balance->getErrorMessage(false) ?></div>
</span></template>
<div id="po_pending_wbc_query_builder" class="query-builder mb-3"></div>
<div class="btn-group mb-3 query-btn-group"></div>
<button type="button" id="btn-view-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("View", true)) ?>"><i class="fa-solid fa-eye ew-icon"></i></button>
<button type="button" id="btn-clear-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("Clear", true)) ?>"><i class="fa-solid fa-xmark ew-icon"></i></button>
<script>
// Filter builder
loadjs.ready(["wrapper", "head"], () => {
    let filters = [
            {
                id: "id",
                type: "integer",
                label: currentTable.fields.id.caption,
                operators: currentTable.fields.id.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpo_pending_wbcsearch.fields.id.validators),
                data: {
                    format: currentTable.fields.id.clientFormatPattern
                }
            },
            {
                id: "po",
                type: "integer",
                label: currentTable.fields.po.caption,
                operators: currentTable.fields.po.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpo_pending_wbcsearch.fields.po.validators),
                data: {
                    format: currentTable.fields.po.clientFormatPattern
                }
            },
            {
                id: "pod",
                type: "string",
                label: currentTable.fields.pod.caption,
                operators: currentTable.fields.pod.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpo_pending_wbcsearch.fields.pod.validators),
                data: {
                    format: currentTable.fields.pod.clientFormatPattern
                }
            },
            {
                id: "jc_no",
                type: "string",
                label: currentTable.fields.jc_no.caption,
                operators: currentTable.fields.jc_no.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpo_pending_wbcsearch.fields.jc_no.validators),
                data: {
                    format: currentTable.fields.jc_no.clientFormatPattern
                }
            },
            {
                id: "product_code",
                type: "string",
                label: currentTable.fields.product_code.caption,
                operators: currentTable.fields.product_code.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpo_pending_wbcsearch.fields.product_code.validators),
                data: {
                    format: currentTable.fields.product_code.clientFormatPattern
                }
            },
            {
                id: "batch_no",
                type: "integer",
                label: currentTable.fields.batch_no.caption,
                operators: currentTable.fields.batch_no.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fpo_pending_wbcsearch.fields.batch_no.validators),
                data: {
                    format: currentTable.fields.batch_no.clientFormatPattern
                }
            },
            {
                id: "cart_quantity",
                type: "double",
                label: currentTable.fields.cart_quantity.caption,
                operators: currentTable.fields.cart_quantity.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpo_pending_wbcsearch.fields.cart_quantity.validators),
                data: {
                    format: currentTable.fields.cart_quantity.clientFormatPattern
                }
            },
            {
                id: "pam_qty",
                type: "double",
                label: currentTable.fields.pam_qty.caption,
                operators: currentTable.fields.pam_qty.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpo_pending_wbcsearch.fields.pam_qty.validators),
                data: {
                    format: currentTable.fields.pam_qty.clientFormatPattern
                }
            },
            {
                id: "pending_qty",
                type: "double",
                label: currentTable.fields.pending_qty.caption,
                operators: currentTable.fields.pending_qty.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpo_pending_wbcsearch.fields.pending_qty.validators),
                data: {
                    format: currentTable.fields.pending_qty.clientFormatPattern
                }
            },
            {
                id: "despatch_week",
                type: "integer",
                label: currentTable.fields.despatch_week.caption,
                operators: currentTable.fields.despatch_week.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fpo_pending_wbcsearch.fields.despatch_week.validators),
                data: {
                    format: currentTable.fields.despatch_week.clientFormatPattern
                }
            },
            {
                id: "packing_type",
                type: "integer",
                label: currentTable.fields.packing_type.caption,
                operators: currentTable.fields.packing_type.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fpo_pending_wbcsearch.fields.packing_type.validators),
                data: {
                    format: currentTable.fields.packing_type.clientFormatPattern
                }
            },
            {
                id: "process",
                type: "string",
                label: currentTable.fields.process.caption,
                operators: currentTable.fields.process.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fpo_pending_wbcsearch.fields.process.validators),
                data: {
                    format: currentTable.fields.process.clientFormatPattern
                }
            },
            {
                id: "pam_id",
                type: "string",
                label: currentTable.fields.pam_id.caption,
                operators: currentTable.fields.pam_id.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpo_pending_wbcsearch.fields.pam_id.validators),
                data: {
                    format: currentTable.fields.pam_id.clientFormatPattern
                }
            },
            {
                id: "issue_to",
                type: "integer",
                label: currentTable.fields.issue_to.caption,
                operators: currentTable.fields.issue_to.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fpo_pending_wbcsearch.fields.issue_to.validators),
                data: {
                    format: currentTable.fields.issue_to.clientFormatPattern
                }
            },
            {
                id: "pp_qty",
                type: "double",
                label: currentTable.fields.pp_qty.caption,
                operators: currentTable.fields.pp_qty.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpo_pending_wbcsearch.fields.pp_qty.validators),
                data: {
                    format: currentTable.fields.pp_qty.clientFormatPattern
                }
            },
            {
                id: "company_id",
                type: "integer",
                label: currentTable.fields.company_id.caption,
                operators: currentTable.fields.company_id.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fpo_pending_wbcsearch.fields.company_id.validators),
                data: {
                    format: currentTable.fields.company_id.clientFormatPattern
                }
            },
            {
                id: "jc_quantity",
                type: "double",
                label: currentTable.fields.jc_quantity.caption,
                operators: currentTable.fields.jc_quantity.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpo_pending_wbcsearch.fields.jc_quantity.validators),
                data: {
                    format: currentTable.fields.jc_quantity.clientFormatPattern
                }
            },
            {
                id: "buyer_id",
                type: "integer",
                label: currentTable.fields.buyer_id.caption,
                operators: currentTable.fields.buyer_id.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fpo_pending_wbcsearch.fields.buyer_id.validators),
                data: {
                    format: currentTable.fields.buyer_id.clientFormatPattern
                }
            },
            {
                id: "level",
                type: "integer",
                label: currentTable.fields.level.caption,
                operators: currentTable.fields.level.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fpo_pending_wbcsearch.fields.level.validators),
                data: {
                    format: currentTable.fields.level.clientFormatPattern
                }
            },
            {
                id: "balance",
                type: "double",
                label: currentTable.fields.balance.caption,
                operators: currentTable.fields.balance.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpo_pending_wbcsearch.fields.balance.validators),
                data: {
                    format: currentTable.fields.balance.clientFormatPattern
                }
            },
        ],
        $ = jQuery,
        $qb = $("#po_pending_wbc_query_builder"),
        args = {},
        rules = ew.parseJson($("#fpo_pending_wbcsearch input[name=rules]").val()),
        queryBuilderOptions = Object.assign({}, ew.queryBuilderOptions),
        allowViewRules = queryBuilderOptions.allowViewRules,
        allowClearRules = queryBuilderOptions.allowClearRules,
        hasRules = group => Array.isArray(group?.rules) && group.rules.length > 0,
        getRules = () => $qb.queryBuilder("getRules", { skip_empty: true }),
        getSql = () => $qb.queryBuilder("getSQL", false, false, rules)?.sql;
    delete queryBuilderOptions.allowViewRules;
    delete queryBuilderOptions.allowClearRules;
    args.options = ew.deepAssign({
        plugins: Object.assign({}, ew.queryBuilderPlugins),
        lang: ew.language.phrase("querybuilderjs"),
        select_placeholder: ew.language.phrase("PleaseSelect"),
        inputs_separator: `<div class="d-inline-flex ms-2 me-2">${ew.language.phrase("AND")}</div>`, // For "between"
        filters,
        rules
    }, queryBuilderOptions);
    $qb.trigger("querybuilder", [args]);
    $qb.queryBuilder(args.options).on("rulesChanged.queryBuilder", () => {
        let rules = getRules();
        !ew.DEBUG || console.log(rules, getSql());
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").toggleClass("disabled", !rules);
    }).on("afterCreateRuleInput.queryBuilder", function(e, rule) {
        let select = rule.$el.find(".rule-value-container").find("selection-list, select")[0];
        if (select) { // Selection list
            let id = select.dataset.field.replace("^x_", ""),
                form = ew.forms.get(select);
            form.updateList(select, undefined, undefined, true); // Update immediately
        }
    });
    $("#fpo_pending_wbcsearch").on("beforesubmit", function () {
        this.rules.value = JSON.stringify(getRules());
    });
    $("#btn-reset").toggleClass("d-none", false).on("click", () => {
        hasRules(rules) ? $qb.queryBuilder("setRules", rules) : $qb.queryBuilder("reset");
        return false;
    });
    $("#btn-action").toggleClass("d-none", false);
    if (allowClearRules) {
        $("#btn-clear-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => $qb.queryBuilder("reset"));
    }
    if (allowViewRules) {
        $("#btn-view-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => {
            let rules = getRules();
            if (hasRules(rules)) {
                let sql = getSql();
                ew.alert(sql ? '<pre class="text-start fs-6">' + sql + '</pre>' : '', "dark");
                !ew.DEBUG || console.log(rules, sql);
            } else {
                ew.alert(ew.language.phrase("EmptyLabel"));
            }
        });
    }
    $(".query-btn-group").toggleClass(".mb-3", $(".query-btn-group").find(".btn:not(.d-none)").length);
    if (hasRules(rules)) { // Enable buttons if rules exist initially
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").removeClass("disabled");
    }
});
</script>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn d-none disabled" name="btn-action" id="btn-action" type="submit" form="fpo_pending_wbcsearch" formaction="<?= HtmlEncode(GetUrl("popendingwbclist")) ?>" data-ajax="<?= $Page->UseAjaxActions ? "true" : "false" ?>"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpo_pending_wbcsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn d-none disabled" name="btn-reset" id="btn-reset" type="button" form="fpo_pending_wbcsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("po_pending_wbc");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
