<?php

namespace PHPMaker2024\fibre;

// Page object
$PoPendingWbcList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { po_pending_wbc: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fpo_pending_wbcsrch" id="fpo_pending_wbcsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fpo_pending_wbcsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { po_pending_wbc: currentTable } });
var currentForm;
var fpo_pending_wbcsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpo_pending_wbcsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["pod", [], fields.pod.isInvalid],
            ["product_code", [], fields.product_code.isInvalid],
            ["cart_quantity", [ew.Validators.integer], fields.cart_quantity.isInvalid],
            ["pending_qty", [ew.Validators.float], fields.pending_qty.isInvalid],
            ["despatch_week", [], fields.despatch_week.isInvalid],
            ["buyer_id", [ew.Validators.integer], fields.buyer_id.isInvalid],
            ["balance", [ew.Validators.float], fields.balance.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "despatch_week": <?= $Page->despatch_week->toClientList($Page) ?>,
            "buyer_id": <?= $Page->buyer_id->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->pod->Visible) { // pod ?>
<?php
if (!$Page->pod->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_pod" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->pod->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_pod" class="ew-search-caption ew-label"><?= $Page->pod->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_pod" id="z_pod" value="LIKE">
</div>
        </div>
        <div id="el_po_pending_wbc_pod" class="ew-search-field">
<input type="<?= $Page->pod->getInputTextType() ?>" name="x_pod" id="x_pod" data-table="po_pending_wbc" data-field="x_pod" value="<?= $Page->pod->EditValue ?>" size="30" maxlength="63" placeholder="<?= HtmlEncode($Page->pod->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pod->formatPattern()) ?>"<?= $Page->pod->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pod->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->product_code->Visible) { // product_code ?>
<?php
if (!$Page->product_code->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_product_code" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->product_code->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_product_code" class="ew-search-caption ew-label"><?= $Page->product_code->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_product_code" id="z_product_code" value="LIKE">
</div>
        </div>
        <div id="el_po_pending_wbc_product_code" class="ew-search-field">
<input type="<?= $Page->product_code->getInputTextType() ?>" name="x_product_code" id="x_product_code" data-table="po_pending_wbc" data-field="x_product_code" value="<?= $Page->product_code->EditValue ?>" size="30" maxlength="351" placeholder="<?= HtmlEncode($Page->product_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->product_code->formatPattern()) ?>"<?= $Page->product_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->product_code->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->cart_quantity->Visible) { // cart_quantity ?>
<?php
if (!$Page->cart_quantity->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_cart_quantity" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->cart_quantity->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_cart_quantity" class="ew-search-caption ew-label"><?= $Page->cart_quantity->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_cart_quantity" id="z_cart_quantity" value="=">
</div>
        </div>
        <div id="el_po_pending_wbc_cart_quantity" class="ew-search-field">
<input type="<?= $Page->cart_quantity->getInputTextType() ?>" name="x_cart_quantity" id="x_cart_quantity" data-table="po_pending_wbc" data-field="x_cart_quantity" value="<?= $Page->cart_quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->cart_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cart_quantity->formatPattern()) ?>"<?= $Page->cart_quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->cart_quantity->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->pending_qty->Visible) { // pending_qty ?>
<?php
if (!$Page->pending_qty->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_pending_qty" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->pending_qty->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_pending_qty" class="ew-search-caption ew-label"><?= $Page->pending_qty->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pending_qty" id="z_pending_qty" value="=">
</div>
        </div>
        <div id="el_po_pending_wbc_pending_qty" class="ew-search-field">
<input type="<?= $Page->pending_qty->getInputTextType() ?>" name="x_pending_qty" id="x_pending_qty" data-table="po_pending_wbc" data-field="x_pending_qty" value="<?= $Page->pending_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pending_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pending_qty->formatPattern()) ?>"<?= $Page->pending_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pending_qty->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->despatch_week->Visible) { // despatch_week ?>
<?php
if (!$Page->despatch_week->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_despatch_week" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->despatch_week->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_despatch_week" class="ew-search-caption ew-label"><?= $Page->despatch_week->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_despatch_week" id="z_despatch_week" value="=">
</div>
        </div>
        <div id="el_po_pending_wbc_despatch_week" class="ew-search-field">
    <select
        id="x_despatch_week"
        name="x_despatch_week"
        class="form-select ew-select<?= $Page->despatch_week->isInvalidClass() ?>"
        <?php if (!$Page->despatch_week->IsNativeSelect) { ?>
        data-select2-id="fpo_pending_wbcsrch_x_despatch_week"
        <?php } ?>
        data-table="po_pending_wbc"
        data-field="x_despatch_week"
        data-value-separator="<?= $Page->despatch_week->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->despatch_week->getPlaceHolder()) ?>"
        <?= $Page->despatch_week->editAttributes() ?>>
        <?= $Page->despatch_week->selectOptionListHtml("x_despatch_week") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->despatch_week->getErrorMessage(false) ?></div>
<?= $Page->despatch_week->Lookup->getParamTag($Page, "p_x_despatch_week") ?>
<?php if (!$Page->despatch_week->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_pending_wbcsrch", function() {
    var options = { name: "x_despatch_week", selectId: "fpo_pending_wbcsrch_x_despatch_week" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_pending_wbcsrch.lists.despatch_week?.lookupOptions.length) {
        options.data = { id: "x_despatch_week", form: "fpo_pending_wbcsrch" };
    } else {
        options.ajax = { id: "x_despatch_week", form: "fpo_pending_wbcsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_pending_wbc.fields.despatch_week.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->buyer_id->Visible) { // buyer_id ?>
<?php
if (!$Page->buyer_id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_buyer_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->buyer_id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->buyer_id->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyer_id" id="z_buyer_id" value="=">
</div>
        </div>
        <div id="el_po_pending_wbc_buyer_id" class="ew-search-field">
<?php
if (IsRTL()) {
    $Page->buyer_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_buyer_id" class="ew-auto-suggest">
    <input type="<?= $Page->buyer_id->getInputTextType() ?>" class="form-control" name="sv_x_buyer_id" id="sv_x_buyer_id" value="<?= RemoveHtml($Page->buyer_id->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->buyer_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->buyer_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_id->formatPattern()) ?>"<?= $Page->buyer_id->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="po_pending_wbc" data-field="x_buyer_id" data-input="sv_x_buyer_id" data-value-separator="<?= $Page->buyer_id->displayValueSeparatorAttribute() ?>" name="x_buyer_id" id="x_buyer_id" value="<?= HtmlEncode($Page->buyer_id->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->buyer_id->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fpo_pending_wbcsrch", function() {
    fpo_pending_wbcsrch.createAutoSuggest(Object.assign({"id":"x_buyer_id","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->buyer_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.po_pending_wbc.fields.buyer_id.autoSuggestOptions));
});
</script>
<?= $Page->buyer_id->Lookup->getParamTag($Page, "p_x_buyer_id") ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->balance->Visible) { // balance ?>
<?php
if (!$Page->balance->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_balance" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->balance->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_balance" class="ew-search-caption ew-label"><?= $Page->balance->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_balance" id="z_balance" value="=">
</div>
        </div>
        <div id="el_po_pending_wbc_balance" class="ew-search-field">
<input type="<?= $Page->balance->getInputTextType() ?>" name="x_balance" id="x_balance" data-table="po_pending_wbc" data-field="x_balance" value="<?= $Page->balance->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->balance->formatPattern()) ?>"<?= $Page->balance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->balance->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fpo_pending_wbcsrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fpo_pending_wbcsrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fpo_pending_wbcsrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fpo_pending_wbcsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fpo_pending_wbcsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fpo_pending_wbcsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fpo_pending_wbcsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="po_pending_wbc">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_po_pending_wbc" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_po_pending_wbclist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_po_pending_wbc_id" class="po_pending_wbc_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->pod->Visible) { // pod ?>
        <th data-name="pod" class="<?= $Page->pod->headerCellClass() ?>"><div id="elh_po_pending_wbc_pod" class="po_pending_wbc_pod"><?= $Page->renderFieldHeader($Page->pod) ?></div></th>
<?php } ?>
<?php if ($Page->jc_no->Visible) { // jc_no ?>
        <th data-name="jc_no" class="<?= $Page->jc_no->headerCellClass() ?>"><div id="elh_po_pending_wbc_jc_no" class="po_pending_wbc_jc_no"><?= $Page->renderFieldHeader($Page->jc_no) ?></div></th>
<?php } ?>
<?php if ($Page->product_code->Visible) { // product_code ?>
        <th data-name="product_code" class="<?= $Page->product_code->headerCellClass() ?>"><div id="elh_po_pending_wbc_product_code" class="po_pending_wbc_product_code"><?= $Page->renderFieldHeader($Page->product_code) ?></div></th>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
        <th data-name="batch_no" class="<?= $Page->batch_no->headerCellClass() ?>"><div id="elh_po_pending_wbc_batch_no" class="po_pending_wbc_batch_no"><?= $Page->renderFieldHeader($Page->batch_no) ?></div></th>
<?php } ?>
<?php if ($Page->cart_quantity->Visible) { // cart_quantity ?>
        <th data-name="cart_quantity" class="<?= $Page->cart_quantity->headerCellClass() ?>"><div id="elh_po_pending_wbc_cart_quantity" class="po_pending_wbc_cart_quantity"><?= $Page->renderFieldHeader($Page->cart_quantity) ?></div></th>
<?php } ?>
<?php if ($Page->pam_qty->Visible) { // pam_qty ?>
        <th data-name="pam_qty" class="<?= $Page->pam_qty->headerCellClass() ?>"><div id="elh_po_pending_wbc_pam_qty" class="po_pending_wbc_pam_qty"><?= $Page->renderFieldHeader($Page->pam_qty) ?></div></th>
<?php } ?>
<?php if ($Page->pending_qty->Visible) { // pending_qty ?>
        <th data-name="pending_qty" class="<?= $Page->pending_qty->headerCellClass() ?>"><div id="elh_po_pending_wbc_pending_qty" class="po_pending_wbc_pending_qty"><?= $Page->renderFieldHeader($Page->pending_qty) ?></div></th>
<?php } ?>
<?php if ($Page->despatch_week->Visible) { // despatch_week ?>
        <th data-name="despatch_week" class="<?= $Page->despatch_week->headerCellClass() ?>"><div id="elh_po_pending_wbc_despatch_week" class="po_pending_wbc_despatch_week"><?= $Page->renderFieldHeader($Page->despatch_week) ?></div></th>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
        <th data-name="packing_type" class="<?= $Page->packing_type->headerCellClass() ?>"><div id="elh_po_pending_wbc_packing_type" class="po_pending_wbc_packing_type"><?= $Page->renderFieldHeader($Page->packing_type) ?></div></th>
<?php } ?>
<?php if ($Page->process->Visible) { // process ?>
        <th data-name="process" class="<?= $Page->process->headerCellClass() ?>"><div id="elh_po_pending_wbc_process" class="po_pending_wbc_process"><?= $Page->renderFieldHeader($Page->process) ?></div></th>
<?php } ?>
<?php if ($Page->pam_id->Visible) { // pam_id ?>
        <th data-name="pam_id" class="<?= $Page->pam_id->headerCellClass() ?>"><div id="elh_po_pending_wbc_pam_id" class="po_pending_wbc_pam_id"><?= $Page->renderFieldHeader($Page->pam_id) ?></div></th>
<?php } ?>
<?php if ($Page->issue_to->Visible) { // issue_to ?>
        <th data-name="issue_to" class="<?= $Page->issue_to->headerCellClass() ?>"><div id="elh_po_pending_wbc_issue_to" class="po_pending_wbc_issue_to"><?= $Page->renderFieldHeader($Page->issue_to) ?></div></th>
<?php } ?>
<?php if ($Page->pp_qty->Visible) { // pp_qty ?>
        <th data-name="pp_qty" class="<?= $Page->pp_qty->headerCellClass() ?>"><div id="elh_po_pending_wbc_pp_qty" class="po_pending_wbc_pp_qty"><?= $Page->renderFieldHeader($Page->pp_qty) ?></div></th>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
        <th data-name="company_id" class="<?= $Page->company_id->headerCellClass() ?>"><div id="elh_po_pending_wbc_company_id" class="po_pending_wbc_company_id"><?= $Page->renderFieldHeader($Page->company_id) ?></div></th>
<?php } ?>
<?php if ($Page->jc_quantity->Visible) { // jc_quantity ?>
        <th data-name="jc_quantity" class="<?= $Page->jc_quantity->headerCellClass() ?>"><div id="elh_po_pending_wbc_jc_quantity" class="po_pending_wbc_jc_quantity"><?= $Page->renderFieldHeader($Page->jc_quantity) ?></div></th>
<?php } ?>
<?php if ($Page->buyer_id->Visible) { // buyer_id ?>
        <th data-name="buyer_id" class="<?= $Page->buyer_id->headerCellClass() ?>"><div id="elh_po_pending_wbc_buyer_id" class="po_pending_wbc_buyer_id"><?= $Page->renderFieldHeader($Page->buyer_id) ?></div></th>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
        <th data-name="status" class="<?= $Page->status->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_po_pending_wbc_status" class="po_pending_wbc_status"><?= $Page->renderFieldHeader($Page->status) ?></div></th>
<?php } ?>
<?php if ($Page->balance->Visible) { // balance ?>
        <th data-name="balance" class="<?= $Page->balance->headerCellClass() ?>"><div id="elh_po_pending_wbc_balance" class="po_pending_wbc_balance"><?= $Page->renderFieldHeader($Page->balance) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_pending_wbc_id" class="el_po_pending_wbc_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pod->Visible) { // pod ?>
        <td data-name="pod"<?= $Page->pod->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_pending_wbc_pod" class="el_po_pending_wbc_pod">
<span<?= $Page->pod->viewAttributes() ?>>
<?= $Page->pod->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->jc_no->Visible) { // jc_no ?>
        <td data-name="jc_no"<?= $Page->jc_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_pending_wbc_jc_no" class="el_po_pending_wbc_jc_no">
<span<?= $Page->jc_no->viewAttributes() ?>>
<?= $Page->jc_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->product_code->Visible) { // product_code ?>
        <td data-name="product_code"<?= $Page->product_code->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_pending_wbc_product_code" class="el_po_pending_wbc_product_code">
<span<?= $Page->product_code->viewAttributes() ?>>
<?= $Page->product_code->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->batch_no->Visible) { // batch_no ?>
        <td data-name="batch_no"<?= $Page->batch_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_pending_wbc_batch_no" class="el_po_pending_wbc_batch_no">
<span<?= $Page->batch_no->viewAttributes() ?>>
<?= $Page->batch_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->cart_quantity->Visible) { // cart_quantity ?>
        <td data-name="cart_quantity"<?= $Page->cart_quantity->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_pending_wbc_cart_quantity" class="el_po_pending_wbc_cart_quantity">
<span<?= $Page->cart_quantity->viewAttributes() ?>>
<?= $Page->cart_quantity->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pam_qty->Visible) { // pam_qty ?>
        <td data-name="pam_qty"<?= $Page->pam_qty->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_pending_wbc_pam_qty" class="el_po_pending_wbc_pam_qty">
<span<?= $Page->pam_qty->viewAttributes() ?>>
<?= $Page->pam_qty->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pending_qty->Visible) { // pending_qty ?>
        <td data-name="pending_qty"<?= $Page->pending_qty->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_pending_wbc_pending_qty" class="el_po_pending_wbc_pending_qty">
<span<?= $Page->pending_qty->viewAttributes() ?>>
<?= $Page->pending_qty->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->despatch_week->Visible) { // despatch_week ?>
        <td data-name="despatch_week"<?= $Page->despatch_week->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_pending_wbc_despatch_week" class="el_po_pending_wbc_despatch_week">
<span<?= $Page->despatch_week->viewAttributes() ?>>
<?= $Page->despatch_week->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->packing_type->Visible) { // packing_type ?>
        <td data-name="packing_type"<?= $Page->packing_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_pending_wbc_packing_type" class="el_po_pending_wbc_packing_type">
<span<?= $Page->packing_type->viewAttributes() ?>>
<?= $Page->packing_type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->process->Visible) { // process ?>
        <td data-name="process"<?= $Page->process->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_pending_wbc_process" class="el_po_pending_wbc_process">
<span<?= $Page->process->viewAttributes() ?>>
<?= $Page->process->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pam_id->Visible) { // pam_id ?>
        <td data-name="pam_id"<?= $Page->pam_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_pending_wbc_pam_id" class="el_po_pending_wbc_pam_id">
<span<?= $Page->pam_id->viewAttributes() ?>>
<?= $Page->pam_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->issue_to->Visible) { // issue_to ?>
        <td data-name="issue_to"<?= $Page->issue_to->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_pending_wbc_issue_to" class="el_po_pending_wbc_issue_to">
<span<?= $Page->issue_to->viewAttributes() ?>>
<?= $Page->issue_to->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pp_qty->Visible) { // pp_qty ?>
        <td data-name="pp_qty"<?= $Page->pp_qty->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_pending_wbc_pp_qty" class="el_po_pending_wbc_pp_qty">
<span<?= $Page->pp_qty->viewAttributes() ?>>
<?= $Page->pp_qty->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->company_id->Visible) { // company_id ?>
        <td data-name="company_id"<?= $Page->company_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_pending_wbc_company_id" class="el_po_pending_wbc_company_id">
<span<?= $Page->company_id->viewAttributes() ?>>
<?= $Page->company_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->jc_quantity->Visible) { // jc_quantity ?>
        <td data-name="jc_quantity"<?= $Page->jc_quantity->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_pending_wbc_jc_quantity" class="el_po_pending_wbc_jc_quantity">
<span<?= $Page->jc_quantity->viewAttributes() ?>>
<?= $Page->jc_quantity->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyer_id->Visible) { // buyer_id ?>
        <td data-name="buyer_id"<?= $Page->buyer_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_pending_wbc_buyer_id" class="el_po_pending_wbc_buyer_id">
<span<?= $Page->buyer_id->viewAttributes() ?>>
<?= $Page->buyer_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->status->Visible) { // status ?>
        <td data-name="status"<?= $Page->status->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_pending_wbc_status" class="el_po_pending_wbc_status">
<span<?= $Page->status->viewAttributes() ?>>
<?= $Page->status->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->balance->Visible) { // balance ?>
        <td data-name="balance"<?= $Page->balance->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_pending_wbc_balance" class="el_po_pending_wbc_balance">
<span<?= $Page->balance->viewAttributes() ?>>
<?= $Page->balance->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Page->RowType = RowType::AGGREGATE;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->TotalRecords > 0 && !$Page->isGridAdd() && !$Page->isGridEdit() && !$Page->isMultiEdit()) { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (footer, left)
$Page->ListOptions->render("footer", "left");
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id" class="<?= $Page->id->footerCellClass() ?>"><span id="elf_po_pending_wbc_id" class="po_pending_wbc_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->pod->Visible) { // pod ?>
        <td data-name="pod" class="<?= $Page->pod->footerCellClass() ?>"><span id="elf_po_pending_wbc_pod" class="po_pending_wbc_pod">
        </span></td>
    <?php } ?>
    <?php if ($Page->jc_no->Visible) { // jc_no ?>
        <td data-name="jc_no" class="<?= $Page->jc_no->footerCellClass() ?>"><span id="elf_po_pending_wbc_jc_no" class="po_pending_wbc_jc_no">
        </span></td>
    <?php } ?>
    <?php if ($Page->product_code->Visible) { // product_code ?>
        <td data-name="product_code" class="<?= $Page->product_code->footerCellClass() ?>"><span id="elf_po_pending_wbc_product_code" class="po_pending_wbc_product_code">
        </span></td>
    <?php } ?>
    <?php if ($Page->batch_no->Visible) { // batch_no ?>
        <td data-name="batch_no" class="<?= $Page->batch_no->footerCellClass() ?>"><span id="elf_po_pending_wbc_batch_no" class="po_pending_wbc_batch_no">
        </span></td>
    <?php } ?>
    <?php if ($Page->cart_quantity->Visible) { // cart_quantity ?>
        <td data-name="cart_quantity" class="<?= $Page->cart_quantity->footerCellClass() ?>"><span id="elf_po_pending_wbc_cart_quantity" class="po_pending_wbc_cart_quantity">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->cart_quantity->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->pam_qty->Visible) { // pam_qty ?>
        <td data-name="pam_qty" class="<?= $Page->pam_qty->footerCellClass() ?>"><span id="elf_po_pending_wbc_pam_qty" class="po_pending_wbc_pam_qty">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->pam_qty->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->pending_qty->Visible) { // pending_qty ?>
        <td data-name="pending_qty" class="<?= $Page->pending_qty->footerCellClass() ?>"><span id="elf_po_pending_wbc_pending_qty" class="po_pending_wbc_pending_qty">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->pending_qty->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->despatch_week->Visible) { // despatch_week ?>
        <td data-name="despatch_week" class="<?= $Page->despatch_week->footerCellClass() ?>"><span id="elf_po_pending_wbc_despatch_week" class="po_pending_wbc_despatch_week">
        </span></td>
    <?php } ?>
    <?php if ($Page->packing_type->Visible) { // packing_type ?>
        <td data-name="packing_type" class="<?= $Page->packing_type->footerCellClass() ?>"><span id="elf_po_pending_wbc_packing_type" class="po_pending_wbc_packing_type">
        </span></td>
    <?php } ?>
    <?php if ($Page->process->Visible) { // process ?>
        <td data-name="process" class="<?= $Page->process->footerCellClass() ?>"><span id="elf_po_pending_wbc_process" class="po_pending_wbc_process">
        </span></td>
    <?php } ?>
    <?php if ($Page->pam_id->Visible) { // pam_id ?>
        <td data-name="pam_id" class="<?= $Page->pam_id->footerCellClass() ?>"><span id="elf_po_pending_wbc_pam_id" class="po_pending_wbc_pam_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->issue_to->Visible) { // issue_to ?>
        <td data-name="issue_to" class="<?= $Page->issue_to->footerCellClass() ?>"><span id="elf_po_pending_wbc_issue_to" class="po_pending_wbc_issue_to">
        </span></td>
    <?php } ?>
    <?php if ($Page->pp_qty->Visible) { // pp_qty ?>
        <td data-name="pp_qty" class="<?= $Page->pp_qty->footerCellClass() ?>"><span id="elf_po_pending_wbc_pp_qty" class="po_pending_wbc_pp_qty">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->pp_qty->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->company_id->Visible) { // company_id ?>
        <td data-name="company_id" class="<?= $Page->company_id->footerCellClass() ?>"><span id="elf_po_pending_wbc_company_id" class="po_pending_wbc_company_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->jc_quantity->Visible) { // jc_quantity ?>
        <td data-name="jc_quantity" class="<?= $Page->jc_quantity->footerCellClass() ?>"><span id="elf_po_pending_wbc_jc_quantity" class="po_pending_wbc_jc_quantity">
        </span></td>
    <?php } ?>
    <?php if ($Page->buyer_id->Visible) { // buyer_id ?>
        <td data-name="buyer_id" class="<?= $Page->buyer_id->footerCellClass() ?>"><span id="elf_po_pending_wbc_buyer_id" class="po_pending_wbc_buyer_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->status->Visible) { // status ?>
        <td data-name="status" class="<?= $Page->status->footerCellClass() ?>"><span id="elf_po_pending_wbc_status" class="po_pending_wbc_status">
        </span></td>
    <?php } ?>
    <?php if ($Page->balance->Visible) { // balance ?>
        <td data-name="balance" class="<?= $Page->balance->footerCellClass() ?>"><span id="elf_po_pending_wbc_balance" class="po_pending_wbc_balance">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Page->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("po_pending_wbc");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
