<?php

namespace PHPMaker2024\fibre;

// Page object
$PoOverallList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { po_overall: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if (!$Page->isExport() || Config("EXPORT_MASTER_RECORD") && $Page->isExport("print")) { ?>
<?php
if ($Page->DbMasterFilter != "" && $Page->getCurrentMasterTable() == "po_overall_compiled") {
    if ($Page->MasterRecordExists) {
        include_once "views/PoOverallCompiledMaster.php";
    }
}
?>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fpo_overallsrch" id="fpo_overallsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fpo_overallsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { po_overall: currentTable } });
var currentForm;
var fpo_overallsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpo_overallsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["buyer_id", [], fields.buyer_id.isInvalid],
            ["reports_to", [], fields.reports_to.isInvalid],
            ["year", [ew.Validators.integer], fields.year.isInvalid],
            ["month", [], fields.month.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "buyer_id": <?= $Page->buyer_id->toClientList($Page) ?>,
            "reports_to": <?= $Page->reports_to->toClientList($Page) ?>,
            "month": <?= $Page->month->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->buyer_id->Visible) { // buyer_id ?>
<?php
if (!$Page->buyer_id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_buyer_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->buyer_id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_buyer_id" class="ew-search-caption ew-label"><?= $Page->buyer_id->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyer_id" id="z_buyer_id" value="=">
</div>
        </div>
        <div id="el_po_overall_buyer_id" class="ew-search-field">
    <select
        id="x_buyer_id"
        name="x_buyer_id"
        class="form-select ew-select<?= $Page->buyer_id->isInvalidClass() ?>"
        <?php if (!$Page->buyer_id->IsNativeSelect) { ?>
        data-select2-id="fpo_overallsrch_x_buyer_id"
        <?php } ?>
        data-table="po_overall"
        data-field="x_buyer_id"
        data-value-separator="<?= $Page->buyer_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyer_id->getPlaceHolder()) ?>"
        <?= $Page->buyer_id->editAttributes() ?>>
        <?= $Page->buyer_id->selectOptionListHtml("x_buyer_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyer_id->getErrorMessage(false) ?></div>
<?= $Page->buyer_id->Lookup->getParamTag($Page, "p_x_buyer_id") ?>
<?php if (!$Page->buyer_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_overallsrch", function() {
    var options = { name: "x_buyer_id", selectId: "fpo_overallsrch_x_buyer_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_overallsrch.lists.buyer_id?.lookupOptions.length) {
        options.data = { id: "x_buyer_id", form: "fpo_overallsrch" };
    } else {
        options.ajax = { id: "x_buyer_id", form: "fpo_overallsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_overall.fields.buyer_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->reports_to->Visible) { // reports_to ?>
<?php
if (!$Page->reports_to->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_reports_to" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->reports_to->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_reports_to" class="ew-search-caption ew-label"><?= $Page->reports_to->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_reports_to" id="z_reports_to" value="=">
</div>
        </div>
        <div id="el_po_overall_reports_to" class="ew-search-field">
    <select
        id="x_reports_to"
        name="x_reports_to"
        class="form-select ew-select<?= $Page->reports_to->isInvalidClass() ?>"
        <?php if (!$Page->reports_to->IsNativeSelect) { ?>
        data-select2-id="fpo_overallsrch_x_reports_to"
        <?php } ?>
        data-table="po_overall"
        data-field="x_reports_to"
        data-value-separator="<?= $Page->reports_to->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->reports_to->getPlaceHolder()) ?>"
        <?= $Page->reports_to->editAttributes() ?>>
        <?= $Page->reports_to->selectOptionListHtml("x_reports_to") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->reports_to->getErrorMessage(false) ?></div>
<?= $Page->reports_to->Lookup->getParamTag($Page, "p_x_reports_to") ?>
<?php if (!$Page->reports_to->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_overallsrch", function() {
    var options = { name: "x_reports_to", selectId: "fpo_overallsrch_x_reports_to" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_overallsrch.lists.reports_to?.lookupOptions.length) {
        options.data = { id: "x_reports_to", form: "fpo_overallsrch" };
    } else {
        options.ajax = { id: "x_reports_to", form: "fpo_overallsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_overall.fields.reports_to.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->year->Visible) { // year ?>
<?php
if (!$Page->year->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_year" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->year->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_year" class="ew-search-caption ew-label"><?= $Page->year->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_year" id="z_year" value="=">
</div>
        </div>
        <div id="el_po_overall_year" class="ew-search-field">
<input type="<?= $Page->year->getInputTextType() ?>" name="x_year" id="x_year" data-table="po_overall" data-field="x_year" value="<?= $Page->year->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->year->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->year->formatPattern()) ?>"<?= $Page->year->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->year->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->month->Visible) { // month ?>
<?php
if (!$Page->month->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_month" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->month->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_month" class="ew-search-caption ew-label"><?= $Page->month->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_month" id="z_month" value="=">
</div>
        </div>
        <div id="el_po_overall_month" class="ew-search-field">
<input type="<?= $Page->month->getInputTextType() ?>" name="x_month" id="x_month" data-table="po_overall" data-field="x_month" value="<?= $Page->month->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->month->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->month->formatPattern()) ?>"<?= $Page->month->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->month->getErrorMessage(false) ?></div>
<?= $Page->month->Lookup->getParamTag($Page, "p_x_month") ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fpo_overallsrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fpo_overallsrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fpo_overallsrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fpo_overallsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fpo_overallsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fpo_overallsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fpo_overallsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="po_overall">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<?php if ($Page->getCurrentMasterTable() == "po_overall_compiled" && $Page->CurrentAction) { ?>
<input type="hidden" name="<?= Config("TABLE_SHOW_MASTER") ?>" value="po_overall_compiled">
<input type="hidden" name="fk_buyer_id" value="<?= HtmlEncode($Page->buyer_id->getSessionValue()) ?>">
<?php } ?>
<div id="gmp_po_overall" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_po_overalllist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_po_overall_id" class="po_overall_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->buyer_id->Visible) { // buyer_id ?>
        <th data-name="buyer_id" class="<?= $Page->buyer_id->headerCellClass() ?>"><div id="elh_po_overall_buyer_id" class="po_overall_buyer_id"><?= $Page->renderFieldHeader($Page->buyer_id) ?></div></th>
<?php } ?>
<?php if ($Page->reports_to->Visible) { // reports_to ?>
        <th data-name="reports_to" class="<?= $Page->reports_to->headerCellClass() ?>"><div id="elh_po_overall_reports_to" class="po_overall_reports_to"><?= $Page->renderFieldHeader($Page->reports_to) ?></div></th>
<?php } ?>
<?php if ($Page->year->Visible) { // year ?>
        <th data-name="year" class="<?= $Page->year->headerCellClass() ?>"><div id="elh_po_overall_year" class="po_overall_year"><?= $Page->renderFieldHeader($Page->year) ?></div></th>
<?php } ?>
<?php if ($Page->month->Visible) { // month ?>
        <th data-name="month" class="<?= $Page->month->headerCellClass() ?>"><div id="elh_po_overall_month" class="po_overall_month"><?= $Page->renderFieldHeader($Page->month) ?></div></th>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
        <th data-name="sqm" class="<?= $Page->sqm->headerCellClass() ?>"><div id="elh_po_overall_sqm" class="po_overall_sqm"><?= $Page->renderFieldHeader($Page->sqm) ?></div></th>
<?php } ?>
<?php if ($Page->usd->Visible) { // usd ?>
        <th data-name="usd" class="<?= $Page->usd->headerCellClass() ?>"><div id="elh_po_overall_usd" class="po_overall_usd"><?= $Page->renderFieldHeader($Page->usd) ?></div></th>
<?php } ?>
<?php if ($Page->euro->Visible) { // euro ?>
        <th data-name="euro" class="<?= $Page->euro->headerCellClass() ?>"><div id="elh_po_overall_euro" class="po_overall_euro"><?= $Page->renderFieldHeader($Page->euro) ?></div></th>
<?php } ?>
<?php if ($Page->inr->Visible) { // inr ?>
        <th data-name="inr" class="<?= $Page->inr->headerCellClass() ?>"><div id="elh_po_overall_inr" class="po_overall_inr"><?= $Page->renderFieldHeader($Page->inr) ?></div></th>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Page->operator->headerCellClass() ?>"><div id="elh_po_overall_operator" class="po_overall_operator"><?= $Page->renderFieldHeader($Page->operator) ?></div></th>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Page->datetime->headerCellClass() ?>"><div id="elh_po_overall_datetime" class="po_overall_datetime"><?= $Page->renderFieldHeader($Page->datetime) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_overall_id" class="el_po_overall_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyer_id->Visible) { // buyer_id ?>
        <td data-name="buyer_id"<?= $Page->buyer_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_overall_buyer_id" class="el_po_overall_buyer_id">
<span<?= $Page->buyer_id->viewAttributes() ?>>
<?= $Page->buyer_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->reports_to->Visible) { // reports_to ?>
        <td data-name="reports_to"<?= $Page->reports_to->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_overall_reports_to" class="el_po_overall_reports_to">
<span<?= $Page->reports_to->viewAttributes() ?>>
<?= $Page->reports_to->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->year->Visible) { // year ?>
        <td data-name="year"<?= $Page->year->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_overall_year" class="el_po_overall_year">
<span<?= $Page->year->viewAttributes() ?>>
<?= $Page->year->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->month->Visible) { // month ?>
        <td data-name="month"<?= $Page->month->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_overall_month" class="el_po_overall_month">
<span<?= $Page->month->viewAttributes() ?>>
<?= $Page->month->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sqm->Visible) { // sqm ?>
        <td data-name="sqm"<?= $Page->sqm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_overall_sqm" class="el_po_overall_sqm">
<span<?= $Page->sqm->viewAttributes() ?>>
<?= $Page->sqm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->usd->Visible) { // usd ?>
        <td data-name="usd"<?= $Page->usd->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_overall_usd" class="el_po_overall_usd">
<span<?= $Page->usd->viewAttributes() ?>>
<?= $Page->usd->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->euro->Visible) { // euro ?>
        <td data-name="euro"<?= $Page->euro->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_overall_euro" class="el_po_overall_euro">
<span<?= $Page->euro->viewAttributes() ?>>
<?= $Page->euro->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->inr->Visible) { // inr ?>
        <td data-name="inr"<?= $Page->inr->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_overall_inr" class="el_po_overall_inr">
<span<?= $Page->inr->viewAttributes() ?>>
<?= $Page->inr->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_overall_operator" class="el_po_overall_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_overall_datetime" class="el_po_overall_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Page->RowType = RowType::AGGREGATE;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->TotalRecords > 0 && !$Page->isGridAdd() && !$Page->isGridEdit() && !$Page->isMultiEdit()) { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (footer, left)
$Page->ListOptions->render("footer", "left");
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id" class="<?= $Page->id->footerCellClass() ?>"><span id="elf_po_overall_id" class="po_overall_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->buyer_id->Visible) { // buyer_id ?>
        <td data-name="buyer_id" class="<?= $Page->buyer_id->footerCellClass() ?>"><span id="elf_po_overall_buyer_id" class="po_overall_buyer_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->reports_to->Visible) { // reports_to ?>
        <td data-name="reports_to" class="<?= $Page->reports_to->footerCellClass() ?>"><span id="elf_po_overall_reports_to" class="po_overall_reports_to">
        </span></td>
    <?php } ?>
    <?php if ($Page->year->Visible) { // year ?>
        <td data-name="year" class="<?= $Page->year->footerCellClass() ?>"><span id="elf_po_overall_year" class="po_overall_year">
        </span></td>
    <?php } ?>
    <?php if ($Page->month->Visible) { // month ?>
        <td data-name="month" class="<?= $Page->month->footerCellClass() ?>"><span id="elf_po_overall_month" class="po_overall_month">
        </span></td>
    <?php } ?>
    <?php if ($Page->sqm->Visible) { // sqm ?>
        <td data-name="sqm" class="<?= $Page->sqm->footerCellClass() ?>"><span id="elf_po_overall_sqm" class="po_overall_sqm">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->sqm->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->usd->Visible) { // usd ?>
        <td data-name="usd" class="<?= $Page->usd->footerCellClass() ?>"><span id="elf_po_overall_usd" class="po_overall_usd">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->usd->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->euro->Visible) { // euro ?>
        <td data-name="euro" class="<?= $Page->euro->footerCellClass() ?>"><span id="elf_po_overall_euro" class="po_overall_euro">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->euro->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->inr->Visible) { // inr ?>
        <td data-name="inr" class="<?= $Page->inr->footerCellClass() ?>"><span id="elf_po_overall_inr" class="po_overall_inr">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->inr->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator" class="<?= $Page->operator->footerCellClass() ?>"><span id="elf_po_overall_operator" class="po_overall_operator">
        </span></td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime" class="<?= $Page->datetime->footerCellClass() ?>"><span id="elf_po_overall_datetime" class="po_overall_datetime">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Page->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("po_overall");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
