<?php

namespace PHPMaker2024\fibre;

// Set up and run Grid object
$Grid = Container("PoOverallGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var fpo_overallgrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { po_overall: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fpo_overallgrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["buyer_id", [fields.buyer_id.visible && fields.buyer_id.required ? ew.Validators.required(fields.buyer_id.caption) : null], fields.buyer_id.isInvalid],
            ["reports_to", [fields.reports_to.visible && fields.reports_to.required ? ew.Validators.required(fields.reports_to.caption) : null], fields.reports_to.isInvalid],
            ["year", [fields.year.visible && fields.year.required ? ew.Validators.required(fields.year.caption) : null, ew.Validators.integer], fields.year.isInvalid],
            ["month", [fields.month.visible && fields.month.required ? ew.Validators.required(fields.month.caption) : null], fields.month.isInvalid],
            ["sqm", [fields.sqm.visible && fields.sqm.required ? ew.Validators.required(fields.sqm.caption) : null, ew.Validators.float], fields.sqm.isInvalid],
            ["usd", [fields.usd.visible && fields.usd.required ? ew.Validators.required(fields.usd.caption) : null, ew.Validators.float], fields.usd.isInvalid],
            ["euro", [fields.euro.visible && fields.euro.required ? ew.Validators.required(fields.euro.caption) : null, ew.Validators.float], fields.euro.isInvalid],
            ["inr", [fields.inr.visible && fields.inr.required ? ew.Validators.required(fields.inr.caption) : null, ew.Validators.float], fields.inr.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["buyer_id",false],["reports_to",false],["year",false],["month",false],["sqm",false],["usd",false],["euro",false],["inr",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "buyer_id": <?= $Grid->buyer_id->toClientList($Grid) ?>,
            "reports_to": <?= $Grid->reports_to->toClientList($Grid) ?>,
            "month": <?= $Grid->month->toClientList($Grid) ?>,
            "operator": <?= $Grid->operator->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
<div id="fpo_overallgrid" class="ew-form ew-list-form">
<div id="gmp_po_overall" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_po_overallgrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Grid->id->headerCellClass() ?>"><div id="elh_po_overall_id" class="po_overall_id"><?= $Grid->renderFieldHeader($Grid->id) ?></div></th>
<?php } ?>
<?php if ($Grid->buyer_id->Visible) { // buyer_id ?>
        <th data-name="buyer_id" class="<?= $Grid->buyer_id->headerCellClass() ?>"><div id="elh_po_overall_buyer_id" class="po_overall_buyer_id"><?= $Grid->renderFieldHeader($Grid->buyer_id) ?></div></th>
<?php } ?>
<?php if ($Grid->reports_to->Visible) { // reports_to ?>
        <th data-name="reports_to" class="<?= $Grid->reports_to->headerCellClass() ?>"><div id="elh_po_overall_reports_to" class="po_overall_reports_to"><?= $Grid->renderFieldHeader($Grid->reports_to) ?></div></th>
<?php } ?>
<?php if ($Grid->year->Visible) { // year ?>
        <th data-name="year" class="<?= $Grid->year->headerCellClass() ?>"><div id="elh_po_overall_year" class="po_overall_year"><?= $Grid->renderFieldHeader($Grid->year) ?></div></th>
<?php } ?>
<?php if ($Grid->month->Visible) { // month ?>
        <th data-name="month" class="<?= $Grid->month->headerCellClass() ?>"><div id="elh_po_overall_month" class="po_overall_month"><?= $Grid->renderFieldHeader($Grid->month) ?></div></th>
<?php } ?>
<?php if ($Grid->sqm->Visible) { // sqm ?>
        <th data-name="sqm" class="<?= $Grid->sqm->headerCellClass() ?>"><div id="elh_po_overall_sqm" class="po_overall_sqm"><?= $Grid->renderFieldHeader($Grid->sqm) ?></div></th>
<?php } ?>
<?php if ($Grid->usd->Visible) { // usd ?>
        <th data-name="usd" class="<?= $Grid->usd->headerCellClass() ?>"><div id="elh_po_overall_usd" class="po_overall_usd"><?= $Grid->renderFieldHeader($Grid->usd) ?></div></th>
<?php } ?>
<?php if ($Grid->euro->Visible) { // euro ?>
        <th data-name="euro" class="<?= $Grid->euro->headerCellClass() ?>"><div id="elh_po_overall_euro" class="po_overall_euro"><?= $Grid->renderFieldHeader($Grid->euro) ?></div></th>
<?php } ?>
<?php if ($Grid->inr->Visible) { // inr ?>
        <th data-name="inr" class="<?= $Grid->inr->headerCellClass() ?>"><div id="elh_po_overall_inr" class="po_overall_inr"><?= $Grid->renderFieldHeader($Grid->inr) ?></div></th>
<?php } ?>
<?php if ($Grid->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Grid->operator->headerCellClass() ?>"><div id="elh_po_overall_operator" class="po_overall_operator"><?= $Grid->renderFieldHeader($Grid->operator) ?></div></th>
<?php } ?>
<?php if ($Grid->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Grid->datetime->headerCellClass() ?>"><div id="elh_po_overall_datetime" class="po_overall_datetime"><?= $Grid->renderFieldHeader($Grid->datetime) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->id->Visible) { // id ?>
        <td data-name="id"<?= $Grid->id->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_po_overall_id" class="el_po_overall_id"></span>
<input type="hidden" data-table="po_overall" data-field="x_id" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_id" id="o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_po_overall_id" class="el_po_overall_id">
<span<?= $Grid->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->id->getDisplayValue($Grid->id->EditValue))) ?>"></span>
<input type="hidden" data-table="po_overall" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_po_overall_id" class="el_po_overall_id">
<span<?= $Grid->id->viewAttributes() ?>>
<?= $Grid->id->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="po_overall" data-field="x_id" data-hidden="1" name="fpo_overallgrid$x<?= $Grid->RowIndex ?>_id" id="fpo_overallgrid$x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->FormValue) ?>">
<input type="hidden" data-table="po_overall" data-field="x_id" data-hidden="1" data-old name="fpo_overallgrid$o<?= $Grid->RowIndex ?>_id" id="fpo_overallgrid$o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="po_overall" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Grid->buyer_id->Visible) { // buyer_id ?>
        <td data-name="buyer_id"<?= $Grid->buyer_id->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->buyer_id->getSessionValue() != "") { ?>
<span<?= $Grid->buyer_id->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->buyer_id->getDisplayValue($Grid->buyer_id->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_buyer_id" name="x<?= $Grid->RowIndex ?>_buyer_id" value="<?= HtmlEncode($Grid->buyer_id->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_po_overall_buyer_id" class="el_po_overall_buyer_id">
    <select
        id="x<?= $Grid->RowIndex ?>_buyer_id"
        name="x<?= $Grid->RowIndex ?>_buyer_id"
        class="form-select ew-select<?= $Grid->buyer_id->isInvalidClass() ?>"
        <?php if (!$Grid->buyer_id->IsNativeSelect) { ?>
        data-select2-id="fpo_overallgrid_x<?= $Grid->RowIndex ?>_buyer_id"
        <?php } ?>
        data-table="po_overall"
        data-field="x_buyer_id"
        data-value-separator="<?= $Grid->buyer_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->buyer_id->getPlaceHolder()) ?>"
        <?= $Grid->buyer_id->editAttributes() ?>>
        <?= $Grid->buyer_id->selectOptionListHtml("x{$Grid->RowIndex}_buyer_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->buyer_id->getErrorMessage() ?></div>
<?= $Grid->buyer_id->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_buyer_id") ?>
<?php if (!$Grid->buyer_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_overallgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_buyer_id", selectId: "fpo_overallgrid_x<?= $Grid->RowIndex ?>_buyer_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_overallgrid.lists.buyer_id?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_buyer_id", form: "fpo_overallgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_buyer_id", form: "fpo_overallgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_overall.fields.buyer_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="po_overall" data-field="x_buyer_id" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_buyer_id" id="o<?= $Grid->RowIndex ?>_buyer_id" value="<?= HtmlEncode($Grid->buyer_id->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->buyer_id->getSessionValue() != "") { ?>
<span<?= $Grid->buyer_id->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->buyer_id->getDisplayValue($Grid->buyer_id->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_buyer_id" name="x<?= $Grid->RowIndex ?>_buyer_id" value="<?= HtmlEncode($Grid->buyer_id->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_po_overall_buyer_id" class="el_po_overall_buyer_id">
    <select
        id="x<?= $Grid->RowIndex ?>_buyer_id"
        name="x<?= $Grid->RowIndex ?>_buyer_id"
        class="form-select ew-select<?= $Grid->buyer_id->isInvalidClass() ?>"
        <?php if (!$Grid->buyer_id->IsNativeSelect) { ?>
        data-select2-id="fpo_overallgrid_x<?= $Grid->RowIndex ?>_buyer_id"
        <?php } ?>
        data-table="po_overall"
        data-field="x_buyer_id"
        data-value-separator="<?= $Grid->buyer_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->buyer_id->getPlaceHolder()) ?>"
        <?= $Grid->buyer_id->editAttributes() ?>>
        <?= $Grid->buyer_id->selectOptionListHtml("x{$Grid->RowIndex}_buyer_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->buyer_id->getErrorMessage() ?></div>
<?= $Grid->buyer_id->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_buyer_id") ?>
<?php if (!$Grid->buyer_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_overallgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_buyer_id", selectId: "fpo_overallgrid_x<?= $Grid->RowIndex ?>_buyer_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_overallgrid.lists.buyer_id?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_buyer_id", form: "fpo_overallgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_buyer_id", form: "fpo_overallgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_overall.fields.buyer_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_po_overall_buyer_id" class="el_po_overall_buyer_id">
<span<?= $Grid->buyer_id->viewAttributes() ?>>
<?= $Grid->buyer_id->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="po_overall" data-field="x_buyer_id" data-hidden="1" name="fpo_overallgrid$x<?= $Grid->RowIndex ?>_buyer_id" id="fpo_overallgrid$x<?= $Grid->RowIndex ?>_buyer_id" value="<?= HtmlEncode($Grid->buyer_id->FormValue) ?>">
<input type="hidden" data-table="po_overall" data-field="x_buyer_id" data-hidden="1" data-old name="fpo_overallgrid$o<?= $Grid->RowIndex ?>_buyer_id" id="fpo_overallgrid$o<?= $Grid->RowIndex ?>_buyer_id" value="<?= HtmlEncode($Grid->buyer_id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->reports_to->Visible) { // reports_to ?>
        <td data-name="reports_to"<?= $Grid->reports_to->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_po_overall_reports_to" class="el_po_overall_reports_to">
    <select
        id="x<?= $Grid->RowIndex ?>_reports_to"
        name="x<?= $Grid->RowIndex ?>_reports_to"
        class="form-select ew-select<?= $Grid->reports_to->isInvalidClass() ?>"
        <?php if (!$Grid->reports_to->IsNativeSelect) { ?>
        data-select2-id="fpo_overallgrid_x<?= $Grid->RowIndex ?>_reports_to"
        <?php } ?>
        data-table="po_overall"
        data-field="x_reports_to"
        data-value-separator="<?= $Grid->reports_to->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->reports_to->getPlaceHolder()) ?>"
        <?= $Grid->reports_to->editAttributes() ?>>
        <?= $Grid->reports_to->selectOptionListHtml("x{$Grid->RowIndex}_reports_to") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->reports_to->getErrorMessage() ?></div>
<?= $Grid->reports_to->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_reports_to") ?>
<?php if (!$Grid->reports_to->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_overallgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_reports_to", selectId: "fpo_overallgrid_x<?= $Grid->RowIndex ?>_reports_to" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_overallgrid.lists.reports_to?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_reports_to", form: "fpo_overallgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_reports_to", form: "fpo_overallgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_overall.fields.reports_to.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="po_overall" data-field="x_reports_to" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_reports_to" id="o<?= $Grid->RowIndex ?>_reports_to" value="<?= HtmlEncode($Grid->reports_to->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_po_overall_reports_to" class="el_po_overall_reports_to">
    <select
        id="x<?= $Grid->RowIndex ?>_reports_to"
        name="x<?= $Grid->RowIndex ?>_reports_to"
        class="form-select ew-select<?= $Grid->reports_to->isInvalidClass() ?>"
        <?php if (!$Grid->reports_to->IsNativeSelect) { ?>
        data-select2-id="fpo_overallgrid_x<?= $Grid->RowIndex ?>_reports_to"
        <?php } ?>
        data-table="po_overall"
        data-field="x_reports_to"
        data-value-separator="<?= $Grid->reports_to->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->reports_to->getPlaceHolder()) ?>"
        <?= $Grid->reports_to->editAttributes() ?>>
        <?= $Grid->reports_to->selectOptionListHtml("x{$Grid->RowIndex}_reports_to") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->reports_to->getErrorMessage() ?></div>
<?= $Grid->reports_to->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_reports_to") ?>
<?php if (!$Grid->reports_to->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_overallgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_reports_to", selectId: "fpo_overallgrid_x<?= $Grid->RowIndex ?>_reports_to" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_overallgrid.lists.reports_to?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_reports_to", form: "fpo_overallgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_reports_to", form: "fpo_overallgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_overall.fields.reports_to.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_po_overall_reports_to" class="el_po_overall_reports_to">
<span<?= $Grid->reports_to->viewAttributes() ?>>
<?= $Grid->reports_to->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="po_overall" data-field="x_reports_to" data-hidden="1" name="fpo_overallgrid$x<?= $Grid->RowIndex ?>_reports_to" id="fpo_overallgrid$x<?= $Grid->RowIndex ?>_reports_to" value="<?= HtmlEncode($Grid->reports_to->FormValue) ?>">
<input type="hidden" data-table="po_overall" data-field="x_reports_to" data-hidden="1" data-old name="fpo_overallgrid$o<?= $Grid->RowIndex ?>_reports_to" id="fpo_overallgrid$o<?= $Grid->RowIndex ?>_reports_to" value="<?= HtmlEncode($Grid->reports_to->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->year->Visible) { // year ?>
        <td data-name="year"<?= $Grid->year->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_po_overall_year" class="el_po_overall_year">
<input type="<?= $Grid->year->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_year" id="x<?= $Grid->RowIndex ?>_year" data-table="po_overall" data-field="x_year" value="<?= $Grid->year->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->year->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->year->formatPattern()) ?>"<?= $Grid->year->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->year->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="po_overall" data-field="x_year" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_year" id="o<?= $Grid->RowIndex ?>_year" value="<?= HtmlEncode($Grid->year->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_po_overall_year" class="el_po_overall_year">
<input type="<?= $Grid->year->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_year" id="x<?= $Grid->RowIndex ?>_year" data-table="po_overall" data-field="x_year" value="<?= $Grid->year->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->year->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->year->formatPattern()) ?>"<?= $Grid->year->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->year->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_po_overall_year" class="el_po_overall_year">
<span<?= $Grid->year->viewAttributes() ?>>
<?= $Grid->year->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="po_overall" data-field="x_year" data-hidden="1" name="fpo_overallgrid$x<?= $Grid->RowIndex ?>_year" id="fpo_overallgrid$x<?= $Grid->RowIndex ?>_year" value="<?= HtmlEncode($Grid->year->FormValue) ?>">
<input type="hidden" data-table="po_overall" data-field="x_year" data-hidden="1" data-old name="fpo_overallgrid$o<?= $Grid->RowIndex ?>_year" id="fpo_overallgrid$o<?= $Grid->RowIndex ?>_year" value="<?= HtmlEncode($Grid->year->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->month->Visible) { // month ?>
        <td data-name="month"<?= $Grid->month->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_po_overall_month" class="el_po_overall_month">
    <select
        id="x<?= $Grid->RowIndex ?>_month"
        name="x<?= $Grid->RowIndex ?>_month"
        class="form-select ew-select<?= $Grid->month->isInvalidClass() ?>"
        <?php if (!$Grid->month->IsNativeSelect) { ?>
        data-select2-id="fpo_overallgrid_x<?= $Grid->RowIndex ?>_month"
        <?php } ?>
        data-table="po_overall"
        data-field="x_month"
        data-value-separator="<?= $Grid->month->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->month->getPlaceHolder()) ?>"
        <?= $Grid->month->editAttributes() ?>>
        <?= $Grid->month->selectOptionListHtml("x{$Grid->RowIndex}_month") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->month->getErrorMessage() ?></div>
<?= $Grid->month->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_month") ?>
<?php if (!$Grid->month->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_overallgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_month", selectId: "fpo_overallgrid_x<?= $Grid->RowIndex ?>_month" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_overallgrid.lists.month?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_month", form: "fpo_overallgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_month", form: "fpo_overallgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_overall.fields.month.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="po_overall" data-field="x_month" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_month" id="o<?= $Grid->RowIndex ?>_month" value="<?= HtmlEncode($Grid->month->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_po_overall_month" class="el_po_overall_month">
    <select
        id="x<?= $Grid->RowIndex ?>_month"
        name="x<?= $Grid->RowIndex ?>_month"
        class="form-select ew-select<?= $Grid->month->isInvalidClass() ?>"
        <?php if (!$Grid->month->IsNativeSelect) { ?>
        data-select2-id="fpo_overallgrid_x<?= $Grid->RowIndex ?>_month"
        <?php } ?>
        data-table="po_overall"
        data-field="x_month"
        data-value-separator="<?= $Grid->month->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->month->getPlaceHolder()) ?>"
        <?= $Grid->month->editAttributes() ?>>
        <?= $Grid->month->selectOptionListHtml("x{$Grid->RowIndex}_month") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->month->getErrorMessage() ?></div>
<?= $Grid->month->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_month") ?>
<?php if (!$Grid->month->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_overallgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_month", selectId: "fpo_overallgrid_x<?= $Grid->RowIndex ?>_month" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_overallgrid.lists.month?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_month", form: "fpo_overallgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_month", form: "fpo_overallgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_overall.fields.month.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_po_overall_month" class="el_po_overall_month">
<span<?= $Grid->month->viewAttributes() ?>>
<?= $Grid->month->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="po_overall" data-field="x_month" data-hidden="1" name="fpo_overallgrid$x<?= $Grid->RowIndex ?>_month" id="fpo_overallgrid$x<?= $Grid->RowIndex ?>_month" value="<?= HtmlEncode($Grid->month->FormValue) ?>">
<input type="hidden" data-table="po_overall" data-field="x_month" data-hidden="1" data-old name="fpo_overallgrid$o<?= $Grid->RowIndex ?>_month" id="fpo_overallgrid$o<?= $Grid->RowIndex ?>_month" value="<?= HtmlEncode($Grid->month->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->sqm->Visible) { // sqm ?>
        <td data-name="sqm"<?= $Grid->sqm->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_po_overall_sqm" class="el_po_overall_sqm">
<input type="<?= $Grid->sqm->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_sqm" id="x<?= $Grid->RowIndex ?>_sqm" data-table="po_overall" data-field="x_sqm" value="<?= $Grid->sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->sqm->formatPattern()) ?>"<?= $Grid->sqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->sqm->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="po_overall" data-field="x_sqm" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_sqm" id="o<?= $Grid->RowIndex ?>_sqm" value="<?= HtmlEncode($Grid->sqm->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_po_overall_sqm" class="el_po_overall_sqm">
<input type="<?= $Grid->sqm->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_sqm" id="x<?= $Grid->RowIndex ?>_sqm" data-table="po_overall" data-field="x_sqm" value="<?= $Grid->sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->sqm->formatPattern()) ?>"<?= $Grid->sqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->sqm->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_po_overall_sqm" class="el_po_overall_sqm">
<span<?= $Grid->sqm->viewAttributes() ?>>
<?= $Grid->sqm->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="po_overall" data-field="x_sqm" data-hidden="1" name="fpo_overallgrid$x<?= $Grid->RowIndex ?>_sqm" id="fpo_overallgrid$x<?= $Grid->RowIndex ?>_sqm" value="<?= HtmlEncode($Grid->sqm->FormValue) ?>">
<input type="hidden" data-table="po_overall" data-field="x_sqm" data-hidden="1" data-old name="fpo_overallgrid$o<?= $Grid->RowIndex ?>_sqm" id="fpo_overallgrid$o<?= $Grid->RowIndex ?>_sqm" value="<?= HtmlEncode($Grid->sqm->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->usd->Visible) { // usd ?>
        <td data-name="usd"<?= $Grid->usd->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_po_overall_usd" class="el_po_overall_usd">
<input type="<?= $Grid->usd->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_usd" id="x<?= $Grid->RowIndex ?>_usd" data-table="po_overall" data-field="x_usd" value="<?= $Grid->usd->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->usd->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->usd->formatPattern()) ?>"<?= $Grid->usd->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->usd->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="po_overall" data-field="x_usd" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_usd" id="o<?= $Grid->RowIndex ?>_usd" value="<?= HtmlEncode($Grid->usd->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_po_overall_usd" class="el_po_overall_usd">
<input type="<?= $Grid->usd->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_usd" id="x<?= $Grid->RowIndex ?>_usd" data-table="po_overall" data-field="x_usd" value="<?= $Grid->usd->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->usd->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->usd->formatPattern()) ?>"<?= $Grid->usd->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->usd->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_po_overall_usd" class="el_po_overall_usd">
<span<?= $Grid->usd->viewAttributes() ?>>
<?= $Grid->usd->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="po_overall" data-field="x_usd" data-hidden="1" name="fpo_overallgrid$x<?= $Grid->RowIndex ?>_usd" id="fpo_overallgrid$x<?= $Grid->RowIndex ?>_usd" value="<?= HtmlEncode($Grid->usd->FormValue) ?>">
<input type="hidden" data-table="po_overall" data-field="x_usd" data-hidden="1" data-old name="fpo_overallgrid$o<?= $Grid->RowIndex ?>_usd" id="fpo_overallgrid$o<?= $Grid->RowIndex ?>_usd" value="<?= HtmlEncode($Grid->usd->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->euro->Visible) { // euro ?>
        <td data-name="euro"<?= $Grid->euro->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_po_overall_euro" class="el_po_overall_euro">
<input type="<?= $Grid->euro->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_euro" id="x<?= $Grid->RowIndex ?>_euro" data-table="po_overall" data-field="x_euro" value="<?= $Grid->euro->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->euro->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->euro->formatPattern()) ?>"<?= $Grid->euro->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->euro->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="po_overall" data-field="x_euro" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_euro" id="o<?= $Grid->RowIndex ?>_euro" value="<?= HtmlEncode($Grid->euro->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_po_overall_euro" class="el_po_overall_euro">
<input type="<?= $Grid->euro->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_euro" id="x<?= $Grid->RowIndex ?>_euro" data-table="po_overall" data-field="x_euro" value="<?= $Grid->euro->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->euro->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->euro->formatPattern()) ?>"<?= $Grid->euro->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->euro->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_po_overall_euro" class="el_po_overall_euro">
<span<?= $Grid->euro->viewAttributes() ?>>
<?= $Grid->euro->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="po_overall" data-field="x_euro" data-hidden="1" name="fpo_overallgrid$x<?= $Grid->RowIndex ?>_euro" id="fpo_overallgrid$x<?= $Grid->RowIndex ?>_euro" value="<?= HtmlEncode($Grid->euro->FormValue) ?>">
<input type="hidden" data-table="po_overall" data-field="x_euro" data-hidden="1" data-old name="fpo_overallgrid$o<?= $Grid->RowIndex ?>_euro" id="fpo_overallgrid$o<?= $Grid->RowIndex ?>_euro" value="<?= HtmlEncode($Grid->euro->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->inr->Visible) { // inr ?>
        <td data-name="inr"<?= $Grid->inr->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_po_overall_inr" class="el_po_overall_inr">
<input type="<?= $Grid->inr->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_inr" id="x<?= $Grid->RowIndex ?>_inr" data-table="po_overall" data-field="x_inr" value="<?= $Grid->inr->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->inr->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->inr->formatPattern()) ?>"<?= $Grid->inr->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->inr->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="po_overall" data-field="x_inr" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_inr" id="o<?= $Grid->RowIndex ?>_inr" value="<?= HtmlEncode($Grid->inr->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_po_overall_inr" class="el_po_overall_inr">
<input type="<?= $Grid->inr->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_inr" id="x<?= $Grid->RowIndex ?>_inr" data-table="po_overall" data-field="x_inr" value="<?= $Grid->inr->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->inr->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->inr->formatPattern()) ?>"<?= $Grid->inr->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->inr->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_po_overall_inr" class="el_po_overall_inr">
<span<?= $Grid->inr->viewAttributes() ?>>
<?= $Grid->inr->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="po_overall" data-field="x_inr" data-hidden="1" name="fpo_overallgrid$x<?= $Grid->RowIndex ?>_inr" id="fpo_overallgrid$x<?= $Grid->RowIndex ?>_inr" value="<?= HtmlEncode($Grid->inr->FormValue) ?>">
<input type="hidden" data-table="po_overall" data-field="x_inr" data-hidden="1" data-old name="fpo_overallgrid$o<?= $Grid->RowIndex ?>_inr" id="fpo_overallgrid$o<?= $Grid->RowIndex ?>_inr" value="<?= HtmlEncode($Grid->inr->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Grid->operator->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="po_overall" data-field="x_operator" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_operator" id="o<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_po_overall_operator" class="el_po_overall_operator">
<span<?= $Grid->operator->viewAttributes() ?>>
<?= $Grid->operator->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="po_overall" data-field="x_operator" data-hidden="1" name="fpo_overallgrid$x<?= $Grid->RowIndex ?>_operator" id="fpo_overallgrid$x<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->FormValue) ?>">
<input type="hidden" data-table="po_overall" data-field="x_operator" data-hidden="1" data-old name="fpo_overallgrid$o<?= $Grid->RowIndex ?>_operator" id="fpo_overallgrid$o<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Grid->datetime->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="po_overall" data-field="x_datetime" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_datetime" id="o<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_po_overall_datetime" class="el_po_overall_datetime">
<span<?= $Grid->datetime->viewAttributes() ?>>
<?= $Grid->datetime->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="po_overall" data-field="x_datetime" data-hidden="1" name="fpo_overallgrid$x<?= $Grid->RowIndex ?>_datetime" id="fpo_overallgrid$x<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->FormValue) ?>">
<input type="hidden" data-table="po_overall" data-field="x_datetime" data-hidden="1" data-old name="fpo_overallgrid$o<?= $Grid->RowIndex ?>_datetime" id="fpo_overallgrid$o<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["fpo_overallgrid","load"], () => fpo_overallgrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Grid->RowType = RowType::AGGREGATE;
$Grid->resetAttributes();
$Grid->renderRow();
?>
<?php if ($Grid->TotalRecords > 0 && $Grid->CurrentMode == "view") { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Grid->renderListOptions();

// Render list options (footer, left)
$Grid->ListOptions->render("footer", "left");
?>
    <?php if ($Grid->id->Visible) { // id ?>
        <td data-name="id" class="<?= $Grid->id->footerCellClass() ?>"><span id="elf_po_overall_id" class="po_overall_id">
        </span></td>
    <?php } ?>
    <?php if ($Grid->buyer_id->Visible) { // buyer_id ?>
        <td data-name="buyer_id" class="<?= $Grid->buyer_id->footerCellClass() ?>"><span id="elf_po_overall_buyer_id" class="po_overall_buyer_id">
        </span></td>
    <?php } ?>
    <?php if ($Grid->reports_to->Visible) { // reports_to ?>
        <td data-name="reports_to" class="<?= $Grid->reports_to->footerCellClass() ?>"><span id="elf_po_overall_reports_to" class="po_overall_reports_to">
        </span></td>
    <?php } ?>
    <?php if ($Grid->year->Visible) { // year ?>
        <td data-name="year" class="<?= $Grid->year->footerCellClass() ?>"><span id="elf_po_overall_year" class="po_overall_year">
        </span></td>
    <?php } ?>
    <?php if ($Grid->month->Visible) { // month ?>
        <td data-name="month" class="<?= $Grid->month->footerCellClass() ?>"><span id="elf_po_overall_month" class="po_overall_month">
        </span></td>
    <?php } ?>
    <?php if ($Grid->sqm->Visible) { // sqm ?>
        <td data-name="sqm" class="<?= $Grid->sqm->footerCellClass() ?>"><span id="elf_po_overall_sqm" class="po_overall_sqm">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Grid->sqm->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Grid->usd->Visible) { // usd ?>
        <td data-name="usd" class="<?= $Grid->usd->footerCellClass() ?>"><span id="elf_po_overall_usd" class="po_overall_usd">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Grid->usd->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Grid->euro->Visible) { // euro ?>
        <td data-name="euro" class="<?= $Grid->euro->footerCellClass() ?>"><span id="elf_po_overall_euro" class="po_overall_euro">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Grid->euro->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Grid->inr->Visible) { // inr ?>
        <td data-name="inr" class="<?= $Grid->inr->footerCellClass() ?>"><span id="elf_po_overall_inr" class="po_overall_inr">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Grid->inr->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Grid->operator->Visible) { // operator ?>
        <td data-name="operator" class="<?= $Grid->operator->footerCellClass() ?>"><span id="elf_po_overall_operator" class="po_overall_operator">
        </span></td>
    <?php } ?>
    <?php if ($Grid->datetime->Visible) { // datetime ?>
        <td data-name="datetime" class="<?= $Grid->datetime->footerCellClass() ?>"><span id="elf_po_overall_datetime" class="po_overall_datetime">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Grid->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fpo_overallgrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("po_overall");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
