<?php

namespace PHPMaker2024\fibre;

// Page object
$PoOverallCrossSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { po_overall_cross: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fpo_overall_crosssearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpo_overall_crosssearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["Buyer", [], fields.Buyer.isInvalid],
            ["Month", [], fields.Month.isInvalid],
            ["SQM_CY", [ew.Validators.float], fields.SQM_CY.isInvalid],
            ["Amount_CY", [], fields.Amount_CY.isInvalid],
            ["SQM_PY", [ew.Validators.float], fields.SQM_PY.isInvalid],
            ["Amount_PY", [], fields.Amount_PY.isInvalid],
            ["SQM_BPY", [ew.Validators.float], fields.SQM_BPY.isInvalid],
            ["Amount_BPY", [], fields.Amount_BPY.isInvalid],
            ["SQM_BBPY", [ew.Validators.float], fields.SQM_BBPY.isInvalid],
            ["Amount_BBPY", [], fields.Amount_BBPY.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "Buyer": <?= $Page->Buyer->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fpo_overall_crosssearch" id="fpo_overall_crosssearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="po_overall_cross">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->Buyer->Visible) { // Buyer ?>
    <div id="r_Buyer" class="row"<?= $Page->Buyer->rowAttributes() ?>>
        <label for="x_Buyer" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_overall_cross_Buyer"><?= $Page->Buyer->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Buyer" id="z_Buyer" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Buyer->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_overall_cross_Buyer" class="ew-search-field ew-search-field-single">
    <select
        id="x_Buyer"
        name="x_Buyer"
        class="form-select ew-select<?= $Page->Buyer->isInvalidClass() ?>"
        <?php if (!$Page->Buyer->IsNativeSelect) { ?>
        data-select2-id="fpo_overall_crosssearch_x_Buyer"
        <?php } ?>
        data-table="po_overall_cross"
        data-field="x_Buyer"
        data-value-separator="<?= $Page->Buyer->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Buyer->getPlaceHolder()) ?>"
        <?= $Page->Buyer->editAttributes() ?>>
        <?= $Page->Buyer->selectOptionListHtml("x_Buyer") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Buyer->getErrorMessage(false) ?></div>
<?= $Page->Buyer->Lookup->getParamTag($Page, "p_x_Buyer") ?>
<?php if (!$Page->Buyer->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_overall_crosssearch", function() {
    var options = { name: "x_Buyer", selectId: "fpo_overall_crosssearch_x_Buyer" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_overall_crosssearch.lists.Buyer?.lookupOptions.length) {
        options.data = { id: "x_Buyer", form: "fpo_overall_crosssearch" };
    } else {
        options.ajax = { id: "x_Buyer", form: "fpo_overall_crosssearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_overall_cross.fields.Buyer.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Month->Visible) { // Month ?>
    <div id="r_Month" class="row"<?= $Page->Month->rowAttributes() ?>>
        <label for="x_Month" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_overall_cross_Month"><?= $Page->Month->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Month" id="z_Month" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Month->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_overall_cross_Month" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Month->getInputTextType() ?>" name="x_Month" id="x_Month" data-table="po_overall_cross" data-field="x_Month" value="<?= $Page->Month->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->Month->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Month->formatPattern()) ?>"<?= $Page->Month->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Month->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->SQM_CY->Visible) { // SQM_CY ?>
    <div id="r_SQM_CY" class="row"<?= $Page->SQM_CY->rowAttributes() ?>>
        <label for="x_SQM_CY" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_overall_cross_SQM_CY"><?= $Page->SQM_CY->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_SQM_CY" id="z_SQM_CY" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->SQM_CY->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_overall_cross_SQM_CY" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->SQM_CY->getInputTextType() ?>" name="x_SQM_CY" id="x_SQM_CY" data-table="po_overall_cross" data-field="x_SQM_CY" value="<?= $Page->SQM_CY->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->SQM_CY->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->SQM_CY->formatPattern()) ?>"<?= $Page->SQM_CY->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->SQM_CY->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Amount_CY->Visible) { // Amount_CY ?>
    <div id="r_Amount_CY" class="row"<?= $Page->Amount_CY->rowAttributes() ?>>
        <label for="x_Amount_CY" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_overall_cross_Amount_CY"><?= $Page->Amount_CY->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Amount_CY" id="z_Amount_CY" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Amount_CY->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_overall_cross_Amount_CY" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Amount_CY->getInputTextType() ?>" name="x_Amount_CY" id="x_Amount_CY" data-table="po_overall_cross" data-field="x_Amount_CY" value="<?= $Page->Amount_CY->EditValue ?>" size="30" maxlength="129" placeholder="<?= HtmlEncode($Page->Amount_CY->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Amount_CY->formatPattern()) ?>"<?= $Page->Amount_CY->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Amount_CY->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->SQM_PY->Visible) { // SQM_PY ?>
    <div id="r_SQM_PY" class="row"<?= $Page->SQM_PY->rowAttributes() ?>>
        <label for="x_SQM_PY" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_overall_cross_SQM_PY"><?= $Page->SQM_PY->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_SQM_PY" id="z_SQM_PY" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->SQM_PY->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_overall_cross_SQM_PY" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->SQM_PY->getInputTextType() ?>" name="x_SQM_PY" id="x_SQM_PY" data-table="po_overall_cross" data-field="x_SQM_PY" value="<?= $Page->SQM_PY->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->SQM_PY->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->SQM_PY->formatPattern()) ?>"<?= $Page->SQM_PY->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->SQM_PY->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Amount_PY->Visible) { // Amount_PY ?>
    <div id="r_Amount_PY" class="row"<?= $Page->Amount_PY->rowAttributes() ?>>
        <label for="x_Amount_PY" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_overall_cross_Amount_PY"><?= $Page->Amount_PY->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Amount_PY" id="z_Amount_PY" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Amount_PY->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_overall_cross_Amount_PY" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Amount_PY->getInputTextType() ?>" name="x_Amount_PY" id="x_Amount_PY" data-table="po_overall_cross" data-field="x_Amount_PY" value="<?= $Page->Amount_PY->EditValue ?>" size="30" maxlength="129" placeholder="<?= HtmlEncode($Page->Amount_PY->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Amount_PY->formatPattern()) ?>"<?= $Page->Amount_PY->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Amount_PY->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->SQM_BPY->Visible) { // SQM_BPY ?>
    <div id="r_SQM_BPY" class="row"<?= $Page->SQM_BPY->rowAttributes() ?>>
        <label for="x_SQM_BPY" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_overall_cross_SQM_BPY"><?= $Page->SQM_BPY->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_SQM_BPY" id="z_SQM_BPY" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->SQM_BPY->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_overall_cross_SQM_BPY" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->SQM_BPY->getInputTextType() ?>" name="x_SQM_BPY" id="x_SQM_BPY" data-table="po_overall_cross" data-field="x_SQM_BPY" value="<?= $Page->SQM_BPY->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->SQM_BPY->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->SQM_BPY->formatPattern()) ?>"<?= $Page->SQM_BPY->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->SQM_BPY->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Amount_BPY->Visible) { // Amount_BPY ?>
    <div id="r_Amount_BPY" class="row"<?= $Page->Amount_BPY->rowAttributes() ?>>
        <label for="x_Amount_BPY" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_overall_cross_Amount_BPY"><?= $Page->Amount_BPY->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Amount_BPY" id="z_Amount_BPY" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Amount_BPY->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_overall_cross_Amount_BPY" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Amount_BPY->getInputTextType() ?>" name="x_Amount_BPY" id="x_Amount_BPY" data-table="po_overall_cross" data-field="x_Amount_BPY" value="<?= $Page->Amount_BPY->EditValue ?>" size="30" maxlength="129" placeholder="<?= HtmlEncode($Page->Amount_BPY->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Amount_BPY->formatPattern()) ?>"<?= $Page->Amount_BPY->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Amount_BPY->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->SQM_BBPY->Visible) { // SQM_BBPY ?>
    <div id="r_SQM_BBPY" class="row"<?= $Page->SQM_BBPY->rowAttributes() ?>>
        <label for="x_SQM_BBPY" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_overall_cross_SQM_BBPY"><?= $Page->SQM_BBPY->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_SQM_BBPY" id="z_SQM_BBPY" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->SQM_BBPY->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_overall_cross_SQM_BBPY" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->SQM_BBPY->getInputTextType() ?>" name="x_SQM_BBPY" id="x_SQM_BBPY" data-table="po_overall_cross" data-field="x_SQM_BBPY" value="<?= $Page->SQM_BBPY->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->SQM_BBPY->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->SQM_BBPY->formatPattern()) ?>"<?= $Page->SQM_BBPY->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->SQM_BBPY->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Amount_BBPY->Visible) { // Amount_BBPY ?>
    <div id="r_Amount_BBPY" class="row"<?= $Page->Amount_BBPY->rowAttributes() ?>>
        <label for="x_Amount_BBPY" class="<?= $Page->LeftColumnClass ?>"><span id="elh_po_overall_cross_Amount_BBPY"><?= $Page->Amount_BBPY->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Amount_BBPY" id="z_Amount_BBPY" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Amount_BBPY->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_po_overall_cross_Amount_BBPY" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Amount_BBPY->getInputTextType() ?>" name="x_Amount_BBPY" id="x_Amount_BBPY" data-table="po_overall_cross" data-field="x_Amount_BBPY" value="<?= $Page->Amount_BBPY->EditValue ?>" size="30" maxlength="129" placeholder="<?= HtmlEncode($Page->Amount_BBPY->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Amount_BBPY->formatPattern()) ?>"<?= $Page->Amount_BBPY->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Amount_BBPY->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fpo_overall_crosssearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpo_overall_crosssearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fpo_overall_crosssearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("po_overall_cross");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
