<?php

namespace PHPMaker2024\fibre;

// Page object
$PoOverallCrossList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { po_overall_cross: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fpo_overall_crosssrch" id="fpo_overall_crosssrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fpo_overall_crosssrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { po_overall_cross: currentTable } });
var currentForm;
var fpo_overall_crosssrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpo_overall_crosssrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["Buyer", [], fields.Buyer.isInvalid],
            ["Month", [], fields.Month.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "Buyer": <?= $Page->Buyer->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->Buyer->Visible) { // Buyer ?>
<?php
if (!$Page->Buyer->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Buyer" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Buyer->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_Buyer" class="ew-search-caption ew-label"><?= $Page->Buyer->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Buyer" id="z_Buyer" value="=">
</div>
        </div>
        <div id="el_po_overall_cross_Buyer" class="ew-search-field">
    <select
        id="x_Buyer"
        name="x_Buyer"
        class="form-select ew-select<?= $Page->Buyer->isInvalidClass() ?>"
        <?php if (!$Page->Buyer->IsNativeSelect) { ?>
        data-select2-id="fpo_overall_crosssrch_x_Buyer"
        <?php } ?>
        data-table="po_overall_cross"
        data-field="x_Buyer"
        data-value-separator="<?= $Page->Buyer->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Buyer->getPlaceHolder()) ?>"
        <?= $Page->Buyer->editAttributes() ?>>
        <?= $Page->Buyer->selectOptionListHtml("x_Buyer") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Buyer->getErrorMessage(false) ?></div>
<?= $Page->Buyer->Lookup->getParamTag($Page, "p_x_Buyer") ?>
<?php if (!$Page->Buyer->IsNativeSelect) { ?>
<script>
loadjs.ready("fpo_overall_crosssrch", function() {
    var options = { name: "x_Buyer", selectId: "fpo_overall_crosssrch_x_Buyer" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpo_overall_crosssrch.lists.Buyer?.lookupOptions.length) {
        options.data = { id: "x_Buyer", form: "fpo_overall_crosssrch" };
    } else {
        options.ajax = { id: "x_Buyer", form: "fpo_overall_crosssrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po_overall_cross.fields.Buyer.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Month->Visible) { // Month ?>
<?php
if (!$Page->Month->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Month" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Month->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_Month" class="ew-search-caption ew-label"><?= $Page->Month->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Month" id="z_Month" value="LIKE">
</div>
        </div>
        <div id="el_po_overall_cross_Month" class="ew-search-field">
<input type="<?= $Page->Month->getInputTextType() ?>" name="x_Month" id="x_Month" data-table="po_overall_cross" data-field="x_Month" value="<?= $Page->Month->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->Month->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Month->formatPattern()) ?>"<?= $Page->Month->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Month->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fpo_overall_crosssrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fpo_overall_crosssrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fpo_overall_crosssrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fpo_overall_crosssrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fpo_overall_crosssrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fpo_overall_crosssrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fpo_overall_crosssrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="po_overall_cross">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_po_overall_cross" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_po_overall_crosslist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->Buyer->Visible) { // Buyer ?>
        <th data-name="Buyer" class="<?= $Page->Buyer->headerCellClass() ?>"><div id="elh_po_overall_cross_Buyer" class="po_overall_cross_Buyer"><?= $Page->renderFieldHeader($Page->Buyer) ?></div></th>
<?php } ?>
<?php if ($Page->Month->Visible) { // Month ?>
        <th data-name="Month" class="<?= $Page->Month->headerCellClass() ?>"><div id="elh_po_overall_cross_Month" class="po_overall_cross_Month"><?= $Page->renderFieldHeader($Page->Month) ?></div></th>
<?php } ?>
<?php if ($Page->SQM_CY->Visible) { // SQM_CY ?>
        <th data-name="SQM_CY" class="<?= $Page->SQM_CY->headerCellClass() ?>"><div id="elh_po_overall_cross_SQM_CY" class="po_overall_cross_SQM_CY"><?= $Page->renderFieldHeader($Page->SQM_CY) ?></div></th>
<?php } ?>
<?php if ($Page->Amount_CY->Visible) { // Amount_CY ?>
        <th data-name="Amount_CY" class="<?= $Page->Amount_CY->headerCellClass() ?>"><div id="elh_po_overall_cross_Amount_CY" class="po_overall_cross_Amount_CY"><?= $Page->renderFieldHeader($Page->Amount_CY) ?></div></th>
<?php } ?>
<?php if ($Page->SQM_PY->Visible) { // SQM_PY ?>
        <th data-name="SQM_PY" class="<?= $Page->SQM_PY->headerCellClass() ?>"><div id="elh_po_overall_cross_SQM_PY" class="po_overall_cross_SQM_PY"><?= $Page->renderFieldHeader($Page->SQM_PY) ?></div></th>
<?php } ?>
<?php if ($Page->Amount_PY->Visible) { // Amount_PY ?>
        <th data-name="Amount_PY" class="<?= $Page->Amount_PY->headerCellClass() ?>"><div id="elh_po_overall_cross_Amount_PY" class="po_overall_cross_Amount_PY"><?= $Page->renderFieldHeader($Page->Amount_PY) ?></div></th>
<?php } ?>
<?php if ($Page->SQM_BPY->Visible) { // SQM_BPY ?>
        <th data-name="SQM_BPY" class="<?= $Page->SQM_BPY->headerCellClass() ?>"><div id="elh_po_overall_cross_SQM_BPY" class="po_overall_cross_SQM_BPY"><?= $Page->renderFieldHeader($Page->SQM_BPY) ?></div></th>
<?php } ?>
<?php if ($Page->Amount_BPY->Visible) { // Amount_BPY ?>
        <th data-name="Amount_BPY" class="<?= $Page->Amount_BPY->headerCellClass() ?>"><div id="elh_po_overall_cross_Amount_BPY" class="po_overall_cross_Amount_BPY"><?= $Page->renderFieldHeader($Page->Amount_BPY) ?></div></th>
<?php } ?>
<?php if ($Page->SQM_BBPY->Visible) { // SQM_BBPY ?>
        <th data-name="SQM_BBPY" class="<?= $Page->SQM_BBPY->headerCellClass() ?>"><div id="elh_po_overall_cross_SQM_BBPY" class="po_overall_cross_SQM_BBPY"><?= $Page->renderFieldHeader($Page->SQM_BBPY) ?></div></th>
<?php } ?>
<?php if ($Page->Amount_BBPY->Visible) { // Amount_BBPY ?>
        <th data-name="Amount_BBPY" class="<?= $Page->Amount_BBPY->headerCellClass() ?>"><div id="elh_po_overall_cross_Amount_BBPY" class="po_overall_cross_Amount_BBPY"><?= $Page->renderFieldHeader($Page->Amount_BBPY) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->Buyer->Visible) { // Buyer ?>
        <td data-name="Buyer"<?= $Page->Buyer->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_overall_cross_Buyer" class="el_po_overall_cross_Buyer">
<span<?= $Page->Buyer->viewAttributes() ?>>
<?= $Page->Buyer->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Month->Visible) { // Month ?>
        <td data-name="Month"<?= $Page->Month->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_overall_cross_Month" class="el_po_overall_cross_Month">
<span<?= $Page->Month->viewAttributes() ?>>
<?= $Page->Month->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->SQM_CY->Visible) { // SQM_CY ?>
        <td data-name="SQM_CY"<?= $Page->SQM_CY->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_overall_cross_SQM_CY" class="el_po_overall_cross_SQM_CY">
<span<?= $Page->SQM_CY->viewAttributes() ?>>
<?= $Page->SQM_CY->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Amount_CY->Visible) { // Amount_CY ?>
        <td data-name="Amount_CY"<?= $Page->Amount_CY->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_overall_cross_Amount_CY" class="el_po_overall_cross_Amount_CY">
<span<?= $Page->Amount_CY->viewAttributes() ?>>
<?= $Page->Amount_CY->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->SQM_PY->Visible) { // SQM_PY ?>
        <td data-name="SQM_PY"<?= $Page->SQM_PY->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_overall_cross_SQM_PY" class="el_po_overall_cross_SQM_PY">
<span<?= $Page->SQM_PY->viewAttributes() ?>>
<?= $Page->SQM_PY->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Amount_PY->Visible) { // Amount_PY ?>
        <td data-name="Amount_PY"<?= $Page->Amount_PY->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_overall_cross_Amount_PY" class="el_po_overall_cross_Amount_PY">
<span<?= $Page->Amount_PY->viewAttributes() ?>>
<?= $Page->Amount_PY->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->SQM_BPY->Visible) { // SQM_BPY ?>
        <td data-name="SQM_BPY"<?= $Page->SQM_BPY->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_overall_cross_SQM_BPY" class="el_po_overall_cross_SQM_BPY">
<span<?= $Page->SQM_BPY->viewAttributes() ?>>
<?= $Page->SQM_BPY->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Amount_BPY->Visible) { // Amount_BPY ?>
        <td data-name="Amount_BPY"<?= $Page->Amount_BPY->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_overall_cross_Amount_BPY" class="el_po_overall_cross_Amount_BPY">
<span<?= $Page->Amount_BPY->viewAttributes() ?>>
<?= $Page->Amount_BPY->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->SQM_BBPY->Visible) { // SQM_BBPY ?>
        <td data-name="SQM_BBPY"<?= $Page->SQM_BBPY->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_overall_cross_SQM_BBPY" class="el_po_overall_cross_SQM_BBPY">
<span<?= $Page->SQM_BBPY->viewAttributes() ?>>
<?= $Page->SQM_BBPY->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Amount_BBPY->Visible) { // Amount_BBPY ?>
        <td data-name="Amount_BBPY"<?= $Page->Amount_BBPY->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_po_overall_cross_Amount_BBPY" class="el_po_overall_cross_Amount_BBPY">
<span<?= $Page->Amount_BBPY->viewAttributes() ?>>
<?= $Page->Amount_BBPY->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("po_overall_cross");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
