<?php

namespace PHPMaker2024\fibre;

// Page object
$PoAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { po: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fpoadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fpoadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["order_type", [fields.order_type.visible && fields.order_type.required ? ew.Validators.required(fields.order_type.caption) : null], fields.order_type.isInvalid],
            ["buyer_id", [fields.buyer_id.visible && fields.buyer_id.required ? ew.Validators.required(fields.buyer_id.caption) : null], fields.buyer_id.isInvalid],
            ["buyer_order_no", [fields.buyer_order_no.visible && fields.buyer_order_no.required ? ew.Validators.required(fields.buyer_order_no.caption) : null], fields.buyer_order_no.isInvalid],
            ["buyer_order_date", [fields.buyer_order_date.visible && fields.buyer_order_date.required ? ew.Validators.required(fields.buyer_order_date.caption) : null, ew.Validators.datetime(fields.buyer_order_date.clientFormatPattern)], fields.buyer_order_date.isInvalid],
            ["cart_id", [fields.cart_id.visible && fields.cart_id.required ? ew.Validators.required(fields.cart_id.caption) : null], fields.cart_id.isInvalid],
            ["buyer_product_ref", [fields.buyer_product_ref.visible && fields.buyer_product_ref.required ? ew.Validators.required(fields.buyer_product_ref.caption) : null], fields.buyer_product_ref.isInvalid],
            ["grp", [fields.grp.visible && fields.grp.required ? ew.Validators.required(fields.grp.caption) : null], fields.grp.isInvalid],
            ["s_grp", [fields.s_grp.visible && fields.s_grp.required ? ew.Validators.required(fields.s_grp.caption) : null], fields.s_grp.isInvalid],
            ["product", [fields.product.visible && fields.product.required ? ew.Validators.required(fields.product.caption) : null], fields.product.isInvalid],
            ["rid", [fields.rid.visible && fields.rid.required ? ew.Validators.required(fields.rid.caption) : null], fields.rid.isInvalid],
            ["despatch_date", [fields.despatch_date.visible && fields.despatch_date.required ? ew.Validators.required(fields.despatch_date.caption) : null, ew.Validators.datetime(fields.despatch_date.clientFormatPattern)], fields.despatch_date.isInvalid],
            ["despatch_week", [fields.despatch_week.visible && fields.despatch_week.required ? ew.Validators.required(fields.despatch_week.caption) : null], fields.despatch_week.isInvalid],
            ["fob_date", [fields.fob_date.visible && fields.fob_date.required ? ew.Validators.required(fields.fob_date.caption) : null, ew.Validators.datetime(fields.fob_date.clientFormatPattern)], fields.fob_date.isInvalid],
            ["part_dispatch", [fields.part_dispatch.visible && fields.part_dispatch.required ? ew.Validators.required(fields.part_dispatch.caption) : null], fields.part_dispatch.isInvalid],
            ["payment_terms", [fields.payment_terms.visible && fields.payment_terms.required ? ew.Validators.required(fields.payment_terms.caption) : null], fields.payment_terms.isInvalid],
            ["transport_terms", [fields.transport_terms.visible && fields.transport_terms.required ? ew.Validators.required(fields.transport_terms.caption) : null], fields.transport_terms.isInvalid],
            ["buyer_shipping_id", [fields.buyer_shipping_id.visible && fields.buyer_shipping_id.required ? ew.Validators.required(fields.buyer_shipping_id.caption) : null, ew.Validators.integer], fields.buyer_shipping_id.isInvalid],
            ["description_04", [fields.description_04.visible && fields.description_04.required ? ew.Validators.required(fields.description_04.caption) : null, ew.Validators.integer], fields.description_04.isInvalid],
            ["description_03", [fields.description_03.visible && fields.description_03.required ? ew.Validators.required(fields.description_03.caption) : null], fields.description_03.isInvalid],
            ["description_01", [fields.description_01.visible && fields.description_01.required ? ew.Validators.required(fields.description_01.caption) : null, ew.Validators.float], fields.description_01.isInvalid],
            ["description_02", [fields.description_02.visible && fields.description_02.required ? ew.Validators.required(fields.description_02.caption) : null, ew.Validators.float], fields.description_02.isInvalid],
            ["description_07", [fields.description_07.visible && fields.description_07.required ? ew.Validators.required(fields.description_07.caption) : null, ew.Validators.float], fields.description_07.isInvalid],
            ["description_20", [fields.description_20.visible && fields.description_20.required ? ew.Validators.required(fields.description_20.caption) : null], fields.description_20.isInvalid],
            ["description_17", [fields.description_17.visible && fields.description_17.required ? ew.Validators.required(fields.description_17.caption) : null, ew.Validators.float], fields.description_17.isInvalid],
            ["description_18", [fields.description_18.visible && fields.description_18.required ? ew.Validators.required(fields.description_18.caption) : null, ew.Validators.float], fields.description_18.isInvalid],
            ["description_19", [fields.description_19.visible && fields.description_19.required ? ew.Validators.required(fields.description_19.caption) : null, ew.Validators.float], fields.description_19.isInvalid],
            ["quantity", [fields.quantity.visible && fields.quantity.required ? ew.Validators.required(fields.quantity.caption) : null], fields.quantity.isInvalid],
            ["price", [fields.price.visible && fields.price.required ? ew.Validators.required(fields.price.caption) : null], fields.price.isInvalid],
            ["currency", [fields.currency.visible && fields.currency.required ? ew.Validators.required(fields.currency.caption) : null], fields.currency.isInvalid],
            ["amount", [fields.amount.visible && fields.amount.required ? ew.Validators.required(fields.amount.caption) : null, ew.Validators.float], fields.amount.isInvalid],
            ["cbm", [fields.cbm.visible && fields.cbm.required ? ew.Validators.required(fields.cbm.caption) : null, ew.Validators.float], fields.cbm.isInvalid],
            ["buyer_size", [fields.buyer_size.visible && fields.buyer_size.required ? ew.Validators.required(fields.buyer_size.caption) : null], fields.buyer_size.isInvalid],
            ["description_05", [fields.description_05.visible && fields.description_05.required ? ew.Validators.required(fields.description_05.caption) : null], fields.description_05.isInvalid],
            ["description_06", [fields.description_06.visible && fields.description_06.required ? ew.Validators.required(fields.description_06.caption) : null], fields.description_06.isInvalid],
            ["description_08", [fields.description_08.visible && fields.description_08.required ? ew.Validators.required(fields.description_08.caption) : null, ew.Validators.float], fields.description_08.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid],
            ["buyer_instruction", [fields.buyer_instruction.visible && fields.buyer_instruction.required ? ew.Validators.required(fields.buyer_instruction.caption) : null], fields.buyer_instruction.isInvalid],
            ["d_09_head", [fields.d_09_head.visible && fields.d_09_head.required ? ew.Validators.required(fields.d_09_head.caption) : null], fields.d_09_head.isInvalid],
            ["description_09", [fields.description_09.visible && fields.description_09.required ? ew.Validators.required(fields.description_09.caption) : null], fields.description_09.isInvalid],
            ["d_10_head", [fields.d_10_head.visible && fields.d_10_head.required ? ew.Validators.required(fields.d_10_head.caption) : null], fields.d_10_head.isInvalid],
            ["description_10", [fields.description_10.visible && fields.description_10.required ? ew.Validators.required(fields.description_10.caption) : null], fields.description_10.isInvalid],
            ["d_11_head", [fields.d_11_head.visible && fields.d_11_head.required ? ew.Validators.required(fields.d_11_head.caption) : null], fields.d_11_head.isInvalid],
            ["description_11", [fields.description_11.visible && fields.description_11.required ? ew.Validators.required(fields.description_11.caption) : null], fields.description_11.isInvalid],
            ["d_12_head", [fields.d_12_head.visible && fields.d_12_head.required ? ew.Validators.required(fields.d_12_head.caption) : null], fields.d_12_head.isInvalid],
            ["description_12", [fields.description_12.visible && fields.description_12.required ? ew.Validators.required(fields.description_12.caption) : null], fields.description_12.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Multi-Page
        .setMultiPage(true)

        // Dynamic selection lists
        .setLists({
            "order_type": <?= $Page->order_type->toClientList($Page) ?>,
            "buyer_id": <?= $Page->buyer_id->toClientList($Page) ?>,
            "cart_id": <?= $Page->cart_id->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "despatch_week": <?= $Page->despatch_week->toClientList($Page) ?>,
            "part_dispatch": <?= $Page->part_dispatch->toClientList($Page) ?>,
            "payment_terms": <?= $Page->payment_terms->toClientList($Page) ?>,
            "description_04": <?= $Page->description_04->toClientList($Page) ?>,
            "description_03": <?= $Page->description_03->toClientList($Page) ?>,
            "description_20": <?= $Page->description_20->toClientList($Page) ?>,
            "currency": <?= $Page->currency->toClientList($Page) ?>,
            "description_05": <?= $Page->description_05->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
            "d_09_head": <?= $Page->d_09_head->toClientList($Page) ?>,
            "d_10_head": <?= $Page->d_10_head->toClientList($Page) ?>,
            "d_11_head": <?= $Page->d_11_head->toClientList($Page) ?>,
            "d_12_head": <?= $Page->d_12_head->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fpoadd" id="fpoadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="po">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<?php if ($Page->MultiPages->Items[0]->Visible) { ?>
<div class="ew-add-div"><!-- page0 -->
<?php if ($Page->order_type->Visible) { // order_type ?>
    <div id="r_order_type"<?= $Page->order_type->rowAttributes() ?>>
        <label id="elh_po_order_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->order_type->caption() ?><?= $Page->order_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->order_type->cellAttributes() ?>>
<span id="el_po_order_type">
<template id="tp_x_order_type">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="po" data-field="x_order_type" name="x_order_type" id="x_order_type"<?= $Page->order_type->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_order_type" class="ew-item-list"></div>
<selection-list hidden
    id="x_order_type"
    name="x_order_type"
    value="<?= HtmlEncode($Page->order_type->CurrentValue) ?>"
    data-type="select-one"
    data-template="tp_x_order_type"
    data-target="dsl_x_order_type"
    data-repeatcolumn="5"
    class="form-control<?= $Page->order_type->isInvalidClass() ?>"
    data-table="po"
    data-field="x_order_type"
    data-page="0"
    data-value-separator="<?= $Page->order_type->displayValueSeparatorAttribute() ?>"
    <?= $Page->order_type->editAttributes() ?>></selection-list>
<?= $Page->order_type->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->order_type->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->cart_id->Visible) { // cart_id ?>
    <div id="r_cart_id"<?= $Page->cart_id->rowAttributes() ?>>
        <label id="elh_po_cart_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->cart_id->caption() ?><?= $Page->cart_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->cart_id->cellAttributes() ?>>
<span id="el_po_cart_id">
<template id="tp_x_cart_id">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="po" data-field="x_cart_id" name="x_cart_id" id="x_cart_id"<?= $Page->cart_id->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_cart_id" class="ew-item-list"></div>
<selection-list hidden
    id="x_cart_id[]"
    name="x_cart_id[]"
    value="<?= HtmlEncode($Page->cart_id->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_cart_id"
    data-target="dsl_x_cart_id"
    data-repeatcolumn="1"
    class="form-control<?= $Page->cart_id->isInvalidClass() ?>"
    data-table="po"
    data-field="x_cart_id"
    data-page="0"
    data-value-separator="<?= $Page->cart_id->displayValueSeparatorAttribute() ?>"
    <?= $Page->cart_id->editAttributes() ?>></selection-list>
<?= $Page->cart_id->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->cart_id->getErrorMessage() ?></div>
<?= $Page->cart_id->Lookup->getParamTag($Page, "p_x_cart_id") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp"<?= $Page->grp->rowAttributes() ?>>
        <label id="elh_po_grp" for="x_grp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->grp->caption() ?><?= $Page->grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->grp->cellAttributes() ?>>
<span id="el_po_grp">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fpoadd_x_grp"
        <?php } ?>
        data-table="po"
        data-field="x_grp"
        data-page="0"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <?= $Page->grp->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage() ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fpoadd", function() {
    var options = { name: "x_grp", selectId: "fpoadd_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpoadd.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fpoadd" };
    } else {
        options.ajax = { id: "x_grp", form: "fpoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp"<?= $Page->s_grp->rowAttributes() ?>>
        <label id="elh_po_s_grp" for="x_s_grp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->s_grp->caption() ?><?= $Page->s_grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->s_grp->cellAttributes() ?>>
<span id="el_po_s_grp">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="fpoadd_x_s_grp"
        <?php } ?>
        data-table="po"
        data-field="x_s_grp"
        data-page="0"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <?= $Page->s_grp->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage() ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fpoadd", function() {
    var options = { name: "x_s_grp", selectId: "fpoadd_x_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpoadd.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "fpoadd" };
    } else {
        options.ajax = { id: "x_s_grp", form: "fpoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product"<?= $Page->product->rowAttributes() ?>>
        <label id="elh_po_product" for="x_product" class="<?= $Page->LeftColumnClass ?>"><?= $Page->product->caption() ?><?= $Page->product->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->product->cellAttributes() ?>>
<span id="el_po_product">
<div class="input-group flex-nowrap">
    <select
        id="x_product"
        name="x_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="fpoadd_x_product"
        <?php } ?>
        data-table="po"
        data-field="x_product"
        data-page="0"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "product") && !$Page->product->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_product" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->product->caption() ?>" data-title="<?= $Page->product->caption() ?>" data-ew-action="add-option" data-el="x_product" data-url="<?= GetUrl("productaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->product->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->product->getErrorMessage() ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fpoadd", function() {
    var options = { name: "x_product", selectId: "fpoadd_x_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpoadd.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "fpoadd" };
    } else {
        options.ajax = { id: "x_product", form: "fpoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
    <div id="r_rid"<?= $Page->rid->rowAttributes() ?>>
        <label id="elh_po_rid" class="<?= $Page->LeftColumnClass ?>"><?= $Page->rid->caption() ?><?= $Page->rid->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->rid->cellAttributes() ?>>
<span id="el_po_rid">
<template id="tp_x_rid">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="po" data-field="x_rid" name="x_rid" id="x_rid"<?= $Page->rid->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_rid" class="ew-item-list"></div>
<selection-list hidden
    id="x_rid"
    name="x_rid"
    value="<?= HtmlEncode($Page->rid->CurrentValue) ?>"
    data-type="select-one"
    data-template="tp_x_rid"
    data-target="dsl_x_rid"
    data-repeatcolumn="1"
    class="form-control<?= $Page->rid->isInvalidClass() ?>"
    data-table="po"
    data-field="x_rid"
    data-page="0"
    data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>"
    data-ew-action="autofill"
    <?= $Page->rid->editAttributes() ?>></selection-list>
<?= $Page->rid->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->rid->getErrorMessage() ?></div>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="accordion ew-accordion" id="accordion_PoAdd"><!-- multi-page accordion -->
<div class="accordion-item ew-accordion-item"><!-- multi-page .accordion-item -->
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(1)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(1)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_po1"><?= $Page->pageCaption(1) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(1)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_po1"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->buyer_id->Visible) { // buyer_id ?>
    <div id="r_buyer_id"<?= $Page->buyer_id->rowAttributes() ?>>
        <label id="elh_po_buyer_id" for="x_buyer_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->buyer_id->caption() ?><?= $Page->buyer_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->buyer_id->cellAttributes() ?>>
<span id="el_po_buyer_id">
<div class="input-group flex-nowrap">
    <select
        id="x_buyer_id"
        name="x_buyer_id"
        class="form-select ew-select<?= $Page->buyer_id->isInvalidClass() ?>"
        <?php if (!$Page->buyer_id->IsNativeSelect) { ?>
        data-select2-id="fpoadd_x_buyer_id"
        <?php } ?>
        data-table="po"
        data-field="x_buyer_id"
        data-page="1"
        data-value-separator="<?= $Page->buyer_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyer_id->getPlaceHolder()) ?>"
        <?= $Page->buyer_id->editAttributes() ?>>
        <?= $Page->buyer_id->selectOptionListHtml("x_buyer_id") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "buyer") && !$Page->buyer_id->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_buyer_id" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->buyer_id->caption() ?>" data-title="<?= $Page->buyer_id->caption() ?>" data-ew-action="add-option" data-el="x_buyer_id" data-url="<?= GetUrl("buyeraddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->buyer_id->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->buyer_id->getErrorMessage() ?></div>
<?= $Page->buyer_id->Lookup->getParamTag($Page, "p_x_buyer_id") ?>
<?php if (!$Page->buyer_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fpoadd", function() {
    var options = { name: "x_buyer_id", selectId: "fpoadd_x_buyer_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpoadd.lists.buyer_id?.lookupOptions.length) {
        options.data = { id: "x_buyer_id", form: "fpoadd" };
    } else {
        options.ajax = { id: "x_buyer_id", form: "fpoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po.fields.buyer_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->buyer_order_no->Visible) { // buyer_order_no ?>
    <div id="r_buyer_order_no"<?= $Page->buyer_order_no->rowAttributes() ?>>
        <label id="elh_po_buyer_order_no" for="x_buyer_order_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->buyer_order_no->caption() ?><?= $Page->buyer_order_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->buyer_order_no->cellAttributes() ?>>
<span id="el_po_buyer_order_no">
<input type="<?= $Page->buyer_order_no->getInputTextType() ?>" name="x_buyer_order_no" id="x_buyer_order_no" data-table="po" data-field="x_buyer_order_no" value="<?= $Page->buyer_order_no->EditValue ?>" data-page="1" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->buyer_order_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_order_no->formatPattern()) ?>"<?= $Page->buyer_order_no->editAttributes() ?> aria-describedby="x_buyer_order_no_help">
<?= $Page->buyer_order_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->buyer_order_no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->buyer_order_date->Visible) { // buyer_order_date ?>
    <div id="r_buyer_order_date"<?= $Page->buyer_order_date->rowAttributes() ?>>
        <label id="elh_po_buyer_order_date" for="x_buyer_order_date" class="<?= $Page->LeftColumnClass ?>"><?= $Page->buyer_order_date->caption() ?><?= $Page->buyer_order_date->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->buyer_order_date->cellAttributes() ?>>
<span id="el_po_buyer_order_date">
<input type="<?= $Page->buyer_order_date->getInputTextType() ?>" name="x_buyer_order_date" id="x_buyer_order_date" data-table="po" data-field="x_buyer_order_date" value="<?= $Page->buyer_order_date->EditValue ?>" data-page="1" placeholder="<?= HtmlEncode($Page->buyer_order_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_order_date->formatPattern()) ?>"<?= $Page->buyer_order_date->editAttributes() ?> aria-describedby="x_buyer_order_date_help">
<?= $Page->buyer_order_date->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->buyer_order_date->getErrorMessage() ?></div>
<?php if (!$Page->buyer_order_date->ReadOnly && !$Page->buyer_order_date->Disabled && !isset($Page->buyer_order_date->EditAttrs["readonly"]) && !isset($Page->buyer_order_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpoadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpoadd", "x_buyer_order_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->buyer_product_ref->Visible) { // buyer_product_ref ?>
    <div id="r_buyer_product_ref"<?= $Page->buyer_product_ref->rowAttributes() ?>>
        <label id="elh_po_buyer_product_ref" for="x_buyer_product_ref" class="<?= $Page->LeftColumnClass ?>"><?= $Page->buyer_product_ref->caption() ?><?= $Page->buyer_product_ref->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->buyer_product_ref->cellAttributes() ?>>
<span id="el_po_buyer_product_ref">
<input type="<?= $Page->buyer_product_ref->getInputTextType() ?>" name="x_buyer_product_ref" id="x_buyer_product_ref" data-table="po" data-field="x_buyer_product_ref" value="<?= $Page->buyer_product_ref->EditValue ?>" data-page="1" size="30" maxlength="65535" placeholder="<?= HtmlEncode($Page->buyer_product_ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_product_ref->formatPattern()) ?>"<?= $Page->buyer_product_ref->editAttributes() ?> aria-describedby="x_buyer_product_ref_help">
<?= $Page->buyer_product_ref->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->buyer_product_ref->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->despatch_date->Visible) { // despatch_date ?>
    <div id="r_despatch_date"<?= $Page->despatch_date->rowAttributes() ?>>
        <label id="elh_po_despatch_date" for="x_despatch_date" class="<?= $Page->LeftColumnClass ?>"><?= $Page->despatch_date->caption() ?><?= $Page->despatch_date->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->despatch_date->cellAttributes() ?>>
<span id="el_po_despatch_date">
<input type="<?= $Page->despatch_date->getInputTextType() ?>" name="x_despatch_date" id="x_despatch_date" data-table="po" data-field="x_despatch_date" value="<?= $Page->despatch_date->EditValue ?>" data-page="1" placeholder="<?= HtmlEncode($Page->despatch_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->despatch_date->formatPattern()) ?>"<?= $Page->despatch_date->editAttributes() ?> aria-describedby="x_despatch_date_help">
<?= $Page->despatch_date->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->despatch_date->getErrorMessage() ?></div>
<?php if (!$Page->despatch_date->ReadOnly && !$Page->despatch_date->Disabled && !isset($Page->despatch_date->EditAttrs["readonly"]) && !isset($Page->despatch_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpoadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpoadd", "x_despatch_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->despatch_week->Visible) { // despatch_week ?>
    <div id="r_despatch_week"<?= $Page->despatch_week->rowAttributes() ?>>
        <label id="elh_po_despatch_week" for="x_despatch_week" class="<?= $Page->LeftColumnClass ?>"><?= $Page->despatch_week->caption() ?><?= $Page->despatch_week->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->despatch_week->cellAttributes() ?>>
<span id="el_po_despatch_week">
    <select
        id="x_despatch_week"
        name="x_despatch_week"
        class="form-select ew-select<?= $Page->despatch_week->isInvalidClass() ?>"
        <?php if (!$Page->despatch_week->IsNativeSelect) { ?>
        data-select2-id="fpoadd_x_despatch_week"
        <?php } ?>
        data-table="po"
        data-field="x_despatch_week"
        data-page="1"
        data-value-separator="<?= $Page->despatch_week->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->despatch_week->getPlaceHolder()) ?>"
        <?= $Page->despatch_week->editAttributes() ?>>
        <?= $Page->despatch_week->selectOptionListHtml("x_despatch_week") ?>
    </select>
    <?= $Page->despatch_week->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->despatch_week->getErrorMessage() ?></div>
<?= $Page->despatch_week->Lookup->getParamTag($Page, "p_x_despatch_week") ?>
<?php if (!$Page->despatch_week->IsNativeSelect) { ?>
<script>
loadjs.ready("fpoadd", function() {
    var options = { name: "x_despatch_week", selectId: "fpoadd_x_despatch_week" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpoadd.lists.despatch_week?.lookupOptions.length) {
        options.data = { id: "x_despatch_week", form: "fpoadd" };
    } else {
        options.ajax = { id: "x_despatch_week", form: "fpoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po.fields.despatch_week.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->fob_date->Visible) { // fob_date ?>
    <div id="r_fob_date"<?= $Page->fob_date->rowAttributes() ?>>
        <label id="elh_po_fob_date" for="x_fob_date" class="<?= $Page->LeftColumnClass ?>"><?= $Page->fob_date->caption() ?><?= $Page->fob_date->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->fob_date->cellAttributes() ?>>
<span id="el_po_fob_date">
<input type="<?= $Page->fob_date->getInputTextType() ?>" name="x_fob_date" id="x_fob_date" data-table="po" data-field="x_fob_date" value="<?= $Page->fob_date->EditValue ?>" data-page="1" placeholder="<?= HtmlEncode($Page->fob_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->fob_date->formatPattern()) ?>"<?= $Page->fob_date->editAttributes() ?> aria-describedby="x_fob_date_help">
<?= $Page->fob_date->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->fob_date->getErrorMessage() ?></div>
<?php if (!$Page->fob_date->ReadOnly && !$Page->fob_date->Disabled && !isset($Page->fob_date->EditAttrs["readonly"]) && !isset($Page->fob_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpoadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpoadd", "x_fob_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->part_dispatch->Visible) { // part_dispatch ?>
    <div id="r_part_dispatch"<?= $Page->part_dispatch->rowAttributes() ?>>
        <label id="elh_po_part_dispatch" for="x_part_dispatch" class="<?= $Page->LeftColumnClass ?>"><?= $Page->part_dispatch->caption() ?><?= $Page->part_dispatch->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->part_dispatch->cellAttributes() ?>>
<span id="el_po_part_dispatch">
    <select
        id="x_part_dispatch"
        name="x_part_dispatch"
        class="form-select ew-select<?= $Page->part_dispatch->isInvalidClass() ?>"
        <?php if (!$Page->part_dispatch->IsNativeSelect) { ?>
        data-select2-id="fpoadd_x_part_dispatch"
        <?php } ?>
        data-table="po"
        data-field="x_part_dispatch"
        data-page="1"
        data-value-separator="<?= $Page->part_dispatch->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->part_dispatch->getPlaceHolder()) ?>"
        <?= $Page->part_dispatch->editAttributes() ?>>
        <?= $Page->part_dispatch->selectOptionListHtml("x_part_dispatch") ?>
    </select>
    <?= $Page->part_dispatch->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->part_dispatch->getErrorMessage() ?></div>
<?php if (!$Page->part_dispatch->IsNativeSelect) { ?>
<script>
loadjs.ready("fpoadd", function() {
    var options = { name: "x_part_dispatch", selectId: "fpoadd_x_part_dispatch" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpoadd.lists.part_dispatch?.lookupOptions.length) {
        options.data = { id: "x_part_dispatch", form: "fpoadd" };
    } else {
        options.ajax = { id: "x_part_dispatch", form: "fpoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po.fields.part_dispatch.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->payment_terms->Visible) { // payment_terms ?>
    <div id="r_payment_terms"<?= $Page->payment_terms->rowAttributes() ?>>
        <label id="elh_po_payment_terms" for="x_payment_terms" class="<?= $Page->LeftColumnClass ?>"><?= $Page->payment_terms->caption() ?><?= $Page->payment_terms->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->payment_terms->cellAttributes() ?>>
<span id="el_po_payment_terms">
<div class="input-group flex-nowrap">
    <select
        id="x_payment_terms"
        name="x_payment_terms"
        class="form-select ew-select<?= $Page->payment_terms->isInvalidClass() ?>"
        <?php if (!$Page->payment_terms->IsNativeSelect) { ?>
        data-select2-id="fpoadd_x_payment_terms"
        <?php } ?>
        data-table="po"
        data-field="x_payment_terms"
        data-page="1"
        data-value-separator="<?= $Page->payment_terms->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->payment_terms->getPlaceHolder()) ?>"
        <?= $Page->payment_terms->editAttributes() ?>>
        <?= $Page->payment_terms->selectOptionListHtml("x_payment_terms") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "misc") && !$Page->payment_terms->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_payment_terms" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->payment_terms->caption() ?>" data-title="<?= $Page->payment_terms->caption() ?>" data-ew-action="add-option" data-el="x_payment_terms" data-url="<?= GetUrl("miscaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->payment_terms->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->payment_terms->getErrorMessage() ?></div>
<?= $Page->payment_terms->Lookup->getParamTag($Page, "p_x_payment_terms") ?>
<?php if (!$Page->payment_terms->IsNativeSelect) { ?>
<script>
loadjs.ready("fpoadd", function() {
    var options = { name: "x_payment_terms", selectId: "fpoadd_x_payment_terms" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpoadd.lists.payment_terms?.lookupOptions.length) {
        options.data = { id: "x_payment_terms", form: "fpoadd" };
    } else {
        options.ajax = { id: "x_payment_terms", form: "fpoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po.fields.payment_terms.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->transport_terms->Visible) { // transport_terms ?>
    <div id="r_transport_terms"<?= $Page->transport_terms->rowAttributes() ?>>
        <label id="elh_po_transport_terms" for="x_transport_terms" class="<?= $Page->LeftColumnClass ?>"><?= $Page->transport_terms->caption() ?><?= $Page->transport_terms->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->transport_terms->cellAttributes() ?>>
<span id="el_po_transport_terms">
<input type="<?= $Page->transport_terms->getInputTextType() ?>" name="x_transport_terms" id="x_transport_terms" data-table="po" data-field="x_transport_terms" value="<?= $Page->transport_terms->EditValue ?>" data-page="1" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->transport_terms->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->transport_terms->formatPattern()) ?>"<?= $Page->transport_terms->editAttributes() ?> aria-describedby="x_transport_terms_help">
<?= $Page->transport_terms->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->transport_terms->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->buyer_shipping_id->Visible) { // buyer_shipping _id ?>
    <div id="r_buyer_shipping_id"<?= $Page->buyer_shipping_id->rowAttributes() ?>>
        <label id="elh_po_buyer_shipping_id" for="x_buyer_shipping_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->buyer_shipping_id->caption() ?><?= $Page->buyer_shipping_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->buyer_shipping_id->cellAttributes() ?>>
<span id="el_po_buyer_shipping_id">
<input type="<?= $Page->buyer_shipping_id->getInputTextType() ?>" name="x_buyer_shipping_id" id="x_buyer_shipping_id" data-table="po" data-field="x_buyer_shipping_id" value="<?= $Page->buyer_shipping_id->EditValue ?>" data-page="1" size="30" placeholder="<?= HtmlEncode($Page->buyer_shipping_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_shipping_id->formatPattern()) ?>"<?= $Page->buyer_shipping_id->editAttributes() ?> aria-describedby="x_buyer_shipping_id_help">
<?= $Page->buyer_shipping_id->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->buyer_shipping_id->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->currency->Visible) { // currency ?>
    <div id="r_currency"<?= $Page->currency->rowAttributes() ?>>
        <label id="elh_po_currency" for="x_currency" class="<?= $Page->LeftColumnClass ?>"><?= $Page->currency->caption() ?><?= $Page->currency->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->currency->cellAttributes() ?>>
<span id="el_po_currency">
    <select
        id="x_currency"
        name="x_currency"
        class="form-select ew-select<?= $Page->currency->isInvalidClass() ?>"
        <?php if (!$Page->currency->IsNativeSelect) { ?>
        data-select2-id="fpoadd_x_currency"
        <?php } ?>
        data-table="po"
        data-field="x_currency"
        data-page="1"
        data-value-separator="<?= $Page->currency->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->currency->getPlaceHolder()) ?>"
        <?= $Page->currency->editAttributes() ?>>
        <?= $Page->currency->selectOptionListHtml("x_currency") ?>
    </select>
    <?= $Page->currency->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->currency->getErrorMessage() ?></div>
<?= $Page->currency->Lookup->getParamTag($Page, "p_x_currency") ?>
<?php if (!$Page->currency->IsNativeSelect) { ?>
<script>
loadjs.ready("fpoadd", function() {
    var options = { name: "x_currency", selectId: "fpoadd_x_currency" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpoadd.lists.currency?.lookupOptions.length) {
        options.data = { id: "x_currency", form: "fpoadd" };
    } else {
        options.ajax = { id: "x_currency", form: "fpoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po.fields.currency.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <label id="elh_po_remarks" for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->remarks->caption() ?><?= $Page->remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->remarks->cellAttributes() ?>>
<span id="el_po_remarks">
<textarea data-table="po" data-field="x_remarks" data-page="1" name="x_remarks" id="x_remarks" cols="30" rows="4" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>"<?= $Page->remarks->editAttributes() ?> aria-describedby="x_remarks_help"><?= $Page->remarks->EditValue ?></textarea>
<?= $Page->remarks->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->buyer_instruction->Visible) { // buyer_instruction ?>
    <div id="r_buyer_instruction"<?= $Page->buyer_instruction->rowAttributes() ?>>
        <label id="elh_po_buyer_instruction" for="x_buyer_instruction" class="<?= $Page->LeftColumnClass ?>"><?= $Page->buyer_instruction->caption() ?><?= $Page->buyer_instruction->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->buyer_instruction->cellAttributes() ?>>
<span id="el_po_buyer_instruction">
<textarea data-table="po" data-field="x_buyer_instruction" data-page="1" name="x_buyer_instruction" id="x_buyer_instruction" cols="30" rows="4" placeholder="<?= HtmlEncode($Page->buyer_instruction->getPlaceHolder()) ?>"<?= $Page->buyer_instruction->editAttributes() ?> aria-describedby="x_buyer_instruction_help"><?= $Page->buyer_instruction->EditValue ?></textarea>
<?= $Page->buyer_instruction->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->buyer_instruction->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div><!-- /multi-page .accordion-item -->
<div class="accordion-item ew-accordion-item"><!-- multi-page .accordion-item -->
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(2)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(2)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_po2"><?= $Page->pageCaption(2) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(2)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_po2"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->description_04->Visible) { // description_04 ?>
    <div id="r_description_04"<?= $Page->description_04->rowAttributes() ?>>
        <label id="elh_po_description_04" class="<?= $Page->LeftColumnClass ?>"><?= $Page->description_04->caption() ?><?= $Page->description_04->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->description_04->cellAttributes() ?>>
<span id="el_po_description_04">
<?php
if (IsRTL()) {
    $Page->description_04->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_description_04" class="ew-auto-suggest">
    <input type="<?= $Page->description_04->getInputTextType() ?>" class="form-control" name="sv_x_description_04" id="sv_x_description_04" value="<?= RemoveHtml($Page->description_04->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->description_04->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->description_04->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description_04->formatPattern()) ?>"<?= $Page->description_04->editAttributes() ?> aria-describedby="x_description_04_help">
</span>
<selection-list hidden class="form-control" data-table="po" data-field="x_description_04" data-input="sv_x_description_04" data-page="2" data-value-separator="<?= $Page->description_04->displayValueSeparatorAttribute() ?>" name="x_description_04" id="x_description_04" value="<?= HtmlEncode($Page->description_04->CurrentValue) ?>"></selection-list>
<?= $Page->description_04->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->description_04->getErrorMessage() ?></div>
<script>
loadjs.ready("fpoadd", function() {
    fpoadd.createAutoSuggest(Object.assign({"id":"x_description_04","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->description_04->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.po.fields.description_04.autoSuggestOptions));
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->description_03->Visible) { // description_03 ?>
    <div id="r_description_03"<?= $Page->description_03->rowAttributes() ?>>
        <label id="elh_po_description_03" for="x_description_03" class="<?= $Page->LeftColumnClass ?>"><?= $Page->description_03->caption() ?><?= $Page->description_03->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->description_03->cellAttributes() ?>>
<span id="el_po_description_03">
    <select
        id="x_description_03"
        name="x_description_03"
        class="form-select ew-select<?= $Page->description_03->isInvalidClass() ?>"
        <?php if (!$Page->description_03->IsNativeSelect) { ?>
        data-select2-id="fpoadd_x_description_03"
        <?php } ?>
        data-table="po"
        data-field="x_description_03"
        data-page="2"
        data-value-separator="<?= $Page->description_03->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->description_03->getPlaceHolder()) ?>"
        <?= $Page->description_03->editAttributes() ?>>
        <?= $Page->description_03->selectOptionListHtml("x_description_03") ?>
    </select>
    <?= $Page->description_03->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->description_03->getErrorMessage() ?></div>
<?php if (!$Page->description_03->IsNativeSelect) { ?>
<script>
loadjs.ready("fpoadd", function() {
    var options = { name: "x_description_03", selectId: "fpoadd_x_description_03" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpoadd.lists.description_03?.lookupOptions.length) {
        options.data = { id: "x_description_03", form: "fpoadd" };
    } else {
        options.ajax = { id: "x_description_03", form: "fpoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po.fields.description_03.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->description_01->Visible) { // description_01 ?>
    <div id="r_description_01"<?= $Page->description_01->rowAttributes() ?>>
        <label id="elh_po_description_01" for="x_description_01" class="<?= $Page->LeftColumnClass ?>"><?= $Page->description_01->caption() ?><?= $Page->description_01->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->description_01->cellAttributes() ?>>
<span id="el_po_description_01">
<input type="<?= $Page->description_01->getInputTextType() ?>" name="x_description_01" id="x_description_01" data-table="po" data-field="x_description_01" value="<?= $Page->description_01->EditValue ?>" data-page="2" size="30" placeholder="<?= HtmlEncode($Page->description_01->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description_01->formatPattern()) ?>"<?= $Page->description_01->editAttributes() ?> aria-describedby="x_description_01_help">
<?= $Page->description_01->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->description_01->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->description_02->Visible) { // description_02 ?>
    <div id="r_description_02"<?= $Page->description_02->rowAttributes() ?>>
        <label id="elh_po_description_02" for="x_description_02" class="<?= $Page->LeftColumnClass ?>"><?= $Page->description_02->caption() ?><?= $Page->description_02->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->description_02->cellAttributes() ?>>
<span id="el_po_description_02">
<input type="<?= $Page->description_02->getInputTextType() ?>" name="x_description_02" id="x_description_02" data-table="po" data-field="x_description_02" value="<?= $Page->description_02->EditValue ?>" data-page="2" size="30" placeholder="<?= HtmlEncode($Page->description_02->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description_02->formatPattern()) ?>"<?= $Page->description_02->editAttributes() ?> aria-describedby="x_description_02_help">
<?= $Page->description_02->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->description_02->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->description_07->Visible) { // description_07 ?>
    <div id="r_description_07"<?= $Page->description_07->rowAttributes() ?>>
        <label id="elh_po_description_07" for="x_description_07" class="<?= $Page->LeftColumnClass ?>"><?= $Page->description_07->caption() ?><?= $Page->description_07->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->description_07->cellAttributes() ?>>
<span id="el_po_description_07">
<input type="<?= $Page->description_07->getInputTextType() ?>" name="x_description_07" id="x_description_07" data-table="po" data-field="x_description_07" value="<?= $Page->description_07->EditValue ?>" data-page="2" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->description_07->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description_07->formatPattern()) ?>"<?= $Page->description_07->editAttributes() ?> aria-describedby="x_description_07_help">
<?= $Page->description_07->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->description_07->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->description_20->Visible) { // description_20 ?>
    <div id="r_description_20"<?= $Page->description_20->rowAttributes() ?>>
        <label id="elh_po_description_20" for="x_description_20" class="<?= $Page->LeftColumnClass ?>"><?= $Page->description_20->caption() ?><?= $Page->description_20->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->description_20->cellAttributes() ?>>
<span id="el_po_description_20">
    <select
        id="x_description_20"
        name="x_description_20"
        class="form-select ew-select<?= $Page->description_20->isInvalidClass() ?>"
        <?php if (!$Page->description_20->IsNativeSelect) { ?>
        data-select2-id="fpoadd_x_description_20"
        <?php } ?>
        data-table="po"
        data-field="x_description_20"
        data-page="2"
        data-value-separator="<?= $Page->description_20->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->description_20->getPlaceHolder()) ?>"
        <?= $Page->description_20->editAttributes() ?>>
        <?= $Page->description_20->selectOptionListHtml("x_description_20") ?>
    </select>
    <?= $Page->description_20->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->description_20->getErrorMessage() ?></div>
<?php if (!$Page->description_20->IsNativeSelect) { ?>
<script>
loadjs.ready("fpoadd", function() {
    var options = { name: "x_description_20", selectId: "fpoadd_x_description_20" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpoadd.lists.description_20?.lookupOptions.length) {
        options.data = { id: "x_description_20", form: "fpoadd" };
    } else {
        options.ajax = { id: "x_description_20", form: "fpoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po.fields.description_20.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->description_17->Visible) { // description_17 ?>
    <div id="r_description_17"<?= $Page->description_17->rowAttributes() ?>>
        <label id="elh_po_description_17" for="x_description_17" class="<?= $Page->LeftColumnClass ?>"><?= $Page->description_17->caption() ?><?= $Page->description_17->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->description_17->cellAttributes() ?>>
<span id="el_po_description_17">
<input type="<?= $Page->description_17->getInputTextType() ?>" name="x_description_17" id="x_description_17" data-table="po" data-field="x_description_17" value="<?= $Page->description_17->EditValue ?>" data-page="2" size="30" placeholder="<?= HtmlEncode($Page->description_17->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description_17->formatPattern()) ?>"<?= $Page->description_17->editAttributes() ?> aria-describedby="x_description_17_help">
<?= $Page->description_17->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->description_17->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->description_18->Visible) { // description_18 ?>
    <div id="r_description_18"<?= $Page->description_18->rowAttributes() ?>>
        <label id="elh_po_description_18" for="x_description_18" class="<?= $Page->LeftColumnClass ?>"><?= $Page->description_18->caption() ?><?= $Page->description_18->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->description_18->cellAttributes() ?>>
<span id="el_po_description_18">
<input type="<?= $Page->description_18->getInputTextType() ?>" name="x_description_18" id="x_description_18" data-table="po" data-field="x_description_18" value="<?= $Page->description_18->EditValue ?>" data-page="2" size="30" placeholder="<?= HtmlEncode($Page->description_18->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description_18->formatPattern()) ?>"<?= $Page->description_18->editAttributes() ?> aria-describedby="x_description_18_help">
<?= $Page->description_18->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->description_18->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->description_19->Visible) { // description_19 ?>
    <div id="r_description_19"<?= $Page->description_19->rowAttributes() ?>>
        <label id="elh_po_description_19" for="x_description_19" class="<?= $Page->LeftColumnClass ?>"><?= $Page->description_19->caption() ?><?= $Page->description_19->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->description_19->cellAttributes() ?>>
<span id="el_po_description_19">
<input type="<?= $Page->description_19->getInputTextType() ?>" name="x_description_19" id="x_description_19" data-table="po" data-field="x_description_19" value="<?= $Page->description_19->EditValue ?>" data-page="2" size="30" placeholder="<?= HtmlEncode($Page->description_19->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description_19->formatPattern()) ?>"<?= $Page->description_19->editAttributes() ?> aria-describedby="x_description_19_help">
<?= $Page->description_19->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->description_19->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity"<?= $Page->quantity->rowAttributes() ?>>
        <label id="elh_po_quantity" for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><?= $Page->quantity->caption() ?><?= $Page->quantity->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->quantity->cellAttributes() ?>>
<span id="el_po_quantity">
<input type="<?= $Page->quantity->getInputTextType() ?>" name="x_quantity" id="x_quantity" data-table="po" data-field="x_quantity" value="<?= $Page->quantity->EditValue ?>" data-page="2" size="30" placeholder="<?= HtmlEncode($Page->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity->formatPattern()) ?>"<?= $Page->quantity->editAttributes() ?> aria-describedby="x_quantity_help">
<?= $Page->quantity->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->quantity->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->price->Visible) { // price ?>
    <div id="r_price"<?= $Page->price->rowAttributes() ?>>
        <label id="elh_po_price" for="x_price" class="<?= $Page->LeftColumnClass ?>"><?= $Page->price->caption() ?><?= $Page->price->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->price->cellAttributes() ?>>
<span id="el_po_price">
<input type="<?= $Page->price->getInputTextType() ?>" name="x_price" id="x_price" data-table="po" data-field="x_price" value="<?= $Page->price->EditValue ?>" data-page="2" size="30" placeholder="<?= HtmlEncode($Page->price->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->price->formatPattern()) ?>"<?= $Page->price->editAttributes() ?> aria-describedby="x_price_help">
<?= $Page->price->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->price->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
    <div id="r_amount"<?= $Page->amount->rowAttributes() ?>>
        <label id="elh_po_amount" for="x_amount" class="<?= $Page->LeftColumnClass ?>"><?= $Page->amount->caption() ?><?= $Page->amount->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->amount->cellAttributes() ?>>
<span id="el_po_amount">
<input type="<?= $Page->amount->getInputTextType() ?>" name="x_amount" id="x_amount" data-table="po" data-field="x_amount" value="<?= $Page->amount->EditValue ?>" data-page="2" size="30" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?> aria-describedby="x_amount_help">
<?= $Page->amount->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->cbm->Visible) { // cbm ?>
    <div id="r_cbm"<?= $Page->cbm->rowAttributes() ?>>
        <label id="elh_po_cbm" for="x_cbm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->cbm->caption() ?><?= $Page->cbm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->cbm->cellAttributes() ?>>
<span id="el_po_cbm">
<input type="<?= $Page->cbm->getInputTextType() ?>" name="x_cbm" id="x_cbm" data-table="po" data-field="x_cbm" value="<?= $Page->cbm->EditValue ?>" data-page="2" size="30" placeholder="<?= HtmlEncode($Page->cbm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cbm->formatPattern()) ?>"<?= $Page->cbm->editAttributes() ?> aria-describedby="x_cbm_help">
<?= $Page->cbm->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->cbm->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->buyer_size->Visible) { // buyer_size ?>
    <div id="r_buyer_size"<?= $Page->buyer_size->rowAttributes() ?>>
        <label id="elh_po_buyer_size" for="x_buyer_size" class="<?= $Page->LeftColumnClass ?>"><?= $Page->buyer_size->caption() ?><?= $Page->buyer_size->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->buyer_size->cellAttributes() ?>>
<span id="el_po_buyer_size">
<input type="<?= $Page->buyer_size->getInputTextType() ?>" name="x_buyer_size" id="x_buyer_size" data-table="po" data-field="x_buyer_size" value="<?= $Page->buyer_size->EditValue ?>" data-page="2" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->buyer_size->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_size->formatPattern()) ?>"<?= $Page->buyer_size->editAttributes() ?> aria-describedby="x_buyer_size_help">
<?= $Page->buyer_size->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->buyer_size->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->description_05->Visible) { // description_05 ?>
    <div id="r_description_05"<?= $Page->description_05->rowAttributes() ?>>
        <label id="elh_po_description_05" for="x_description_05" class="<?= $Page->LeftColumnClass ?>"><?= $Page->description_05->caption() ?><?= $Page->description_05->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->description_05->cellAttributes() ?>>
<span id="el_po_description_05">
<div class="input-group flex-nowrap">
    <select
        id="x_description_05"
        name="x_description_05"
        class="form-select ew-select<?= $Page->description_05->isInvalidClass() ?>"
        <?php if (!$Page->description_05->IsNativeSelect) { ?>
        data-select2-id="fpoadd_x_description_05"
        <?php } ?>
        data-table="po"
        data-field="x_description_05"
        data-page="2"
        data-value-separator="<?= $Page->description_05->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->description_05->getPlaceHolder()) ?>"
        <?= $Page->description_05->editAttributes() ?>>
        <?= $Page->description_05->selectOptionListHtml("x_description_05") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "d_05") && !$Page->description_05->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_description_05" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->description_05->caption() ?>" data-title="<?= $Page->description_05->caption() ?>" data-ew-action="add-option" data-el="x_description_05" data-url="<?= GetUrl("d05addopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->description_05->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->description_05->getErrorMessage() ?></div>
<?= $Page->description_05->Lookup->getParamTag($Page, "p_x_description_05") ?>
<?php if (!$Page->description_05->IsNativeSelect) { ?>
<script>
loadjs.ready("fpoadd", function() {
    var options = { name: "x_description_05", selectId: "fpoadd_x_description_05" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpoadd.lists.description_05?.lookupOptions.length) {
        options.data = { id: "x_description_05", form: "fpoadd" };
    } else {
        options.ajax = { id: "x_description_05", form: "fpoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po.fields.description_05.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->description_06->Visible) { // description_06 ?>
    <div id="r_description_06"<?= $Page->description_06->rowAttributes() ?>>
        <label id="elh_po_description_06" for="x_description_06" class="<?= $Page->LeftColumnClass ?>"><?= $Page->description_06->caption() ?><?= $Page->description_06->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->description_06->cellAttributes() ?>>
<span id="el_po_description_06">
<input type="<?= $Page->description_06->getInputTextType() ?>" name="x_description_06" id="x_description_06" data-table="po" data-field="x_description_06" value="<?= $Page->description_06->EditValue ?>" data-page="2" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->description_06->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description_06->formatPattern()) ?>"<?= $Page->description_06->editAttributes() ?> aria-describedby="x_description_06_help">
<?= $Page->description_06->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->description_06->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->description_08->Visible) { // description_08 ?>
    <div id="r_description_08"<?= $Page->description_08->rowAttributes() ?>>
        <label id="elh_po_description_08" for="x_description_08" class="<?= $Page->LeftColumnClass ?>"><?= $Page->description_08->caption() ?><?= $Page->description_08->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->description_08->cellAttributes() ?>>
<span id="el_po_description_08">
<input type="<?= $Page->description_08->getInputTextType() ?>" name="x_description_08" id="x_description_08" data-table="po" data-field="x_description_08" value="<?= $Page->description_08->EditValue ?>" data-page="2" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->description_08->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description_08->formatPattern()) ?>"<?= $Page->description_08->editAttributes() ?> aria-describedby="x_description_08_help">
<?= $Page->description_08->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->description_08->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div><!-- /multi-page .accordion-item -->
<div class="accordion-item ew-accordion-item"><!-- multi-page .accordion-item -->
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(3)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(3)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_po3"><?= $Page->pageCaption(3) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(3)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_po3"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->d_09_head->Visible) { // d_09_head ?>
    <div id="r_d_09_head"<?= $Page->d_09_head->rowAttributes() ?>>
        <label id="elh_po_d_09_head" for="x_d_09_head" class="<?= $Page->LeftColumnClass ?>"><?= $Page->d_09_head->caption() ?><?= $Page->d_09_head->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->d_09_head->cellAttributes() ?>>
<span id="el_po_d_09_head">
<div class="input-group flex-nowrap">
    <select
        id="x_d_09_head"
        name="x_d_09_head"
        class="form-select ew-select<?= $Page->d_09_head->isInvalidClass() ?>"
        <?php if (!$Page->d_09_head->IsNativeSelect) { ?>
        data-select2-id="fpoadd_x_d_09_head"
        <?php } ?>
        data-table="po"
        data-field="x_d_09_head"
        data-page="3"
        data-value-separator="<?= $Page->d_09_head->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->d_09_head->getPlaceHolder()) ?>"
        <?= $Page->d_09_head->editAttributes() ?>>
        <?= $Page->d_09_head->selectOptionListHtml("x_d_09_head") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "po_desc") && !$Page->d_09_head->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_d_09_head" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->d_09_head->caption() ?>" data-title="<?= $Page->d_09_head->caption() ?>" data-ew-action="add-option" data-el="x_d_09_head" data-url="<?= GetUrl("podescaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->d_09_head->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->d_09_head->getErrorMessage() ?></div>
<?= $Page->d_09_head->Lookup->getParamTag($Page, "p_x_d_09_head") ?>
<?php if (!$Page->d_09_head->IsNativeSelect) { ?>
<script>
loadjs.ready("fpoadd", function() {
    var options = { name: "x_d_09_head", selectId: "fpoadd_x_d_09_head" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpoadd.lists.d_09_head?.lookupOptions.length) {
        options.data = { id: "x_d_09_head", form: "fpoadd" };
    } else {
        options.ajax = { id: "x_d_09_head", form: "fpoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po.fields.d_09_head.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->description_09->Visible) { // description_09 ?>
    <div id="r_description_09"<?= $Page->description_09->rowAttributes() ?>>
        <label id="elh_po_description_09" for="x_description_09" class="<?= $Page->LeftColumnClass ?>"><?= $Page->description_09->caption() ?><?= $Page->description_09->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->description_09->cellAttributes() ?>>
<span id="el_po_description_09">
<input type="<?= $Page->description_09->getInputTextType() ?>" name="x_description_09" id="x_description_09" data-table="po" data-field="x_description_09" value="<?= $Page->description_09->EditValue ?>" data-page="3" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->description_09->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description_09->formatPattern()) ?>"<?= $Page->description_09->editAttributes() ?> aria-describedby="x_description_09_help">
<?= $Page->description_09->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->description_09->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->d_10_head->Visible) { // d_10_head ?>
    <div id="r_d_10_head"<?= $Page->d_10_head->rowAttributes() ?>>
        <label id="elh_po_d_10_head" for="x_d_10_head" class="<?= $Page->LeftColumnClass ?>"><?= $Page->d_10_head->caption() ?><?= $Page->d_10_head->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->d_10_head->cellAttributes() ?>>
<span id="el_po_d_10_head">
<div class="input-group flex-nowrap">
    <select
        id="x_d_10_head"
        name="x_d_10_head"
        class="form-select ew-select<?= $Page->d_10_head->isInvalidClass() ?>"
        <?php if (!$Page->d_10_head->IsNativeSelect) { ?>
        data-select2-id="fpoadd_x_d_10_head"
        <?php } ?>
        data-table="po"
        data-field="x_d_10_head"
        data-page="3"
        data-value-separator="<?= $Page->d_10_head->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->d_10_head->getPlaceHolder()) ?>"
        <?= $Page->d_10_head->editAttributes() ?>>
        <?= $Page->d_10_head->selectOptionListHtml("x_d_10_head") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "po_desc") && !$Page->d_10_head->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_d_10_head" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->d_10_head->caption() ?>" data-title="<?= $Page->d_10_head->caption() ?>" data-ew-action="add-option" data-el="x_d_10_head" data-url="<?= GetUrl("podescaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->d_10_head->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->d_10_head->getErrorMessage() ?></div>
<?= $Page->d_10_head->Lookup->getParamTag($Page, "p_x_d_10_head") ?>
<?php if (!$Page->d_10_head->IsNativeSelect) { ?>
<script>
loadjs.ready("fpoadd", function() {
    var options = { name: "x_d_10_head", selectId: "fpoadd_x_d_10_head" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpoadd.lists.d_10_head?.lookupOptions.length) {
        options.data = { id: "x_d_10_head", form: "fpoadd" };
    } else {
        options.ajax = { id: "x_d_10_head", form: "fpoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po.fields.d_10_head.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->description_10->Visible) { // description_10 ?>
    <div id="r_description_10"<?= $Page->description_10->rowAttributes() ?>>
        <label id="elh_po_description_10" for="x_description_10" class="<?= $Page->LeftColumnClass ?>"><?= $Page->description_10->caption() ?><?= $Page->description_10->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->description_10->cellAttributes() ?>>
<span id="el_po_description_10">
<input type="<?= $Page->description_10->getInputTextType() ?>" name="x_description_10" id="x_description_10" data-table="po" data-field="x_description_10" value="<?= $Page->description_10->EditValue ?>" data-page="3" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->description_10->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description_10->formatPattern()) ?>"<?= $Page->description_10->editAttributes() ?> aria-describedby="x_description_10_help">
<?= $Page->description_10->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->description_10->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->d_11_head->Visible) { // d_11_head ?>
    <div id="r_d_11_head"<?= $Page->d_11_head->rowAttributes() ?>>
        <label id="elh_po_d_11_head" for="x_d_11_head" class="<?= $Page->LeftColumnClass ?>"><?= $Page->d_11_head->caption() ?><?= $Page->d_11_head->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->d_11_head->cellAttributes() ?>>
<span id="el_po_d_11_head">
<div class="input-group flex-nowrap">
    <select
        id="x_d_11_head"
        name="x_d_11_head"
        class="form-select ew-select<?= $Page->d_11_head->isInvalidClass() ?>"
        <?php if (!$Page->d_11_head->IsNativeSelect) { ?>
        data-select2-id="fpoadd_x_d_11_head"
        <?php } ?>
        data-table="po"
        data-field="x_d_11_head"
        data-page="3"
        data-value-separator="<?= $Page->d_11_head->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->d_11_head->getPlaceHolder()) ?>"
        <?= $Page->d_11_head->editAttributes() ?>>
        <?= $Page->d_11_head->selectOptionListHtml("x_d_11_head") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "po_desc") && !$Page->d_11_head->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_d_11_head" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->d_11_head->caption() ?>" data-title="<?= $Page->d_11_head->caption() ?>" data-ew-action="add-option" data-el="x_d_11_head" data-url="<?= GetUrl("podescaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->d_11_head->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->d_11_head->getErrorMessage() ?></div>
<?= $Page->d_11_head->Lookup->getParamTag($Page, "p_x_d_11_head") ?>
<?php if (!$Page->d_11_head->IsNativeSelect) { ?>
<script>
loadjs.ready("fpoadd", function() {
    var options = { name: "x_d_11_head", selectId: "fpoadd_x_d_11_head" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpoadd.lists.d_11_head?.lookupOptions.length) {
        options.data = { id: "x_d_11_head", form: "fpoadd" };
    } else {
        options.ajax = { id: "x_d_11_head", form: "fpoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po.fields.d_11_head.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->description_11->Visible) { // description_11 ?>
    <div id="r_description_11"<?= $Page->description_11->rowAttributes() ?>>
        <label id="elh_po_description_11" for="x_description_11" class="<?= $Page->LeftColumnClass ?>"><?= $Page->description_11->caption() ?><?= $Page->description_11->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->description_11->cellAttributes() ?>>
<span id="el_po_description_11">
<input type="<?= $Page->description_11->getInputTextType() ?>" name="x_description_11" id="x_description_11" data-table="po" data-field="x_description_11" value="<?= $Page->description_11->EditValue ?>" data-page="3" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->description_11->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description_11->formatPattern()) ?>"<?= $Page->description_11->editAttributes() ?> aria-describedby="x_description_11_help">
<?= $Page->description_11->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->description_11->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->d_12_head->Visible) { // d_12_head ?>
    <div id="r_d_12_head"<?= $Page->d_12_head->rowAttributes() ?>>
        <label id="elh_po_d_12_head" for="x_d_12_head" class="<?= $Page->LeftColumnClass ?>"><?= $Page->d_12_head->caption() ?><?= $Page->d_12_head->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->d_12_head->cellAttributes() ?>>
<span id="el_po_d_12_head">
<div class="input-group flex-nowrap">
    <select
        id="x_d_12_head"
        name="x_d_12_head"
        class="form-select ew-select<?= $Page->d_12_head->isInvalidClass() ?>"
        <?php if (!$Page->d_12_head->IsNativeSelect) { ?>
        data-select2-id="fpoadd_x_d_12_head"
        <?php } ?>
        data-table="po"
        data-field="x_d_12_head"
        data-page="3"
        data-value-separator="<?= $Page->d_12_head->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->d_12_head->getPlaceHolder()) ?>"
        <?= $Page->d_12_head->editAttributes() ?>>
        <?= $Page->d_12_head->selectOptionListHtml("x_d_12_head") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "po_desc") && !$Page->d_12_head->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_d_12_head" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->d_12_head->caption() ?>" data-title="<?= $Page->d_12_head->caption() ?>" data-ew-action="add-option" data-el="x_d_12_head" data-url="<?= GetUrl("podescaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->d_12_head->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->d_12_head->getErrorMessage() ?></div>
<?= $Page->d_12_head->Lookup->getParamTag($Page, "p_x_d_12_head") ?>
<?php if (!$Page->d_12_head->IsNativeSelect) { ?>
<script>
loadjs.ready("fpoadd", function() {
    var options = { name: "x_d_12_head", selectId: "fpoadd_x_d_12_head" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpoadd.lists.d_12_head?.lookupOptions.length) {
        options.data = { id: "x_d_12_head", form: "fpoadd" };
    } else {
        options.ajax = { id: "x_d_12_head", form: "fpoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.po.fields.d_12_head.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->description_12->Visible) { // description_12 ?>
    <div id="r_description_12"<?= $Page->description_12->rowAttributes() ?>>
        <label id="elh_po_description_12" for="x_description_12" class="<?= $Page->LeftColumnClass ?>"><?= $Page->description_12->caption() ?><?= $Page->description_12->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->description_12->cellAttributes() ?>>
<span id="el_po_description_12">
<input type="<?= $Page->description_12->getInputTextType() ?>" name="x_description_12" id="x_description_12" data-table="po" data-field="x_description_12" value="<?= $Page->description_12->EditValue ?>" data-page="3" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->description_12->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description_12->formatPattern()) ?>"<?= $Page->description_12->editAttributes() ?> aria-describedby="x_description_12_help">
<?= $Page->description_12->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->description_12->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div><!-- /multi-page .accordion-item -->
</div><!-- /multi-page accordion -->
</div><!-- /multi-page -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fpoadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpoadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("po");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
