<?php

namespace PHPMaker2024\fibre;

// Page object
$PersonalInfoView = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $Page->ExportOptions->render("body") ?>
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="view">
<form name="fpersonal_infoview" id="fpersonal_infoview" class="ew-form ew-view-form overlay-wrapper" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { personal_info: currentTable } });
var currentPageID = ew.PAGE_ID = "view";
var currentForm;
var fpersonal_infoview;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fpersonal_infoview")
        .setPageId("view")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="personal_info">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<table class="<?= $Page->TableClass ?>">
<?php if ($Page->id->Visible) { // id ?>
    <tr id="r_id"<?= $Page->id->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_personal_info_id"><?= $Page->id->caption() ?></span></td>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el_personal_info_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->formal_name->Visible) { // formal_name ?>
    <tr id="r_formal_name"<?= $Page->formal_name->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_personal_info_formal_name"><?= $Page->formal_name->caption() ?></span></td>
        <td data-name="formal_name"<?= $Page->formal_name->cellAttributes() ?>>
<span id="el_personal_info_formal_name">
<span<?= $Page->formal_name->viewAttributes() ?>>
<?= $Page->formal_name->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->gender->Visible) { // gender ?>
    <tr id="r_gender"<?= $Page->gender->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_personal_info_gender"><?= $Page->gender->caption() ?></span></td>
        <td data-name="gender"<?= $Page->gender->cellAttributes() ?>>
<span id="el_personal_info_gender">
<span<?= $Page->gender->viewAttributes() ?>>
<?= $Page->gender->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->mobile->Visible) { // mobile ?>
    <tr id="r_mobile"<?= $Page->mobile->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_personal_info_mobile"><?= $Page->mobile->caption() ?></span></td>
        <td data-name="mobile"<?= $Page->mobile->cellAttributes() ?>>
<span id="el_personal_info_mobile">
<span<?= $Page->mobile->viewAttributes() ?>>
<?= $Page->mobile->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->_email->Visible) { // email ?>
    <tr id="r__email"<?= $Page->_email->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_personal_info__email"><?= $Page->_email->caption() ?></span></td>
        <td data-name="_email"<?= $Page->_email->cellAttributes() ?>>
<span id="el_personal_info__email">
<span<?= $Page->_email->viewAttributes() ?>>
<?= $Page->_email->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->address->Visible) { // address ?>
    <tr id="r_address"<?= $Page->address->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_personal_info_address"><?= $Page->address->caption() ?></span></td>
        <td data-name="address"<?= $Page->address->cellAttributes() ?>>
<span id="el_personal_info_address">
<span<?= $Page->address->viewAttributes() ?>>
<?= $Page->address->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->country->Visible) { // country ?>
    <tr id="r_country"<?= $Page->country->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_personal_info_country"><?= $Page->country->caption() ?></span></td>
        <td data-name="country"<?= $Page->country->cellAttributes() ?>>
<span id="el_personal_info_country">
<span<?= $Page->country->viewAttributes() ?>>
<?= $Page->country->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->state->Visible) { // state ?>
    <tr id="r_state"<?= $Page->state->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_personal_info_state"><?= $Page->state->caption() ?></span></td>
        <td data-name="state"<?= $Page->state->cellAttributes() ?>>
<span id="el_personal_info_state">
<span<?= $Page->state->viewAttributes() ?>>
<?= $Page->state->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->city->Visible) { // city ?>
    <tr id="r_city"<?= $Page->city->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_personal_info_city"><?= $Page->city->caption() ?></span></td>
        <td data-name="city"<?= $Page->city->cellAttributes() ?>>
<span id="el_personal_info_city">
<span<?= $Page->city->viewAttributes() ?>>
<?= $Page->city->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->city_name->Visible) { // city_name ?>
    <tr id="r_city_name"<?= $Page->city_name->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_personal_info_city_name"><?= $Page->city_name->caption() ?></span></td>
        <td data-name="city_name"<?= $Page->city_name->cellAttributes() ?>>
<span id="el_personal_info_city_name">
<span<?= $Page->city_name->viewAttributes() ?>>
<?= $Page->city_name->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->dob->Visible) { // dob ?>
    <tr id="r_dob"<?= $Page->dob->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_personal_info_dob"><?= $Page->dob->caption() ?></span></td>
        <td data-name="dob"<?= $Page->dob->cellAttributes() ?>>
<span id="el_personal_info_dob">
<span<?= $Page->dob->viewAttributes() ?>>
<?= $Page->dob->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->dom->Visible) { // dom ?>
    <tr id="r_dom"<?= $Page->dom->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_personal_info_dom"><?= $Page->dom->caption() ?></span></td>
        <td data-name="dom"<?= $Page->dom->cellAttributes() ?>>
<span id="el_personal_info_dom">
<span<?= $Page->dom->viewAttributes() ?>>
<?= $Page->dom->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->marital_status->Visible) { // marital_status ?>
    <tr id="r_marital_status"<?= $Page->marital_status->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_personal_info_marital_status"><?= $Page->marital_status->caption() ?></span></td>
        <td data-name="marital_status"<?= $Page->marital_status->cellAttributes() ?>>
<span id="el_personal_info_marital_status">
<span<?= $Page->marital_status->viewAttributes() ?>>
<?= $Page->marital_status->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->spouse_details->Visible) { // spouse_details ?>
    <tr id="r_spouse_details"<?= $Page->spouse_details->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_personal_info_spouse_details"><?= $Page->spouse_details->caption() ?></span></td>
        <td data-name="spouse_details"<?= $Page->spouse_details->cellAttributes() ?>>
<span id="el_personal_info_spouse_details">
<span<?= $Page->spouse_details->viewAttributes() ?>>
<?= $Page->spouse_details->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->image->Visible) { // image ?>
    <tr id="r_image"<?= $Page->image->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_personal_info_image"><?= $Page->image->caption() ?></span></td>
        <td data-name="image"<?= $Page->image->cellAttributes() ?>>
<span id="el_personal_info_image">
<span<?= $Page->image->viewAttributes() ?>>
<?= GetFileViewTag($Page->image, $Page->image->getViewValue(), false) ?>
</span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->father_name->Visible) { // father_name ?>
    <tr id="r_father_name"<?= $Page->father_name->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_personal_info_father_name"><?= $Page->father_name->caption() ?></span></td>
        <td data-name="father_name"<?= $Page->father_name->cellAttributes() ?>>
<span id="el_personal_info_father_name">
<span<?= $Page->father_name->viewAttributes() ?>>
<?= $Page->father_name->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->mother_name->Visible) { // mother_name ?>
    <tr id="r_mother_name"<?= $Page->mother_name->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_personal_info_mother_name"><?= $Page->mother_name->caption() ?></span></td>
        <td data-name="mother_name"<?= $Page->mother_name->cellAttributes() ?>>
<span id="el_personal_info_mother_name">
<span<?= $Page->mother_name->viewAttributes() ?>>
<?= $Page->mother_name->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->permanent_address->Visible) { // permanent_address ?>
    <tr id="r_permanent_address"<?= $Page->permanent_address->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_personal_info_permanent_address"><?= $Page->permanent_address->caption() ?></span></td>
        <td data-name="permanent_address"<?= $Page->permanent_address->cellAttributes() ?>>
<span id="el_personal_info_permanent_address">
<span<?= $Page->permanent_address->viewAttributes() ?>>
<?= $Page->permanent_address->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->mobile_other->Visible) { // mobile_other ?>
    <tr id="r_mobile_other"<?= $Page->mobile_other->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_personal_info_mobile_other"><?= $Page->mobile_other->caption() ?></span></td>
        <td data-name="mobile_other"<?= $Page->mobile_other->cellAttributes() ?>>
<span id="el_personal_info_mobile_other">
<span<?= $Page->mobile_other->viewAttributes() ?>>
<?= $Page->mobile_other->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->mobile_family->Visible) { // mobile_family ?>
    <tr id="r_mobile_family"<?= $Page->mobile_family->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_personal_info_mobile_family"><?= $Page->mobile_family->caption() ?></span></td>
        <td data-name="mobile_family"<?= $Page->mobile_family->cellAttributes() ?>>
<span id="el_personal_info_mobile_family">
<span<?= $Page->mobile_family->viewAttributes() ?>>
<?= $Page->mobile_family->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->emergency_details->Visible) { // emergency_details ?>
    <tr id="r_emergency_details"<?= $Page->emergency_details->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_personal_info_emergency_details"><?= $Page->emergency_details->caption() ?></span></td>
        <td data-name="emergency_details"<?= $Page->emergency_details->cellAttributes() ?>>
<span id="el_personal_info_emergency_details">
<span<?= $Page->emergency_details->viewAttributes() ?>>
<?= $Page->emergency_details->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->annual_income->Visible) { // annual_income ?>
    <tr id="r_annual_income"<?= $Page->annual_income->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_personal_info_annual_income"><?= $Page->annual_income->caption() ?></span></td>
        <td data-name="annual_income"<?= $Page->annual_income->cellAttributes() ?>>
<span id="el_personal_info_annual_income">
<span<?= $Page->annual_income->viewAttributes() ?>>
<?= $Page->annual_income->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->work_details->Visible) { // work_details ?>
    <tr id="r_work_details"<?= $Page->work_details->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_personal_info_work_details"><?= $Page->work_details->caption() ?></span></td>
        <td data-name="work_details"<?= $Page->work_details->cellAttributes() ?>>
<span id="el_personal_info_work_details">
<span<?= $Page->work_details->viewAttributes() ?>>
<?= $Page->work_details->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <tr id="r_status"<?= $Page->status->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_personal_info_status"><?= $Page->status->caption() ?></span></td>
        <td data-name="status"<?= $Page->status->cellAttributes() ?>>
<span id="el_personal_info_status">
<span<?= $Page->status->viewAttributes() ?>>
<?= $Page->status->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->gst->Visible) { // gst ?>
    <tr id="r_gst"<?= $Page->gst->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_personal_info_gst"><?= $Page->gst->caption() ?></span></td>
        <td data-name="gst"<?= $Page->gst->cellAttributes() ?>>
<span id="el_personal_info_gst">
<span<?= $Page->gst->viewAttributes() ?>>
<?= $Page->gst->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->aadhaar_no->Visible) { // aadhaar_no ?>
    <tr id="r_aadhaar_no"<?= $Page->aadhaar_no->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_personal_info_aadhaar_no"><?= $Page->aadhaar_no->caption() ?></span></td>
        <td data-name="aadhaar_no"<?= $Page->aadhaar_no->cellAttributes() ?>>
<span id="el_personal_info_aadhaar_no">
<span<?= $Page->aadhaar_no->viewAttributes() ?>>
<?= $Page->aadhaar_no->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->pan_no->Visible) { // pan_no ?>
    <tr id="r_pan_no"<?= $Page->pan_no->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_personal_info_pan_no"><?= $Page->pan_no->caption() ?></span></td>
        <td data-name="pan_no"<?= $Page->pan_no->cellAttributes() ?>>
<span id="el_personal_info_pan_no">
<span<?= $Page->pan_no->viewAttributes() ?>>
<?= $Page->pan_no->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->id_proof->Visible) { // id_proof ?>
    <tr id="r_id_proof"<?= $Page->id_proof->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_personal_info_id_proof"><?= $Page->id_proof->caption() ?></span></td>
        <td data-name="id_proof"<?= $Page->id_proof->cellAttributes() ?>>
<span id="el_personal_info_id_proof">
<span<?= $Page->id_proof->viewAttributes() ?>>
<?= GetFileViewTag($Page->id_proof, $Page->id_proof->getViewValue(), false) ?>
</span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->reference_details->Visible) { // reference_details ?>
    <tr id="r_reference_details"<?= $Page->reference_details->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_personal_info_reference_details"><?= $Page->reference_details->caption() ?></span></td>
        <td data-name="reference_details"<?= $Page->reference_details->cellAttributes() ?>>
<span id="el_personal_info_reference_details">
<span<?= $Page->reference_details->viewAttributes() ?>>
<?= $Page->reference_details->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->other_details->Visible) { // other_details ?>
    <tr id="r_other_details"<?= $Page->other_details->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_personal_info_other_details"><?= $Page->other_details->caption() ?></span></td>
        <td data-name="other_details"<?= $Page->other_details->cellAttributes() ?>>
<span id="el_personal_info_other_details">
<span<?= $Page->other_details->viewAttributes() ?>>
<?= $Page->other_details->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->bank_name->Visible) { // bank_name ?>
    <tr id="r_bank_name"<?= $Page->bank_name->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_personal_info_bank_name"><?= $Page->bank_name->caption() ?></span></td>
        <td data-name="bank_name"<?= $Page->bank_name->cellAttributes() ?>>
<span id="el_personal_info_bank_name">
<span<?= $Page->bank_name->viewAttributes() ?>>
<?= $Page->bank_name->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->bank_ifsc_code->Visible) { // bank_ifsc_code ?>
    <tr id="r_bank_ifsc_code"<?= $Page->bank_ifsc_code->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_personal_info_bank_ifsc_code"><?= $Page->bank_ifsc_code->caption() ?></span></td>
        <td data-name="bank_ifsc_code"<?= $Page->bank_ifsc_code->cellAttributes() ?>>
<span id="el_personal_info_bank_ifsc_code">
<span<?= $Page->bank_ifsc_code->viewAttributes() ?>>
<?= $Page->bank_ifsc_code->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->bank_account_no->Visible) { // bank_account_no ?>
    <tr id="r_bank_account_no"<?= $Page->bank_account_no->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_personal_info_bank_account_no"><?= $Page->bank_account_no->caption() ?></span></td>
        <td data-name="bank_account_no"<?= $Page->bank_account_no->cellAttributes() ?>>
<span id="el_personal_info_bank_account_no">
<span<?= $Page->bank_account_no->viewAttributes() ?>>
<?= $Page->bank_account_no->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <tr id="r_operator"<?= $Page->operator->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_personal_info_operator"><?= $Page->operator->caption() ?></span></td>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el_personal_info_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <tr id="r_datetime"<?= $Page->datetime->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_personal_info_datetime"><?= $Page->datetime->caption() ?></span></td>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el_personal_info_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
</table>
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
