<?php

namespace PHPMaker2024\fibre;

// Page object
$PersonalInfoUpdate = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { personal_info: currentTable } });
var currentPageID = ew.PAGE_ID = "update";
var currentForm;
var fpersonal_infoupdate;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fpersonal_infoupdate")
        .setPageId("update")

        // Add fields
        .setFields([
            ["formal_name", [fields.formal_name.visible && fields.formal_name.required ? ew.Validators.required(fields.formal_name.caption) : null], fields.formal_name.isInvalid],
            ["gender", [fields.gender.visible && fields.gender.required ? ew.Validators.required(fields.gender.caption) : null], fields.gender.isInvalid],
            ["mobile", [fields.mobile.visible && fields.mobile.required ? ew.Validators.required(fields.mobile.caption) : null, ew.Validators.integer, ew.Validators.selected], fields.mobile.isInvalid],
            ["_email", [fields._email.visible && fields._email.required ? ew.Validators.required(fields._email.caption) : null, ew.Validators.email, ew.Validators.selected], fields._email.isInvalid],
            ["address", [fields.address.visible && fields.address.required ? ew.Validators.required(fields.address.caption) : null], fields.address.isInvalid],
            ["country", [fields.country.visible && fields.country.required ? ew.Validators.required(fields.country.caption) : null], fields.country.isInvalid],
            ["state", [fields.state.visible && fields.state.required ? ew.Validators.required(fields.state.caption) : null], fields.state.isInvalid],
            ["city", [fields.city.visible && fields.city.required ? ew.Validators.required(fields.city.caption) : null], fields.city.isInvalid],
            ["city_name", [fields.city_name.visible && fields.city_name.required ? ew.Validators.required(fields.city_name.caption) : null], fields.city_name.isInvalid],
            ["dob", [fields.dob.visible && fields.dob.required ? ew.Validators.required(fields.dob.caption) : null, ew.Validators.datetime(fields.dob.clientFormatPattern), ew.Validators.selected], fields.dob.isInvalid],
            ["dom", [fields.dom.visible && fields.dom.required ? ew.Validators.required(fields.dom.caption) : null, ew.Validators.datetime(fields.dom.clientFormatPattern), ew.Validators.selected], fields.dom.isInvalid],
            ["marital_status", [fields.marital_status.visible && fields.marital_status.required ? ew.Validators.required(fields.marital_status.caption) : null], fields.marital_status.isInvalid],
            ["spouse_details", [fields.spouse_details.visible && fields.spouse_details.required ? ew.Validators.required(fields.spouse_details.caption) : null], fields.spouse_details.isInvalid],
            ["image", [fields.image.visible && fields.image.required ? ew.Validators.fileRequired(fields.image.caption) : null], fields.image.isInvalid],
            ["father_name", [fields.father_name.visible && fields.father_name.required ? ew.Validators.required(fields.father_name.caption) : null], fields.father_name.isInvalid],
            ["mother_name", [fields.mother_name.visible && fields.mother_name.required ? ew.Validators.required(fields.mother_name.caption) : null], fields.mother_name.isInvalid],
            ["permanent_address", [fields.permanent_address.visible && fields.permanent_address.required ? ew.Validators.required(fields.permanent_address.caption) : null], fields.permanent_address.isInvalid],
            ["mobile_other", [fields.mobile_other.visible && fields.mobile_other.required ? ew.Validators.required(fields.mobile_other.caption) : null], fields.mobile_other.isInvalid],
            ["mobile_family", [fields.mobile_family.visible && fields.mobile_family.required ? ew.Validators.required(fields.mobile_family.caption) : null], fields.mobile_family.isInvalid],
            ["emergency_details", [fields.emergency_details.visible && fields.emergency_details.required ? ew.Validators.required(fields.emergency_details.caption) : null], fields.emergency_details.isInvalid],
            ["annual_income", [fields.annual_income.visible && fields.annual_income.required ? ew.Validators.required(fields.annual_income.caption) : null, ew.Validators.integer, ew.Validators.selected], fields.annual_income.isInvalid],
            ["work_details", [fields.work_details.visible && fields.work_details.required ? ew.Validators.required(fields.work_details.caption) : null], fields.work_details.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["gst", [fields.gst.visible && fields.gst.required ? ew.Validators.required(fields.gst.caption) : null], fields.gst.isInvalid],
            ["aadhaar_no", [fields.aadhaar_no.visible && fields.aadhaar_no.required ? ew.Validators.required(fields.aadhaar_no.caption) : null, ew.Validators.regex(/^[2-9]{1}[0-9]{3}\s[0-9]{4}\s[0-9]{4}$/), ew.Validators.selected], fields.aadhaar_no.isInvalid],
            ["pan_no", [fields.pan_no.visible && fields.pan_no.required ? ew.Validators.required(fields.pan_no.caption) : null, ew.Validators.regex(/([A-Z]){5}([0-9]){4}([A-Z]){1}$/), ew.Validators.selected], fields.pan_no.isInvalid],
            ["id_proof", [fields.id_proof.visible && fields.id_proof.required ? ew.Validators.fileRequired(fields.id_proof.caption) : null], fields.id_proof.isInvalid],
            ["reference_details", [fields.reference_details.visible && fields.reference_details.required ? ew.Validators.required(fields.reference_details.caption) : null], fields.reference_details.isInvalid],
            ["other_details", [fields.other_details.visible && fields.other_details.required ? ew.Validators.required(fields.other_details.caption) : null], fields.other_details.isInvalid],
            ["bank_name", [fields.bank_name.visible && fields.bank_name.required ? ew.Validators.required(fields.bank_name.caption) : null], fields.bank_name.isInvalid],
            ["bank_ifsc_code", [fields.bank_ifsc_code.visible && fields.bank_ifsc_code.required ? ew.Validators.required(fields.bank_ifsc_code.caption) : null], fields.bank_ifsc_code.isInvalid],
            ["bank_account_no", [fields.bank_account_no.visible && fields.bank_account_no.required ? ew.Validators.required(fields.bank_account_no.caption) : null], fields.bank_account_no.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "gender": <?= $Page->gender->toClientList($Page) ?>,
            "country": <?= $Page->country->toClientList($Page) ?>,
            "state": <?= $Page->state->toClientList($Page) ?>,
            "city": <?= $Page->city->toClientList($Page) ?>,
            "marital_status": <?= $Page->marital_status->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fpersonal_infoupdate" id="fpersonal_infoupdate" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="personal_info">
<?php if ($Page->isConfirm()) { // Confirm page ?>
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="confirm" id="confirm" value="confirm">
<?php } else { ?>
<input type="hidden" name="action" id="action" value="confirm">
<?php } ?>
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php foreach ($Page->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode(Config("COMPOSITE_KEY_SEPARATOR"), $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?= HtmlEncode($keyvalue) ?>">
<?php } ?>
<div id="tbl_personal_infoupdate" class="ew-update-div"><!-- page -->
    <?php if (!$Page->isConfirm()) { // Confirm page ?>
    <div class="form-check">
        <input type="checkbox" class="form-check-input" name="u" id="u" data-ew-action="select-all"<?= $Page->Disabled ?>><label class="form-check-label" for="u"><?= $Language->phrase("SelectAll") ?></label>
    </div>
    <?php } ?>
<?php if ($Page->formal_name->Visible && (!$Page->isConfirm() || $Page->formal_name->multiUpdateSelected())) { // formal_name ?>
    <div id="r_formal_name"<?= $Page->formal_name->rowAttributes() ?>>
        <label for="x_formal_name" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_formal_name" id="u_formal_name" class="form-check-input ew-multi-select" value="1"<?= $Page->formal_name->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_formal_name"><?= $Page->formal_name->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_formal_name" id="u_formal_name" value="<?= $Page->formal_name->MultiUpdate ?>">
            <?= $Page->formal_name->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->formal_name->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_personal_info_formal_name">
                <input type="<?= $Page->formal_name->getInputTextType() ?>" name="x_formal_name" id="x_formal_name" data-table="personal_info" data-field="x_formal_name" value="<?= $Page->formal_name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->formal_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->formal_name->formatPattern()) ?>"<?= $Page->formal_name->editAttributes() ?> aria-describedby="x_formal_name_help">
                <?= $Page->formal_name->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->formal_name->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_personal_info_formal_name">
                <span<?= $Page->formal_name->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->formal_name->getDisplayValue($Page->formal_name->ViewValue))) ?>"></span>
                <input type="hidden" data-table="personal_info" data-field="x_formal_name" data-hidden="1" name="x_formal_name" id="x_formal_name" value="<?= HtmlEncode($Page->formal_name->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->gender->Visible && (!$Page->isConfirm() || $Page->gender->multiUpdateSelected())) { // gender ?>
    <div id="r_gender"<?= $Page->gender->rowAttributes() ?>>
        <label for="x_gender" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_gender" id="u_gender" class="form-check-input ew-multi-select" value="1"<?= $Page->gender->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_gender"><?= $Page->gender->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_gender" id="u_gender" value="<?= $Page->gender->MultiUpdate ?>">
            <?= $Page->gender->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->gender->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_personal_info_gender">
                    <select
                        id="x_gender"
                        name="x_gender"
                        class="form-select ew-select<?= $Page->gender->isInvalidClass() ?>"
                        <?php if (!$Page->gender->IsNativeSelect) { ?>
                        data-select2-id="fpersonal_infoupdate_x_gender"
                        <?php } ?>
                        data-table="personal_info"
                        data-field="x_gender"
                        data-value-separator="<?= $Page->gender->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->gender->getPlaceHolder()) ?>"
                        <?= $Page->gender->editAttributes() ?>>
                        <?= $Page->gender->selectOptionListHtml("x_gender") ?>
                    </select>
                    <?= $Page->gender->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->gender->getErrorMessage() ?></div>
                <?php if (!$Page->gender->IsNativeSelect) { ?>
                <script>
                loadjs.ready("fpersonal_infoupdate", function() {
                    var options = { name: "x_gender", selectId: "fpersonal_infoupdate_x_gender" },
                        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
                    if (!el)
                        return;
                    options.closeOnSelect = !options.multiple;
                    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
                    if (fpersonal_infoupdate.lists.gender?.lookupOptions.length) {
                        options.data = { id: "x_gender", form: "fpersonal_infoupdate" };
                    } else {
                        options.ajax = { id: "x_gender", form: "fpersonal_infoupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options.minimumResultsForSearch = Infinity;
                    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.personal_info.fields.gender.selectOptions);
                    ew.createSelect(options);
                });
                </script>
                <?php } ?>
                </span>
                <?php } else { ?>
                <span id="el_personal_info_gender">
                <span<?= $Page->gender->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->gender->getDisplayValue($Page->gender->ViewValue) ?></span></span>
                <input type="hidden" data-table="personal_info" data-field="x_gender" data-hidden="1" name="x_gender" id="x_gender" value="<?= HtmlEncode($Page->gender->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->mobile->Visible && (!$Page->isConfirm() || $Page->mobile->multiUpdateSelected())) { // mobile ?>
    <div id="r_mobile"<?= $Page->mobile->rowAttributes() ?>>
        <label for="x_mobile" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_mobile" id="u_mobile" class="form-check-input ew-multi-select" value="1"<?= $Page->mobile->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_mobile"><?= $Page->mobile->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_mobile" id="u_mobile" value="<?= $Page->mobile->MultiUpdate ?>">
            <?= $Page->mobile->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->mobile->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_personal_info_mobile">
                <input type="<?= $Page->mobile->getInputTextType() ?>" name="x_mobile" id="x_mobile" data-table="personal_info" data-field="x_mobile" value="<?= $Page->mobile->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile->formatPattern()) ?>"<?= $Page->mobile->editAttributes() ?> aria-describedby="x_mobile_help">
                <?= $Page->mobile->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->mobile->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_personal_info_mobile">
                <span<?= $Page->mobile->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->mobile->getDisplayValue($Page->mobile->ViewValue))) ?>"></span>
                <input type="hidden" data-table="personal_info" data-field="x_mobile" data-hidden="1" name="x_mobile" id="x_mobile" value="<?= HtmlEncode($Page->mobile->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_email->Visible && (!$Page->isConfirm() || $Page->_email->multiUpdateSelected())) { // email ?>
    <div id="r__email"<?= $Page->_email->rowAttributes() ?>>
        <label for="x__email" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u__email" id="u__email" class="form-check-input ew-multi-select" value="1"<?= $Page->_email->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u__email"><?= $Page->_email->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u__email" id="u__email" value="<?= $Page->_email->MultiUpdate ?>">
            <?= $Page->_email->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_email->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_personal_info__email">
                <input type="<?= $Page->_email->getInputTextType() ?>" name="x__email" id="x__email" data-table="personal_info" data-field="x__email" value="<?= $Page->_email->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->_email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_email->formatPattern()) ?>"<?= $Page->_email->editAttributes() ?> aria-describedby="x__email_help">
                <?= $Page->_email->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->_email->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_personal_info__email">
                <span<?= $Page->_email->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->_email->getDisplayValue($Page->_email->ViewValue))) ?>"></span>
                <input type="hidden" data-table="personal_info" data-field="x__email" data-hidden="1" name="x__email" id="x__email" value="<?= HtmlEncode($Page->_email->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->address->Visible && (!$Page->isConfirm() || $Page->address->multiUpdateSelected())) { // address ?>
    <div id="r_address"<?= $Page->address->rowAttributes() ?>>
        <label for="x_address" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_address" id="u_address" class="form-check-input ew-multi-select" value="1"<?= $Page->address->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_address"><?= $Page->address->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_address" id="u_address" value="<?= $Page->address->MultiUpdate ?>">
            <?= $Page->address->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->address->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_personal_info_address">
                <input type="<?= $Page->address->getInputTextType() ?>" name="x_address" id="x_address" data-table="personal_info" data-field="x_address" value="<?= $Page->address->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->address->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->address->formatPattern()) ?>"<?= $Page->address->editAttributes() ?> aria-describedby="x_address_help">
                <?= $Page->address->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->address->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_personal_info_address">
                <span<?= $Page->address->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->address->getDisplayValue($Page->address->ViewValue))) ?>"></span>
                <input type="hidden" data-table="personal_info" data-field="x_address" data-hidden="1" name="x_address" id="x_address" value="<?= HtmlEncode($Page->address->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->country->Visible && (!$Page->isConfirm() || $Page->country->multiUpdateSelected())) { // country ?>
    <div id="r_country"<?= $Page->country->rowAttributes() ?>>
        <label for="x_country" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_country" id="u_country" class="form-check-input ew-multi-select" value="1"<?= $Page->country->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_country"><?= $Page->country->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_country" id="u_country" value="<?= $Page->country->MultiUpdate ?>">
            <?= $Page->country->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->country->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_personal_info_country">
                    <select
                        id="x_country"
                        name="x_country"
                        class="form-select ew-select<?= $Page->country->isInvalidClass() ?>"
                        <?php if (!$Page->country->IsNativeSelect) { ?>
                        data-select2-id="fpersonal_infoupdate_x_country"
                        <?php } ?>
                        data-table="personal_info"
                        data-field="x_country"
                        data-value-separator="<?= $Page->country->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->country->getPlaceHolder()) ?>"
                        data-ew-action="update-options"
                        <?= $Page->country->editAttributes() ?>>
                        <?= $Page->country->selectOptionListHtml("x_country") ?>
                    </select>
                    <?= $Page->country->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->country->getErrorMessage() ?></div>
                <?= $Page->country->Lookup->getParamTag($Page, "p_x_country") ?>
                <?php if (!$Page->country->IsNativeSelect) { ?>
                <script>
                loadjs.ready("fpersonal_infoupdate", function() {
                    var options = { name: "x_country", selectId: "fpersonal_infoupdate_x_country" },
                        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
                    if (!el)
                        return;
                    options.closeOnSelect = !options.multiple;
                    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
                    if (fpersonal_infoupdate.lists.country?.lookupOptions.length) {
                        options.data = { id: "x_country", form: "fpersonal_infoupdate" };
                    } else {
                        options.ajax = { id: "x_country", form: "fpersonal_infoupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options.minimumResultsForSearch = Infinity;
                    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.personal_info.fields.country.selectOptions);
                    ew.createSelect(options);
                });
                </script>
                <?php } ?>
                </span>
                <?php } else { ?>
                <span id="el_personal_info_country">
                <span<?= $Page->country->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->country->getDisplayValue($Page->country->ViewValue) ?></span></span>
                <input type="hidden" data-table="personal_info" data-field="x_country" data-hidden="1" name="x_country" id="x_country" value="<?= HtmlEncode($Page->country->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->state->Visible && (!$Page->isConfirm() || $Page->state->multiUpdateSelected())) { // state ?>
    <div id="r_state"<?= $Page->state->rowAttributes() ?>>
        <label for="x_state" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_state" id="u_state" class="form-check-input ew-multi-select" value="1"<?= $Page->state->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_state"><?= $Page->state->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_state" id="u_state" value="<?= $Page->state->MultiUpdate ?>">
            <?= $Page->state->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->state->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_personal_info_state">
                    <select
                        id="x_state"
                        name="x_state"
                        class="form-select ew-select<?= $Page->state->isInvalidClass() ?>"
                        <?php if (!$Page->state->IsNativeSelect) { ?>
                        data-select2-id="fpersonal_infoupdate_x_state"
                        <?php } ?>
                        data-table="personal_info"
                        data-field="x_state"
                        data-value-separator="<?= $Page->state->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->state->getPlaceHolder()) ?>"
                        data-ew-action="update-options"
                        <?= $Page->state->editAttributes() ?>>
                        <?= $Page->state->selectOptionListHtml("x_state") ?>
                    </select>
                    <?= $Page->state->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->state->getErrorMessage() ?></div>
                <?= $Page->state->Lookup->getParamTag($Page, "p_x_state") ?>
                <?php if (!$Page->state->IsNativeSelect) { ?>
                <script>
                loadjs.ready("fpersonal_infoupdate", function() {
                    var options = { name: "x_state", selectId: "fpersonal_infoupdate_x_state" },
                        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
                    if (!el)
                        return;
                    options.closeOnSelect = !options.multiple;
                    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
                    if (fpersonal_infoupdate.lists.state?.lookupOptions.length) {
                        options.data = { id: "x_state", form: "fpersonal_infoupdate" };
                    } else {
                        options.ajax = { id: "x_state", form: "fpersonal_infoupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options.minimumResultsForSearch = Infinity;
                    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.personal_info.fields.state.selectOptions);
                    ew.createSelect(options);
                });
                </script>
                <?php } ?>
                </span>
                <?php } else { ?>
                <span id="el_personal_info_state">
                <span<?= $Page->state->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->state->getDisplayValue($Page->state->ViewValue) ?></span></span>
                <input type="hidden" data-table="personal_info" data-field="x_state" data-hidden="1" name="x_state" id="x_state" value="<?= HtmlEncode($Page->state->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->city->Visible && (!$Page->isConfirm() || $Page->city->multiUpdateSelected())) { // city ?>
    <div id="r_city"<?= $Page->city->rowAttributes() ?>>
        <label for="x_city" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_city" id="u_city" class="form-check-input ew-multi-select" value="1"<?= $Page->city->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_city"><?= $Page->city->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_city" id="u_city" value="<?= $Page->city->MultiUpdate ?>">
            <?= $Page->city->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->city->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_personal_info_city">
                    <select
                        id="x_city"
                        name="x_city"
                        class="form-select ew-select<?= $Page->city->isInvalidClass() ?>"
                        <?php if (!$Page->city->IsNativeSelect) { ?>
                        data-select2-id="fpersonal_infoupdate_x_city"
                        <?php } ?>
                        data-table="personal_info"
                        data-field="x_city"
                        data-value-separator="<?= $Page->city->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->city->getPlaceHolder()) ?>"
                        <?= $Page->city->editAttributes() ?>>
                        <?= $Page->city->selectOptionListHtml("x_city") ?>
                    </select>
                    <?= $Page->city->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->city->getErrorMessage() ?></div>
                <?= $Page->city->Lookup->getParamTag($Page, "p_x_city") ?>
                <?php if (!$Page->city->IsNativeSelect) { ?>
                <script>
                loadjs.ready("fpersonal_infoupdate", function() {
                    var options = { name: "x_city", selectId: "fpersonal_infoupdate_x_city" },
                        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
                    if (!el)
                        return;
                    options.closeOnSelect = !options.multiple;
                    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
                    if (fpersonal_infoupdate.lists.city?.lookupOptions.length) {
                        options.data = { id: "x_city", form: "fpersonal_infoupdate" };
                    } else {
                        options.ajax = { id: "x_city", form: "fpersonal_infoupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options.minimumResultsForSearch = Infinity;
                    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.personal_info.fields.city.selectOptions);
                    ew.createSelect(options);
                });
                </script>
                <?php } ?>
                </span>
                <?php } else { ?>
                <span id="el_personal_info_city">
                <span<?= $Page->city->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->city->getDisplayValue($Page->city->ViewValue) ?></span></span>
                <input type="hidden" data-table="personal_info" data-field="x_city" data-hidden="1" name="x_city" id="x_city" value="<?= HtmlEncode($Page->city->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->city_name->Visible && (!$Page->isConfirm() || $Page->city_name->multiUpdateSelected())) { // city_name ?>
    <div id="r_city_name"<?= $Page->city_name->rowAttributes() ?>>
        <label for="x_city_name" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_city_name" id="u_city_name" class="form-check-input ew-multi-select" value="1"<?= $Page->city_name->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_city_name"><?= $Page->city_name->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_city_name" id="u_city_name" value="<?= $Page->city_name->MultiUpdate ?>">
            <?= $Page->city_name->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->city_name->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_personal_info_city_name">
                <input type="<?= $Page->city_name->getInputTextType() ?>" name="x_city_name" id="x_city_name" data-table="personal_info" data-field="x_city_name" value="<?= $Page->city_name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->city_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->city_name->formatPattern()) ?>"<?= $Page->city_name->editAttributes() ?> aria-describedby="x_city_name_help">
                <?= $Page->city_name->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->city_name->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_personal_info_city_name">
                <span<?= $Page->city_name->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->city_name->getDisplayValue($Page->city_name->ViewValue))) ?>"></span>
                <input type="hidden" data-table="personal_info" data-field="x_city_name" data-hidden="1" name="x_city_name" id="x_city_name" value="<?= HtmlEncode($Page->city_name->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->dob->Visible && (!$Page->isConfirm() || $Page->dob->multiUpdateSelected())) { // dob ?>
    <div id="r_dob"<?= $Page->dob->rowAttributes() ?>>
        <label for="x_dob" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_dob" id="u_dob" class="form-check-input ew-multi-select" value="1"<?= $Page->dob->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_dob"><?= $Page->dob->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_dob" id="u_dob" value="<?= $Page->dob->MultiUpdate ?>">
            <?= $Page->dob->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->dob->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_personal_info_dob">
                <input type="<?= $Page->dob->getInputTextType() ?>" name="x_dob" id="x_dob" data-table="personal_info" data-field="x_dob" value="<?= $Page->dob->EditValue ?>" placeholder="<?= HtmlEncode($Page->dob->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dob->formatPattern()) ?>"<?= $Page->dob->editAttributes() ?> aria-describedby="x_dob_help">
                <?= $Page->dob->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->dob->getErrorMessage() ?></div>
                <?php if (!$Page->dob->ReadOnly && !$Page->dob->Disabled && !isset($Page->dob->EditAttrs["readonly"]) && !isset($Page->dob->EditAttrs["disabled"])) { ?>
                <script>
                loadjs.ready(["fpersonal_infoupdate", "datetimepicker"], function () {
                    let format = "<?= DateFormat(7) ?>",
                        options = {
                            localization: {
                                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                                hourCycle: format.match(/H/) ? "h24" : "h12",
                                format,
                                ...ew.language.phrase("datetimepicker")
                            },
                            display: {
                                icons: {
                                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                                },
                                components: {
                                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                                    hours: !!format.match(/h/i),
                                    minutes: !!format.match(/m/),
                                    seconds: !!format.match(/s/i)
                                },
                                theme: ew.getPreferredTheme()
                            }
                        };
                    ew.createDateTimePicker("fpersonal_infoupdate", "x_dob", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
                });
                </script>
                <?php } ?>
                </span>
                <?php } else { ?>
                <span id="el_personal_info_dob">
                <span<?= $Page->dob->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->dob->getDisplayValue($Page->dob->ViewValue))) ?>"></span>
                <input type="hidden" data-table="personal_info" data-field="x_dob" data-hidden="1" name="x_dob" id="x_dob" value="<?= HtmlEncode($Page->dob->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->dom->Visible && (!$Page->isConfirm() || $Page->dom->multiUpdateSelected())) { // dom ?>
    <div id="r_dom"<?= $Page->dom->rowAttributes() ?>>
        <label for="x_dom" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_dom" id="u_dom" class="form-check-input ew-multi-select" value="1"<?= $Page->dom->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_dom"><?= $Page->dom->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_dom" id="u_dom" value="<?= $Page->dom->MultiUpdate ?>">
            <?= $Page->dom->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->dom->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_personal_info_dom">
                <input type="<?= $Page->dom->getInputTextType() ?>" name="x_dom" id="x_dom" data-table="personal_info" data-field="x_dom" value="<?= $Page->dom->EditValue ?>" placeholder="<?= HtmlEncode($Page->dom->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dom->formatPattern()) ?>"<?= $Page->dom->editAttributes() ?> aria-describedby="x_dom_help">
                <?= $Page->dom->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->dom->getErrorMessage() ?></div>
                <?php if (!$Page->dom->ReadOnly && !$Page->dom->Disabled && !isset($Page->dom->EditAttrs["readonly"]) && !isset($Page->dom->EditAttrs["disabled"])) { ?>
                <script>
                loadjs.ready(["fpersonal_infoupdate", "datetimepicker"], function () {
                    let format = "<?= DateFormat(7) ?>",
                        options = {
                            localization: {
                                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                                hourCycle: format.match(/H/) ? "h24" : "h12",
                                format,
                                ...ew.language.phrase("datetimepicker")
                            },
                            display: {
                                icons: {
                                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                                },
                                components: {
                                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                                    hours: !!format.match(/h/i),
                                    minutes: !!format.match(/m/),
                                    seconds: !!format.match(/s/i)
                                },
                                theme: ew.getPreferredTheme()
                            }
                        };
                    ew.createDateTimePicker("fpersonal_infoupdate", "x_dom", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
                });
                </script>
                <?php } ?>
                </span>
                <?php } else { ?>
                <span id="el_personal_info_dom">
                <span<?= $Page->dom->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->dom->getDisplayValue($Page->dom->ViewValue))) ?>"></span>
                <input type="hidden" data-table="personal_info" data-field="x_dom" data-hidden="1" name="x_dom" id="x_dom" value="<?= HtmlEncode($Page->dom->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->marital_status->Visible && (!$Page->isConfirm() || $Page->marital_status->multiUpdateSelected())) { // marital_status ?>
    <div id="r_marital_status"<?= $Page->marital_status->rowAttributes() ?>>
        <label for="x_marital_status" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_marital_status" id="u_marital_status" class="form-check-input ew-multi-select" value="1"<?= $Page->marital_status->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_marital_status"><?= $Page->marital_status->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_marital_status" id="u_marital_status" value="<?= $Page->marital_status->MultiUpdate ?>">
            <?= $Page->marital_status->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->marital_status->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_personal_info_marital_status">
                    <select
                        id="x_marital_status"
                        name="x_marital_status"
                        class="form-select ew-select<?= $Page->marital_status->isInvalidClass() ?>"
                        <?php if (!$Page->marital_status->IsNativeSelect) { ?>
                        data-select2-id="fpersonal_infoupdate_x_marital_status"
                        <?php } ?>
                        data-table="personal_info"
                        data-field="x_marital_status"
                        data-value-separator="<?= $Page->marital_status->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->marital_status->getPlaceHolder()) ?>"
                        <?= $Page->marital_status->editAttributes() ?>>
                        <?= $Page->marital_status->selectOptionListHtml("x_marital_status") ?>
                    </select>
                    <?= $Page->marital_status->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->marital_status->getErrorMessage() ?></div>
                <?php if (!$Page->marital_status->IsNativeSelect) { ?>
                <script>
                loadjs.ready("fpersonal_infoupdate", function() {
                    var options = { name: "x_marital_status", selectId: "fpersonal_infoupdate_x_marital_status" },
                        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
                    if (!el)
                        return;
                    options.closeOnSelect = !options.multiple;
                    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
                    if (fpersonal_infoupdate.lists.marital_status?.lookupOptions.length) {
                        options.data = { id: "x_marital_status", form: "fpersonal_infoupdate" };
                    } else {
                        options.ajax = { id: "x_marital_status", form: "fpersonal_infoupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options.minimumResultsForSearch = Infinity;
                    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.personal_info.fields.marital_status.selectOptions);
                    ew.createSelect(options);
                });
                </script>
                <?php } ?>
                </span>
                <?php } else { ?>
                <span id="el_personal_info_marital_status">
                <span<?= $Page->marital_status->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->marital_status->getDisplayValue($Page->marital_status->ViewValue) ?></span></span>
                <input type="hidden" data-table="personal_info" data-field="x_marital_status" data-hidden="1" name="x_marital_status" id="x_marital_status" value="<?= HtmlEncode($Page->marital_status->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->spouse_details->Visible && (!$Page->isConfirm() || $Page->spouse_details->multiUpdateSelected())) { // spouse_details ?>
    <div id="r_spouse_details"<?= $Page->spouse_details->rowAttributes() ?>>
        <label for="x_spouse_details" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_spouse_details" id="u_spouse_details" class="form-check-input ew-multi-select" value="1"<?= $Page->spouse_details->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_spouse_details"><?= $Page->spouse_details->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_spouse_details" id="u_spouse_details" value="<?= $Page->spouse_details->MultiUpdate ?>">
            <?= $Page->spouse_details->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->spouse_details->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_personal_info_spouse_details">
                <input type="<?= $Page->spouse_details->getInputTextType() ?>" name="x_spouse_details" id="x_spouse_details" data-table="personal_info" data-field="x_spouse_details" value="<?= $Page->spouse_details->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->spouse_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->spouse_details->formatPattern()) ?>"<?= $Page->spouse_details->editAttributes() ?> aria-describedby="x_spouse_details_help">
                <?= $Page->spouse_details->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->spouse_details->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_personal_info_spouse_details">
                <span<?= $Page->spouse_details->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->spouse_details->getDisplayValue($Page->spouse_details->ViewValue))) ?>"></span>
                <input type="hidden" data-table="personal_info" data-field="x_spouse_details" data-hidden="1" name="x_spouse_details" id="x_spouse_details" value="<?= HtmlEncode($Page->spouse_details->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->image->Visible && (!$Page->isConfirm() || $Page->image->multiUpdateSelected())) { // image ?>
    <div id="r_image"<?= $Page->image->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_image" id="u_image" class="form-check-input ew-multi-select" value="1"<?= $Page->image->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_image"><?= $Page->image->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_image" id="u_image" value="<?= $Page->image->MultiUpdate ?>">
            <?= $Page->image->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->image->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_personal_info_image">
                <div id="fd_x_image" class="fileinput-button ew-file-drop-zone">
                    <input
                        type="file"
                        id="x_image"
                        name="x_image"
                        class="form-control ew-file-input"
                        title="<?= $Page->image->title() ?>"
                        lang="<?= CurrentLanguageID() ?>"
                        data-table="personal_info"
                        data-field="x_image"
                        data-size="48"
                        data-accept-file-types="<?= $Page->image->acceptFileTypes() ?>"
                        data-max-file-size="<?= $Page->image->UploadMaxFileSize ?>"
                        data-max-number-of-files="null"
                        data-disable-image-crop="<?= $Page->image->ImageCropper ? 0 : 1 ?>"
                        aria-describedby="x_image_help"
                        <?= ($Page->image->ReadOnly || $Page->image->Disabled) ? " disabled" : "" ?>
                        <?= $Page->image->editAttributes() ?>
                    >
                    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFile") ?></div>
                    <?= $Page->image->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->image->getErrorMessage() ?></div>
                </div>
                <input type="hidden" name="fn_x_image" id= "fn_x_image" value="<?= $Page->image->Upload->FileName ?>">
                <input type="hidden" name="fa_x_image" id= "fa_x_image" value="<?= (Post("fa_x_image") == "0") ? "0" : "1" ?>">
                <table id="ft_x_image" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
                </span>
                <?php } else { ?>
                <span id="el_personal_info_image">
                <div id="fd_x_image">
                    <input
                        type="file"
                        id="x_image"
                        name="x_image"
                        class="form-control ew-file-input d-none"
                        title="<?= $Page->image->title() ?>"
                        lang="<?= CurrentLanguageID() ?>"
                        data-table="personal_info"
                        data-field="x_image"
                        data-size="48"
                        data-accept-file-types="<?= $Page->image->acceptFileTypes() ?>"
                        data-max-file-size="<?= $Page->image->UploadMaxFileSize ?>"
                        data-max-number-of-files="null"
                        data-disable-image-crop="<?= $Page->image->ImageCropper ? 0 : 1 ?>"
                        aria-describedby="x_image_help"
                        <?= $Page->image->editAttributes() ?>
                    >
                    <?= $Page->image->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->image->getErrorMessage() ?></div>
                </div>
                <input type="hidden" name="fn_x_image" id= "fn_x_image" value="<?= $Page->image->Upload->FileName ?>">
                <input type="hidden" name="fa_x_image" id= "fa_x_image" value="<?= (Post("fa_x_image") == "0") ? "0" : "1" ?>">
                <table id="ft_x_image" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->father_name->Visible && (!$Page->isConfirm() || $Page->father_name->multiUpdateSelected())) { // father_name ?>
    <div id="r_father_name"<?= $Page->father_name->rowAttributes() ?>>
        <label for="x_father_name" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_father_name" id="u_father_name" class="form-check-input ew-multi-select" value="1"<?= $Page->father_name->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_father_name"><?= $Page->father_name->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_father_name" id="u_father_name" value="<?= $Page->father_name->MultiUpdate ?>">
            <?= $Page->father_name->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->father_name->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_personal_info_father_name">
                <input type="<?= $Page->father_name->getInputTextType() ?>" name="x_father_name" id="x_father_name" data-table="personal_info" data-field="x_father_name" value="<?= $Page->father_name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->father_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->father_name->formatPattern()) ?>"<?= $Page->father_name->editAttributes() ?> aria-describedby="x_father_name_help">
                <?= $Page->father_name->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->father_name->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_personal_info_father_name">
                <span<?= $Page->father_name->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->father_name->getDisplayValue($Page->father_name->ViewValue))) ?>"></span>
                <input type="hidden" data-table="personal_info" data-field="x_father_name" data-hidden="1" name="x_father_name" id="x_father_name" value="<?= HtmlEncode($Page->father_name->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->mother_name->Visible && (!$Page->isConfirm() || $Page->mother_name->multiUpdateSelected())) { // mother_name ?>
    <div id="r_mother_name"<?= $Page->mother_name->rowAttributes() ?>>
        <label for="x_mother_name" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_mother_name" id="u_mother_name" class="form-check-input ew-multi-select" value="1"<?= $Page->mother_name->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_mother_name"><?= $Page->mother_name->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_mother_name" id="u_mother_name" value="<?= $Page->mother_name->MultiUpdate ?>">
            <?= $Page->mother_name->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->mother_name->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_personal_info_mother_name">
                <input type="<?= $Page->mother_name->getInputTextType() ?>" name="x_mother_name" id="x_mother_name" data-table="personal_info" data-field="x_mother_name" value="<?= $Page->mother_name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->mother_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mother_name->formatPattern()) ?>"<?= $Page->mother_name->editAttributes() ?> aria-describedby="x_mother_name_help">
                <?= $Page->mother_name->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->mother_name->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_personal_info_mother_name">
                <span<?= $Page->mother_name->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->mother_name->getDisplayValue($Page->mother_name->ViewValue))) ?>"></span>
                <input type="hidden" data-table="personal_info" data-field="x_mother_name" data-hidden="1" name="x_mother_name" id="x_mother_name" value="<?= HtmlEncode($Page->mother_name->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->permanent_address->Visible && (!$Page->isConfirm() || $Page->permanent_address->multiUpdateSelected())) { // permanent_address ?>
    <div id="r_permanent_address"<?= $Page->permanent_address->rowAttributes() ?>>
        <label for="x_permanent_address" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_permanent_address" id="u_permanent_address" class="form-check-input ew-multi-select" value="1"<?= $Page->permanent_address->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_permanent_address"><?= $Page->permanent_address->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_permanent_address" id="u_permanent_address" value="<?= $Page->permanent_address->MultiUpdate ?>">
            <?= $Page->permanent_address->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->permanent_address->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_personal_info_permanent_address">
                <input type="<?= $Page->permanent_address->getInputTextType() ?>" name="x_permanent_address" id="x_permanent_address" data-table="personal_info" data-field="x_permanent_address" value="<?= $Page->permanent_address->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->permanent_address->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->permanent_address->formatPattern()) ?>"<?= $Page->permanent_address->editAttributes() ?> aria-describedby="x_permanent_address_help">
                <?= $Page->permanent_address->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->permanent_address->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_personal_info_permanent_address">
                <span<?= $Page->permanent_address->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->permanent_address->getDisplayValue($Page->permanent_address->ViewValue))) ?>"></span>
                <input type="hidden" data-table="personal_info" data-field="x_permanent_address" data-hidden="1" name="x_permanent_address" id="x_permanent_address" value="<?= HtmlEncode($Page->permanent_address->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->mobile_other->Visible && (!$Page->isConfirm() || $Page->mobile_other->multiUpdateSelected())) { // mobile_other ?>
    <div id="r_mobile_other"<?= $Page->mobile_other->rowAttributes() ?>>
        <label for="x_mobile_other" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_mobile_other" id="u_mobile_other" class="form-check-input ew-multi-select" value="1"<?= $Page->mobile_other->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_mobile_other"><?= $Page->mobile_other->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_mobile_other" id="u_mobile_other" value="<?= $Page->mobile_other->MultiUpdate ?>">
            <?= $Page->mobile_other->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->mobile_other->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_personal_info_mobile_other">
                <input type="<?= $Page->mobile_other->getInputTextType() ?>" name="x_mobile_other" id="x_mobile_other" data-table="personal_info" data-field="x_mobile_other" value="<?= $Page->mobile_other->EditValue ?>" size="30" maxlength="60" placeholder="<?= HtmlEncode($Page->mobile_other->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile_other->formatPattern()) ?>"<?= $Page->mobile_other->editAttributes() ?> aria-describedby="x_mobile_other_help">
                <?= $Page->mobile_other->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->mobile_other->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_personal_info_mobile_other">
                <span<?= $Page->mobile_other->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->mobile_other->getDisplayValue($Page->mobile_other->ViewValue))) ?>"></span>
                <input type="hidden" data-table="personal_info" data-field="x_mobile_other" data-hidden="1" name="x_mobile_other" id="x_mobile_other" value="<?= HtmlEncode($Page->mobile_other->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->mobile_family->Visible && (!$Page->isConfirm() || $Page->mobile_family->multiUpdateSelected())) { // mobile_family ?>
    <div id="r_mobile_family"<?= $Page->mobile_family->rowAttributes() ?>>
        <label for="x_mobile_family" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_mobile_family" id="u_mobile_family" class="form-check-input ew-multi-select" value="1"<?= $Page->mobile_family->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_mobile_family"><?= $Page->mobile_family->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_mobile_family" id="u_mobile_family" value="<?= $Page->mobile_family->MultiUpdate ?>">
            <?= $Page->mobile_family->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->mobile_family->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_personal_info_mobile_family">
                <input type="<?= $Page->mobile_family->getInputTextType() ?>" name="x_mobile_family" id="x_mobile_family" data-table="personal_info" data-field="x_mobile_family" value="<?= $Page->mobile_family->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->mobile_family->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile_family->formatPattern()) ?>"<?= $Page->mobile_family->editAttributes() ?> aria-describedby="x_mobile_family_help">
                <?= $Page->mobile_family->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->mobile_family->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_personal_info_mobile_family">
                <span<?= $Page->mobile_family->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->mobile_family->getDisplayValue($Page->mobile_family->ViewValue))) ?>"></span>
                <input type="hidden" data-table="personal_info" data-field="x_mobile_family" data-hidden="1" name="x_mobile_family" id="x_mobile_family" value="<?= HtmlEncode($Page->mobile_family->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->emergency_details->Visible && (!$Page->isConfirm() || $Page->emergency_details->multiUpdateSelected())) { // emergency_details ?>
    <div id="r_emergency_details"<?= $Page->emergency_details->rowAttributes() ?>>
        <label for="x_emergency_details" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_emergency_details" id="u_emergency_details" class="form-check-input ew-multi-select" value="1"<?= $Page->emergency_details->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_emergency_details"><?= $Page->emergency_details->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_emergency_details" id="u_emergency_details" value="<?= $Page->emergency_details->MultiUpdate ?>">
            <?= $Page->emergency_details->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->emergency_details->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_personal_info_emergency_details">
                <input type="<?= $Page->emergency_details->getInputTextType() ?>" name="x_emergency_details" id="x_emergency_details" data-table="personal_info" data-field="x_emergency_details" value="<?= $Page->emergency_details->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->emergency_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->emergency_details->formatPattern()) ?>"<?= $Page->emergency_details->editAttributes() ?> aria-describedby="x_emergency_details_help">
                <?= $Page->emergency_details->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->emergency_details->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_personal_info_emergency_details">
                <span<?= $Page->emergency_details->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->emergency_details->getDisplayValue($Page->emergency_details->ViewValue))) ?>"></span>
                <input type="hidden" data-table="personal_info" data-field="x_emergency_details" data-hidden="1" name="x_emergency_details" id="x_emergency_details" value="<?= HtmlEncode($Page->emergency_details->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->annual_income->Visible && (!$Page->isConfirm() || $Page->annual_income->multiUpdateSelected())) { // annual_income ?>
    <div id="r_annual_income"<?= $Page->annual_income->rowAttributes() ?>>
        <label for="x_annual_income" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_annual_income" id="u_annual_income" class="form-check-input ew-multi-select" value="1"<?= $Page->annual_income->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_annual_income"><?= $Page->annual_income->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_annual_income" id="u_annual_income" value="<?= $Page->annual_income->MultiUpdate ?>">
            <?= $Page->annual_income->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->annual_income->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_personal_info_annual_income">
                <input type="<?= $Page->annual_income->getInputTextType() ?>" name="x_annual_income" id="x_annual_income" data-table="personal_info" data-field="x_annual_income" value="<?= $Page->annual_income->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->annual_income->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->annual_income->formatPattern()) ?>"<?= $Page->annual_income->editAttributes() ?> aria-describedby="x_annual_income_help">
                <?= $Page->annual_income->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->annual_income->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_personal_info_annual_income">
                <span<?= $Page->annual_income->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->annual_income->getDisplayValue($Page->annual_income->ViewValue))) ?>"></span>
                <input type="hidden" data-table="personal_info" data-field="x_annual_income" data-hidden="1" name="x_annual_income" id="x_annual_income" value="<?= HtmlEncode($Page->annual_income->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->work_details->Visible && (!$Page->isConfirm() || $Page->work_details->multiUpdateSelected())) { // work_details ?>
    <div id="r_work_details"<?= $Page->work_details->rowAttributes() ?>>
        <label for="x_work_details" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_work_details" id="u_work_details" class="form-check-input ew-multi-select" value="1"<?= $Page->work_details->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_work_details"><?= $Page->work_details->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_work_details" id="u_work_details" value="<?= $Page->work_details->MultiUpdate ?>">
            <?= $Page->work_details->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->work_details->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_personal_info_work_details">
                <input type="<?= $Page->work_details->getInputTextType() ?>" name="x_work_details" id="x_work_details" data-table="personal_info" data-field="x_work_details" value="<?= $Page->work_details->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->work_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->work_details->formatPattern()) ?>"<?= $Page->work_details->editAttributes() ?> aria-describedby="x_work_details_help">
                <?= $Page->work_details->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->work_details->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_personal_info_work_details">
                <span<?= $Page->work_details->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->work_details->getDisplayValue($Page->work_details->ViewValue))) ?>"></span>
                <input type="hidden" data-table="personal_info" data-field="x_work_details" data-hidden="1" name="x_work_details" id="x_work_details" value="<?= HtmlEncode($Page->work_details->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible && (!$Page->isConfirm() || $Page->status->multiUpdateSelected())) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_status" id="u_status" class="form-check-input ew-multi-select" value="1"<?= $Page->status->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_status"><?= $Page->status->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_status" id="u_status" value="<?= $Page->status->MultiUpdate ?>">
            <?= $Page->status->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_personal_info_status">
                    <select
                        id="x_status"
                        name="x_status"
                        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
                        <?php if (!$Page->status->IsNativeSelect) { ?>
                        data-select2-id="fpersonal_infoupdate_x_status"
                        <?php } ?>
                        data-table="personal_info"
                        data-field="x_status"
                        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
                        <?= $Page->status->editAttributes() ?>>
                        <?= $Page->status->selectOptionListHtml("x_status") ?>
                    </select>
                    <?= $Page->status->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
                <?php if (!$Page->status->IsNativeSelect) { ?>
                <script>
                loadjs.ready("fpersonal_infoupdate", function() {
                    var options = { name: "x_status", selectId: "fpersonal_infoupdate_x_status" },
                        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
                    if (!el)
                        return;
                    options.closeOnSelect = !options.multiple;
                    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
                    if (fpersonal_infoupdate.lists.status?.lookupOptions.length) {
                        options.data = { id: "x_status", form: "fpersonal_infoupdate" };
                    } else {
                        options.ajax = { id: "x_status", form: "fpersonal_infoupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options.minimumResultsForSearch = Infinity;
                    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.personal_info.fields.status.selectOptions);
                    ew.createSelect(options);
                });
                </script>
                <?php } ?>
                </span>
                <?php } else { ?>
                <span id="el_personal_info_status">
                <span<?= $Page->status->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->status->getDisplayValue($Page->status->ViewValue) ?></span></span>
                <input type="hidden" data-table="personal_info" data-field="x_status" data-hidden="1" name="x_status" id="x_status" value="<?= HtmlEncode($Page->status->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->gst->Visible && (!$Page->isConfirm() || $Page->gst->multiUpdateSelected())) { // gst ?>
    <div id="r_gst"<?= $Page->gst->rowAttributes() ?>>
        <label for="x_gst" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_gst" id="u_gst" class="form-check-input ew-multi-select" value="1"<?= $Page->gst->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_gst"><?= $Page->gst->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_gst" id="u_gst" value="<?= $Page->gst->MultiUpdate ?>">
            <?= $Page->gst->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->gst->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_personal_info_gst">
                <input type="<?= $Page->gst->getInputTextType() ?>" name="x_gst" id="x_gst" data-table="personal_info" data-field="x_gst" value="<?= $Page->gst->EditValue ?>" size="30" maxlength="15" placeholder="<?= HtmlEncode($Page->gst->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->gst->formatPattern()) ?>"<?= $Page->gst->editAttributes() ?> aria-describedby="x_gst_help">
                <?= $Page->gst->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->gst->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_personal_info_gst">
                <span<?= $Page->gst->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->gst->getDisplayValue($Page->gst->ViewValue))) ?>"></span>
                <input type="hidden" data-table="personal_info" data-field="x_gst" data-hidden="1" name="x_gst" id="x_gst" value="<?= HtmlEncode($Page->gst->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->aadhaar_no->Visible && (!$Page->isConfirm() || $Page->aadhaar_no->multiUpdateSelected())) { // aadhaar_no ?>
    <div id="r_aadhaar_no"<?= $Page->aadhaar_no->rowAttributes() ?>>
        <label for="x_aadhaar_no" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_aadhaar_no" id="u_aadhaar_no" class="form-check-input ew-multi-select" value="1"<?= $Page->aadhaar_no->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_aadhaar_no"><?= $Page->aadhaar_no->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_aadhaar_no" id="u_aadhaar_no" value="<?= $Page->aadhaar_no->MultiUpdate ?>">
            <?= $Page->aadhaar_no->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->aadhaar_no->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_personal_info_aadhaar_no">
                <input type="<?= $Page->aadhaar_no->getInputTextType() ?>" name="x_aadhaar_no" id="x_aadhaar_no" data-table="personal_info" data-field="x_aadhaar_no" value="<?= $Page->aadhaar_no->EditValue ?>" size="30" maxlength="14" placeholder="<?= HtmlEncode($Page->aadhaar_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->aadhaar_no->formatPattern()) ?>"<?= $Page->aadhaar_no->editAttributes() ?> aria-describedby="x_aadhaar_no_help">
                <?= $Page->aadhaar_no->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->aadhaar_no->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_personal_info_aadhaar_no">
                <span<?= $Page->aadhaar_no->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->aadhaar_no->getDisplayValue($Page->aadhaar_no->ViewValue))) ?>"></span>
                <input type="hidden" data-table="personal_info" data-field="x_aadhaar_no" data-hidden="1" name="x_aadhaar_no" id="x_aadhaar_no" value="<?= HtmlEncode($Page->aadhaar_no->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pan_no->Visible && (!$Page->isConfirm() || $Page->pan_no->multiUpdateSelected())) { // pan_no ?>
    <div id="r_pan_no"<?= $Page->pan_no->rowAttributes() ?>>
        <label for="x_pan_no" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_pan_no" id="u_pan_no" class="form-check-input ew-multi-select" value="1"<?= $Page->pan_no->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_pan_no"><?= $Page->pan_no->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_pan_no" id="u_pan_no" value="<?= $Page->pan_no->MultiUpdate ?>">
            <?= $Page->pan_no->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pan_no->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_personal_info_pan_no">
                <input type="<?= $Page->pan_no->getInputTextType() ?>" name="x_pan_no" id="x_pan_no" data-table="personal_info" data-field="x_pan_no" value="<?= $Page->pan_no->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Page->pan_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pan_no->formatPattern()) ?>"<?= $Page->pan_no->editAttributes() ?> aria-describedby="x_pan_no_help">
                <?= $Page->pan_no->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->pan_no->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_personal_info_pan_no">
                <span<?= $Page->pan_no->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->pan_no->getDisplayValue($Page->pan_no->ViewValue))) ?>"></span>
                <input type="hidden" data-table="personal_info" data-field="x_pan_no" data-hidden="1" name="x_pan_no" id="x_pan_no" value="<?= HtmlEncode($Page->pan_no->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->id_proof->Visible && (!$Page->isConfirm() || $Page->id_proof->multiUpdateSelected())) { // id_proof ?>
    <div id="r_id_proof"<?= $Page->id_proof->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_id_proof" id="u_id_proof" class="form-check-input ew-multi-select" value="1"<?= $Page->id_proof->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_id_proof"><?= $Page->id_proof->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_id_proof" id="u_id_proof" value="<?= $Page->id_proof->MultiUpdate ?>">
            <?= $Page->id_proof->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id_proof->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_personal_info_id_proof">
                <div id="fd_x_id_proof" class="fileinput-button ew-file-drop-zone">
                    <input
                        type="file"
                        id="x_id_proof"
                        name="x_id_proof"
                        class="form-control ew-file-input"
                        title="<?= $Page->id_proof->title() ?>"
                        lang="<?= CurrentLanguageID() ?>"
                        data-table="personal_info"
                        data-field="x_id_proof"
                        data-size="255"
                        data-accept-file-types="<?= $Page->id_proof->acceptFileTypes() ?>"
                        data-max-file-size="<?= $Page->id_proof->UploadMaxFileSize ?>"
                        data-max-number-of-files="<?= $Page->id_proof->UploadMaxFileCount ?>"
                        data-disable-image-crop="<?= $Page->id_proof->ImageCropper ? 0 : 1 ?>"
                        multiple
                        aria-describedby="x_id_proof_help"
                        <?= ($Page->id_proof->ReadOnly || $Page->id_proof->Disabled) ? " disabled" : "" ?>
                        <?= $Page->id_proof->editAttributes() ?>
                    >
                    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFiles") ?></div>
                    <?= $Page->id_proof->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->id_proof->getErrorMessage() ?></div>
                </div>
                <input type="hidden" name="fn_x_id_proof" id= "fn_x_id_proof" value="<?= $Page->id_proof->Upload->FileName ?>">
                <input type="hidden" name="fa_x_id_proof" id= "fa_x_id_proof" value="<?= (Post("fa_x_id_proof") == "0") ? "0" : "1" ?>">
                <table id="ft_x_id_proof" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
                </span>
                <?php } else { ?>
                <span id="el_personal_info_id_proof">
                <div id="fd_x_id_proof">
                    <input
                        type="file"
                        id="x_id_proof"
                        name="x_id_proof"
                        class="form-control ew-file-input d-none"
                        title="<?= $Page->id_proof->title() ?>"
                        lang="<?= CurrentLanguageID() ?>"
                        data-table="personal_info"
                        data-field="x_id_proof"
                        data-size="255"
                        data-accept-file-types="<?= $Page->id_proof->acceptFileTypes() ?>"
                        data-max-file-size="<?= $Page->id_proof->UploadMaxFileSize ?>"
                        data-max-number-of-files="<?= $Page->id_proof->UploadMaxFileCount ?>"
                        data-disable-image-crop="<?= $Page->id_proof->ImageCropper ? 0 : 1 ?>"
                        multiple
                        aria-describedby="x_id_proof_help"
                        <?= $Page->id_proof->editAttributes() ?>
                    >
                    <?= $Page->id_proof->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->id_proof->getErrorMessage() ?></div>
                </div>
                <input type="hidden" name="fn_x_id_proof" id= "fn_x_id_proof" value="<?= $Page->id_proof->Upload->FileName ?>">
                <input type="hidden" name="fa_x_id_proof" id= "fa_x_id_proof" value="<?= (Post("fa_x_id_proof") == "0") ? "0" : "1" ?>">
                <table id="ft_x_id_proof" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->reference_details->Visible && (!$Page->isConfirm() || $Page->reference_details->multiUpdateSelected())) { // reference_details ?>
    <div id="r_reference_details"<?= $Page->reference_details->rowAttributes() ?>>
        <label for="x_reference_details" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_reference_details" id="u_reference_details" class="form-check-input ew-multi-select" value="1"<?= $Page->reference_details->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_reference_details"><?= $Page->reference_details->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_reference_details" id="u_reference_details" value="<?= $Page->reference_details->MultiUpdate ?>">
            <?= $Page->reference_details->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->reference_details->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_personal_info_reference_details">
                <input type="<?= $Page->reference_details->getInputTextType() ?>" name="x_reference_details" id="x_reference_details" data-table="personal_info" data-field="x_reference_details" value="<?= $Page->reference_details->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->reference_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->reference_details->formatPattern()) ?>"<?= $Page->reference_details->editAttributes() ?> aria-describedby="x_reference_details_help">
                <?= $Page->reference_details->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->reference_details->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_personal_info_reference_details">
                <span<?= $Page->reference_details->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->reference_details->getDisplayValue($Page->reference_details->ViewValue))) ?>"></span>
                <input type="hidden" data-table="personal_info" data-field="x_reference_details" data-hidden="1" name="x_reference_details" id="x_reference_details" value="<?= HtmlEncode($Page->reference_details->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->other_details->Visible && (!$Page->isConfirm() || $Page->other_details->multiUpdateSelected())) { // other_details ?>
    <div id="r_other_details"<?= $Page->other_details->rowAttributes() ?>>
        <label for="x_other_details" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_other_details" id="u_other_details" class="form-check-input ew-multi-select" value="1"<?= $Page->other_details->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_other_details"><?= $Page->other_details->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_other_details" id="u_other_details" value="<?= $Page->other_details->MultiUpdate ?>">
            <?= $Page->other_details->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->other_details->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_personal_info_other_details">
                <textarea data-table="personal_info" data-field="x_other_details" name="x_other_details" id="x_other_details" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->other_details->getPlaceHolder()) ?>"<?= $Page->other_details->editAttributes() ?> aria-describedby="x_other_details_help"><?= $Page->other_details->EditValue ?></textarea>
                <?= $Page->other_details->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->other_details->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_personal_info_other_details">
                <span<?= $Page->other_details->viewAttributes() ?>>
                <?= $Page->other_details->ViewValue ?></span>
                <input type="hidden" data-table="personal_info" data-field="x_other_details" data-hidden="1" name="x_other_details" id="x_other_details" value="<?= HtmlEncode($Page->other_details->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->bank_name->Visible && (!$Page->isConfirm() || $Page->bank_name->multiUpdateSelected())) { // bank_name ?>
    <div id="r_bank_name"<?= $Page->bank_name->rowAttributes() ?>>
        <label for="x_bank_name" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_bank_name" id="u_bank_name" class="form-check-input ew-multi-select" value="1"<?= $Page->bank_name->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_bank_name"><?= $Page->bank_name->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_bank_name" id="u_bank_name" value="<?= $Page->bank_name->MultiUpdate ?>">
            <?= $Page->bank_name->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->bank_name->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_personal_info_bank_name">
                <input type="<?= $Page->bank_name->getInputTextType() ?>" name="x_bank_name" id="x_bank_name" data-table="personal_info" data-field="x_bank_name" value="<?= $Page->bank_name->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->bank_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bank_name->formatPattern()) ?>"<?= $Page->bank_name->editAttributes() ?> aria-describedby="x_bank_name_help">
                <?= $Page->bank_name->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->bank_name->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_personal_info_bank_name">
                <span<?= $Page->bank_name->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->bank_name->getDisplayValue($Page->bank_name->ViewValue))) ?>"></span>
                <input type="hidden" data-table="personal_info" data-field="x_bank_name" data-hidden="1" name="x_bank_name" id="x_bank_name" value="<?= HtmlEncode($Page->bank_name->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->bank_ifsc_code->Visible && (!$Page->isConfirm() || $Page->bank_ifsc_code->multiUpdateSelected())) { // bank_ifsc_code ?>
    <div id="r_bank_ifsc_code"<?= $Page->bank_ifsc_code->rowAttributes() ?>>
        <label for="x_bank_ifsc_code" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_bank_ifsc_code" id="u_bank_ifsc_code" class="form-check-input ew-multi-select" value="1"<?= $Page->bank_ifsc_code->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_bank_ifsc_code"><?= $Page->bank_ifsc_code->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_bank_ifsc_code" id="u_bank_ifsc_code" value="<?= $Page->bank_ifsc_code->MultiUpdate ?>">
            <?= $Page->bank_ifsc_code->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->bank_ifsc_code->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_personal_info_bank_ifsc_code">
                <input type="<?= $Page->bank_ifsc_code->getInputTextType() ?>" name="x_bank_ifsc_code" id="x_bank_ifsc_code" data-table="personal_info" data-field="x_bank_ifsc_code" value="<?= $Page->bank_ifsc_code->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->bank_ifsc_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bank_ifsc_code->formatPattern()) ?>"<?= $Page->bank_ifsc_code->editAttributes() ?> aria-describedby="x_bank_ifsc_code_help">
                <?= $Page->bank_ifsc_code->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->bank_ifsc_code->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_personal_info_bank_ifsc_code">
                <span<?= $Page->bank_ifsc_code->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->bank_ifsc_code->getDisplayValue($Page->bank_ifsc_code->ViewValue))) ?>"></span>
                <input type="hidden" data-table="personal_info" data-field="x_bank_ifsc_code" data-hidden="1" name="x_bank_ifsc_code" id="x_bank_ifsc_code" value="<?= HtmlEncode($Page->bank_ifsc_code->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->bank_account_no->Visible && (!$Page->isConfirm() || $Page->bank_account_no->multiUpdateSelected())) { // bank_account_no ?>
    <div id="r_bank_account_no"<?= $Page->bank_account_no->rowAttributes() ?>>
        <label for="x_bank_account_no" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_bank_account_no" id="u_bank_account_no" class="form-check-input ew-multi-select" value="1"<?= $Page->bank_account_no->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_bank_account_no"><?= $Page->bank_account_no->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_bank_account_no" id="u_bank_account_no" value="<?= $Page->bank_account_no->MultiUpdate ?>">
            <?= $Page->bank_account_no->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->bank_account_no->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_personal_info_bank_account_no">
                <input type="<?= $Page->bank_account_no->getInputTextType() ?>" name="x_bank_account_no" id="x_bank_account_no" data-table="personal_info" data-field="x_bank_account_no" value="<?= $Page->bank_account_no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->bank_account_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bank_account_no->formatPattern()) ?>"<?= $Page->bank_account_no->editAttributes() ?> aria-describedby="x_bank_account_no_help">
                <?= $Page->bank_account_no->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->bank_account_no->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_personal_info_bank_account_no">
                <span<?= $Page->bank_account_no->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->bank_account_no->getDisplayValue($Page->bank_account_no->ViewValue))) ?>"></span>
                <input type="hidden" data-table="personal_info" data-field="x_bank_account_no" data-hidden="1" name="x_bank_account_no" id="x_bank_account_no" value="<?= HtmlEncode($Page->bank_account_no->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible && (!$Page->isConfirm() || $Page->operator->multiUpdateSelected())) { // operator ?>
    <div id="r_operator"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_operator" id="u_operator" class="form-check-input ew-multi-select" value="1"<?= $Page->operator->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_operator"><?= $Page->operator->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_operator" id="u_operator" value="<?= $Page->operator->MultiUpdate ?>">
            <?= $Page->operator->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <?php } else { ?>
                <span id="el_personal_info_operator">
                <span<?= $Page->operator->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->operator->getDisplayValue($Page->operator->ViewValue))) ?>"></span>
                <input type="hidden" data-table="personal_info" data-field="x_operator" data-hidden="1" name="x_operator" id="x_operator" value="<?= HtmlEncode($Page->operator->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible && (!$Page->isConfirm() || $Page->datetime->multiUpdateSelected())) { // datetime ?>
    <div id="r_datetime"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_datetime" id="u_datetime" class="form-check-input ew-multi-select" value="1"<?= $Page->datetime->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_datetime"><?= $Page->datetime->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_datetime" id="u_datetime" value="<?= $Page->datetime->MultiUpdate ?>">
            <?= $Page->datetime->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <?php } else { ?>
                <span id="el_personal_info_datetime">
                <span<?= $Page->datetime->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->datetime->getDisplayValue($Page->datetime->ViewValue))) ?>"></span>
                <input type="hidden" data-table="personal_info" data-field="x_datetime" data-hidden="1" name="x_datetime" id="x_datetime" value="<?= HtmlEncode($Page->datetime->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<?php if (!$Page->isConfirm()) { // Confirm page ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fpersonal_infoupdate" data-ew-action="set-action" data-value="confirm"><?= $Language->phrase("UpdateBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpersonal_infoupdate" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fpersonal_infoupdate"><?= $Language->phrase("ConfirmBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="submit" form="fpersonal_infoupdate" data-ew-action="set-action" data-value="cancel"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("personal_info");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
