<?php

namespace PHPMaker2024\fibre;

// Page object
$PersonalInfoSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { personal_info: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fpersonal_infosearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpersonal_infosearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["formal_name", [], fields.formal_name.isInvalid],
            ["gender", [], fields.gender.isInvalid],
            ["mobile", [ew.Validators.integer], fields.mobile.isInvalid],
            ["_email", [], fields._email.isInvalid],
            ["address", [], fields.address.isInvalid],
            ["country", [], fields.country.isInvalid],
            ["state", [], fields.state.isInvalid],
            ["city", [], fields.city.isInvalid],
            ["city_name", [], fields.city_name.isInvalid],
            ["dob", [ew.Validators.datetime(fields.dob.clientFormatPattern)], fields.dob.isInvalid],
            ["dom", [ew.Validators.datetime(fields.dom.clientFormatPattern)], fields.dom.isInvalid],
            ["marital_status", [], fields.marital_status.isInvalid],
            ["spouse_details", [], fields.spouse_details.isInvalid],
            ["image", [], fields.image.isInvalid],
            ["father_name", [], fields.father_name.isInvalid],
            ["mother_name", [], fields.mother_name.isInvalid],
            ["permanent_address", [], fields.permanent_address.isInvalid],
            ["mobile_other", [], fields.mobile_other.isInvalid],
            ["mobile_family", [], fields.mobile_family.isInvalid],
            ["emergency_details", [], fields.emergency_details.isInvalid],
            ["annual_income", [ew.Validators.integer], fields.annual_income.isInvalid],
            ["work_details", [], fields.work_details.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["gst", [], fields.gst.isInvalid],
            ["aadhaar_no", [ew.Validators.regex(/^[2-9]{1}[0-9]{3}\s[0-9]{4}\s[0-9]{4}$/)], fields.aadhaar_no.isInvalid],
            ["pan_no", [ew.Validators.regex(/([A-Z]){5}([0-9]){4}([A-Z]){1}$/)], fields.pan_no.isInvalid],
            ["id_proof", [], fields.id_proof.isInvalid],
            ["reference_details", [], fields.reference_details.isInvalid],
            ["other_details", [], fields.other_details.isInvalid],
            ["bank_name", [], fields.bank_name.isInvalid],
            ["bank_ifsc_code", [], fields.bank_ifsc_code.isInvalid],
            ["bank_account_no", [], fields.bank_account_no.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "gender": <?= $Page->gender->toClientList($Page) ?>,
            "country": <?= $Page->country->toClientList($Page) ?>,
            "state": <?= $Page->state->toClientList($Page) ?>,
            "city": <?= $Page->city->toClientList($Page) ?>,
            "marital_status": <?= $Page->marital_status->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fpersonal_infosearch" id="fpersonal_infosearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="personal_info">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->formal_name->Visible) { // formal_name ?>
    <div id="r_formal_name" class="row"<?= $Page->formal_name->rowAttributes() ?>>
        <label for="x_formal_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_personal_info_formal_name"><?= $Page->formal_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_formal_name" id="z_formal_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->formal_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_personal_info_formal_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->formal_name->getInputTextType() ?>" name="x_formal_name" id="x_formal_name" data-table="personal_info" data-field="x_formal_name" value="<?= $Page->formal_name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->formal_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->formal_name->formatPattern()) ?>"<?= $Page->formal_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->formal_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->gender->Visible) { // gender ?>
    <div id="r_gender" class="row"<?= $Page->gender->rowAttributes() ?>>
        <label for="x_gender" class="<?= $Page->LeftColumnClass ?>"><span id="elh_personal_info_gender"><?= $Page->gender->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_gender" id="z_gender" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->gender->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_personal_info_gender" class="ew-search-field ew-search-field-single">
    <select
        id="x_gender"
        name="x_gender"
        class="form-select ew-select<?= $Page->gender->isInvalidClass() ?>"
        <?php if (!$Page->gender->IsNativeSelect) { ?>
        data-select2-id="fpersonal_infosearch_x_gender"
        <?php } ?>
        data-table="personal_info"
        data-field="x_gender"
        data-value-separator="<?= $Page->gender->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->gender->getPlaceHolder()) ?>"
        <?= $Page->gender->editAttributes() ?>>
        <?= $Page->gender->selectOptionListHtml("x_gender") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->gender->getErrorMessage(false) ?></div>
<?php if (!$Page->gender->IsNativeSelect) { ?>
<script>
loadjs.ready("fpersonal_infosearch", function() {
    var options = { name: "x_gender", selectId: "fpersonal_infosearch_x_gender" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpersonal_infosearch.lists.gender?.lookupOptions.length) {
        options.data = { id: "x_gender", form: "fpersonal_infosearch" };
    } else {
        options.ajax = { id: "x_gender", form: "fpersonal_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.personal_info.fields.gender.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->mobile->Visible) { // mobile ?>
    <div id="r_mobile" class="row"<?= $Page->mobile->rowAttributes() ?>>
        <label for="x_mobile" class="<?= $Page->LeftColumnClass ?>"><span id="elh_personal_info_mobile"><?= $Page->mobile->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_mobile" id="z_mobile" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->mobile->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_personal_info_mobile" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->mobile->getInputTextType() ?>" name="x_mobile" id="x_mobile" data-table="personal_info" data-field="x_mobile" value="<?= $Page->mobile->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile->formatPattern()) ?>"<?= $Page->mobile->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->mobile->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_email->Visible) { // email ?>
    <div id="r__email" class="row"<?= $Page->_email->rowAttributes() ?>>
        <label for="x__email" class="<?= $Page->LeftColumnClass ?>"><span id="elh_personal_info__email"><?= $Page->_email->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__email" id="z__email" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_email->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_personal_info__email" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_email->getInputTextType() ?>" name="x__email" id="x__email" data-table="personal_info" data-field="x__email" value="<?= $Page->_email->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->_email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_email->formatPattern()) ?>"<?= $Page->_email->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_email->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->address->Visible) { // address ?>
    <div id="r_address" class="row"<?= $Page->address->rowAttributes() ?>>
        <label for="x_address" class="<?= $Page->LeftColumnClass ?>"><span id="elh_personal_info_address"><?= $Page->address->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_address" id="z_address" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->address->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_personal_info_address" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->address->getInputTextType() ?>" name="x_address" id="x_address" data-table="personal_info" data-field="x_address" value="<?= $Page->address->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->address->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->address->formatPattern()) ?>"<?= $Page->address->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->address->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->country->Visible) { // country ?>
    <div id="r_country" class="row"<?= $Page->country->rowAttributes() ?>>
        <label for="x_country" class="<?= $Page->LeftColumnClass ?>"><span id="elh_personal_info_country"><?= $Page->country->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_country" id="z_country" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->country->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_personal_info_country" class="ew-search-field ew-search-field-single">
    <select
        id="x_country"
        name="x_country"
        class="form-select ew-select<?= $Page->country->isInvalidClass() ?>"
        <?php if (!$Page->country->IsNativeSelect) { ?>
        data-select2-id="fpersonal_infosearch_x_country"
        <?php } ?>
        data-table="personal_info"
        data-field="x_country"
        data-value-separator="<?= $Page->country->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->country->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->country->editAttributes() ?>>
        <?= $Page->country->selectOptionListHtml("x_country") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->country->getErrorMessage(false) ?></div>
<?= $Page->country->Lookup->getParamTag($Page, "p_x_country") ?>
<?php if (!$Page->country->IsNativeSelect) { ?>
<script>
loadjs.ready("fpersonal_infosearch", function() {
    var options = { name: "x_country", selectId: "fpersonal_infosearch_x_country" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpersonal_infosearch.lists.country?.lookupOptions.length) {
        options.data = { id: "x_country", form: "fpersonal_infosearch" };
    } else {
        options.ajax = { id: "x_country", form: "fpersonal_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.personal_info.fields.country.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->state->Visible) { // state ?>
    <div id="r_state" class="row"<?= $Page->state->rowAttributes() ?>>
        <label for="x_state" class="<?= $Page->LeftColumnClass ?>"><span id="elh_personal_info_state"><?= $Page->state->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_state" id="z_state" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->state->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_personal_info_state" class="ew-search-field ew-search-field-single">
    <select
        id="x_state"
        name="x_state"
        class="form-select ew-select<?= $Page->state->isInvalidClass() ?>"
        <?php if (!$Page->state->IsNativeSelect) { ?>
        data-select2-id="fpersonal_infosearch_x_state"
        <?php } ?>
        data-table="personal_info"
        data-field="x_state"
        data-value-separator="<?= $Page->state->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->state->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->state->editAttributes() ?>>
        <?= $Page->state->selectOptionListHtml("x_state") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->state->getErrorMessage(false) ?></div>
<?= $Page->state->Lookup->getParamTag($Page, "p_x_state") ?>
<?php if (!$Page->state->IsNativeSelect) { ?>
<script>
loadjs.ready("fpersonal_infosearch", function() {
    var options = { name: "x_state", selectId: "fpersonal_infosearch_x_state" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpersonal_infosearch.lists.state?.lookupOptions.length) {
        options.data = { id: "x_state", form: "fpersonal_infosearch" };
    } else {
        options.ajax = { id: "x_state", form: "fpersonal_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.personal_info.fields.state.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->city->Visible) { // city ?>
    <div id="r_city" class="row"<?= $Page->city->rowAttributes() ?>>
        <label for="x_city" class="<?= $Page->LeftColumnClass ?>"><span id="elh_personal_info_city"><?= $Page->city->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_city" id="z_city" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->city->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_personal_info_city" class="ew-search-field ew-search-field-single">
    <select
        id="x_city"
        name="x_city"
        class="form-select ew-select<?= $Page->city->isInvalidClass() ?>"
        <?php if (!$Page->city->IsNativeSelect) { ?>
        data-select2-id="fpersonal_infosearch_x_city"
        <?php } ?>
        data-table="personal_info"
        data-field="x_city"
        data-value-separator="<?= $Page->city->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->city->getPlaceHolder()) ?>"
        <?= $Page->city->editAttributes() ?>>
        <?= $Page->city->selectOptionListHtml("x_city") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->city->getErrorMessage(false) ?></div>
<?= $Page->city->Lookup->getParamTag($Page, "p_x_city") ?>
<?php if (!$Page->city->IsNativeSelect) { ?>
<script>
loadjs.ready("fpersonal_infosearch", function() {
    var options = { name: "x_city", selectId: "fpersonal_infosearch_x_city" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpersonal_infosearch.lists.city?.lookupOptions.length) {
        options.data = { id: "x_city", form: "fpersonal_infosearch" };
    } else {
        options.ajax = { id: "x_city", form: "fpersonal_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.personal_info.fields.city.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->city_name->Visible) { // city_name ?>
    <div id="r_city_name" class="row"<?= $Page->city_name->rowAttributes() ?>>
        <label for="x_city_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_personal_info_city_name"><?= $Page->city_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_city_name" id="z_city_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->city_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_personal_info_city_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->city_name->getInputTextType() ?>" name="x_city_name" id="x_city_name" data-table="personal_info" data-field="x_city_name" value="<?= $Page->city_name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->city_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->city_name->formatPattern()) ?>"<?= $Page->city_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->city_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->dob->Visible) { // dob ?>
    <div id="r_dob" class="row"<?= $Page->dob->rowAttributes() ?>>
        <label for="x_dob" class="<?= $Page->LeftColumnClass ?>"><span id="elh_personal_info_dob"><?= $Page->dob->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_dob" id="z_dob" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->dob->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_personal_info_dob" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->dob->getInputTextType() ?>" name="x_dob" id="x_dob" data-table="personal_info" data-field="x_dob" value="<?= $Page->dob->EditValue ?>" placeholder="<?= HtmlEncode($Page->dob->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dob->formatPattern()) ?>"<?= $Page->dob->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dob->getErrorMessage(false) ?></div>
<?php if (!$Page->dob->ReadOnly && !$Page->dob->Disabled && !isset($Page->dob->EditAttrs["readonly"]) && !isset($Page->dob->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpersonal_infosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpersonal_infosearch", "x_dob", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->dom->Visible) { // dom ?>
    <div id="r_dom" class="row"<?= $Page->dom->rowAttributes() ?>>
        <label for="x_dom" class="<?= $Page->LeftColumnClass ?>"><span id="elh_personal_info_dom"><?= $Page->dom->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_dom" id="z_dom" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->dom->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_personal_info_dom" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->dom->getInputTextType() ?>" name="x_dom" id="x_dom" data-table="personal_info" data-field="x_dom" value="<?= $Page->dom->EditValue ?>" placeholder="<?= HtmlEncode($Page->dom->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dom->formatPattern()) ?>"<?= $Page->dom->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dom->getErrorMessage(false) ?></div>
<?php if (!$Page->dom->ReadOnly && !$Page->dom->Disabled && !isset($Page->dom->EditAttrs["readonly"]) && !isset($Page->dom->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpersonal_infosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpersonal_infosearch", "x_dom", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->marital_status->Visible) { // marital_status ?>
    <div id="r_marital_status" class="row"<?= $Page->marital_status->rowAttributes() ?>>
        <label for="x_marital_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_personal_info_marital_status"><?= $Page->marital_status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_marital_status" id="z_marital_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->marital_status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_personal_info_marital_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_marital_status"
        name="x_marital_status"
        class="form-select ew-select<?= $Page->marital_status->isInvalidClass() ?>"
        <?php if (!$Page->marital_status->IsNativeSelect) { ?>
        data-select2-id="fpersonal_infosearch_x_marital_status"
        <?php } ?>
        data-table="personal_info"
        data-field="x_marital_status"
        data-value-separator="<?= $Page->marital_status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->marital_status->getPlaceHolder()) ?>"
        <?= $Page->marital_status->editAttributes() ?>>
        <?= $Page->marital_status->selectOptionListHtml("x_marital_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->marital_status->getErrorMessage(false) ?></div>
<?php if (!$Page->marital_status->IsNativeSelect) { ?>
<script>
loadjs.ready("fpersonal_infosearch", function() {
    var options = { name: "x_marital_status", selectId: "fpersonal_infosearch_x_marital_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpersonal_infosearch.lists.marital_status?.lookupOptions.length) {
        options.data = { id: "x_marital_status", form: "fpersonal_infosearch" };
    } else {
        options.ajax = { id: "x_marital_status", form: "fpersonal_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.personal_info.fields.marital_status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->spouse_details->Visible) { // spouse_details ?>
    <div id="r_spouse_details" class="row"<?= $Page->spouse_details->rowAttributes() ?>>
        <label for="x_spouse_details" class="<?= $Page->LeftColumnClass ?>"><span id="elh_personal_info_spouse_details"><?= $Page->spouse_details->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_spouse_details" id="z_spouse_details" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->spouse_details->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_personal_info_spouse_details" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->spouse_details->getInputTextType() ?>" name="x_spouse_details" id="x_spouse_details" data-table="personal_info" data-field="x_spouse_details" value="<?= $Page->spouse_details->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->spouse_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->spouse_details->formatPattern()) ?>"<?= $Page->spouse_details->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->spouse_details->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->image->Visible) { // image ?>
    <div id="r_image" class="row"<?= $Page->image->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_personal_info_image"><?= $Page->image->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_image" id="z_image" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->image->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_personal_info_image" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->image->getInputTextType() ?>" name="x_image" id="x_image" data-table="personal_info" data-field="x_image" value="<?= $Page->image->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->image->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->image->formatPattern()) ?>"<?= $Page->image->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->image->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->father_name->Visible) { // father_name ?>
    <div id="r_father_name" class="row"<?= $Page->father_name->rowAttributes() ?>>
        <label for="x_father_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_personal_info_father_name"><?= $Page->father_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_father_name" id="z_father_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->father_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_personal_info_father_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->father_name->getInputTextType() ?>" name="x_father_name" id="x_father_name" data-table="personal_info" data-field="x_father_name" value="<?= $Page->father_name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->father_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->father_name->formatPattern()) ?>"<?= $Page->father_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->father_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->mother_name->Visible) { // mother_name ?>
    <div id="r_mother_name" class="row"<?= $Page->mother_name->rowAttributes() ?>>
        <label for="x_mother_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_personal_info_mother_name"><?= $Page->mother_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_mother_name" id="z_mother_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->mother_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_personal_info_mother_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->mother_name->getInputTextType() ?>" name="x_mother_name" id="x_mother_name" data-table="personal_info" data-field="x_mother_name" value="<?= $Page->mother_name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->mother_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mother_name->formatPattern()) ?>"<?= $Page->mother_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->mother_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->permanent_address->Visible) { // permanent_address ?>
    <div id="r_permanent_address" class="row"<?= $Page->permanent_address->rowAttributes() ?>>
        <label for="x_permanent_address" class="<?= $Page->LeftColumnClass ?>"><span id="elh_personal_info_permanent_address"><?= $Page->permanent_address->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_permanent_address" id="z_permanent_address" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->permanent_address->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_personal_info_permanent_address" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->permanent_address->getInputTextType() ?>" name="x_permanent_address" id="x_permanent_address" data-table="personal_info" data-field="x_permanent_address" value="<?= $Page->permanent_address->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->permanent_address->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->permanent_address->formatPattern()) ?>"<?= $Page->permanent_address->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->permanent_address->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->mobile_other->Visible) { // mobile_other ?>
    <div id="r_mobile_other" class="row"<?= $Page->mobile_other->rowAttributes() ?>>
        <label for="x_mobile_other" class="<?= $Page->LeftColumnClass ?>"><span id="elh_personal_info_mobile_other"><?= $Page->mobile_other->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_mobile_other" id="z_mobile_other" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->mobile_other->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_personal_info_mobile_other" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->mobile_other->getInputTextType() ?>" name="x_mobile_other" id="x_mobile_other" data-table="personal_info" data-field="x_mobile_other" value="<?= $Page->mobile_other->EditValue ?>" size="30" maxlength="60" placeholder="<?= HtmlEncode($Page->mobile_other->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile_other->formatPattern()) ?>"<?= $Page->mobile_other->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->mobile_other->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->mobile_family->Visible) { // mobile_family ?>
    <div id="r_mobile_family" class="row"<?= $Page->mobile_family->rowAttributes() ?>>
        <label for="x_mobile_family" class="<?= $Page->LeftColumnClass ?>"><span id="elh_personal_info_mobile_family"><?= $Page->mobile_family->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_mobile_family" id="z_mobile_family" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->mobile_family->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_personal_info_mobile_family" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->mobile_family->getInputTextType() ?>" name="x_mobile_family" id="x_mobile_family" data-table="personal_info" data-field="x_mobile_family" value="<?= $Page->mobile_family->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->mobile_family->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile_family->formatPattern()) ?>"<?= $Page->mobile_family->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->mobile_family->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->emergency_details->Visible) { // emergency_details ?>
    <div id="r_emergency_details" class="row"<?= $Page->emergency_details->rowAttributes() ?>>
        <label for="x_emergency_details" class="<?= $Page->LeftColumnClass ?>"><span id="elh_personal_info_emergency_details"><?= $Page->emergency_details->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_emergency_details" id="z_emergency_details" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->emergency_details->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_personal_info_emergency_details" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->emergency_details->getInputTextType() ?>" name="x_emergency_details" id="x_emergency_details" data-table="personal_info" data-field="x_emergency_details" value="<?= $Page->emergency_details->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->emergency_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->emergency_details->formatPattern()) ?>"<?= $Page->emergency_details->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->emergency_details->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->annual_income->Visible) { // annual_income ?>
    <div id="r_annual_income" class="row"<?= $Page->annual_income->rowAttributes() ?>>
        <label for="x_annual_income" class="<?= $Page->LeftColumnClass ?>"><span id="elh_personal_info_annual_income"><?= $Page->annual_income->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_annual_income" id="z_annual_income" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->annual_income->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_personal_info_annual_income" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->annual_income->getInputTextType() ?>" name="x_annual_income" id="x_annual_income" data-table="personal_info" data-field="x_annual_income" value="<?= $Page->annual_income->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->annual_income->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->annual_income->formatPattern()) ?>"<?= $Page->annual_income->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->annual_income->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->work_details->Visible) { // work_details ?>
    <div id="r_work_details" class="row"<?= $Page->work_details->rowAttributes() ?>>
        <label for="x_work_details" class="<?= $Page->LeftColumnClass ?>"><span id="elh_personal_info_work_details"><?= $Page->work_details->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_work_details" id="z_work_details" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->work_details->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_personal_info_work_details" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->work_details->getInputTextType() ?>" name="x_work_details" id="x_work_details" data-table="personal_info" data-field="x_work_details" value="<?= $Page->work_details->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->work_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->work_details->formatPattern()) ?>"<?= $Page->work_details->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->work_details->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_personal_info_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_personal_info_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fpersonal_infosearch_x_status"
        <?php } ?>
        data-table="personal_info"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fpersonal_infosearch", function() {
    var options = { name: "x_status", selectId: "fpersonal_infosearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpersonal_infosearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fpersonal_infosearch" };
    } else {
        options.ajax = { id: "x_status", form: "fpersonal_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.personal_info.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->gst->Visible) { // gst ?>
    <div id="r_gst" class="row"<?= $Page->gst->rowAttributes() ?>>
        <label for="x_gst" class="<?= $Page->LeftColumnClass ?>"><span id="elh_personal_info_gst"><?= $Page->gst->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_gst" id="z_gst" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->gst->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_personal_info_gst" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->gst->getInputTextType() ?>" name="x_gst" id="x_gst" data-table="personal_info" data-field="x_gst" value="<?= $Page->gst->EditValue ?>" size="30" maxlength="15" placeholder="<?= HtmlEncode($Page->gst->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->gst->formatPattern()) ?>"<?= $Page->gst->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->gst->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->aadhaar_no->Visible) { // aadhaar_no ?>
    <div id="r_aadhaar_no" class="row"<?= $Page->aadhaar_no->rowAttributes() ?>>
        <label for="x_aadhaar_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_personal_info_aadhaar_no"><?= $Page->aadhaar_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_aadhaar_no" id="z_aadhaar_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->aadhaar_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_personal_info_aadhaar_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->aadhaar_no->getInputTextType() ?>" name="x_aadhaar_no" id="x_aadhaar_no" data-table="personal_info" data-field="x_aadhaar_no" value="<?= $Page->aadhaar_no->EditValue ?>" size="30" maxlength="14" placeholder="<?= HtmlEncode($Page->aadhaar_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->aadhaar_no->formatPattern()) ?>"<?= $Page->aadhaar_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->aadhaar_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pan_no->Visible) { // pan_no ?>
    <div id="r_pan_no" class="row"<?= $Page->pan_no->rowAttributes() ?>>
        <label for="x_pan_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_personal_info_pan_no"><?= $Page->pan_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_pan_no" id="z_pan_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pan_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_personal_info_pan_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pan_no->getInputTextType() ?>" name="x_pan_no" id="x_pan_no" data-table="personal_info" data-field="x_pan_no" value="<?= $Page->pan_no->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Page->pan_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pan_no->formatPattern()) ?>"<?= $Page->pan_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pan_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->id_proof->Visible) { // id_proof ?>
    <div id="r_id_proof" class="row"<?= $Page->id_proof->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_personal_info_id_proof"><?= $Page->id_proof->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_id_proof" id="z_id_proof" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id_proof->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_personal_info_id_proof" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id_proof->getInputTextType() ?>" name="x_id_proof" id="x_id_proof" data-table="personal_info" data-field="x_id_proof" value="<?= $Page->id_proof->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->id_proof->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id_proof->formatPattern()) ?>"<?= $Page->id_proof->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id_proof->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->reference_details->Visible) { // reference_details ?>
    <div id="r_reference_details" class="row"<?= $Page->reference_details->rowAttributes() ?>>
        <label for="x_reference_details" class="<?= $Page->LeftColumnClass ?>"><span id="elh_personal_info_reference_details"><?= $Page->reference_details->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_reference_details" id="z_reference_details" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->reference_details->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_personal_info_reference_details" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->reference_details->getInputTextType() ?>" name="x_reference_details" id="x_reference_details" data-table="personal_info" data-field="x_reference_details" value="<?= $Page->reference_details->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->reference_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->reference_details->formatPattern()) ?>"<?= $Page->reference_details->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->reference_details->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->other_details->Visible) { // other_details ?>
    <div id="r_other_details" class="row"<?= $Page->other_details->rowAttributes() ?>>
        <label for="x_other_details" class="<?= $Page->LeftColumnClass ?>"><span id="elh_personal_info_other_details"><?= $Page->other_details->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_other_details" id="z_other_details" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->other_details->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_personal_info_other_details" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->other_details->getInputTextType() ?>" name="x_other_details" id="x_other_details" data-table="personal_info" data-field="x_other_details" value="<?= $Page->other_details->EditValue ?>" size="35" maxlength="65535" placeholder="<?= HtmlEncode($Page->other_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->other_details->formatPattern()) ?>"<?= $Page->other_details->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->other_details->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->bank_name->Visible) { // bank_name ?>
    <div id="r_bank_name" class="row"<?= $Page->bank_name->rowAttributes() ?>>
        <label for="x_bank_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_personal_info_bank_name"><?= $Page->bank_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_bank_name" id="z_bank_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->bank_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_personal_info_bank_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->bank_name->getInputTextType() ?>" name="x_bank_name" id="x_bank_name" data-table="personal_info" data-field="x_bank_name" value="<?= $Page->bank_name->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->bank_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bank_name->formatPattern()) ?>"<?= $Page->bank_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->bank_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->bank_ifsc_code->Visible) { // bank_ifsc_code ?>
    <div id="r_bank_ifsc_code" class="row"<?= $Page->bank_ifsc_code->rowAttributes() ?>>
        <label for="x_bank_ifsc_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_personal_info_bank_ifsc_code"><?= $Page->bank_ifsc_code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_bank_ifsc_code" id="z_bank_ifsc_code" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->bank_ifsc_code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_personal_info_bank_ifsc_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->bank_ifsc_code->getInputTextType() ?>" name="x_bank_ifsc_code" id="x_bank_ifsc_code" data-table="personal_info" data-field="x_bank_ifsc_code" value="<?= $Page->bank_ifsc_code->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->bank_ifsc_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bank_ifsc_code->formatPattern()) ?>"<?= $Page->bank_ifsc_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->bank_ifsc_code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->bank_account_no->Visible) { // bank_account_no ?>
    <div id="r_bank_account_no" class="row"<?= $Page->bank_account_no->rowAttributes() ?>>
        <label for="x_bank_account_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_personal_info_bank_account_no"><?= $Page->bank_account_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_bank_account_no" id="z_bank_account_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->bank_account_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_personal_info_bank_account_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->bank_account_no->getInputTextType() ?>" name="x_bank_account_no" id="x_bank_account_no" data-table="personal_info" data-field="x_bank_account_no" value="<?= $Page->bank_account_no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->bank_account_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bank_account_no->formatPattern()) ?>"<?= $Page->bank_account_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->bank_account_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_personal_info_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_personal_info_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="personal_info" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_personal_info_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_personal_info_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="personal_info" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpersonal_infosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpersonal_infosearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fpersonal_infosearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpersonal_infosearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fpersonal_infosearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("personal_info");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
