<?php

namespace PHPMaker2024\fibre;

// Page object
$PersonalInfoList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { personal_info: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fpersonal_infosrch" id="fpersonal_infosrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fpersonal_infosrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { personal_info: currentTable } });
var currentForm;
var fpersonal_infosrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpersonal_infosrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Dynamic selection lists
        .setLists({
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fpersonal_infosrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fpersonal_infosrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fpersonal_infosrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fpersonal_infosrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fpersonal_infosrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fpersonal_infosrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fpersonal_infosrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="personal_info">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_personal_info" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_personal_infolist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_personal_info_id" class="personal_info_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->formal_name->Visible) { // formal_name ?>
        <th data-name="formal_name" class="<?= $Page->formal_name->headerCellClass() ?>"><div id="elh_personal_info_formal_name" class="personal_info_formal_name"><?= $Page->renderFieldHeader($Page->formal_name) ?></div></th>
<?php } ?>
<?php if ($Page->gender->Visible) { // gender ?>
        <th data-name="gender" class="<?= $Page->gender->headerCellClass() ?>"><div id="elh_personal_info_gender" class="personal_info_gender"><?= $Page->renderFieldHeader($Page->gender) ?></div></th>
<?php } ?>
<?php if ($Page->address->Visible) { // address ?>
        <th data-name="address" class="<?= $Page->address->headerCellClass() ?>"><div id="elh_personal_info_address" class="personal_info_address"><?= $Page->renderFieldHeader($Page->address) ?></div></th>
<?php } ?>
<?php if ($Page->country->Visible) { // country ?>
        <th data-name="country" class="<?= $Page->country->headerCellClass() ?>"><div id="elh_personal_info_country" class="personal_info_country"><?= $Page->renderFieldHeader($Page->country) ?></div></th>
<?php } ?>
<?php if ($Page->state->Visible) { // state ?>
        <th data-name="state" class="<?= $Page->state->headerCellClass() ?>"><div id="elh_personal_info_state" class="personal_info_state"><?= $Page->renderFieldHeader($Page->state) ?></div></th>
<?php } ?>
<?php if ($Page->city->Visible) { // city ?>
        <th data-name="city" class="<?= $Page->city->headerCellClass() ?>"><div id="elh_personal_info_city" class="personal_info_city"><?= $Page->renderFieldHeader($Page->city) ?></div></th>
<?php } ?>
<?php if ($Page->city_name->Visible) { // city_name ?>
        <th data-name="city_name" class="<?= $Page->city_name->headerCellClass() ?>"><div id="elh_personal_info_city_name" class="personal_info_city_name"><?= $Page->renderFieldHeader($Page->city_name) ?></div></th>
<?php } ?>
<?php if ($Page->dob->Visible) { // dob ?>
        <th data-name="dob" class="<?= $Page->dob->headerCellClass() ?>"><div id="elh_personal_info_dob" class="personal_info_dob"><?= $Page->renderFieldHeader($Page->dob) ?></div></th>
<?php } ?>
<?php if ($Page->dom->Visible) { // dom ?>
        <th data-name="dom" class="<?= $Page->dom->headerCellClass() ?>"><div id="elh_personal_info_dom" class="personal_info_dom"><?= $Page->renderFieldHeader($Page->dom) ?></div></th>
<?php } ?>
<?php if ($Page->marital_status->Visible) { // marital_status ?>
        <th data-name="marital_status" class="<?= $Page->marital_status->headerCellClass() ?>"><div id="elh_personal_info_marital_status" class="personal_info_marital_status"><?= $Page->renderFieldHeader($Page->marital_status) ?></div></th>
<?php } ?>
<?php if ($Page->spouse_details->Visible) { // spouse_details ?>
        <th data-name="spouse_details" class="<?= $Page->spouse_details->headerCellClass() ?>"><div id="elh_personal_info_spouse_details" class="personal_info_spouse_details"><?= $Page->renderFieldHeader($Page->spouse_details) ?></div></th>
<?php } ?>
<?php if ($Page->father_name->Visible) { // father_name ?>
        <th data-name="father_name" class="<?= $Page->father_name->headerCellClass() ?>"><div id="elh_personal_info_father_name" class="personal_info_father_name"><?= $Page->renderFieldHeader($Page->father_name) ?></div></th>
<?php } ?>
<?php if ($Page->mother_name->Visible) { // mother_name ?>
        <th data-name="mother_name" class="<?= $Page->mother_name->headerCellClass() ?>"><div id="elh_personal_info_mother_name" class="personal_info_mother_name"><?= $Page->renderFieldHeader($Page->mother_name) ?></div></th>
<?php } ?>
<?php if ($Page->permanent_address->Visible) { // permanent_address ?>
        <th data-name="permanent_address" class="<?= $Page->permanent_address->headerCellClass() ?>"><div id="elh_personal_info_permanent_address" class="personal_info_permanent_address"><?= $Page->renderFieldHeader($Page->permanent_address) ?></div></th>
<?php } ?>
<?php if ($Page->mobile_other->Visible) { // mobile_other ?>
        <th data-name="mobile_other" class="<?= $Page->mobile_other->headerCellClass() ?>"><div id="elh_personal_info_mobile_other" class="personal_info_mobile_other"><?= $Page->renderFieldHeader($Page->mobile_other) ?></div></th>
<?php } ?>
<?php if ($Page->mobile_family->Visible) { // mobile_family ?>
        <th data-name="mobile_family" class="<?= $Page->mobile_family->headerCellClass() ?>"><div id="elh_personal_info_mobile_family" class="personal_info_mobile_family"><?= $Page->renderFieldHeader($Page->mobile_family) ?></div></th>
<?php } ?>
<?php if ($Page->emergency_details->Visible) { // emergency_details ?>
        <th data-name="emergency_details" class="<?= $Page->emergency_details->headerCellClass() ?>"><div id="elh_personal_info_emergency_details" class="personal_info_emergency_details"><?= $Page->renderFieldHeader($Page->emergency_details) ?></div></th>
<?php } ?>
<?php if ($Page->annual_income->Visible) { // annual_income ?>
        <th data-name="annual_income" class="<?= $Page->annual_income->headerCellClass() ?>"><div id="elh_personal_info_annual_income" class="personal_info_annual_income"><?= $Page->renderFieldHeader($Page->annual_income) ?></div></th>
<?php } ?>
<?php if ($Page->work_details->Visible) { // work_details ?>
        <th data-name="work_details" class="<?= $Page->work_details->headerCellClass() ?>"><div id="elh_personal_info_work_details" class="personal_info_work_details"><?= $Page->renderFieldHeader($Page->work_details) ?></div></th>
<?php } ?>
<?php if ($Page->gst->Visible) { // gst ?>
        <th data-name="gst" class="<?= $Page->gst->headerCellClass() ?>"><div id="elh_personal_info_gst" class="personal_info_gst"><?= $Page->renderFieldHeader($Page->gst) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_personal_info_id" class="el_personal_info_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->formal_name->Visible) { // formal_name ?>
        <td data-name="formal_name"<?= $Page->formal_name->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_personal_info_formal_name" class="el_personal_info_formal_name">
<span<?= $Page->formal_name->viewAttributes() ?>>
<?= $Page->formal_name->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->gender->Visible) { // gender ?>
        <td data-name="gender"<?= $Page->gender->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_personal_info_gender" class="el_personal_info_gender">
<span<?= $Page->gender->viewAttributes() ?>>
<?= $Page->gender->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->address->Visible) { // address ?>
        <td data-name="address"<?= $Page->address->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_personal_info_address" class="el_personal_info_address">
<span<?= $Page->address->viewAttributes() ?>>
<?= $Page->address->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->country->Visible) { // country ?>
        <td data-name="country"<?= $Page->country->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_personal_info_country" class="el_personal_info_country">
<span<?= $Page->country->viewAttributes() ?>>
<?= $Page->country->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->state->Visible) { // state ?>
        <td data-name="state"<?= $Page->state->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_personal_info_state" class="el_personal_info_state">
<span<?= $Page->state->viewAttributes() ?>>
<?= $Page->state->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->city->Visible) { // city ?>
        <td data-name="city"<?= $Page->city->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_personal_info_city" class="el_personal_info_city">
<span<?= $Page->city->viewAttributes() ?>>
<?= $Page->city->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->city_name->Visible) { // city_name ?>
        <td data-name="city_name"<?= $Page->city_name->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_personal_info_city_name" class="el_personal_info_city_name">
<span<?= $Page->city_name->viewAttributes() ?>>
<?= $Page->city_name->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->dob->Visible) { // dob ?>
        <td data-name="dob"<?= $Page->dob->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_personal_info_dob" class="el_personal_info_dob">
<span<?= $Page->dob->viewAttributes() ?>>
<?= $Page->dob->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->dom->Visible) { // dom ?>
        <td data-name="dom"<?= $Page->dom->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_personal_info_dom" class="el_personal_info_dom">
<span<?= $Page->dom->viewAttributes() ?>>
<?= $Page->dom->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->marital_status->Visible) { // marital_status ?>
        <td data-name="marital_status"<?= $Page->marital_status->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_personal_info_marital_status" class="el_personal_info_marital_status">
<span<?= $Page->marital_status->viewAttributes() ?>>
<?= $Page->marital_status->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->spouse_details->Visible) { // spouse_details ?>
        <td data-name="spouse_details"<?= $Page->spouse_details->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_personal_info_spouse_details" class="el_personal_info_spouse_details">
<span<?= $Page->spouse_details->viewAttributes() ?>>
<?= $Page->spouse_details->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->father_name->Visible) { // father_name ?>
        <td data-name="father_name"<?= $Page->father_name->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_personal_info_father_name" class="el_personal_info_father_name">
<span<?= $Page->father_name->viewAttributes() ?>>
<?= $Page->father_name->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->mother_name->Visible) { // mother_name ?>
        <td data-name="mother_name"<?= $Page->mother_name->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_personal_info_mother_name" class="el_personal_info_mother_name">
<span<?= $Page->mother_name->viewAttributes() ?>>
<?= $Page->mother_name->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->permanent_address->Visible) { // permanent_address ?>
        <td data-name="permanent_address"<?= $Page->permanent_address->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_personal_info_permanent_address" class="el_personal_info_permanent_address">
<span<?= $Page->permanent_address->viewAttributes() ?>>
<?= $Page->permanent_address->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->mobile_other->Visible) { // mobile_other ?>
        <td data-name="mobile_other"<?= $Page->mobile_other->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_personal_info_mobile_other" class="el_personal_info_mobile_other">
<span<?= $Page->mobile_other->viewAttributes() ?>>
<?= $Page->mobile_other->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->mobile_family->Visible) { // mobile_family ?>
        <td data-name="mobile_family"<?= $Page->mobile_family->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_personal_info_mobile_family" class="el_personal_info_mobile_family">
<span<?= $Page->mobile_family->viewAttributes() ?>>
<?= $Page->mobile_family->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->emergency_details->Visible) { // emergency_details ?>
        <td data-name="emergency_details"<?= $Page->emergency_details->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_personal_info_emergency_details" class="el_personal_info_emergency_details">
<span<?= $Page->emergency_details->viewAttributes() ?>>
<?= $Page->emergency_details->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->annual_income->Visible) { // annual_income ?>
        <td data-name="annual_income"<?= $Page->annual_income->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_personal_info_annual_income" class="el_personal_info_annual_income">
<span<?= $Page->annual_income->viewAttributes() ?>>
<?= $Page->annual_income->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->work_details->Visible) { // work_details ?>
        <td data-name="work_details"<?= $Page->work_details->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_personal_info_work_details" class="el_personal_info_work_details">
<span<?= $Page->work_details->viewAttributes() ?>>
<?= $Page->work_details->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->gst->Visible) { // gst ?>
        <td data-name="gst"<?= $Page->gst->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_personal_info_gst" class="el_personal_info_gst">
<span<?= $Page->gst->viewAttributes() ?>>
<?= $Page->gst->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("personal_info");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
