<?php

namespace PHPMaker2024\fibre;

// Page object
$PersonalInfoAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { personal_info: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fpersonal_infoadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fpersonal_infoadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["formal_name", [fields.formal_name.visible && fields.formal_name.required ? ew.Validators.required(fields.formal_name.caption) : null], fields.formal_name.isInvalid],
            ["gender", [fields.gender.visible && fields.gender.required ? ew.Validators.required(fields.gender.caption) : null], fields.gender.isInvalid],
            ["mobile", [fields.mobile.visible && fields.mobile.required ? ew.Validators.required(fields.mobile.caption) : null, ew.Validators.integer], fields.mobile.isInvalid],
            ["_email", [fields._email.visible && fields._email.required ? ew.Validators.required(fields._email.caption) : null, ew.Validators.email], fields._email.isInvalid],
            ["address", [fields.address.visible && fields.address.required ? ew.Validators.required(fields.address.caption) : null], fields.address.isInvalid],
            ["country", [fields.country.visible && fields.country.required ? ew.Validators.required(fields.country.caption) : null], fields.country.isInvalid],
            ["state", [fields.state.visible && fields.state.required ? ew.Validators.required(fields.state.caption) : null], fields.state.isInvalid],
            ["city", [fields.city.visible && fields.city.required ? ew.Validators.required(fields.city.caption) : null], fields.city.isInvalid],
            ["city_name", [fields.city_name.visible && fields.city_name.required ? ew.Validators.required(fields.city_name.caption) : null], fields.city_name.isInvalid],
            ["dob", [fields.dob.visible && fields.dob.required ? ew.Validators.required(fields.dob.caption) : null, ew.Validators.datetime(fields.dob.clientFormatPattern)], fields.dob.isInvalid],
            ["dom", [fields.dom.visible && fields.dom.required ? ew.Validators.required(fields.dom.caption) : null, ew.Validators.datetime(fields.dom.clientFormatPattern)], fields.dom.isInvalid],
            ["marital_status", [fields.marital_status.visible && fields.marital_status.required ? ew.Validators.required(fields.marital_status.caption) : null], fields.marital_status.isInvalid],
            ["spouse_details", [fields.spouse_details.visible && fields.spouse_details.required ? ew.Validators.required(fields.spouse_details.caption) : null], fields.spouse_details.isInvalid],
            ["father_name", [fields.father_name.visible && fields.father_name.required ? ew.Validators.required(fields.father_name.caption) : null], fields.father_name.isInvalid],
            ["mother_name", [fields.mother_name.visible && fields.mother_name.required ? ew.Validators.required(fields.mother_name.caption) : null], fields.mother_name.isInvalid],
            ["permanent_address", [fields.permanent_address.visible && fields.permanent_address.required ? ew.Validators.required(fields.permanent_address.caption) : null], fields.permanent_address.isInvalid],
            ["mobile_other", [fields.mobile_other.visible && fields.mobile_other.required ? ew.Validators.required(fields.mobile_other.caption) : null], fields.mobile_other.isInvalid],
            ["mobile_family", [fields.mobile_family.visible && fields.mobile_family.required ? ew.Validators.required(fields.mobile_family.caption) : null], fields.mobile_family.isInvalid],
            ["emergency_details", [fields.emergency_details.visible && fields.emergency_details.required ? ew.Validators.required(fields.emergency_details.caption) : null], fields.emergency_details.isInvalid],
            ["annual_income", [fields.annual_income.visible && fields.annual_income.required ? ew.Validators.required(fields.annual_income.caption) : null, ew.Validators.integer], fields.annual_income.isInvalid],
            ["work_details", [fields.work_details.visible && fields.work_details.required ? ew.Validators.required(fields.work_details.caption) : null], fields.work_details.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["gst", [fields.gst.visible && fields.gst.required ? ew.Validators.required(fields.gst.caption) : null], fields.gst.isInvalid],
            ["aadhaar_no", [fields.aadhaar_no.visible && fields.aadhaar_no.required ? ew.Validators.required(fields.aadhaar_no.caption) : null, ew.Validators.regex(/^[2-9]{1}[0-9]{3}\s[0-9]{4}\s[0-9]{4}$/)], fields.aadhaar_no.isInvalid],
            ["pan_no", [fields.pan_no.visible && fields.pan_no.required ? ew.Validators.required(fields.pan_no.caption) : null, ew.Validators.regex(/([A-Z]){5}([0-9]){4}([A-Z]){1}$/)], fields.pan_no.isInvalid],
            ["reference_details", [fields.reference_details.visible && fields.reference_details.required ? ew.Validators.required(fields.reference_details.caption) : null], fields.reference_details.isInvalid],
            ["other_details", [fields.other_details.visible && fields.other_details.required ? ew.Validators.required(fields.other_details.caption) : null], fields.other_details.isInvalid],
            ["bank_name", [fields.bank_name.visible && fields.bank_name.required ? ew.Validators.required(fields.bank_name.caption) : null], fields.bank_name.isInvalid],
            ["bank_ifsc_code", [fields.bank_ifsc_code.visible && fields.bank_ifsc_code.required ? ew.Validators.required(fields.bank_ifsc_code.caption) : null], fields.bank_ifsc_code.isInvalid],
            ["bank_account_no", [fields.bank_account_no.visible && fields.bank_account_no.required ? ew.Validators.required(fields.bank_account_no.caption) : null], fields.bank_account_no.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "gender": <?= $Page->gender->toClientList($Page) ?>,
            "country": <?= $Page->country->toClientList($Page) ?>,
            "state": <?= $Page->state->toClientList($Page) ?>,
            "city": <?= $Page->city->toClientList($Page) ?>,
            "marital_status": <?= $Page->marital_status->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fpersonal_infoadd" id="fpersonal_infoadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="personal_info">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_personal_info_id" for="x_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>></div></div>
    </div>
<?php } ?>
<?php if ($Page->formal_name->Visible) { // formal_name ?>
    <div id="r_formal_name"<?= $Page->formal_name->rowAttributes() ?>>
        <label id="elh_personal_info_formal_name" for="x_formal_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->formal_name->caption() ?><?= $Page->formal_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->formal_name->cellAttributes() ?>>
<span id="el_personal_info_formal_name">
<input type="<?= $Page->formal_name->getInputTextType() ?>" name="x_formal_name" id="x_formal_name" data-table="personal_info" data-field="x_formal_name" value="<?= $Page->formal_name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->formal_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->formal_name->formatPattern()) ?>"<?= $Page->formal_name->editAttributes() ?> aria-describedby="x_formal_name_help">
<?= $Page->formal_name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->formal_name->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->gender->Visible) { // gender ?>
    <div id="r_gender"<?= $Page->gender->rowAttributes() ?>>
        <label id="elh_personal_info_gender" for="x_gender" class="<?= $Page->LeftColumnClass ?>"><?= $Page->gender->caption() ?><?= $Page->gender->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->gender->cellAttributes() ?>>
<span id="el_personal_info_gender">
    <select
        id="x_gender"
        name="x_gender"
        class="form-select ew-select<?= $Page->gender->isInvalidClass() ?>"
        <?php if (!$Page->gender->IsNativeSelect) { ?>
        data-select2-id="fpersonal_infoadd_x_gender"
        <?php } ?>
        data-table="personal_info"
        data-field="x_gender"
        data-value-separator="<?= $Page->gender->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->gender->getPlaceHolder()) ?>"
        <?= $Page->gender->editAttributes() ?>>
        <?= $Page->gender->selectOptionListHtml("x_gender") ?>
    </select>
    <?= $Page->gender->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->gender->getErrorMessage() ?></div>
<?php if (!$Page->gender->IsNativeSelect) { ?>
<script>
loadjs.ready("fpersonal_infoadd", function() {
    var options = { name: "x_gender", selectId: "fpersonal_infoadd_x_gender" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpersonal_infoadd.lists.gender?.lookupOptions.length) {
        options.data = { id: "x_gender", form: "fpersonal_infoadd" };
    } else {
        options.ajax = { id: "x_gender", form: "fpersonal_infoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.personal_info.fields.gender.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->mobile->Visible) { // mobile ?>
    <div id="r_mobile"<?= $Page->mobile->rowAttributes() ?>>
        <label id="elh_personal_info_mobile" for="x_mobile" class="<?= $Page->LeftColumnClass ?>"><?= $Page->mobile->caption() ?><?= $Page->mobile->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->mobile->cellAttributes() ?>>
<span id="el_personal_info_mobile">
<input type="<?= $Page->mobile->getInputTextType() ?>" name="x_mobile" id="x_mobile" data-table="personal_info" data-field="x_mobile" value="<?= $Page->mobile->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile->formatPattern()) ?>"<?= $Page->mobile->editAttributes() ?> aria-describedby="x_mobile_help">
<?= $Page->mobile->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->mobile->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_email->Visible) { // email ?>
    <div id="r__email"<?= $Page->_email->rowAttributes() ?>>
        <label id="elh_personal_info__email" for="x__email" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_email->caption() ?><?= $Page->_email->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_email->cellAttributes() ?>>
<span id="el_personal_info__email">
<input type="<?= $Page->_email->getInputTextType() ?>" name="x__email" id="x__email" data-table="personal_info" data-field="x__email" value="<?= $Page->_email->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->_email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_email->formatPattern()) ?>"<?= $Page->_email->editAttributes() ?> aria-describedby="x__email_help">
<?= $Page->_email->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_email->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->address->Visible) { // address ?>
    <div id="r_address"<?= $Page->address->rowAttributes() ?>>
        <label id="elh_personal_info_address" for="x_address" class="<?= $Page->LeftColumnClass ?>"><?= $Page->address->caption() ?><?= $Page->address->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->address->cellAttributes() ?>>
<span id="el_personal_info_address">
<input type="<?= $Page->address->getInputTextType() ?>" name="x_address" id="x_address" data-table="personal_info" data-field="x_address" value="<?= $Page->address->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->address->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->address->formatPattern()) ?>"<?= $Page->address->editAttributes() ?> aria-describedby="x_address_help">
<?= $Page->address->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->address->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->country->Visible) { // country ?>
    <div id="r_country"<?= $Page->country->rowAttributes() ?>>
        <label id="elh_personal_info_country" for="x_country" class="<?= $Page->LeftColumnClass ?>"><?= $Page->country->caption() ?><?= $Page->country->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->country->cellAttributes() ?>>
<span id="el_personal_info_country">
    <select
        id="x_country"
        name="x_country"
        class="form-select ew-select<?= $Page->country->isInvalidClass() ?>"
        <?php if (!$Page->country->IsNativeSelect) { ?>
        data-select2-id="fpersonal_infoadd_x_country"
        <?php } ?>
        data-table="personal_info"
        data-field="x_country"
        data-value-separator="<?= $Page->country->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->country->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->country->editAttributes() ?>>
        <?= $Page->country->selectOptionListHtml("x_country") ?>
    </select>
    <?= $Page->country->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->country->getErrorMessage() ?></div>
<?= $Page->country->Lookup->getParamTag($Page, "p_x_country") ?>
<?php if (!$Page->country->IsNativeSelect) { ?>
<script>
loadjs.ready("fpersonal_infoadd", function() {
    var options = { name: "x_country", selectId: "fpersonal_infoadd_x_country" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpersonal_infoadd.lists.country?.lookupOptions.length) {
        options.data = { id: "x_country", form: "fpersonal_infoadd" };
    } else {
        options.ajax = { id: "x_country", form: "fpersonal_infoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.personal_info.fields.country.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->state->Visible) { // state ?>
    <div id="r_state"<?= $Page->state->rowAttributes() ?>>
        <label id="elh_personal_info_state" for="x_state" class="<?= $Page->LeftColumnClass ?>"><?= $Page->state->caption() ?><?= $Page->state->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->state->cellAttributes() ?>>
<span id="el_personal_info_state">
    <select
        id="x_state"
        name="x_state"
        class="form-select ew-select<?= $Page->state->isInvalidClass() ?>"
        <?php if (!$Page->state->IsNativeSelect) { ?>
        data-select2-id="fpersonal_infoadd_x_state"
        <?php } ?>
        data-table="personal_info"
        data-field="x_state"
        data-value-separator="<?= $Page->state->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->state->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->state->editAttributes() ?>>
        <?= $Page->state->selectOptionListHtml("x_state") ?>
    </select>
    <?= $Page->state->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->state->getErrorMessage() ?></div>
<?= $Page->state->Lookup->getParamTag($Page, "p_x_state") ?>
<?php if (!$Page->state->IsNativeSelect) { ?>
<script>
loadjs.ready("fpersonal_infoadd", function() {
    var options = { name: "x_state", selectId: "fpersonal_infoadd_x_state" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpersonal_infoadd.lists.state?.lookupOptions.length) {
        options.data = { id: "x_state", form: "fpersonal_infoadd" };
    } else {
        options.ajax = { id: "x_state", form: "fpersonal_infoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.personal_info.fields.state.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->city->Visible) { // city ?>
    <div id="r_city"<?= $Page->city->rowAttributes() ?>>
        <label id="elh_personal_info_city" for="x_city" class="<?= $Page->LeftColumnClass ?>"><?= $Page->city->caption() ?><?= $Page->city->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->city->cellAttributes() ?>>
<span id="el_personal_info_city">
    <select
        id="x_city"
        name="x_city"
        class="form-select ew-select<?= $Page->city->isInvalidClass() ?>"
        <?php if (!$Page->city->IsNativeSelect) { ?>
        data-select2-id="fpersonal_infoadd_x_city"
        <?php } ?>
        data-table="personal_info"
        data-field="x_city"
        data-value-separator="<?= $Page->city->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->city->getPlaceHolder()) ?>"
        <?= $Page->city->editAttributes() ?>>
        <?= $Page->city->selectOptionListHtml("x_city") ?>
    </select>
    <?= $Page->city->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->city->getErrorMessage() ?></div>
<?= $Page->city->Lookup->getParamTag($Page, "p_x_city") ?>
<?php if (!$Page->city->IsNativeSelect) { ?>
<script>
loadjs.ready("fpersonal_infoadd", function() {
    var options = { name: "x_city", selectId: "fpersonal_infoadd_x_city" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpersonal_infoadd.lists.city?.lookupOptions.length) {
        options.data = { id: "x_city", form: "fpersonal_infoadd" };
    } else {
        options.ajax = { id: "x_city", form: "fpersonal_infoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.personal_info.fields.city.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->city_name->Visible) { // city_name ?>
    <div id="r_city_name"<?= $Page->city_name->rowAttributes() ?>>
        <label id="elh_personal_info_city_name" for="x_city_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->city_name->caption() ?><?= $Page->city_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->city_name->cellAttributes() ?>>
<span id="el_personal_info_city_name">
<input type="<?= $Page->city_name->getInputTextType() ?>" name="x_city_name" id="x_city_name" data-table="personal_info" data-field="x_city_name" value="<?= $Page->city_name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->city_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->city_name->formatPattern()) ?>"<?= $Page->city_name->editAttributes() ?> aria-describedby="x_city_name_help">
<?= $Page->city_name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->city_name->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->dob->Visible) { // dob ?>
    <div id="r_dob"<?= $Page->dob->rowAttributes() ?>>
        <label id="elh_personal_info_dob" for="x_dob" class="<?= $Page->LeftColumnClass ?>"><?= $Page->dob->caption() ?><?= $Page->dob->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->dob->cellAttributes() ?>>
<span id="el_personal_info_dob">
<input type="<?= $Page->dob->getInputTextType() ?>" name="x_dob" id="x_dob" data-table="personal_info" data-field="x_dob" value="<?= $Page->dob->EditValue ?>" placeholder="<?= HtmlEncode($Page->dob->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dob->formatPattern()) ?>"<?= $Page->dob->editAttributes() ?> aria-describedby="x_dob_help">
<?= $Page->dob->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->dob->getErrorMessage() ?></div>
<?php if (!$Page->dob->ReadOnly && !$Page->dob->Disabled && !isset($Page->dob->EditAttrs["readonly"]) && !isset($Page->dob->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpersonal_infoadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpersonal_infoadd", "x_dob", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->dom->Visible) { // dom ?>
    <div id="r_dom"<?= $Page->dom->rowAttributes() ?>>
        <label id="elh_personal_info_dom" for="x_dom" class="<?= $Page->LeftColumnClass ?>"><?= $Page->dom->caption() ?><?= $Page->dom->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->dom->cellAttributes() ?>>
<span id="el_personal_info_dom">
<input type="<?= $Page->dom->getInputTextType() ?>" name="x_dom" id="x_dom" data-table="personal_info" data-field="x_dom" value="<?= $Page->dom->EditValue ?>" placeholder="<?= HtmlEncode($Page->dom->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dom->formatPattern()) ?>"<?= $Page->dom->editAttributes() ?> aria-describedby="x_dom_help">
<?= $Page->dom->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->dom->getErrorMessage() ?></div>
<?php if (!$Page->dom->ReadOnly && !$Page->dom->Disabled && !isset($Page->dom->EditAttrs["readonly"]) && !isset($Page->dom->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpersonal_infoadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpersonal_infoadd", "x_dom", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->marital_status->Visible) { // marital_status ?>
    <div id="r_marital_status"<?= $Page->marital_status->rowAttributes() ?>>
        <label id="elh_personal_info_marital_status" for="x_marital_status" class="<?= $Page->LeftColumnClass ?>"><?= $Page->marital_status->caption() ?><?= $Page->marital_status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->marital_status->cellAttributes() ?>>
<span id="el_personal_info_marital_status">
    <select
        id="x_marital_status"
        name="x_marital_status"
        class="form-select ew-select<?= $Page->marital_status->isInvalidClass() ?>"
        <?php if (!$Page->marital_status->IsNativeSelect) { ?>
        data-select2-id="fpersonal_infoadd_x_marital_status"
        <?php } ?>
        data-table="personal_info"
        data-field="x_marital_status"
        data-value-separator="<?= $Page->marital_status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->marital_status->getPlaceHolder()) ?>"
        <?= $Page->marital_status->editAttributes() ?>>
        <?= $Page->marital_status->selectOptionListHtml("x_marital_status") ?>
    </select>
    <?= $Page->marital_status->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->marital_status->getErrorMessage() ?></div>
<?php if (!$Page->marital_status->IsNativeSelect) { ?>
<script>
loadjs.ready("fpersonal_infoadd", function() {
    var options = { name: "x_marital_status", selectId: "fpersonal_infoadd_x_marital_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpersonal_infoadd.lists.marital_status?.lookupOptions.length) {
        options.data = { id: "x_marital_status", form: "fpersonal_infoadd" };
    } else {
        options.ajax = { id: "x_marital_status", form: "fpersonal_infoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.personal_info.fields.marital_status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->spouse_details->Visible) { // spouse_details ?>
    <div id="r_spouse_details"<?= $Page->spouse_details->rowAttributes() ?>>
        <label id="elh_personal_info_spouse_details" for="x_spouse_details" class="<?= $Page->LeftColumnClass ?>"><?= $Page->spouse_details->caption() ?><?= $Page->spouse_details->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->spouse_details->cellAttributes() ?>>
<span id="el_personal_info_spouse_details">
<input type="<?= $Page->spouse_details->getInputTextType() ?>" name="x_spouse_details" id="x_spouse_details" data-table="personal_info" data-field="x_spouse_details" value="<?= $Page->spouse_details->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->spouse_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->spouse_details->formatPattern()) ?>"<?= $Page->spouse_details->editAttributes() ?> aria-describedby="x_spouse_details_help">
<?= $Page->spouse_details->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->spouse_details->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->father_name->Visible) { // father_name ?>
    <div id="r_father_name"<?= $Page->father_name->rowAttributes() ?>>
        <label id="elh_personal_info_father_name" for="x_father_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->father_name->caption() ?><?= $Page->father_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->father_name->cellAttributes() ?>>
<span id="el_personal_info_father_name">
<input type="<?= $Page->father_name->getInputTextType() ?>" name="x_father_name" id="x_father_name" data-table="personal_info" data-field="x_father_name" value="<?= $Page->father_name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->father_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->father_name->formatPattern()) ?>"<?= $Page->father_name->editAttributes() ?> aria-describedby="x_father_name_help">
<?= $Page->father_name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->father_name->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->mother_name->Visible) { // mother_name ?>
    <div id="r_mother_name"<?= $Page->mother_name->rowAttributes() ?>>
        <label id="elh_personal_info_mother_name" for="x_mother_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->mother_name->caption() ?><?= $Page->mother_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->mother_name->cellAttributes() ?>>
<span id="el_personal_info_mother_name">
<input type="<?= $Page->mother_name->getInputTextType() ?>" name="x_mother_name" id="x_mother_name" data-table="personal_info" data-field="x_mother_name" value="<?= $Page->mother_name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->mother_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mother_name->formatPattern()) ?>"<?= $Page->mother_name->editAttributes() ?> aria-describedby="x_mother_name_help">
<?= $Page->mother_name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->mother_name->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->permanent_address->Visible) { // permanent_address ?>
    <div id="r_permanent_address"<?= $Page->permanent_address->rowAttributes() ?>>
        <label id="elh_personal_info_permanent_address" for="x_permanent_address" class="<?= $Page->LeftColumnClass ?>"><?= $Page->permanent_address->caption() ?><?= $Page->permanent_address->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->permanent_address->cellAttributes() ?>>
<span id="el_personal_info_permanent_address">
<input type="<?= $Page->permanent_address->getInputTextType() ?>" name="x_permanent_address" id="x_permanent_address" data-table="personal_info" data-field="x_permanent_address" value="<?= $Page->permanent_address->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->permanent_address->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->permanent_address->formatPattern()) ?>"<?= $Page->permanent_address->editAttributes() ?> aria-describedby="x_permanent_address_help">
<?= $Page->permanent_address->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->permanent_address->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->mobile_other->Visible) { // mobile_other ?>
    <div id="r_mobile_other"<?= $Page->mobile_other->rowAttributes() ?>>
        <label id="elh_personal_info_mobile_other" for="x_mobile_other" class="<?= $Page->LeftColumnClass ?>"><?= $Page->mobile_other->caption() ?><?= $Page->mobile_other->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->mobile_other->cellAttributes() ?>>
<span id="el_personal_info_mobile_other">
<input type="<?= $Page->mobile_other->getInputTextType() ?>" name="x_mobile_other" id="x_mobile_other" data-table="personal_info" data-field="x_mobile_other" value="<?= $Page->mobile_other->EditValue ?>" size="30" maxlength="60" placeholder="<?= HtmlEncode($Page->mobile_other->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile_other->formatPattern()) ?>"<?= $Page->mobile_other->editAttributes() ?> aria-describedby="x_mobile_other_help">
<?= $Page->mobile_other->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->mobile_other->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->mobile_family->Visible) { // mobile_family ?>
    <div id="r_mobile_family"<?= $Page->mobile_family->rowAttributes() ?>>
        <label id="elh_personal_info_mobile_family" for="x_mobile_family" class="<?= $Page->LeftColumnClass ?>"><?= $Page->mobile_family->caption() ?><?= $Page->mobile_family->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->mobile_family->cellAttributes() ?>>
<span id="el_personal_info_mobile_family">
<input type="<?= $Page->mobile_family->getInputTextType() ?>" name="x_mobile_family" id="x_mobile_family" data-table="personal_info" data-field="x_mobile_family" value="<?= $Page->mobile_family->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->mobile_family->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile_family->formatPattern()) ?>"<?= $Page->mobile_family->editAttributes() ?> aria-describedby="x_mobile_family_help">
<?= $Page->mobile_family->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->mobile_family->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->emergency_details->Visible) { // emergency_details ?>
    <div id="r_emergency_details"<?= $Page->emergency_details->rowAttributes() ?>>
        <label id="elh_personal_info_emergency_details" for="x_emergency_details" class="<?= $Page->LeftColumnClass ?>"><?= $Page->emergency_details->caption() ?><?= $Page->emergency_details->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->emergency_details->cellAttributes() ?>>
<span id="el_personal_info_emergency_details">
<input type="<?= $Page->emergency_details->getInputTextType() ?>" name="x_emergency_details" id="x_emergency_details" data-table="personal_info" data-field="x_emergency_details" value="<?= $Page->emergency_details->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->emergency_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->emergency_details->formatPattern()) ?>"<?= $Page->emergency_details->editAttributes() ?> aria-describedby="x_emergency_details_help">
<?= $Page->emergency_details->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->emergency_details->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->annual_income->Visible) { // annual_income ?>
    <div id="r_annual_income"<?= $Page->annual_income->rowAttributes() ?>>
        <label id="elh_personal_info_annual_income" for="x_annual_income" class="<?= $Page->LeftColumnClass ?>"><?= $Page->annual_income->caption() ?><?= $Page->annual_income->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->annual_income->cellAttributes() ?>>
<span id="el_personal_info_annual_income">
<input type="<?= $Page->annual_income->getInputTextType() ?>" name="x_annual_income" id="x_annual_income" data-table="personal_info" data-field="x_annual_income" value="<?= $Page->annual_income->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->annual_income->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->annual_income->formatPattern()) ?>"<?= $Page->annual_income->editAttributes() ?> aria-describedby="x_annual_income_help">
<?= $Page->annual_income->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->annual_income->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->work_details->Visible) { // work_details ?>
    <div id="r_work_details"<?= $Page->work_details->rowAttributes() ?>>
        <label id="elh_personal_info_work_details" for="x_work_details" class="<?= $Page->LeftColumnClass ?>"><?= $Page->work_details->caption() ?><?= $Page->work_details->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->work_details->cellAttributes() ?>>
<span id="el_personal_info_work_details">
<input type="<?= $Page->work_details->getInputTextType() ?>" name="x_work_details" id="x_work_details" data-table="personal_info" data-field="x_work_details" value="<?= $Page->work_details->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->work_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->work_details->formatPattern()) ?>"<?= $Page->work_details->editAttributes() ?> aria-describedby="x_work_details_help">
<?= $Page->work_details->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->work_details->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label id="elh_personal_info_status" for="x_status" class="<?= $Page->LeftColumnClass ?>"><?= $Page->status->caption() ?><?= $Page->status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->status->cellAttributes() ?>>
<span id="el_personal_info_status">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fpersonal_infoadd_x_status"
        <?php } ?>
        data-table="personal_info"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <?= $Page->status->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fpersonal_infoadd", function() {
    var options = { name: "x_status", selectId: "fpersonal_infoadd_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpersonal_infoadd.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fpersonal_infoadd" };
    } else {
        options.ajax = { id: "x_status", form: "fpersonal_infoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.personal_info.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->gst->Visible) { // gst ?>
    <div id="r_gst"<?= $Page->gst->rowAttributes() ?>>
        <label id="elh_personal_info_gst" for="x_gst" class="<?= $Page->LeftColumnClass ?>"><?= $Page->gst->caption() ?><?= $Page->gst->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->gst->cellAttributes() ?>>
<span id="el_personal_info_gst">
<input type="<?= $Page->gst->getInputTextType() ?>" name="x_gst" id="x_gst" data-table="personal_info" data-field="x_gst" value="<?= $Page->gst->EditValue ?>" size="30" maxlength="15" placeholder="<?= HtmlEncode($Page->gst->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->gst->formatPattern()) ?>"<?= $Page->gst->editAttributes() ?> aria-describedby="x_gst_help">
<?= $Page->gst->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->gst->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->aadhaar_no->Visible) { // aadhaar_no ?>
    <div id="r_aadhaar_no"<?= $Page->aadhaar_no->rowAttributes() ?>>
        <label id="elh_personal_info_aadhaar_no" for="x_aadhaar_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->aadhaar_no->caption() ?><?= $Page->aadhaar_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->aadhaar_no->cellAttributes() ?>>
<span id="el_personal_info_aadhaar_no">
<input type="<?= $Page->aadhaar_no->getInputTextType() ?>" name="x_aadhaar_no" id="x_aadhaar_no" data-table="personal_info" data-field="x_aadhaar_no" value="<?= $Page->aadhaar_no->EditValue ?>" size="30" maxlength="14" placeholder="<?= HtmlEncode($Page->aadhaar_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->aadhaar_no->formatPattern()) ?>"<?= $Page->aadhaar_no->editAttributes() ?> aria-describedby="x_aadhaar_no_help">
<?= $Page->aadhaar_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->aadhaar_no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->pan_no->Visible) { // pan_no ?>
    <div id="r_pan_no"<?= $Page->pan_no->rowAttributes() ?>>
        <label id="elh_personal_info_pan_no" for="x_pan_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->pan_no->caption() ?><?= $Page->pan_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->pan_no->cellAttributes() ?>>
<span id="el_personal_info_pan_no">
<input type="<?= $Page->pan_no->getInputTextType() ?>" name="x_pan_no" id="x_pan_no" data-table="personal_info" data-field="x_pan_no" value="<?= $Page->pan_no->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Page->pan_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pan_no->formatPattern()) ?>"<?= $Page->pan_no->editAttributes() ?> aria-describedby="x_pan_no_help">
<?= $Page->pan_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->pan_no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->reference_details->Visible) { // reference_details ?>
    <div id="r_reference_details"<?= $Page->reference_details->rowAttributes() ?>>
        <label id="elh_personal_info_reference_details" for="x_reference_details" class="<?= $Page->LeftColumnClass ?>"><?= $Page->reference_details->caption() ?><?= $Page->reference_details->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->reference_details->cellAttributes() ?>>
<span id="el_personal_info_reference_details">
<input type="<?= $Page->reference_details->getInputTextType() ?>" name="x_reference_details" id="x_reference_details" data-table="personal_info" data-field="x_reference_details" value="<?= $Page->reference_details->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->reference_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->reference_details->formatPattern()) ?>"<?= $Page->reference_details->editAttributes() ?> aria-describedby="x_reference_details_help">
<?= $Page->reference_details->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->reference_details->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->other_details->Visible) { // other_details ?>
    <div id="r_other_details"<?= $Page->other_details->rowAttributes() ?>>
        <label id="elh_personal_info_other_details" for="x_other_details" class="<?= $Page->LeftColumnClass ?>"><?= $Page->other_details->caption() ?><?= $Page->other_details->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->other_details->cellAttributes() ?>>
<span id="el_personal_info_other_details">
<textarea data-table="personal_info" data-field="x_other_details" name="x_other_details" id="x_other_details" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->other_details->getPlaceHolder()) ?>"<?= $Page->other_details->editAttributes() ?> aria-describedby="x_other_details_help"><?= $Page->other_details->EditValue ?></textarea>
<?= $Page->other_details->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->other_details->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->bank_name->Visible) { // bank_name ?>
    <div id="r_bank_name"<?= $Page->bank_name->rowAttributes() ?>>
        <label id="elh_personal_info_bank_name" for="x_bank_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->bank_name->caption() ?><?= $Page->bank_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->bank_name->cellAttributes() ?>>
<span id="el_personal_info_bank_name">
<input type="<?= $Page->bank_name->getInputTextType() ?>" name="x_bank_name" id="x_bank_name" data-table="personal_info" data-field="x_bank_name" value="<?= $Page->bank_name->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->bank_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bank_name->formatPattern()) ?>"<?= $Page->bank_name->editAttributes() ?> aria-describedby="x_bank_name_help">
<?= $Page->bank_name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->bank_name->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->bank_ifsc_code->Visible) { // bank_ifsc_code ?>
    <div id="r_bank_ifsc_code"<?= $Page->bank_ifsc_code->rowAttributes() ?>>
        <label id="elh_personal_info_bank_ifsc_code" for="x_bank_ifsc_code" class="<?= $Page->LeftColumnClass ?>"><?= $Page->bank_ifsc_code->caption() ?><?= $Page->bank_ifsc_code->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->bank_ifsc_code->cellAttributes() ?>>
<span id="el_personal_info_bank_ifsc_code">
<input type="<?= $Page->bank_ifsc_code->getInputTextType() ?>" name="x_bank_ifsc_code" id="x_bank_ifsc_code" data-table="personal_info" data-field="x_bank_ifsc_code" value="<?= $Page->bank_ifsc_code->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->bank_ifsc_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bank_ifsc_code->formatPattern()) ?>"<?= $Page->bank_ifsc_code->editAttributes() ?> aria-describedby="x_bank_ifsc_code_help">
<?= $Page->bank_ifsc_code->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->bank_ifsc_code->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->bank_account_no->Visible) { // bank_account_no ?>
    <div id="r_bank_account_no"<?= $Page->bank_account_no->rowAttributes() ?>>
        <label id="elh_personal_info_bank_account_no" for="x_bank_account_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->bank_account_no->caption() ?><?= $Page->bank_account_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->bank_account_no->cellAttributes() ?>>
<span id="el_personal_info_bank_account_no">
<input type="<?= $Page->bank_account_no->getInputTextType() ?>" name="x_bank_account_no" id="x_bank_account_no" data-table="personal_info" data-field="x_bank_account_no" value="<?= $Page->bank_account_no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->bank_account_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bank_account_no->formatPattern()) ?>"<?= $Page->bank_account_no->editAttributes() ?> aria-describedby="x_bank_account_no_help">
<?= $Page->bank_account_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->bank_account_no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fpersonal_infoadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpersonal_infoadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("personal_info");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
