<?php

namespace PHPMaker2024\fibre;

// Page object
$PayrollTimeLogSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { payroll_time_log: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fpayroll_time_logsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpayroll_time_logsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["employee_id", [ew.Validators.integer], fields.employee_id.isInvalid],
            ["dated", [ew.Validators.integer], fields.dated.isInvalid],
            ["y_dated", [ew.Validators.between], false],
            ["in_time", [ew.Validators.datetime(fields.in_time.clientFormatPattern)], fields.in_time.isInvalid],
            ["out_time", [ew.Validators.datetime(fields.out_time.clientFormatPattern)], fields.out_time.isInvalid],
            ["minutes", [ew.Validators.integer], fields.minutes.isInvalid],
            ["late_arrival", [ew.Validators.integer], fields.late_arrival.isInvalid],
            ["early_departure", [ew.Validators.integer], fields.early_departure.isInvalid],
            ["overtime", [ew.Validators.integer], fields.overtime.isInvalid],
            ["breakduration", [ew.Validators.integer], fields.breakduration.isInvalid],
            ["employee_am_id", [ew.Validators.integer], fields.employee_am_id.isInvalid],
            ["offset_consumed", [ew.Validators.integer], fields.offset_consumed.isInvalid],
            ["c_offset", [ew.Validators.integer], fields.c_offset.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "employee_id": <?= $Page->employee_id->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fpayroll_time_logsearch" id="fpayroll_time_logsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="payroll_time_log">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payroll_time_log_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payroll_time_log_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="payroll_time_log" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->employee_id->Visible) { // employee_id ?>
    <div id="r_employee_id" class="row"<?= $Page->employee_id->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_payroll_time_log_employee_id"><?= $Page->employee_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_employee_id" id="z_employee_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->employee_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payroll_time_log_employee_id" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->employee_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_employee_id" class="ew-auto-suggest">
    <input type="<?= $Page->employee_id->getInputTextType() ?>" class="form-control" name="sv_x_employee_id" id="sv_x_employee_id" value="<?= RemoveHtml($Page->employee_id->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->employee_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->employee_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->employee_id->formatPattern()) ?>"<?= $Page->employee_id->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="payroll_time_log" data-field="x_employee_id" data-input="sv_x_employee_id" data-value-separator="<?= $Page->employee_id->displayValueSeparatorAttribute() ?>" name="x_employee_id" id="x_employee_id" value="<?= HtmlEncode($Page->employee_id->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->employee_id->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fpayroll_time_logsearch", function() {
    fpayroll_time_logsearch.createAutoSuggest(Object.assign({"id":"x_employee_id","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->employee_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.payroll_time_log.fields.employee_id.autoSuggestOptions));
});
</script>
<?= $Page->employee_id->Lookup->getParamTag($Page, "p_x_employee_id") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
    <div id="r_dated" class="row"<?= $Page->dated->rowAttributes() ?>>
        <label for="x_dated" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payroll_time_log_dated"><?= $Page->dated->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->dated->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_dated" id="z_dated" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->dated->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->dated->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_payroll_time_log_dated" class="ew-search-field">
<input type="<?= $Page->dated->getInputTextType() ?>" name="x_dated" id="x_dated" data-table="payroll_time_log" data-field="x_dated" value="<?= $Page->dated->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_payroll_time_log_dated" class="ew-search-field2 d-none">
<input type="<?= $Page->dated->getInputTextType() ?>" name="y_dated" id="y_dated" data-table="payroll_time_log" data-field="x_dated" value="<?= $Page->dated->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->in_time->Visible) { // in_time ?>
    <div id="r_in_time" class="row"<?= $Page->in_time->rowAttributes() ?>>
        <label for="x_in_time" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payroll_time_log_in_time"><?= $Page->in_time->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_in_time" id="z_in_time" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->in_time->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payroll_time_log_in_time" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->in_time->getInputTextType() ?>" name="x_in_time" id="x_in_time" data-table="payroll_time_log" data-field="x_in_time" value="<?= $Page->in_time->EditValue ?>" placeholder="<?= HtmlEncode($Page->in_time->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->in_time->formatPattern()) ?>"<?= $Page->in_time->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->in_time->getErrorMessage(false) ?></div>
<?php if (!$Page->in_time->ReadOnly && !$Page->in_time->Disabled && !isset($Page->in_time->EditAttrs["readonly"]) && !isset($Page->in_time->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpayroll_time_logsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(117) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpayroll_time_logsearch", "x_in_time", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->out_time->Visible) { // out_time ?>
    <div id="r_out_time" class="row"<?= $Page->out_time->rowAttributes() ?>>
        <label for="x_out_time" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payroll_time_log_out_time"><?= $Page->out_time->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_out_time" id="z_out_time" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->out_time->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payroll_time_log_out_time" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->out_time->getInputTextType() ?>" name="x_out_time" id="x_out_time" data-table="payroll_time_log" data-field="x_out_time" value="<?= $Page->out_time->EditValue ?>" placeholder="<?= HtmlEncode($Page->out_time->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->out_time->formatPattern()) ?>"<?= $Page->out_time->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->out_time->getErrorMessage(false) ?></div>
<?php if (!$Page->out_time->ReadOnly && !$Page->out_time->Disabled && !isset($Page->out_time->EditAttrs["readonly"]) && !isset($Page->out_time->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpayroll_time_logsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpayroll_time_logsearch", "x_out_time", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->minutes->Visible) { // minutes ?>
    <div id="r_minutes" class="row"<?= $Page->minutes->rowAttributes() ?>>
        <label for="x_minutes" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payroll_time_log_minutes"><?= $Page->minutes->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_minutes" id="z_minutes" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->minutes->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payroll_time_log_minutes" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->minutes->getInputTextType() ?>" name="x_minutes" id="x_minutes" data-table="payroll_time_log" data-field="x_minutes" value="<?= $Page->minutes->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->minutes->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->minutes->formatPattern()) ?>"<?= $Page->minutes->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->minutes->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->late_arrival->Visible) { // late_arrival ?>
    <div id="r_late_arrival" class="row"<?= $Page->late_arrival->rowAttributes() ?>>
        <label for="x_late_arrival" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payroll_time_log_late_arrival"><?= $Page->late_arrival->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_late_arrival" id="z_late_arrival" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->late_arrival->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payroll_time_log_late_arrival" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->late_arrival->getInputTextType() ?>" name="x_late_arrival" id="x_late_arrival" data-table="payroll_time_log" data-field="x_late_arrival" value="<?= $Page->late_arrival->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->late_arrival->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->late_arrival->formatPattern()) ?>"<?= $Page->late_arrival->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->late_arrival->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->early_departure->Visible) { // early_departure ?>
    <div id="r_early_departure" class="row"<?= $Page->early_departure->rowAttributes() ?>>
        <label for="x_early_departure" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payroll_time_log_early_departure"><?= $Page->early_departure->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_early_departure" id="z_early_departure" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->early_departure->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payroll_time_log_early_departure" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->early_departure->getInputTextType() ?>" name="x_early_departure" id="x_early_departure" data-table="payroll_time_log" data-field="x_early_departure" value="<?= $Page->early_departure->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->early_departure->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->early_departure->formatPattern()) ?>"<?= $Page->early_departure->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->early_departure->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->overtime->Visible) { // overtime ?>
    <div id="r_overtime" class="row"<?= $Page->overtime->rowAttributes() ?>>
        <label for="x_overtime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payroll_time_log_overtime"><?= $Page->overtime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_overtime" id="z_overtime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->overtime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payroll_time_log_overtime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->overtime->getInputTextType() ?>" name="x_overtime" id="x_overtime" data-table="payroll_time_log" data-field="x_overtime" value="<?= $Page->overtime->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->overtime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->overtime->formatPattern()) ?>"<?= $Page->overtime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->overtime->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->breakduration->Visible) { // break duration ?>
    <div id="r_breakduration" class="row"<?= $Page->breakduration->rowAttributes() ?>>
        <label for="x_breakduration" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payroll_time_log_breakduration"><?= $Page->breakduration->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_breakduration" id="z_breakduration" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->breakduration->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payroll_time_log_breakduration" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->breakduration->getInputTextType() ?>" name="x_breakduration" id="x_breakduration" data-table="payroll_time_log" data-field="x_breakduration" value="<?= $Page->breakduration->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->breakduration->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->breakduration->formatPattern()) ?>"<?= $Page->breakduration->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->breakduration->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->employee_am_id->Visible) { // employee_am_id ?>
    <div id="r_employee_am_id" class="row"<?= $Page->employee_am_id->rowAttributes() ?>>
        <label for="x_employee_am_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payroll_time_log_employee_am_id"><?= $Page->employee_am_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_employee_am_id" id="z_employee_am_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->employee_am_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payroll_time_log_employee_am_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->employee_am_id->getInputTextType() ?>" name="x_employee_am_id" id="x_employee_am_id" data-table="payroll_time_log" data-field="x_employee_am_id" value="<?= $Page->employee_am_id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->employee_am_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->employee_am_id->formatPattern()) ?>"<?= $Page->employee_am_id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->employee_am_id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->offset_consumed->Visible) { // offset_consumed ?>
    <div id="r_offset_consumed" class="row"<?= $Page->offset_consumed->rowAttributes() ?>>
        <label for="x_offset_consumed" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payroll_time_log_offset_consumed"><?= $Page->offset_consumed->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_offset_consumed" id="z_offset_consumed" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->offset_consumed->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payroll_time_log_offset_consumed" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->offset_consumed->getInputTextType() ?>" name="x_offset_consumed" id="x_offset_consumed" data-table="payroll_time_log" data-field="x_offset_consumed" value="<?= $Page->offset_consumed->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->offset_consumed->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->offset_consumed->formatPattern()) ?>"<?= $Page->offset_consumed->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->offset_consumed->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->c_offset->Visible) { // c_offset ?>
    <div id="r_c_offset" class="row"<?= $Page->c_offset->rowAttributes() ?>>
        <label for="x_c_offset" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payroll_time_log_c_offset"><?= $Page->c_offset->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_c_offset" id="z_c_offset" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->c_offset->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payroll_time_log_c_offset" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->c_offset->getInputTextType() ?>" name="x_c_offset" id="x_c_offset" data-table="payroll_time_log" data-field="x_c_offset" value="<?= $Page->c_offset->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->c_offset->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->c_offset->formatPattern()) ?>"<?= $Page->c_offset->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->c_offset->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payroll_time_log_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payroll_time_log_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="payroll_time_log" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payroll_time_log_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payroll_time_log_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="payroll_time_log" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpayroll_time_logsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpayroll_time_logsearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fpayroll_time_logsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpayroll_time_logsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fpayroll_time_logsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("payroll_time_log");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
