<?php

namespace PHPMaker2024\fibre;

// Page object
$PayrollTimeLogSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { payroll_time_log: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fpayroll_time_logsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpayroll_time_logsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["employee_id", [ew.Validators.integer], fields.employee_id.isInvalid],
            ["dated", [ew.Validators.integer], fields.dated.isInvalid],
            ["y_dated", [ew.Validators.between], false],
            ["in_time", [ew.Validators.datetime(fields.in_time.clientFormatPattern)], fields.in_time.isInvalid],
            ["out_time", [ew.Validators.datetime(fields.out_time.clientFormatPattern)], fields.out_time.isInvalid],
            ["minutes", [ew.Validators.integer], fields.minutes.isInvalid],
            ["late_arrival", [ew.Validators.integer], fields.late_arrival.isInvalid],
            ["early_departure", [ew.Validators.integer], fields.early_departure.isInvalid],
            ["overtime", [ew.Validators.integer], fields.overtime.isInvalid],
            ["breakduration", [ew.Validators.integer], fields.breakduration.isInvalid],
            ["employee_am_id", [ew.Validators.integer], fields.employee_am_id.isInvalid],
            ["offset_consumed", [ew.Validators.integer], fields.offset_consumed.isInvalid],
            ["c_offset", [ew.Validators.integer], fields.c_offset.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setQueryBuilderLists({
            "employee_id": <?= $Page->employee_id->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fpayroll_time_logsearch" id="fpayroll_time_logsearch" class="<?= $Page->FormClassName ?>" action="<?= HtmlEncode(GetUrl("payrolltimeloglist")) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="payroll_time_log">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<input type="hidden" name="rules" value="<?= HtmlEncode($Page->getSessionRules()) ?>">
<template id="tpx_payroll_time_log_id" class="payroll_time_logsearch"><span id="el_payroll_time_log_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="payroll_time_log" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_payroll_time_log_employee_id" class="payroll_time_logsearch"><span id="el_payroll_time_log_employee_id" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->employee_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_employee_id" class="ew-auto-suggest">
    <input type="<?= $Page->employee_id->getInputTextType() ?>" class="form-control" name="sv_x_employee_id" id="sv_x_employee_id" value="<?= RemoveHtml($Page->employee_id->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->employee_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->employee_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->employee_id->formatPattern()) ?>"<?= $Page->employee_id->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="payroll_time_log" data-field="x_employee_id" data-input="sv_x_employee_id" data-value-separator="<?= $Page->employee_id->displayValueSeparatorAttribute() ?>" name="x_employee_id" id="x_employee_id" value="<?= HtmlEncode($Page->employee_id->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->employee_id->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fpayroll_time_logsearch", function() {
    fpayroll_time_logsearch.createAutoSuggest(Object.assign({"id":"x_employee_id","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->employee_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.payroll_time_log.fields.employee_id.autoSuggestOptions));
});
</script>
<?= $Page->employee_id->Lookup->getParamTag($Page, "p_x_employee_id") ?>
</span></template>
<template id="tpx_payroll_time_log_dated" class="payroll_time_logsearch"><span id="el_payroll_time_log_dated" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->dated->getInputTextType() ?>" name="x_dated" id="x_dated" data-table="payroll_time_log" data-field="x_dated" value="<?= $Page->dated->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_payroll_time_log_in_time" class="payroll_time_logsearch"><span id="el_payroll_time_log_in_time" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->in_time->getInputTextType() ?>" name="x_in_time" id="x_in_time" data-table="payroll_time_log" data-field="x_in_time" value="<?= $Page->in_time->EditValue ?>" placeholder="<?= HtmlEncode($Page->in_time->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->in_time->formatPattern()) ?>"<?= $Page->in_time->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->in_time->getErrorMessage(false) ?></div>
<?php if (!$Page->in_time->ReadOnly && !$Page->in_time->Disabled && !isset($Page->in_time->EditAttrs["readonly"]) && !isset($Page->in_time->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpayroll_time_logsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(117) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpayroll_time_logsearch", "x_in_time", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_payroll_time_log_out_time" class="payroll_time_logsearch"><span id="el_payroll_time_log_out_time" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->out_time->getInputTextType() ?>" name="x_out_time" id="x_out_time" data-table="payroll_time_log" data-field="x_out_time" value="<?= $Page->out_time->EditValue ?>" placeholder="<?= HtmlEncode($Page->out_time->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->out_time->formatPattern()) ?>"<?= $Page->out_time->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->out_time->getErrorMessage(false) ?></div>
<?php if (!$Page->out_time->ReadOnly && !$Page->out_time->Disabled && !isset($Page->out_time->EditAttrs["readonly"]) && !isset($Page->out_time->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpayroll_time_logsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpayroll_time_logsearch", "x_out_time", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_payroll_time_log_minutes" class="payroll_time_logsearch"><span id="el_payroll_time_log_minutes" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->minutes->getInputTextType() ?>" name="x_minutes" id="x_minutes" data-table="payroll_time_log" data-field="x_minutes" value="<?= $Page->minutes->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->minutes->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->minutes->formatPattern()) ?>"<?= $Page->minutes->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->minutes->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_payroll_time_log_late_arrival" class="payroll_time_logsearch"><span id="el_payroll_time_log_late_arrival" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->late_arrival->getInputTextType() ?>" name="x_late_arrival" id="x_late_arrival" data-table="payroll_time_log" data-field="x_late_arrival" value="<?= $Page->late_arrival->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->late_arrival->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->late_arrival->formatPattern()) ?>"<?= $Page->late_arrival->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->late_arrival->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_payroll_time_log_early_departure" class="payroll_time_logsearch"><span id="el_payroll_time_log_early_departure" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->early_departure->getInputTextType() ?>" name="x_early_departure" id="x_early_departure" data-table="payroll_time_log" data-field="x_early_departure" value="<?= $Page->early_departure->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->early_departure->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->early_departure->formatPattern()) ?>"<?= $Page->early_departure->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->early_departure->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_payroll_time_log_overtime" class="payroll_time_logsearch"><span id="el_payroll_time_log_overtime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->overtime->getInputTextType() ?>" name="x_overtime" id="x_overtime" data-table="payroll_time_log" data-field="x_overtime" value="<?= $Page->overtime->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->overtime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->overtime->formatPattern()) ?>"<?= $Page->overtime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->overtime->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_payroll_time_log_breakduration" class="payroll_time_logsearch"><span id="el_payroll_time_log_breakduration" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->breakduration->getInputTextType() ?>" name="x_breakduration" id="x_breakduration" data-table="payroll_time_log" data-field="x_breakduration" value="<?= $Page->breakduration->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->breakduration->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->breakduration->formatPattern()) ?>"<?= $Page->breakduration->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->breakduration->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_payroll_time_log_employee_am_id" class="payroll_time_logsearch"><span id="el_payroll_time_log_employee_am_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->employee_am_id->getInputTextType() ?>" name="x_employee_am_id" id="x_employee_am_id" data-table="payroll_time_log" data-field="x_employee_am_id" value="<?= $Page->employee_am_id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->employee_am_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->employee_am_id->formatPattern()) ?>"<?= $Page->employee_am_id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->employee_am_id->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_payroll_time_log_offset_consumed" class="payroll_time_logsearch"><span id="el_payroll_time_log_offset_consumed" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->offset_consumed->getInputTextType() ?>" name="x_offset_consumed" id="x_offset_consumed" data-table="payroll_time_log" data-field="x_offset_consumed" value="<?= $Page->offset_consumed->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->offset_consumed->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->offset_consumed->formatPattern()) ?>"<?= $Page->offset_consumed->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->offset_consumed->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_payroll_time_log_c_offset" class="payroll_time_logsearch"><span id="el_payroll_time_log_c_offset" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->c_offset->getInputTextType() ?>" name="x_c_offset" id="x_c_offset" data-table="payroll_time_log" data-field="x_c_offset" value="<?= $Page->c_offset->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->c_offset->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->c_offset->formatPattern()) ?>"<?= $Page->c_offset->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->c_offset->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_payroll_time_log_operator" class="payroll_time_logsearch"><span id="el_payroll_time_log_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="payroll_time_log" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_payroll_time_log_datetime" class="payroll_time_logsearch"><span id="el_payroll_time_log_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="payroll_time_log" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpayroll_time_logsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpayroll_time_logsearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span></template>
<div id="payroll_time_log_query_builder" class="query-builder mb-3"></div>
<div class="btn-group mb-3 query-btn-group"></div>
<button type="button" id="btn-view-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("View", true)) ?>"><i class="fa-solid fa-eye ew-icon"></i></button>
<button type="button" id="btn-clear-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("Clear", true)) ?>"><i class="fa-solid fa-xmark ew-icon"></i></button>
<script>
// Filter builder
loadjs.ready(["wrapper", "head"], () => {
    let filters = [
            {
                id: "id",
                type: "integer",
                label: currentTable.fields.id.caption,
                operators: currentTable.fields.id.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fpayroll_time_logsearch.fields.id.validators),
                data: {
                    format: currentTable.fields.id.clientFormatPattern
                }
            },
            {
                id: "employee_id",
                type: "integer",
                label: currentTable.fields.employee_id.caption,
                operators: currentTable.fields.employee_id.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fpayroll_time_logsearch.fields.employee_id.validators),
                data: {
                    format: currentTable.fields.employee_id.clientFormatPattern
                }
            },
            {
                id: "dated",
                type: "datetime",
                label: currentTable.fields.dated.caption,
                operators: currentTable.fields.dated.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpayroll_time_logsearch.fields.dated.validators),
                data: {
                    format: currentTable.fields.dated.clientFormatPattern
                }
            },
            {
                id: "in_time",
                type: "datetime",
                label: currentTable.fields.in_time.caption,
                operators: currentTable.fields.in_time.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpayroll_time_logsearch.fields.in_time.validators),
                data: {
                    format: currentTable.fields.in_time.clientFormatPattern
                }
            },
            {
                id: "out_time",
                type: "datetime",
                label: currentTable.fields.out_time.caption,
                operators: currentTable.fields.out_time.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpayroll_time_logsearch.fields.out_time.validators),
                data: {
                    format: currentTable.fields.out_time.clientFormatPattern
                }
            },
            {
                id: "minutes",
                type: "integer",
                label: currentTable.fields.minutes.caption,
                operators: currentTable.fields.minutes.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpayroll_time_logsearch.fields.minutes.validators),
                data: {
                    format: currentTable.fields.minutes.clientFormatPattern
                }
            },
            {
                id: "late_arrival",
                type: "integer",
                label: currentTable.fields.late_arrival.caption,
                operators: currentTable.fields.late_arrival.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpayroll_time_logsearch.fields.late_arrival.validators),
                data: {
                    format: currentTable.fields.late_arrival.clientFormatPattern
                }
            },
            {
                id: "early_departure",
                type: "integer",
                label: currentTable.fields.early_departure.caption,
                operators: currentTable.fields.early_departure.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpayroll_time_logsearch.fields.early_departure.validators),
                data: {
                    format: currentTable.fields.early_departure.clientFormatPattern
                }
            },
            {
                id: "overtime",
                type: "integer",
                label: currentTable.fields.overtime.caption,
                operators: currentTable.fields.overtime.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpayroll_time_logsearch.fields.overtime.validators),
                data: {
                    format: currentTable.fields.overtime.clientFormatPattern
                }
            },
            {
                id: "breakduration",
                type: "integer",
                label: currentTable.fields.breakduration.caption,
                operators: currentTable.fields.breakduration.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpayroll_time_logsearch.fields.breakduration.validators),
                data: {
                    format: currentTable.fields.breakduration.clientFormatPattern
                }
            },
            {
                id: "employee_am_id",
                type: "integer",
                label: currentTable.fields.employee_am_id.caption,
                operators: currentTable.fields.employee_am_id.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpayroll_time_logsearch.fields.employee_am_id.validators),
                data: {
                    format: currentTable.fields.employee_am_id.clientFormatPattern
                }
            },
            {
                id: "offset_consumed",
                type: "integer",
                label: currentTable.fields.offset_consumed.caption,
                operators: currentTable.fields.offset_consumed.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpayroll_time_logsearch.fields.offset_consumed.validators),
                data: {
                    format: currentTable.fields.offset_consumed.clientFormatPattern
                }
            },
            {
                id: "c_offset",
                type: "integer",
                label: currentTable.fields.c_offset.caption,
                operators: currentTable.fields.c_offset.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpayroll_time_logsearch.fields.c_offset.validators),
                data: {
                    format: currentTable.fields.c_offset.clientFormatPattern
                }
            },
            {
                id: "operator",
                type: "integer",
                label: currentTable.fields.operator.caption,
                operators: currentTable.fields.operator.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpayroll_time_logsearch.fields.operator.validators),
                data: {
                    format: currentTable.fields.operator.clientFormatPattern
                }
            },
            {
                id: "datetime",
                type: "datetime",
                label: currentTable.fields.datetime.caption,
                operators: currentTable.fields.datetime.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpayroll_time_logsearch.fields.datetime.validators),
                data: {
                    format: currentTable.fields.datetime.clientFormatPattern
                }
            },
        ],
        $ = jQuery,
        $qb = $("#payroll_time_log_query_builder"),
        args = {},
        rules = ew.parseJson($("#fpayroll_time_logsearch input[name=rules]").val()),
        queryBuilderOptions = Object.assign({}, ew.queryBuilderOptions),
        allowViewRules = queryBuilderOptions.allowViewRules,
        allowClearRules = queryBuilderOptions.allowClearRules,
        hasRules = group => Array.isArray(group?.rules) && group.rules.length > 0,
        getRules = () => $qb.queryBuilder("getRules", { skip_empty: true }),
        getSql = () => $qb.queryBuilder("getSQL", false, false, rules)?.sql;
    delete queryBuilderOptions.allowViewRules;
    delete queryBuilderOptions.allowClearRules;
    args.options = ew.deepAssign({
        plugins: Object.assign({}, ew.queryBuilderPlugins),
        lang: ew.language.phrase("querybuilderjs"),
        select_placeholder: ew.language.phrase("PleaseSelect"),
        inputs_separator: `<div class="d-inline-flex ms-2 me-2">${ew.language.phrase("AND")}</div>`, // For "between"
        filters,
        rules
    }, queryBuilderOptions);
    $qb.trigger("querybuilder", [args]);
    $qb.queryBuilder(args.options).on("rulesChanged.queryBuilder", () => {
        let rules = getRules();
        !ew.DEBUG || console.log(rules, getSql());
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").toggleClass("disabled", !rules);
    }).on("afterCreateRuleInput.queryBuilder", function(e, rule) {
        let select = rule.$el.find(".rule-value-container").find("selection-list, select")[0];
        if (select) { // Selection list
            let id = select.dataset.field.replace("^x_", ""),
                form = ew.forms.get(select);
            form.updateList(select, undefined, undefined, true); // Update immediately
        }
    });
    $("#fpayroll_time_logsearch").on("beforesubmit", function () {
        this.rules.value = JSON.stringify(getRules());
    });
    $("#btn-reset").toggleClass("d-none", false).on("click", () => {
        hasRules(rules) ? $qb.queryBuilder("setRules", rules) : $qb.queryBuilder("reset");
        return false;
    });
    $("#btn-action").toggleClass("d-none", false);
    if (allowClearRules) {
        $("#btn-clear-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => $qb.queryBuilder("reset"));
    }
    if (allowViewRules) {
        $("#btn-view-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => {
            let rules = getRules();
            if (hasRules(rules)) {
                let sql = getSql();
                ew.alert(sql ? '<pre class="text-start fs-6">' + sql + '</pre>' : '', "dark");
                !ew.DEBUG || console.log(rules, sql);
            } else {
                ew.alert(ew.language.phrase("EmptyLabel"));
            }
        });
    }
    $(".query-btn-group").toggleClass(".mb-3", $(".query-btn-group").find(".btn:not(.d-none)").length);
    if (hasRules(rules)) { // Enable buttons if rules exist initially
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").removeClass("disabled");
    }
});
</script>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn d-none disabled" name="btn-action" id="btn-action" type="submit" form="fpayroll_time_logsearch" formaction="<?= HtmlEncode(GetUrl("payrolltimeloglist")) ?>" data-ajax="<?= $Page->UseAjaxActions ? "true" : "false" ?>"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpayroll_time_logsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn d-none disabled" name="btn-reset" id="btn-reset" type="button" form="fpayroll_time_logsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("payroll_time_log");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
