<?php

namespace PHPMaker2024\fibre;

// Page object
$PayrollTimeLogList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { payroll_time_log: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fpayroll_time_logsrch" id="fpayroll_time_logsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fpayroll_time_logsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { payroll_time_log: currentTable } });
var currentForm;
var fpayroll_time_logsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpayroll_time_logsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["employee_id", [ew.Validators.integer], fields.employee_id.isInvalid],
            ["dated", [ew.Validators.integer], fields.dated.isInvalid],
            ["y_dated", [ew.Validators.between], false]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "employee_id": <?= $Page->employee_id->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->employee_id->Visible) { // employee_id ?>
<?php
if (!$Page->employee_id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_employee_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->employee_id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->employee_id->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_employee_id" id="z_employee_id" value="=">
</div>
        </div>
        <div id="el_payroll_time_log_employee_id" class="ew-search-field">
<?php
if (IsRTL()) {
    $Page->employee_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_employee_id" class="ew-auto-suggest">
    <input type="<?= $Page->employee_id->getInputTextType() ?>" class="form-control" name="sv_x_employee_id" id="sv_x_employee_id" value="<?= RemoveHtml($Page->employee_id->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->employee_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->employee_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->employee_id->formatPattern()) ?>"<?= $Page->employee_id->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="payroll_time_log" data-field="x_employee_id" data-input="sv_x_employee_id" data-value-separator="<?= $Page->employee_id->displayValueSeparatorAttribute() ?>" name="x_employee_id" id="x_employee_id" value="<?= HtmlEncode($Page->employee_id->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->employee_id->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fpayroll_time_logsrch", function() {
    fpayroll_time_logsrch.createAutoSuggest(Object.assign({"id":"x_employee_id","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->employee_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.payroll_time_log.fields.employee_id.autoSuggestOptions));
});
</script>
<?= $Page->employee_id->Lookup->getParamTag($Page, "p_x_employee_id") ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
<?php
if (!$Page->dated->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_dated" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->dated->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_dated" class="ew-search-caption ew-label"><?= $Page->dated->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_dated" id="z_dated" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->dated->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->dated->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_payroll_time_log_dated" class="ew-search-field">
<input type="<?= $Page->dated->getInputTextType() ?>" name="x_dated" id="x_dated" data-table="payroll_time_log" data-field="x_dated" value="<?= $Page->dated->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_payroll_time_log_dated" class="ew-search-field2 d-none">
<input type="<?= $Page->dated->getInputTextType() ?>" name="y_dated" id="y_dated" data-table="payroll_time_log" data-field="x_dated" value="<?= $Page->dated->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage(false) ?></div>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="payroll_time_log">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_payroll_time_log" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_payroll_time_loglist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_payroll_time_log_id" class="payroll_time_log_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->employee_id->Visible) { // employee_id ?>
        <th data-name="employee_id" class="<?= $Page->employee_id->headerCellClass() ?>"><div id="elh_payroll_time_log_employee_id" class="payroll_time_log_employee_id"><?= $Page->renderFieldHeader($Page->employee_id) ?></div></th>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
        <th data-name="dated" class="<?= $Page->dated->headerCellClass() ?>"><div id="elh_payroll_time_log_dated" class="payroll_time_log_dated"><?= $Page->renderFieldHeader($Page->dated) ?></div></th>
<?php } ?>
<?php if ($Page->in_time->Visible) { // in_time ?>
        <th data-name="in_time" class="<?= $Page->in_time->headerCellClass() ?>"><div id="elh_payroll_time_log_in_time" class="payroll_time_log_in_time"><?= $Page->renderFieldHeader($Page->in_time) ?></div></th>
<?php } ?>
<?php if ($Page->out_time->Visible) { // out_time ?>
        <th data-name="out_time" class="<?= $Page->out_time->headerCellClass() ?>"><div id="elh_payroll_time_log_out_time" class="payroll_time_log_out_time"><?= $Page->renderFieldHeader($Page->out_time) ?></div></th>
<?php } ?>
<?php if ($Page->minutes->Visible) { // minutes ?>
        <th data-name="minutes" class="<?= $Page->minutes->headerCellClass() ?>"><div id="elh_payroll_time_log_minutes" class="payroll_time_log_minutes"><?= $Page->renderFieldHeader($Page->minutes) ?></div></th>
<?php } ?>
<?php if ($Page->late_arrival->Visible) { // late_arrival ?>
        <th data-name="late_arrival" class="<?= $Page->late_arrival->headerCellClass() ?>"><div id="elh_payroll_time_log_late_arrival" class="payroll_time_log_late_arrival"><?= $Page->renderFieldHeader($Page->late_arrival) ?></div></th>
<?php } ?>
<?php if ($Page->early_departure->Visible) { // early_departure ?>
        <th data-name="early_departure" class="<?= $Page->early_departure->headerCellClass() ?>"><div id="elh_payroll_time_log_early_departure" class="payroll_time_log_early_departure"><?= $Page->renderFieldHeader($Page->early_departure) ?></div></th>
<?php } ?>
<?php if ($Page->overtime->Visible) { // overtime ?>
        <th data-name="overtime" class="<?= $Page->overtime->headerCellClass() ?>"><div id="elh_payroll_time_log_overtime" class="payroll_time_log_overtime"><?= $Page->renderFieldHeader($Page->overtime) ?></div></th>
<?php } ?>
<?php if ($Page->breakduration->Visible) { // break duration ?>
        <th data-name="breakduration" class="<?= $Page->breakduration->headerCellClass() ?>"><div id="elh_payroll_time_log_breakduration" class="payroll_time_log_breakduration"><?= $Page->renderFieldHeader($Page->breakduration) ?></div></th>
<?php } ?>
<?php if ($Page->employee_am_id->Visible) { // employee_am_id ?>
        <th data-name="employee_am_id" class="<?= $Page->employee_am_id->headerCellClass() ?>"><div id="elh_payroll_time_log_employee_am_id" class="payroll_time_log_employee_am_id"><?= $Page->renderFieldHeader($Page->employee_am_id) ?></div></th>
<?php } ?>
<?php if ($Page->offset_consumed->Visible) { // offset_consumed ?>
        <th data-name="offset_consumed" class="<?= $Page->offset_consumed->headerCellClass() ?>"><div id="elh_payroll_time_log_offset_consumed" class="payroll_time_log_offset_consumed"><?= $Page->renderFieldHeader($Page->offset_consumed) ?></div></th>
<?php } ?>
<?php if ($Page->c_offset->Visible) { // c_offset ?>
        <th data-name="c_offset" class="<?= $Page->c_offset->headerCellClass() ?>"><div id="elh_payroll_time_log_c_offset" class="payroll_time_log_c_offset"><?= $Page->renderFieldHeader($Page->c_offset) ?></div></th>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Page->operator->headerCellClass() ?>"><div id="elh_payroll_time_log_operator" class="payroll_time_log_operator"><?= $Page->renderFieldHeader($Page->operator) ?></div></th>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Page->datetime->headerCellClass() ?>"><div id="elh_payroll_time_log_datetime" class="payroll_time_log_datetime"><?= $Page->renderFieldHeader($Page->datetime) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payroll_time_log_id" class="el_payroll_time_log_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->employee_id->Visible) { // employee_id ?>
        <td data-name="employee_id"<?= $Page->employee_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payroll_time_log_employee_id" class="el_payroll_time_log_employee_id">
<span<?= $Page->employee_id->viewAttributes() ?>>
<?= $Page->employee_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->dated->Visible) { // dated ?>
        <td data-name="dated"<?= $Page->dated->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payroll_time_log_dated" class="el_payroll_time_log_dated">
<span<?= $Page->dated->viewAttributes() ?>>
<?= $Page->dated->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->in_time->Visible) { // in_time ?>
        <td data-name="in_time"<?= $Page->in_time->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payroll_time_log_in_time" class="el_payroll_time_log_in_time">
<span<?= $Page->in_time->viewAttributes() ?>>
<?= $Page->in_time->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->out_time->Visible) { // out_time ?>
        <td data-name="out_time"<?= $Page->out_time->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payroll_time_log_out_time" class="el_payroll_time_log_out_time">
<span<?= $Page->out_time->viewAttributes() ?>>
<?= $Page->out_time->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->minutes->Visible) { // minutes ?>
        <td data-name="minutes"<?= $Page->minutes->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payroll_time_log_minutes" class="el_payroll_time_log_minutes">
<span<?= $Page->minutes->viewAttributes() ?>>
<?= $Page->minutes->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->late_arrival->Visible) { // late_arrival ?>
        <td data-name="late_arrival"<?= $Page->late_arrival->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payroll_time_log_late_arrival" class="el_payroll_time_log_late_arrival">
<span<?= $Page->late_arrival->viewAttributes() ?>>
<?= $Page->late_arrival->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->early_departure->Visible) { // early_departure ?>
        <td data-name="early_departure"<?= $Page->early_departure->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payroll_time_log_early_departure" class="el_payroll_time_log_early_departure">
<span<?= $Page->early_departure->viewAttributes() ?>>
<?= $Page->early_departure->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->overtime->Visible) { // overtime ?>
        <td data-name="overtime"<?= $Page->overtime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payroll_time_log_overtime" class="el_payroll_time_log_overtime">
<span<?= $Page->overtime->viewAttributes() ?>>
<?= $Page->overtime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->breakduration->Visible) { // break duration ?>
        <td data-name="breakduration"<?= $Page->breakduration->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payroll_time_log_breakduration" class="el_payroll_time_log_breakduration">
<span<?= $Page->breakduration->viewAttributes() ?>>
<?= $Page->breakduration->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->employee_am_id->Visible) { // employee_am_id ?>
        <td data-name="employee_am_id"<?= $Page->employee_am_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payroll_time_log_employee_am_id" class="el_payroll_time_log_employee_am_id">
<span<?= $Page->employee_am_id->viewAttributes() ?>>
<?= $Page->employee_am_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->offset_consumed->Visible) { // offset_consumed ?>
        <td data-name="offset_consumed"<?= $Page->offset_consumed->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payroll_time_log_offset_consumed" class="el_payroll_time_log_offset_consumed">
<span<?= $Page->offset_consumed->viewAttributes() ?>>
<?= $Page->offset_consumed->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->c_offset->Visible) { // c_offset ?>
        <td data-name="c_offset"<?= $Page->c_offset->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payroll_time_log_c_offset" class="el_payroll_time_log_c_offset">
<span<?= $Page->c_offset->viewAttributes() ?>>
<?= $Page->c_offset->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payroll_time_log_operator" class="el_payroll_time_log_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payroll_time_log_datetime" class="el_payroll_time_log_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("payroll_time_log");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
